DROP TABLE IF EXISTS `dircms_yp`;
CREATE TABLE `dircms_yp` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `domain` varchar(200) NOT NULL,
  `url` varchar(200) NOT NULL,
  `dir` varchar(30) NOT NULL,
  `areaid` smallint(6) NOT NULL,
  `typeid` mediumint(8) NOT NULL,
  `name` varchar(100) NOT NULL,
  `seo` mediumint(8) NOT NULL DEFAULT '0',
  `logo` varchar(100) NOT NULL,
  `banner` varchar(100) NOT NULL,
  `meta_title` varchar(255) NOT NULL,
  `meta_keywords` varchar(100) NOT NULL,
  `meta_description` varchar(255) NOT NULL,
  `address` text NOT NULL,
  `about` mediumtext NOT NULL,
  `busroute` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `fax` varchar(30) NOT NULL,
  `openingtime` varchar(40) NOT NULL,
  `shenfenzheng` varchar(200) NOT NULL,
  `zhizhao` varchar(200) NOT NULL,
  `qq` varchar(20) NOT NULL,
  `pics` text NOT NULL,
  `memberid` mediumint(8) NOT NULL,
  `template` varchar(20) NOT NULL DEFAULT 'default',
  `opentime` varchar(10) NOT NULL,
  `map` varchar(20) NOT NULL,
  `score` smallint(4) NOT NULL DEFAULT '60',
  `menu` text NOT NULL,
  `istop` tinyint(1) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `businesslicense` tinyint(1) NOT NULL DEFAULT '0',
  `identitycard` tinyint(1) NOT NULL DEFAULT '0',
  `visits` mediumint(8) NOT NULL DEFAULT '0',
  `siteid` smallint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`status`),
  UNIQUE KEY `memberid` (`memberid`,`status`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `dircms_yp_news`;
CREATE TABLE `dircms_yp_news` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `typeid` mediumint(8) NOT NULL,
  `areaid` smallint(6) NOT NULL,
  `ypid` mediumint(8) NOT NULL,
  `ypname` varchar(100) NOT NULL,
  `ypurl` varchar(200) NOT NULL,
  `title` varchar(100) NOT NULL,
  `keywords` varchar(100) NOT NULL,
  `description` varchar(255) NOT NULL,
  `copyfrom` varchar(80) NOT NULL,
  `author` varchar(80) NOT NULL,
  `content` text NOT NULL,
  `inputtime` char(10) NOT NULL,
  `clicks` mediumint(8) NOT NULL DEFAULT '0',
  `siteid` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `memberid` (`ypid`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `dircms_yp_expert`;
CREATE TABLE `dircms_yp_expert` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `typeid` mediumint(8) NOT NULL,
  `areaid` smallint(6) NOT NULL,
  `ypid` mediumint(8) NOT NULL,
  `ypname` varchar(100) NOT NULL,
  `ypurl` varchar(200) NOT NULL,
  `title` varchar(100) NOT NULL,
  `country` varchar(80) NOT NULL,
  `keywords` varchar(100) NOT NULL,
  `description` varchar(255) NOT NULL,
  `thumb` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `inputtime` char(10) NOT NULL,
  `clicks` mediumint(8) NOT NULL DEFAULT '0',
  `siteid` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `memberid` (`ypid`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `dircms_yp_discount`;
CREATE TABLE `dircms_yp_discount` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `typeid` mediumint(8) NOT NULL,
  `areaid` smallint(6) NOT NULL,
  `ypid` mediumint(8) NOT NULL,
  `ypname` varchar(100) NOT NULL,
  `ypurl` varchar(200) NOT NULL,
  `title` varchar(100) NOT NULL,
  `price` varchar(10) NOT NULL,
  `discountprice` varchar(10) NOT NULL,
  `start` char(10) NOT NULL,
  `end` char(10) NOT NULL,
  `thumb` varchar(200) NOT NULL,
  `keywords` varchar(100) NOT NULL,
  `description` varchar(255) NOT NULL,
  `copyfrom` varchar(80) NOT NULL,
  `content` text NOT NULL,
  `inputtime` char(10) NOT NULL,
  `clicks` mediumint(8) NOT NULL DEFAULT '0',
  `siteid` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `memberid` (`ypid`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `dircms_yp_product`;
CREATE TABLE `dircms_yp_product` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `typeid` mediumint(8) NOT NULL,
  `images` text NOT NULL,
  `areaid` smallint(6) NOT NULL,
  `ypid` mediumint(8) NOT NULL,
  `ypname` varchar(100) NOT NULL,
  `ypurl` varchar(200) NOT NULL,
  `title` varchar(100) NOT NULL,
  `keywords` varchar(100) NOT NULL,
  `description` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `thumb` varchar(100) NOT NULL DEFAULT 'images/image128x128.png',
  `clicks` mediumint(8) NOT NULL DEFAULT '0',
  `market_price` varchar(10) NOT NULL DEFAULT '0.00',
  `price` varchar(10) NOT NULL DEFAULT '0.00',
  `unit` varchar(20) NOT NULL DEFAULT '',
  `inputtime` varchar(10) NOT NULL,
  `siteid` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `memberid` (`ypid`),
  FULLTEXT KEY `thumb` (`thumb`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `dircms_yp_producttype`;
CREATE TABLE `dircms_yp_producttype` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `ypid` mediumint(8) NOT NULL,
  `name` varchar(80) NOT NULL,
  `parentid` mediumint(8) NOT NULL,
  `siteid` smallint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `dircms_yp_comment`;
CREATE TABLE `dircms_yp_comment` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `areaid` smallint(6) NOT NULL,
  `parentid` mediumint(8) unsigned NOT NULL,
  `ypid` mediumint(8) NOT NULL DEFAULT '0',
  `ypname` varchar(100) NOT NULL,
  `guestid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `guestname` varchar(20) NOT NULL,
  `guestface` varchar(100) NOT NULL,
  `service` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `condition` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `price` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '0.0.0.0',
  `addtime` varchar(10) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `siteid` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `userid` (`guestid`,`status`,`id`,`ypid`),
  KEY `status` (`status`,`ypid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `dircms_yp_page`;
CREATE TABLE `dircms_yp_page` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `typeid` mediumint(8) NOT NULL,
  `areaid` mediumint(8) NOT NULL,
  `ypname` varchar(80) NOT NULL,
  `ypurl` varchar(200) NOT NULL,
  `ypid` mediumint(8) NOT NULL,
  `name` varchar(80) NOT NULL,
  `image` varchar(100) NOT NULL,
  `contype` varchar(8) NOT NULL DEFAULT 'editor',
  `meta_title` varchar(255) NOT NULL,
  `meta_keywords` varchar(255) NOT NULL,
  `meta_description` varchar(255) NOT NULL,
  `content` mediumtext NOT NULL,
  `clicks` mediumint(8) NOT NULL DEFAULT '1',
  `siteid` smallint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
