<?php

/**
 *      【橙创家校通v4.0】 (C)2010-2012 Tuntron Inc.
 *      
 *    	 http://www.tuntron.com   QQ：1121251729
 *
 *      &讨论组基类文件&
 */

if (!defined('IS_RUN')) die('Forbidden');

class tj_topic extends tj_model {

	var $table = 'dbpre_group_topics';
    var $key = 'topicid';

	function __construct() {
		parent::__construct();
		$this->init_field();
	}

    function msm_topicouncement() {
        $this->__construct();
    }

	function init_field() {
		$this->add_field('topicid,typeid,groupid,uid,title,content,count_comment,count_view,istop,isshow,iscomment,isposts,isnotice,isask,addtime,uptime');
		$this->add_field_fun('topicid,typeid,groupid,uid,count_comment,count_view,istop,isshow,iscomment,isposts,isnotice,isask,addtime,uptime', 'intval');
        $this->add_field_fun('title,topicicon', '_T');
		$this->add_field_fun('content', '_HTML');
	}

	function read_all($type=null,$typestr='groupid',$lstart,$listnum) {
        $this->db->from($this->table);
		$this->db->order_by('istop','DESC');
		$this->db->order_by('uptime','DESC');
		if($type) $this->db->where($typestr,$type);
		$this->db->limit($lstart,$listnum);
        return $this->db->fetch_all_assoc();
    }
	
	function read_one($topicid,$new=NULL) {
        $this->db->from($this->table);
		if($new){
			$this->db->where('groupid', $topicid);
			$this->db->order_by('uptime', 'DESC');
		}else{
        $this->db->where('topicid', $topicid);
		}
        return $this->db->once_fetch_assoc();
    }
	
	
	
    function save(& $post, $topicid=NULL, $cache=TRUE) {
        $this->check_post($post);
		
        if(!$topicid) {
			global $_CO;
            $post['uid'] = $_CO['uid'];
            $post['addtime'] = $this->global['timestamp'];
			$post['uptime'] = $this->global['timestamp'];
        }
        return parent::save($post, $topicid, $cache, FALSE);
    }

    function update($post) {
        if(!is_array($post)) Note('global_op_unselect');
        foreach($post as $topicid => $val) {
            $this->db->from($this->table);
            $this->db->set($val);
			$this->db->set(array('uptime'=>$this->global['timestamp']));
            $this->db->where('topicid',$topicid);
            $this->db->update();
        }
    }
	
	function deltopic($topicid) {
		
        $this->db->where('topicid', $topicid);  
		
		$this->db->from($this->table);     

        $this->db->delete();
		
    }

    function check_post($post,$is_edit=false) {
		if(!$post['groupid']) Note('所属讨论组不能为空！');
        if(!$post['title']) Note('话题标题不能为空！');
        if(!$post['content']) Note('话题内容不能为空！');
    }
}
?>