<?php

/**
 *      【橙创家校通v4.0】 (C)2010-2012 Tuntron Inc.
 *      
 *    	 http://www.tuntron.com   QQ：1121251729
 *
 *      &图片附件基类文件&
 */

if (!defined('IS_RUN')) die('Forbidden');

class tj_image_file extends tj_model {

	var $table = 'dbpre_image_file';
    var $key = 'imageid';

	function __construct() {
		parent::__construct();
		$this->init_field();
	}

    function msm_imageouncement() {
        $this->__construct();
    }

	function init_field() {
		$this->add_field('imageid,imageurl,addtime');
		$this->add_field_fun('imageid,addtime', 'intval');
		$this->add_field_fun('imageurl', 'trim');
	}

	function read_all($type=null) {
        $this->db->from($this->table);
        if($type) {
            $this->db->where('imageid', $type);
        }
		$this->db->order_by('addtime','DESC');//必须为大写DESC或ASC
        $this->db->select('imageid,imageurl,addtime');
        return $this->db->fetch_all_assoc();
    }
	
	function read_one($imageid) {
        $this->db->from($this->table);
        $this->db->where('imageid', $imageid);
        $this->db->select('imageid,imageurl,addtime');
        return $this->db->once_fetch_assoc();
    }
	
	function get_mediaImgList($content) {
        preg_match_all('/\[图片\d{1,10}\]/',$content, $matches);
		
		$str=str_replace("[图片","",$matches[0]);
		$str_arrs=str_replace("]","",$str);
		foreach($str_arrs as $val){
			$imagearr= $this->read_one($val);
			$str_arr[$val] = SITEURL.$imagearr['imageurl'];
	 	}
		return outputJson($str_arr,true);
    }
	
	
	
    function save(& $post, $imageid=NULL, $cache=TRUE) {
        if(!$imageid) {
			$this->check_post($post);
            $post['addtime'] = $this->global['timestamp'];
        }
        return parent::save($post, $imageid, $cache, FALSE);
    }

    function update($post) {
        if(!is_array($post)) Note('global_op_unselect');
        foreach($post as $imageid => $val) {
            $val['imageid'] = (int) $val['imageid'];
            $this->db->from($this->table);
            $this->db->set($val);
            $this->db->where('imageid',$imageid);
            $this->db->update();
        }
    }
	
	
	
	function delimage($imageid) {
		
		$imageurl = $this->read_one($imageid);
		
        $this->db->where('imageid', $imageid);  
		
		$this->db->from($this->table);     

        $this->db->delete();
		
		@unlink(TUNTRON_PATH.$imageurl['imageurl']);
		
        
    }

    function check_post($post,$is_edit=false) {
	    if(!$post['imageurl']) Note('文件下载地址不能为空！');
    }
}
?>