<?php

/**
 *      【橙创家校通v4.0】 (C)2010-2012 Tuntron Inc.
 *      
 *    	 http://www.tuntron.com   QQ：1121251729
 *
 *      &公告基类文件&
 */

if (!defined('IS_RUN')) die('Forbidden');

class tj_help_cat extends tj_model {

	var $table = 'dbpre_help_cat';
    var $key = 'catid';

	function __construct() {
		parent::__construct();
		$this->init_field();
	}

    function msm_announcement() {
        $this->__construct();
    }

	function init_field() {
		$this->add_field('catid,name,des');
		$this->add_field_fun('catid', 'intval');
        $this->add_field_fun('name,des', '_T');
	}

	function read_all($type=null) {
		
        $this->db->from($this->table);
		
        if($type) $this->db->where('catid', $type);
		
		$this->db->order_by('catid');//必须为大写DESC或ASC
        return $this->db->fetch_all_assoc();
    }
	
	function read_one($catid) {
        $this->db->from($this->table);
		$this->db->where('catid', $catid);
        return $this->db->once_fetch_assoc();
    }
	
	
	function helpcat_option($catid) {
        $helpcat =  $this->read_all();
		foreach($helpcat as $key=>$item){
			$isselected = intval($catid)>0&&$catid==$item['catid']?'selected="selected"':'';
			$helpcat_html.= '<option value="'.$item['catid'].'"'.$isselected.'>'.$item['name'].'</option>';
		}
		return $helpcat_html;
    }
	
	
	
    function save(& $post, $catid=NULL, $cache=TRUE) {
        $this->check_post($post);
        return parent::save($post, $catid, $cache, FALSE);
    }

    function update($post) {
        if(!is_array($post)) Note('global_op_unselect');
        foreach($post as $catid => $val) {
            $val['available'] = (int) $val['available'];
            $this->db->from($this->table);
            $this->db->set($val);
            $this->db->where('catid',$catid);
            $this->db->update();
        }
    }
	
	function delcat($catid) {
		
        $this->db->where('catid', $catid);  
		
		$this->db->from($this->table);     

        $this->db->delete();

    }

    function check_post($post,$is_edit=false) {
        if(!$post['name']) Note('分类名称不能为空！');
    }
}
?>