<?php
/**
 * 
 * @file subject.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */
require_once(dirname(__FILE__) . '/includes/inc_general.php');
require_once(EIFR_ROOT . 'libraries/pages.php');

function getArticel($id) {
    $sql = "select * from " . TB_ARTICLE . " where id=$id";
    return dbGetRecord1($sql);
}

function getSubjectLayoutid0($limit_num = 10) {
    global $id;
    if ($id != '') {
        $article_list = dbGetFieldValue(TB_SUBJECT_RELATION, 'article_list', "article_id=" . $id . " and layout_id=0");
        $sql = "select * from " . TB_ARTICLE . " where flag<3 and id in (" . $article_list . ") order by issuetime desc limit $limit_num";
    } else $sql = '';

    return dbGetRecordn($sql);
} 

function getHotArticle($limit_num = 10) {
    global $subject_article_all;
    if ($subject_article_all != '') {
        $sql = "select * from " . TB_ARTICLE . " where flag<3 and id in (" . $subject_article_all . ") order by viewnum desc,issuetime desc limit $limit_num";
    } else {
        $sql = '';
    } 
    return dbGetRecordn($sql);
} 

function getHotComment($limit_num = 10) {
    global $subject_article_all;
    if ($subject_article_all != '') {
        $sql = "select * from " . TB_ARTICLE . " where flag<3 and id in (" . $subject_article_all . ") order by commentnum desc,issuetime desc limit $limit_num";
    } else {
        $sql = '';
    } 
    return dbGetRecordn($sql);
} 

function getRelation() {
    global $article_array, $id;
    $relation_type = $article_array['relation_type'];
    $relation_info = $article_array['relation_info']; 
    // $rtn = array();
    // if($relation_type==0 || $relation_info=='') return $rtn;
    $so_sql = '';
    $limit_sql = '';

    if ($relation_type == 1) { // keyword
        $so_sql .= " and id<>$id and (";
        $key_arr = explode('|', $relation_info);
        $key_count = count($key_arr);
        for($i = 0;$i < $key_count;$i++) {
            if ($i == $key_count-1) $so_sql .= " title like '%" . $key_arr[$i] . "%'";
            else $so_sql .= " title like '%" . $key_arr[$i] . "%' or ";
        } 
        $so_sql .= ") ";
        $limit_sql = " limit 10";
    } else if ($relation_type == 2) { // id
        $so_sql = "and  id in (" . $relation_info . ") ";
    } 

    $sql = "select id,title,issuetime from " . TB_ARTICLE . " where flag<3 " . $so_sql . " order by issuetime desc " . $limit_sql . "";
    if ($relation_type == 0) $sql = ''; 
    // echo $sql;
    return dbGetRecordn($sql);
} 

function getSubjectList() {
    global $id, $lid;
    if($id=='' || $lid=='') return null;
    $article_list = dbGetFieldValue(TB_SUBJECT_RELATION, 'article_list', "article_id=$id and layout_id=$lid");
    if ($article_list != '') $sql = "select id,title,issuetime from " . TB_ARTICLE . " where flag<3 and id in (" . $article_list . ") order by issuetime desc ";
    else $sql = ''; 
    // echo $sql;
    return dbGetRecordPages($sql, 'id=' . $id . '&lid=' . $lid);
}

function getSubjectSql($sql = '', $article_list = '') {
    $rtn = '';
    if (strpos($sql, '$article_list') > 0 && $article_list != '') {
        $rtn = evalSql($sql, '$article_list="' . $article_list . '";');
    } 
    return $rtn;
} 
// ---start---
if ($tpl_file == '') {
    $tpl_file = 'subject';
} 

$id = kGet('id');
if (!$is_preview && empty($id)) {
    goErrorPage($lang['article_inexistent']);
}
if (! isset($lid)) $lid = 0;

$channel_parentid = '';
$search_select = '';
$navigation = '';
$subject_article_all = '';
$article_array = array();
$template_array = array();
$layout_array = array();
$layout_title_array = array();
$layout_id_array = array();
$layout_sql_array = array();
$layout_ad_array = array();
$layout_link_array = array();

if (!empty($id)) {
    $article_array = getArticel($id);
    if (!$article_array) {
        goErrorPage($lang['article_inexistent']);
    }

}

if ($article_array) {
    $template_id = $article_array['template_id'];
    $channel_id = $article_array['channel_id'];
    $channel_parentid = substr($channel_id, 0, 2);

    if ($template_id) {
        $template_array = getTemplateByID($template_id);
    } 

    updateArticleViewnum(1);

    $search_select = createChannelsSelect($channel_parentid);
    $navigation = createChannelsNav($channel_id);
} 

if (!$template_array) {
    $template_array = getTemplate('subject.php', $tpl_file);
} 
if ($template_array) {
    $tpl_file = $template_array['template_filename'];
    $layout_array = getTemplateLayoutArray($template_array['id']);
} 

foreach($layout_array as $row) {
    $layout_title_array[$row['layout_code']] = $row['title'];
    $layout_id_array[$row['layout_code']] = $row['id']; 
    $layout_sql_array[$row['layout_code']] = '';
    if (!empty($id)) {
        $article_list = dbGetFieldValue(TB_SUBJECT_RELATION, 'article_list', "article_id=" . $id . " and layout_id=" . $row['id'] . "");
        $layout_sql_array[$row['layout_code']] = getSubjectSql($row['sql_select'], $article_list);
        if ($article_list != '') {
            $subject_article_all .= ',' . $article_list;
        } 
    } 

    if ($row['type'] == 1) {
        $layout_ad_array[$row['layout_code']] = getAdvertisement($row['id']);
    } 
    if ($row['type'] == 2) {
        $layout_link_array[$row['layout_code']] = getLink($row['id']);
    } 
} 
if ($subject_article_all != '') {
    $subject_article_all = substr($subject_article_all, 1);
} 

if (!$article_array) {
    $article_array = getTableFill('article');
} 
require_once(getTemplatePath($tpl_file));

?>