<?php
/**
 * Created on 2011-5-16
 */

class CSession {
    const MAX_TIMEOUT = MAX_COOKIE_TIME;
    const IS_ENCRYPT_COOKIE = IS_ENCRYPT_COOKIE;
    const COOKIE_PATH = DIR_INSTALL;
    const COOKIE_ENCODE = COOKIE_ENCODE;
    const COOKIE_ENCRYPT_SUFFIX = '_encrypt_validate';
    const COOKIE_PREFIX = COOKIE_PREFIX;
    const SESSION_PREFIX = SESSION_PREFIX;

    public static function setSession($key, $val) {
        $key = self :: SESSION_PREFIX . $key;
        $_SESSION[$key] = $val;
    } 

    public static function getSession($key) {
        $key = self :: SESSION_PREFIX . $key;
        if (!isset($_SESSION[$key])) return '';
        return $_SESSION[$key];
    } 
    // set session with serialize
    public static function setSSession($key, $val) {
        $key = self :: SESSION_PREFIX . $key;
        $_SESSION[$key] = serialize($val);
    } 
    // get session with unserialize
    public static function getSSession($key) {
        $key = self :: SESSION_PREFIX . $key;
        if (!isset($_SESSION[$key])) return '';
        return unserialize($_SESSION[$key]);
    } 

    public static function isSession($key) {
        $key = self :: SESSION_PREFIX . $key;
        return isset($_SESSION[$key]);
    } 

    public static function delSession($key) {
        $key = self :: SESSION_PREFIX . $key;
        $_SESSION[$key] = '';
    } 


    public static function isCookie($key) {
        $key = self :: COOKIE_PREFIX . $key;
        return isset($_COOKIE[$key]);
    }
    
    /**
     * ---addCookie---
     * 
     * @param string $key ,$value,$cpath
     * @param int $timeout 
     */
    public static function addCookie($key, $value, $timeout = 0, $cpath = self :: COOKIE_PATH) {
        if ($timeout > self :: MAX_TIMEOUT) return;

        $key = self :: COOKIE_PREFIX . $key;
        if($timeout !== 0) {
            $timeout = time() + $timeout;
        }
        if (self :: IS_ENCRYPT_COOKIE) {
            $key = $key . self :: COOKIE_ENCRYPT_SUFFIX;
            $value = substr(md5(self :: COOKIE_ENCODE . $value), 0, 24);
        } 
        // Log_v(__FILE__,__LINE__,'addCookie'.$key.':'.$value);
        setcookie($key, $value, $timeout, $cpath);
    } 

    /**
     * ---delCookie---
     * 
     * @param string $key ,$cpath
     */
    public static function delCookie($key, $cpath = self :: COOKIE_PATH) {
        $key = self :: COOKIE_PREFIX . $key;
        $timeout = time() - self :: MAX_TIMEOUT-1;
        if (self :: IS_ENCRYPT_COOKIE) {
            $key = $key . self :: COOKIE_ENCRYPT_SUFFIX;
        } 
        // Log_v(__FILE__,__LINE__,'delCookie'.$key);
        setcookie($key, '', $timeout, $cpath);
    } 

    /**
     * ---getCookie---
     * 
     * @param string $key 
     */
    public static function getCookie($key) {
        $key = self :: COOKIE_PREFIX . $key;
        if (!isset($_COOKIE[$key])) return '';

        if (self :: IS_ENCRYPT_COOKIE) {
            if ($_COOKIE[$key . self :: COOKIE_ENCRYPT_SUFFIX] != substr(md5(self :: COOKIE_ENCODE . $_COOKIE[$key]), 0, 24)) return '';
            $key = $key . self :: COOKIE_ENCRYPT_SUFFIX;
        } 

        return $_COOKIE[$key];
    } 
} // end CSession
if (!function_exists('session_register')) {
    function session_register($key) {
        echo "test session_register2";
        $_SESSION[$key] = null;
    } 
} 

if (!function_exists('session_is_registered')) {
    function session_is_registered($key) {
        return isset ($_SESSION[$key]);
    } 
} 

if (!function_exists('session_is_registered')) {
    function session_unregister($key) {
        unset ($_SESSION[$key]);
    } 
} 

function isSession($key) {
    return CSession :: isSession($key);
} 

function setSession($key, $val) {
    CSession :: setSession($key, $val);
} 

function setSSession($key, $val) {
    CSession :: setSSession($key, $val);
} 

function getSession($key) {
    return CSession :: getSession($key);
} 

function getSSession($key) {
    return CSession :: getSSession($key);
} 

function delSession($key) {
    CSession :: delSession($key);
} 

function isCookie($key) {
    return CSession :: isCookie($key);
}

function addCookie($key, $value, $ctimeout = DEF_COOKIE_TIME, $cpath = CSession :: COOKIE_PATH) {
    CSession :: addCookie($key, $value, $ctimeout, $cpath);
} 

function delCookie($key, $cpath = CSession :: COOKIE_PATH) {
    CSession :: delCookie($key, $cpath);
} 

function getCookie($key) {
    return CSession :: getCookie($key);
} 

/**
 * End of file session.php
 */