<?php
/**
 * 
 * @file safedata.php
 * get saft data
 * @copyright (c) 2005 - 2011 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

class CSafeData {
    
    public static function getString($data, $defval='') {
        if ($data === '' || $data === NULL) {
            $data = $defval;
        }
        return $data;
    }
    
    public static function getNumeric($data, $defval=0) {
        if (! is_numeric($data)) {
            $data = $defval;
        }
        return $data;
    }

    public static function getInt($data, $defval=0) {
        if (! is_numeric($data)) {
            $data = $defval;
        }
        return (int) $data;
    }

    public static function getFloat($data, $defval=0.0) {
        if (! is_numeric($data)) {
            $data = $defval;
        }
        return (float) $data;
    }

    public static function getImgSrc($descsrc, $defsrc = '') {
        if ($descsrc != '') {
			$urlarr = parse_url($descsrc);
			if (! isset($urlarr['scheme']) && substr($urlarr['path'], 0, 1) != '/') {
				return DIR_INSTALL . $descsrc;
			}
			return $descsrc;
		} else if ($defsrc != '') {
			return $defsrc;
		}

        return SYS_FRONT_STYLE_PATH . 'images/blank.gif';
    }

    public static function getArray($data, $keys = '') {
        if(! $data || ! is_array($data)) {
            $data = array();
        }

        if ($keys != '') {
            $arr = explode(',', $keys);
            foreach ($arr as $k) {
                if(! array_key_exists($k, $data)) {
                    $data[$k] = '';
                }
            }
        }

        return $data;
    }

} 

/**
 * End of file safedata.php
 */