<?php
/**
 * 
 * @file log.php
 * @copyright (c) 2005 - 2011 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

class CLog {
    /**
     * * const value *
     */
    const LOG_FILE = 1;
    const LOG_WEB = 2;
    const LOG_SOCKET = 4;

    const LEVEL_OFF = 0 ;
    const LEVEL_FATAL = 1 ;
    const LEVEL_ERROR = 2;
    const LEVEL_WARN = 3;
    const LEVEL_INFO = 4;
    const LEVEL_DEBUG = 5;
    const LEVEL_VERBOSE = 6;
    
    const LOG_FILESIZE = 20460;

    var $log_level;
    var $log_set;
    var $log_server_ip;
    var $log_server_port;

    var $log_socket;
    var $log_webmsg;
    var $log_level_array;

    var $log_outfile;

    function __construct($level = self :: LEVEL_VERBOSE, $set = self :: LOG_FILE, $server_ip = '127.0.0.1', $server_port = '19793') {
        $this -> log_level = $level;
        $this -> log_set = $set;
        $this -> log_server_ip = $server_ip;
        $this -> log_server_port = $server_port;

        $this -> log_outfile = EIFR_ROOT . 'cache/eifr.log.php';
        
        if ($set &self :: LOG_SOCKET) {
            $this -> log_socket = socket_create(AF_INET, SOCK_DGRAM, 0);
        } 

        if ($set &self :: LOG_WEB) {
            $this -> log_webmsg = "<table width='100%'><tr style='background-color: #98AB6F'><td>Level</td><td>Message</td><tr>";
        }
        
        $this -> log_level_array = Array(
            self :: LEVEL_FATAL => 'FATAL', 
            self :: LEVEL_ERROR => 'ERROR', 
            self :: LEVEL_WARN => 'WARN', 
            self :: LEVEL_INFO => 'INFO', 
            self :: LEVEL_DEBUG => 'DEBUG', 
            self :: LEVEL_VERBOSE => 'VERBOSE'
        );
    } 

    function log_f($file, $line, $msg) {
        if ($this -> log_level >= self :: LEVEL_FATAL) {
            $this -> log(self :: LEVEL_FATAL, $file, $line, $msg);
        } 
    } 

    function log_e($file, $line, $msg) {
        if ($this -> log_level >= self :: LEVEL_ERROR) {
            $this -> log(self :: LEVEL_ERROR, $file, $line, $msg);
        } 
    } 

    function log_w($file, $line, $msg) {
        if ($this -> log_level >= self :: LEVEL_WARN) {
            $this -> log(self :: LEVEL_WARN, $file, $line, $msg);
        } 
    } 

    function log_i($file, $line, $msg) {
        if ($this -> log_level >= self :: LEVEL_INFO) {
            $this -> log(self :: LEVEL_INFO, $file, $line, $msg);
        } 
    } 

    function log_d($file, $line, $msg) {
        if ($this -> log_level >= self :: LEVEL_DEBUG) {
            $this -> log(self :: LEVEL_DEBUG, $file, $line, $msg);
        } 
    } 

    function log_v($file, $line, $msg) {
        if ($this -> log_level >= self :: LEVEL_VERBOSE) {
            $this -> log(self :: LEVEL_VERBOSE, $file, $line, $msg);
        } 
    } 

    function send_socket($buf) {
        if (!$this -> log_socket) {
            return;
        } 

        if (!@socket_sendto($this -> log_socket, $buf, strlen($buf), 0, $this -> log_server_ip, $this -> log_server_port)) {
            socket_close($this -> log_socket);
            $this -> log_socket = 0;
        } 
    } 

    function log($level, $file, $line, $msg) {
        if ($level == self :: LEVEL_OFF)
            return;

        $pfile = addslashes(substr($file, strlen(EIFR_ROOT)));
        $pfile = str_replace("\\\\", "/", $pfile);
        $level_desc = $this -> log_level_array[$level];

        // output file
        if ($this -> log_set &self :: LOG_FILE) {
            $level_desc = sprintf("%-10s", $level_desc);
            $outStr = getDateTimeMk(time()) . " " . sprintf("%-10s", $level_desc) . "$pfile($line) $msg\n";
            
            //rm log file if > LOG_FILESIZE
            if (file_exists($this -> log_outfile) && filesize($this -> log_outfile) > self :: LOG_FILESIZE) {
                unlink($this -> log_outfile);
            }

            //append log to file
            if ($fp = @fopen($this -> log_outfile, 'a+')) {
                flock($fp, LOCK_EX);
                fwrite($fp, $outStr);
                flock($fp, LOCK_UN);
                fclose($fp);
            } else {
                exit("Can not write to log files($this->log_outfile)!");
            }
        }
        
        // output web
        if ($this -> log_set &self :: LOG_WEB) {
            $color = "";
            switch ($level) {
                case self :: LEVEL_VERBOSE:$color = "#eeeeee";
                    break;
                case self :: LEVEL_DEBUG:$color = "#0000ff";
                    break;
                case self :: LEVEL_INFO:$color = "#00ff00";
                    break;
                case self :: LEVEL_WARN:$color = "#FF6100";
                    break;
                case self :: LEVEL_ERROR:$color = "#FF5500";
                    break;
                case self :: LEVEL_FATAL:$color = "#ff0000";
                    break;
            } 

            $this -> log_webmsg .= "<tr style='color:" . $color . "' onmouseout=this.style.backgroundColor='transparent'; onmouseover=this.style.backgroundColor='#223322'; ><td align='left'>[" . $level_desc . "]</td>";
            $this -> log_webmsg .= "<td>" . $pfile . "(" . $line . ")<br/>" . $msg . "</td></tr>";
        } 

        // output socket
        if ($this -> log_set &self :: LOG_SOCKET) {
            $level_desc = sprintf("%-10s", $level_desc);
            $this -> send_socket("$level_desc $pfile($line) $msg\n ");
        }
        
    } 

    function web_output() {
        if ($this -> log_set &self :: LOG_WEB) {
            $t = time();
            echo "\n<script>\n";
            echo "var _eifrLogWin = window.open(\"\", \"DebugWindow_$t\", \"resizable=yes,height=500,width=700,top=0,left=600,toolbar=no,menubar=no,scrollbars=yes\");\n";
            echo "_eifrLogWin.document.write(\"<html><head><title></title></head><body bgcolor=#000000>\"); \n";
            echo "_eifrLogWin.document.write(\"<center><font color=white>DebugConsole</font></center><hr size=1 color=lightgray>\");\n";
            echo "_eifrLogWin.document.write(\"$this->log_webmsg\");\n";
            echo "_eifrLogWin.document.write(\"</table>\");\n";
            echo "_eifrLogWin.document.write(\"<hr size=1 color=lightgray><center><input type='button' value='close' onclick='window.close();'></center>\");\n";
            echo "_eifrLogWin.document.write(\"</body></html>\");\n";
            echo "</script>\n";
        } 
    } 
} 

$_eifrLog = null;
if (IS_DEBUG) {
    $_eifrLog = new CLog(LOG_LEVEL, CLog :: LOG_SOCKET | CLog :: LOG_FILE);
} 

function Log_f($file, $line, $msg) {
    if (IS_DEBUG) {
        global $_eifrLog;
        $_eifrLog -> log_f($file, $line, $msg);
    } 
} 

function Log_e($file, $line, $msg) {
    if (IS_DEBUG) {
        global $_eifrLog;
        $_eifrLog -> log_e($file, $line, $msg);
    } 
} 

function Log_w($file, $line, $msg) {
    if (IS_DEBUG) {
        global $_eifrLog;
        $_eifrLog -> log_w($file, $line, $msg);
    } 
} 

function Log_i($file, $line, $msg) {
    if (IS_DEBUG) {
        global $_eifrLog;
        $_eifrLog -> log_i($file, $line, $msg);
    } 
} 

function Log_d($file, $line, $msg) {
    if (IS_DEBUG) {
        global $_eifrLog;
        $_eifrLog -> log_d($file, $line, $msg);
    } 
} 

function Log_v($file, $line, $msg) {
    if (IS_DEBUG) {
        global $_eifrLog;
        $_eifrLog -> log_v($file, $line, $msg);
    } 
} 

function LogPrint() {
    if (IS_DEBUG) {
        global $_eifrLog;
        $_eifrLog -> web_output();
    } 
} 

/**
 * for example:
 * Log_d(__FILE__,__LINE__,'debug');
 */

?>