<?php
/**
 * 
 * @file cart.php
 * @copyright (c) 2005 - 2011 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

class CCart {
    var $sessionName = 'eifrSessionCart';
    var $cartContents = array();

    function __construct() {
        if (isCookie($this -> sessionName)) {
            if (getCookie($this -> sessionName) != '') {
                $this -> cartContents = unserialize(getCookie($this -> sessionName));
                Log_d(__FILE__, __LINE__, "session cart has data");
            } 
        } else {
            delCookie($this -> sessionName);
            Log_d(__FILE__, __LINE__, "session cart has nothing");
        } 
    } 

    function getCart() {
        return $this -> cartContents;
    } 

    /**
     * add an item into the cart and save it to the session table
     * id is key
     * for example:
     * $item = array('id'=>12, 'name'=>'product1', 'price'=>33.5, 'quantity'=>3);
     * 
     * @param array $ 
     * @return bool 
     */
    function addCart($item = array()) {
        if (! isset($item['id'])) {
            Log_e(__FILE__, __LINE__, "NO id as key!");
            return false;
        } 
        if (array_key_exists($item['id'], $this -> cartContents)) {
            Log_e(__FILE__, __LINE__, $item['id'] . " exists!");
            return false;
        } 
        $this -> cartContents[$item['id']] = $item;
        $this -> _saveCart();
        return true;
    } 

    /**
     * update items into the cart and save it to the session table
     * id is key
     * for example:
     * $item['1'] = array('id'=>1, 'name'=>'product1', 'price'=>33.5, 'quantity'=>3);
     * $item['2'] = array('id'=>2, 'name'=>'product2', 'price'=>38.8, 'quantity'=>1);
     * 
     * @param array $ 
     * @return bool 
     */
    function updateCart($items = array()) {
        // empty cart and reset cart
        $this -> emptyCart();
        $this -> cartContents = $items;
        $this -> _saveCart();
        return true;
    } 

    function updateCartByField($field = '', $fieldarr = array()) {
        if (count($this -> cartContents) != count($fieldarr) || $field == '') {
            Log_e(__FILE__, __LINE__, "Invalid data");
            return false;
        } 
        foreach($this -> cartContents as $k => $v) {
            $this -> cartContents[$k][$field] = current($fieldarr);
            next($fieldarr);
        } 
        $this -> _saveCart();
        return true;
    } 

    function delCart($id) {
        unset($this -> cartContents[$id]);
        $this -> _saveCart();
    } 

    function emptyCart() {
        unset($this -> cartContents);
        $this -> cartContents = array();
        delCookie($this -> sessionName);
    } 

    function _saveCart() {
        Log_v(__FILE__, __LINE__, "cart count:" . count($this -> cartContents));
        addCookie($this -> sessionName, serialize($this -> cartContents));
    } 

    function getCartHtml() {
        // Log_v(__FILE__,__LINE__,'getCartHtml');
        $cartHtml = '';
        foreach($this -> cartContents as $row) {
            $cartHtml .= $this -> getItemHtml($row);
        } 
        return $cartHtml;
    } 

    function getItemHtml($row) {
        Log_v(__FILE__, __LINE__, 'getItemHtml, articleID=' . $row['id']);
        $itemHtml = '<li id="articleID_' . $row['id'] . '"><a href=api/cart.php?action=delFromCart&articleID=' . $row['id'] . ' onClick="return false;"><img src="images/delete.png" id="deletearticleID_' . $row['id'] . '"></a> ' . $row['title'] . '(id:' . $row['id'] . ', quantity:' . $row['quantity'] . ' $' . $row['price'] . ') </li>';
        return $itemHtml;
    } 
} 

?>
