<?php
/**
 * 
 * @file ajax.php
 * @create date 2007-09-25
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

class EIFRajax {
    const SYS_CHARSET = 'UTF-8';

    public static function ajaxStringEncode($str='', $charset=self::SYS_CHARSET) {
        if ($str == '') return '';
        $str = str_replace("\"", "&quot;", $str);
        if (strtoupper($charset) != "UTF-8") {
            if (function_exists("iconv")) {
                $str = iconv($charset, "UTF-8", $str);
            } 
        }
        return $str;
    } 

    /**
     * ---ajaxParseResultArr---
     * 
     * @param int $i 
     * @param array $keyArr 
     * @return string 
     */
    public static function ajaxParseResultArr($i, $keyArr) {
        $rtn = '';
        reset($keyArr);
        foreach($keyArr AS $key => $value) {
            $rtn .= " result_" . $i . "." . $key . "=\"" . $value . "\"; ";
        } 
        return $rtn;
    } 

    /**
     * ---ajaxReturnJavaScript---
     * 
     * @param int $ajax_num 
     * @param array $layout_arr 
     * @return string 
     */
    public static function ajaxReturnJavaScript($ajax_num = 0, $layout_arr) {
        if (count($layout_arr) < 1) return '';
        $rtn = " resultObj.errorCode=\"$ajax_num\"; ";
        $rtn .= " resultObj.dataArr= new Array(); ";
        $i = 0;
        reset($layout_arr);
        foreach($layout_arr AS $key => $value) {
            $rtn .= " var result_$i = new Object(); ";
            $rtn .= self::ajaxParseResultArr($i, $layout_arr[$key]);
            $rtn .= " resultObj.dataArr[$i] = result_$i; ";
            $i++;
        } 
        $rtn .= "";
        return $rtn;
    } 
} 

?>