<?php
/**
 * 
 * @file acl.php
 * Access Control List
 * @copyright (c) 2005 - 2011 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

class CAcl {
    var $access = array();
    var $value = 0;

    function __construct($access = array()) {
        $this -> setAccess($access);
    } 

    function getAccess() {
        return $this -> access;
    } 

    function setAccess($access) {
        $this -> access = $access;
        $this -> value = $this -> getValueByAccess();
    } 

    function setValue($val) {
        $this -> value = $val;
        $this -> access = $this -> getAccessByValue($this -> value);
    } 

    function getValue() {
        return $this -> value;
    } 

    function getValueByAccess() {
        $rc = 0;
        foreach($this -> access as $key => $val) {
            $rc = $rc | $val;
        } 
        return $rc;
    } 

    function getAccessKey($val = 0) {
        if ($val === 0) {
            $val = $this -> value;
        } 

        foreach($this -> access as $k => $v) {
            if ($val === $v) {
                return $k;
            } 
        } 
        return '';
    } 

    function getAccessByValue($val = 0) {
        $myaccess = array();
        foreach($this -> access as $k => $v) {
            if ($val &$v) {
                $myaccess[$k] = $v;
            } 
        } 
        return $myaccess;
    } 

    function getKeyByValue($val = 0) {
        foreach($this -> access as $k => $v) {
            if ($val === $v) {
                return $k;
            } 
        } 
        return '';
    } 

    function getValueByKey($key = '') {
        if (array_key_exists($key, $this -> access)) {
            return $this -> access[$key];
        } 

        return 0;
    } 

    function getValueByValues($values = array()) {
        $rc = 0;
        foreach($values as $val) {
            $rc = $rc | $val;
        } 
        return $rc;
    } 

    function getValueByKeys($keys = array()) {
        $rc = 0;
        foreach($keys as $key) {
            $rc = $rc | $this -> access[$key];
        } 
        return $rc;
    } 

    function isAllowed($checkval) {

        $this -> isAllowedInValue($checkval, $this -> value);
    } 

    function isAllowedInValue($checkval, $val = 0) {

        //checkval is value
        if(is_int($checkval)) {
            Log_v(__FILE__,__LINE__,"isAllowedInValue(value), checkval:$checkval, val:$val");
            return ($checkval &$val);
        }
        //checkval is key
        //Log_v(__FILE__,__LINE__,"isAllowedInValue(key), checkval:$checkval, val:$val");
        if (! array_key_exists($checkval, $this -> access)) {
            return false;
        } 

        return ($this -> access[$checkval] &$val);
    }
} 

/**
 * End of file acl.php
 */