<?php
/**
 * 
 * @file comment.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */
require_once(dirname(__FILE__) . '/includes/inc_general.php');
require_once(dirname(__FILE__) . '/libraries/pages.php');

/**
 * tip: if article is html page, then need use ajax to request session
 */
function checkSaveComment() {
    global $article_id, $vcode, $backurl, $lang;

    if (!isset($backurl) || $backurl == '') {
        $backurl = '?article_id=' . $article_id;
    } 

    if (! checkVcode('eifr_checkvcode', $vcode)) {
        showMsg($lang['vincorrect_vcode'], $backurl);
        exit();
    }
} 

function saveComment() {
    global $db, $lang, $is_nickname, $title, $comment_content, $ratevalue, $article_id, $nickname, $parent_id;
    $uid = 0;
    if (getCookie(COOKIE_UID) != '') {
        $uid = getCookie(COOKIE_UID);
        if (!$is_nickname) $nickname = dbGetFieldValue(TB_USER, TF_USER_NICK, "uid='" . $uid . "'");
    } 
    if ($is_nickname) $nickname = $lang['nickname'];
    $parent_id = 0;
    $addtime = time();
    $ip = getIP();
    $rtn_comment = true;
    if ($title == $lang['pls_write_title']) $title = '';
    $title = sTextEncode($title, 255);
    $nickname = sTextEncode($nickname, 255);
    $comment_content = strip_tags($comment_content, '<p><br><b>');
    $sql = "insert into " . TB_COMMENT . " (title,content,article_id,uid,nickname,ratevalue,addtime,ip,parent_id) values('$title','$comment_content','$article_id','$uid','$nickname','$ratevalue','$addtime','$ip',$parent_id)";
    $rs = $db -> Execute($sql); 
    // echo $sql;
    if ($rs) {
        $rtn_comment = true;
    } else {
        $rtn_comment = false;
    } 
    $rs -> Close();
    $rtn_article = true;
    $sql = "update " . TB_ARTICLE . " set commentnum=commentnum+1 where id='$article_id'";
    $rs = $db -> Execute($sql); 
    // echo $sql;
    if ($rs) {
        $rtn_article = true;
    } else {
        $rtn_article = false;
    } 
    $rs -> Close();
    if ($rtn_comment && $rtn_article) {
        showMsg('', '?article_id=' . $article_id . '');
    } else {
        showMsg($lang['addFail']);
    } 
} 

function deleteCommentRecords() {
    global $db, $lang, $id, $article_id;
    $url = 'comment.php';
    Common::checkAdminExeAuth('com_comment/comment.php', 'delete');

    $sql = "UPDATE " . TB_COMMENT . "  set flag ='4'  WHERE id='" . $id . "'";
    $rs = $db -> Execute($sql);
    if ($rs) {
        showMsg('', '?article_id=' . $article_id . '');
    } else {
        showMsg($lang['modifyFail']);
    } 
} 

function getCommentCount() {
    global $db;
    global $article_id;

    $rtn = array();
    $rtn['rate1'] = 0;
    $rtn['rate2'] = 0;
    $rtn['rate3'] = 0;
    $rtn['rate_count'] = 0;

    $sql = "select * from " . TB_COMMENT . " where flag<4 and article_id='" . $article_id . "' ";
    $rs = $db -> Execute($sql);
    while (!$rs -> EOF) {
        $rtn['rate_count']++;
        $ratevalue = $rs -> fields['ratevalue'];
        switch ($ratevalue) {
            case 1:
                $rtn['rate1']++;
                break;
            case 2:
                $rtn['rate2']++;
                break;
            case 3:
                $rtn['rate3']++;
                break;
        } 
        $rs -> MoveNext();
    } 
    $rs -> Close();

    return $rtn;
} 

function getCommentList() {
    global $db, $lang;
    global $article_id;

    $rtn = array();
    $rtn['list'] = array();
    $rtn['page'] = '';

    if ($article_id == '') return $rtn;

    $page_list = array();
    $sql = "select * from " . TB_COMMENT . " where flag<4 and article_id='" . $article_id . "' order by id asc ";

    $clPages = new Pages();
    $clPages -> query_string = 'article_id=' . $article_id . '';
    $clPages -> query_sql = $sql;
    $aryResult = $clPages -> Execute();
    $rs = $aryResult[0];
    $intList = $aryResult[2];

    $num = 0;
    if ($intList > 0) {
        while (!$rs -> EOF) {
            $num++;
            $uid = $rs -> fields[TF_USER_ID];

            $db_handle = '';
            if (getCookie(COOKIE_UID) != '') {
                if (Common::checkAdminAuth('com_comment/comment.php', 'delete'))
                    $db_handle = "<a href='comment.php?act=delete&article_id=" . $article_id . "&id=" . $rs -> fields['id'] . "'>" . $lang['delete'] . "</a>";
            } 
            $rs -> fields['eifr_uid'] = $uid;
            $rs -> fields['eifr_num'] = $num;
            $rs -> fields['eifr_handle'] = $db_handle;
            $rs -> fields['eifr_ratevalue'] = getArticleRate($rs -> fields['ratevalue']);
            $page_list[] = $rs -> fields;
            $rs -> MoveNext();
        } 
    } 
    $rs -> Close();

    $rtn['list'] = $page_list;
    $rtn['page'] = $aryResult[3];

    return $rtn;
} 

function getArticleRate($ratevalue) {
    global $lang;
    $rtn = '';
    if (array_key_exists($ratevalue, $lang['comment_ratevalue'])) {
        $rtn = $lang['comment_ratevalue'][$ratevalue];
    } 
    return $rtn;
} 
// ---start---
if ($tpl_file == '') {
    $tpl_file = 'comment';
} 

$article_id = kRequest('article_id');
if (!$is_preview && empty($article_id)) {
    goErrorPage($lang['article_inexistent']);
} 
$act = kRequest('act');
if ($act == 'save') {
    checkSaveComment();
    saveComment();
} else if ($act == 'delete') {
    deleteCommentRecords();
} 

$rate_array = getCommentCount();
$channel_parentid = '';
$search_select = '';
$navigation = '';
$article_array = array();
$template_array = array();
$layout_array = array();
$layout_title_array = array();
$layout_id_array = array();
$layout_sql_array = array();
$layout_ad_array = array();
$layout_link_array = array();
if (!empty($article_id)) {
    // article
    $sql = "select channel_id, id, title, intro, issuetime from " . TB_ARTICLE . " where id=$article_id";
    $article_array = dbGetRecord1($sql);
    if (!$article_array) {
       goErrorPage($lang['article_inexistent']);
    } 

    $channel_id = $article_array['channel_id'];
    $channel_parentid = substr($channel_id, 0, 2);
    $search_select = createChannelsSelect($channel_parentid);
    $navigation = createChannelsNav($channel_id);

}

$template_array = getTemplate('comment.php', $tpl_file);
if ($template_array) {
    $tpl_file = $template_array['template_filename'];
    $layout_array = getTemplateLayoutArray($template_array['id']);
} 

foreach($layout_array as $row) {
    $layout_title_array[$row['layout_code']] = $row['title'];
    $layout_id_array[$row['layout_code']] = $row['id'];
    $layout_sql_array[$row['layout_code']] = $row['sql_select'];
    if ($row['type'] == 1) {
        $layout_ad_array[$row['layout_code']] = getAdvertisement($row['id']);
    } 
    if ($row['type'] == 2) {
        $layout_link_array[$row['layout_code']] = getLink($row['id']);
    } 
} 

$comment_list_array = getCommentList();

if (!$article_array) {
    $article_array = getTableFill('article');
} 

require_once(getTemplatePath($tpl_file));

?>
