<?php
/**
 * 
 * @file article.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */
require_once(dirname(__FILE__) . '/includes/inc_general.php');
require_once(EIFR_ROOT . 'admin/mod_article/article.config.php');

function getArticel($id) {
    $sql = "select * from " . TB_ARTICLE . " where id=$id";
    return dbGetRecord1($sql);
}

function getArticelContent($id, $ordernum = '') {
    if($ordernum == '') $ordernum = 1;
    $sql = "select * from " . TB_ARTICLE_CONTENT . " where article_id='" . $id . "' and ordernum='" . $ordernum . "' and flag=0";
    return dbGetRecord1($sql);
} 

function showContentPages() {
    global $lang;
    global $id, $page, $act;
    $rtn = '';

    // ListContent
    $gotoUrl = basename($_SERVER['PHP_SELF']);
    $gotoUrl .= "?id=" . $id;
    if($act != '') $gotoUrl .= "&act=" . $act;
    
    $current_page = 1;
    $max_page = intval(dbGetMaxValue(TB_ARTICLE_CONTENT, 'ordernum', "article_id='" . $id . "'")); 
    if ($page > 1) $current_page = intval($page);
    
    $gotoPage = 1; 
    // echo $max_page."|".$current_page;
    if ($max_page > 1) {
        if ($current_page == 1) {
            $gotoPage = $current_page + 1;
            $rtn = " <a href='" . $gotoUrl . "&page=" . $gotoPage . "' title='" . $lang['page_next'] . "'>" . $lang['page_next'] . "</a>\n";
        } else if ($current_page == $max_page) {
            $gotoPage = $current_page-1;
            $rtn = " <a href='" . $gotoUrl . "&page=" . $gotoPage . "' title='" . $lang['page_previous'] . "'>" . $lang['page_previous'] . "</a>\n";
        } else {
            $gotoPage = $current_page-1;
            $rtn .= " <a href='" . $gotoUrl . "&page=" . $gotoPage . "' title='" . $lang['page_previous'] . "'>" . $lang['page_previous'] . "</a>\n";
            $gotoPage = $current_page + 1;
            $rtn .= " <a href='" . $gotoUrl . "&page=" . $gotoPage . "' title='" . $lang['page_next'] . "'>" . $lang['page_next'] . "</a>\n";
        } 
        $rtn .= '&nbsp;';
    } 

    return $rtn;
} 

function createContentJumpMenu() {
    global $db, $page, $id, $act;
    $cur_ordernum = 1;
    if ($page > 1) $cur_ordernum = $page;
    $rtn = '';
    $gotoUrl = basename($_SERVER['PHP_SELF']);
    $gotoUrl .= "?id=" . $id;
    if($act != '') $gotoUrl .= "&act=" . $act;
    $sql = "select id, title,ordernum from " . TB_ARTICLE_CONTENT . " where article_id='" . $id . "' order by ordernum";
    $rs = $db -> Execute($sql);
    while (!$rs -> EOF) {
        $e_s = '';
        $ordernum = $rs -> fields['ordernum'];
        if ($ordernum == $cur_ordernum) {
            $e_s = ' selected';
            $cur_ordernum = '';
        } 
        $rtn .= "<option value='" .$gotoUrl. "&page=" . $ordernum . "' " . $e_s . ">" . $ordernum . "." . $rs -> fields['title'] . "</option>\n";

        $rs -> MoveNext();
    } 
    $rs -> Close();
    return $rtn;
} 

function insertPoll($poll_id = 0) {
    global $db, $notion, $id;
    $uid = 0;
    if (getCookie(COOKIE_UID) != '') {
        $uid = getCookie(COOKIE_UID);
    } 
    $addtime = time();
    $ip = getIP();
    $rtn_poll = true;
    $sql = "insert into " . TB_POLL_LOG . " (notion,poll_id,article_id,uid,addtime,ip) values('$notion','$poll_id','$id','$uid','$addtime','$ip')";
    $rs = $db -> Execute($sql); 
    // echo $sql;
    if ($rs) {
        $rtn_poll = true;
    } else {
        $rtn_poll = false;
    } 
    $rs -> Close();
    return $rtn_poll;
} 

function savePoll() {
    global $lang, $id, $poll_id;
    if ($id == '') return;
    $rtn_poll = true;
    if (is_array($poll_id)) {
        $poll_id_count = count($poll_id);
        for($i = 0; $i < $poll_id_count; $i++) {
            $rtn_poll = insertPoll($poll_id[$i]);
        } 
    } else {
        $rtn_poll = insertPoll($poll_id);
    } 

    $rtn_article = updateArticleViewnum(-1);

    if ($rtn_poll && $rtn_article) {
        showMsg($lang['poll_submitok'], '?id=' . $id . '&act=show');
        addCookie('eifr_post_poll', $id, 3600);
    } else {
        showMsg($lang['addFail']);
    } 
} 

function getPoll($poll_total_count) {
    global $db, $lang, $id;

    $rtn = array();
    $sql = "select id,title,type from " . TB_POLL . " where article_id='" . $id . "' order by ordernum ";
    $rs = $db -> Execute($sql); 
    // echo $sql;
    while (!$rs -> EOF) {
        if ($rs -> fields['type'] == 2) {
            $rs -> fields['eifr_type'] = 'checkbox';
            $rs -> fields['eifr_name'] = 'poll_id[]';
        } else {
            $rs -> fields['eifr_type'] = 'radio';
            $rs -> fields['eifr_name'] = 'poll_id';
        } 
        $poll_num = dbGetRecordCount(TB_POLL_LOG, "poll_id='" . $rs -> fields['id'] . "' and article_id='$id'");
        $poll_rate = $poll_num > 0 ? round($poll_num * 100 / $poll_total_count, 2) : 0;
        $rs -> fields['eifr_poll_num'] = $poll_num;
        $rs -> fields['eifr_poll_rate'] = $poll_rate;

        $rtn[] = $rs -> fields;
        $rs -> MoveNext();
    } 
    $rs -> Close();
    return $rtn;
} 

function getFile() {
	global $id;
	$sql="select id, title, fileurl from ".TB_FILE." where article_id=$id and flag=0 order by ordernum asc";
	return dbGetRecordn($sql);
}

function getRelation() {
    global $article_array, $id;
    $relation_type = $article_array['relation_type'];
    $relation_info = $article_array['relation_info']; 
    // $rtn = array();
    // if($relation_type==0 || $relation_info=='') return $rtn;
    $so_sql = '';
    $limit_sql = '';

    if ($relation_type == 1) { // keyword
        $so_sql .= " and id<>$id and (";
		$key_arr = getArrayWithoutEmpty($relation_info);
        $key_count = count($key_arr);
        for($i = 0;$i < $key_count;$i++) {
            $so_sql .= " relation_info like '%" . $key_arr[$i] . "%' ";
            if ($i == $key_count-1) $so_sql .= " or title like '%" . $key_arr[$i] . "%' ";
            else $so_sql .= " or title like '%" . $key_arr[$i] . "%' or ";
        } 
        $so_sql .= ") ";
        $limit_sql = " limit 10";
    } else if ($relation_type == 2) { // id
        $so_sql = "and  id in (" . $relation_info . ") ";
    } 

    $sql = "select id,title,issuetime from " . TB_ARTICLE . " where flag<3 " . $so_sql . " order by issuetime desc " . $limit_sql . ""; 
    // echo $sql;
    return dbGetRecordn($sql);
} 

function getContentCount() {
    global $id;
    return dbGetRecordCount(TB_ARTICLE_CONTENT, "article_id='$id'");
} 

function getCommentCount() {
    global $id;
    return dbGetRecordCount(TB_COMMENT, "flag<4 and article_id='$id'");
} 

function getPollTotalCount() {
    global $id;
    return dbGetRecordCount(TB_POLL_LOG, "article_id='$id'");
} 

function getPollTotalSelectCount() {
    global $id;
    return dbGetRecordCount(TB_POLL_LOG, "poll_id>0 and article_id='$id'");
} 

function getArticleTemplateIDByChannelID($id) {
    global $db;
    $rtn = 0;
    $id_len = strlen($id);
    if ($id_len > 0) {
        for($i = $id_len; $i >= 2; $i = $i-2) {
            $tmp = substr($id, 0, $i);
            $rtn = dbGetFieldValue(TB_CHANNEL, 'article_template_id', "id='$tmp'");
            if ($rtn > 0) return $rtn;
        } 
    } 

    return $rtn;
} 
// ---start---
if ($tpl_file == '') {
    $tpl_file = 'article';
} 

$id = kRequest('id');
$act = kRequest('act');
if ($act == 'savepoll' && getCookie('eifr_post_poll') != $id) savePoll();

if (!$is_preview && empty($id)) {
    goErrorPage($lang['article_inexistent']);
} 

$channel_parentid = '';
$search_select = '';
$navigation = '';
$cartContents = '';
$article_array = array();
$articleContent = array();

Log_d(__FILE__, __LINE__, "id:($id)");
if (!empty($id)) {
    $article_array = getArticel($id);
    if (!$article_array) {
        goErrorPage($lang['article_inexistent']);
    }
    $articleContent = getArticelContent($id, kGet('page'));
}

if($act=='print') {
    if (!$article_array) {
        $article_array = getTableFill('article');
    } 
    if (!$articleContent) {
        $articleContent = getTableFill('article_content');
    }
    require_once(getTemplatePath('article_print'));
} else if($article_array){
    $template_id = $article_array['template_id'];
    $channel_id = $article_array['channel_id'];
    $channel_parentid = substr($channel_id, 0, 2);

    if ($article_array['type'] == $cfgarr_article_type['redirect'] && $article_array['redirectaddress'] != '') { // redirect url
        if (is_numeric($article_array['redirectaddress'])) {
            Log_d(__FILE__, __LINE__, "Location:article.php?id=" . $article_array['redirectaddress']);
            header("Location:article.php?id=" . $article_array['redirectaddress']);
        } else {
            $rtn_article = updateArticleViewnum(1);
            Log_d(__FILE__, __LINE__, "Location:" . $article_array['redirectaddress']);
            header("Location:" . $article_array['redirectaddress']);
        } 
        exit();
    } else if ($article_array['type'] == $cfgarr_article_type['subject']) {
        $subject_default_file = 'subject.php';
        if ($template_id) {
            $template_array = getTemplateByID($template_id);
        } 
        if ($template_array['program_filename']) {
            $subject_default_file = $template_array['program_filename'];
        } 
        Log_d(__FILE__, __LINE__, "Location:" . $subject_default_file . "?id=" . $id);
        header("Location:" . $subject_default_file . "?id=" . $id);
        exit();
    } 

    if (!$template_id) {
        $template_id = getArticleTemplateIDByChannelID($channel_id);
    } 

    if ($template_id) {
        $template_array = getTemplateByID($template_id);
    } else {
        $template_array = getTemplate('article.php', $tpl_file);
    } 

    if ($template_array['program_filename'] != 'article.php') {
        Log_d(__FILE__, __LINE__, "Location:" . $template_array['program_filename'] . "?id=" . $id);
        header("Location:" . $template_array['program_filename'] . "?id=" . $id);
        exit();
    } 

    if (! isset($article_array['sourcename']) || $article_array['sourcename']=='') {
        $article_array['sourcename'] = SYS_TITLE;
        if (isset($article_array['sourceurl'])) {
            $url_array = parse_url($article_array['sourceurl']);
            if (isset($url_array['host'])) {
                $article_array['sourcename'] = $url_array['host'];
            } 
        } 
    } 

    /**
     * if($article_array['type']==$cfgarr_article_type['shop']) {
     * $clCart = new CCart();
     * $cartContents = $clCart->getCartHtml();
     * }
     */

    $rtn_article = updateArticleViewnum(1);
    $search_select = createChannelsSelect($channel_parentid);
    $navigation = createChannelsNav($channel_id);

    if($act == 'book') {
        $tpl_file = 'book_content';
        if (kGet('tpl') != '') $tpl_file = kGet('tpl') . '_content';
        require_once(getTemplatePath($tpl_file));
    } else {
        require_once(EIFR_ROOT . 'includes/inc_loadtpl.php');
    }
}  else {
    $article_array = getTableFill('article');
    $articleContent = getTableFill('article_content');
    require_once(EIFR_ROOT . 'includes/inc_loadtpl.php');
}
?>
