<?php
/**
 * 
 * @file class_user_repository.php
 * @create date 2007/8/23
 * @copyright (c) 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

require_once(EIFR_ROOT . 'libraries/template.php');

/**
 * ---ComUserRepository---
 * #relation_typ(0:article 1:user 2:url)
 * #status(0:display,1:hidden)
 * #flag (0:unchecked, 1:open, 2:locked, 3:stop, 4:delete)
 */
class ComUserRepository {
    function setFieldRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?	
        global $selectid, $selectValue, $field_name, $field_value;

        if ($selectValue != '') $selectid = $selectValue;
        $sql = "UPDATE " . TB_USER_REPOSITORY . "  set $field_name ='$field_value'  WHERE id in (" . $selectid . ")";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showMsg($lang['modifySuccess'], 'success', 'user_repository.php');
        } else {
            Common::showErrorMsg($lang['modifyFail']);
        } 
    } 

    function deleteRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete'); //have delete authority ?
        global $selectValue;

        $sql = "DELETE FROM " . TB_USER_REPOSITORY . " WHERE id in (" . $selectValue . ")";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showMsg($lang['delSuccess'], 'success', DIR_INSTALL . 'admin/' . $url);
        } else {
            Common::showErrorMsg($lang['delFail']);
        } 
    } 

    function addRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'add'); //have add authority ?	
        global $tag, $relation_type, $relation_info, $ratevalue, $uid, $user_channel_channelid, $status, $flag, $is_getsnapshot, $content;
        $is_manage = Common::checkAdminAuth($url, 'manage');

        $addtime = time();
        $edittime = 0;
        $ip = getIP();
        if (!isset($ratevalue)) $ratevalue = 0;
        if (!$is_manage) {
            $uid = getCookie(COOKIE_UID);
        } 

        if ($relation_type == 2) {
            $relation_info = $this -> getUrl($relation_info);
            if ($is_getsnapshot == 1) $content = addslashes($this -> getWebSnapshot($relation_info));
        } 

        if ($ratevalue == '') $ratevalue = 0;

        $sql = "insert into " . TB_USER_REPOSITORY . " (tag, relation_type, relation_info, ratevalue, content, uid,user_channel_channelid, addtime, edittime, ip, status, flag) values('$tag', '$relation_type', '$relation_info', '$ratevalue', '$content', '$uid', '$user_channel_channelid', '$addtime', '$edittime', '$ip', '$status', '$flag')";
        $rs = $db -> Execute($sql);
        if ($rs) {
            $id = dbGetMaxValue1(TB_USER_REPOSITORY, 'id', "" . TFR_USER_ID . "='$uid'");
            Common::showOkMsg($lang['saveSuccess'], 'user_repository_edit.php', 'user_repository_edit.php?act=edit&selectid=' . $id, 'user_repository.php');
        } else {
            Common::showErrorMsg($lang['addFail']);
        } 
        $rs -> Close();
    } 

    function editRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?
        global $selectid, $selectValue, $tag, $relation_type, $relation_info, $ratevalue, $uid, $user_channel_channelid, $edittime, $status, $flag, $is_getsnapshot, $content;
        $is_manage = Common::checkAdminAuth($url, 'manage');
        if ($selectValue) $selectid = $selectValue;

        if (!isset($ratevalue)) $ratevalue = 0;

        $manage_sql = '';
        if ($is_manage) {
            $manage_sql = ", uid='$uid'";
        } 

        $content_sql = '';
        if ($relation_type == 0) {
            if ($is_getsnapshot == 1) $content_sql = ", content='" . addslashes($this -> getWebSnapshot(SYS_WEBURL . DIR_INSTALL . "/article.php?id=$relation_info")) . "'";
            else if ($is_getsnapshot == 2) $content_sql = ", content=''";
        } else if ($relation_type == 2) {
            $relation_info = $this -> getUrl($relation_info);
            if ($is_getsnapshot == 1) $content_sql = ", content='" . addslashes($this -> getWebSnapshot($relation_info)) . "'";
            else if ($is_getsnapshot == 2) $content_sql = ", content='$content'";
        } 

        if ($ratevalue == '') $ratevalue = 0;

        $sql = "update " . TB_USER_REPOSITORY . " set tag='$tag',relation_info='$relation_info',ratevalue='$ratevalue',user_channel_channelid='$user_channel_channelid',edittime='$edittime',status='$status',flag='$flag'" . $manage_sql . $content_sql . " where id=" . $selectid . "";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if ($rs) {
            Common::showOkMsg($lang['saveSuccess'], 'user_repository_edit.php', 'user_repository_edit.php?act=edit&selectid=' . $selectid, 'user_repository.php');
        } else {
            Common::showErrorMsg($lang['modifyFail']);
        } 
        $rs -> Close();
    } 

    function layout_user_repository() {
        global $db, $lang, $url;
        global $search_field, $search_keyword, $order_type, $order_field, $relation_type, $user_channel_channelid, $flag;
        $is_manage = Common::checkAdminAuth($url, 'manage');

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        // show list---start---
        $sql_str = '';
        if (!$is_manage) {
            $sql_str .= "  and flag<>4 and uid=" . getCookie(COOKIE_UID) . " ";
        } 
        if ($flag != '') {
            $sql_str .= " and flag='" . $flag . "' ";
        } 

        if ($relation_type != '' && $relation_type != '-1') {
            $sql_str .= " and relation_type='" . $relation_type . "' ";
        } 

        if ($user_channel_channelid != '') {
            $sql_str .= " and user_channel_channelid like'" . $user_channel_channelid . "%' ";
        } 

        $search_sql = '';

        if ($search_keyword != '') {
            $search_sql = $this -> getRelationRecordSql($search_keyword, $is_manage);
        } 

        if (!isset($order_field)) $order_field = 'id';
        if ($order_field == '') $order_field = 'id';

        if (!isset($order_type)) $order_type = 'desc';
        if ($order_type == '') $order_type = 'desc';

        $order_sql = " order by " . $order_field . "  " . $order_type . " ";

        $sql = "select * from " . TB_USER_REPOSITORY . " where 1 " . $sql_str . $search_sql . $order_sql;
        $clPages = new Pages();
        $clPages -> query_string = 'relation_type=' . $relation_type . '&user_channel_channelid=' . $user_channel_channelid . '&flag=' . $flag . '&order_field=' . $order_field . '&order_type=' . $order_type . '&search_field=' . $search_field . '&search_keyword=' . $search_keyword . '';
        $clPages -> query_sql = $sql;
        $aryResult = $clPages -> Execute();
        $rs = $aryResult[0];
        $intList = $aryResult[2];

        if ($intList > 0) {
            $num = 0;
            while (!$rs -> EOF) {
                $num++;
                $show_link = '';
                switch ($rs -> fields['relation_type']) {
                    case 0:
                        $relation_link = DIR_INSTALL . '/article.php?id=' . $rs -> fields['relation_info'];
                        $relation_info = dbGetFieldValue(TB_ARTICLE, 'title', " id='" . $rs -> fields['relation_info'] . "'");
                        break;
                    case 1:
                        $relation_link = '';
                        $relation_info = dbGetFieldValue(TB_USER, TF_USER_NICK, "" . TF_USER_ID . " ='" . $rs -> fields['relation_info'] . "'");
                        break;
                    case 2:
                        $relation_link = $rs -> fields['relation_info'];
                        $relation_info = $this -> getDomainUrl($rs -> fields['relation_info']);

                        break;
                    default:
                        $relation_link = '';
                        $relation_info = $rs -> fields['relation_info'];
                        break;
                } 

                if ($rs -> fields['content'] != '') $show_link = "<a href='user_repository_snapshot.php?selectid=" . $rs -> fields['id'] . "' target='_blank'><img src='" . SYS_ADMIN_STYLE_PATH . "images/camera_photo.gif' border='0' align='absmiddle'></a>";

                $clTemplate -> assign_block_vars('ListUserRepository', array('num' => $num,
                        'id' => $rs -> fields['id'],
                        'uid' => $rs -> fields[TF_USER_ID],
                        'user_channel_channelid' => $rs -> fields[TFR_USER_CHANNEL_ID],
                        'username' => dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $rs -> fields[TFR_USER_ID] . "'"),
                        'nickname' => dbGetFieldValue(TB_USER, TF_USER_NICK, "" . TF_USER_ID . " ='" . $rs -> fields[TFR_USER_ID] . "'"),
                        'tag' => $rs -> fields['status']? '' : $rs -> fields['tag'],
                        'relation_type' => $lang['user_repository_relation_type_arr'][$rs -> fields['relation_type']],
                        'relation_info' => $relation_info,
                        'relation_link' => $relation_link,
                        'show_link' => $show_link,
                        'ratevalue' => $rs -> fields['ratevalue'],
                        'ip' => $rs -> fields['ip'],
                        'addtime' => getDateTimeMk($rs -> fields['addtime']),
                        'edittime' => getDateTimeMk($rs -> fields['edittime']),
                        'status' => $rs -> fields['status']? Common::createFlagTxt('hidden') : Common::createFlagTxt('display'),
                        'flag' => Common::createFlagShow($rs -> fields['flag'])
                        ));

                $rs -> MoveNext();
            } 
        } 
        $rs -> Close(); 
        // show list---end---
        $list_flag = '';
        $btn_delete_forever = '';
        $btn_flag = '';
        if ($is_manage) {
            $list_flag .= '<select name="flag" class="input_select" ><option value="">---' . $lang['flag'] . '---</option>';
            $list_flag .= Common::createFlagSelect($flag);
            $list_flag .= '</select>';

            $btn_delete_forever = Common::createToolbar($url, 'delete_forever', 'user_repository.php?act=delete_forever');

            $btn_flag .= Common::createSplitLine();
            $btn_flag .= Common::createToolbar($url, 'unchecked', 'user_repository.php?act=setvalue&field_name=flag&field_value=0');
            $btn_flag .= Common::createToolbar($url, 'open', 'user_repository.php?act=setvalue&field_name=flag&field_value=1');
            $btn_flag .= Common::createToolbar($url, 'locked', 'user_repository.php?act=setvalue&field_name=flag&field_value=2');
            $btn_flag .= Common::createToolbar($url, 'stop', 'user_repository.php?act=setvalue&field_name=flag&field_value=3');
        } 

        $toolbar = Common::createToolbar($url, 'add', 'user_repository_edit.php');
        $toolbar .= Common::createToolbar($url, 'edit', 'user_repository_edit.php?act=edit');
        $toolbar .= Common::createToolbar($url, 'delete', 'user_repository.php?act=setvalue&field_name=flag&field_value=4');
        $toolbar .= $btn_delete_forever;
        $toolbar .= $btn_flag; 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => $toolbar,
                'order_field' => $order_field,
                'order_type' => $order_type,
                'list_flag' => $list_flag,
                'list_relation_type' => $this -> createRelationTypeSelect($relation_type),
                'list_user_channel' => Common::creatClassSelect(TB_USER_CHANNEL, TF_USER_CHANNEL_ID, $user_channel_channelid, "uid=" . getCookie(COOKIE_UID)),
                'pagenext' => $aryResult[3]
                ));

        $clTemplate -> set_filenames(array('body' => 'user_repository.tpl.html'));
        $clTemplate -> pparse("body");
    } 

    function layout_user_repository_edit() {
        global $db, $lang, $url;
        global $selectid, $selectValue, $uid, $act;

        if ($selectValue) $selectid = $selectValue;

        $tplfile = 'user_repository_edit.tpl.html';

        $is_manage = Common::checkAdminAuth($url, 'manage');
        $style_display = 'none';
        $isUrlOpen = @ini_get("allow_url_fopen");
        $is_getsnapshot = $isUrlOpen? '' : ' disabled';

        if ($is_manage) {
            $style_display = '';
        } 
        if ($act == 'edit') { // edit
            Common::checkAdminExeAuth($url, 'edit');

            $toolbar = Common::createToolbar($url, 'save', 'user_repository_edit.php?act=save');
            $toolbar .= Common::createToolbar($url, 'delete', 'user_repository.php?act=setvalue&field_name=flag&field_value=4');
            if ($is_manage) {
                $toolbar .= Common::createToolbar($url, 'delete_forever', 'user_repository.php?act=delete_forever');
            } 

            $is_edit = '';

            $sql = "select * from " . TB_USER_REPOSITORY . " where id='" . $selectid . "'";
            $rs = $db -> Execute($sql); 
            // echo $sql;
            if (!$rs -> EOF) {
                $tplfile = 'user_repository_' . $rs -> fields['relation_type'] . '_edit.tpl.html';

                if (!$is_manage) {
                    $is_edit = ' disabled';
                } 

                switch ($rs -> fields['relation_type']) {
                    case 0:
                        $relation_link = DIR_INSTALL . '/article.php?id=' . $rs -> fields['relation_info'];
                        $relation_info_show = dbGetFieldValue(TB_ARTICLE, 'title', " id='" . $rs -> fields['relation_info'] . "'");

                        break;
                    case 1:
                        $relation_link = '';
                        $relation_info_show = dbGetFieldValue(TB_USER, TF_USER_NICK, "" . TF_USER_ID . " ='" . $rs -> fields['relation_info'] . "'");
                        break;
                    case 2:
                        $relation_link = $rs -> fields['relation_info'];
                        $relation_info_show = $rs -> fields['relation_info'];
                        break;
                    default:
                        $relation_link = '';
                        $relation_info_show = $rs -> fields['relation_info'];
                        break;
                } 

                $content_html = '';
                $content_show = '';
                if ($rs -> fields['content'] != '') {
                    $content_show = "<a href='user_repository_snapshot.php?selectid=$selectid' target='_blank'><img src='" . SYS_ADMIN_STYLE_PATH . "images/camera_photo.gif' border='0' align='absmiddle'></a>";

                    $content_html = $this -> HTMLEncode2($rs -> fields['content']);
                } 

                $id = $rs -> fields['id'];
                $tag = $rs -> fields['tag'];
                $relation_type = $rs -> fields['relation_type'];
                $relation_type_show = $lang['user_repository_relation_type_arr'][$rs -> fields['relation_type']];
                $relation_info = $rs -> fields['relation_info'];
                $ratevalue = $rs -> fields['ratevalue'];
                $content = $rs -> fields['content'];
                $uid = $rs -> fields[TFR_USER_ID];
                $username = dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $uid . "'");
                $nickname = dbGetFieldValue(TB_USER, TF_USER_NICK, "" . TF_USER_ID . " ='" . $uid . "'");
                $user_channel_channelid = $rs -> fields[TFR_USER_CHANNEL_ID];
                $list_user_channel = Common::creatClassSelect(TB_USER_CHANNEL, TF_USER_CHANNEL_ID, $user_channel_channelid, "uid=" . getCookie(COOKIE_UID));
                $addtime = getDateTimeMk($rs -> fields['addtime']);
                $edittime = getDateTimeMk($rs -> fields['edittime']);
                $ip = $rs -> fields['ip'];
                $status = Common::creatStatusRadio($rs -> fields['status']);
                $flag = Common::createFlagRadio($rs -> fields['flag']);

                if (!$is_manage) {
                    if ($uid != getCookie(COOKIE_UID)) {
                        Common::showWarningMsg($lang['checkAuth']);
                    } 
                } 

                $rs -> Close();
            } else {
                $rs -> Close();
                Common::showWarningMsg($lang['records_inexistence']);
            } 
        } else { // add
            $tplfile = 'user_repository_2_edit.tpl.html';
            Common::checkAdminExeAuth($url, 'add');

            $toolbar = Common::createToolbar($url, 'save', 'user_repository_edit.php?act=save');
            $id = '';
            $tag = '';
            $relation_type = 2;
            $relation_type_show = $lang['user_repository_relation_type_arr'][2];
            $relation_info = '';
            $relation_info_show = '';
            $content = '';
            $content_html = '';
            $content_show = '';
            $relation_link = '';
            $ratevalue = '';
            $status = Common::creatStatusRadio(0);
            $flag = $is_manage ? Common::createFlagRadio(0) : Common::createFlagTxt(0);
            $uid = 0;
            $username = '';
            $nickname = '';
            $user_channel_channelid = '';
            $list_user_channel = Common::creatClassSelect(TB_USER_CHANNEL, TF_USER_CHANNEL_ID, $user_channel_channelid, "uid=" . getCookie(COOKIE_UID));
            $addtime = getDateTimeMk(time());
            $edittime = '';
            $ip = getIP();
        } 

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'css_path' => DIR_INSTALL . 'admin/style/',
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => $toolbar
                )); 
        // data
        $clTemplate -> assign_vars(array('selectid' => $selectid,
                'style_display' => $style_display,
                'id' => $id,
                'tag' => $tag,
                'relation_type' => $relation_type,
                'relation_type_show' => $relation_type_show,
                'relation_info' => $relation_info,
                'relation_info_show' => $relation_info_show,
                'relation_link' => $relation_link,
                'ratevalue' => $ratevalue,
                'is_getsnapshot' => $is_getsnapshot,
                'content' => $content,
                'content_html' => $content_html,
                'content_show' => $content_show,
                'status' => $status,
                'flag' => $flag,
                'uid' => $uid,
                'username' => $username,
                'nickname' => $nickname,
                'user_channel_channelid' => $user_channel_channelid,
                'list_user_channel' => $list_user_channel,
                'ip' => $ip,
                'ip' => $ip,
                'addtime' => $addtime,
                'edittime' => $edittime
                ));

        $clTemplate -> set_filenames(array('body' => $tplfile));
        $clTemplate -> pparse("body");
    } 

    function layout_user_repository_snapshot() {
        global $db, $lang, $url;
        global $selectid, $selectValue;

        if ($selectValue) $selectid = $selectValue;

        $sql = "select * from " . TB_USER_REPOSITORY . " where id='" . $selectid . "'";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if (!$rs -> EOF) {
            $is_manage = Common::checkAdminAuth($url, 'manage');
            if (!$is_manage) {
                if ($rs -> fields[TFR_USER_ID] != getCookie(COOKIE_UID)) {
                    $rs -> Close();
                    Common::showWarningMsg($lang['checkAuth']);
                } 
            } 
            $basestr = "<base href='" . $rs -> fields['relation_info'] . "'>\n<meta http-equiv='Content-Type' Content='text/html; charset=" . SYS_CHARSET . "'>\n";
            echo $basestr . $rs -> fields['content'];
        } 
        $rs -> Close();
    } 

    function createRelationTypeRadio($type = -1) {
        global $lang;
        $rtn = '';
        for($i = 0; $i < count($lang['user_repository_relation_type_arr']);$i++) {
            $e_s = '';
            if ($i == $type) {
                $e_s = ' checked';
                $type = '';
            } 
            $showvalue = $lang['user_repository_relation_type_arr'][$i];
            $rtn .= "<input type='radio' name='relation_type' value='" . $i . "' " . $e_s . ">" . $showvalue . "&nbsp;\n";
        } 

        return $rtn;
    } 

    function createRelationTypeSelect($flag = -1) {
        global $lang;
        $rtn = '';
        if (!is_numeric($flag)) $flag = -1;
        $flag = intval($flag);
        $relation_ary = array($lang['type_select']);
        $relation_ary = array_merge($relation_ary, $lang['user_repository_relation_type_arr']);
        $j = -1;
        for($i = 0; $i < count($relation_ary);$i++, $j++) {
            $e_s = '';
            if ($j === $flag) {
                $e_s = ' selected';
                $flag = '';
            } 
            $showvalue = $relation_ary[$i];
            $rtn .= "<option value='" . $j . "' " . $e_s . ">" . $showvalue . "</option>\n";
        } 

        return $rtn;
    } 

    function getRelationRecordSql($search_keyword = '', $is_manage = false) {
        global $db;

        $rtn = '';
        if ($search_keyword == '') return $rtn;

        $id_ary = array();

        $sql_str = '';
        if (!$is_manage) {
            $sql_str .= "  and flag<>4 and uid=" . getCookie(COOKIE_UID) . " ";
        } 
        // article---start
        $article_ary = array();
        $sql = "select relation_info from " . TB_USER_REPOSITORY . " where relation_type=0 " . $sql_str;
        $rs = $db -> Execute($sql);
        while (!$rs -> EOF) {
            if ($rs -> fields['relation_info'])
                $article_ary[] = $rs -> fields['relation_info'];
            $rs -> MoveNext();
        } 
        $rs -> Close();

        $article_list = implode(',', $article_ary);
        if ($article_list != '') {
            $sql = "select id from " . TB_ARTICLE . " where id in ($article_list) and title like '%$search_keyword%' order by id desc ";
            $rs = $db -> Execute($sql);
            while (!$rs -> EOF) {
                $id_ary[] = "relation_info='" . $rs -> fields['id'] . "'";
                $rs -> MoveNext();
            } 
            $rs -> Close();
        } 
        // article---end
        // user---start
        $user_ary = array();
        $sql = "select relation_info from " . TB_USER_REPOSITORY . " where relation_type=1 " . $sql_str;
        $rs = $db -> Execute($sql);
        while (!$rs -> EOF) {
            if ($rs -> fields['relation_info'])
                $user_ary[] = $rs -> fields['relation_info'];
            $rs -> MoveNext();
        } 
        $rs -> Close();

        $user_list = implode(',', $user_ary);
        if ($user_list != '') {
            $sql = "select " . TF_USER_ID . " from " . TB_USER . " where " . TF_USER_ID . " in ($user_list) and " . TF_USER_NICK . " like '%$search_keyword%' order by " . TF_USER_ID . " desc ";
            $rs = $db -> Execute($sql);
            while (!$rs -> EOF) {
                $id_ary[] = "relation_info='" . $rs -> fields[TF_USER_ID] . "'";
                $rs -> MoveNext();
            } 
            $rs -> Close();
        } 
        // user---end
        $id_ary = array_unique($id_ary);

        $id_ary[] = " relation_info  like '%$search_keyword%'";
        $id_ary[] = " tag  like '%$search_keyword%'";

        if (count($id_ary) > 0) {
            $id_sql = implode(' or ', $id_ary);
            $rtn = " and ( $id_sql )";
        } 

        return $rtn;
    } 

    function createUserChannelIdList($uid, $channelid_list = '') {
        global $db;
        $rtn = '';
        if ($channelid_list != '') {
            $sql = "select channelid,title from " . TB_USER_CHANNEL . " where uid='$uid' and channelid in ($channelid_list) order by ordernum ";
            $rs = $db -> Execute($sql);
            while (!$rs -> EOF) {
                $title = $this -> getUserChannelTile($uid, $rs -> fields['channelid']);
                $rtn .= "<option value='" . $rs -> fields['channelid'] . "' selected>$title</option>\n";
                $rs -> MoveNext();
            } 
            $rs -> Close();
        } 

        return $rtn;
    } 

    function getUserChannelTile($uid, $channelid = '') {
        global $db;
        $rtn = '';
        $tmp_ary = array();
        $channelidlen = strlen($channelid);
        if ($channelidlen > 0) {
            for($i = 2; $i <= $channelidlen; $i = $i + 2) {
                $tmp = substr($channelid, 0, $i);
                $sql = "select title from " . TB_USER_CHANNEL . " where uid='$uid' and channelid='$tmp' order by ordernum ";
                $rs = $db -> Execute($sql);
                if (!$rs -> EOF) {
                    $tmp_ary[] = $rs -> fields['title'];
                } 
                $rs -> Close();
            } 
        } 
        $rtn = implode(' -> ', $tmp_ary);

        return $rtn;
    } 

    function getUrl($url) {
        $str = $url;
        if (strpos($url, '://') === false) {
            $str = 'http://' . $url;
        } 

        return $str;
    } 

    function getDomainUrl($url) {
        $str = '';

        $url_ary = explode('://', $url);
        $str .= $url_ary[0] . '://';
        if (strpos($url_ary[1], '/') === false) {
            $str .= $url_ary[1];
        } else {
            $url_ary1 = explode('/', $url_ary[1]);
            $str .= $url_ary1[0] . '/';
        } 

        return $str;
    } 

    function getWebSnapshot($url) {
        $rtn = '';
        $isUrlOpen = @ini_get("allow_url_fopen");
        if ($isUrlOpen) {
            $data = null;
            $data = file_get_contents($url);
            if ($data) {
                $rtn = $data;
            } 
        } 

        return $rtn;
    } 

    function HTMLEncode($str) {
        $str = str_replace("&gt;", ">", $str);
        $str = str_replace("&lt;", "<", $str);
        return $str;
    } 

    function HTMLEncode2($str) {
        $str = str_replace(">", "&gt;", $str);
        $str = str_replace("<", "&lt;", $str);
        return $str;
    } 
} 

?>
