<?php
/**
 * 
 * @file class_user_channel.php
 * @copyright (c) 2005 - 2011 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

/**
 * ---ComUserChannel---
 * status(0:display,1:hidden)
 * flag(1:open,2:locked,3:stop)
 */
class ComUserChannel {
    function deleteRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete'); //have delete authority ?
        global $selectid, $selectValue;

        if ($selectValue != '') $selectid = $selectValue;

        $uid = '';
        $channelid = '';
        $sql = "select * from " . TB_USER_CHANNEL . " where id='" . $selectid . "'";
        $rs = $db -> Execute($sql);
        if (!$rs -> EOF) {
            $uid = $rs -> fields[TFR_USER_ID];
            $channelid = $rs -> fields['channelid'];
        } 
        $rs -> Close();

        if (!Common::checkAdminAuth($url, 'manage')) {
            if ($uid != getCookie(COOKIE_UID)) {
                Common::showWarningMsg($lang['checkAuth']);
            } 
        } 

        if ($uid != '' && $channelid != '') {
            $sql = "DELETE FROM " . TB_USER_CHANNEL . " where uid='$uid' and channelid like '" . $channelid . "%'";
            $rs = $db -> Execute($sql);
            if ($rs) {
                Common::showMsg($lang['delSuccess'], 'success', DIR_INSTALL . 'admin/' . $url);
            } else {
                Common::showErrorMsg($lang['delFail']);
            } 
            $rs -> Close();
        } 
    } 

    function addRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'add'); //have add authority ?
        global $title, $intro, $redirecturl, $fileurl, $status, $flag, $uid, $parentid, $channelid;
        $parentid = $channelid;
        if (!Common::checkAdminAuth($url, 'manage')) {
            if ($uid != getCookie(COOKIE_UID)) {
                Common::showWarningMsg($lang['checkAuth']);
            } 
        } 

        $toaddurl = '';
        if ($uid == getCookie(COOKIE_UID)) $toaddurl = 'user_channel_edit.php';

        $ordernum = dbGetMaxValue1(TB_USER_CHANNEL, 'ordernum', " uid='$uid' and channelid like '" . $parentid . "__'");

        $sql = "select max(channelid) as channelid from " . TB_USER_CHANNEL . " where uid='$uid' and channelid like '" . $parentid . "__'";
        $rs = $db -> Execute($sql);

        if ($parentid) {
            $id_pos = substr($rs -> fields['channelid'], strlen($parentid), 2);
            $id_pos += 1;
            Common::checkOverMaxNum($id_pos, MAX_CATEGORYID);

            if (strlen($id_pos) < 2) {
                $id_pos = "0" . $id_pos;
            } 
            $channelid = $parentid . $id_pos;
        } else {
            $channelid = $rs -> fields['channelid'] + 1;
            Common::checkOverMaxNum($channelid, MAX_CATEGORYID);
        } 

        if (strlen($channelid) < 2) {
            $channelid = "0" . $channelid;
        } 

        Common::checkOverMaxNum(strlen($channelid), MAX_CATEGORYID_LEN);

        $addtime = time();
        $ip = getIP();
        $title = sTextEncode($title);
        $sql = "insert into " . TB_USER_CHANNEL . " (channelid,title,fileurl,redirecturl,ordernum,intro,status,flag,uid,ip,addtime) values('$channelid','$title','$fileurl','$redirecturl','$ordernum','$intro','$status','$flag','$uid','$ip','$addtime')"; 
        // echo $sql;
        $rs = $db -> Execute($sql);
        if ($rs) {
            $id = dbGetMaxValue1(TB_USER_CHANNEL, 'id', "uid=$uid");
            Common::showOkMsg($lang['addSuccess'], $toaddurl, 'user_channel_edit.php?act=edit&selectid=' . $id, "user_channel.php?uid=$uid");
        } else {
            Common::showErrorMsg($lang['addFail']);
        } 
        $rs -> Close();
    } 

    function editRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?
        global $selectid, $selectValue, $title, $intro, $redirecturl, $fileurl, $status, $flag, $uid, $template_id;

        if (!Common::checkAdminAuth($url, 'manage')) {
            if ($uid != getCookie(COOKIE_UID)) {
                Common::showWarningMsg($lang['checkAuth']);
            } 
        } 

        $toaddurl = 'user_channel_edit.php';
        if ($uid != getCookie(COOKIE_UID)) $toaddurl = '';

        if ($selectValue) $selectid = $selectValue;
        $title = sTextEncode($title);
        if ($template_id == '') $template_id = 0;
        $sql = "update " . TB_USER_CHANNEL . " set title='$title', fileurl='$fileurl', intro='$intro',  redirecturl='$redirecturl', status='$status', flag='$flag', uid='$uid' where id='$selectid'";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showOkMsg($lang['saveSuccess'], $toaddurl, 'user_channel_edit.php?act=edit&selectid=' . $selectid, "user_channel.php?uid=$uid");
        } else {
            Common::showErrorMsg($lang['saveFail']);
        } 
        $rs -> Close();
    } 

    function copyRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'add'); //have add authority ?
        global $selectValue, $title, $intro, $template_id, $redirecturl, $fileurl, $status, $flag, $uid;

        if (!Common::checkAdminAuth($url, 'manage')) {
            if ($uid != getCookie(COOKIE_UID)) {
                Common::showWarningMsg($lang['checkAuth']);
            } 
        } 
        $toaddurl = 'user_channel_edit.php';
        if ($uid != getCookie(COOKIE_UID)) $toaddurl = '';

        $parentid = substr($selectValue, 0, strlen($selectValue)-2);

        $ordernum = dbGetMaxValue1(TB_USER_CHANNEL, 'ordernum', " channelid like '" . $parentid . "__'");

        $sql = "select max(channelid) as channelid from " . TB_USER_CHANNEL . " where uid='$uid' and channelid like '" . $parentid . "__'";
        $rs = $db -> Execute($sql);

        if ($parentid) {
            $id_pos = substr($rs -> fields['channelid'], strlen($parentid), 2);
            $id_pos += 1;
            Common::checkOverMaxNum($id_pos, MAX_CATEGORYID);

            if (strlen($id_pos) < 2) {
                $id_pos = "0" . $id_pos;
            } 
            $channelid = $parentid . $id_pos;
        } else {
            $channelid = $rs -> fields['channelid'] + 1;
            Common::checkOverMaxNum($channelid, MAX_CATEGORYID);
        } 

        if (strlen($channelid) < 2) {
            $channelid = "0" . $channelid;
        } 

        Common::checkOverMaxNum(strlen($channelid), MAX_CATEGORYID_LEN);

        $title .= '[copy]';
        $addtime = time();
        $ip = getIP();
        $title = sTextEncode($title);
        if ($template_id == '') $template_id = 0;

        $sql = "insert into " . TB_USER_CHANNEL . " (channelid,title,fileurl,redirecturl,ordernum,intro,status,flag,uid,ip,addtime) values('$channelid','$title','$fileurl','$redirecturl','$ordernum','$intro','$status','$flag','$uid','$ip','$addtime')";
        $rs = $db -> Execute($sql);
        if ($rs) {
            $id = dbGetMaxValue1(TB_USER_CHANNEL, 'id', "uid=$uid");
            Common::showOkMsg($lang['addSuccess'], $toaddurl, 'user_channel_edit.php?act=edit&selectid=' . $id, "user_channel.php?uid=$uid");
        } else {
            Common::showErrorMsg($lang['addFail']);
        } 
        $rs -> Close();
    } 

    function orderbyRecords($uid) {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?
        global $channelid, $act;

        $is_manage = Common::checkAdminAuth($url, 'manage');
        if (!$is_manage) {
            if ($uid != getCookie(COOKIE_UID)) {
                Common::showWarningMsg($lang['checkAuth']);
            } 
        } 

        if ($channelid == '') return;
        $rootid = substr($channelid, 0, 2);

        $rs_1 = $db -> Execute("select channelid,ordernum from " . TB_USER_CHANNEL . "  where uid='$uid' and channelid='" . $channelid . "'");
        if ($act == 'up') {
            $sql2 = "select channelid,ordernum from " . TB_USER_CHANNEL . " where uid='$uid' and ordernum<" . $rs_1 -> fields['ordernum'] . " and length(channelid)=" . strlen($rs_1 -> fields['channelid']) . " order by ordernum desc limit 1";
            $rs_2 = $db -> Execute($sql2);
        } 
        if ($act == 'down') {
            $sql2 = "select channelid,ordernum from " . TB_USER_CHANNEL . " where uid='$uid' and ordernum>" . $rs_1 -> fields['ordernum'] . " and length(channelid)=" . strlen($rs_1 -> fields['channelid']) . " order by ordernum asc limit 1";
            $rs_2 = $db -> Execute($sql2);
        } 

        $up_1 = $db -> Execute("update " . TB_USER_CHANNEL . " set ordernum='" . $rs_2 -> fields['ordernum'] . "' where uid='$uid' and channelid='" . $rs_1 -> fields['channelid'] . "'");
        $up_2 = $db -> Execute("update " . TB_USER_CHANNEL . " set ordernum='" . $rs_1 -> fields['ordernum'] . "' where uid='$uid' and channelid='" . $rs_2 -> fields['channelid'] . "'");

        $rs_1 -> Close();
        $rs_2 -> Close();
        $up_1 -> Close();
        $up_2 -> Close();
        Common::showMsg('', '', DIR_INSTALL . 'admin/' . $url . "?uid=$uid&rootid=$rootid");
    } 

    function layout_user_channel($uid = '') {
        global $db, $clTemplate, $url; 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'menu_nav' => Common::createAdminMenuNav($url),
                'uid' => $uid,
                'username' => dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $uid . "'"),
                'toolbar' => Common::createToolbar($url, 'add', 'user_channel_edit.php') . Common::createToolbar($url, 'edit', 'user_channel_edit.php?act=edit') . Common::createToolbar($url, 'delete', 'user_channel.php?act=delete')
                ));
        $this -> user_channel_show($uid);

        $clTemplate -> set_filenames(array('body' => 'user_channel.tpl.html'));
        $clTemplate -> pparse("body");
    } 

    function user_channel_show($uid, $parentid = '') {
        global $db, $clTemplate, $url;
        global $rootid;
        static $num = 0; 
        // show list---start---
        $sqlstr = '';
        $isedit = Common::checkAdminAuth($url, 'edit');

        $sql = "select * from " . TB_USER_CHANNEL . " where uid='$uid' and channelid like '" . $parentid . "__' " . $sqlstr . " order by ordernum ";
        $rs = $db -> Execute($sql); 
        // echo $sql.'<br/>';
        while (!$rs -> EOF) {
            $num++;
            $id = $rs -> fields['id'];
            $channelid = $rs -> fields['channelid'];
            $tr_id = ' id="' . $channelid . '"';
            $depth = strlen($channelid)-2;
            $spaces = '';
            $is_orderby = false;
            $is_disabled = '';

            if ($rootid == substr($channelid, 0, 2)) {
                $is_orderby = true;
            } 
            if ($depth == 0) { // first floor
                    $orderby = '<b>' . $rs -> fields['ordernum'] . '</b>';
                $tr_css = 'list_parent_tr_bg';
                $td_css = 'list_parent_td_bg';

                $tr_style = ' style="display:"';
                $tr_onmouse = 'onMouseOver="this.className=\'list_mouseover_tr_bg\'" onMouseOut="this.className=\'list_parent_tr_bg\'"';
                $td_onmouse = 'onMouseOver="this.className=\'list_mouseover_td_bg\'" onMouseOut="this.className=\'list_parent_td_bg\'"';
            } else {
                $spaces = str_repeat("&nbsp;&nbsp;", $depth);
                $orderby = '' . $rs -> fields['ordernum'] . '';
                $tr_css = 'list_sub_tr_bg';
                $td_css = 'list_sub_td_bg';

                $tr_style = $is_orderby? ' style="display:"' : ' style="display:none"';
                $tr_onmouse = 'onMouseOver="this.className=\'list_mouseover_tr_bg\'" onMouseOut="this.className=\'list_sub_tr_bg\'"';
                $td_onmouse = 'onMouseOver="this.className=\'list_mouseover_td_bg\'" onMouseOut="this.className=\'list_sub_td_bg\'"';
            } 

            if (dbGetRecordCount(TB_USER_CHANNEL, "uid='$uid' and channelid like '" . $channelid . "__' " . $sqlstr . "") > 0) { // sub menu
                    if ($depth > 0)
                        $show_arrow = "<a href=\"javascript:showSubClassTr('" . $channelid . "','" . SYS_ADMIN_STYLE_PATH . "images/')\" ><img id='img" . $channelid . "' src='" . SYS_ADMIN_STYLE_PATH . "images/minus.gif' border='0'></a>";
                    else
                        $show_arrow = "<a href=\"javascript:showSubClassTr('" . $channelid . "','" . SYS_ADMIN_STYLE_PATH . "images/')\" ><img id='img" . $channelid . "' src='" . SYS_ADMIN_STYLE_PATH . "images/plus.gif' border='0'></a>";
                } else {
                    $show_arrow = '';
                } 

                if ($isedit) { // is to show orderby ?
                        $orderby = Common::createOrderBy('', "&uid=$uid&channelid=$channelid");
                } 

                $clTemplate -> assign_block_vars('ListChannel', array('tr_id' => $tr_id,
                        'tr_css' => $tr_css,
                        'td_css' => $td_css,
                        'tr_onmouse' => $tr_onmouse,
                        'td_onmouse' => IS_ONMOUSE_TD? $td_onmouse : '',
                        'tr_style' => $tr_style,
                        'show_arrow' => $show_arrow,
                        'num' => $num,
                        'id' => $id,
                        'channelid' => $channelid,
                        'title' => $spaces . '|-' . $rs -> fields['title'],
                        'orderby' => $orderby,
                        'intro' => Common::showTxtAb($rs -> fields['intro'], 20, '...'),
                        'status' => $rs -> fields['status']? Common::createFlagTxt('hidden') : Common::createFlagTxt('display'),
                        'flag' => Common::createFlagShow($rs -> fields['flag']),
                        'ip' => $rs -> fields['ip'],
                        'addtime' => $rs -> fields['addtime']? getDateTimeMk($rs -> fields['addtime']) : '',
                        'is_disabled' => $is_disabled
                        ));

                $this -> user_channel_show($uid, $channelid);
                $rs -> MoveNext();
            } 
            $rs -> Close(); 
            // show list---end---
        } 

        function layout_user_channel_edit() {
            global $db, $lang, $clTemplate, $url;
            global $selectid, $selectValue, $act;

            if ($selectValue) $selectid = $selectValue;
            $display_parent = '';
            $template_id = '';
            $template_title = '';
            if ($act == 'edit') {
                Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?	
                $toolbar = Common::createToolbar($url, 'save', 'user_channel_edit.php?act=save_edit') . Common::createToolbar($url, 'copy', 'user_channel_edit.php?act=copy') . Common::createToolbar($url, 'delete', 'user_channel.php?act=delete');

                $sql = "select * from " . TB_USER_CHANNEL . " where id='" . $selectid . "'";
                $rs = $db -> Execute($sql);
                if (!$rs -> EOF) {
                    $selectid = $rs -> fields['id'];
                    $channelid = $rs -> fields['channelid'];
                    $selected_channelid = substr($channelid, 0, strlen($channelid)-2);
                    $uid = $rs -> fields[TFR_USER_ID];
                    $list_channel = Common::creatClassSelect(TB_USER_CHANNEL, 'channelid', $selected_channelid, "uid=$uid");
                    if (strlen($channelid) == 2) $display_parent = 'none';
                    $title = $rs -> fields['title'];
                    $intro = $rs -> fields['intro'];
                    $redirecturl = $rs -> fields['redirecturl'];
                    $fileurl = $rs -> fields['fileurl']? $rs -> fields['fileurl'] : '';
                    $show_img = $rs -> fields['fileurl']? "<img src='" . CSafeData::getImgSrc($rs -> fields['fileurl']) . "' align='absmiddle'>" : '';
                    $status = Common::creatStatusRadio($rs -> fields['status']);
                    $flag = $this -> createFlagRadio($rs -> fields['flag']);

                    $username = dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $uid . "'");
                    $is_edit = ' disabled';
                    $isdisabled = Common::checkAdminAuth($url, 'manage')? '' : ' disabled';
                    $addtime = getDateTimeMk($rs -> fields['addtime']);
                    $ip = $rs -> fields['ip'];
                } 
                $rs -> Close();
            } else { // add
                Common::checkAdminExeAuth($url, 'add'); //have add authority ?	
                $toolbar = Common::createToolbar($url, 'save', 'user_channel_edit.php?act=save_add');
                $uid = getCookie(COOKIE_UID);

                $channelid = dbGetFieldValue(TB_USER_CHANNEL, 'channelid', "id='" . $selectid . "'");
                $list_channel = Common::creatClassSelect(TB_USER_CHANNEL, 'channelid', $channelid, "uid=$uid");

                $title = '';
                $intro = '';

                $redirecturl = '';
                $fileurl = '';
                $show_img = '';
                $status = Common::creatStatusRadio(0);
                $flag = $this -> createFlagRadio(1);

                $username = dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . getCookie(COOKIE_UID) . "'");
                $is_edit = '';
                $isdisabled = '';
                $addtime = getDateTimeMk(time());
                $ip = getIP();
            } 
            // common
            $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                    'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                    'menu_nav' => Common::createAdminMenuNav($url),
                    'toolbar' => $toolbar
                    )); 
            // data
            $clTemplate -> assign_vars(array('selectid' => $selectid,
                    'channelid' => $channelid,
                    'list_channel' => $list_channel,
                    'title' => $title,
                    'intro' => $intro,
                    'template_id' => $template_id,
                    'template_title' => $template_title,
                    'redirecturl' => $redirecturl,
                    'fileurl' => $fileurl,
                    'show_img' => $show_img,
                    'status' => $status,
                    'flag' => $flag,
                    'uid' => $uid,
                    'username' => $username,
                    'ip' => $ip,
                    'addtime' => $addtime,
                    'is_edit' => $is_edit,
                    'display_parent' => $display_parent,
                    'isdisabled' => $isdisabled
                    ));

            $clTemplate -> set_filenames(array('body' => 'user_channel_edit.tpl.html'));
            $clTemplate -> pparse("body");
        } 

        function layout_user_channel_select($uid) {
            global $db, $clTemplate, $url;
            global $form_input, $selectid; 
            // common
            $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                    'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                    'menu_nav' => Common::createAdminMenuNav($url),
                    'form_input' => $form_input
                    ));

            $this -> user_channel_select_show($uid, $selectid);

            $clTemplate -> set_filenames(array('body' => 'user_channel_select.tpl.html'));
            $clTemplate -> pparse("body");
        } 

        function user_channel_select_show($uid, $selectid, $parentid = '') {
            global $db, $clTemplate, $url;

            static $num = 0; 
            // show list---start---
            $sqlstr = '';
            $sql = "select * from " . TB_USER_CHANNEL . " where uid='$uid' and channelid like '" . $parentid . "__' " . $sqlstr . " order by ordernum ";
            $rs = $db -> Execute($sql); 
            // echo $sql;
            while (!$rs -> EOF) {
                $num++;
                $channelid = $rs -> fields['channelid'];
                $tr_id = ' id="' . $channelid . '"';
                $depth = strlen($channelid)-2;
                $spaces = '';
                $is_disabled = '';

                if ($depth == 0) { // first floor
                        $tr_css = 'list_parent_tr_bg';
                    $td_css = 'list_parent_td_bg';
                    $tr_style = ' style="display:"';
                    $tr_onmouse = 'onMouseOver="this.className=\'list_mouseover_tr_bg\'" onMouseOut="this.className=\'list_parent_tr_bg\'"';
                    $td_onmouse = 'onMouseOver="this.className=\'list_mouseover_td_bg\'" onMouseOut="this.className=\'list_parent_td_bg\'"';
                } else {
                    $spaces = str_repeat("&nbsp;&nbsp;", $depth);
                    $tr_css = 'list_sub_tr_bg';
                    $td_css = 'list_sub_td_bg';
                    $tr_style = ' style="display:"';
                    $tr_onmouse = 'onMouseOver="this.className=\'list_mouseover_tr_bg\'" onMouseOut="this.className=\'list_sub_tr_bg\'"';
                    $td_onmouse = 'onMouseOver="this.className=\'list_mouseover_td_bg\'" onMouseOut="this.className=\'list_sub_td_bg\'"';
                } 
                if ($channelid == $selectid) {
                    $tr_css = 'list_mouseover_tr_bg';
                    $td_css = 'list_mouseover_td_bg';
                } 

                if (dbGetRecordCount(TB_USER_CHANNEL, "channelid like '" . $channelid . "__' " . $sqlstr . "") > 0) { // sub menu
                        $show_arrow = "<a href=\"javascript:showSubClassTr('" . $channelid . "','" . SYS_ADMIN_STYLE_PATH . "images/')\" ><img id='img" . $channelid . "' src='" . SYS_ADMIN_STYLE_PATH . "images/minus.gif' border='0'></a>";
                } else {
                    $show_arrow = '';
                } 

                switch ($rs -> fields['flag']) {
                    case 0:
                        $flag = Common::createFlagTxt('open');
                        break;
                    case 1:
                        $flag = Common::createFlagTxt('locked');
                        break;
                    case 2:
                        $flag = Common::createFlagTxt('stop');
                        break;
                } 

                $clTemplate -> assign_block_vars('ListChannel', array('tr_id' => $tr_id,
                        'tr_css' => $tr_css,
                        'td_css' => $td_css,
                        'tr_onmouse' => $tr_onmouse,
                        'td_onmouse' => IS_ONMOUSE_TD? $td_onmouse : '',
                        'tr_style' => $tr_style,
                        'show_arrow' => $show_arrow,
                        'num' => $num,
                        'channelid' => $channelid,
                        'title' => $spaces . '|-' . $rs -> fields['title'],
                        'title_info' => $rs -> fields['title'],
                        'intro' => Common::showTxtAb($rs -> fields['intro'], 20, '...'),
                        'status' => $rs -> fields['status']? Common::createFlagTxt('hidden') : Common::createFlagTxt('display'),
                        'flag' => $flag,
                        'ip' => $rs -> fields['ip'],
                        'addtime' => $rs -> fields['addtime']? getDateTimeMk($rs -> fields['addtime']) : '',
                        'is_disabled' => $is_disabled
                        ));

                $this -> user_channel_select_show($uid, $selectid, $channelid);
                $rs -> MoveNext();
            } 
            $rs -> Close(); 
            // show list---end---
        } 

        /**
         * ---createFlagRadio---
         * 
         * @param string $flag 
         * @return string 
         */
        function createFlagRadio($flag = -1) {
            global $lang;
            $rtn = '';
            $flag_arr = array(1, 2, 3);
            $flag_txt_arr = array('open', 'locked', 'stop');
            for($i = 0; $i < count($flag_txt_arr);$i++) {
                $e_s = '';
                if ($flag_arr[$i] == $flag) {
                    $e_s = ' checked';
                    $flag = '';
                } 
                $showvalue = $flag_txt_arr[$i];
                if (array_key_exists($flag_txt_arr[$i], $lang)) $showvalue = $lang[$flag_txt_arr[$i]];
                $rtn .= "<input type='radio' name='flag' value='" . $flag_arr[$i] . "' " . $e_s . ">" . $showvalue . "&nbsp;\n";
            } 

            return $rtn;
        } 
    } 

    ?>
