<?php
/**
 * 
 * @file class_link.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

require_once(EIFR_ROOT . 'libraries/template.php');

/**
 * ---ComLink---
 * #flag (0:unchecked, 1:open, 2:locked, 3:stop, 4:delete)
 */
class ComLink {
    function setLinkFieldRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?	
        global $selectid, $selectValue, $field_name, $field_value;

        if ($selectValue != '') $selectid = $selectValue;
        $sql = "UPDATE " . TB_LINK . "  set $field_name ='$field_value'  WHERE id in (" . $selectid . ")";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showMsg($lang['modifySuccess'], 'success', 'link.php');
        } else {
            Common::showErrorMsg($lang['modifyFail']);
        } 
    } 

    function deleteRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete'); //have delete authority ?
        global $selectValue;

        $sql = "DELETE FROM " . TB_LINK . " WHERE id in (" . $selectValue . ")";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showMsg($lang['delSuccess'], 'success', DIR_INSTALL . 'admin/' . $url);
        } else {
            Common::showErrorMsg($lang['delFail']);
        } 
    } 

    function addRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'add'); //have add authority ?	
        global $ordernum, $weburl, $webname, $intro, $email, $logo, $layout_type, $layout_list, $channel_type, $channel_id, $flag, $uid;
        $is_manage = Common::checkAdminAuth($url, 'manage');
        $layout_id = '';
        if ($layout_type == '1') $layout_id = '-1';
        if ($layout_type == '2') {
            if ($layout_list != '') $layout_id = implode(',', $layout_list);
        } 

        $channel_id = addCommaHeadTail($channel_id);
        if ($channel_type == '1') $channel_id = '-1';

        $addtime = time();
        $ip = getIP();
        $id = dbGetMaxValue1(TB_LINK, 'id');
        $ordernum = dbGetMaxValue1(TB_LINK, 'ordernum');
        $webname = sTextEncode($webname);
        if (!$is_manage) {
            $layout_id = '';
            $channel_id = '';
            $uid = getCookie(COOKIE_UID);
        } 

        $sql = "insert into " . TB_LINK . " (id,ordernum,weburl,webname,intro,email,logo,layout_id," . TFR_CHANNEL_ID . ",flag,uid,addtime,ip) values('$id','$ordernum','$weburl','$webname','$intro','$email','$logo','$layout_id','$channel_id','$flag','$uid','$addtime','$ip')";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showOkMsg($lang['saveSuccess'], 'link_edit.php', 'link_edit.php?act=edit&selectid=' . $id, 'link.php');
        } else {
            Common::showErrorMsg($lang['addFail']);
        } 
        $rs -> Close();
    } 

    function editRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?
        global $selectid, $selectValue, $ordernum, $weburl, $webname, $intro, $email, $logo, $layout_type, $layout_list, $channel_type, $channel_id, $flag, $uid;
        $is_manage = Common::checkAdminAuth($url, 'manage');
        if ($selectValue) $selectid = $selectValue;

        $layout_id = '';
        if ($layout_type == '1') $layout_id = '-1';
        if ($layout_type == '2') {
            if ($layout_list != '') $layout_id = implode(',', $layout_list);
        } 

        $channel_id = addCommaHeadTail($channel_id);
        if ($channel_type == '1') $channel_id = '-1';

        $manage_sql = '';
        if ($is_manage) {
            $manage_sql = ",layout_id='$layout_id'," . TFR_CHANNEL_ID . "='$channel_id',flag='$flag',uid='$uid'";
        } 

        $webname = sTextEncode($webname);
        $sql = "update " . TB_LINK . " set weburl='$weburl',webname='$webname',intro='$intro',email='$email',logo='$logo'" . $manage_sql . " where id=" . $selectid . "";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if ($rs) {
            Common::showOkMsg($lang['saveSuccess'], 'link_edit.php', 'link_edit.php?act=edit&selectid=' . $selectid, 'link.php');
        } else {
            Common::showErrorMsg($lang['modifyFail']);
        } 
        $rs -> Close();
    } 

    function layout_link() {
        global $db, $lang, $url;
        global $search_field, $search_keyword, $flag, $layout_id;
        $is_manage = Common::checkAdminAuth($url, 'manage');

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        // show list---start---
        $manage_sql = '';
        if (!$is_manage) {
            $manage_sql = "  and flag<>4 and uid=" . getCookie(COOKIE_UID) . " ";
        } 

        $layout_id_sql = '';
        if ($layout_id != '') {
            $layout_id_sql = " and (find_in_set(" . $layout_id . ",layout_id) or layout_id='-1')";
        } 

        $flag_sql = '';
        if ($flag != '') {
            $flag_sql = " and flag='" . $flag . "' ";
        } 

        $search_sql = '';
        if ($search_keyword != '') {
            $search_sql = " and " . $search_field . " like '%$search_keyword%' ";
        } 
        $sql = "select * from " . TB_LINK . " where 1=1 " . $manage_sql . $layout_id_sql . $flag_sql . $search_sql . " order by id asc ";
        $clPages = new Pages();
        $clPages -> query_string = 'flag=' . $flag . '&layout_id=' . $layout_id . '&search_field=' . $search_field . '&search_keyword=' . $search_keyword . '';
        $clPages -> query_sql = $sql;
        $aryResult = $clPages -> Execute();
        $rs = $aryResult[0];
        $intList = $aryResult[2];

        if ($intList > 0) {
            $num = 0;
            while (!$rs -> EOF) {
                $num++;

                $clTemplate -> assign_block_vars('ListLink', array('num' => $num,
                        'id' => $rs -> fields['id'],
                        'uid' => $rs -> fields[TF_USER_ID],
                        'username' => dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $rs -> fields[TFR_USER_ID] . "'"),
                        'layout_id' => $rs -> fields['layout_id'],
                        'layout_title' => dbGetFieldValue(TB_TEMPLATE_LAYOUT, 'title', "id='" . $rs -> fields['layout_id'] . "'"),
                        'webname' => $rs -> fields['webname'],
                        'logo' => $rs -> fields['logo'],
                        'logo_img' => $rs -> fields['logo']? "<img src='" . CSafeData::getImgSrc($rs -> fields['logo']) . "' align='absmiddle'>" : '',
                        'intro' => $rs -> fields['intro'],
                        'weburl' => $rs -> fields['weburl'],
                        'email' => $rs -> fields['email'],
                        'addtime' => getDateTimeMk($rs -> fields['addtime']),
                        'flag' => Common::createFlagShow($rs -> fields['flag'])
                        ));

                $rs -> MoveNext();
            } 
        } 
        $rs -> Close(); 
        // show list---end---
        $list_flag = '';
        $btn_delete_forever = '';
        $btn_flag = '';
        if ($is_manage) {
            $list_flag .= '<select name="flag" class="input_select" ><option value="">---' . $lang['flag'] . '---</option>';
            $list_flag .= Common::createFlagSelect($flag);
            $list_flag .= '</select>';

            $btn_delete_forever = Common::createToolbar($url, 'delete_forever', 'link.php?act=delete_forever');
            $btn_flag .= Common::createSplitLine();
            $btn_flag .= Common::createToolbar($url, 'unchecked', 'link.php?act=setvalue&field_name=flag&field_value=0');
            $btn_flag .= Common::createToolbar($url, 'open', 'link.php?act=setvalue&field_name=flag&field_value=1');
            $btn_flag .= Common::createToolbar($url, 'locked', 'link.php?act=setvalue&field_name=flag&field_value=2');
            $btn_flag .= Common::createToolbar($url, 'stop', 'link.php?act=setvalue&field_name=flag&field_value=3');
        } 

        $toolbar = Common::createToolbar($url, 'add', 'link_edit.php');
        $toolbar .= Common::createToolbar($url, 'edit', 'link_edit.php?act=edit');
        $toolbar .= Common::createToolbar($url, 'delete', 'link.php?act=setvalue&field_name=flag&field_value=4');
        $toolbar .= $btn_delete_forever;
        $toolbar .= $btn_flag;

        if ($layout_id != '') $layout_title = dbGetFieldValue(TB_TEMPLATE_LAYOUT, 'title', "id='" . $layout_id . "'");
        else $layout_title = $lang['layout_select']; 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => $toolbar,
                'layout_id' => $layout_id,
                'layout_title' => $layout_title,
                'list_flag' => $list_flag,
                'pagenext' => $aryResult[3]
                ));

        $clTemplate -> set_filenames(array('body' => 'link.tpl.html'));
        $clTemplate -> pparse("body");
    } 

    function layout_link_edit() {
        global $db, $lang, $url;
        global $selectid, $selectValue, $uid, $act;

        if ($selectValue) $selectid = $selectValue;
        $is_manage = Common::checkAdminAuth($url, 'manage');
        $style_display = 'none';
        if ($is_manage) {
            $style_display = '';
        } 
        if ($act == 'edit') { // edit
            Common::checkAdminExeAuth($url, 'edit');

            $toolbar = Common::createToolbar($url, 'save', 'link_edit.php?act=save');
            $toolbar .= Common::createToolbar($url, 'delete', 'link.php?act=setvalue&field_name=flag&field_value=4');
            if ($is_manage) {
                $toolbar .= Common::createToolbar($url, 'delete_forever', 'link.php?act=delete_forever');
            } 

            $is_edit = '';

            $sql = "select * from " . TB_LINK . " where id='" . $selectid . "'";
            $rs = $db -> Execute($sql); 
            // echo $sql;
            if (!$rs -> EOF) {
                if (!$is_manage) {
                    $is_edit = ' disabled';
                } 

                $channel_checked_1 = '';
                $channel_checked_2 = '';
                $channel_display = 'none';
                $channel_id = removeCommaHeadTail($rs -> fields[TFR_CHANNEL_ID]);
                if ($channel_id != '' && $channel_id != '-1') {
                    $channel_checked_2 = ' checked';
                    $channel_display = '';
                } 
                if ($channel_id == '-1') $channel_checked_1 = ' checked';

                $layout_list = '';
                $layout_checked_1 = '';
                $layout_checked_2 = '';
                $layout_display = 'none';
                $layout_id = $rs -> fields['layout_id'];
                if ($layout_id != '' && $layout_id != '-1') {
                    $layout_checked_2 = ' checked';
                    $layout_display = '';
                    $layout_list = Common::createLayoutSelect($layout_id);
                } 
                if ($layout_id == '-1') $layout_checked_1 = ' checked';

                $id = $rs -> fields['id'];
                $webname = $rs -> fields['webname'];
                $intro = $rs -> fields['intro'];
                $weburl = $rs -> fields['weburl'];
                $email = $rs -> fields['email'];
                $logo = $rs -> fields['logo'];
                $logo_img = $rs -> fields['logo']? "<img src='" . CSafeData::getImgSrc($rs -> fields['logo']) . "' align='absmiddle'>" : '';
                $flag = $is_manage ? Common::createFlagRadio($rs -> fields['flag']) : Common::createFlagShow($rs -> fields['flag']);
                $uid = $rs -> fields[TFR_USER_ID];
                $username = dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $uid . "'");
                $addtime = getDateTimeMk($rs -> fields['addtime']);
                $ip = $rs -> fields['ip'];

                if (!$is_manage) {
                    if ($uid != $_SESSION[SESSION_BACK_USERID]) {
                        Common::showWarningMsg($lang['checkAuth']);
                    } 
                } 

                $rs -> Close();
            } else {
                $rs -> Close();
                Common::showWarningMsg($lang['records_inexistence']);
            } 
        } else { // add
            Common::checkAdminExeAuth($url, 'add');

            $toolbar = Common::createToolbar($url, 'save', 'link_edit.php?act=save');
            $id = '';
            $webname = '';
            $intro = '';
            $layout_list = '';
            $layout_checked_1 = '';
            $layout_checked_2 = '';
            $layout_display = 'none';
            $channel_id = '';
            $channel_checked_1 = '';
            $channel_checked_2 = '';
            $channel_display = 'none';
            $weburl = '';
            $email = '';
            $logo = '';
            $logo_img = '';
            $flag = $is_manage ? Common::createFlagRadio(0) : Common::createFlagShow(0);
            $uid = 0;
            $username = '';
            $addtime = getDateTimeMk(time());
            $ip = getIP();
        } 

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'css_path' => DIR_INSTALL . 'admin/style/',
                'sys_path' => DIR_INSTALL,
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => $toolbar
                )); 
        // data
        $clTemplate -> assign_vars(array('selectid' => $selectid,
                'style_display' => $style_display,
                'id' => $id,
                'webname' => $webname,
                'intro' => $intro,
                'layout_list' => $layout_list,
                'layout_checked_1' => $layout_checked_1,
                'layout_checked_2' => $layout_checked_2,
                'layout_display' => $layout_display,
                'channel_id' => $channel_id,
                'channel_checked_1' => $channel_checked_1,
                'channel_checked_2' => $channel_checked_2,
                'channel_display' => $channel_display,
                'email' => $email,
                'weburl' => $weburl,
                'logo' => $logo,
                'logo_img' => $logo_img,
                'flag' => $flag,
                'uid' => $uid,
                'username' => $username,
                'ip' => $ip,
                'addtime' => $addtime
                ));

        $clTemplate -> set_filenames(array('body' => 'link_edit.tpl.html'));
        $clTemplate -> pparse("body");
    } 

    function getAvailableLinks() {
        global $db;
        $rtn = array();

        $cacheHelper = new CCacheHelper('db_link');
        $rtn = $cacheHelper -> getCache();
        if ($rtn !== false) {
            Log_v(__FILE__, __LINE__, 'getAvailableLinks from cache');
            return $rtn;
        } 

        $sql = "select * from " . TB_LINK . " where flag=1 or flag=2 order by id asc ";
        $rs = dbGetRecordn($sql);
        foreach($rs as $row) {
            $rtn[$row['id']] = array();
            $rtn[$row['id']]['id'] = $row['id'];
            $rtn[$row['id']]['webname'] = $row['webname'];
            $rtn[$row['id']]['logo'] = $row['logo'];
            $rtn[$row['id']]['weburl'] = $row['weburl'];
            $rtn[$row['id']]['channel_id'] = $row['channel_id'];
            $rtn[$row['id']]['layout_id'] = $row['layout_id'];
        } 
        return $rtn;
    } 

    function genCache() {
        $data = array();
        $cacheHelper = new CCacheHelper('db_link');
        $cacheHelper -> deleteCache();
        $data = $this -> getAvailableLinks();
        $cacheHelper -> writeCache($data);
    } 
} 

?>
