<?php
/**
 * 
 * @file class_guestbook.php
 * @copyright (c) 2005 - 2011 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

require_once(EIFR_ROOT . 'libraries/template.php');

/**
 * ---Comguestbook---
 * #flag (0:unchecked, 1:open, 2:locked, 3:stop, 4:delete)
 */
class Comguestbook {
    function recycleRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?	
        global $selectid, $selectValue, $field_name, $field_value;

        if ($selectValue != '') $selectid = $selectValue;
        $sql = "UPDATE " . TB_GUESTBOOK . "  set flag=4 WHERE id='$selectid'";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if ($rs) {
            Common::showMsg($lang['modifySuccess'], 'success', 'guestbook.php');
        } else {
            Common::showErrorMsg($lang['modifyFail']);
        } 
    } 

    function setFieldRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?	
        global $selectid, $selectValue, $field_name, $field_value;

        if ($selectValue != '') $selectid = $selectValue;
        $sql = "UPDATE " . TB_GUESTBOOK . "  set $field_name ='$field_value'  WHERE id in (" . $selectid . ")";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if ($rs) {
            Common::showMsg($lang['modifySuccess'], 'success', 'guestbook.php');
        } else {
            Common::showErrorMsg($lang['modifyFail']);
        } 
    } 

    function deleteRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete');
        Common::checkAdminExeAuth($url, 'manage');

        global $selectid, $selectValue;

        if ($selectValue != '') $selectid = $selectValue;

        if (!Common::checkAdminAuth($url, 'manage')) {
            $uid = dbGetFieldValue(TB_GUESTBOOK, TFR_USER_ID, "id ='" . $selectid . "'");
            if ($uid != getCookie(COOKIE_UID)) {
                Common::showWarningMsg($lang['checkAuth']);
            } 
        } 

        $sql = "DELETE FROM " . TB_GUESTBOOK . " WHERE id in (" . $selectid . ")";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showMsg($lang['delSuccess'], 'success', 'guestbook.php');
        } else {
            Common::showErrorMsg($lang['delFail']);
        } 
    } 

    function addRecords() {
		global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'add');

		$title = sTextEncode(kPost('title'));

		$contact = '';
        $contact_arr = array();
        if (kPost('contact') != '') $contact_arr['contact'] = kPost('contact');
        if (kPost('email') != '') $contact_arr['email'] = kPost('email');
        if ($contact_arr) $contact = serialize($contact_arr);

		$content = '';
        if (kPost('content') != '') $content = HTMLEncode2(kPost('content'));
		$replycontent = '';
		if (kPost('replycontent') != '') $replycontent = HTMLEncode2(kPost('replycontent'));
        

        $record_arr = array(
			'title' => $title,
            'contact' => $contact,
			'content' => $content,
            'replycontent' => $replycontent,
            'nickname' => kPost('nickname'),
			'replyuid' => kPost('replyuid'),
			'replynickname' => kPost('replynickname'),
			'addtime' => time(),
            'replytime' => getMkTime(kPost('replytime')),
			'ip' => getIP(),
            'flag' => kPost('flag')
            );

		if (kPost('layout_id') != '') $record_arr['layout_id'] = implode(',', kPost('layout_id'));

        if (dbInsert(TB_GUESTBOOK, $record_arr)) {
            $id = dbGetMaxValue(TB_GUESTBOOK, 'id', "replyuid='" . kPost('replyuid') . "'");
            Common::showOkMsg($lang['saveSuccess'], 'guestbook_edit.php', 'guestbook_edit.php?act=edit&selectid=' . $id, 'guestbook.php');
        } else {
            Common::showErrorMsg($lang['addFail']);
        }
    }

    function editRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit');

        $selectid = kRequest('selectid');
        if (kPost('selectValue')) $selectid = kPost('selectValue');

		$title = sTextEncode(kPost('title'));

		$contact = '';
        $contact_arr = array();
        if (kPost('contact') != '') $contact_arr['contact'] = kPost('contact');
        if (kPost('email') != '') $contact_arr['email'] = kPost('email');
        if ($contact_arr) $contact = serialize($contact_arr);

		$content = '';
        if (kPost('content') != '') $content = HTMLEncode2(kPost('content'));
		$replycontent = '';
		if (kPost('replycontent') != '') $replycontent = HTMLEncode2(kPost('replycontent'));
        

        $record_arr = array(
			'title' => $title,
            'contact' => $contact,
			'content' => $content,
            'replycontent' => $replycontent,
            'nickname' => kPost('nickname'),
			'replyuid' => kPost('replyuid'),
			'replynickname' => kPost('replynickname'),
			'replytime' => getMkTime(kPost('replytime')),
            'flag' => kPost('flag')
            );

		if (kPost('layout_id') != '') $record_arr['layout_id'] = implode(',', kPost('layout_id'));

        if (dbUpdate(TB_GUESTBOOK, $record_arr, "id=" . $selectid)) {
            Common::showOkMsg($lang['saveSuccess'], '', 'guestbook_edit.php?act=edit&selectid=' . $selectid, 'guestbook.php');
        } else {
            Common::showErrorMsg($lang['saveFail']);
        } 

    } 

    function layout_guestbook() {
        global $db, $lang, $url;
        global $search_field, $search_keyword, $flag;
        $is_manage = Common::checkAdminAuth($url, 'manage');

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        // show list---start---
        $manage_sql = '';
        if (!$is_manage) {
            $manage_sql = "  and flag<>4 ";
        } 
        $flag_sql = '';
        if ($flag != '') {
            $flag_sql = " and flag='" . $flag . "' ";
        } 

        $search_sql = '';
        if ($search_keyword != '') {
            $search_sql = " and " . $search_field . " like '%$search_keyword%' ";
        } 
        $sql = "select * from " . TB_GUESTBOOK . " where 1=1 " . $manage_sql . $flag_sql . $search_sql . " order by id desc ";
        $clPages = new Pages();
        $clPages -> query_string = 'flag=' . $flag . '&search_field=' . $search_field . '&search_keyword=' . $search_keyword . '';
        $clPages -> query_sql = $sql;
        $aryResult = $clPages -> Execute();
        $rs = $aryResult[0];
        $intList = $aryResult[2];

        if ($intList > 0) {
            $num = 0;
            while (!$rs -> EOF) {
                $num++;

                $clTemplate -> assign_block_vars('Listguestbook', array('num' => $num,
                        'uid' => $rs -> fields[TF_USER_ID],
                        'nickname' => $rs -> fields['nickname'],
                        'id' => $rs -> fields['id'],
                        'title' => $rs -> fields['title'],
                        'content' => $rs -> fields['content'],
						'replyontent' => $rs -> fields['replycontent'],
                        'replyuid' => $rs -> fields['replyuid'],
                        'replynickname' => $rs -> fields['replynickname'],
                        'addtime' => getDateTimeMk_YMD($rs -> fields['addtime']),
						'replytime' => getDateTimeMk_YMD($rs -> fields['replytime']),
                        'flag' => Common::createFlagShow($rs -> fields['flag'])
                        ));

                $rs -> MoveNext();
            } 
        } 
        $rs -> Close(); 
        // show list---end---
        $list_flag = '';
        $btn_delete_forever = '';
        $btn_flag = '';
		$toolbar = '';
        if ($is_manage) {
            $list_flag .= '<select name="flag" class="input_select" ><option value="">---' . $lang['flag'] . '---</option>';
            $list_flag .= Common::createFlagSelect($flag);
            $list_flag .= '</select>';

            $btn_delete_forever = Common::createToolbar($url, 'delete_forever', 'guestbook.php?act=delete_forever');
            $btn_flag .= Common::createSplitLine();
            $btn_flag .= Common::createToolbar($url, 'unchecked', 'guestbook.php?act=setvalue&field_name=flag&field_value=0');
            $btn_flag .= Common::createToolbar($url, 'open', 'guestbook.php?act=setvalue&field_name=flag&field_value=1');
            $btn_flag .= Common::createToolbar($url, 'locked', 'guestbook.php?act=setvalue&field_name=flag&field_value=2');
            $btn_flag .= Common::createToolbar($url, 'stop', 'guestbook.php?act=setvalue&field_name=flag&field_value=3');
        } 

		$toolbar .= Common::createToolbar($url, 'add', 'guestbook_edit.php');        
		$toolbar .= Common::createToolbar($url, 'edit', 'guestbook_edit.php?act=edit');
        $toolbar .= Common::createToolbar($url, 'delete', 'guestbook.php?act=setvalue&field_name=flag&field_value=4');
        $toolbar .= $btn_delete_forever;
        $toolbar .= $btn_flag; 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => $toolbar,
                'list_flag' => $list_flag,
                'pagenext' => $aryResult[3]
                ));

        $clTemplate -> set_filenames(array('body' => 'guestbook.tpl.html'));
        $clTemplate -> pparse("body");
    } 

    function layout_guestbook_edit() {
        global $db, $lang, $url;
        global $selectid, $selectValue, $act;

        if ($selectValue) $selectid = $selectValue;
        $is_manage = Common::checkAdminAuth($url, 'manage');

		$id = '';
		$title = '';
		$content = '';
		$replycontent = '';
		$uid = '';
		$nickname = '';
		$replyuid = getCookie(COOKIE_UID);
		$replynickname = getCookie(COOKIE_NICKNAME);
		$addtime = getDateTimeMk(time());
		$replytime = getDateTimeMk(time());
		$contact = '';
		$email = '';
		$flag = $is_manage ? Common::createFlagRadio(0) : Common::createFlagShow(0);
        $ip = getIP();

        if ($act == 'edit') { // edit
            Common::checkAdminExeAuth($url, 'edit');

            $toolbar = Common::createToolbar($url, 'save', 'guestbook_edit.php?act=save_edit');
            $toolbar .= Common::createToolbar($url, 'delete', 'guestbook.php?act=setvalue&field_name=flag&field_value=4');
            if ($is_manage) {
                $toolbar .= Common::createToolbar($url, 'delete_forever', 'guestbook.php?act=delete_forever');
            } 

            $sql = "select * from " . TB_GUESTBOOK . " where id='" . $selectid . "'";
            $rs = $db -> Execute($sql);
            if (!$rs -> EOF) {
				$uid = $rs -> fields[TFR_USER_ID];
                if (!$is_manage) {
                    if ($uid != getCookie(COOKIE_UID)) {
                        Common::showWarningMsg($lang['checkAuth']);
                    } 
                }

                $id = $rs -> fields['id'];
                $title = $rs -> fields['title'];
                $content = $rs -> fields['content'] != '' ? HTMLEncode($rs -> fields['content']) : '';
				$replycontent = $rs -> fields['replycontent'] != '' ? HTMLEncode($rs -> fields['replycontent']) : '';
                $flag = $is_manage ? Common::createFlagRadio($rs -> fields['flag']) : Common::createFlagShow($rs -> fields['flag']);
                
                $nickname = $rs -> fields['nickname'];
                $addtime = getDateTimeMk($rs -> fields['addtime']);
				$replytime = getDateTimeMk($rs -> fields['replytime']);
                $ip = $rs -> fields['ip']; 

				$replyuid = $rs -> fields['replyuid'];
                $replynickname = $rs -> fields['replynickname'];
				if($rs -> fields['replynickname'] == '' && $is_manage) {
					$replyuid = getCookie(COOKIE_UID);
	                $replynickname = getCookie(COOKIE_NICKNAME);
				}
				
				$contact_arr = unserializeFixed($rs -> fields['contact']);
	            $contact = '';
	            $email = '';
	            if (is_array($contact_arr)) {
	                if (array_key_exists('contact', $contact_arr)) $contact = $contact_arr['contact'];
	                if (array_key_exists('email', $contact_arr)) $email = $contact_arr['email'];
	            }
	
				$eifrtf_layout_select = $this -> cTagLayoutMSelect($rs -> fields['layout_id']);

                $rs -> Close();
            } else {
                $rs -> Close();
                Common::showWarningMsg($lang['guestbook_isnull']);
            } 
        } else {
			Common::checkAdminExeAuth($url, 'add');
			$toolbar = Common::createToolbar($url, 'save', 'guestbook_edit.php?act=save_add');
			$eifrtf_layout_select = $this -> cTagLayoutMSelect();
		}

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        $clTemplate -> assign_vars(array(
				'sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'css_path' => DIR_INSTALL . 'admin/style/',
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => $toolbar,
                'selectid' => $selectid,
                'id' => $id,
                'replynickname' => $replynickname,
                'replyuid' => $replyuid,
                'title' => $title,
                'content' => $content,
                'replycontent' => $replycontent,
                'flag' => $flag,
                'uid' => $uid,
                'nickname' => $nickname,
				'contact' => $contact,
				'email' => $email,
                'ip' => $ip,
				'eifrtf_layout_select' => $eifrtf_layout_select,
                'addtime' => $addtime,
				'replytime' => $replytime
                ));

        $clTemplate -> set_filenames(array('body' => 'guestbook_edit.tpl.html'));
        $clTemplate -> pparse("body");
    } 
    
    function cTagLayoutMSelect($layout_ids = '') {
        $selectAttrs = array('name'=>'layout_id[]', 'id'=>'layout_id', 'multiple'=>'multiple', 'size'=>3);
        return Common::cTagLayoutMSelect($selectAttrs, $layout_ids);
    }

} 

?>
