<?php
/**
 * 
 * @file class_comment.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

require_once(EIFR_ROOT . 'libraries/template.php');

/**
 * ---ComComment---
 * #flag (0:unchecked, 1:open, 2:locked, 3:stop, 4:delete)
 */
class ComComment {
    function recycleRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?	
        global $selectid, $selectValue, $field_name, $field_value;

        if ($selectValue != '') $selectid = $selectValue;
        $sql = "UPDATE " . TB_COMMENT . "  set flag=4 WHERE id='$selectid'";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if ($rs) {
            Common::showMsg($lang['modifySuccess'], 'success', 'comment.php');
        } else {
            Common::showErrorMsg($lang['modifyFail']);
        } 
    } 

    function setFieldRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?	
        global $selectid, $selectValue, $field_name, $field_value;

        if ($selectValue != '') $selectid = $selectValue;
        $sql = "UPDATE " . TB_COMMENT . "  set $field_name ='$field_value'  WHERE id in (" . $selectid . ")";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if ($rs) {
            Common::showMsg($lang['modifySuccess'], 'success', 'comment.php');
        } else {
            Common::showErrorMsg($lang['modifyFail']);
        } 
    } 

    function deleteRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete');
        Common::checkAdminExeAuth($url, 'manage');

        global $selectid, $selectValue;

        if ($selectValue != '') $selectid = $selectValue;

        if (!Common::checkAdminAuth($url, 'manage')) {
            $uid = dbGetFieldValue(TB_COMMENT, TFR_USER_ID, "id ='" . $selectid . "'");
            if ($uid != getCookie(COOKIE_UID)) {
                Common::showWarningMsg($lang['checkAuth']);
            } 
        } 

        $sql = "DELETE FROM " . TB_COMMENT . " WHERE id in (" . $selectid . ")";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showMsg($lang['delSuccess'], 'success', 'comment.php');
        } else {
            Common::showErrorMsg($lang['delFail']);
        } 
    } 

    function editRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit');

        global $selectid, $selectValue, $title, $content, $flag, $nickname, $ratevalue;

        if ($selectValue != '') $selectid = $selectValue;
        $manage_sql = '';
        if (Common::checkAdminAuth($url, 'manage')) {
            $manage_sql = " ratevalue='$ratevalue', ";
        } 

        if ($content != '') $content = HTMLEncode2($content);
        $title = sTextEncode($title);
        $sql = "update " . TB_COMMENT . " set  " . $manage_sql . " title='$title', content='$content', flag='$flag' where id=" . $selectid . ""; 
        // echo $sql;
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showOkMsg($lang['saveSuccess'], '', 'comment_edit.php?act=edit&selectid=' . $selectid, 'comment.php');
        } else {
            Common::showErrorMsg($lang['saveFail']);
        } 
        $rs -> Close();
    } 

    function layout_comment() {
        global $db, $lang, $url;
        global $search_field, $search_keyword, $channel_id, $flag;
        $is_manage = Common::checkAdminAuth($url, 'manage');

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        // show list---start---
        $manage_sql = '';
        if (!$is_manage) {
            $manage_sql = "  and flag<>4 ";
        } 
        $flag_sql = '';
        if ($flag != '') {
            $flag_sql = " and flag='" . $flag . "' ";
        } 

        $channel_id_sql = '';
        if ($channel_id != '') {
            $channel_id_sql = " and channel_id ='" . $channel_id . "' ";
        } 
        $search_sql = '';
        if ($search_keyword != '') {
            $search_sql = " and " . $search_field . " like '%$search_keyword%' ";
        } 
        $sql = "select * from " . TB_COMMENT . " where 1=1 " . $manage_sql . $flag_sql . $channel_id_sql . $search_sql . " order by id desc ";
        $clPages = new Pages();
        $clPages -> query_string = 'flag=' . $flag . '&channel_id=' . $channel_id . '&search_field=' . $search_field . '&search_keyword=' . $search_keyword . '';
        $clPages -> query_sql = $sql;
        $aryResult = $clPages -> Execute();
        $rs = $aryResult[0];
        $intList = $aryResult[2];

        if ($intList > 0) {
            $num = 0;
            while (!$rs -> EOF) {
                $num++;

                $clTemplate -> assign_block_vars('ListComment', array('num' => $num,
                        'uid' => $rs -> fields[TF_USER_ID],
                        'nickname' => $rs -> fields['nickname'],
                        'id' => $rs -> fields['id'],
                        'title' => $rs -> fields['title'],
                        'content' => $rs -> fields['content'],
                        'article_id' => $rs -> fields['article_id'],
                        'article_title' => dbGetFieldValue(TB_ARTICLE, 'title', "id ='" . $rs -> fields['article_id'] . "'"),
                        'addtime' => getDateTimeMk_YMD($rs -> fields['addtime']),
                        'flag' => Common::createFlagShow($rs -> fields['flag'])
                        ));

                $rs -> MoveNext();
            } 
        } 
        $rs -> Close(); 
        // show list---end---
        $list_flag = '';
        $list_channel = '';
        $btn_delete_forever = '';
        $btn_flag = '';
        if ($is_manage) {
            $list_flag .= '<select name="flag" class="input_select" ><option value="">---' . $lang['flag'] . '---</option>';
            $list_flag .= Common::createFlagSelect($flag);
            $list_flag .= '</select>';

            $btn_delete_forever = Common::createToolbar($url, 'delete_forever', 'comment.php?act=delete_forever');
            $btn_flag .= Common::createSplitLine();
            $btn_flag .= Common::createToolbar($url, 'unchecked', 'comment.php?act=setvalue&field_name=flag&field_value=0');
            $btn_flag .= Common::createToolbar($url, 'open', 'comment.php?act=setvalue&field_name=flag&field_value=1');
            $btn_flag .= Common::createToolbar($url, 'locked', 'comment.php?act=setvalue&field_name=flag&field_value=2');
            $btn_flag .= Common::createToolbar($url, 'stop', 'comment.php?act=setvalue&field_name=flag&field_value=3');

            $list_channel .= '<select name="channel_id" class="input_select" ><option value="">+---' . $lang["channel_select"] . '---</option>';
            $list_channel .= Common::creatClassSelect(TB_CHANNEL, 'id', $channel_id);
            $list_channel .= '</select>';
        } 

        $toolbar = Common::createToolbar($url, 'edit', 'comment_edit.php?act=edit');
        $toolbar .= Common::createToolbar($url, 'delete', 'comment.php?act=setvalue&field_name=flag&field_value=4');
        $toolbar .= $btn_delete_forever;
        $toolbar .= $btn_flag; 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => $toolbar,
                'list_flag' => $list_flag,
                'pagenext' => $aryResult[3]
                ));

        $clTemplate -> set_filenames(array('body' => 'comment.tpl.html'));
        $clTemplate -> pparse("body");
    } 

    function layout_comment_edit() {
        global $db, $lang, $url;
        global $selectid, $selectValue, $act;

        if ($selectValue) $selectid = $selectValue;
        $is_manage = Common::checkAdminAuth($url, 'manage');
        $list_channel = '';
        $act_type = '';
        if ($act == 'edit') { // edit
            Common::checkAdminExeAuth($url, 'edit');

            $toolbar = Common::createToolbar($url, 'save', 'comment_edit.php?act=save_edit');
            $toolbar .= Common::createToolbar($url, 'delete', 'comment.php?act=setvalue&field_name=flag&field_value=4');
            if ($is_manage) {
                $toolbar .= Common::createToolbar($url, 'delete_forever', 'comment.php?act=delete_forever');
            } 

            $sql = "select * from " . TB_COMMENT . " where id='" . $selectid . "'";
            $rs = $db -> Execute($sql);
            if (!$rs -> EOF) {
                $article_id = $rs -> fields['article_id'];
                $article_title = dbGetFieldValue(TB_ARTICLE, 'title', "id ='" . $rs -> fields['article_id'] . "'");
                $id = $rs -> fields['id'];
                $title = $rs -> fields['title'];
                $content = $rs -> fields['content'] != '' ? HTMLEncode($rs -> fields['content']) : '';
                $ratevalue = $this -> createRateRadio($rs -> fields['ratevalue']);
                $flag = $is_manage ? Common::createFlagRadio($rs -> fields['flag']) : Common::createFlagShow($rs -> fields['flag']);
                $uid = $rs -> fields[TFR_USER_ID];
                $username = dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $uid . "'");
                $nickname = $rs -> fields['nickname'];
                $addtime = getDateTimeMk($rs -> fields['addtime']);
                $ip = $rs -> fields['ip'];
                $parent_id = $rs -> fields['parent_id'];

                if (!$is_manage) {
                    if ($uid != getCookie(COOKIE_UID)) {
                        Common::showWarningMsg($lang['checkAuth']);
                    } 
                } 

                $rs -> Close();
            } else {
                $rs -> Close();
                Common::showWarningMsg($lang['comment_isnull']);
            } 
        } 

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'css_path' => DIR_INSTALL . 'admin/style/',
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => $toolbar
                )); 
        // data
        $clTemplate -> assign_vars(array('selectid' => $selectid,
                'id' => $id,
                'article_title' => $article_title,
                'article_id' => $article_id,
                'title' => $title,
                'content' => $content,
                'ratevalue' => $ratevalue,
                'flag' => $flag,
                'uid' => $uid,
                'username' => $username,
                'nickname' => $nickname,
                'ip' => $ip,
                'addtime' => $addtime,
                'parent_id' => $parent_id
                ));

        $clTemplate -> set_filenames(array('body' => 'comment_edit.tpl.html'));
        $clTemplate -> pparse("body");
    } 

    /**
     * ---createRateRadio---
     * 
     * @param string $rate 
     * @return string 
     */
    function createRateRadio($rate = '') {
        global $lang;
        $rtn = '';
        $rate_arr = array(1, 2, 3);
        $rate_txt_arr = array($lang['low'], $lang['middling'], $lang['good']);
        if (!is_numeric($rate)) $rate = -1;
        for($i = 0; $i < 3;$i++) {
            $e_s = '';
            if ($rate_arr[$i] == $rate) {
                $e_s = ' checked';
                $rate = '';
            } 
            $showvalue = $rate_txt_arr[$i];
            $rtn .= "<input type='radio' name='ratevalue' value='" . $rate_arr[$i] . "' " . $e_s . ">" . $showvalue . "&nbsp;\n";
        } 

        return $rtn;
    } 
} 

?>
