<?php
/**
 * 
 * @file cache.php
 * @copyright (c) 2005 - 2011 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

require_once('../../includes/inc_admin.php');

$url = 'mod_cache/cache.php';
Common::checkAdminFileAuth($url); //check file authority

$act = kGet('act');
$menu_nav = Common::createAdminMenuNav($url);

function updateChannel() {
    require_once(EIFR_ROOT . 'admin/mod_channel/class_channel.php');
    $clComChannel = new ComChannel();
    $clComChannel -> genCache();
} 

function updateTemplateLayout() {
    require_once(EIFR_ROOT . 'admin/mod_template/class_template.php');
    $clComTemplate = new ComTemplate();
    $clComTemplate -> genCache();
} 

function updateAd() {
    require_once(EIFR_ROOT . 'admin/mod_ad/class_ad.php');
    $clComAd = new ComAd();
    $clComAd -> genCache();
} 

function updateLink() {
    require_once(EIFR_ROOT . 'admin/mod_link/class_link.php');
    $clComLink = new ComLink();
    $clComLink -> genCache();
} 

function updateAdminMenu() {
    require_once(EIFR_ROOT . 'admin/mod_adminmenu/class_adminmenu.php');
    $clComAdminmenu = new ComAdminmenu();
    $clComAdminmenu -> genCache();
} 

function updateUserClass() {
    require_once(EIFR_ROOT . 'admin/mod_user_class/class_user_class.php');
    $clComUserClass = new ComUserClass();
    $clComUserClass -> genCache();
} 

function updateAddress() {
    require_once(EIFR_ROOT . 'admin/mod_address/class_address.php');
    $clComAddress = new ComAddress();
    $clComAddress -> genCache();
} 

function updateAll() {
    updateChannel();
    updateAd();
    updateLink();
    updateAdminMenu();
    updateUserClass();
    updateTemplateLayout();
    updateAddress();
} 

switch ($act) {
    case 'all':
        updateAll();
        Common::showWinMsg('ok', $lang['successful'], 'goback');
        break;

    case 'channel':
        updateChannel();
        Common::showWinMsg('ok', $lang['successful'], 'goback');
        break;

    case 'ad':
        updateAd();
        Common::showWinMsg('ok', $lang['successful'], 'goback');
        break;

    case 'link':
        updateLink();
        Common::showWinMsg('ok', $lang['successful'], 'goback');
        break;

    case 'adminmenu':
        updateAdminMenu();
        Common::showWinMsg('ok', $lang['successful'], 'goback');
        break;

    case 'userclass':
        updateUserClass();
        Common::showWinMsg('ok', $lang['successful'], 'goback');
        break;

    case 'tpl_layout':
        updateTemplateLayout();
        Common::showWinMsg('ok', $lang['successful'], 'goback');
        break;

    case 'address':
        updateAddress();
        Common::showWinMsg('ok', $lang['successful'], 'goback');
        break;
} 

require_once(getAdminTemplatePath('cache', $url));

?>