<?php
/**
 * 
 * @file article_edit.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

require_once('../../includes/inc_admin.php');
require_once(EIFR_ROOT . 'admin/mod_article/class_article.php');

$url = 'mod_article/article_edit.php';
Common::checkAdminFileAuth($url); //check file authority
$clComArticle = new ComArticle();

$type = kRequest('type');
$extra_session = $clComArticle -> _CLASSNAME . '_' . $type;

$act = kGet('act');
switch ($act) {
    case 'save_add':
        Common::checkSubmit($extra_session);
        $clComArticle -> addRecords();
        break;

    case 'save_add_content':
        $clComArticle -> addArticleContentRecords();
        break;

    case 'save_edit_base':
        $clComArticle -> editArticleRecords();
        break;

    case 'save_edit_content':
        $clComArticle -> editArticleContentRecords();
        break;

    case 'add_content':
    case 'edit_content':
        $layout = $clComArticle -> get_layout_article_content_edit();
        require_once(getAdminTemplatePath('info_edit_content', $url));
        break;

    case 'comeback_content':
        $clComArticle -> comebackArticleContentRecords();
        break;

    case 'edit_base':
        if ($selectValue) $selectid = $selectValue;
        $type = dbGetFieldValue(TB_ARTICLE, 'type', "id ='$selectid'");
        $pfile = $clComArticle -> getEditProgramFile($type);
        if ($pfile != 'article_edit.php') {
            header("Location:$pfile?act=edit_base&selectid=$selectid");
            exit();
        } 
        $clComArticle -> layout_article_edit();
        break;

    case 'delete':
        $clComArticle -> recycleArticleRecords();
        break;

    case 'delete_content':
        $clComArticle -> recycleArticleContentRecords();
        break;

    case 'delete_forever':
        $clComArticle -> deleteArticleRecords();
        break;

    case 'delete_forever_content':
        $clComArticle -> deleteArticleContentRecords();
        break;

    case 'add':
    default :
        $layout = $clComArticle -> get_layout_article_type_list();
        require_once(getAdminTemplatePath('article_type_list', $url));
        break;
} 

?>
