<?php
/**
 * 
 * @file class_ad.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

require_once(EIFR_ROOT . 'libraries/template.php');

class ComAd {
    function setAdFieldRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?	
        global $selectid, $selectValue, $field_name, $field_value;

        if ($selectValue != '') $selectid = $selectValue;
        $sql = "UPDATE " . TB_AD . "  set $field_name ='$field_value'  WHERE id in (" . $selectid . ")";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showMsg($lang['modifySuccess'], 'success', 'ad.php');
        } else {
            Common::showErrorMsg($lang['modifyFail']);
        } 
    } 

    function deleteRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete'); //have delete authority ?
        global $selectValue;

        $sql = "DELETE FROM " . TB_AD . " WHERE id in (" . $selectValue . ")";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showMsg($lang['delSuccess'], 'success', DIR_INSTALL . 'admin/' . $url);
        } else {
            Common::showErrorMsg($lang['delFail']);
        } 
    } 

    function addRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'add'); //have add authority ?	
        global $title, $starttime, $endtime, $content_open, $content_stop, $layout_id, $channel_type, $channel_id, $flag, $uid;

        $channel_id = addCommaHeadTail($channel_id);
        if ($channel_type == '1') $channel_id = '-1';

        $addtime = time();
        $ip = getIP();
        $id = dbGetMaxValue1(TB_AD, 'id');
        $starttime = getMkTime($starttime);
        $endtime = getMkTime($endtime);
        $title = sTextEncode($title);
        $sql = "insert into " . TB_AD . " (id,title,starttime,endtime,content_open,content_stop,layout_id," . TFR_CHANNEL_ID . ",flag,uid,addtime,ip) values('$id','$title','$starttime','$endtime','$content_open','$content_stop','$layout_id','$channel_id','$flag','$uid','$addtime','$ip')";
        $rs = $db -> Execute($sql);
        if ($rs) {
            $this -> genCache();
            Common::showOkMsg($lang['addSuccess'], 'ad_edit.php', 'ad_edit.php?act=edit&selectid=' . $id, 'ad.php');
        } else {
            Common::showErrorMsg($lang['addFail']);
        } 
        $rs -> Close();
    } 

    function editRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?
        global $selectid, $selectValue, $title, $starttime, $endtime, $content_open, $content_stop, $layout_id, $channel_type, $channel_id, $flag, $uid;

        if ($selectValue) $selectid = $selectValue;

        $channel_id = addCommaHeadTail($channel_id);
        if ($channel_type == '1') $channel_id = '-1';

        $starttime = getMkTime($starttime);
        $endtime = getMkTime($endtime);
        $title = sTextEncode($title);
        $sql = "update " . TB_AD . " set title='$title',starttime='$starttime',endtime='$endtime',content_open='$content_open',content_stop='$content_stop',layout_id='$layout_id'," . TFR_CHANNEL_ID . "='$channel_id',flag='$flag',uid='$uid' where id=" . $selectid . "";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if ($rs) {
            $this -> genCache();
            Common::showOkMsg($lang['saveSuccess'], 'ad_edit.php', 'ad_edit.php?act=edit&selectid=' . $selectid, 'ad.php');
        } else {
            Common::showErrorMsg($lang['saveFail']);
        } 
        $rs -> Close();
    } 

    function layout_ad() {
        global $db, $lang, $url;
        global $search_field, $search_keyword, $layout_id, $flag;
        $is_manage = Common::checkAdminAuth($url, 'manage');

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        // show list---start---
        $manage_sql = '';
        if (!$is_manage) {
            $manage_sql = "  and flag<>4 ";
        } 

        $layout_id_sql = '';
        if ($layout_id != '') {
            $layout_id_sql = " and layout_id='" . $layout_id . "' ";
        } 

        $flag_sql = '';
        if ($flag != '') {
            $flag_sql = " and flag='" . $flag . "' ";
        } 

        $search_sql = '';
        if ($search_keyword != '') {
            $search_sql = " and " . $search_field . " like '%$search_keyword%' ";
        } 
        $sql = "select * from " . TB_AD . " where 1=1 " . $manage_sql . $layout_id_sql . $flag_sql . $search_sql . " order by id asc ";
        $clPages = new Pages();
        $clPages -> query_string = 'flag=' . $flag . '&layout_id=' . $layout_id . '&search_field=' . $search_field . '&search_keyword=' . $search_keyword . '';
        $clPages -> query_sql = $sql; 
        // $clPages->lim =3;
        $aryResult = $clPages -> Execute();
        $rs = $aryResult[0];
        $intList = $aryResult[2];

        if ($intList > 0) {
            $num = 0;
            while (!$rs -> EOF) {
                $num++;

                $clTemplate -> assign_block_vars('ListAd', array('num' => $num,
                        'id' => $rs -> fields['id'],
                        'uid' => $rs -> fields[TF_USER_ID],
                        'username' => dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $rs -> fields[TFR_USER_ID] . "'"),
                        'layout_id' => $rs -> fields['layout_id'],
                        'layout_title' => dbGetFieldValue(TB_TEMPLATE_LAYOUT, 'title', "id='" . $rs -> fields['layout_id'] . "'"),
                        'channel' => dbGetFieldValue(TB_CHANNEL, TF_CHANNEL_TITLE, "" . TF_CHANNEL_ID . " ='" . $rs -> fields[TFR_CHANNEL_ID] . "'"),
                        'channel_nav' => Common::createClassNav(TB_CHANNEL, TF_CHANNEL_ID, TF_CHANNEL_TITLE, $rs -> fields[TFR_CHANNEL_ID]),
                        'title' => $rs -> fields['title'],
                        'starttime' => $rs -> fields['starttime']? getDateTimeMk($rs -> fields['starttime']) : '',
                        'endtime' => $rs -> fields['endtime']? getDateTimeMk($rs -> fields['endtime']) : '',
                        'flag' => Common::createFlagShow($rs -> fields['flag'])
                        ));

                $rs -> MoveNext();
            } 
        } 
        $rs -> Close(); 
        // show list---end---
        $list_flag = '';
        $btn_delete_forever = '';
        $btn_flag = '';
        if ($is_manage) {
            $list_flag .= '<select name="flag" class="input_select" ><option value="">---' . $lang['flag'] . '---</option>';
            $list_flag .= Common::createFlagSelect($flag);
            $list_flag .= '</select>';

            $btn_delete_forever = Common::createToolbar($url, 'delete_forever', 'ad.php?act=delete_forever');
            $btn_flag .= Common::createSplitLine();
            $btn_flag .= Common::createToolbar($url, 'unchecked', 'ad.php?act=setvalue&field_name=flag&field_value=0');
            $btn_flag .= Common::createToolbar($url, 'open', 'ad.php?act=setvalue&field_name=flag&field_value=1');
            $btn_flag .= Common::createToolbar($url, 'locked', 'ad.php?act=setvalue&field_name=flag&field_value=2');
            $btn_flag .= Common::createToolbar($url, 'stop', 'ad.php?act=setvalue&field_name=flag&field_value=3');
        } 

        $toolbar = Common::createToolbar($url, 'add', 'ad_edit.php');
        $toolbar .= Common::createToolbar($url, 'edit', 'ad_edit.php?act=edit');
        $toolbar .= Common::createToolbar($url, 'delete', 'ad.php?act=setvalue&field_name=flag&field_value=4');
        $toolbar .= $btn_delete_forever;
        $toolbar .= $btn_flag;

        if ($layout_id != '') $layout_title = dbGetFieldValue(TB_TEMPLATE_LAYOUT, 'title', "id='" . $layout_id . "'");
        else $layout_title = $lang['layout_select']; 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => $toolbar,
                'list_flag' => $list_flag,
                'layout_id' => $layout_id,
                'layout_title' => $layout_title,
                'pagenext' => $aryResult[3]
                ));

        $clTemplate -> set_filenames(array('body' => 'ad.tpl.html'));
        $clTemplate -> pparse("body");
    } 

    function layout_ad_edit() {
        global $db, $lang, $url;
        global $selectid, $selectValue, $uid, $act;

        if ($selectValue) $selectid = $selectValue;
        $is_manage = Common::checkAdminAuth($url, 'manage');

        $style_display = '';
        if ($act == 'edit') { // edit
            Common::checkAdminExeAuth($url, 'edit');

            $toolbar = Common::createToolbar($url, 'save', 'ad_edit.php?act=save');
            $toolbar .= Common::createToolbar($url, 'delete', 'ad.php?act=setvalue&field_name=flag&field_value=4');
            if ($is_manage) {
                $toolbar .= Common::createToolbar($url, 'delete_forever', 'ad.php?act=delete_forever');
            } 

            $is_edit = '';

            $sql = "select * from " . TB_AD . " where id='" . $selectid . "'";
            $rs = $db -> Execute($sql);
            if (!$rs -> EOF) {
                if (!$is_manage) {
                    $is_edit = ' disabled';
                    $style_display = 'none';
                } 

                $channel_checked_1 = '';
                $channel_checked_2 = '';
                $channel_display = 'none';
                $channel_id = removeCommaHeadTail($rs -> fields[TFR_CHANNEL_ID]);
                if ($channel_id != '' && $channel_id != '-1') {
                    $channel_checked_2 = ' checked';
                    $channel_display = '';
                } 
                if ($channel_id == '-1') $channel_checked_1 = ' checked';

                $id = $rs -> fields['id'];
                $title = $rs -> fields['title'];
                $content_open = $rs -> fields['content_open'];
                $content_stop = $rs -> fields['content_stop'];
                $layout_id = $rs -> fields['layout_id'];
                $layout_title = dbGetFieldValue(TB_TEMPLATE_LAYOUT, 'title', "id='" . $layout_id . "'");
                $flag = $is_manage ? Common::createFlagRadio($rs -> fields['flag']) : Common::createFlagShow($rs -> fields['flag']);
                $channel_id = $rs -> fields[TFR_CHANNEL_ID];
                $channel_title = dbGetFieldValue(TB_CHANNEL, 'title', "id ='" . $channel_id . "'");
                $uid = $rs -> fields[TFR_USER_ID];
                $username = dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $uid . "'");
                $addtime = $rs -> fields['addtime']? getDateTimeMk($rs -> fields['addtime']) : '';
                $starttime = $rs -> fields['starttime']? getDateTimeMk($rs -> fields['starttime']) : '';
                $endtime = $rs -> fields['endtime']? getDateTimeMk($rs -> fields['endtime']) : '';
                $ip = $rs -> fields['ip'];

                if (!$is_manage) {
                    if ($uid != getCookie(COOKIE_UID)) {
                        Common::showWarningMsg($lang['checkAuth']);
                    } 
                } 

                $rs -> Close();
            } else {
                $rs -> Close();
                Common::showErrorMsg($lang['records_inexistence']);
            } 
        } else { // add
            Common::checkAdminExeAuth($url, 'add');
            if (!$is_manage) {
                $style_display = 'none';
            } 
            $toolbar = Common::createToolbar($url, 'save', 'ad_edit.php?act=save');
            $id = '';
            $title = '';
            $content_open = '';
            $content_stop = '';
            $layout_id = '';
            $layout_title = '';
            $channel_id = '';
            $channel_checked_1 = '';
            $channel_checked_2 = '';
            $channel_display = 'none';
            $flag = $is_manage ? Common::createFlagRadio(0) : Common::createFlagShow(0);
            $uid = 0;
            $username = '';
            $addtime = '';
            $starttime = '';
            $endtime = '';
            $ip = getIP();
        } 

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'css_path' => DIR_INSTALL . 'admin/style/',
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => $toolbar
                )); 
        // data
        $clTemplate -> assign_vars(array('selectid' => $selectid,
                'style_display' => $style_display,
                'id' => $id,
                'title' => $title,
                'content_open' => $content_open,
                'content_stop' => $content_stop,
                'layout_id' => $layout_id,
                'layout_title' => $layout_title,
                'channel_id' => $channel_id,
                'channel_checked_1' => $channel_checked_1,
                'channel_checked_2' => $channel_checked_2,
                'channel_display' => $channel_display,
                'flag' => $flag,
                'uid' => $uid,
                'username' => $username,
                'ip' => $ip,
                'addtime' => $addtime,
                'starttime' => $starttime,
                'endtime' => $endtime
                ));

        $clTemplate -> set_filenames(array('body' => 'ad_edit.tpl.html'));
        $clTemplate -> pparse("body");
    } 

    function getAvailableAds() {
        global $db;
        $rtn = array();

        $cacheHelper = new CCacheHelper('db_ad');
        $rtn = $cacheHelper -> getCache();
        if ($rtn !== false) {
            Log_v(__FILE__, __LINE__, 'getAvailableADs from cache');
            return $rtn;
        } 

        $sql = "select * from " . TB_AD . " where flag=1 or flag=2 order by id asc ";
        $rs = dbGetRecordn($sql);
        foreach($rs as $row) {
            $rtn[$row['id']] = array();
            $rtn[$row['id']]['id'] = $row['id'];
            $rtn[$row['id']]['title'] = $row['title'];
            $rtn[$row['id']]['channel_id'] = $row['channel_id'];
            $rtn[$row['id']]['layout_id'] = $row['layout_id'];
            $rtn[$row['id']]['starttime'] = $row['starttime'];
            $rtn[$row['id']]['endtime'] = $row['endtime'];
            $rtn[$row['id']]['content_open'] = $row['content_open'];
            $rtn[$row['id']]['content_stop'] = $row['content_stop'];
        } 
        return $rtn;
    } 

    function genCache() {
        $data = array();
        $cacheHelper = new CCacheHelper('db_ad');
        $cacheHelper -> deleteCache();
        $data = $this -> getAvailableAds();
        $cacheHelper -> writeCache($data);
    } 
} 

?>
