<?php
class CRequest {
    var $_get = array();
    var $_post = array();
    var $_cookie = array();
    var $_request = array();

    public function __construct() {
        if (!defined('FILTER_STRING')) {
            define('FILTER_STRING', '');
        } 

        $this -> _loadRequest();
    } 

    public function request() {
        return $this -> _request;
    } 

    public function get() {
        return $this -> _get;
    } 

    public function post() {
        return $this -> _post;
    } 

    public function cookie() {
        return $this -> _cookie;
    }

    function getUrlQuery($opts=array(), $onlySpecified=false) {
        $getArr = array();
        if(! $onlySpecified) {
            $getArr = $this -> get();
        }
        foreach($opts as $key=>$val) {
            $getArr[$key] = $val;
        }

        $urlQuery = '';
        foreach($getArr as $key=>$val) {
            if($val !='' ) {
                $urlQuery .= "&$key=$val";
            }
        }
        return $urlQuery;
    }

    public function kRequest($key) {
        if (isset($this -> _request[$key])) {
            return $this -> _request[$key];
        } else {
            return null;
        } 
    }

    /**
     * $keys = 'key1,key2'
     */
    public function kRequests($keys) {
        $keyarr = explode(',',$keys);
        $rtn = array();
        foreach ($keyarr as $key) {
            if (isset($this -> _request[$key])) {
                $rtn[$key] = $this -> _request[$key];
            } else {
                $rtn[$key] = null;
            } 
        }
        return $rtn;
    }
    
    public function kGet($key) {
        if (isset($this -> _get[$key])) {
            return $this -> _get[$key];
        } else {
            return null;
        } 
    } 

    /**
     * $keys = 'key1,key2'
     */
    public function kGets($keys) {
        $keyarr = explode(',',$keys);
        $rtn = array();
        foreach ($keyarr as $key) {
            if (isset($this -> _get[$key])) {
                $rtn[$key] = $this -> _get[$key];
            } else {
                $rtn[$key] = null;
            } 
        }
        return $rtn;
    }
    
    public function kPost($key) {
        if (isset($this -> _post[$key])) {
            return $this -> _post[$key];
        } else {
            return null;
        } 
    } 

    /**
     * $keys = 'key1,key2'
     */
    public function kPosts($keys) {
        $keyarr = explode(',',$keys);
        $rtn = array();
        foreach ($keyarr as $key) {
            if (isset($this -> _post[$key])) {
                $rtn[$key] = $this -> _post[$key];
            } else {
                $rtn[$key] = null;
            } 
        }
        return $rtn;
    }
    
    public function kCookie($key) {
        if (isset($this -> _cookie[$key])) {
            return $this -> _cookie[$key];
        } else {
            return null;
        } 
    } 

    /**
     * $keys = 'key1,key2'
     */
    public function kCookies($keys) {
        $keyarr = explode(',',$keys);
        $rtn = array();
        foreach ($keyarr as $key) {
            if (isset($this -> _cookie[$key])) {
                $rtn[$key] = $this -> _cookie[$key];
            } else {
                $rtn[$key] = null;
            } 
        }
        return $rtn;
    }
    
    function _filterString($key, &$value) {
        if (is_array($value)) {
            foreach($value as $_k => $_v) {
                $value[$_k] = $this -> _filterString($key, $_v);
            } 
        } else {
            if (FILTER_STRING != '' && preg_match("/" . FILTER_STRING . "/i", $value)) {
                echo("'$value' is not allowed word!");
                exit();
            } 
            if (! get_magic_quotes_gpc()) {
                $value = addslashes($value);
                //$value = mysql_real_escape_string($value); // does not handle \r\n
            } 
        } 
        return $value;
    } 

    function _loadRequest() {
        foreach(Array('_GET', '_POST', '_COOKIE') as $_request) {
            global ${$_request};
            foreach(${$_request} as $_k => $_v) {
                $_value = $this -> _filterString($_k, $_v);
                $this -> _request[$_k] = $_value;
                switch ($_request) {
                    case '_GET':
                        $this -> _get[$_k] = $_value;
                        break;
                    case '_POST':
                        $this -> _post[$_k] = $_value;
                        break;
                    case '_COOKIE':
                        $this -> _cookie[$_k] = $_value;
                        break;
                } 
            } 
        } 
    } 
} 

unset($_ENV, $HTTP_ENV_VARS, $_REQUEST, $HTTP_POST_VARS, $HTTP_GET_VARS, $HTTP_POST_FILES, $HTTP_COOKIE_VARS);

$clRequest = new CRequest();

function kRequest($key) {
    global $clRequest;
    return $clRequest -> kRequest($key);
} 

function kRequests($keys) {
    global $clRequest;
    return $clRequest -> kRequests($keys);
} 

function kGet($key) {
    global $clRequest;
    return $clRequest -> kGet($key);
} 

function kGets($key) {
    global $clRequest;
    return $clRequest -> kGets($key);
} 

function kPost($key) {
    global $clRequest;
    return $clRequest -> kPost($key);
} 

function kPosts($key) {
    global $clRequest;
    return $clRequest -> kPosts($key);
} 

function kCookie($key) {
    global $clRequest;
    return $clRequest -> kCookie($key);
} 

function kCookies($key) {
    global $clRequest;
    return $clRequest -> kCookies($key);
} 

function Request() {
    global $clRequest;
    return $clRequest -> request();
} 

function Get() {
    global $clRequest;
    return $clRequest -> get();
} 

function Post() {
    global $clRequest;
    return $clRequest -> post();
} 

function Cookie() {
    global $clRequest;
    return $clRequest -> cookie();
}

function getUrlQuery($opts=array(), $onlySpecified=false) {
    global $clRequest;
    return $clRequest -> getUrlQuery($opts, $onlySpecified);
}

// This is effectively the same as register_globals = on
foreach($clRequest -> get() as $_k => $_v) {
    ${$_k} = $_v; 
    // Log_v(__FILE__,__LINE__,'get::'.${$_k}.':'.$_v);
} 

foreach($clRequest -> post() as $_k => $_v) {
    ${$_k} = $_v; 
    // Log_v(__FILE__,__LINE__,'post::'.${$_k}.':'.$_v);
} 

foreach($clRequest -> cookie() as $_k => $_v) {
    if (isset(${$_k})) {
        ${$_k} = $_v; 
        // Log_v(__FILE__,__LINE__,'cookie::',${$_k}.':'.$_v);
    } 
} 

?>