<?php
/**
 * 
 * @file pages.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

class Pages {
    var $type; //Num,PreNextGo,PreNext
    var $lim;
    var $adjacents; // how many adjacent pages should be shown on each side.
    var $query_string;
    var $gotoPage = 1;
    var $start = 0;
    var $query_sql;
    var $currentUrl;
    var $vars;
    var $listNum = 2;
    var $intNext = 1;
    var $totalPages = 1;

    function __construct($type = 'PreNextGo', $lim = 20, $adjacents = 6) {
        $this -> type = $type;
        $this -> lim = $lim;
        $this -> adjacents = $adjacents;
    }     

    function Execute() {
        global $db, $lang;
        $gotoPage = kRequest('gotoPage');
        if ($gotoPage != '') {
            $this -> gotoPage = $gotoPage;
        } 
        $this -> start = ($this -> gotoPage-1) * $this -> lim;

        if ($this -> query_string == '') {
            $this -> currentUrl = basename($_SERVER['PHP_SELF']) . "?";
        } else {
            $this -> currentUrl = basename($_SERVER['PHP_SELF']) . "?" . $this -> query_string . "&";
        } 

        $rs = $db -> Execute($this -> query_sql);
        if ($rs === false) {
            Log_e(__FILE__, __LINE__, $this -> query_sql);
        }
        $rs_count = $rs -> RecordCount();

        $res_lim = $db -> SelectLimit($this -> query_sql, $this -> lim, $this -> start);

        $rtn_arr = array();
        $rtn_arr[0] = $res_lim;
        if ($rs_count > $this -> lim) {
            $rtn_arr[1] = true;
        } else {
            $rtn_arr[1] = false;
        } 
        $rtn_arr[2] = $rs_count;

        $this->totalPages = 1;
        if ($rtn_arr[1]) {
            if ($rs_count % $this -> lim != 0) {
                $this->totalPages = (intval($rs_count / $this -> lim)) + 1;
            } else {
                $this->totalPages = intval($rs_count / $this -> lim);
            } 
        } 

        $rtn_arr[3] = $this -> _showPage();
        $rtn_arr[4] = $this->totalPages;
        return $rtn_arr;
    } 

    function _showPage() {
        if ($this->totalPages == 1) return '';

        switch ($this -> type) {
            case 'Num':
                return $this->_styleNum();
            case 'PreNext':
                return $this->_stylePreNext();
            case 'PreNextGo':
            default:
                return $this->_stylePreNextGo();
        }

        return '';
    } 
   
    function _styleNum() {
        
        $prevlabel = "&lt;";
        $nextlabel = "&gt;";
        
        $pageOutput = "<div class=\"pagination\">\n";
        
        // previous
        if($this -> gotoPage==1) {
            $pageOutput.= "<span class=\"disabled\">" . $prevlabel . "</span>\n";
        }
        elseif($this -> gotoPage==2) {
            $pageOutput.= "<a href=\"" . $this->currentUrl . "\">" . $prevlabel . "</a>\n";
        }
        else {
            $pageOutput.= "<a href=\"" . $this->currentUrl . "gotoPage=" . ($this -> gotoPage-1) . "\">" . $prevlabel . "</a>\n";
        }
        
        // first
        if($this -> gotoPage>($this->adjacents+1)) {
            $pageOutput.= "<a href=\"" . $this->currentUrl . "\">1</a>\n";
        }
        
        // interval
        if($this -> gotoPage>($this->adjacents+2)) {
            $pageOutput.= "...\n";
        }
        
        // gotoPages
        $pmin = ($this -> gotoPage>$this->adjacents) ? ($this -> gotoPage-$this->adjacents) : 1;
        $pmax = ($this -> gotoPage<($this->totalPages-$this->adjacents)) ? ($this -> gotoPage+$this->adjacents) : $this->totalPages;
        for($i=$pmin; $i<=$pmax; $i++) {
            if($i==$this -> gotoPage) {
                $pageOutput.= "<span class=\"current\">" . $i . "</span>\n";
            }
            elseif($i==1) {
                $pageOutput.= "<a href=\"" . $this->currentUrl . "\">" . $i . "</a>\n";
            }
            else {
                $pageOutput.= "<a href=\"" . $this->currentUrl . "gotoPage=" . $i . "\">" . $i . "</a>\n";
            }
        }
        
        // interval
        if($this -> gotoPage<($this->totalPages-$this->adjacents-1)) {
            $pageOutput.= "...\n";
        }
        
        // last
        if($this -> gotoPage<($this->totalPages-$this->adjacents)) {
            $pageOutput.= "<a href=\"" . $this->currentUrl . "gotoPage=" . $this->totalPages . "\">" . $this->totalPages . "</a>\n";
        }
        
        // next
        if($this -> gotoPage<$this->totalPages) {
            $pageOutput.= "<a href=\"" . $this->currentUrl . "gotoPage=" . ($this -> gotoPage+1) . "\">" . $nextlabel . "</a>\n";
        }
        else {
            $pageOutput.= "<span class=\"disabled\">" . $nextlabel . "</span>\n";
        }
        
        $pageOutput.= "</div>";
        
        return $pageOutput;
    }
    
    function _stylePreNextGo() {
        global $lang;
        $pageOutput = '';
        $pageOutput .= "<script language='javascript'>\n";
        $pageOutput .= "function goPage()\n";
        $pageOutput .= "{\n";
        $pageOutput .= "var frm=document.frmChange;\n";
        $pageOutput .= "var intNowPage=frm.gotoPage.value;\n";
        $pageOutput .= "var intStandard=/^[0-9]{1,10}$/;\n";
        $pageOutput .= "if(intStandard.test(intNowPage)){\nif(intNowPage<=0 || intNowPage>" . $this->totalPages . "){\n alert('" . $lang['pages_valid'] . "');\n return false;\n}\n}\n";
        $pageOutput .= "else{return false;}";
        $pageOutput .= "window.location.href='" . $this -> currentUrl . "gotoPage='+intNowPage;";
        $pageOutput .= "}\n";
        $pageOutput .= "</script>";

        $pageOutput .= "<form method='post' name='frmChange' onsubmit='return goPage();'>";
        $pageOutput .= "" . $lang['page_total'] . $this->totalPages . $lang['pages'] . "&nbsp;" . $lang['page_no'] . $this -> gotoPage . $lang['pages'] . "";
        
        // first
        if ($this -> start) {
            $pageOutput .= "&nbsp;&nbsp;<a href='" . $this -> currentUrl . "gotoPage=1' title='" . $lang['page_start'] . "'>" . $lang['page_start'] . "</a>";
        } else {
            $pageOutput .= "&nbsp;&nbsp;" . $lang['page_start'];
        }
        
        // preious
        if ($this -> gotoPage != 1) {
            $pageOutput .= "&nbsp;&nbsp;<a href='" . $this -> currentUrl . "gotoPage=" . ($this -> gotoPage-1) . "' title='" . $lang['page_previous'] . "'>" . $lang['page_previous'] . "</a>";
        } else {
            $pageOutput .= "&nbsp;&nbsp;" . $lang['page_previous'];
        }
        
        // next
        if ($this -> gotoPage >= $this->totalPages) {
            $pageOutput .= "&nbsp;&nbsp;" . $lang['page_next'];
        } else {
            $pageOutput .= "&nbsp;&nbsp;<a href='" . $this -> currentUrl . "gotoPage=" . ($this -> gotoPage + 1) . "' title='" . $lang['page_next'] . "'>" . $lang['page_next'] . "</a>";
        }
        
        // last
        if ($this -> gotoPage == $this->totalPages) {
            $pageOutput .= "&nbsp;&nbsp;" . $lang['page_end'];
        } else {
            $pageOutput .= "&nbsp;&nbsp;<a href='" . $this -> currentUrl . "gotoPage=" . $this->totalPages . "' title='" . $lang['page_end'] . "'>" . $lang['page_end'] . "</a>";
        }
        
        // goto
        $pageOutput .= "&nbsp;&nbsp;" . $lang['page_no'] . "<input type=text name='gotoPage' size=2 class='pagenext_inputnum'>" . $lang['pages'] . "<input type=submit value='GO' class='btn_go'>\n";
        $pageOutput .= "</form>";
        
        return $pageOutput;
    }
    
    function _stylePreNext() {
        $pageOutput = '';
        $intNext = kGet('initNext');
        if ($intNext!='') {
            $this -> intNext = $intNext;
        } 
        $intTemp = ($this -> start / $this -> lim + 1) / $this -> listNum;
        if (($intTemp - intval($intTemp)) > 0) {
            $this -> intNext = intval($intTemp) + 1;
        } else {
            $this -> intNext = intval($intTemp);
        } 

        $page = ($this -> start / $this -> lim) + 1;
        $last = $this -> start - $this -> lim;
        $next = $this -> start + $this -> lim;
        $suffix = '';

        if (is_array($this -> vars)) {
            foreach($this -> vars as $key => $val) {
                $suffix .= "&$key=$val";
            } 
        } 
        $dNum = $this -> start / $this -> lim;

        if ($this->totalPages > $this -> listNum) {
            if ($this -> intNext * $this -> listNum > $this->totalPages) {
                $intPageMax = $this->totalPages;
                $intPageMin = ($this -> intNext-1) * $this -> listNum + 1;
            } else {
                $intPageMax = $this -> intNext * $this -> listNum;
                $intPageMin = ($this -> intNext-1) * $this -> listNum + 1;
            } 
        } else {
            $intPageMax = $this->totalPages;
            $intPageMin = ($this -> intNext-1) * $this -> listNum + 1;
        } 
        if ($this->totalPages % $this -> listNum != 0) {
            $lastNumPage = intval($this->totalPages / $this -> listNum) + 1;
        } else {
            $lastNumPage = intval($this->totalPages / $this -> listNum);
        } 

        ($this -> intNext == 1?$pageOutput .= " <b>&lt;&lt;</b> ":$pageOutput .= " <b><a href='" . $this -> currentUrl . "intNext=" . ($this -> intNext-1) . "&gotoPage=" . (($this -> intNext-1) * $this -> listNum-1) . "'>&lt;&lt;</a></b> ");

        for($n = $intPageMin;$n <= $intPageMax;$n++) {
            ($n == $page ? $pageOutput .= " $n" : $pageOutput .= " <a href=\"" . $this -> currentUrl . "gotoPage=$n$suffix\" title=\"$n\">$n</a>\n");
        } 
        $uNum = $next / $this -> lim + 1;

        ($this -> intNext == $lastNumPage?$pageOutput .= " <b>&gt;&gt;</b> ":$pageOutput .= " <b><a href='" . $this -> currentUrl . "intNext=" . ($this -> intNext + 1) . "&gotoPage=" . (($this -> intNext + 1) * $this -> listNum-1) . "'>&gt;&gt;</a></b> ");

        return $pageOutput;
    }

} 

?>
