<?php
/**
 * 
 * @file layout_data.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

/**
 * ---getChannel_root---
 * 
 * @return array 
 */
function getChannel_root() {
    $channel_root = array();
    $cacheHelper = new CCacheHelper('db_channel');
    $channels = $cacheHelper -> getCache();
    if ($channels) {
        Log_v(__FILE__, __LINE__, 'Channel_root from cache');
        foreach($channels as $key => $val) {
            if (strlen($key) == 2 && $val['flag'] == 2) {
                $channel_root[] = $channels[$key];
            } 
        } 
    } else {
        Log_v(__FILE__, __LINE__, 'Channel_root from db');
        $sql = "select id,title,redirecturl from " . TB_CHANNEL . " where length(id)=2 and status=0 and flag=2 order by ordernum ";
        $channel_root = dbGetRecordn($sql);
    } 
    return $channel_root;
} 

function updateArticleViewnum($num = 1) {
    global $db, $id, $is_preview;
    if ($is_preview) {
        return true;
    } 
    $rtn = false;
    $sql = "update " . TB_ARTICLE . " set viewnum=viewnum+'$num' where id='$id'";
    $rs = $db -> Execute($sql);
    if ($rs) {
        $rtn = true;
    } 
    $rs -> Close();
    return $rtn;
} 

function updateArticleQuantity($id, $num = 0) {
    global $db;
    $rtn = false;
    $sql = "update " . TB_ARTICLE . " set quantity=quantity+'$num' where id='$id'";
    $rs = $db -> Execute($sql);
    if ($rs) {
        $rtn = true;
    } 
    $rs -> Close();
    return $rtn;
}

/**
 * ---getChannelChild---
 * 
 * @return array 
 */
function getChannelChild($id) {
    $rtn = array();
    $cacheHelper = new CCacheHelper('db_channel');
    $channels = $cacheHelper -> getCache();
    if ($channels) {
        Log_v(__FILE__, __LINE__, 'getChannelChild from cache');
        $id_len = strlen($id);
        foreach($channels as $key => $val) {
            if ($key != $id && substr($key, 0, $id_len) == $id && strlen($key) == $id_len + 2) {
                $rtn[] = $channels[$key];
            } 
        } 
    } else {
        Log_v(__FILE__, __LINE__, 'getChannelChild from db');
        $sql = "select id,title from " . TB_CHANNEL . " where id like '" . $id . "__' and status=0 and flag<3 order by ordernum ";
        $rtn = dbGetRecordn($sql);
    } 

    return $rtn;
} 

function createChannelsSelect($select = '') {
    $rtn = '';
    $channel_root = array();
    $cacheHelper = new CCacheHelper('db_channel');
    $channels = $cacheHelper -> getCache();
    if ($channels) {
        Log_v(__FILE__, __LINE__, 'createChannelsSelect from cache');
        foreach($channels as $key => $val) {
            if (strlen($key) == 2) {
                $channel_root[] = $channels[$key];
            } 
        } 
    } else {
        Log_v(__FILE__, __LINE__, 'createChannelsSelect from db');
        $sql = "select id, title from " . TB_CHANNEL . " where status=0 and flag<3 and length(id)=2 order by ordernum";
        $channel_root = dbGetRecordn($sql);
    } 
    foreach($channel_root as $row) {
        $e_s = '';
        if ($row['id'] == $select) {
            $e_s = " selected";
            $select = '';
        } 
        $rtn .= "<option value='" . $row['id'] . "' " . $e_s . ">" . $row['title'] . "</option>\n";
    } 

    return $rtn;
} 

function createChannelsNav($channel_id = '', $idlen = 0) {
    $rtn = '';
    $cacheHelper = new CCacheHelper('db_channel');
    $channels = $cacheHelper -> getCache();
    if ($channel_id != '' && $idlen < strlen($channel_id)) {
        $idlen += 2;
        $cid = substr($channel_id, 0, $idlen);
        $rs = array();
        if ($channels) {
            if (array_key_exists($cid, $channels)) {
                $rs = $channels[$cid];
            } 
        } else {
            $sql = "select id, title from " . TB_CHANNEL . " where status=0 and flag<3 and id='" . $cid . "'";
            $rs = dbGetRecord1($sql);
        } 

        if ($rs) {
            $rtn = "&gt;&gt;<a href='channel.php?id=" . $rs['id'] . "'>" . $rs['title'] . "</a>";
        } 

        $rtn .= createChannelsNav($channel_id, $idlen);
    } 
    return $rtn;
} 

/**
 * ---getLayoutPages---
 * 
 * @param string $layout_code = '', $page_where = '', $page_type = 'Num', $page_lim = 20, $page_adjacents = 6
 * @return array 
 */
function getLayoutPages($layout_code = '', $page_where = '', $page_type = 'Num', $page_lim = 20, $page_adjacents = 6) {
    global $lang, $layout_sql_array;
    if (!isset($layout_sql_array[$layout_code])) {
        showMsg($layout_code . $lang['layout_code_inexistence']);
    } 
    return dbGetRecordPages($layout_sql_array[$layout_code], $page_where, $page_type, $page_lim, $page_adjacents);
} 

/**
 * ---getLayoutn---
 * 
 * @param string $layout_code ='', $template_id=''
 * @return array 
 */
function getLayoutn($layout_code = '', $template_id='') {
    global $lang, $layout_sql_array;
    $sql = '';
    if (!isset($layout_sql_array[$layout_code])) {
        showMsg($layout_code . $lang['layout_code_inexistence']);
    }
    if($template_id != '') {
        $sql = getLayoutSql($layout_code, $template_id);
    } else if (isset($layout_sql_array[$layout_code])) {
        $sql = $layout_sql_array[$layout_code];
    }
    
    return dbGetRecordn($sql);
} 

/**
 * ---getLayout1---
 * 
 * @param string $layout_code ='', $template_id=''
 * @return array 
 */
function getLayout1($layout_code = '', $template_id='') {
    global $lang, $layout_sql_array;
    $sql = '';
	if (!isset($layout_sql_array[$layout_code])) {
        showMsg($layout_code . $lang['layout_code_inexistence']);
    }
    if($template_id != '') {
        $sql = getLayoutSql($layout_code, $template_id);
    } else if (isset($layout_sql_array[$layout_code])) {
        $sql = $layout_sql_array[$layout_code];
    }

    return dbGetRecord1($sql);
} 

/**
 * ---getLayout---
 * 
 * @param int $type =0,
 * @param string $layout_code ='',$page_where=''
 * @return array 
 */
function getLayout($type = 0, $layout_code = '', $page_where = '') { // 1:one record ; 2:multi-recodes 3: multi-recodes page break
    if ($type = 1) return getLayout1($layout_code);
    if ($type = 2) return getLayoutn($layout_code);
    if ($type = 3) return getLayoutPages($layout_code, $page_where = '');
} 

/**
 * ---getAdvertisement---
 * 
 * @param string $layout_id ='',$cur_channel_id=''
 * @return String 
 */
function getAdvertisement($layout_id = '', $cur_channel_id = '') {
    global $db;
    $rtn = '';
    $now_time = time();
    Log_d(__FILE__, 'getAdvertisement', "layout_id:$layout_id, channel_id:$cur_channel_id");
    if ($layout_id == '')return $rtn;
    $cacheHelper = new CCacheHelper('db_ad');
    $ads = $cacheHelper -> getCache();
    if ($ads) {
        Log_v(__FILE__, __LINE__, 'getAdvertisement from cache');
    } else {
        Log_v(__FILE__, __LINE__, 'getAdvertisement from db');
        $sql = "select * from " . TB_AD . " where flag=1 or flag=2";
        $ads = dbGetRecordn($sql);
    } 

    foreach ($ads as $row) {
        $channel_id = $row['channel_id'];
        if ($row['layout_id'] != $layout_id) {
            continue;
        } 

        if ($cur_channel_id != '') {
            if ($row['channel_id'] == '') {
                continue;
            } else {
                $channel_arr = explode(',', removeCommaHeadTail($row['channel_id']));
                if (!in_array($cur_channel_id, $channel_arr)) {
                    continue;
                } 
            } 
        } 

        $rtn = $row['content_stop'];
        if ($row['content_open'] != '') {
            $row['starttime'] = (int) $row['starttime'];
            $row['endtime'] = (int) $row['endtime'];
            if ($row['starttime'] === 0 && $row['endtime'] === 0) {
                $rtn = $row['content_open'];
            } else if ($row['starttime'] === 0 && $now_time <= $row['endtime']) {
                $rtn = $row['content_open'];
            } else if ($now_time >= $row['starttime'] && $row['endtime'] === 0) {
                $rtn = $row['content_open'];
            } else if ($now_time >= $row['starttime'] && $now_time <= $row['endtime']) {
                $rtn = $row['content_open'];
            } 
        } 

        Log_d('', 'getAdvertisement', "match layout_id: $row[layout_id]");
    } 

    return $rtn;
} 

/**
 * ---getLink---
 * 
 * @param string $layout_id ='',$cur_channel_id=''
 * @return String 
 */
function getLink($cur_layout_id = '', $cur_channel_id = '') {
    global $db;
    $rtn = array();
    Log_d(__FILE__, __LINE__, "layout_id:$cur_layout_id, channel_id:$cur_channel_id");
    if ($cur_layout_id == '')return $rtn;

    $cacheHelper = new CCacheHelper('db_link');
    $links = $cacheHelper -> getCache();
    if ($links) {
        Log_v(__FILE__, __LINE__, 'getLink from cache');
    } else {
        Log_v(__FILE__, __LINE__, 'getLink from db');
        $sql = "select * from " . TB_LINK . " where flag=1 or flag=2";
        $links = dbGetRecordn($sql);
    } 

    foreach ($links as $row) {
        if ($cur_layout_id != '' && $row['layout_id'] != '-1') {
            $layout_id_arr = explode(',', removeCommaHeadTail($row['layout_id']));
            if (!in_array($cur_layout_id, $layout_id_arr)) {
                continue;
            } 
        } 
        if ($cur_channel_id != '' && $row['channel_id'] != '-1') {
            $channel_arr = explode(',', removeCommaHeadTail($row['channel_id']));
            if (!in_array($cur_channel_id, $channel_arr)) {
                continue;
            } 
        } 

        $rtn[] = $row;
    } 

    return $rtn;
} 


function getTemplateByID($id = '') {
    $cacheHelper = new CCacheHelper('db_template');
    $templates = $cacheHelper -> getCache();
    if ($templates) {
        if (isset($templates[$id])) {
            Log_v(__FILE__, __LINE__, 'getTemplateByID from cache');
            return $templates[$id];
        } 
    } 

    $sql = "select * from " . TB_TEMPLATE . " where id='$id'";
    $rtn = dbGetRecord1($sql);
    if ($rtn) {
        Log_v(__FILE__, __LINE__, 'getTemplateByID from db');
        return $rtn;
    } 

    return false;
} 

/**
 * ---getTemplate---
 * 
 * @param string $pfile ='',$def_tplfile=''
 * @return array 
 */
function getTemplate($pfile = '', $def_tplfile = '') {
    Log_d(__FILE__, __LINE__, "getTemplate, pfile:$pfile, tplfile:$def_tplfile");
    $cacheHelper = new CCacheHelper('db_template');
    $templates = $cacheHelper -> getCache();
    if ($templates) {
        foreach($templates as $row) {
            if ($row['program_filename'] == $pfile && $row['template_filename'] == $def_tplfile) {
                Log_v(__FILE__, __LINE__, 'getTemplate from cache');
                return $row;
            } 
        } 
    } 

    $strsql = '';
    if ($def_tplfile != '') {
        $strsql = " and template_filename ='$def_tplfile' ";
    } 
    $sql = "select * from " . TB_TEMPLATE . " where program_filename='$pfile' $strsql order by flag desc, ordernum asc limit 1";
    $rtn = dbGetRecord1($sql);
    if ($rtn) {
        Log_v(__FILE__, __LINE__, 'getTemplate from db');
        return $rtn;
    } 

    return false;
} 

/**
 * ---getTemplateLayoutArray---
 * 
 * @param string $template_id =''
 * @return array 
 */
function getTemplateLayoutArray($template_id = '') {
    $cacheHelper = new CCacheHelper('db_template');
    $templates = $cacheHelper -> getCache();
    if ($templates) {
        if (isset($templates[$template_id])) {
            if (isset($templates[$template_id]['eifrtf_layout'])) {
                Log_v(__FILE__, __LINE__, 'getTemplateLayoutArray from cache');
                return $templates[$template_id]['eifrtf_layout'];
            } 
        } 
    } 

    $sql = "select * from " . TB_TEMPLATE_LAYOUT . " where template_id='" . $template_id . "' order by ordernum asc";
    $rtn = dbGetRecordn($sql);
    if ($rtn) {
        Log_v(__FILE__, __LINE__, 'getTemplateLayoutArray from db');
        return $rtn;
    } 

    Log_d(__FILE__, __LINE__, 'getTemplateLayoutArray not found');
    return array();
} 

/**
 * ---getTemplateLayout---
 * 
 * @param string $layout_code, $template_id
 * @return string 
 */
function getTemplateLayout($layout_code, $template_id) {
    $cacheHelper = new CCacheHelper('db_template');
    $templates = $cacheHelper -> getCache();
    if ($templates) {
        if (isset($templates[$template_id])) {
            if (isset($templates[$template_id]['eifrtf_layout'])) {
                foreach($templates[$template_id]['eifrtf_layout'] as $row) {
                    if($row['layout_code']==$layout_code) {
                        Log_v(__FILE__, __LINE__, 'getTemplateLayout from cache');
                        return $row;
                    }
                }
            } 
        } 
    } 

    $sql = "select * from " . TB_TEMPLATE_LAYOUT . " where layout_code='$layout_code' and template_id='$template_id' ";
    $rtn = dbGetRecord1($sql);
    if ($rtn) {
        Log_v(__FILE__, __LINE__, 'getTemplateLayout from db');
        return $rtn;
    } 

    Log_e(__FILE__, __LINE__, "getTemplateLayout($layout_code, $template_id) not found");
    return '';
} 

/**
 * ---getLayoutSql---
 * 
 * @param string $layout_code, $template_id
 * @return string 
 */
function getLayoutSql($layout_code, $template_id) {
    $tplLayout = getTemplateLayout($layout_code, $template_id);
    return $tplLayout['sql_select'];
} 

/**
 * ---getLayoutId---
 * 
 * @param string $layout_code ='', $template_id=''
 * @return array 
 */
function getLayoutId($layout_code = '', $template_id='') {
    if ($template_id =='') {
        global $template_array;
        if ($template_array) $template_id = $template_array['id'];
    }
    $tplLayout = getTemplateLayout($layout_code, $template_id);
    return $tplLayout['id'];
}

?>
