<?php
/**
 * 
 * @file function.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

/**
 * ---checkVar---
 * check variable is exist?
 * 
 * @param  $var 
 */
function checkVar($var) {
    if (isset($var)) return $var;
    else return '';
} 

/**
 * ---checkUsername---
 * check is invalid?
 * 
 * @param string $str 
 * @param int $mixlen =2,$maxlen=20
 */
function checkUsername($str, $minslen = 2, $maxslen = 20) {
    $rtn_len = false;
    $slen = strlen($str);
    if (($slen - $maxslen > 0) || ($minslen - $slen > 0)) $rtn_len = true;
    $rtn_match = preg_match("/[;%'<>\\\?\*\$\r\n\t]/", $str);
    if ($rtn_len || $rtn_match) return false;
    else return true;
} 

function checkVcode($skey, $vcode) {
    if (!isset($_SESSION[$skey]) || $_SESSION[$skey] != $vcode) {
        return false;
    }
    if (isset($_SESSION[$skey])) {
        unset($_SESSION[$skey]);
    }
    return true;
}


/**
 * ---getAdminComDir---
 * get admin component directory
 * 
 * @param string $url =''
 */
function getAdminComDir($url = '') {
    $rtn = explode('/', $url);
    return $rtn[0];
} 

/**
 * ---getTemplatePath---
 * 
 * @param string $tplfile =''
 * @return array 
 */
function getTemplatePath($tplfile = '') {
    if (defined('SYS_OUTER_DIR')) {
        return SYS_OUTER_DIR . 'templates/' . SYS_DEFAULT_STYLE . '/' . $tplfile . '.' . SYS_TEMPLATE_SUFFIX;
    } 
    return DIR_TEMPLATE_NAME . '/' . SYS_DEFAULT_STYLE . '/' . $tplfile . '.' . SYS_TEMPLATE_SUFFIX;
} 

function getAdminTemplatePath($tplfile = '', $path = '') {
    global $url;
    if ($path != '') {
        $url = $path;
    } 
    if (defined('SYS_OUTER_DIR')) {
        return SYS_OUTER_DIR.'admin/templates/'.SYS_DEFAULT_STYLE.'/'.getAdminComDir($url).'/'.$tplfile.'.'.SYS_TEMPLATE_SUFFIX;
    } 
    return '../' . DIR_TEMPLATE_NAME . '/' . SYS_DEFAULT_STYLE . '/' . getAdminComDir($url) . '/' . $tplfile . '.' . SYS_TEMPLATE_SUFFIX;
} 

/**
 * ---getAdminTemplateDir---
 * 
 * @param string $url =''
 * @return string 
 */
function getAdminTemplateDir($url = '') {
    if (defined('SYS_OUTER_DIR')) {
        return SYS_OUTER_DIR.'admin/templates/'.SYS_DEFAULT_STYLE.'/'.getAdminComDir($url);
    } 
    return '../' . DIR_TEMPLATE_NAME . '/' . SYS_DEFAULT_STYLE . '/' . getAdminComDir($url);
} 

/**
 * ---getIP---
 * get client ip
 * 
 * @return string 
 */
function getIP() {
    if (getenv("HTTP_CLIENT_IP") && strcasecmp(getenv("HTTP_CLIENT_IP"), "unknown"))
        $ip = getenv("HTTP_CLIENT_IP");
    else if (getenv("HTTP_X_FORWARDED_FOR") && strcasecmp(getenv("HTTP_X_FORWARDED_FOR"), "unknown"))
        $ip = getenv("HTTP_X_FORWARDED_FOR");
    else if (getenv("REMOTE_ADDR") && strcasecmp(getenv("REMOTE_ADDR"), "unknown"))
        $ip = getenv("REMOTE_ADDR");
    else if (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], "unknown"))
        $ip = $_SERVER['REMOTE_ADDR'];
    else
        $ip = "unknown";
    return($ip);
} 

/**
 * ---showMsg---
 * alert message and turn url
 * 
 * @param string $msg 
 * @param string $page_to 
 */
function showMsg($msg = '', $page_to = '') {
	echo '<meta http-equiv="Content-Type" content="text/html; charset=' . SYS_CHARSET . '" />';
    if ($msg !== '') {
        echo"<SCRIPT LANGUAGE='JavaScript'>alert('" . $msg . "');</SCRIPT>";
    } 
    switch ($page_to) {
        case '':
            echo"<SCRIPT LANGUAGE='JavaScript'></SCRIPT>";
            break;
        case '-1':
            echo"<SCRIPT LANGUAGE='JavaScript'>history.go(-1);</SCRIPT>";
            break;
        case 'top':
            echo"<SCRIPT LANGUAGE='JavaScript'>top.location='index.php';</SCRIPT>";
            break;
        default :
            echo"<SCRIPT LANGUAGE='JavaScript'>location='$page_to';</SCRIPT>";
            break;
    } 
} 

/**
 * ---goErrorPage---
 * go error page
 */
function goErrorPage($msg = '') {
    Log_e('', 'goErrorPage', "$msg");
    //if (IS_DEBUG) return;

    addCookie(COOKIE_ERRMSG, $msg);
    header("Location:" . DIR_INSTALL . "error.php");
    exit(1);
} 

/**
 * ---goPage---
 * go to page
 */
function goPage($url = '', $savecburl = '') {
    if ($savecburl != '') {
        addCookie('eifr_gopage', $savecburl);
    }
    
    $tourl = getCookie('eifr_gopage');
    if($tourl!='') {
        delCookie('eifr_gopage');
        header('Location:'.$tourl);
        exit(0);
    }
    
    if ($url != '') {
        header('Location:'.$url);
        exit(0);
    }
} 

/**
 * ---checkOverMaxNum---
 * check $num is over $maxnum
 * 
 * @param int $num ,$maxnum
 */
function checkOverMaxNum($num, $maxnum) {
    global $lang;
    if ($num > $maxnum) {
        showMsg($lang['overMaxNum'] . '"' . $maxnum . '"', '', '-1');
        exit();
    } 
} 

/**
 * ---createSplitLine---
 * create split line
 * 
 * @param string $showtype =''
 * @param string $height =18
 * @return string 
 */
function createSplitLine($showtype = '', $height = 18) {
    $rtn = '<img src="' . SYS_ADMIN_STYLE_PATH . 'images/blank.gif" align="absmiddle" style="width:1px; height:' . $height . 'px; border:1px solid; border-color:	ButtonHighlight ButtonShadow ButtonShadow ButtonHighlight;">&nbsp;';
    return $rtn;
} 

function getArrayWithoutEmpty($str = '', $separator = ' ') {
	$arr = array();
	if($str === '') return $arr;
    $str_arr = explode($separator, $str);
    $arr = array();
    foreach ($str_arr as $val) {
        if($val !== '') {
            array_push($arr,$val);
        }
    }
	return $arr;
}

?>
