<?php
/**
 * 
 * @file function.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

/**
 * ---dQuotEncode---
 * 
 * @param string $str 
 * @return string 
 */
function dQuotEncode($str) {
    $str = str_replace("\"", "&quot;", $str);
    return $str;
} 

/**
 * ---dQuotDecode---
 * 
 * @param string $str 
 * @return string 
 */
function dQuotDecode($str) {
    $str = str_replace("&quot;", "\"", $str);
    return $str;
} 

/**
 * ---sTextEncode---
 * 1 line
 * 
 * @param string $str 
 * @param int $str_lenght =-1
 * @return string 
 */
function sTextEncode($str, $str_lenght = -1) {
    $str = str_replace(">", "&gt;", $str);
    $str = str_replace("<", "&lt;", $str);

    if ($str_lenght != -1) $str = utfSubstr($str, $str_lenght);
    return $str;
} 

/**
 * ---cStr_substr---
 * 
 * @param string $str 
 * @param int $slen ,$startdd=0
 * @return string 
 */
function cStr_substr($str, $slen, $startdd = 0) {
    if (strlen($str) <= $slen) return $str;

    $restr = "";
    $c = "";
    $str_len = strlen($str);
    if ($str_len < $startdd + 1) return "";
    if ($str_len < $startdd + $slen || $slen == 0) $slen = $str_len - $startdd;
    $enddd = $startdd + $slen - 1;
    for($i = 0;$i < $str_len;$i++) {
        if ($startdd == 0) $restr .= $c;
        else if ($i > $startdd) $restr .= $c;

        if (ord($str[$i]) > 0x80) {
            if ($str_len > $i + 1) $c = $str[$i] . $str[$i + 1];
            $i++;
        } else {
            $c = $str[$i];
        } 

        if ($i >= $enddd) {
            if (strlen($restr) + strlen($c) > $slen) break;
            else {
                $restr .= $c;
                break;
            } 
        } 
    } 
    return $restr;
} 


function stripTags($str, $allow = '') {
    $str = strip_tags($str, $allow);
    $str = HTMLEncode($str);
    return $str;
} 

/**
 * ---utfSubstr---
 * 
 * @param string $str 
 * @param int $slen 
 * @return string 
 */
function utfSubstr($str, $len) {
    for($i = 0;$i < $len;$i++) {
        $temp_str = substr($str, 0, 1);
        if (ord($temp_str) > 127) {
            $i++;
            if ($i < $len) {
                $new_str[] = substr($str, 0, 3);
                $str = substr($str, 3);
            } 
        } else {
            $new_str[] = substr($str, 0, 1);
            $str = substr($str, 1);
        } 
    } 
    return join($new_str);
} 

function substrWithMore($str,$len,$more='..') {
    if(strlen($str)<= $len) {
        return utfSubstr($str, $len);
    } else {
        return utfSubstr($str, $len-strlen($more)) . $more;
    }
}

/**
 * fix unserialize error
 * Notice: unserialize() [function.unserialize]: Error at offset if uft8
 */
function unserializeFixed($str) {
    return unserialize(preg_replace('!s:(\d+):"(.*?)";!se', '"s:".strlen("$2").":\"$2\";"', $str));
}

/**
 * ---HTMLEncode---
 * char replace, unEncode html
 * 
 * @param string $str 
 * @return String 
 */
function HTMLEncode($str) {
    $str = str_replace("&gt;", ">", $str);
    $str = str_replace("&lt;", "<", $str);
    $str = str_replace("<br>", chr(10), $str);
    $str = str_replace("<br/>", chr(10), $str);
    $str = str_replace("<br />", chr(10), $str);
    return $str;
} 

/**
 * ---HTMLEncode2---
 * char replace, Encode html
 * 
 * @param string $str 
 * @return String 
 */
function HTMLEncode2($str) {
    $str = str_replace(">", "&gt;", $str);
    $str = str_replace("<", "&lt;", $str);
    $str = str_replace(chr(10), "<br>", $str);
    $str = str_replace(chr(10), "<br/>", $str);
    $str = str_replace(chr(10), "<br />", $str);
    return $str;
} 

/**
 * ---filterContent---
 * char replace, delete script
 * 
 * @param string $str 
 * @return String 
 */
function filterContent($str = '') {
    $str = preg_replace("/<script(.*)\\/script>/isU", "", $str);
    return $str;
} 

/**
 * ---filterUsername---
 * char replace
 * 
 * @param  $var 
 */
function filterUsername($str) {
    return preg_replace("/[;%'<> \\\?\*\$\r\n\t]/", "", $str);
} 

/**
 * ---mediaScriptParse---
 * char replace, Encode html
 * 
 * @param string $str =''
 * @return String 
 */
function mediaScriptParse($str = '') {
    // $str = preg_replace("/<script(.*)\\/script>/isU","",$str);
    $str = preg_replace("/<div\s+(.*)\s*eifr_mediavalue=\"(.*)\"\s+(.*)\s*eifr_mediaattributes=\"(.*)\"\s*(.*)<\/div>/isU",
        "<script>mediaPlay('\\2','\\4')</script>",
        $str);
    $str = preg_replace("/<div\s+(.*)\s*eifr_mediaattributes=\"(.*)\"\s+(.*)\s*eifr_mediavalue=\"(.*)\"\s*(.*)<\/div>/isU",
        "<script>mediaPlay('\\4','\\2')</script>",
        $str);
    return $str;
} 

/**
 * ---getDateTimeMk---
 * get format time
 * 
 * @param int $mktime 
 * @return string "%Y-%m-%d %H:%M:%S"
 */
function getDateTimeMk($mktime) {
    if (!$mktime || preg_match("/[^0-9]/", $mktime)) return "";
    return strftime("%Y-%m-%d %H:%M:%S", $mktime);
} 

/**
 * ---getDateTimeMk_YMDHM---
 * get format time
 * 
 * @param int $mktime 
 * @return string "%Y-%m-%d %H:%M"
 */
function getDateTimeMk_YMDHM($mktime) {
    if (!$mktime || preg_match("/[^0-9]/", $mktime)) return "";
    return strftime("%Y-%m-%d %H:%M", $mktime);
} 

/**
 * ---getDateTimeMk_YMD---
 * get format time
 * 
 * @param int $mktime 
 * @return string "%Y-%m-%d"
 */
function getDateTimeMk_YMD($mktime) {
    if (!$mktime || preg_match("/[^0-9]/", $mktime)) return "";
    return strftime("%Y-%m-%d", $mktime);
} 

/**
 * ---getDateTimeMk_MD---
 * get format time
 * 
 * @param int $mktime 
 * @return string "%m-%d"
 */
function getDateTimeMk_MD($mktime) {
    if (!$mktime || preg_match("/[^0-9]/", $mktime)) return "";
    return strftime("%m-%d", $mktime);
} 

/**
 * ---getMkTime---
 * reset format time
 * 
 * @param int $dtime "%Y-%m-%d %H:%M:%S"
 * @return int 
 */
function getMkTime($dtime) {
    global $lang;

    if (!preg_match("/[^0-9]/", $dtime)) return 0;
    $dt = Array(1970, 1, 1, 0, 0, 0);
    $dtime = preg_replace("/[\r\n\t]|" . $lang['day'] . "|" . $lang['second'] . "/", " ", $dtime);
    $dtime = str_replace($lang['year'], "-", $dtime);
    $dtime = str_replace($lang['month'], "-", $dtime);
    $dtime = str_replace($lang['hour'], ":", $dtime);
    $dtime = str_replace($lang['minute'], ":", $dtime);
    $dtime = trim(preg_replace("/[ ]{1,}/", " ", $dtime));
    $ds = explode(" ", $dtime);
    $ymd = explode("-", $ds[0]);
    if (isset($ymd[0])) $dt[0] = $ymd[0];
    if (isset($ymd[1])) $dt[1] = $ymd[1];
    if (isset($ymd[2])) $dt[2] = $ymd[2];
    if (strlen($dt[0]) == 2) $dt[0] = '20' . $dt[0];
    if (isset($ds[1])) {
        $hms = explode(":", $ds[1]);
        if (isset($hms[0])) $dt[3] = $hms[0];
        if (isset($hms[1])) $dt[4] = $hms[1];
        if (isset($hms[2])) $dt[5] = $hms[2];
    } 
    foreach($dt as $k => $v) {
        $v = preg_replace("/^0{1,}/", "", trim($v));
        if ($v == "") $dt[$k] = 0;
    } 
    $mt = @mktime($dt[3], $dt[4], $dt[5], $dt[1], $dt[2], $dt[0]);
    if ($mt > 0) return $mt;
    else return time();
} 

/**
 * ---sqlESC---
 * parse sql word
 * 
 * @param string $string 
 * @return string 
 */
function sqlESC($string = '') {
    if (strnatcmp(PHP_VERSION, '4.3.0') >= 0) {
        return mysql_real_escape_string($string);
    } 
    $string = str_replace("'", "\\'" , str_replace('\\', '\\\\', str_replace("\0", "\\\0", $string)));
    return $string;
} 

/**
 * ---sqlParse---
 * parse sql word
 * 
 * @param string $sql 
 * @return string 
 */
function sqlParse($str = '') {
    return $str;
} 

/**
 * ---CheckSqlIn---
 * char replace, prevent sql attack
 * 
 * @param string $str 
 * @return String 
 */
function CheckSqlIn($str) {
    $str = str_replace("'", " ", $str);
    $str = str_replace(";", " ", $str);
    $str = str_replace("--", " ", $str);
    $str = str_replace("%", " ", $str);
    $str = str_replace("/*", " ", $str);
    $str = htmlspecialchars(strip_tags($str));
    return $str;
} 

function encode($str) {
    return base64_encode($str);
} 

function decode($str) {
    return base64_decode($str);
} 

function addCommaHeadTail($str = '') {
    $str = trim($str);
    if ($str == '') return $str;
    if (substr($str, 0, 1) != ',') {
        $str = ',' . $str;
    } 
    if (substr($str, -1) != ',') {
        $str = $str . ',';
    } 
    return $str;
} 

function removeCommaHeadTail($str = '') {
    $str = trim($str);
    if ($str == '') return $str;
    if (substr($str, 0, 1) == ',') {
        $str = substr($str, 1);
    } 
    if (substr($str, -1) == ',') {
        $str = substr($str, 0, -1);
    } 
    return $str;
} 

?>
