<?php
/**
 * 
 * @file file.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

class CFile {
    public static function mkDirs($dir) {
        if (!is_dir($dir)) {
            if (!self :: mkDirs(dirname($dir))) {
                return false;
            } 

            if (!mkdir($dir, 0777)) {
                return false;
            } 
        } 
        return true;
    } 

    public static function rmAll($dir) {
        $dh = opendir($dir);
        while ($file = readdir($dh)) {
            if ($file != "." && $file != "..") {
                $fullpath = $dir . "/" . $file;
                if (!is_dir($fullpath)) {
                    unlink($fullpath);
                } else {
                    self :: rmAll($fullpath);
                } 
            } 
        } 

        closedir($dh);

        if (is_dir($dir)) {
            if (rmdir($dir)) {
                return true;
            } else {
                return false;
            } 
        } 
        return true;
    } 

    public static function removeLastSlash($dir) {
        if ($dir == '')
            return $dir;
        $len = strlen($dir);
        $lastchar = substr($dir, $len-1);
        if ($lastchar == '/') {
            $dir = substr($dir, 0, $len-1);
        }
        return $dir;
    } 

    public static function removeInstallDir($dir) {
        if ($dir == '')
            return $dir;
        
        if (substr($dir, 0, strlen(DIR_INSTALL)) == DIR_INSTALL) {
            $dir = substr($dir, strlen(DIR_INSTALL));
        }
        return $dir;
    }

    /**
     * ---getParentFolder---
     */
    public static function getParentFolder($folderPath) {
        $sPattern = "-[/\\\\][^/\\\\]+[/\\\\]?$-" ;
        return preg_replace($sPattern, '', $folderPath) ;
    } 

    /**
     * ---createServerFolder---
     */
    public static function createServerFolder($folderPath) {
        $sParent = self :: getParentFolder($folderPath) ; 
        Log_v(__FILE__, __LINE__, "createServerFolder '$sParent' start...");
        // Check if the parent exists, or create it.
        if (!file_exists($sParent)) {
            $sErrorMsg = self :: createServerFolder($sParent) ;
            if ($sErrorMsg != '') {
                Log_e(__FILE__, __LINE__, "createServerFolder '$sParent' fail ($sErrorMsg)");
                return $sErrorMsg ;
            }
        } 

        if (!file_exists($folderPath)) {
            // Turn off all error reporting.
            error_reporting(0) ; 
            // Enable error tracking to catch the error.
            ini_set('track_errors', '1') ; 
            // To create the folder with 0777 permissions, we need to set umask to zero.
            $oldumask = umask(0) ;
            Log_v(__FILE__, __LINE__, "createServerFolder '$folderPath' start...");
            mkdir($folderPath, 0777) ;
            umask($oldumask) ;

            $sErrorMsg = $php_errormsg ; 
            // Restore the configurations.
            ini_restore('track_errors') ;
            ini_restore('error_reporting') ;

            return $sErrorMsg ;
        } else {
            return '' ;
        }
    } 

    /**
     * ---getPhysicalPath---
     * get Physical Path
     * 
     * @return string 
     */
    public static function getPhysicalPath() {
        return str_replace("\\", "/", dirname(__FILE__));
    } 

    /**
     * ---getRelativePath---
     * get relative path
     * 
     * @param string $needlepath =''
     * @return string 
     */

    public static function getRelativePath($destpath) {
        $curpath = $_SERVER['PHP_SELF'];
        $returnPath = array(dirname($curpath));
        $arrDestPath = explode('/', $destpath);
        $arrCurPath = explode('/', $returnPath[0]);

        for ($n = 1, $len = count($arrCurPath); $n < $len; $n++) {
            if ($arrDestPath[$n] != $arrCurPath[$n]) {
                break;
            } 
        } 
        if ($len - $n > 0) {
            $returnPath = array_fill(1, $len - $n, '..');
        } 
        $returnPath = array_merge($returnPath, array_slice($arrDestPath, $n));
        return implode('/', $returnPath);
    } 

    /**
     * ---listDirs---
     * list all dir
     */
    public static function listDirs($dir, $default) {
        $diroption = "";
        if ($handle = opendir($dir)) {
            while (false !== ($file = readdir($handle))) {
                if ($file != "." && $file != "..") {
                    if ($file == $default) {
                        $selectd = "selected";
                    } 
                    $diroption .= "<option value=$file " . $selectd . ">$file</option>\n";
                } 
            } 
            closedir($handle);
        } 
        Return $diroption;
    } 
    
    /**
     * get path by date
     * format is 0000/00/00
     */
    public static function genDatePath() {
        $now = time();
        $date_path = date('Y', $now) . '/' . date('m', $now) . '/' . date('d', $now);
        return $date_path;
    } 
} 

?>
