<?php
/**
 * 
 * @file guestbook.php
 * @copyright (c) 2005 - 2011 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */
require_once(dirname(__FILE__) . '/includes/inc_general.php');
require_once(dirname(__FILE__) . '/libraries/pages.php');


function saveGuestbook() {
    global $lang;
	
    if (! checkVcode('eifr_checkvcode', kPost('vcode'))) {
        showMsg($lang['vincorrect_vcode'], '-1');
        exit();
    }
    
    Log_d(__FILE__, __LINE__, 'saveGuestbook start');
    $uid = 0;
    if (getCookie(COOKIE_UID) != '') {
        $uid = getCookie(COOKIE_UID);
    } 

	$title = sTextEncode(kPost('title'));

	$contact = '';
    $contact_arr = array();
    if (kPost('contact') != '') $contact_arr['contact'] = kPost('contact');
    if (kPost('email') != '') $contact_arr['email'] = kPost('email');
    if ($contact_arr) $contact = serialize($contact_arr);

	$content = '';
    if (kPost('content') != '') $content = HTMLEncode2(kPost('content'));

    $record_arr = array(
		'uid' => $uid,
		'nickname' => kPost('nickname'),
		'title' => $title,
        'contact' => $contact,
		'content' => $content,
		'addtime' => time(),
		'ip' => getIP(),
        'flag' => kPost('flag')
        );

    if (dbInsert(TB_GUESTBOOK, $record_arr)) {
        Log_d(__FILE__, __LINE__, 'saveGuestbook successful');
        showMsg('', 'guestbook.php?act=saveok');
    } else {
        showMsg($lang['addFail']);
    } 
} 


function getGuestbookList($num) {
	$id = kGet('id');
	$qsql = " where flag>0 and flag <3 ";
	if($id != '') {
		$qsql .= " and id='$id' ";
	}
	$sql = "select * from " . TB_GUESTBOOK . " $qsql order by id desc";
	$page_where = "id=$id";
	return dbGetRecordPages($sql, $page_where, 'Num', $num) ;
} 

// ---start---
if ($tpl_file == '') {
    $tpl_file = 'guestbook';
} 

$act = kRequest('act');
if ($act == 'save') {
    saveGuestbook();
}

$navigation = '';

require_once(getTemplatePath($tpl_file));
?>
