<?php
/**
 * 
 * @file channel.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */
require_once(dirname(__FILE__) . '/includes/inc_general.php');
require_once(dirname(__FILE__) . '/libraries/pages.php');

function getChannelTitles($id) {
    global $db ;
    if (empty($id)) {
        return '';
    } 

    $rtn_ary = array();
    $cacheHelper = new CCacheHelper('db_channel');
    $channels = $cacheHelper -> getCache();
    if ($channels) {
        if (array_key_exists($id, $channels)) {
            Log_d(__FILE__, __LINE__, 'getChannelTitles from cache');
            for($i = strlen($id); $i >= 2; $i = $i-2) {
                $rtn_ary[] = $channels[substr($id, 0, $i)]['title'];
            } 
        } 
    } else {
        Log_d(__FILE__, __LINE__, 'getChannelTitles from db');
        $where_ary = array();
        for($i = 2; $i <= strlen($id); $i = $i + 2) {
            $where_ary[] = 'id=' . substr($id, 0, $i);
        } 
        $sql_id = implode(' or ', $where_ary);
        $sql = "select id,title from " . TB_CHANNEL . " where ($sql_id) and status=0 and flag<3 order by id desc";
        $rs = dbGetRecordn($sql);
        foreach($rs as $row) {
            $rtn_ary[] = $row['title'];
        } 
    } 

    return implode('_', $rtn_ary);
} 

function getChannelById($id) {
    if (empty($id)) {
        return false;
    } 
    $cacheHelper = new CCacheHelper('db_channel');
    $channels = $cacheHelper -> getCache();
    if ($channels) {
        if (array_key_exists($id, $channels)) {
            Log_d(__FILE__, __LINE__, 'getChannelById from cache');
            return $channels[$id];
        } 
    } else {
        Log_d(__FILE__, __LINE__, 'getChannelById from db');
        return dbGetRecord1("select * from " . TB_CHANNEL . " where id='$id' and status=0 and flag<3 ");
    } 

    return false;
} 

function getSubChannel($limit_num = 10) {
    global $db, $id;
    $rtn = array();
    if ($id == '') return $rtn;
    $channels = getChannelChild($id); 
    // echo $sql;
    foreach($channels as $row) {
        $row['eifr_aritcle'] = array();
        $sql_sub = "select id,title,issuetime from " . TB_ARTICLE . " where channel_id like '" . $row['id'] . "%' and status=0 and flag<>4 order by ordernum desc, issuetime desc limit $limit_num";
        $rs_sub = $db -> Execute($sql_sub); 
        // echo $sql_sub.'<br>';
        while (!$rs_sub -> EOF) {
            $row['eifr_aritcle'][] = $rs_sub -> fields;
            $rs_sub -> MoveNext();
        } 
        $rs_sub -> Close();
        $rtn[] = $row;
    } 

    return $rtn;
} 

function getTabViewTime($days = 1, $limit_num = 10) {
    global $id;
    $pretime = time() - $days * 24 * 60 * 60;
    $sql = "select id,title,issuetime from " . TB_ARTICLE . " where flag<3  and status=0 and issuetime>'$pretime' and channel_id like '$id%' order by viewnum desc, issuetime desc limit $limit_num"; 
    // echo $sql;
    return dbGetRecordn($sql);
} 
// ---start---
if ($tpl_file == '') {
    $tpl_file = 'channel';
} 

$id = kGet('id');
Log_d(__FILE__, __LINE__, "id:($id)");
if (!$is_preview && empty($id)) {
    goErrorPage($lang['channel_inexistent']);
} 
$evalSqlVars = array('id'=>$id);
$channel_array = array();
$search_select = '';
$navigation = '';
$channeltitles = '';
$channel_parentid = $id;

if (!empty($id)) {
    $channel_array = getChannelById($id);
    if (!$channel_array) {
        goErrorPage($lang['channel_inexistent']);
    } 
    if ($channel_array['redirecturl'] != '') {
        header("Location:" . $channel_array['redirecturl']);
        exit();
    } 

    $template_array = getTemplateByID($channel_array['template_id']);
    $search_select = createChannelsSelect($id);
    $navigation = createChannelsNav($id);
    $channeltitles = getChannelTitles($id);
} 

require_once(EIFR_ROOT . 'includes/inc_loadtpl.php');

?>