<?php
/**
 * 
 * @file class_style.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

require_once(EIFR_ROOT . 'libraries/template.php');
class ComStyle {
    function deleteRecords() {
        global $db, $lang, $url;
        global $selectid, $selectValue;
        if ($selectValue) $selectid = $selectValue;
        Common::checkAdminExeAuth($url, 'delete'); //have delete authority ?	
        
        $sql = "DELETE FROM " . TB_STYLE . " WHERE id='" . $selectid . "'";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showMsg($lang['delSuccess'], 'success', DIR_INSTALL . 'admin/' . $url);
        } else {
            Common::showErrorMsg($lang['delFail']);
        } 
    } 

    function addRecords() {
        global $db, $lang, $url;
        global $selectid, $selectValue, $id, $title, $intro;
        Common::checkAdminExeAuth($url, 'add'); //have add authority ?	
        Common::checkEditDataIsExist(TB_STYLE, 'id', $id);
        $title = sTextEncode($title);
        $sql = "insert into " . TB_STYLE . " (id,title,intro) values('$id','$title','$intro')";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if ($rs) {
            Common::showOkMsg($lang['addSuccess'], 'style_edit.php', 'style_edit.php?act=edit&selectid=' . $id, 'style.php');
        } else {
            Common::showErrorMsg($lang['addFail']);
        } 
        $rs -> Close();
    } 

    function editRecords() {
        global $db, $lang, $url;
        global $selectid, $selectValue, $id, $id_old, $title, $intro;
        Common::checkAdminExeAuth($url, 'edit');

        Common::checkEditDataIsExist(TB_STYLE, 'id', $id, $id_old);

        $title = sTextEncode($title);
        $sql = "update " . TB_STYLE . " set id='$id', title='$title', intro='$intro' where id='" . $id_old . "'"; 
        // echo $sql;
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showOkMsg($lang['saveSuccess'], 'style_edit.php', 'style_edit.php?act=edit&selectid=' . $selectid, 'style.php');
        } else {
            Common::showErrorMsg($lang['saveFail']);
        } 
        $rs -> Close();
    } 

    function layoutStyle() {
        global $db, $url;

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => Common::createToolbar($url, 'add', 'style_edit.php') . Common::createToolbar($url, 'edit', 'style_edit.php?act=edit') . Common::createToolbar($url, 'delete', 'style.php?act=delete')
                )); 
        // show list---start---
        $sqlstr = '';

        $sql = "select * from " . TB_STYLE . "  ";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        // echo '<br/>';
        $num = 0;
        while (!$rs -> EOF) {
            $num++;

            $clTemplate -> assign_block_vars('ListStyle', array('num' => $num,
                    'id' => $rs -> fields['id'],
                    'title' => $rs -> fields['title'],
                    'intro' => $rs -> fields['intro']

                    ));

            $rs -> MoveNext();
        } 
        $rs -> Close(); 
        // show list---end---
        $clTemplate -> set_filenames(array('body' => 'style.tpl.html'));
        $clTemplate -> pparse("body");
    } 

    function layoutStyle_edit($act = '') {
        global $db, $url;
        global $act, $selectid, $selectValue;
        if ($act == 'edit') {
            Common::checkAdminExeAuth($url, 'edit');
            if ($selectValue) $selectid = $selectValue;

            $toolbar = Common::createToolbar($url, 'save', 'style_edit.php?act=save_edit') . Common::createToolbar($url, 'delete', 'style.php?act=delete');

            $sql = "select * from " . TB_STYLE . " where id='" . $selectid . "'"; 
            // echo $sql;
            $rs = $db -> Execute($sql);
            if (!$rs -> EOF) {
                $id = $rs -> fields['id'];
                $title = $rs -> fields['title'];
                $intro = $rs -> fields['intro'];
            } 
            $rs -> Close();
        } else {
            Common::checkAdminExeAuth($url, 'add');
            $toolbar = Common::createToolbar($url, 'save', 'style_edit.php?act=save_add') . Common::createToolbar($url, 'delete', 'style.php?act=delete');
            $selectid = '';
            $id = '';
            $title = '';
            $intro = '';
        } 

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'style_id' => SYS_DEFAULT_STYLE,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => $toolbar
                )); 
        // data
        $clTemplate -> assign_vars(array('selectid' => $selectid,
                'title' => $title,
                'id' => $id,
                'id_old' => $id,
                'intro' => $intro
                ));

        $clTemplate -> set_filenames(array('body' => 'style_edit.tpl.html'));
        $clTemplate -> pparse("body");
    } 
} 

?>