<?php
/**
 * 
 * @file class_order.php
 * @copyright (c) 2005 - 2007 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

require_once(EIFR_ROOT . 'admin/mod_order/order.config.php');
require_once(EIFR_ROOT . 'admin/mod_user/user.config.php');
require_once(EIFR_ROOT . 'libraries/template.php');

/**
 * ---ComOrder---
 * #status(0:display,1:hidden)
 */
class ComOrder {
    function recycleRecords($act_role = '') {
        global $db, $lang, $url, $cfgarr_order_isdelete;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?	
        global $selectid, $selectValue, $field_name, $field_value;

        $pfile_list = 'order.php';
        if ($act_role != '') {
            $pfile_list = 'order_' . $act_role . '.php';
        } 

        if ($selectValue != '') $selectid = $selectValue;
        $sql = "UPDATE " . TB_ORDER . "  set is_delete=" . $cfgarr_order_isdelete['trash'] . " WHERE id='$selectid'";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if ($rs) {
            Common::showMsg($lang['modifySuccess'], 'success', $pfile_list);
        } else {
            Common::showErrorMsg($lang['modifyFail']);
        } 
    } 

    function setFieldRecords($act_role = '') {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?	
        global $selectid, $selectValue, $field_name, $field_value;

        $pfile_list = 'order.php';
        if ($act_role != '') {
            $pfile_list = 'order_' . $act_role . '.php';
        } 

        if ($selectValue != '') $selectid = $selectValue;
        $sql = "UPDATE " . TB_ORDER . "  set $field_name ='$field_value'  WHERE id in (" . $selectid . ")";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if ($rs) {
            Common::showMsg($lang['modifySuccess'], 'success', $pfile_list);
        } else {
            Common::showErrorMsg($lang['modifyFail']);
        } 
    } 

    function deleteRecords($act_role = '') {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete');
        Common::checkAdminExeAuth($url, 'manage');

        global $selectid, $selectValue;

        $pfile_list = 'order.php';
        if ($act_role != '') {
            $pfile_list = 'order_' . $act_role . '.php';
        } 

        if ($selectValue != '') $selectid = $selectValue;

        if (!Common::checkAdminAuth($url, 'manage')) {
            $uid = dbGetFieldValue(TB_ORDER, TFR_USER_ID, "id ='" . $selectid . "'");
            if ($uid != getCookie(COOKIE_UID)) {
                Common::showWarningMsg($lang['checkAuth']);
            } 
        } 

        $sql = "DELETE FROM " . TB_ORDER . " WHERE id in (" . $selectid . ")";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showMsg($lang['delSuccess'], 'success', $pfile_list);
        } else {
            Common::showErrorMsg($lang['delFail']);
        } 
    } 

    function editRecords($act_role = '') {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit');
        $is_manage = Common::checkAdminAuth($url, 'manage');

        global $selectid, $selectValue, $count, $fare, $total, $leave_words, $payment_id, $delivery_id, $consignor_name, $consignor_address, $consignor_zipcode, $consignor_tel, $consignor_mobile, $consignor_email, $consignor_gender, $realname, $gender, $address, $zipcode, $email, $tel, $mobile, $is_invoice, $status, $flag, $flag_old;

        $pfile_list = 'order.php';
        $pfile_edit = 'order_edit.php';
        if ($act_role != '') {
            $pfile_list = 'order_' . $act_role . '.php';
            $pfile_edit = 'order_' . $act_role . '_edit.php';
        } 

        if ($selectValue != '') $selectid = $selectValue;

        if ($leave_words != '') $leave_words = HTMLEncode2($leave_words);

        if ($is_manage) {
            $sql = "update " . TB_ORDER . " set  total='$total', leave_words='$leave_words',payment_id='$payment_id',delivery_id='$delivery_id',consignor_name='$consignor_name',consignor_address='$consignor_address',consignor_zipcode='$consignor_zipcode',consignor_tel='$consignor_tel',consignor_mobile='$consignor_mobile',consignor_email='$consignor_email',consignor_gender='$consignor_gender',realname='$realname',gender='$gender',address='$address',zipcode='$zipcode',email='$email',tel='$tel',mobile='$mobile',is_invoice='$is_invoice', status='$status', flag='$flag' where id=" . $selectid . "";
        } elseif ($act_role == 'buyer') {
            if ($flag_old == 1) {
                $sql = "update " . TB_ORDER . " set leave_words='$leave_words',payment_id='$payment_id',delivery_id='$delivery_id',consignor_name='$consignor_name',consignor_address='$consignor_address',consignor_zipcode='$consignor_zipcode',consignor_tel='$consignor_tel',consignor_mobile='$consignor_mobile',consignor_email='$consignor_email',consignor_gender='$consignor_gender',realname='$realname',gender='$gender',address='$address',zipcode='$zipcode',email='$email',tel='$tel',mobile='$mobile',is_invoice='$is_invoice', status='$status'  where id=" . $selectid . "";
            } 
            if ($flag == 4) {
                $sql = "update " . TB_ORDER . " set status='$status', flag='$flag' where id=" . $selectid . "";
            } 
        } elseif ($act_role == 'seller') {
            if ($flag_old == 1) {
                $sql = "update " . TB_ORDER . " set  total='$total'  where id=" . $selectid . "";
            } 
            if ($flag == 3) {
                $sql = "update " . TB_ORDER . " set  flag='$flag' where id=" . $selectid . "";
            } 
        } 
        // echo $sql;
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showOkMsg($lang['saveSuccess'], '', $pfile_edit . '?act=edit&selectid=' . $selectid, $pfile_list);
        } else {
            Common::showErrorMsg($lang['saveFail']);
        } 
        $rs -> Close();
    } 
    
    function get_layout_order($act_role = '') {
        global $db, $lang, $url , $cfgarr_order_isdelete;

        $querys = kRequests('search_keyword,search_field,channel_id,type,is_delete,flag,begintime,endtime');
        $pfile_list = 'order.php';
        $pfile_edit = 'order_edit.php';
        if ($act_role != '') {
            $pfile_list = 'order_' . $act_role . '.php';
            $pfile_edit = 'order_' . $act_role . '_edit.php';
        } 
        $is_manage = Common::checkAdminAuth($url, 'manage');
        $query_ary = array();
        $query_ary[] = 1;
        $is_delete = 0;
        if ($querys['is_delete']) $is_delete = $querys['is_delete'];
        if (!$is_manage) {
            $query_ary[] = "is_delete=" . $cfgarr_order_isdelete['valid'];
            if ($act_role == 'buyer') $query_ary[] = 'uid=' . getCookie(COOKIE_UID);
            elseif ($act_role == 'seller') $query_ary[] = 'seller_uid=' . getCookie(COOKIE_UID);
        } else {
            $query_ary[] = 'is_delete='. $is_delete;
        } 
        
        if ($act_role !='') $query_ary[] = "order_number <> '' ";
        if ($querys['flag'] != '') $query_ary[] = 'flag='. $querys['flag'];
        if ($querys['search_field'] == '') $querys['search_field'] = 'order_number';
        if ($querys['search_keyword'] != '') $query_ary[] = $querys['search_field'] . " like '%".$querys['search_keyword']."%' ";
        if ($querys['begintime'] !='') $query_ary[] = "addtime >= " . getMkTime($querys['begintime']);
        if ($querys['endtime'] !='') $query_ary[] = "addtime <= " . getMkTime($querys['endtime']);

        $query_sql = implode(' and ', $query_ary);
        $query_string = getUrlQuery($querys, true);

        $sql = "select * from " . TB_ORDER . " where " . $query_sql . " order by id desc ";

        $orders = dbGetRecordPages($sql, $query_string);

        $toolbar = Common::createToolbar($url, 'edit', $pfile_edit . '?act=edit');
        if ($is_delete) {
            $toolbar .= Common::createToolbar($url, 'comeback', $pfile_list . '?act=setvalue&field_name=is_delete&field_value=' . $cfgarr_order_isdelete['valid']);
        } else {
            $toolbar .= Common::createToolbar($url, 'delete', $pfile_list . '?act=setvalue&field_name=is_delete&field_value=' . $cfgarr_order_isdelete['trash']);
        }
        if ($is_manage) {
            $toolbar .= Common::createToolbar($url, 'delete_forever', $pfile_list . '?act=delete_forever');
        }

        $rtnLayout = array(
            'eifr_pages' => $orders,
            'eifr_querys'=> $querys,
            'is_manage' => $is_manage,
            'menu_nav' => Common::createAdminMenuNav($url),
            'list_flag' => $this -> createFlagOption($querys['flag']),
            'list_delete' => $this -> createDeleteOption($querys['is_delete']),
            'total_price' => dbGetFieldSum(TB_ORDER, 'total', $query_sql),
            'total_num' => dbGetFieldSum(TB_ORDER, 'count', $query_sql),
            'toolbar' => $toolbar,
            );

        return $rtnLayout;
    } 

    function get_layout_order_edit($act_role = '') {
        global $db, $lang, $url, $cfgarr_order_isdelete;
        Common::checkAdminExeAuth($url, 'edit');
        
        $pfile_list = 'order.php';
        $pfile_edit = 'order_edit.php';
        if ($act_role != '') {
            $pfile_list = 'order_' . $act_role . '.php';
            $pfile_edit = 'order_' . $act_role . '_edit.php';
        } 

        $selectid = kRequest('selectid');
        $selectValue = kRequest('selectValue');
        if ($selectValue) $selectid = $selectValue;

        $is_manage = Common::checkAdminAuth($url, 'manage');

        $toolbar = Common::createToolbar($url, 'save', $pfile_edit . '?act=save_edit');
        $toolbar .= Common::createToolbar($url, 'delete', $pfile_list . '?act=setvalue&field_name=is_delete&field_value=' . $cfgarr_order_isdelete['trash']);
        if ($is_manage) {
            $toolbar .= Common::createToolbar($url, 'delete_forever', $pfile_list . '?act=delete_forever');
        } 

        $manage_sql = '';
        if (!$is_manage) {
            if ($act_role == 'buyer') $manage_sql = ' and uid=' . getCookie(COOKIE_UID);
            elseif ($act_role == 'seller') $manage_sql = ' and seller_uid=' . getCookie(COOKIE_UID);
        } 

        $sql = "select * from " . TB_ORDER . " where id='$selectid'" . $manage_sql;

        $rtnLayout = dbGetRecord1($sql);
        $rtnLayout['menu_nav'] = Common::createAdminMenuNav($url);
        $rtnLayout['toolbar'] = $toolbar;

        return $rtnLayout;
    } 

    function layout_order_edit($act_role = '') {
        global $db, $lang, $url, $cfgarr_order_isdelete;

        $pfile_list = 'order.php';
        $pfile_edit = 'order_edit.php';
        $tfile = 'order_edit.tpl.html';
        if ($act_role != '') {
            $pfile_list = 'order_' . $act_role . '.php';
            $pfile_edit = 'order_' . $act_role . '_edit.php';
            $tfile = 'order_' . $act_role . '_edit.tpl.html';
        } 

        $selectid = kRequest('selectid');
        $selectValue = kRequest('selectValue');
        if ($selectValue) $selectid = $selectValue;

        $act = kGet('act');

        $is_manage = Common::checkAdminAuth($url, 'manage');
        $list_channel = '';

        if ($act == 'edit') { // edit
            Common::checkAdminExeAuth($url, 'edit');

            $toolbar = Common::createToolbar($url, 'save', $pfile_edit . '?act=save_edit');
            $toolbar .= Common::createToolbar($url, 'delete', $pfile_list . '?act=setvalue&field_name=is_delete&field_value=' . $cfgarr_order_isdelete['trash']);
            if ($is_manage) {
                $toolbar .= Common::createToolbar($url, 'delete_forever', $pfile_list . '?act=delete_forever');
            } 

            $manage_sql = '';
            if (!$is_manage) {
                if ($act_role == 'buyer') $manage_sql = ' and uid=' . getCookie(COOKIE_UID);
                elseif ($act_role == 'seller') $manage_sql = ' and seller_uid=' . getCookie(COOKIE_UID);
            } 

            $sql = "select * from " . TB_ORDER . " where id='$selectid'" . $manage_sql;
            $rs = $db -> Execute($sql);
            if (!$rs -> EOF) {
                $article_id = $rs -> fields['article_id'];
                $article_title = dbGetFieldValue(TB_ARTICLE, 'title', "id ='" . $rs -> fields['article_id'] . "'");
                $id = $rs -> fields['id'];
                $order_number = $rs -> fields['order_number'];
                $leave_words = $rs -> fields['leave_words'] != '' ? HTMLEncode($rs -> fields['leave_words']) : '';
                $uid = $rs -> fields[TFR_USER_ID];
                $username = dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $uid . "'");
                $buyer = $username;
                $seller_uid = $rs -> fields['seller_uid'];
                $seller = dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $seller_uid . "'");
                $realname = $rs -> fields['realname'];
                $gender = $rs -> fields['gender'];
                $list_gender = $this -> createGenderShow($gender);
                $address = $rs -> fields['address'];
                $email = $rs -> fields['email'];
                $tel = $rs -> fields['tel'];
                $mobile = $rs -> fields['mobile'];
                $zipcode = $rs -> fields['zipcode'];

                $consignor_name = $rs -> fields['consignor_name'];
                $consignor_gender = $rs -> fields['consignor_gender'];
                $list_consignor_gender = $this -> createGenderShow($consignor_gender);
                $consignor_address = $rs -> fields['consignor_address'];
                $consignor_zipcode = $rs -> fields['consignor_zipcode'];
                $consignor_tel = $rs -> fields['consignor_tel'];
                $consignor_mobile = $rs -> fields['consignor_mobile'];
                $consignor_email = $rs -> fields['consignor_email'];

                $count = $rs -> fields['count'];
                $price = $rs -> fields['price'];
                $fare = $rs -> fields['fare'];
                $total = $rs -> fields['total'];
                $total_count = $price * $count + $fare;
                $is_invoice = $rs -> fields['is_invoice'];
                $show_invoice = $is_invoice ? $lang['yes'] : $lang['no'];

                $payment_id = $rs -> fields['payment_id'];
                $list_payment = $this -> createPaymentShow($payment_id);

                $delivery_id = $rs -> fields['delivery_id'];
                $list_deliver = $this -> createDeliverShow($delivery_id);
                $delivery_time = $rs -> fields['delivery_time'];
                $status = Common::createStatusTxt($rs -> fields['status']);
                $flag = $this -> createFlagShow($rs -> fields['flag']);
                $flag_old = $rs -> fields['flag'];
                $addtime = getDateTimeMk($rs -> fields['addtime']);
                $ip = $rs -> fields['ip'];

                if ($is_manage) {
                    $total = Common::creatInputSingleText('total', $total);

                    $leave_words = Common::creatInputMultiText('leave_words', $leave_words);
                    $realname = Common::creatInputSingleText('realname', $realname);
                    $address = Common::creatInputSingleText('address', $address);
                    $email = Common::creatInputSingleText('email', $email);
                    $tel = Common::creatInputSingleText('tel', $tel);
                    $mobile = Common::creatInputSingleText('mobile', $mobile);
                    $zipcode = Common::creatInputSingleText('zipcode', $zipcode);

                    $consignor_name = Common::creatInputSingleText('consignor_name', $consignor_name);
                    $consignor_address = Common::creatInputSingleText('consignor_address', $consignor_address);
                    $consignor_zipcode = Common::creatInputSingleText('consignor_zipcode', $consignor_zipcode);
                    $consignor_tel = Common::creatInputSingleText('consignor_tel', $consignor_tel);
                    $consignor_mobile = Common::creatInputSingleText('consignor_mobile', $consignor_mobile);
                    $consignor_email = Common::creatInputSingleText('consignor_email', $consignor_email);

                    $show_invoice = Common::creatInputCheckbox('is_invoice', 1, $is_invoice);
                    $list_payment = $this -> createPaymentRadio('payment_id', $payment_id);
                    $list_deliver = $this -> createDeliverRadio('delivery_id', $delivery_id);

                    $status = Common::creatStatusRadio($rs -> fields['status']);
                    $flag = $this -> createFlagRadio('flag', $rs -> fields['flag']);
                } elseif ($act_role == 'buyer') {
                    $status = Common::creatStatusRadio($rs -> fields['status']);
                    if ($rs -> fields['flag'] == 1) {
                        $leave_words = Common::creatInputMultiText('leave_words', $leave_words);
                        $realname = Common::creatInputSingleText('realname', $realname);
                        $address = Common::creatInputSingleText('address', $address);
                        $email = Common::creatInputSingleText('email', $email);
                        $tel = Common::creatInputSingleText('tel', $tel);
                        $mobile = Common::creatInputSingleText('mobile', $mobile);
                        $zipcode = Common::creatInputSingleText('zipcode', $zipcode);

                        $consignor_name = Common::creatInputSingleText('consignor_name', $consignor_name);
                        $consignor_address = Common::creatInputSingleText('consignor_address', $consignor_address);
                        $consignor_zipcode = Common::creatInputSingleText('consignor_zipcode', $consignor_zipcode);
                        $consignor_tel = Common::creatInputSingleText('consignor_tel', $consignor_tel);
                        $consignor_mobile = Common::creatInputSingleText('consignor_mobile', $consignor_mobile);
                        $consignor_email = Common::creatInputSingleText('consignor_email', $consignor_email);

                        $list_gender = $this -> createGenderRadio('gender', $gender);
                        $list_consignor_gender = $this -> createGenderRadio('consignor_gender', $consignor_gender);
                        $show_invoice = Common::creatInputCheckbox('is_invoice', 1, $is_invoice);
                        $list_payment = $this -> createPaymentRadio('payment_id', $payment_id);
                        $list_deliver = $this -> createDeliverRadio('delivery_id', $delivery_id);
                    } 
                    if ($rs -> fields['flag'] == 3) {
                        $flag .= '&nbsp;->&nbsp;';
                        $flag .= Common::creatInputCheckbox('flag', 4);
                        $flag .= $this -> createFlagShow(4);
                    } 
                } elseif ($act_role == 'seller') {
                    if ($rs -> fields['flag'] == 1) {
                        $total = Common::creatInputSingleText('total', $total);
                    } elseif ($rs -> fields['flag'] == 2) {
                        $flag .= '&nbsp;->&nbsp;';
                        $flag .= Common::creatInputCheckbox('flag', 3);
                        $flag .= $this -> createFlagShow(3);
                    } 
                } 

                $rs -> Close();
            } else {
                $rs -> Close();
                Common::showWarningMsg($lang['order_isnull']);
            } 
        } 

        $clTemplate = new Template(getAdminTemplateDir($url)); 
        // common
        $clTemplate -> assign_vars(array('sys_charset' => SYS_CHARSET,
                'adminStylePath' => SYS_ADMIN_STYLE_PATH,
                'css_path' => DIR_INSTALL . 'admin/style/',
                'menu_nav' => Common::createAdminMenuNav($url),
                'toolbar' => $toolbar
                )); 
        // data
        $clTemplate -> assign_vars(array('selectid' => $selectid,
                'id' => $id,
                'article_title' => $article_title,
                'article_id' => $article_id,
                'order_number' => $order_number,
                'delivery_time' => $delivery_time,
                'leave_words' => $leave_words,
                'flag' => $flag,
                'uid' => $uid,
                'username' => $username,
                'buyer' => $buyer,
                'seller' => $seller,
                'realname' => $realname,
                'gender' => $gender,
                'list_gender' => $list_gender,
                'address' => $address,
                'email' => $email,
                'tel' => $tel,
                'mobile' => $mobile,
                'zipcode' => $zipcode,

                'consignor_name' => $consignor_name,
                'consignor_gender' => $consignor_gender,
                'list_consignor_gender' => $list_consignor_gender,
                'consignor_address' => $consignor_address,
                'consignor_zipcode' => $consignor_zipcode,
                'consignor_tel' => $consignor_tel,
                'consignor_mobile' => $consignor_mobile,
                'consignor_email' => $consignor_email,

                'count' => $count,
                'price' => $price,
                'fare' => $fare,
                'total' => $total,
                'total_count' => $total_count,
                'is_invoice' => $is_invoice,
                'show_invoice' => $show_invoice,

                'list_payment' => $list_payment,
                'list_deliver' => $list_deliver,

                'status' => $status,
                'flag' => $flag,
                'flag_old' => $flag_old,

                'ip' => $ip,
                'addtime' => $addtime
                ));

        $clTemplate -> set_filenames(array('body' => $tfile));
        $clTemplate -> pparse("body");
    } 

    function getArticlesByOrderNumber($orderNumber='') {
        $sql = "SELECT o.quantity, o.price, a.id, a.title, a.fileurl from ".TB_ORDER_ARTICLE." AS o LEFT JOIN ".TB_ARTICLE." AS a ON o.article_id=a.id where o.order_id='$orderNumber'";

        return dbGetRecordn($sql);
    }
    
    function getUsernameByUid($uid) {
        return dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $uid . "'");
    }
    
    function createGenderRadio($input_name = '', $flag = '') {
        global $cfgarr_user_gender;
        return Common::createRadiosByArray($input_name, $cfgarr_user_gender, $flag);
    } 

    function createGenderShow($flag = '') {
        global $cfgarr_user_gender;
        return Common::createTxtShowByArray($cfgarr_user_gender, $flag);
    } 

    function createFlagShow($flag = '') {
        global $cfgarr_order_flag;
        return Common::createTxtShowByArray($cfgarr_order_flag, $flag);
    } 

    function createFlagOption($flag = '') {
        global $cfgarr_order_flag;
        return Common::createOptionsByArray($cfgarr_order_flag, $flag);
    } 

    function createDeleteOption($flag = '') {
        global $cfgarr_order_isdelete;
        return Common::createOptionsByArray($cfgarr_order_isdelete, $flag);
    } 

    function createFlagRadio($input_name = '', $flag = '') {
        global $cfgarr_order_flag;
        return Common::createRadiosByArray($input_name, $cfgarr_order_flag, $flag);
    } 

    function createPaymentShow($flag = '') {
        global $cfgarr_order_payment;
        return Common::createTxtShowByArray($cfgarr_order_payment, $flag);
    } 

    function createPaymentRadio($input_name = '', $flag = '') {
        global $cfgarr_order_payment;
        return Common::createRadiosByArray($input_name, $cfgarr_order_payment, $flag);
    } 

    function createDeliverRadio($input_name = '', $flag = '') {
        global $cfgarr_order_deliver;
        return Common::createRadiosByArray($input_name, $cfgarr_order_deliver, $flag);
    } 

    function createDeliverShow($flag = '') {
        global $cfgarr_order_deliver;
        return Common::createTxtShowByArray($cfgarr_order_deliver, $flag);
    } 
} 

?>
