<?php
/**
 * 
 * @file pic_edit.php
 * @copyright (c) 2011 - 2011 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

require_once('../../includes/inc_admin.php');
require_once(EIFR_ROOT . 'admin/mod_article/class_article.php');

$url = 'mod_article/pic_edit.php';
Common::checkAdminFileAuth($url); //check file authority
$clComArticle = new ComArticle($cfgarr_article_type['pic']);

$act = kGet('act');
switch ($act) {
    case 'save_add':
        $extra_session = $clComArticle -> _CLASSNAME . '_' . $cfgarr_article_type['pic'];
        Common::checkSubmit($title, $extra_session);
        $clComArticle -> addRecords();
        break;

    case 'save_add_content':
        $clComArticle -> addFileRecords();
        break;

    case 'save_edit_base':
        $clComArticle -> editArticleRecords();
        break;

    case 'save_edit_content':
        $clComArticle -> editFileRecords();
        break;

    case 'add_content':
    case 'edit_content':
        $layout = $clComArticle -> get_layout_article_file_edit($cfgarr_mediatype['pic']);
        require_once(getAdminTemplatePath('pic_edit_content', $url));
        break;

    case 'comeback_content':
        $clComArticle -> comebackFileRecords();
        break;

    case 'delete':
        $clComArticle -> recycleArticleRecords();
        break;

    case 'delete_content':
        $clComArticle -> recycleFileRecords();
        break;

    case 'delete_forever':
        $clComArticle -> deleteArticleRecords();
        break;

    case 'delete_forever_content':
        $clComArticle -> deleteFileRecords();
        break;

    case 'add':
    case 'edit_base':
    default :
        $layout = $clComArticle -> get_layout_article_edit();
        require_once(getAdminTemplatePath('pic_edit', $url));
        break;
} 

?>
