<?php
/**
 * 
 * @file class_article.php
 * @copyright (c) 2005 - 2011 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */

require_once(EIFR_ROOT . 'admin/mod_article/article.config.php');
require_once(EIFR_ROOT . 'libraries/getresource.php');

/**
 * ---ComArticle---
 * #status(0:display,1:hidden)
 * Article #flag (0:unchecked, 1:open, 2:locked, 3:stop, 4:delete)
 * Article_content #flag (0:unchecked, 1:delete)
 * #article:type (0:none, 1: redirect article id, 2: redirect url 3: poll 4: subject 5: shop)
 * #article:relation_type (1: keyword, 2: article list)
 * #poll:type(1:single, 2:multiple)
 */
class ComArticle {
    var $_CLASSNAME = __CLASS__;
    var $type;
    var $articleId;

    function __construct($type = '') {
        $this -> articleId = 0;
        $this -> setArticleType($type);
    } 

    function setArticleType($type) {
        $this -> type = $type;
    } 

    function setArticleId($id) {
        $this -> articleId = $id;
    } 

    function setArticleFieldRecords() {
        global $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?	
        global $selectid, $selectValue, $field_name, $field_value;

        if ($selectValue != '') $selectid = $selectValue;
        $is_manage = Common::checkAdminAuth($url, 'manage');
        if (!$is_manage && $field_name == 'flag') {
            $id_arr = explode(',', $selectid);

            for($i = 0; $i < count($id_arr); $i++) {
                $uid = dbGetFieldValue(TB_ARTICLE, TFR_USER_ID, "id ='" . $id_arr[$i] . "'");
                Common::checkAdminExeAuthByUid($uid);
            } 
        } 

        $record_arr = array($field_name => $field_value);
        $rc = dbUpdate(TB_ARTICLE, $record_arr, "id in (" . $selectid . ")");
        if ($rc) {
            Common::showMsg($lang['modifySuccess'], 'success', basename($_SERVER['PHP_SELF']) );
        } else {
            Common::showErrorMsg($lang['modifyFail']);
        } 
    } 

    function updateArticleWords($id, $words) {
        $words = addslashes(stripslashes($words));
        $record_arr = array('words' => $words, 'edittime' => time());
        return dbUpdate(TB_ARTICLE, $record_arr, "id ='$id'");
    } 

    function UpdateToLatestArticleWords($id) {
        global $cfgarr_article_type;

        $title = '';
        $intro = '';
        $type = 0;
        $content = '';

        $sql = "select title,intro,type from " . TB_ARTICLE . " where id=$id";
        $article_rs = dbGetRecord1($sql);
        if (!$article_rs) {
            $title = $article_rs['title'];
            $intro = $article_rs['intro'];
            $type = $article_rs['type'];
        } 

        if ($type == $cfgarr_article_type['info']) {
            $content = $this -> getArticleContentString($id);
        } else if ($type == $cfgarr_article_type['poll']) {
            $content = $this -> getArticlePollString($id);
        } else if ($type == $cfgarr_article_type['pic']) {
            $content = $this -> getFileString($id);
        } 

        $words = $title . "\n" . Common::stripTags($intro) . "\n" . Common::stripTags($content);

        return $this -> updateArticleWords($id, $words);
    } 

    function emptyArticleRecordsByChannelId() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete'); //have delete authority ?
        global $selectid, $selectValue;
        if ($selectValue != '') $selectid = $selectValue;

        if (!Common::checkAdminAuth($url, 'manage')) {
            $uid = dbGetFieldValue(TB_CHANNEL, TFR_USER_ID, "id ='" . $selectid . "'");
            Common::checkAdminExeAuthByUid($uid);
        } 

        $sql = "update " . TB_ARTICLE . " set " . TFR_CHANNEL_ID . "='',flag=4 where " . TFR_CHANNEL_ID . " like '" . $selectid . "%'";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showMsg($lang['delSuccess'], 'success', DIR_INSTALL . 'admin/' . $url);
        } else {
            Common::showErrorMsg($lang['delFail']);
        } 
        $rs -> Close();
    } 

    function setArticleOrdernumRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'manage'); //have manage authority ?	
        global $selectid, $selectValue;

        if ($selectValue != '') $selectid = $selectValue;
        $is_manage = Common::checkAdminAuth($url, 'manage');
        if (!$is_manage) {
            Common::showWarningMsg($lang['checkAuth']);
        } 

        $id_arr = explode(',', $selectid);
        for($i = 0; $i < count($id_arr); $i++) {
            $ordernum = kPost('ordernum_' . $id_arr[$i]);
            $sql = "UPDATE " . TB_ARTICLE . "  set ordernum =$ordernum  WHERE id=" . $id_arr[$i] . "";
            $rs = $db -> Execute($sql);
        } 

        Common::showMsg($lang['modifySuccess'], 'success',  basename($_SERVER['PHP_SELF']));
    } 

    function setContentOrdernumRecords($content_id_list = '') {
        global $db, $lang, $url;
  
        $rtn = true;
        if ($content_id_list == '') return $rtn;

        $id_arr = explode(',', $content_id_list);
        $err_count = 0;
        for($i = 0; $i < count($id_arr); $i++) {
            $ordernum = kPost('ordernum_' . $id_arr[$i]);
            if($ordernum != '') {
                $sql = "UPDATE " . TB_ARTICLE_CONTENT . "  set ordernum =$ordernum  WHERE id=" . $id_arr[$i] . "";
                $rs = $db -> Execute($sql);
                if (!$rs) {
                    $err_count++;
                }
            }
        } 

        if ($err_count > 0)
            $rtn = false;

        return $rtn;
    } 

    function comebackArticleContentRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'manage');

        global $selectid, $selectValue;

        if ($selectValue != '') $selectid = $selectValue;

        $ordernum = 0 ;
        $article_id = 0;
        $sql = "select article_id,ordernum from " . TB_ARTICLE_CONTENT . " where id='" . $selectid . "'";
        $rs = $db -> Execute($sql);
        if (!$rs -> EOF) {
            $article_id = $rs -> fields['article_id'];
            $ordernum = $rs -> fields['ordernum'];
            $rs -> Close();
        } else {
            $rs -> Close();
            Common::showWarningMsg($lang['article_content_isnull']);
        } 

        if (!Common::checkAdminAuth($url, 'manage')) {
            $uid = dbGetFieldValue(TB_ARTICLE, TFR_USER_ID, "id ='" . $article_id . "'");
            Common::checkAdminExeAuthByUid($uid);
        } 

        $sql = "select id, ordernum from " . TB_ARTICLE_CONTENT . " where article_id='" . $article_id . "' and ordernum>=" . $ordernum . " ";
        $rs = $db -> Execute($sql);
        while (!$rs -> EOF) {
            $tmp_ordernum = $rs -> fields['ordernum'] + 1;
            $sql1 = "UPDATE " . TB_ARTICLE_CONTENT . " set ordernum='$tmp_ordernum' where id=" . $rs -> fields['id'] . "";
            $rs1 = $db -> Execute($sql1);
            $rs -> MoveNext();
        } 
        $rs -> Close();

        $sql = "UPDATE " . TB_ARTICLE_CONTENT . " set ordernum='$ordernum', flag=0 WHERE id=" . $selectid . "";
        $rs = $db -> Execute($sql);

        if ($rs) {
            $rs -> Close();
            $this -> UpdateToLatestArticleWords($article_id);
            Common::showMsg($lang['modifySuccess'], 'success', '?act=edit_content&selectid=' . $article_id . '');
        } else {
            $rs -> Close();
            Common::showErrorMsg($lang['modifyFail']);
        } 
    } 

    function comebackFileRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'manage');

        global $selectid, $selectValue;

        if ($selectValue != '') $selectid = $selectValue;

        $article_id = dbGetFieldValue(TB_FILE, 'article_id', "id ='" . $selectid . "'");
        if ($article_id == '') {
            Common::showWarningMsg($lang['article_content_isnull']);
        } 

        if (!Common::checkAdminAuth($url, 'manage')) {
            $uid = dbGetFieldValue(TB_ARTICLE, TFR_USER_ID, "id ='" . $article_id . "'");
            Common::checkAdminExeAuthByUid($uid);
        } 

        $sql = "UPDATE " . TB_FILE . " set flag=0 WHERE id=" . $selectid . "";
        $rs = $db -> Execute($sql);
        if ($rs) {
            $rs -> Close();
            $this -> UpdateToLatestArticleWords($article_id);
            Common::showMsg($lang['modifySuccess'], 'success', '?act=edit_content&selectid=' . $article_id . '');
        } else {
            $rs -> Close();
            Common::showErrorMsg($lang['modifyFail']);
        } 
    } 

    function deleteArticleRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete');
        Common::checkAdminExeAuth($url, 'manage');

        global $selectid, $selectValue;

        if ($selectValue != '') $selectid = $selectValue;
        $is_manage = Common::checkAdminAuth($url, 'manage');
        if (!$is_manage) {
            Common::showWarningMsg($lang['checkAuth']);
        } 

        $sql = "DELETE FROM " . TB_ARTICLE_CONTENT . " WHERE article_id in (" . $selectid . ")";
        $rs = $db -> Execute($sql);

        $sql = "DELETE FROM " . TB_ARTICLE . " WHERE id in (" . $selectid . ")";
        $rs = $db -> Execute($sql);
        if ($rs) {
            Common::showMsg($lang['delSuccess'], 'success',  basename($_SERVER['PHP_SELF']));
        } else {
            Common::showErrorMsg($lang['delFail']);
        } 
    } 

    function deleteArticleContentRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete');
        Common::checkAdminExeAuth($url, 'manage');

        global $selectid, $selectValue;

        if ($selectValue != '') $selectid = $selectValue;

        $ordernum = 0 ;
        $article_id = 0;
        $sql = "select article_id,ordernum from " . TB_ARTICLE_CONTENT . " where id='" . $selectid . "'";
        $rs = $db -> Execute($sql);
        if (!$rs -> EOF) {
            $article_id = $rs -> fields['article_id'];
            $ordernum = $rs -> fields['ordernum'];
            $rs -> Close();
        } else {
            $rs -> Close();
            Common::showWarningMsg($lang['article_content_isnull']);
        } 

        if (!Common::checkAdminAuth($url, 'manage')) {
            $uid = dbGetFieldValue(TB_ARTICLE, TFR_USER_ID, "id ='" . $article_id . "'");
            Common::checkAdminExeAuthByUid($uid);
        } 

        $sql = "select ordernum from " . TB_ARTICLE_CONTENT . " where article_id='" . $article_id . "' and ordernum>" . $ordernum . " ";
        $rs = $db -> Execute($sql);
        while (!$rs -> EOF) {
            $ordernum = $rs -> fields['ordernum']-1;
            $sql1 = "UPDATE " . TB_ARTICLE_CONTENT . " set ordernum='$ordernum' where id=" . $rs -> fields['id'] . "";
            $rs1 = $db -> Execute($sql1);
            $rs -> MoveNext();
        } 
        $rs -> Close();

        $sql = "DELETE FROM " . TB_ARTICLE_CONTENT . " WHERE id=" . $selectid . "";
        $rs = $db -> Execute($sql);
        if ($rs) {
            $this -> UpdateToLatestArticleWords($article_id);
            Common::showMsg($lang['delSuccess'], 'success', '?act=edit_content&selectid=' . $article_id . '');
        } else {
            Common::showErrorMsg($lang['delFail']);
        } 
    } 

    function deleteFileRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete');
        Common::checkAdminExeAuth($url, 'manage');

        global $selectid, $selectValue;

        if ($selectValue != '') $selectid = $selectValue;

        $article_id = dbGetFieldValue(TB_FILE, 'article_id', "id ='" . $selectid . "'");
        if ($article_id == '') {
            Common::showWarningMsg($lang['article_content_isnull']);
        } 

        if (!Common::checkAdminAuth($url, 'manage')) {
            $uid = dbGetFieldValue(TB_ARTICLE, TFR_USER_ID, "id ='" . $article_id . "'");
            Common::checkAdminExeAuthByUid($uid);
        } 

        $sql = "DELETE FROM " . TB_FILE . " WHERE id=" . $selectid . "";
        $rs = $db -> Execute($sql);
        if ($rs) {
            $this -> UpdateToLatestArticleWords($article_id);
            Common::showMsg($lang['delSuccess'], 'success', '?act=edit_content&selectid=' . $article_id . '');
        } else {
            Common::showErrorMsg($lang['delFail']);
        } 
    } 

    function recycleArticleContentRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete');

        global $selectid, $selectValue;

        if ($selectValue != '') $selectid = $selectValue;

        $ordernum = 0 ;
        $article_id = 0;
        $sql = "select article_id,ordernum from " . TB_ARTICLE_CONTENT . " where id='" . $selectid . "'";
        $rs = $db -> Execute($sql);
        if (!$rs -> EOF) {
            $article_id = $rs -> fields['article_id'];
            $ordernum = $rs -> fields['ordernum'];
            $rs -> Close();
        } else {
            $rs -> Close();
            Common::showWarningMsg($lang['article_content_isnull']);
        } 

        if (!Common::checkAdminAuth($url, 'manage')) {
            $uid = dbGetFieldValue(TB_ARTICLE, TFR_USER_ID, "id ='" . $article_id . "'");
            Common::checkAdminExeAuthByUid($uid);
        } 

        $sql = "select ordernum from " . TB_ARTICLE_CONTENT . " where article_id='" . $article_id . "' and ordernum>" . $ordernum . " ";
        $rs = $db -> Execute($sql);
        while (!$rs -> EOF) {
            $tmp_ordernum = $rs -> fields['ordernum']-1;
            $sql1 = "UPDATE " . TB_ARTICLE_CONTENT . " set ordernum='$tmp_ordernum' where id=" . $rs -> fields['id'] . "";
            $rs1 = $db -> Execute($sql1);
            $rs -> MoveNext();
        } 
        $rs -> Close();

        $sql = "UPDATE " . TB_ARTICLE_CONTENT . " set flag=1 WHERE id=" . $selectid . "";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if ($rs) {
            $this -> UpdateToLatestArticleWords($article_id);
            $rs -> Close();
            Common::showMsg($lang['delSuccess'], 'success', '?act=edit_content&selectid=' . $article_id . '');
        } else {
            $rs -> Close();
            Common::showErrorMsg($lang['delFail']);
        } 
    } 

    function recycleFileRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'delete');

        global $selectid, $selectValue;

        if ($selectValue != '') $selectid = $selectValue;

        $article_id = dbGetFieldValue(TB_FILE, 'article_id', "id ='" . $selectid . "'");
        if ($article_id == '') {
            Common::showWarningMsg($lang['article_content_isnull']);
        } 

        if (!Common::checkAdminAuth($url, 'manage')) {
            $uid = dbGetFieldValue(TB_ARTICLE, TFR_USER_ID, "id ='" . $article_id . "'");
            Common::checkAdminExeAuthByUid($uid);
        } 

        $sql = "UPDATE " . TB_FILE . " set flag=1 WHERE id=" . $selectid . "";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        if ($rs) {
            $this -> UpdateToLatestArticleWords($article_id);
            $rs -> Close();
            Common::showMsg($lang['delSuccess'], 'success', '?act=edit_content&selectid=' . $article_id . '');
        } else {
            $rs -> Close();
            Common::showErrorMsg($lang['delFail']);
        } 
    } 

    function addRecords_base() {
        global $url, $cfgarr_article_type;

        $recordarr = array();

        $is_manage = Common::checkAdminAuth($url, 'manage');
        if (!$is_manage) {
            $this -> checkChannelForUser(kPost('channel_id'));
            $this -> checkChannelsForUser(kPost('channel_ids'));
        } 

        $recordarr['uid'] = kPost('uid');
        $recordarr['channel_id'] = kPost('channel_id');
        $recordarr['channel_ids'] = addCommaHeadTail(kPost('channel_ids'));

        $recordarr['title_style'] = '';
        if ($is_manage) {
            if (kPost('fontcolor') != '') $recordarr['title_style'] .= 'color:' . kPost('fontcolor') . ';';
            if (kPost('fontsize') != '') $recordarr['title_style'] .= 'font-size:' . kPost('fontsize') . ';';
            if (kPost('em') != '') $recordarr['title_style'] .= 'font-style:' . kPost('em') . ';';
            if (kPost('strong') != '') $recordarr['title_style'] .= 'font-weight:' . kPost('strong') . ';';
            if (kPost('underline') != '') $recordarr['title_style'] .= 'text-decoration:' . kPost('underline') . ';';
        } 

        $recordarr['addtime'] = time();
        if (kPost('issuetime')) {
            $recordarr['issuetime'] = getMkTime(kPost('issuetime'));
        } else {
            $recordarr['issuetime'] = $recordarr['addtime'];
        } 

        if (kPost('endtime')) {
            $recordarr['endtime'] = getMkTime(kPost('endtime'));
        } 

        $recordarr['ip'] = getIP();

        if (kPost('intro') != '') {
            $recordarr['intro'] = filterContent(kPost('intro'));
        } 

        if (kPost('layout_id') != '') $recordarr['layout_id'] = implode(',', kPost('layout_id'));

        $recordarr['relation_type'] = CSafeData::getInt(kPost('relation_type'));
        if ($recordarr['relation_type'] == 1 && kPost('relation_info') != '') {
            $recordarr['relation_info'] = sTextEncode(kPost('relation_info'), 255);
        } else if ($recordarr['relation_type'] == 2 && kPost('article_list') != '') {
            $recordarr['relation_info'] = implode(',', kPost('article_list'));
        } 

        if (kPost('user_channel_channelid_list') != '')
            $recordarr['user_channel_channelid'] = implode(',', kPost('user_channel_channelid_list'));

        $recordarr['attribute'] = '';
        if (kPost('attribute_property') != '') { // checkbox
            $recordarr['attribute'] .= implode(',', kPost('attribute_property'));
        } 
        if (kPost('attribute_source') != '') { // radio
            if ($recordarr['attribute'] != '') {
                $recordarr['attribute'] .= ',' . kPost('attribute_source');
            } else {
                $recordarr['attribute'] .= kPost('attribute_source');
            } 
        } 
        if (kPost('attribute_type') != '') { // radio
            if ($recordarr['attribute'] != '') {
                $recordarr['attribute'] .= ',' . kPost('attribute_type');
            } else {
                $recordarr['attribute'] .= $kPost('attribute_type');
            } 
        } 
        $fileurl = kPost('fileurl');
        $recordarr['type'] = kPost('type');
        if (kPost('type') == $cfgarr_article_type['shop']) {
            if (kPost('picurl') != '' || kPost('picurl_mini') != '') {
                $ary_fileurl = array();
                $ary_fileurl[0] = kPost('picurl_mini');
                $ary_fileurl[1] = kPost('picurl');
                $fileurl = sTextEncode(implode('|', $ary_fileurl));
            } 
        } 
        $recordarr['fileurl'] = sTextEncode($fileurl);
        $recordarr['redirectaddress'] = sTextEncode(kPost('redirectaddress'));
        $recordarr['sourcename'] = sTextEncode(kPost('sourcename'));
        $recordarr['sourceurl'] = sTextEncode(kPost('sourceurl'));

        $recordarr['title'] = sTextEncode(kPost('title'), 255);

        $recordarr['price'] = CSafeData::getFloat(kPost('price'));
        $recordarr['quantity'] = CSafeData::getInt(kPost('quantity'));
        $recordarr['dimension'] = CSafeData::getFloat(kPost('dimension'));
        $recordarr['timelimit'] = CSafeData::getInt(kPost('timelimit'));

        $template_id = kPost('template_id');
        if ($template_id == '' || trim(kPost('template_id_show')) == '') $template_id = 0;
        $recordarr['template_id'] = $template_id;

        return dbInsert(TB_ARTICLE, $recordarr);
    } 

    function addRecords_poll($article_id) {
        global $db;
        global $poll_title, $poll_type;
        $rtn_poll = true;
        $poll_title_count = count($poll_title); 
        // echo $poll_title_count;
        if ($poll_title_count > 0) {
            $j = 1;
            for($i = 0;$i < $poll_title_count;$i++, $j++) {
                $rtn_poll = $this -> insertPoll($poll_title[$i], $j, $article_id, $poll_type);
            } 
        } 
        return $rtn_poll;
    } 

    function insertPoll($title, $ordernum, $article_id, $poll_type = 0) {
        global $db;
        $rtn_poll = true;
        $title = sTextEncode($title);
        $sql = "insert into " . TB_POLL . " (title,ordernum,article_id,type,flag) values('$title','$ordernum','$article_id','$poll_type','')";
        $rs = $db -> Execute($sql);
        if ($rs) {
            $rtn_poll = true;
        } else {
            $rtn_poll = false;
        } 

        return $rtn_poll;
    } 

    function addRecords_content($article_id) {
        global $db;
        global $content, $is_getresource, $flag, $split_type, $split_size;
        $rtn_article_content = false;
        $title = '';

        if ($content != '') { // add TB_ARTICLE_CONTENT
            $channel_id = dbGetFieldValue(TB_ARTICLE, TFR_CHANNEL_ID, "id ='" . $article_id . "'");
            $content = stripslashes($content);
            if ($is_getresource == '1') {
                $clGetResource = new GetResource();
                $content = $clGetResource -> getContent($content, $this -> getUploadImgPath());
            } 

            $content = addslashes($content);
            if ($split_type == 2) { // automatic pagination
                $content_len = strlen($content);
                $split_size = $split_size * 1000;

                if ($content_len < $split_size) {
                    $ordernum = 1;
                    $rtn_article_content = $this -> insertArticleContent($title, $content, $article_id, $ordernum);
                } else {
                    $content_arr = explode('<input type=hidden name=eifr_pagebreak_split />', $this -> splitConten($content, $split_size));
                    $content_arr_count = count($content_arr);
                    $j = 1;

                    for($i = 0;$i < $content_arr_count;$i++, $j++) {
                        $rtn_article_content = $this -> insertArticleContent($title, $content_arr[$i], $article_id, $j);
                    } 
                } 
            } else { // manual pagination
                $rtn_article_content = $this -> insertArticleContent($title, $content, $article_id, 1);
            } 
        } else {
            $rtn_article_content = true;
        } 

        return $rtn_article_content;
    } 

    function addFileRecords() {
        global $lang, $url, $selectid, $selectValue;
        $rtn = true;
        $recordarr = array();

        if ($selectValue != '') $selectid = $selectValue;
        $article_id = $selectid;

        if ($selectid != '') {
            $now = time();
            $recordarr['article_id'] = $article_id;
            $recordarr['title'] = sTextEncode(kPost('title'), 255);
            $recordarr['fileurl'] = sTextEncode(kPost('fileurl'));
            $recordarr['mediatype'] = kPost('mediatype');
            $recordarr['ordernum'] = kPost('ordernum');
            $recordarr['flag'] = kPost('flag');
            $recordarr['addtime'] = $now;
            $recordarr['edittime'] = $now;
            $rtn = dbInsert(TB_FILE, $recordarr);
        } 
        if ($rtn) {
            $words = dbGetFieldValue(TB_ARTICLE, 'words', "id ='" . $article_id . "'");
            if ($words) {
                $words .= "\n" . Common::stripTags(kPost('title'));
            } 
            $this -> updateArticleWords($article_id, $words);
            $file_id = dbGetMaxValue(TB_FILE, 'id', "article_id ='" . $article_id . "'");
            Common::showMsg($lang['saveSuccess'], 'success', DIR_INSTALL . 'admin/' . $url . '?act=edit_content&selectid=' . $article_id . '&file_id=' . $file_id);
        } else {
            Common::showErrorMsg($lang['saveFail']);
        } 

        return $rtn;
    } 

    function addManualPaginaion($regex, $content, $content_arr) {
        $rtn_article_content = true;
        $title_arr = $content_arr;
        $content_arr_count = count($content_arr);
        preg_match_all ($regex, $content, $title_arr, PREG_PATTERN_ORDER);
        $j = 0;
        for($i = 1;$i < $content_arr_count;$i++, $j++) {
            $title = addslashes($title_arr[1][$j]);
            $tmp_content = addslashes($content[$i]);
            $rtn_article_content = $this -> insertArticleContent($title, $tmp_content, $article_id, $i);
        } 
        return $rtn_article_content;
    } 

    function addRecords() {
        global $db, $lang, $url , $uid, $type, $cfgarr_article_type;

        Common::checkAdminExeAuth($url, 'add');
        $is_manage = Common::checkAdminAuth($url, 'manage');

        $addtime = time();
        $ip = getIP();

        if (!$is_manage) {
            Common::checkAdminExeAuthByUid($uid);
        } 

        //$db->StartTrans();
        $rtn_article = $this -> addRecords_base();
        $article_id = dbGetMaxValue(TB_ARTICLE, 'id', "" . TFR_USER_ID . "='" . $uid . "'");

        $rtn_subject = true;
        if ($is_manage) $rtn_subject = $this -> editSubjectRecords($article_id);

        $rtn_poll = true;
        if ($type == $cfgarr_article_type['poll']) $rtn_poll = $this -> addRecords_poll($article_id);
        $rtn_article_content = true;
        if ($type == $cfgarr_article_type['info']) $rtn_article_content = $this -> addRecords_content($article_id);

        $rtn_words = $this -> UpdateToLatestArticleWords($article_id);
        //$db->CompleteTrans();
        if ($rtn_article && $rtn_poll && $rtn_subject && $rtn_article_content && $rtn_words) {
            $pfile = $this -> getEditProgramFile($type);
            $managepfile = $this -> getManageProgramFile($type);
            $extra_link = '';
            switch ($type) {
                case $cfgarr_article_type['subject']:
                    $template_id = dbGetFieldValue(TB_ARTICLE, 'template_id', "id =$article_id");
                    $tourl = "$pfile?act=edit_subject_list&article_id=$article_id&template_id=$template_id";
                    $extra_link = "<img src='" . SYS_ADMIN_STYLE_PATH . "images/subject.gif' align='absmiddle'>&nbsp;<a href='" . $tourl . "'>" . $lang['subject_list'] . "</a>&nbsp;";
                    break;
                case $cfgarr_article_type['info']:
                    $tourl = "$pfile?act=add_content&selectid=$article_id";
                    $extra_link .= "<img src='" . SYS_ADMIN_STYLE_PATH . "images/text.png' align='absmiddle'>&nbsp;<a href='" . $tourl . "'>" . $lang['article_content'] . "</a>&nbsp;";
                    break;
                case $cfgarr_article_type['pic']:
                    $tourl = "$pfile?act=edit_content&selectid=$article_id";
                    $extra_link .= "<img src='" . SYS_ADMIN_STYLE_PATH . "images/pictures.png' align='absmiddle'>&nbsp;<a href='" . $tourl . "'>" . $lang['pictures'] . "</a>&nbsp;";
                    break;
            } 
            Common::showOkMsg($lang['saveSuccess'], $pfile, "$pfile?act=edit_base&selectid=$article_id", $managepfile, $extra_link);
        } else {
            Common::showErrorMsg($lang['addFail']);
        } 
    } 

    function addArticleContentRecords() {
        global $lang, $url;
        Log_d(__FILE__, __LINE__, "addArticleContentRecords BEGIN");
        Common::checkAdminExeAuth($url, 'add');

        $article_id = kRequest('selectid');
        $sql = "select uid, words, type from " . TB_ARTICLE . " where id=" . $article_id; 
        // Log_v(__FILE__, __LINE__, $sql);
        $article_rs = dbGetRecord1($sql);
        if (! $article_rs) {
            Log_d(__FILE__, __LINE__, "no aritcle, add content fail");
            Common::showErrorMsg($lang['addFail']);
        } 

        if (!Common::checkAdminAuth($url, 'manage')) {
            if ($article_rs['uid'] != getCookie(COOKIE_UID)) {
                Log_d(__FILE__, __LINE__, "addArticleContentRecords, permission deny");
                Common::showWarningMsg($lang['checkAuth']);
            } 
        } 

        $ordernum = dbGetMaxValue1(TB_ARTICLE_CONTENT, 'ordernum', "article_id='$article_id'");
        $title = sTextEncode(kPost('title'), 255);
        $content = kPost('content');
        if (kPost('is_getresource') == '1') {
            $content = stripslashes($content);
            $clGetResource = new GetResource();
            $content = $clGetResource -> getContent($content, $this -> getUploadImgPath());
            $content = addslashes($content);
        } 
        $content = filterContent($content);

        $words = $article_rs['words'];
        if ($words) {
            $words .= "\n";
        } 
        $words .= $title . "\n" . Common::stripTags($content);
        $rtn_words = $this -> updateArticleWords($article_id, $words);

        $rtn_content = false;
        $record_arr = array('title' => $title,
            'content' => $content,
            'article_id' => $article_id,
            'ordernum' => $ordernum
            );

        $rtn_content = dbInsert(TB_ARTICLE_CONTENT, $record_arr);

        if ($rtn_words && $rtn_content) {
            $pfile = $this -> getEditProgramFile($article_rs['type']);
            $managepfile = $this -> getManageProgramFile($article_rs['type']);
            $extra_link = '';
            if (IS_MULPAGE) {
                // Common::showMsg($lang['addSuccess'],'success','?act=add_content&selectid='.$article_id.'');
                $tourl = "$pfile?act=add_content&selectid=$article_id";
                $extra_link .= "<img src='" . SYS_ADMIN_STYLE_PATH . "images/text.png' align='absmiddle'>&nbsp;<a href='" . $tourl . "'>" . $lang['add_page'] . "</a>&nbsp;";
            } 
            $content_id = dbGetMaxValue(TB_ARTICLE_CONTENT, 'id', "article_id ='" . $article_id . "'");
            $tourl = "$pfile?act=edit_content&selectid=$article_id&content_id=$content_id";
            $extra_link .= "<img src='" . SYS_ADMIN_STYLE_PATH . "images/text.png' align='absmiddle'>&nbsp;<a href='" . $tourl . "'>" . $lang['edit_content'] . "</a>&nbsp;";
            Log_d(__FILE__, __LINE__, "add content OK, content_id($content_id)");
            Common::showOkMsg($lang['saveSuccess'], $pfile, "$pfile?act=edit_base&selectid=$article_id", $managepfile, $extra_link);
        } else {
            Log_d(__FILE__, __LINE__, "add content fail");
            Common::showErrorMsg($lang['addFail']);
        } 
    } 

    function editArticleRecords() {
        global $db, $lang, $url, $cfgarr_article_type;
        Common::checkAdminExeAuth($url, 'edit');

        global $selectid, $selectValue, $content_id_list, $title, $price, $quantity, $channel_id, $channel_ids, $user_channel_channelid_list, $intro, $template_id, $layout_id, $fileurl, $picurl, $picurl_mini, $type, $relation_type, $relation_info, $article_list, $redirectaddress, $is_comment, $attribute_property, $attribute_source, $attribute_type, $status, $flag, $issuetime, $uid, $sourcename, $sourceurl, $attribute;
        global $fontcolor, $fontsize, $em, $strong, $underline;

        $recordarr = array();
        if ($selectValue != '') $selectid = $selectValue;
        $article_id = $selectid;
        $is_manage = Common::checkAdminAuth($url, 'manage');

        $recordarr['issuetime'] = getMkTime($issuetime);
        $recordarr['endtime'] = getMkTime(kPost('endtime'));

        if (!$is_manage) {
            Common::checkAdminExeAuthByUid($uid);
            $channel_id_old = dbGetFieldValue(TB_ARTICLE, TFR_CHANNEL_ID, "id =$article_id");
            if ($channel_id != $channel_id_old) {
                $this -> checkChannelForUser($channel_id, $uid);
            } 
        } 

        $recordarr['channel_id'] = $channel_id;
        $recordarr['channel_ids'] = addCommaHeadTail($channel_ids);

        $recordarr['attribute'] = '';
        if ($is_manage) {
            $recordarr['uid'] = $uid;
            if ($attribute_property != '') $recordarr['attribute'] .= implode(',', $attribute_property);

            $recordarr['title_style'] = '';
            if ($fontcolor != '') $recordarr['title_style'] .= "color:$fontcolor;";
            if ($fontsize != '') $recordarr['title_style'] .= "font-size:$fontsize;";
            if ($em != '') $recordarr['title_style'] .= "font-style:$em;";
            if ($strong != '') $recordarr['title_style'] .= "font-weight:$strong;";
            if ($underline != '') $recordarr['title_style'] .= "text-decoration:$underline;";
        } else {
            $recordarr['attribute'] .= $this -> getAttributeProperty($article_id);
        } 

        if ($attribute_source != '') {
            if ($recordarr['attribute'] != '') $recordarr['attribute'] .= ',' . $attribute_source;
            else $recordarr['attribute'] .= $attribute_source;
        } 
        if ($attribute_type != '') {
            if ($recordarr['attribute'] != '') $recordarr['attribute'] .= ',' . $attribute_type;
            else $recordarr['attribute'] .= $attribute_type;
        } 

        if (($type == $cfgarr_article_type['redirect']) && $redirectaddress != '') {
            $recordarr['redirectaddress'] = sTextEncode($redirectaddress);
        } 

        $recordarr['relation_type'] = CSafeData::getInt(kPost('relation_type'));
        if ($recordarr['relation_type'] == 1 && $relation_info != '') {
            $recordarr['relation_info'] = sTextEncode($relation_info, 255);
        } else if ($recordarr['relation_type'] == 2 && $article_list != '') {
            $relation_info = implode(',', $article_list);
            $recordarr['relation_info'] = sTextEncode($relation_info, 255);
        } 

        if ($intro != '') {
            $intro = stripslashes($intro);
            $intro = addslashes($intro);
            $intro = filterContent($intro);
            $recordarr['intro'] = $intro;
        } 
        if ($layout_id != '') $recordarr['layout_id'] = implode(',', $layout_id);

        $recordarr['title'] = sTextEncode($title, 255);
        $rtn_article = true;
        if ($type == $cfgarr_article_type['shop']) {
            if ($picurl != '' || $picurl_mini != '') {
                $ary_fileurl = array();
                $ary_fileurl[0] = trim($picurl_mini);
                $ary_fileurl[1] = trim($picurl);
                $fileurl = sTextEncode(implode('|', $ary_fileurl));
            } 
        } 

        $recordarr['fileurl'] = sTextEncode($fileurl);

        $recordarr['sourcename'] = sTextEncode($sourcename);
        $recordarr['sourceurl'] = sTextEncode($sourceurl);

        $recordarr['price'] = CSafeData::getFloat(kPost('price'));
        $recordarr['quantity'] = CSafeData::getInt(kPost('quantity'));
        $recordarr['dimension'] = CSafeData::getFloat(kPost('dimension'));
        $recordarr['timelimit'] = CSafeData::getInt(kPost('timelimit'));

        if ($template_id == '' || trim(kPost('template_id_show')) == '') $template_id = 0;
        $recordarr['template_id'] = $template_id;

        if ($user_channel_channelid_list != '') $recordarr['user_channel_channelid'] = implode(',', $user_channel_channelid_list);

        $rtn_article = dbUpdate(TB_ARTICLE, $recordarr, 'id=' . $article_id);

        $rtn_content = true;
        if ($type == $cfgarr_article_type['info']) $rtn_content = $this -> setContentOrdernumRecords($content_id_list);

        $rtn_poll = true;
        if ($type == $cfgarr_article_type['poll']) $rtn_poll = $this -> editPollRecords($article_id);

        $rtn_subject = true;
        if ($is_manage) $rtn_subject = $this -> editSubjectRecords($article_id);

        $rtn_words = $this -> UpdateToLatestArticleWords($article_id);

        if ($rtn_article && $rtn_content && $rtn_poll && $rtn_subject && $rtn_words) {
            $pfile = $this -> getEditProgramFile($type);
            $managepfile = $this -> getManageProgramFile($type);
            $extra_link = '';
            switch ($type) {
                case $cfgarr_article_type['subject']:
                    $template_id = dbGetFieldValue(TB_ARTICLE, 'template_id', "id =$article_id");
                    $tourl = "$pfile?act=edit_subject_list&article_id=$article_id&template_id=$template_id";
                    $extra_link = "<img src='" . SYS_ADMIN_STYLE_PATH . "images/subject.gif' align='absmiddle'>&nbsp;<a href='" . $tourl . "'>" . $lang['subject_list'] . "</a>&nbsp;";
                    break;
                case $cfgarr_article_type['info']:
                    $tourl = "$pfile?act=add_content&selectid=$article_id";
                    $extra_link .= "<img src='" . SYS_ADMIN_STYLE_PATH . "images/text.png' align='absmiddle'>&nbsp;<a href='" . $tourl . "'>" . $lang['article_content'] . "</a>&nbsp;";
                    break;
                case $cfgarr_article_type['pic']:
                    $tourl = "$pfile?act=edit_content&selectid=$article_id";
                    $extra_link .= "<img src='" . SYS_ADMIN_STYLE_PATH . "images/pictures.png' align='absmiddle'>&nbsp;<a href='" . $tourl . "'>" . $lang['pictures'] . "</a>&nbsp;";
                    break;
            } 

            Common::showOkMsg($lang['saveSuccess'], $pfile, "$pfile?act=edit_base&selectid=$article_id", $managepfile, $extra_link);
        } else {
            Common::showErrorMsg($lang['saveFail']);
        } 
    } 

    function editPollRecords($article_id) {
        global $db, $lang, $url;

        global $poll_title, $poll_id, $poll_type;
        $rtn_poll = true;
        $poll_title_count = count($poll_title);
        $poll_id_count = count($poll_id); 
        // echo $poll_title_count;
        if ($poll_title_count > 0) {
            $j = 1;
            for($i = 0;$i < $poll_title_count;$i++, $j++) {
                $title = sTextEncode($poll_title[$i], 255);
                if ($i > $poll_id_count-1) {
                    $rtn_poll = $this -> insertPoll($title, $j, $article_id, $poll_type);
                } else {
                    $rtn_poll = $this -> updatePoll($poll_id[$i], $title, $poll_type);
                } 
            } 
        } 
        return $rtn_poll;
    } 

    function updatePoll($id, $title, $poll_type = 0) {
        global $db, $lang, $url;
        $rtn_poll = true;
        $title = sTextEncode($title);
        $sql = "update " . TB_POLL . " set  title='$title', type='$poll_type' where id=" . $id . ""; 
        // echo $sql;
        $rs = $db -> Execute($sql);
        if ($rs) {
            $rtn_poll = true;
        } else {
            $rtn_poll = false;
        } 
        $rs -> Close();
        return $rtn_poll;
    } 

    function editSubjectRecords($article_id) {
        global $db;
        global $subject_list;

        $rtn_subject = true;
        $subject_list_count = count($subject_list); 
        // echo $subject_list_count;
        if ($subject_list_count > 0) {
            for($i = 0;$i < $subject_list_count;$i++) {
                $subject_article_id = $subject_list[$i];
                if (!$this -> checkSubject_article($subject_article_id, $article_id)) {
                    $layout_id = 0;
                    $id = $this -> checkSubject_layout($subject_article_id, $layout_id);
                    if ($id > 0) {
                        $article_list = dbGetFieldValue(TB_SUBJECT_RELATION, 'article_list', "article_id=$subject_article_id and layout_id=$layout_id");
                        if ($article_list != '') $article_list .= ',' . $article_id;
                        else $article_list = $article_id;
                        $rtn_subject = $this -> updateSubjectRelation($id, $subject_article_id, $layout_id, $article_list);
                    } else {
                        $rtn_subject = $this -> insertSubjectRelation($subject_article_id, $layout_id, $article_id);
                    } 
                } 
            } 
        } 

        return $rtn_subject;
    } 

    function checkSubject_article($subject_article_id, $article_id) {
        global $db, $lang;
        $rtn_subject = false;
        $sql = "select id from " . TB_SUBJECT_RELATION . " where article_id=$subject_article_id and  find_in_set($article_id,article_list) ";
        $rs = $db -> Execute($sql);
        while (!$rs -> EOF) {
            if ($rs -> fields['id'] > 0) $rtn_subject = true;
            break;
            $rs -> MoveNext();
        } 
        $rs -> Close();
        return $rtn_subject;
    } 

    function checkSubject_layout($subject_article_id, $layout_id = 0) {
        global $db, $lang;
        $id = 0;
        $sql = "select id from " . TB_SUBJECT_RELATION . " where article_id=" . $subject_article_id . " and layout_id=" . $layout_id . "";
        $rs = $db -> Execute($sql);
        if (!$rs -> EOF) {
            $id = $rs -> fields['id'];
        } 
        $rs -> Close();
        return $id;
    } 

    function editArticleContentRecords() {
        global $lang, $url;
        Common::checkAdminExeAuth($url, 'edit');

        $selectid = kRequest('selectid');
        if (kPost('selectValue') != '') $selectid = kPost('selectValue');
        $is_manage = Common::checkAdminAuth($url, 'manage');
        if (!$is_manage) {
            Common::checkAdminExeAuthByUid(kPost('uid'));
        }

        $content_id = kRequest('content_id');
        $article_id = dbGetFieldValue(TB_ARTICLE_CONTENT, 'article_id', "id ='" . $content_id . "'");
        if ($article_id == '') Common::showWarningMsg($lang['article_inexistent']);

        $title = sTextEncode(kPost('title'));
        $content = kPost('content');
        if (kPost('is_getresource') == '1') {
            $content = stripslashes($content);
            $clGetResource = new GetResource();
            $content = $clGetResource -> getContent($content, $this -> getUploadImgPath());
            $content = addslashes($content);
        } 
        $content = filterContent($content);

        $record_arr = array('title' => $title,
            'content' => $content
            );

        $rtn = dbUpdate(TB_ARTICLE_CONTENT, $record_arr, "id=" . $content_id);
        if ($rtn) {
            $this -> UpdateToLatestArticleWords($article_id);
            $type = dbGetFieldValue(TB_ARTICLE, 'type', "id ='" . $article_id . "'");
            $pfile = $this -> getEditProgramFile($type);
            $managepfile = $this -> getManageProgramFile($type);
            $extra_link = '';
            $tourl = "$pfile?act=add_content&selectid=$article_id";
            $extra_link .= "<img src='" . SYS_ADMIN_STYLE_PATH . "images/text.png' align='absmiddle'>&nbsp;<a href='" . $tourl . "'>" . $lang['add_page'] . "</a>&nbsp;";
            $tourl = "$pfile?act=edit_content&selectid=$article_id&content_id=$content_id";
            $extra_link .= "<img src='" . SYS_ADMIN_STYLE_PATH . "images/text.png' align='absmiddle'>&nbsp;<a href='" . $tourl . "'>" . $lang['edit_content'] . "</a>&nbsp;";

            Common::showOkMsg($lang['saveSuccess'], $pfile, "$pfile?act=edit_base&selectid=$article_id", $managepfile, $extra_link);
        } else {
            Common::showErrorMsg($lang['saveFail']);
        } 
    } 

    function editFileRecords() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit');

        global $selectid, $selectValue, $file_id;

        $article_id = dbGetFieldValue(TB_FILE, 'article_id', "id ='" . $file_id . "'");
        if ($article_id == '') Common::showWarningMsg($lang['article_inexistent']);
        $is_manage = Common::checkAdminAuth($url, 'manage');
        if (!$is_manage) {
            Common::checkAdminExeAuthByUid(kPost('uid'));
        } 

        $recordarr = array();
        $recordarr['article_id'] = $article_id;
        $recordarr['title'] = sTextEncode(kPost('title'), 255);
        $recordarr['fileurl'] = sTextEncode(kPost('fileurl'));
        $recordarr['mediatype'] = kPost('mediatype');
        $recordarr['ordernum'] = kPost('ordernum');
        $recordarr['edittime'] = time();

        $rtn = dbUpdate(TB_FILE, $recordarr, 'id=' . $file_id);
        if ($rtn) {
            $this -> UpdateToLatestArticleWords($article_id);
            Common::showMsg($lang['saveSuccess'], 'success', DIR_INSTALL . 'admin/' . $url . '?act=edit_content&selectid=' . $article_id . '&file_id=' . $file_id);
        } else {
            Common::showErrorMsg($lang['saveFail']);
        } 
    } 

    function editSubjectListRelation() {
        global $db, $lang, $url;

        global $article_id, $template_id, $layout_id, $article_list;

        if ($article_list != '') $article_list = implode(',', $article_list);

        $rtn_subject = true;
        $id = $this -> checkSubject_layout($article_id, $layout_id);
        if ($id > 0) {
            $rtn_subject = $this -> updateSubjectRelation($id, $article_id, $layout_id, $article_list);
        } else {
            $rtn_subject = $this -> insertSubjectRelation($article_id, $layout_id, $article_list);
        } 

        if ($rtn_subject) {
            Common::showMsg($lang['saveSuccess'], 'success', DIR_INSTALL . 'admin/' . $url . '?act=edit_subject_list_layout&article_id=' . $article_id . '&template_id=' . $template_id . '&layout_id=' . $layout_id . '');
        } else {
            Common::showErrorMsg($lang['saveFail']);
        } 
    } 

    function insertSubjectRelation($article_id, $layout_id, $article_list = '') {
        global $db, $lang, $url;
        $rtn = true;
        $sql = "insert into " . TB_SUBJECT_RELATION . " (article_id,layout_id,article_list) values('$article_id','$layout_id','$article_list')"; 
        // echo $sql;
        $rs = $db -> Execute($sql);

        if ($rs) {
            $rtn = true;
        } else {
            $rtn = false;
        } 
        $rs -> Close();
        return $rtn;
    } 

    function updateSubjectRelation($id, $article_id, $layout_id, $article_list) {
        global $db, $lang, $url;
        $rtn = true;
        $sql = "update " . TB_SUBJECT_RELATION . " set article_id='$article_id', layout_id='$layout_id', article_list='$article_list' where id=" . $id . ""; 
        // echo $sql;
        $rs = $db -> Execute($sql);
        if ($rs) {
            $rtn = true;
        } else {
            $rtn = false;
        } 
        $rs -> Close();
        return $rtn;
    }
    
    function getArticlesBySearch($query = array(), $is_manage = false) {
        $act = $query['act'];
        $search_keyword = $query['search_keyword'];
        $search_field = $query['search_field'];
        $channel_id = $query['channel_id'];
        $status = $query['status'];
        $layout_id = $query['layout_id'];
        $uid = $query['uid'];
        $quantity = $query['quantity'];
        $flag = $query['flag'];
        $type = $query['type'];
        $order_field = $query['order_field'];
        $order_type = $query['order_type'];

        $query_ary = array();
        $query_ary[] = 1;

        if (!$is_manage) {
            $query_ary[] = "flag<>4";
            $uid_sql = "(" . TFR_USER_ID . "='" . getCookie(COOKIE_UID) . "'";
            if(getCookie(COOKIE_UNDERUIDS) != '') {
                $uidArr = explode(',', getCookie(COOKIE_UNDERUIDS));
                foreach ($uidArr as $val) {
                    $uid_sql .= ' or ' . TFR_USER_ID . "='" . $val . "'";
                }
            }
            $uid_sql .= ")";
            $query_ary[] = $uid_sql;
        } 
        
        if ($type =='') $type = $this -> type;
        if ($type != '') $query_ary[] = "type='" . $type . "' ";

        if ($status != '') $query_ary[] = "status='" . $status . "' ";

        if ($flag != '') $query_ary[] = "flag='" . $flag . "' ";

        if ($layout_id != '') $query_ary[] = "find_in_set(" . $layout_id . ",layout_id) ";

        if ($quantity != '') $query_ary[] =  "quantity<=" . $quantity . "";

        if ($channel_id != '') $query_ary[] = "channel_id like'" . $channel_id . "%' ";

        if (!isset($search_field)) $search_field = '';
        if ($search_keyword != '') {
            if ($search_field == 'id') {
                $query_ary[] = "id = '$search_keyword%' ";
            } else if ($search_field == 'content') {
                $query_ary[] = "words like '%$search_keyword%' ";
            } else if ($search_field != '') {
                $query_ary[] = $search_field . " like '%$search_keyword%' ";
            } else {
                $query_ary[] = "title like '%$search_keyword%' ";
            } 
        }

        $query_sql = implode(' and ', $query_ary);

        if (!isset($order_field)) $order_field = 'id';
        if ($order_field == '') $order_field = 'id';

        if (!isset($order_type)) $order_type = 'desc';
        if ($order_type == '') $order_type = 'desc';
        $order_sql = " order by " . $order_field . "  " . $order_type . " ";
        
        $sql = "select * from " . TB_ARTICLE . " where " . $query_sql . $order_sql;

        $query_string = 'act=' . $act . '&type=' . $type . '&uid=' . $uid . '&status=' . $status . '&flag=' . $flag . '&layout_id=' . $layout_id . '&channel_id=' . $channel_id . '&order_field=' . $order_field . '&order_type=' . $order_type . '&search_field=' . $search_field . '&search_keyword=' . $search_keyword . '';
        
        return dbGetRecordPages($sql, $query_string);
    }

    function get_layout_article() {
        global $lang, $url;
        $querys = kRequests('act,search_keyword,search_field,channel_id,type,status,flag,layout_id,uid,quantity,order_field,order_type');
        $rtnLayout = array();
        if($querys['type'] == '') $querys['type'] = $this -> type;
        $is_manage = Common::checkAdminAuth($url, 'manage');

        $btn_delete_forever = '';
        $toolbar = '';
        $btn_flag = '';
        $editpfile = $this -> getEditProgramFile($querys['type']);
        $managepfile = $this -> getManageProgramFile($querys['type']);
        if ($is_manage) {
            $btn_delete_forever = Common::createToolbar($url, 'delete_forever', $managepfile.'?act=delete_forever');
            $btn_flag .= Common::createSplitLine();
            $btn_flag .= Common::createToolbar($url, 'unchecked', $managepfile.'?act=setvalue&field_name=flag&field_value=0');
            $btn_flag .= Common::createToolbar($url, 'open', $managepfile.'?act=setvalue&field_name=flag&field_value=1');
            $btn_flag .= Common::createToolbar($url, 'locked', $managepfile.'?act=setvalue&field_name=flag&field_value=2');
            $btn_flag .= Common::createToolbar($url, 'stop', $managepfile.'?act=setvalue&field_name=flag&field_value=3');
            $toolbar .= Common::createToolbar($url, 'apply', $managepfile.'?act=set_ordernum');
        } 
  
        $toolbar .= Common::createToolbar($url, 'add', $editpfile);
        $toolbar .= Common::createToolbar($url, 'edit', $editpfile.'?act=edit_base');
        $toolbar .= Common::createToolbar($url, 'delete', $managepfile.'?act=setvalue&field_name=flag&field_value=4');
        $toolbar .= $btn_delete_forever; 
        // $toolbar .= Common::createImgButton('preview','article_view.php', '_blank');
        $toolbar .= $btn_flag;
        $toolbar .= Common::createSplitLine();
        $toolbar .= Common::createToolbar($url, 'display', $managepfile.'?act=setvalue&field_name=status&field_value=0');
        $toolbar .= Common::createToolbar($url, 'hidden', $managepfile.'?act=setvalue&field_name=status&field_value=1');

        if ($querys['layout_id'] != '') {
            $layout_title = dbGetFieldValue(TB_TEMPLATE_LAYOUT, 'title', "id='" . $querys['layout_id'] . "'");
        } else {
            $layout_title = $lang['layout_select'];
        }
        
        if ($querys['uid'] != '') {
            $username = dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $querys['uid'] . "'");
        } else {
            $username = $lang['user_select']; 
        }
        
        $rtnLayout = array(
            'eifr_pages' => $this -> getArticlesBySearch($querys, $is_manage),
            'is_manage' => $is_manage,
            'menu_nav' => Common::createAdminMenuNav($url),
            'search_field' => $querys['search_field'],
            'order_field' => $querys['order_field'],
            'order_type' => $querys['order_type'],
            'list_type' => $this -> cTagTypeSelect($querys['type']),
            'list_flag' => $this -> cTagFlagSelect($querys['flag']),
            'list_status' => $this -> cTagStatusSelect($querys['status']),
            'list_channel' => $this -> cTagChannelSelect($querys['channel_id']),
            'layout_id' => $querys['layout_id'],
            'layout_title' => $layout_title,
            'quantity' => $querys['quantity'],
            'toolbar' => $toolbar,
            'uid' => $querys['uid'],
            'username' => $username,
            );

        return $rtnLayout;
    } 

    function get_layout_article_select() {
        global $lang, $url;
        $querys = kRequests('act,search_keyword,search_field,channel_id,type,status,flag,layout_id,uid,quantity,order_field,order_type');

        $rtnLayout = array();
        $is_manage = Common::checkAdminAuth($url, 'manage');
        
        if ($querys['layout_id'] != '') {
            $layout_title = dbGetFieldValue(TB_TEMPLATE_LAYOUT, 'title', "id='" . $querys['layout_id'] . "'");
        } else {
            $layout_title = $lang['layout_select'];
        }
        
        if ($querys['layout_id'] != '') {
            $username = dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $querys['uid'] . "'");
        } else {
            $username = $lang['user_select']; 
        }
        
        $rtnLayout = array(
            'eifr_pages' => $this -> getArticlesBySearch($querys, $is_manage),
            'is_manage' => $is_manage,
            'search_field' => $querys['search_field'],
            'order_field' => $querys['order_field'],
            'order_type' => $querys['order_type'],
            'list_type' => $this -> cTagTypeSelect($querys['type']),
            'list_flag' => $this -> cTagFlagSelect($querys['flag']),
            'list_status' => $this -> cTagStatusSelect($querys['status']),
            'list_channel' => $this -> cTagChannelSelect($querys['channel_id']),
            'layout_id' => $querys['layout_id'],
            'layout_title' => $layout_title,
            'quantity' => $querys['quantity'],
            'uid' => $querys['uid'],
            'username' => $username,
            );

        return $rtnLayout;
    } 

    function get_layout_article_type_list() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'add');
        $rtnLayout = array();
        $rtnLayout['eifrtf_typelist'] = array();
        $is_manage = Common::checkAdminAuth($url, 'manage');
        $rootid = '02';
        $noid_arr = array('0201'); //article list
        require_once(EIFR_ROOT . 'admin/mod_adminmenu/class_adminmenu.php');
        $clComAdminmenu = new ComAdminmenu();
        $artile_menus = $clComAdminmenu -> getVisibleAdminmenuChildByPid($rootid);
        foreach($artile_menus as $row) {
            if (in_array($row['id'], $noid_arr)) {
                continue;
            } 
            $rtnLayout['eifrtf_typelist'][] = $row;
        } 
        
        $rtnLayout['eifrtf_menu_nav'] = Common::createAdminMenuNav($url);

        return $rtnLayout;
    } 

    function get_layout_article_edit() {
        global $lang, $url;
        $act = kGet('act');
        if ($act == 'edit_base') {
            Common::checkAdminExeAuth($url, 'edit');
        } else {
            Common::checkAdminExeAuth($url, 'add');
        }
        
        $rtnLayout = array();
        
        $type = $this -> type;

        $selectValue = kRequest('selectValue');
        $selectid = kRequest('selectid');
        if ($selectValue) $selectid = $selectValue;

        $is_manage = Common::checkAdminAuth($url, 'manage');
        $this -> setSelectChannelsByUrl($url);

        $uid = getCookie(COOKIE_UID);

        if ($act == 'edit_base') { // edit
            $managepfile = $this -> getManageProgramFile($this -> type);
            $toolbar = Common::createToolbar($url, 'save', '?act=save_edit_base');
            $toolbar .= Common::createToolbar($url, 'delete', $managepfile.'?act=setvalue&field_name=flag&field_value=4');
            if ($is_manage) {
                $toolbar .= Common::createToolbar($url, 'delete_forever', $managepfile.'?act=delete_forever');
            } 
            $toolbar .= Common::createImgButton('preview','article_view.php?selectid='.$selectid, '_blank');

            $is_edit = '';

            $sql = "select * from " . TB_ARTICLE . " where id='" . $selectid . "'";
            $row = dbGetRecord1($sql);
            if ($row) {
                $uid = $row['uid'];
                if (!$is_manage) {
                    Common::checkAdminExeAuthByUid($uid);
                }
                
                $type = $row['type'];
                
                $rtnLayout = $row;

                setCookie(COOKIE_CHANNELID, $row['channel_id']);
                require_once(EIFR_ROOT . 'admin/mod_channel/class_channel.php');
                $channel = ComChannel::getChannelById($row['channel_id']);
                $rtnLayout['eifrtf_channel_title'] = $channel['title'];
                
                $rtnLayout['channel_ids'] = removeCommaHeadTail($row['channel_ids']);

                require_once(EIFR_ROOT . 'admin/mod_template/class_template.php');
                $template = ComTemplate::getTemplateById($row['template_id']);
                $rtnLayout['eifrtf_template_title'] = '';
                if ($template) {
                    $rtnLayout['eifrtf_template_title'] = $template['title'];
                }
                
                $rtnLayout['eifrtf_layout_select'] = $this -> cTagLayoutMSelect($row['layout_id']);

                if ($row['sourcename'] == '' && $row['sourceurl']) {
                    $url_array = parse_url($row['sourceurl']);
                    if (isset($url_array['host'])) {
                        $rtnLayout['sourcename'] = $url_array['host'];
                    } 
                }
                
                $rtnLayout['eifrtf_is_comment'] = $this -> creatCommentRadio($row['is_comment']);
                $rtnLayout['eifrtf_status'] = Common::creatStatusRadio($row['status']);
                $rtnLayout['eifrtf_flag'] = Common::creatStatusRadio($row['flag']);
                $rtnLayout['eifrtf_attribute'] = $this -> creatAttributeCheckbox($row['attribute'], $is_manage);

            } else {
                Common::showWarningMsg($lang['article_inexistent']);
            } 

        } else { //add
            $rtnLayout = getTableFill('article');
            
            $pfile = $this -> getEditProgramFile($type);
            $toolbar = Common::createToolbar($url, 'save', "$pfile?act=save_add");

            $tpl_arr = $this -> getDefaultTemplateByUrl($url);
            $rtnLayout['eifrtf_type_show'] = $lang['article_type_arr'][$type];
            $rtnLayout['template_id'] = $tpl_arr['template_id'];
            $rtnLayout['eifrtf_template_title'] = $tpl_arr['template_title'];
            $rtnLayout['eifrtf_is_comment'] = $this -> creatCommentRadio(0);
            $rtnLayout['eifrtf_status'] = Common::creatStatusRadio(0);
            $rtnLayout['addtime'] = time();
            $rtnLayout['ip'] = getIP();
            $rtnLayout['eifrtf_attribute'] = $this -> creatAttributeCheckbox('', $is_manage);
            $rtnLayout['eifrtf_channel_title'] = '';
            $rtnLayout['eifrtf_layout_select'] = $this -> cTagLayoutMSelect();
        }
        
        $rtnLayout['type'] = $type;
        $rtnLayout['uid'] = $uid;
        $rtnLayout['eifrtf_username'] = dbGetFieldValue(TB_USER, TF_USER_NAME, "" . TF_USER_ID . " ='" . $uid . "'");
        $rtnLayout['eifrtf_act'] = $act;
        $rtnLayout['eifrtf_selectid'] = $selectid;
        $rtnLayout['eifrtf_is_manage'] = $is_manage;
        $rtnLayout['eifrtf_menu_nav'] = Common::createAdminMenuNav($url);
        $rtnLayout['eifrtf_toolbar'] = $toolbar;

        return $rtnLayout;
    } 

    
    function get_layout_article_file_edit($mediatype = 0) {
        global $db, $lang, $url, $cfgarr_mediatype;
        $rtn_layout = array();
        $rtn_layout['list_file'] = array();
        $rtn_layout['edit_file'] = array();

        Common::checkAdminExeAuth($url, 'edit');

        global $selectid, $selectValue, $uid, $act, $file_id;

        if ($selectValue != '') $selectid = $selectValue;
        $is_manage = Common::checkAdminAuth($url, 'manage');

        if ($act == 'edit_content' && dbGetRecordCount(TB_FILE, "article_id='" . $selectid . "'") == 0) {
            Common::showMsg('', '', '?act=add_content&selectid=' . $selectid);
        } 

        $sql = "select type, " . TFR_CHANNEL_ID . ", " . TFR_USER_ID . " from " . TB_ARTICLE . " where id='" . $selectid . "'";
        $row = dbGetRecord1($sql);
        if ($row) {
            setCookie(COOKIE_CHANNELID, $row[TFR_CHANNEL_ID]);
            if (!$is_manage) {
                Common::checkAdminExeAuthByUid($row[TFR_USER_ID]);
            } 
        }
        
        $rtn_layout['uid'] = $row[TFR_USER_ID];

        /**
         * ---ListContent---start---
         */
        $manage_sql = '';
        if (!$is_manage) {
            $manage_sql = ' and flag=0';
        } 

        if ($file_id == '') {
            $file_id = dbGetMinValue(TB_FILE, 'id', "article_id='" . $selectid . "'");
        } 

        $sql = "select * from " . TB_FILE . " where article_id='" . $selectid . "'" . $manage_sql . " order by ordernum "; 
        // Log_v(__FILE__, __LINE__, $sql);
        $rs = $db -> Execute($sql);
        while (!$rs -> EOF) {
            $id = $rs -> fields['id'];
            $operate_btn = Common::createButton('modify', '?act=edit_content&selectid=' . $selectid . '&file_id=' . $id . '');
            if ($rs -> fields['flag'] == 0) {
                $operate_btn .= Common::createButton('delete', '?act=delete_content&selectid=' . $id . '', true);
            } 

            if ($is_manage) {
                if ($rs -> fields['flag'] == 0) {
                    $operate_btn .= Common::createButton('delete_forever', '?act=delete_forever_content&selectid=' . $id . '', true);
                } else {
                    $operate_btn .= Common::createButton('comeback', '?act=comeback_content&selectid=' . $id . '', true);
                    $operate_btn .= Common::createButton('delete_forever', '?act=delete_forever_content&selectid=' . $id . '', true);
                } 
            } 
            $rs -> fields['eifrtf_title_style'] = '';
            if ($file_id == $id) {
                $rs -> fields['eifrtf_title_style'] = 'title_selected';
            } 
            $rs -> fields['eifrtf_operate_btn'] = $operate_btn;
            $rtn_layout['list_file'][] = $rs -> fields;
            $rs -> MoveNext();
        } 
        $rs -> Close();

        if ($act == 'edit_content') { // edit
            $toolbar = Common::createToolbar($url, 'save', '?act=save_edit_content');
            if ($rtn_layout['list_file']) {
                $toolbar .= Common::createButton('add_pic', '?act=add_content&selectid=' . $selectid, false, 'btn_add');
            }
            $toolbar .= Common::createImgButton('preview','article_view.php?selectid='.$selectid, '_blank');
            // file
            $sql = "select * from " . TB_FILE . " where id='" . $file_id . "'";
            $rtn_layout['edit_file'] = dbGetRecord1($sql, 'file');
        } else { // add
            $rtn_layout['edit_file'] = getTableFill('file');
            $rtn_layout['edit_file']['ordernum'] = dbGetMaxValue1(TB_FILE, 'ordernum', "article_id='$selectid'");

            $toolbar = Common::createToolbar($url, 'save', '?act=save_add_content');
        } 

        $rtn_layout['mediatype'] = $mediatype;
        $rtn_layout['menu_nav'] = Common::createAdminMenuNav($url);
        $rtn_layout['toolbar'] = $toolbar;

        return $rtn_layout;
    } 
 
    function get_layout_article_content_edit() {
        global $url;
        Common::checkAdminExeAuth($url, 'edit');

        $act = kGet('act');
        $selectValue = kRequest('selectValue');
        $selectid = kRequest('selectid');
        if ($selectValue) $selectid = $selectValue;

        $content_id = kRequest('content_id');
        if ($act == 'edit_content' && $content_id == '') {
            Log_d(__FILE__, __LINE__, 'add_content&selectid=' . $selectid);
            Common::showMsg('', '', '?act=add_content&selectid=' . $selectid);
        }

        $is_manage = Common::checkAdminAuth($url, 'manage');
        $uid = dbGetFieldValue(TB_ARTICLE, TFR_USER_ID, "id='" . $selectid . "'");
        if (!$is_manage) {
            Common::checkAdminExeAuthByUid($uid);
        }
        
        $rtnLayout = array();

        // get article contents
        $manage_sql = '';
        if (!$is_manage) {
            $manage_sql = ' and flag=0';
        } 
        $sql = "select * from " . TB_ARTICLE_CONTENT . " where article_id='" . $selectid . "'" . $manage_sql . " order by ordernum ";
        $rtnLayout['eifrtf_contents'] = dbGetRecordn($sql);

        if ($act == 'edit_content') { // edit
            $toolbar = Common::createToolbar($url, 'save', '?act=save_edit_content');
            if (IS_MULPAGE) {
                $toolbar .= Common::createButton('add_page', '?act=add_content&selectid=' . $selectid . '', false, 'add_page');
            }
            $toolbar .= Common::createImgButton('preview','article_view.php?selectid='.$selectid, '_blank');
            // content
            $sql = "select * from " . TB_ARTICLE_CONTENT . " where id='" . $content_id . "'";
            $rtnLayout['eifrtf_content'] = dbGetRecord1($sql);
            
        } else { // add
            $toolbar = Common::createToolbar($url, 'save', '?act=save_add_content');
            $rtnLayout['eifrtf_content'] = getTableFill('article_content');
        } 

        $rtnLayout['eifrtf_uid'] = $uid;
        $rtnLayout['eifrtf_content_id'] = $content_id;
        $rtnLayout['eifrtf_selectid'] = $selectid;
        $rtnLayout['eifrtf_is_manage'] = $is_manage;
        $rtnLayout['eifrtf_menu_nav'] = Common::createAdminMenuNav($url);
        $rtnLayout['eifrtf_toolbar'] = $toolbar;

        return $rtnLayout;
    } 

    function get_layout_article_subject_list_edit() {
        global $db, $lang, $url;
        Common::checkAdminExeAuth($url, 'edit'); //have edit authority ?	

        $article_id = kRequest('article_id');
        $template_id = kRequest('template_id');
        $layout_id = kRequest('layout_id');
        if($layout_id == '') $layout_id = 0;

        // edit layout
        $article_list = dbGetFieldValue(TB_SUBJECT_RELATION, 'article_list', "article_id=" . $article_id . " and layout_id=" . $layout_id);
        $article_list = Common::createArticleSelect($article_list);
        $rtnLayout = array(
            'article_id' => $article_id,
            'title' => dbGetFieldValue(TB_ARTICLE, 'title', "id='" . $article_id . "'"),
            'article_list' => $article_list,
            'template_id' => $template_id,
            'layout_id' => $layout_id,
        );

        $rtnLayout['eifrtf_menu_nav'] = Common::createAdminMenuNav($url);
        $rtnLayout['eifrtf_toolbar'] =  Common::createToolbar($url, 'save', '?act=save_edit_subject_list_layout');

        // layout id
        //ListLayout
        $rtnLayout['eifrtf_layoutlist'] = array();
        $rtnLayout['eifrtf_layoutlist'][] = array(
            'id' => 0,
            'title' => $lang['subject_default_layout_id'],
            'intro' => '',
            'layout_code' => '',
            'operate_btn' => Common::createButton('edit', '?act=edit_subject_list_layout&article_id=' . $article_id . '&template_id=' . $template_id . '&layout_id=0')
        );

        $sql = "select * from " . TB_TEMPLATE_LAYOUT . " where type=0 and status=0 and template_id='$template_id' order by ordernum asc ";
        $rs = $db -> Execute($sql);
        while (!$rs -> EOF) {
            $id = $rs -> fields['id'];

            $operate_btn = Common::createButton('edit', '?act=edit_subject_list_layout&article_id=' . $article_id . '&template_id=' . $template_id . '&layout_id=' . $id . '');
            $operate_btn .= Common::createButton('preview', '', false, '', "winOpen('../mod_template/template_view.php?selectid=" . $template_id . "&layout_id=" . $id . "')");

            $rtnLayout['eifrtf_layoutlist'][] = array('id' => $id,
                'title' => $rs -> fields['title'],
                'intro' => $rs -> fields['intro'],
                'layout_code' => $rs -> fields['layout_code'],
                'operate_btn' => $operate_btn
            );
            $rs -> MoveNext();
        } 
        $rs -> Close();
        
        return $rtnLayout;
    } 

    function insertArticleContent($title = '', $content = '', $article_id = '', $ordernum = '') {
        global $db, $lang, $url;
        $rtn = false;
        $title = sTextEncode($title, 255);
        $content = filterContent($content);
        $sql = "insert into " . TB_ARTICLE_CONTENT . " (title,content,article_id,ordernum) values('$title','$content','$article_id','$ordernum')"; 
        // echo $sql;
        $rs = $db -> Execute($sql);
        if ($rs) {
            $rtn = true;
        } else {
            $rtn = false;
        } 
        
        return $rtn;
    } 

    function splitConten($content = '', $split_size) {
        if (strlen($content) < $split_size) return $content;
        $content_arr = explode('<', $content);
        $npageBody = "";
        $istable = 0;
        $content = "";
        foreach($content_arr as $i => $k) {
            if ($i == 0) {
                $npageBody .= $content_arr[$i];
                continue;
            } 
            $content_arr[$i] = "<" . $content_arr[$i];
            if (strlen($content_arr[$i]) > 6) {
                $tname = substr($content_arr[$i], 1, 5);
                if (strtolower($tname) == 'table') $istable++;
                else if (strtolower($tname) == '/tabl') $istable--;
                if ($istable > 0) {
                    $npageBody .= $content_arr[$i];
                    continue;
                } else $npageBody .= $content_arr[$i];
            } else {
                $npageBody .= $content_arr[$i];
            } 
            if (strlen($npageBody) > $split_size) {
                $content .= $npageBody . '<input type=hidden name=eifr_pagebreak_split />';
                $npageBody = "";
            } 
        } 
        if ($npageBody != "") $content .= $npageBody;
        return $content;
    } 

    function showContentPages($article_id, $content_id) {
        global $lang;
        $rtn = '';
        $max_page = intval(dbGetMaxValue(TB_ARTICLE_CONTENT, 'ordernum', "article_id='" . $article_id . "'")); 
        // ListContent
        $current_page = intval(dbGetFieldValue(TB_ARTICLE_CONTENT, 'ordernum', "id='" . $content_id . "'"));
        $gotoUrl = basename($_SERVER['PHP_SELF']);
        $gotoPage = 1; 
        // echo $max_page."|".$current_page;
        if ($max_page > 1) {
            if ($current_page == 1) {
                $gotoPage = $current_page + 1;
                $content_id = dbGetFieldValue(TB_ARTICLE_CONTENT, 'id', "article_id='" . $article_id . "' and ordernum='" . $gotoPage . "'");
                $rtn = " <a href=\"" . $gotoUrl . "?content_id=" . $content_id . "\" title=\"" . $lang['page_next'] . "\">" . $lang['page_next'] . "</a>\n";
            } else if ($current_page == $max_page) {
                $gotoPage = $current_page-1;
                $content_id = dbGetFieldValue(TB_ARTICLE_CONTENT, 'id', "article_id='" . $article_id . "' and ordernum='" . $gotoPage . "'");
                $rtn = " <a href=\"" . $gotoUrl . "?content_id=" . $content_id . "\" title=\"" . $lang['page_previous'] . "\">" . $lang['page_previous'] . "</a>\n";
            } else {
                $gotoPage = $current_page-1;
                $content_id = dbGetFieldValue(TB_ARTICLE_CONTENT, 'id', "article_id='" . $article_id . "' and ordernum='" . $gotoPage . "'");
                $rtn .= " <a href=\"" . $gotoUrl . "?content_id=" . $content_id . "\" title=\"" . $lang['page_previous'] . "\">" . $lang['page_previous'] . "</a>\n";
                $gotoPage = $current_page + 1;
                $content_id = dbGetFieldValue(TB_ARTICLE_CONTENT, 'id', "article_id='" . $article_id . "' and ordernum='" . $gotoPage . "'");
                $rtn .= " <a href=\"" . $gotoUrl . "?content_id=" . $content_id . "\" title=\"" . $lang['page_next'] . "\">" . $lang['page_next'] . "</a>\n";
            } 
        } 

        return $rtn;
    } 

    function showContentJumpMenu($article_id, $content_id) {
        $rtn = '';
        $rs_count = dbGetRecordCount(TB_ARTICLE_CONTENT, "article_id='" . $article_id . "'");
        if ($rs_count < 2) return $rtn;
        $rtn .= '<select name="menu1" onChange="MM_jumpMenu(\'window\',this,0)" class="jump_menu">';
        $rtn .= $this -> createContentJumpMenu($article_id, $content_id);
        $rtn .= '</select>';
        return $rtn;
    } 

    /**
     * ---createContentJumpMenu---
     * 
     * @param string $article_id ,$content_id
     * @return string 
     */
    function createContentJumpMenu($article_id, $content_id) {
        global $db;
        $rtn = '';
        $gotoUrl = basename($_SERVER['PHP_SELF']);
        $sql = "select id, title,ordernum from " . TB_ARTICLE_CONTENT . " where article_id='" . $article_id . "'";
        $rs = $db -> Execute($sql);
        while (!$rs -> EOF) {
            $e_s = '';
            if ($rs -> fields['id'] == $content_id) {
                $e_s = ' selected';
                $content_id = '';
            } 
            $rtn .= "<option value=\"" . $gotoUrl . "?content_id=" . $rs -> fields['id'] . "\" " . $e_s . ">" . $rs -> fields['ordernum'] . "." . $rs -> fields['title'] . "</option>\n";

            $rs -> MoveNext();
        } 
        $rs -> Close();
        return $rtn;
    } 

    function getPollByArticleId($article_id) {
        $sql="select id,title from ".TB_POLL." where article_id='".$article_id."' order by ordernum ";
        return dbGetRecordn($sql);
    }
    
    function getArticleContentByArticleId($article_id, $is_manage = false) {
        $manage_sqlwhere = '';
        if(! $is_manage) {
            $manage_sqlwhere = ' and flag=0';
        }    
        $sql = "select * from " . TB_ARTICLE_CONTENT . " where article_id='" . $article_id . "'" . $manage_sqlwhere . " order by ordernum ";
        return dbGetRecordn($sql);
    }
    
    function getArticleAddTplfile($type = 0) {
        global $cfgarr_article_type;
        $tplfile = 'article_edit_add.tpl.html';
        $article_type_flip = array_flip($cfgarr_article_type);
        if (array_key_exists($type, $article_type_flip)) {
            $tplfile = $article_type_flip[$type] . '_edit.tpl.html';
        } 

        return $tplfile;
    } 

    function getArticleEditTplfile($type = 0) {
        global $cfgarr_article_type;
        $tplfile = 'article_edit.tpl.html';
        $article_type_flip = array_flip($cfgarr_article_type);
        if (array_key_exists($type, $article_type_flip)) {
            $tplfile = $article_type_flip[$type] . '_edit.tpl.html';
        } 
        if ($type == $cfgarr_article_type['info']) {
            $tplfile = 'info_edit_base.tpl.html';
        }

        return $tplfile;
    } 

    function getContentEditTplfile($type = 0) {
        global $cfgarr_article_type;
        $tplfile = 'article_edit_content.tpl.html';
        $article_type_flip = array_flip($cfgarr_article_type);
        if (array_key_exists($type, $article_type_flip)) {
            $tplfile = $article_type_flip[$type] . '_edit_content.tpl.html';
        } 

        return $tplfile;
    } 

    function getEditProgramFile($type = 0) {
        global $cfgarr_article_type;
        $pfile = 'article_edit.php';
        $article_type_flip = array_flip($cfgarr_article_type);
        if (array_key_exists($type, $article_type_flip)) {
            $pfile = $article_type_flip[$type] . '_edit.php';
        } 

        return $pfile;
    } 

    function getManageProgramFile($type = 0) {
        global $cfgarr_article_type;
        $pfile = 'article.php';
        $article_type_flip = array_flip($cfgarr_article_type);
        if (array_key_exists($type, $article_type_flip)) {
            $pfile = $article_type_flip[$type] . '.php';
        } 

        return $pfile;
    }
    
    function checkChannelForUser($channel_id = '', $uid = '') {
        global $lang;
        if ($channel_id == '') return;
        
        if ($uid == '' ) $uid = getCookie(COOKIE_UID);
        $user_class_id = getCookie(COOKIE_USERCLASS);
        if($uid != getCookie(COOKIE_UID)) {
            $user_class_id = dbGetFieldValue(TB_USER,'user_class_id',"".TF_USER_ID." ='".$uid."'");
        }
        $channelArray = $this -> getChannelIdsByUid($uid, $user_class_id);
        if ($channelArray[0] != '-1') {
            if (!in_array($channel_id, $channelArray)) {
                Common::showWarningMsg($lang['checkAuth']);
            } 
        } 
    } 

    function checkChannelsForUser($channel_ids = '', $uid = '') {
        global $lang;
        if ($channel_ids == '') return;
        
        if ($uid == '' ) $uid = getCookie(COOKIE_UID);
        $user_class_id = getCookie(COOKIE_USERCLASS);
        if($uid != getCookie(COOKIE_UID)) {
            $user_class_id = dbGetFieldValue(TB_USER,'user_class_id',"".TF_USER_ID." ='".$uid."'");
        }
        $channelArray = $this -> getChannelIdsByUid($uid, $user_class_id);
        $channelIdsArr = explode(',', $channel_ids);
        if ($channelArray[0] != '-1') {
            foreach($channelIdsArr as $key => $val) {
                if (!in_array($val, $channelArray)) {
                    Common::showWarningMsg($lang['checkAuth']);
                } 
            } 
        } 
    } 

    function getChannelIdsByUid($uid, $user_class_id = '') {
        $rtn = array();
        if (Common::checkSysAdmin()) {
            $rtn[0] = '-1';
        } else { // check user
            $channel_id = dbGetFieldValue(TB_USER, TFR_CHANNEL_ID, "" . TF_USER_ID . " ='" . $uid . "'");
            $channel_id = removeCommaHeadTail($channel_id);
            if (strpos($channel_id, ',') > 0) {
                $rtn = explode(',', $channel_id);
            } else {
                $rtn[0] = $channel_id;
            } 
            if ($rtn[0] == '') {
                // when user not 'channel_id', check user class
                $user_class_channel_id = dbGetFieldValue(TB_USER_CLASS, TFR_CHANNEL_ID, "" . TF_USER_CLASS_ID . " ='" . $user_class_id . "'");
                $user_class_channel_id = removeCommaHeadTail($user_class_channel_id);
                if (strpos($user_class_channel_id, ',') > 0) {
                    $rtn = explode(',', $user_class_channel_id);
                } else {
                    $rtn[0] = $user_class_channel_id;
                } 
            } 
        } 
        return $rtn;
    } 

    function createPollList($article_id) {
        global $db, $poll_list;
        $poll_list = '';
        $sql = "select id,title from " . TB_POLL . " where article_id='" . $article_id . "' order by ordernum ";
        $rs = $db -> Execute($sql); 
        // echo $sql;
        while (!$rs -> EOF) {
            $poll_list .= "<input type='text' name='poll_title[]' class='input_text' size='40' value='" . $rs -> fields['title'] . "'>";
            $poll_list .= "<input type='hidden' name='poll_id[]' value='" . $rs -> fields['id'] . "'>";
            $poll_list .= "<br />\n";
            $rs -> MoveNext();
        } 
        $rs -> Close();

        return $poll_list;
    } 

    /**
     * ---createSubjectSelect---
     * 
     * @param string $subject_list 
     * @return string 
     */
    function createSubjectSelect($article_id = '') {
        global $db;
        $rtn = '';
        $e_s = ' selected';
        if ($article_id != '') {
            $article_list_arr = array();
            $sql = "select article_id from " . TB_SUBJECT_RELATION . " where  find_in_set($article_id,article_list) ";
            $rs = $db -> Execute($sql);
            while (!$rs -> EOF) {
                if (!in_array($rs -> fields['article_id'], $article_list_arr)) {
                    $article_list_arr[] = $rs -> fields['article_id'];
                } 

                $rs -> MoveNext();
            } 
            $rs -> Close();

            for($i = 0; $i < count($article_list_arr); $i++) {
                $rtn .= "<option value='" . $article_list_arr[$i] . "' " . $e_s . ">" . dbGetFieldValue(TB_ARTICLE, 'title', "id='" . $article_list_arr[$i] . "'") . "</option>\n";
            } 
        } 
        return $rtn;
    } 

    function createUserChannelIdList($uid, $channelid_list = '') {
        global $db;
        $rtn = '';
        if ($channelid_list != '') {
            $sql = "select channelid,title from " . TB_USER_CHANNEL . " where uid='$uid' and channelid in ($channelid_list) order by ordernum ";
            $rs = $db -> Execute($sql);
            while (!$rs -> EOF) {
                $title = $this -> getUserChannelTile($uid, $rs -> fields['channelid']);
                $rtn .= "<option value='" . $rs -> fields['channelid'] . "' selected>$title</option>\n";
                $rs -> MoveNext();
            } 
            $rs -> Close();
        } 

        return $rtn;
    } 

    function getUserChannelTile($uid, $channelid = '') {
        global $db;
        $rtn = '';
        $tmp_ary = array();
        $channelidlen = strlen($channelid);
        if ($channelidlen > 0) {
            for($i = 2; $i <= $channelidlen; $i = $i + 2) {
                $tmp = substr($channelid, 0, $i);
                $sql = "select title from " . TB_USER_CHANNEL . " where uid='$uid' and channelid='$tmp' order by ordernum ";
                $rs = $db -> Execute($sql);
                if (!$rs -> EOF) {
                    $tmp_ary[] = $rs -> fields['title'];
                } 
                $rs -> Close();
            } 
        } 
        $rtn = implode(' -> ', $tmp_ary);

        return $rtn;
    } 

    function creatCommentRadio($status = 0) {
        global $lang;
        $rtn = '';
        $status_arr = array(0, 1);
        $status_txt_arr = array('open', 'stop');
        if (!is_numeric($status)) $status = -1;
        for($i = 0; $i < 2;$i++) {
            $e_s = '';
            if ($status_arr[$i] == $status) {
                $e_s = ' checked';
                $status = '';
            } 
            $showvalue = $status_txt_arr[$i];
            if (array_key_exists($status_txt_arr[$i], $lang)) $showvalue = $lang[$status_txt_arr[$i]];
            $rtn .= "<input type='radio' name='is_comment' value='" . $status_arr[$i] . "' " . $e_s . ">" . $showvalue . "&nbsp;\n";
        } 
        return $rtn;
    } 

    function getAttributeProperty($selectid = '') {
        global $db;
        global $cfgarr_article_param_property;
        $attribute = dbGetFieldValue(TB_ARTICLE, 'attribute', "id='$selectid'");
        if ($attribute == '') return '';

        $ary_attribute = explode(',', $attribute);
        $ary_tmp = array();
        foreach($cfgarr_article_param_property as $key => $value) {
            if (in_array($value, $ary_attribute)) $ary_tmp[] = $value;
        } 
        $rtn = implode(',', $ary_tmp);
        return $rtn;
    } 

    function getArticleContentString($id) {
        global $db;
        $rtn = '';
        $sql = "select title,content from " . TB_ARTICLE_CONTENT . " where article_id='" . $id . "' and flag=0 order by ordernum";
        $rs = $db -> Execute($sql);
        while (!$rs -> EOF) {
            $rtn .= "\n" . $rs -> fields['title'];
            $rtn .= "\n" . $rs -> fields['content'];
            $rs -> MoveNext();
        } 
        $rs -> Close();
        return $rtn;
    } 

    function getArticlePollString($id) {
        global $db;
        $rtn = '';
        $sql = "select title from " . TB_POLL . " where article_id='" . $id . "' order by ordernum ";
        $rs = $db -> Execute($sql);
        while (!$rs -> EOF) {
            $rtn .= "\n" . $rs -> fields['title'];
            $rs -> MoveNext();
        } 
        $rs -> Close();

        return $rtn;
    } 

    function getFileString($id) {
        global $db;
        $rtn = '';
        $sql = "select title from " . TB_FILE . " where article_id='" . $id . "' order by ordernum ";
        $rs = $db -> Execute($sql);
        while (!$rs -> EOF) {
            $rtn .= "\n" . $rs -> fields['title'];
            $rs -> MoveNext();
        } 
        $rs -> Close();

        return $rtn;
    } 

    function creatAttributeCheckbox($attribute = '', $is_manage = false) {
        global $lang;
        global $cfgarr_article_param_property, $cfgarr_article_param_source, $cfgarr_article_param_type;
        $rtn = '';
        $ary_attribute = array();
        if ($attribute != '') $ary_attribute = explode(',', $attribute);
        if ($is_manage) {
            foreach($cfgarr_article_param_property as $key => $value) {
                $showvalue = $value;
                if (array_key_exists($value, $lang)) $showvalue = $lang[$value];
                $in_str = '';
                if (in_array($value, $ary_attribute)) $in_str = ' checked';
                $rtn .= "<input type='checkbox' name='attribute_property[]' value='" . $value . "' $in_str>" . $showvalue . "&nbsp;\n";
            } 
        } 

        if (1) { // 0: disable
                $rtn .= '&nbsp;|&nbsp;';
            foreach($cfgarr_article_param_source as $key => $value) {
                $showvalue = $value;
                if (array_key_exists($value, $lang)) $showvalue = $lang[$value];
                $in_str = '';
                if (in_array($value, $ary_attribute)) $in_str = ' checked';
                $rtn .= "<input type='radio' name='attribute_source' value='" . $value . "' $in_str>" . $showvalue . "&nbsp;\n";
            } 
        } 
        if (1) { // 0: disable
                $rtn .= '&nbsp;|&nbsp;';
            foreach($cfgarr_article_param_type as $key => $value) {
                $showvalue = $value;
                if (array_key_exists($value, $lang)) $showvalue = $lang[$value];
                $in_str = '';
                if (in_array($value, $ary_attribute)) $in_str = ' checked';
                $rtn .= "<input type='radio' name='attribute_type' value='" . $value . "' $in_str>" . $showvalue . "&nbsp;\n";
            } 
        } 

        return $rtn;
    } 

    /**
     * setSelectChannels
     * Can provide customized select channels, effect on getSelectChannels of class_channel.php
     * 
     * @param  $channel_ids , if not value then select all
     */
    function setSelectChannels($channel_ids = array()) {
        if ($channel_ids) {
            setSSession('eifr_tmp_select_root_channels', $channel_ids);
        } else {
            delSession('eifr_tmp_select_root_channels');
        } 
    } 

    function setSelectChannelsByUrl($url) {
        $channel_ids_arr = array();
        require_once(EIFR_ROOT . 'admin/mod_adminmenu/class_adminmenu.php');
        $clComAdminmenu = new ComAdminmenu();
        $adminmenu = $clComAdminmenu -> getAdminmenuByUrl($url);
        if ($adminmenu) {
            $param_arr = unserialize($adminmenu['parameter']);
            if (is_array($param_arr) && isset($param_arr['channel_ids'])) {
                $channel_ids_arr = explode(',', $param_arr['channel_ids']);
            } 
        } 
        $this -> setSelectChannels($channel_ids_arr);
    } 

    function getDefaultTemplateByUrl($url) {
        $rtn = array('template_id' => '', 'template_title' => '');
        require_once(EIFR_ROOT . 'admin/mod_adminmenu/class_adminmenu.php');
        $clComAdminmenu = new ComAdminmenu();
        $adminmenu = $clComAdminmenu -> getAdminmenuByUrl($url);
        if ($adminmenu) {
            $param_arr = unserialize($adminmenu['parameter']);
            if (is_array($param_arr) && isset($param_arr['template_id'])) {
                $rtn['template_id'] = $param_arr['template_id'];
                require_once(EIFR_ROOT . 'admin/mod_template/class_template.php');
                $tpl = ComTemplate:: getTemplateById($param_arr['template_id']);
                $rtn['template_title'] = $tpl['title'];
            } 
        } 
        return $rtn;
    }

    function createTypeSelect($type = '') {
        global $lang;
        $rtn = '';
        if (!is_numeric($type)) $type = -1;
        for($i = 0; $i < count($lang['article_type_arr']);$i++) {
            $e_s = '';
            if ($i == $type) {
                $e_s = ' selected';
                $type = '';
            } 
            $showvalue = $lang['article_type_arr'][$i];
            $rtn .= "<option value='" . $i . "' " . $e_s . ">" . $showvalue . "</option>\n";
        } 

        return $rtn;
    }

    function cTagTypeSelect($type = '') {
        global $lang;
        $options = array();
        $options[] = array('title'=>$lang['article_type'], 'value'=>'');
        foreach ($lang['article_type_arr'] as $key=>$val) {
            $options[] = array('title'=>$val, 'value'=>$key);
        }

        $selectAttrs = array('name'=>'type', 'class'=>'input_select');
        $selectValues = array($type);
        return Common::cTagSelect($selectAttrs, $options, $selectValues);
    }
    
    function cTagFlagSelect($flag = '') {
        $selectAttrs = array('name'=>'flag', 'class'=>'input_select');
        return Common::cTagFlagSelect($selectAttrs, $flag);
    }
    
    function cTagStatusSelect($status = '') {
        $selectAttrs = array('name'=>'status', 'class'=>'input_select');
        return Common::cTagStatusSelect($selectAttrs, $status);
    }
    
    function cTagChannelSelect($channel_id = '') {
        $selectAttrs = array('name'=>'channel_id', 'class'=>'input_select');
        return Common::cTagChannelSelect($selectAttrs, $channel_id);
    }
    
    function cTagLayoutMSelect($layout_ids = '') {
        $selectAttrs = array('name'=>'layout_id[]', 'id'=>'layout_id', 'multiple'=>'multiple', 'size'=>3);
        return Common::cTagLayoutMSelect($selectAttrs, $layout_ids);
    }
    
    function getUploadImgPath() {
        return DIR_INSTALL . 'linkfiles/image/' . CFile::genDatePath();
    }
} 

?>
