<?php
/**
 * 
 * @file acl_adminmenu.php
 * Access Control List for Adminmenu
 * @copyright (c) 2005 - 2011 eifr.com
 * @license http://www.gnu.org/copyleft/gpl.html gnu/gpl
 * eifr is free software
 */
require_once(EIFR_ROOT . 'libraries/acl.php');

class CAclAdminmenu extends CAcl {
    var $defAccess = array('read' => 1,
        'add' => 2,
        'edit' => 4,
        'delete' => 8,
        'manage' => 16
        );

    var $url;

    function __construct($url = '') {
        parent :: __construct($this -> defAccess);
        $this -> url = $url;
    } 

    function checkUrlAccess($url = '') {
        if ($url == '') $url = $this -> url;

        $adminmenu_id = $this -> getAdminmenuIdByUrl($url);
        $acl_arr = $this -> getUserAcls();

        if (is_array($acl_arr) && array_key_exists($adminmenu_id, $acl_arr)) {
            return true;
        } 
        return false;
    } 

    function checkActionAccess($action = '', $url = '') {
        if (! array_key_exists($action, $this -> defAccess)) {
            global $lang;
            Log_e(__FILE__, __LINE__, 'checkAccess: ' . $lang['authParamInvalid']); 
            // $this->showMsg($lang['authParamInvalid']);
            return false;
        } 
        if ($url == '') $url = $this -> url;

        $adminmenu_id = $this -> getAdminmenuIdByUrl($url);
        $acl_arr = $this -> getUserAcls();
        $select_aclvalue = 0;
        if (is_array($acl_arr) && array_key_exists($adminmenu_id, $acl_arr)) {
            $select_aclvalue = $acl_arr[$adminmenu_id];
        } 

        return $this -> isAllowedInValue($action, $select_aclvalue);
    } 

    function getUserAcls() {
        $rtn = array();
        $aclstr = '';
        $cacheHelper = new CCacheHelper('db_user_class');
        $user_class = $cacheHelper -> getCache();
        if ($user_class) {
            foreach($user_class as $key => $val) {
                if ($key == getCookie(COOKIE_USERCLASS)) {
                    $aclstr = $val['acl'];
                    break;
                } 
            } 
        } else {
            $aclstr = dbGetFieldValue(TB_USER_CLASS, "acl", "id ='" . getCookie(COOKIE_USERCLASS) . "'");
        } 
        // Log_v('','getUserAcls',$aclstr);
        $acl_arr = unserialize($aclstr);
        if (is_array($acl_arr)) {
            $rtn = $acl_arr;
        } 
        return $rtn;
    } 

    function getAdminmenuIdByUrl($url = '') {
        $adminmenu_id = '';
        $cacheHelper = new CCacheHelper('db_adminmenu');
        $adminmenu = $cacheHelper -> getCache();
        if ($adminmenu) {
            foreach($adminmenu as $key => $val) {
                if ($val['tourl'] == $url) {
                    $adminmenu_id = $key;
                    break;
                } 
            } 
        } else {
            $adminmenu_id = dbGetFieldValue(TB_ADMINMENU, "id", "tourl ='" . $url . "'");
        } 

        return $adminmenu_id;
    } 
} 

/**
 * End of file acl_adminmenu.php
 */