<?php
/**
 * 常用函数库
 * @author wuwenbin <wenbin.wu@foxmail.com>
 * @license http://opensource.org/licenses/MIT The MIT License
 */

// 递归去除\,'转义
function stripslashes_deep($data) {
    if(is_array($data)) return array_map(__FUNCTION__, $data);
    else return stripslashes($data);
}

// 对字符(',\)转义
function addslashes_deep($data) {
    if(is_array($data)) return array_map(__FUNCTION__, $data);
    else return addslashes($data);
}

// 解析ini字符串
function parse_ini($str, $process_sections = false) {
    $rows = preg_split('/\r|\n|\r\n/', $str);
    $sections = array(array());
    $section_in = 0;
    foreach($rows as $v) {
        // 注释
        if(preg_match('/^\s*;/', $v)) {
            continue;
        }
        // 节
        if(preg_match('/^\s*\[([^\]]*)\]/U', $v, $r)) {
            if($process_sections) {
                $section_in = $r[1];
                if(!isset($sections[$section_in])) $sections[$section_in] = array();
            }
            continue;
        }
        // 键 = 值
        if(preg_match('/^([^=]*)=(.*)$/', $v, $r)) {
            $key = trim($r[1]);
            $value = trim($r[2]);
            $sections[$section_in][$key] = $value;
        }
    }
    if($process_sections) {
        if(empty($sections[0])) unset($sections[0]);
        return $sections;
    } else {
        return $sections[0];
    }
}

// 构造插入语句
function build_insert_sql($table, $data) {
    if(!is_array($data) || empty($data)) return "";
    $sql = "insert into $table";
    $fields = "";
    $values = "";
    foreach($data as $k => $v) {
        $fields .= "`$k`,";
        $values .= "'$v',";
    }
    $fields = trim($fields, ",");
    $values = trim($values, ",");
    $sql .= "($fields) values($values)";
    return $sql;
}

// 构造替换语句
function build_replace_sql($table, $data) {
    if(!is_array($data) || empty($data)) return "";
    $sql = "replace into $table";
    $fields = "";
    $values = "";
    foreach($data as $k => $v) {
        $fields .= "`$k`,";
        $values .= "'$v',";
    }
    $fields = trim($fields, ",");
    $values = trim($values, ",");
    $sql .= "($fields) values($values)";
    return $sql;
}

// 构造更新语句
function build_update_sql($table, $data, $where = "") {
    if(!is_array($data) || empty($data)) return "";
    $sql = "update $table set ";
    foreach($data as $k => $v) {
        $sql .= "`$k` = '$v',";
    }
    $sql = trim($sql, ",").($where ? "where $where" : "");
    return $sql;
}

// 获取记录集列集合
function get_col($fields, array $data) {
    $cols = array();
    if(is_array($fields)) {
        $is_one = false;
    } else {
        $is_one = true;
        $fields = array((string)$fields);
    }

    foreach($fields as $v) $cols[$v] = array();
    foreach($data as $k => $v) {
        foreach($fields as $v1) {
            if(isset($v[$v1])) $cols[$v1][$k] = $v[$v1];
        }
    }

    return $is_one ? $cols[$fields[0]] : $cols;
}

// 判断是否为POST请求
function is_post() {
    $method = isset($_SERVER['REQUEST_METHOD']) ? $_SERVER['REQUEST_METHOD'] : "";
    return strtoupper($method) == "POST" ? true : false;
}

// 判断是否为GET请求
function is_get() {
    $method = isset($_SERVER['REQUEST_METHOD']) ? $_SERVER['REQUEST_METHOD'] : "";
    return strtoupper($method) == "GET" ? true : false;
}

// 判断是否为AJAX请求
function is_ajax() {
    if(isset($_SERVER['HTTP_X_REQUESTED_WITH'])) {
        if(strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') return true;
    }
    return false;
}

// 判断是否为HTTPS请求
function is_https() {
    $https = isset($_SERVER["HTTPS"]) ? $_SERVER["HTTPS"] : "";
    return ($https == "on") ? true : false;
}

// 获取GET请求数据
function G($key, $default = null) {
    return isset($_GET[$key]) ? $_GET[$key] : $default;
}

// 获取POST请求数据
function P($key, $default = null) {
    return isset($_POST[$key]) ? $_POST[$key] : $default;
}

// 获取REQUEST(GET/POST)数据
function R($key, $default = null) {
    return isset($_REQUEST[$key]) ? $_REQUEST[$key] : $default;
}

// 构造数字验证码(修改自thinkphp)
function build_verify_image($width = 48, $height = 22) {
    $verify_code = "";
    $chars = "1234567890";
    $length = 4;
    $im = imagecreate($width, $height);
    $r = Array(225, 255, 255, 223);
    $g = Array(225, 236, 237, 255);
    $b = Array(225, 236, 166, 125);
    $key = mt_rand(0, 3);
    $back_color = imagecolorallocate($im, $r[$key], $g[$key], $b[$key]);
    $border_color = imagecolorallocate($im, 100, 100, 100);
    $string_color = imagecolorallocate($im, mt_rand(0, 200), mt_rand(0, 120), mt_rand(0, 120));
    imagefilledrectangle($im, 0, 0, $width - 1, $height - 1, $back_color);
    imagerectangle($im, 0, 0, $width - 1, $height - 1, $border_color);
    // 干扰
    for ($i = 0; $i < 10; $i++) {
        imagearc($im, mt_rand(-10, $width), mt_rand(-10, $height), mt_rand(30, 300), mt_rand(20, 200), 55, 44, $string_color);
    }
    for ($i = 0; $i < 25; $i++) {
        imagesetpixel($im, mt_rand(0, $width), mt_rand(0, $height), $string_color);
    }
    for ($i = 0; $i < $length; $i++) {
        $char = substr($chars, mt_rand(0, strlen($chars) - 1), 1);
        imagestring($im, 5, $i * 10 + 5, mt_rand(1, 8), $char, $string_color);
        $verify_code .= $char;
    }
    header("content-type: image/png");
    imagepng($im);
    imagedestroy($im);
    return $verify_code;
}

//字符串截取(模式:0:英文+1中文+2;1:英文+1,中文+1)
function str_cut($str, $length, $ext = '', $mode = 0) {
    $len = 0;
    $output = '';
    preg_match_all("/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/", $str, $match);

    // 模式0:英文+1;中文+2;
    if($mode == 0) {
        foreach($match[0] as $v) {
            if(strlen($v) > 1) $len += 2;
            else $len += 1;
            $output .= $v;
            if($len >= $length) break;
        }
    }
    // 模式1:英文+1;中文+1;
    elseif($mode == 1) {
        $output = join("",array_slice($match[0], 0, $length));
    } else {
        return '';
    }

    if(strlen($output) < strlen($str)) $output .= $ext;
    return $output;
}

// 获取字符串长度(0:系统默认模式;1:中文+2,英文+1;2:中文+1,英文+1)
function get_str_len($str, $model = 0) {

    if($model == 0) return strlen($str);

    preg_match_all("/[\x{4e00}-\x{9fa5}]/Uu", $str, $match);
    $zh = count($match[0]);
    $_str = preg_replace("/[\x{4e00}-\x{9fa5}]/Uu", '', $str);

    $en = strlen($_str);

    if($model == 1) return $zh * 2 + $en;
    if($model == 2) return $zh * 1 + $en;
    return strlen($str);
}

// 获取当前网址
function get_cur_url() {
    return "http".(is_https() ? "s" : "")."://".$_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"];
}

// 获取来路网址
function get_referer_url() {
    return isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : "";
}

// 获取客户端IP(修改自thinkphp)
function get_client_ip() {
    static $ip = NULL;
    if ($ip !== NULL) return $ip;
    if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $arr = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        $pos =  array_search('unknown',$arr);
        if(false !== $pos) unset($arr[$pos]);
        $ip   =  trim($arr[0]);
    }elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    }elseif (isset($_SERVER['REMOTE_ADDR'])) {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    // IP地址合法验证
    $ip = (false !== ip2long($ip)) ? $ip : '';
    return $ip;
}

// htmlspecialchars别名
function H($str) {
    return htmlspecialchars($str);
}

// COOKIE读写
function cookie($key, $value = "", $expire = 0) {
    if(func_num_args() == 1){
        if(isset($_COOKIE[$key])) return $_COOKIE[$key];
        return null;
    } else {
        if($expire != 0) $expire = time()+$expire;
        return setcookie($key, $value, $expire, "/");
    }
}

// 返回json应答数据
function return_json($flag, $info = '', $data = '') {
    $return["flag"] = (int)$flag;
    $return["info"] = (string)$info;
    $return["data"] = $data;
    echo json_encode($return);
    exit;
}

// 构造数据签名
function build_signature(array $params, $key) {
    $tmp = array();
    foreach($params as $k => $v) $tmp[] = $k.$v;
    sort($tmp);
    return strtoupper(md5($key.implode("", $tmp).$key));
}

// JS信息提示
function alert($msg, $url) {
    $msg = json_encode($msg);
    $url = json_encode($url);
    echo "<script type=\"text/javascript\">alert({$msg}); location.href = {$url};</script>";
    exit;
}

// 分页函数
function page_html($url, $page, $count, $each) {
    $page = max((int)$page, 1);
    $each = max((int)$each, 1);
    $count = (int)$count;
    if($count < 1) return "<span>共0条记录</span> ";
    $total_page = ceil($count / $each);
    $html = "<strong>$page</strong> ";
    $len = 6;
    $l = $r = 1;
    while(1) {
        if($page - $l > 0) {
            $_page = $page - $l;
            $_url = str_replace("[p]", $_page, $url);
            $html = '<a href="'.$_url.'">'.$_page.'</a> '.$html;
            $l++;
            $len--;
        }
        if($len == 0) break;
        if($page + $r < $total_page + 1) {
            $_page = $page + $r;
            $_url = str_replace("[p]", $_page, $url);
            $html .= '<a href="'.$_url.'">'.$_page.'</a> ';
            $r++;
            $len--;
        }
        if($len == 0) break;
        if($page - $l <= 0 && $page + $r > $total_page) break;
    }

    if($page - 1 > 0) {
        $_page = $page - 1;
        $_url = str_replace("[p]", $_page, $url);
        $html = '<a href="'.$_url.'">上页</a> '.$html;
    } else {
        $html = '<a href="javascript:;">上页</a> '.$html;
    }

    if($page + 1 < $total_page + 1) {
        $_page = $page + 1;
        $_url = str_replace("[p]", $_page, $url);
        $html .= '<a href="'.$_url.'">下页</a> ';
    } else {
        $html .= '<a href="javascript:;">下页</a> ';
    }

    if($page > 1) {
        $_page = 1;
        $_url = str_replace("[p]", $_page, $url);
        $html = '<a href="'.$_url.'">首页</a> '.$html;
    } else {
        $html = '<a href="javascript:;">首页</a> '.$html;
    }

    if($page < $total_page) {
        $_page = $total_page;
        $_url = str_replace("[p]", $_page, $url);
        $html .= '<a href="'.$_url.'">末页</a> ';
    } else {
        $html .= '<a href="javascript:;">末页</a> ';
    }

    $html = "<span>共{$total_page}页/{$count}条记录</span> ".$html;
    return $html;
}

// 获取用于分页的url
function get_page_url() {
    $cur_url = "http".(is_https() ? "s" : "")."://".$_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"];
    if(preg_match("/page=(\d+)/", $cur_url)) {
        return preg_replace("/page=(\d+)/", "page=[p]", $cur_url);
    } else {
        return $cur_url.(strpos($cur_url, "?") ? "&" : "?")."page=[p]";
    }
}

// 发送邮件(使用phpmailer)
function send_mail($from_name, $from, $to, $subject, $body, array $smtp, &$err = null) {
    include_once(dirname(__FILE__)."/phpmailer/class.phpmailer.php");
    try {
        ob_start();
        $mail = new PHPMailer();
        $mail->Mailer = "smtp";
        $mail->Host = isset($smtp["host"]) ? $smtp["host"] : "127.0.0.1";
        $mail->Port = isset($smtp["port"]) ? $smtp["port"] : 25;
        $mail->Username = isset($smtp["user"]) ? $smtp["user"] : "";
        $mail->Password = isset($smtp["pass"]) ? $smtp["pass"] : "";
        $mail->FromName = $from_name;
        $mail->From = $from;
        if(is_array($to)) {
            foreach($to as $address) $mail->AddAddress($address);
        } else {
            $mail->AddAddress($to);
        }
        $mail->Subject = $subject;
        $mail->Body = $body;
        $mail->CharSet = "UTF-8";
        $mail->Encoding = "base64";
        $mail->IsHTML(true);
        $mail->AltBody = "text/html";
        $mail->SMTPAuth = true;
        $mail->SMTPDebug = false;

        $res = (bool)$mail->Send();
        $err = ob_get_clean();
        return $res;

    } catch(phpmailerException $e) {
        $err = $e->errorMessage();
        return false;
    }
}

// URL重定向
function redirect($url) {
    @header('location:'.$url);
    exit;
}

// 清空目录
function clean_dir($path, &$list = null) {
    if(!is_dir($path)) return null;
    $handle = @opendir($path);
    while($file = @readdir($handle)) {
        if($file == '.' || $file == '..') continue;
        if(is_dir($path.'/'.$file)) {
            clean_dir($path.'/'.$file, $list);
            if(!@rmdir($path.'/'.$file)) {
                @chmod($path.'/'.$file, 0777);
                @rmdir($path.'/'.$file);
            }
            if(!file_exists($path.'/'.$file)) $list[] = $path.'/'.$file;
        } else {
            if(!@unlink($path.'/'.$file)) {
                @chmod($path.'/'.$file, 0777);
                @unlink($path.'/'.$file);
            }
            if(!file_exists($path.'/'.$file)) $list[] = $path.'/'.$file;
        }
    }
}

// 获取顶级域名
function get_TLD($url) {
    $top_level_domain = array(
        'com','edu','gov','int','mil','net','org','biz','info',
        'pro','name','museum','coop','aero','xxx','idv','mobi','cc','me'
    );
    $tld = implode('|', $top_level_domain);

    $parse = @parse_url($url);
    $host = strtolower(isset($parse['host']) ? $parse['host'] : '');

    if(preg_match('/[^\.]+\.('.$tld.')$/', $host, $match)) {
        $domain = $match[0];
    } elseif(preg_match('/[^\.]+\.('.$tld.')\.\w{2}$/', $host, $match)) {
        $domain = $match[0];
    } else {
        $domain = '';
    }
    return $domain;
}

// 构造唯一ID
function uuid($prefix = "") {
    $time = md5(microtime());
    $rand1 = md5(substr($time, rand(0,10), rand(22,32)));
    $rand2 = md5(substr($rand1, rand(0,10), rand(22,32)));
    $id = strtolower(md5($prefix.$ip.$time.$rand1.$rand2));
    return $id;
}

// 数组递归覆盖
function array_merge_deep(array &$arr1, array $arr2) {
    foreach($arr2 as $k => $v) {
        if(!isset($arr1[$k])) $arr1[$k] = $v;
        else {
            if(!is_array($arr1[$k]) || !is_array($v)) $arr1[$k] = $v;
            else array_merge_deep($arr1[$k], $v);
        }
    }
}

// 检查邮件格式是否合法
function is_valid_email($email) {
    return (bool)preg_match("/[_a-zA-Z\d\-\.]+@[_a-zA-Z\d\-]+(\.[_a-zA-Z\d\-]+)+$/i", $email);
}

// 检查域名格式是否合法
function is_valid_domain($domain) {
    return (bool)preg_match("/^([a-z0-9\-]+\.)+([a-z]{2,})$/i", $domain);
}

// 检查手机号码是否合法(11位大陆号码)
function is_valid_mobile_number($mobile_no) {
    return (bool)preg_match("/^(13|14|15|17|18)\d{9}$/", $mobile_no);
}

