<?php
// 分类操作
include_once(dirname(__FILE__)."/init.php");
if(!$mid) {
    alert("请先登录", get_root_url());
}

$do = G("do");

// 编辑页面
if($do == "edit_show") {
    $cid = (int)G("cid", 0);

    $category = get_category($cid, $mid);
    if(empty($category)) {
        return_json(0, "分类不存在");
    } else {
        template::assign("cid", $cid);
        template::assign("category", $category);
        $html = template::display("category_edit.html", 1);
        return_json(1, "", $html);
    }
}

// 编辑保存
elseif($do == "edit_save") {
    $cid = (int)P("cid");
    $name = trim(P("name", ""));
    $is_private = (int)P("is_private");

    $category = get_category($cid, $mid);
    if(empty($category)) {
        return_json(0, "分类不存在");
    }

    if(strlen($name) < 1) {
        return_json(0, "请填写分类名称");
    }

    $sql = build_update_sql("category", array(
        "name" => addslashes($name),
        "is_private" => $is_private
    ), "id = $cid");

    $res= mysql::query(" $sql");
    if($res) {
        return_json(1, "修改分类成功");
    } else {
        return_json(0, "修改分类失败");
    }
}

// 添加页面
elseif($do == "add_show") {
    $html = template::display("category_add.html", 1);
    return_json(1, "", $html);
}

// 添加保存
elseif($do == "add_save") {
    $name = trim(P("name"), "");
    $is_private = (int)P("is_private");

    if(strlen($name) < 1) {
        return_json(0, "请填写分类名称");
    }

    $per = (int)config::get("category_per_hour");
    $sql = "select count(*) as `count` from category where ctime >= unix_timestamp() - 3600";
    $res = mysql::query($sql);
    $count = empty($res) ? 0 : $res[0]["count"];
    if($count >= $per) {
        return_json(0, "每小时最多只允许添加{$per}个分类");
    }

    $sql = build_insert_sql("category", array(
        "name" => addslashes($name),
        "is_private" => $is_private,
        "uid" => $mid,
        "ctime" => time()
    ));

    $cid = mysql::query($sql);
    if(!$cid) {
        return_json(0, "添加分类失败");
    }

    $sql = build_update_sql("category", array(
        "sort" => $cid
    ), "id = $cid");

    $res = mysql::query($sql);

    return_json(1, "添加分类成功", $cid);
}

// 删除
elseif($do == "delete") {
    $cids = explode(",", P("cid", ""));
    $cids = array_unique(array_map("intval", $cids));

    $sql = "delete from category where id in(".implode(",", $cids).") and uid = $mid and is_default = 0";
    $res = mysql::query($sql);

    if(!$res) {
        return_json(0, "删除分类失败");
    }

    $sql = "delete from link where category_id in(".implode(",", $cids).") and uid = $mid";
    $res = mysql::query($sql);

    return_json(1, "删除分类成功");
}

// 交换
elseif($do == "exchange") {
    $cid1 = (int)P("cid1");
    $cid2 = (int)P("cid2");

    $sql = "select * from category where id in($cid1, $cid2) and uid = $mid";
    $res = mysql::query($sql);

    if(count($res) != 2) {
        return_json(0, "分类不存在");
    }

    foreach($res as $v) {
        if($v["id"] == $cid1) $sort1 = $v["sort"];
        elseif($v["id"] == $cid2) $sort2 = $v["sort"];
    }

    $sql = build_update_sql("category", array(
        "sort" => $sort2
    ), "id = $cid1");
    $res1 = mysql::query($sql);

    $sql = build_update_sql("category", array(
        "sort" => $sort1
    ), "id = $cid2");
    $res2 = mysql::query($sql);

    if($res1 && $res2) {
        return_json(1, "交换分类成功");
    } else {
        return_json(0, "交换分类失败");
    }

}

