#
# Finereason bakfile
# Version: 
# Time: 2011-06-01 12:48
# Finereason: http://www.finereason.com
# --------------------------------------------------------


DROP TABLE IF EXISTS `job_ad`;
CREATE TABLE `job_ad` (
  `ad_id` int(10) unsigned NOT NULL auto_increment,
  `ad_name` varchar(50) NOT NULL,
  `ad_url` varchar(100) NOT NULL,
  `ad_contactman` varchar(50) NOT NULL,
  `ad_tel` varchar(50) NOT NULL,
  `ad_width` varchar(20) NOT NULL,
  `ad_pic` varchar(100) NOT NULL,
  `ad_text` text NOT NULL,
  `ad_type` varchar(10) NOT NULL,
  `ad_act` tinyint(1) NOT NULL default '0',
  `ad_click` int(10) NOT NULL default '0',
  `ad_show` int(10) NOT NULL default '0',
  `ad_enddate` date NOT NULL default '0000-00-00',
  `ad_clicks` int(10) NOT NULL default '0',
  `ad_shows` int(10) NOT NULL default '0',
  `ad_stop` tinyint(1) NOT NULL default '0',
  `ad_other` varchar(50) NOT NULL,
  `ad_priceid` int(10) NOT NULL default '0',
  `ad_placeid` int(10) NOT NULL default '0',
  `ad_addtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `ad_showtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `ad_lose` tinyint(1) NOT NULL default '0',
  `ad_site` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`ad_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_admin`;
CREATE TABLE `job_admin` (
  `a_id` int(10) unsigned NOT NULL auto_increment,
  `a_user` varchar(20) NOT NULL,
  `a_pass` varchar(32) NOT NULL,
  `a_flag` varchar(3000) NOT NULL,
  `a_type` varchar(20) NOT NULL,
  `a_name` varchar(20) NOT NULL,
  `a_tel` varchar(20) NOT NULL,
  `a_qq` varchar(12) NOT NULL,
  `a_kf` tinyint(1) NOT NULL default '0',
  `a_mobile` varchar(15) NOT NULL,
  PRIMARY KEY  (`a_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_adplace`;
CREATE TABLE `job_adplace` (
  `adplace_id` int(10) unsigned NOT NULL auto_increment,
  `adplace_name` varchar(50) NOT NULL,
  PRIMARY KEY  (`adplace_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_adsplace`;
CREATE TABLE `job_adsplace` (
  `ap_id` int(10) unsigned NOT NULL auto_increment,
  `ap_name` varchar(50) default NULL,
  `ap_placeid` int(10) default NULL,
  `ap_priceid` int(10) default NULL,
  `ap_price` int(10) default NULL,
  `ap_unit` varchar(4) default NULL,
  `ap_row` varchar(50) default NULL,
  `ap_width` varchar(50) default NULL,
  PRIMARY KEY  (`ap_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_announce`;
CREATE TABLE `job_announce` (
  `a_id` int(10) unsigned NOT NULL auto_increment,
  `a_title` varchar(255) NOT NULL,
  `a_content` text NOT NULL,
  `a_author` varchar(50) NOT NULL,
  `a_dateandtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `a_isnew` tinyint(1) NOT NULL default '0',
  `a_channelid` smallint(4) NOT NULL default '0',
  `a_showtype` tinyint(1) NOT NULL default '0',
  `a_outtime` int(10) NOT NULL default '0',
  `a_site` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`a_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_channel`;
CREATE TABLE `job_channel` (
  `c_id` smallint(4) unsigned NOT NULL auto_increment,
  `c_name` varchar(20) NOT NULL,
  `c_shortname` varchar(20) NOT NULL,
  `c_itemunit` varchar(20) NOT NULL,
  `c_readme` varchar(255) NOT NULL,
  `c_keywords` varchar(255) NOT NULL,
  `c_description` varchar(255) NOT NULL,
  `c_order` smallint(4) NOT NULL default '0',
  `c_opentype` tinyint(1) NOT NULL default '0',
  `c_channeltype` tinyint(1) NOT NULL default '0',
  `c_linkurl` varchar(200) NOT NULL,
  `c_channeldir` varchar(50) NOT NULL,
  `c_moduletype` tinyint(2) NOT NULL default '0',
  `c_disabled` tinyint(1) NOT NULL default '0',
  `c_shownav` tinyint(1) NOT NULL default '0',
  `c_createhtml` tinyint(1) NOT NULL default '0',
  `c_fileext` tinyint(1) NOT NULL default '0',
  `c_listfiletype` tinyint(1) NOT NULL default '0',
  `c_structuretype` tinyint(1) NOT NULL default '0',
  `c_filenametype` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`c_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_comment`;
CREATE TABLE `job_comment` (
  `c_id` int(10) unsigned NOT NULL auto_increment,
  `c_username` varchar(50) NOT NULL,
  `c_content` mediumtext NOT NULL,
  `c_nid` int(10) NOT NULL default '0',
  `c_title` varchar(100) NOT NULL,
  `c_pass` tinyint(1) NOT NULL default '0',
  `c_addtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `c_ip` varchar(15) NOT NULL default '000.000.000.000',
  `c_type` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`c_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_common`;
CREATE TABLE `job_common` (
  `c_id` int(10) unsigned NOT NULL auto_increment,
  `c_title` varchar(50) NOT NULL,
  `c_content` text NOT NULL,
  `c_template` varchar(20) NOT NULL,
  `c_htmlname` varchar(50) NOT NULL,
  `c_isdefault` tinyint(1) NOT NULL default '0',
  `c_isorder` int(10) NOT NULL default '0',
  `c_dateandtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `c_isshow` tinyint(1) NOT NULL default '0',
  `c_type` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`c_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_consume`;
CREATE TABLE `job_consume` (
  `c_id` int(10) unsigned NOT NULL auto_increment,
  `c_member` varchar(50) NOT NULL,
  `c_content` mediumtext NOT NULL,
  `c_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `c_ip` varchar(15) NOT NULL,
  `c_type` varchar(10) NOT NULL,
  `c_operator` varchar(20) NOT NULL,
  `c_stype` TINYINT( 1 ) NOT NULL DEFAULT '0',
  PRIMARY KEY  (`c_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_count`;
CREATE TABLE `job_count` (
  `c_id` int(10) unsigned NOT NULL auto_increment,
  `c_year` smallint(4) NOT NULL default '0',
  `c_month` tinyint(2) NOT NULL default '0',
  `c_day` tinyint(2) NOT NULL default '0',
  `c_hour` tinyint(2) NOT NULL default '0',
  `c_time` datetime NOT NULL,
  `c_week` tinyint(1) NOT NULL,
  `c_ip` varchar(15) NOT NULL,
  `c_where` varchar(100) NOT NULL,
  `c_come` varchar(255) NOT NULL,
  `c_page` varchar(255) NOT NULL,
  `c_brower` varchar(100) NOT NULL,
  `c_os` varchar(100) NOT NULL,
  PRIMARY KEY  (`c_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_countnum`;
CREATE TABLE `job_countnum` (
  `n_today` int(10) NOT NULL default '0',
  `n_todayip` int(10) NOT NULL default '0',
  `n_yesterday` int(10) NOT NULL default '0',
  `n_yesterdayip` int(10) NOT NULL default '0',
  `n_total` int(10) NOT NULL default '0',
  `n_time` date NOT NULL default '0000-00-00'
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_dept`;
CREATE TABLE `job_dept` (
  `d_id` int(10) unsigned NOT NULL auto_increment,
  `d_name` varchar(50) default NULL,
  `d_principal` varchar(50) default NULL,
  `d_email` varchar(100) default NULL,
  `d_cmember` varchar(50) NOT NULL,
  PRIMARY KEY  (`d_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_ecoclass`;
CREATE TABLE `job_ecoclass` (
  `e_id` int(4) unsigned NOT NULL auto_increment,
  `e_name` varchar(50) NOT NULL,
  `e_enname` varchar(50) NOT NULL,
  PRIMARY KEY  (`e_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_edu`;
CREATE TABLE `job_edu` (
  `e_id` tinyint(2) NOT NULL auto_increment,
  `e_name` varchar(50) NOT NULL,
  `e_enname` varchar(50) NOT NULL,
  PRIMARY KEY  (`e_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_education`;
CREATE TABLE `job_education` (
  `e_id` int(10) unsigned NOT NULL auto_increment,
  `e_startyear` smallint(4) NOT NULL,
  `e_startmonth` tinyint(2) NOT NULL,
  `e_endyear` smallint(4) NOT NULL,
  `e_endmonth` tinyint(2) NOT NULL,
  `e_school` varchar(100) NOT NULL,
  `e_profession` varchar(50) NOT NULL,
  `e_edu` varchar(10) NOT NULL,
  `e_detail` mediumtext NOT NULL,
  `e_adddate` datetime NOT NULL,
  `e_pmember` varchar(50) NOT NULL,
  `e_rid` int(10) NOT NULL,
  `e_language` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`e_id`),
  KEY `e_profession` (`e_profession`),
  KEY `e_school` (`e_school`),
  KEY `e_rid` (`e_rid`),
  KEY `e_pmember` (`e_pmember`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_foreigndegree`;
CREATE TABLE `job_foreigndegree` (
  `f_id` tinyint(2) unsigned NOT NULL auto_increment,
  `f_name` varchar(20) NOT NULL,
  `f_enname` varchar(50) NOT NULL,
  PRIMARY KEY  (`f_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_foreignlanguage`;
CREATE TABLE `job_foreignlanguage` (
  `f_id` tinyint(2) unsigned NOT NULL auto_increment,
  `f_name` varchar(20) NOT NULL,
  `f_enname` varchar(50) NOT NULL,
  PRIMARY KEY  (`f_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_group`;
CREATE TABLE `job_group` (
  `g_id` tinyint(3) unsigned NOT NULL auto_increment,
  `g_name` varchar(20) NOT NULL,
  `g_typeid` tinyint(1) NOT NULL,
  `g_outlay` float NOT NULL default '0',
  `g_term` tinyint(3) NOT NULL default '0',
  `g_unit` varchar(2) NOT NULL,
  `g_images` varchar(50) NOT NULL,
  `g_limit` varchar(200) NOT NULL default '0,0,0,0,0,0,0,0,0,0,0,0,0,0',
  `g_integral` varchar(200) NOT NULL default '0,0,0,0,0,0,0,0,0,0,0,0,0,0',
  `g_isdefault` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`g_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_guestbook`;
CREATE TABLE `job_guestbook` (
  `g_id` int(10) unsigned NOT NULL auto_increment,
  `g_username` varchar(50) NOT NULL,
  `g_useremail` varchar(20) NOT NULL,
  `g_title` varchar(100) NOT NULL,
  `g_content` mediumtext NOT NULL,
  `g_addtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `g_pass` tinyint(1) NOT NULL default '0',
  `g_answer` tinyint(1) NOT NULL default '0',
  `g_email` tinyint(1) NOT NULL default '0',
  `g_ismember` tinyint(1) NOT NULL default '0',
  `g_type` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`g_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_help`;
CREATE TABLE `job_help` (
  `h_id` int(10) unsigned NOT NULL auto_increment,
  `h_title` varchar(50) NOT NULL,
  `h_content` text NOT NULL,
  `h_sortid` int(10) NOT NULL default '0',
  `h_addname` varchar(20) NOT NULL,
  `h_addtime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`h_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_helpsort`;
CREATE TABLE `job_helpsort` (
  `s_id` smallint(4) unsigned NOT NULL auto_increment,
  `s_name` varchar(50) NOT NULL,
  `s_order` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`s_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_hire`;
CREATE TABLE `job_hire` (
  `h_id` int(10) unsigned NOT NULL auto_increment,
  `h_place` varchar(150) NOT NULL,
  `h_number` mediumint(6) NOT NULL default '0',
  `h_sex` tinyint(1) NOT NULL default '0',
  `h_type` tinyint(1) NOT NULL default '0',
  `h_trade` varchar(50) NOT NULL,
  `h_position` varchar(255) NOT NULL,
  `h_dept` varchar(50) NOT NULL,
  `h_workadd` varchar(255) NOT NULL,
  `h_zhicheng` varchar(50) NOT NULL,
  `h_pay` int(10) NOT NULL default '0',
  `h_introduce` mediumtext NOT NULL,
  `h_usergroup` tinyint(1) NOT NULL default '0',
  `h_profession` varchar(255) NOT NULL,
  `h_edu` tinyint(2) NOT NULL default '0',
  `h_experience` int(10) NOT NULL default '0',
  `h_age1` tinyint(2) NOT NULL default '0',
  `h_age2` tinyint(2) NOT NULL default '0',
  `h_language1` varchar(50) NOT NULL,
  `h_level1` varchar(50) NOT NULL,
  `h_language2` varchar(50) NOT NULL,
  `h_level2` varchar(50) NOT NULL,
  `h_comname` varchar(100) NOT NULL,
  `h_address` varchar(150) NOT NULL,
  `h_post` varchar(50) NOT NULL,
  `h_contact` varchar(100) NOT NULL,
  `h_tel` varchar(100) NOT NULL,
  `h_telshowflag` tinyint(1) NOT NULL default '0',
  `h_fax` varchar(100) NOT NULL,
  `h_email` varchar(100) NOT NULL,
  `h_emailshowflag` tinyint(1) NOT NULL default '0',
  `h_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `h_enddate` date NOT NULL default '0000-00-00',
  `h_status` tinyint(1) default '0',
  `h_visitcount` int(10) default '0',
  `h_receiveresume` int(10) default '0',
  `h_sendinterview` int(10) default '0',
  `h_comid` int(10) NOT NULL default '0',
  `h_member` varchar(50) NOT NULL,
  `h_operator` varchar(20) NOT NULL,
  `h_comm` tinyint(1) NOT NULL default '0',
  `h_commstart` date NOT NULL default '0000-00-00',
  `h_commend` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`h_id`),
  KEY `h_comid` (`h_comid`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_hrzp`;
CREATE TABLE `job_hrzp` (
  `h_id` int(10) unsigned NOT NULL auto_increment,
  `h_cname` varchar(100) NOT NULL,
  `h_job` varchar(100) NOT NULL,
  `h_gangwei` varchar(255) NOT NULL,
  `h_cnum` smallint(4) NOT NULL,
  `h_jobtype` varchar(10) NOT NULL,
  `h_enddate` date NOT NULL,
  `h_workadd` varchar(100) NOT NULL,
  `h_comtype` varchar(20) NOT NULL,
  `h_requisition` text NOT NULL,
  `h_yearpay` smallint(4) NOT NULL,
  `h_welfare` text NOT NULL,
  `h_jobdesc` text NOT NULL,
  `h_duty` text NOT NULL,
  `h_address` varchar(100) NOT NULL,
  `h_contact` varchar(50) NOT NULL,
  `h_email` varchar(100) NOT NULL,
  `h_tel` varchar(100) NOT NULL,
  `h_fax` varchar(100) NOT NULL,
  `h_click` int(10) NOT NULL,
  `h_flag` tinyint(1) NOT NULL,
  `h_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`h_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_interview`;
CREATE TABLE `job_interview` (
  `i_id` int(10) unsigned NOT NULL auto_increment,
  `i_rid` int(10) NOT NULL default '0',
  `i_name` varchar(50) NOT NULL,
  `i_sex` tinyint(1) NOT NULL default '0',
  `i_birth` date NOT NULL default '0000-00-00',
  `i_edu` tinyint(2) NOT NULL default '0',
  `i_hid` int(10) NOT NULL default '0',
  `i_place` varchar(50) NOT NULL,
  `i_cmember` varchar(50) NOT NULL,
  `i_pmember` varchar(50) NOT NULL,
  `i_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`i_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_label`;
CREATE TABLE `job_label` (
  `l_id` smallint(5) unsigned NOT NULL auto_increment,
  `l_name` varchar(50) NOT NULL,
  `l_type` tinyint(1) NOT NULL default '0',
  `l_intro` varchar(50) NOT NULL,
  `l_content` mediumtext NOT NULL,
  `l_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `l_editdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `l_order` tinyint(3) NOT NULL default '0',
  PRIMARY KEY  (`l_id`),
  KEY `l_order` (`l_order`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_lang`;
CREATE TABLE `job_lang` (
  `l_id` int(10) unsigned NOT NULL auto_increment,
  `l_name` varchar(10) NOT NULL,
  `l_master` varchar(10) NOT NULL,
  `l_adddate` datetime NOT NULL,
  `l_pmember` varchar(50) NOT NULL,
  `l_rid` int(10) NOT NULL,
  `l_language` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`l_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_letter`;
CREATE TABLE `job_letter` (
  `l_id` int(10) unsigned NOT NULL auto_increment,
  `l_title` varchar(100) NOT NULL,
  `l_content` mediumtext NOT NULL,
  `l_member` varchar(50) NOT NULL,
  `l_adddate` datetime NOT NULL,
  PRIMARY KEY  (`l_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_level`;
CREATE TABLE `job_level` (
  `l_id` int(10) unsigned NOT NULL auto_increment,
  `l_name` varchar(100) NOT NULL,
  `l_integral` int(10) NOT NULL default '0',
  `l_images` varchar(20) NOT NULL,
  `l_num` int(10) NOT NULL default '0',
  PRIMARY KEY  (`l_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_links`;
CREATE TABLE `job_links` (
  `l_id` int(10) unsigned NOT NULL auto_increment,
  `l_name` varchar(255) NOT NULL,
  `l_url` varchar(255) NOT NULL,
  `l_sm` varchar(255) NOT NULL,
  `l_key` tinyint(1) NOT NULL default '0',
  `l_key1` tinyint(1) NOT NULL default '0',
  `l_tj` tinyint(1) NOT NULL default '0',
  `l_order` int(10) NOT NULL default '0',
  `l_site` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`l_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_mail`;
CREATE TABLE `job_mail` (
  `m_id` int(10) unsigned NOT NULL auto_increment,
  `m_title` varchar(50) NOT NULL,
  `m_content` mediumtext NOT NULL,
  `m_cycle` tinyint(2) NOT NULL default '0',
  `m_member` varchar(50) NOT NULL,
  `m_email` varchar(100) NOT NULL,
  `m_number` tinyint(2) NOT NULL default '0',
  `m_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `m_update` datetime NOT NULL default '0000-00-00 00:00:00',
  `m_senddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `m_type` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`m_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_mailtemp`;
CREATE TABLE `job_mailtemp` (
  `m_id` int(10) unsigned NOT NULL auto_increment,
  `m_tit` varchar(255) NOT NULL,
  `m_con` text NOT NULL,
  `m_info` varchar(100) NOT NULL,
  `m_sign` varchar(20) NOT NULL,
  `m_order` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`m_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_manage_log`;
CREATE TABLE `job_manage_log` (
  `l_id` int(10) unsigned NOT NULL auto_increment,
  `l_username` varchar(20) NOT NULL,
  `l_ip` varchar(20) NOT NULL,
  `l_dat` text NOT NULL,
  `l_datetime` datetime NOT NULL,
  `l_cs` tinyint(1) NOT NULL,
  PRIMARY KEY  (`l_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_marriage`;
CREATE TABLE `job_marriage` (
  `m_id` tinyint(2) unsigned NOT NULL auto_increment,
  `m_name` varchar(20) NOT NULL,
  `m_enname` varchar(50) NOT NULL,
  PRIMARY KEY  (`m_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_member`;
CREATE TABLE `job_member` (
  `m_id` int(10) unsigned NOT NULL auto_increment,
  `m_login` varchar(50) NOT NULL,
  `m_pwd` varchar(32) NOT NULL,
  `m_sendemail` tinyint(1) NOT NULL default '0',
  `m_question` varchar(50) NOT NULL,
  `m_answer` varchar(50) NOT NULL,
  `m_typeid` tinyint(1) NOT NULL default '0',
  `m_groupid` tinyint(2) NOT NULL default '0',
  `m_email` varchar(100) NOT NULL,
  `m_emailshowflag` tinyint(1) NOT NULL default '0',
  `m_name` varchar(200) NOT NULL,
  `m_sex` tinyint(1) NOT NULL default '0',
  `m_birth` date NOT NULL default '0000-00-00',
  `m_cardtype` tinyint(1) NOT NULL default '0',
  `m_idcard` varchar(20) NOT NULL,
  `m_marriage` varchar(10) NOT NULL,
  `m_polity` varchar(10) NOT NULL,
  `m_hukou` varchar(100) NOT NULL,
  `m_seat` varchar(100) NOT NULL,
  `m_edu` tinyint(2) NOT NULL,
  `m_address` varchar(200) NOT NULL,
  `m_post` varchar(6) NOT NULL,
  `m_contact` varchar(50) NOT NULL,
  `m_chat` varchar(20) NOT NULL,
  `m_tel` varchar(100) NOT NULL,
  `m_telshowflag` tinyint(1) NOT NULL default '0',
  `m_fax` varchar(50) NOT NULL,
  `m_url` varchar(100) NOT NULL,
  `m_regdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `m_logindate` datetime NOT NULL default '0000-00-00 00:00:00',
  `m_loginip` varchar(15) NOT NULL default '000.000.000.000',
  `m_loginnum` int(10) NOT NULL,
  `m_level` varchar(50) NOT NULL,
  `m_balance` int(10) NOT NULL default '0',
  `m_integral` int(10) NOT NULL default '0',
  `m_flag` tinyint(1) NOT NULL default '0',
  `m_startdate` date NOT NULL default '0000-00-00',
  `m_enddate` date NOT NULL default '0000-00-00',
  `m_resumenums` mediumint(6) NOT NULL default '0',
  `m_mysendnums` mediumint(6) NOT NULL default '0',
  `m_myinterviewnums` mediumint(6) NOT NULL default '0',
  `m_myfavoritenums` mediumint(6) NOT NULL default '0',
  `m_letternums` tinyint(2) NOT NULL default '0',
  `m_hirenums` mediumint(6) NOT NULL default '0',
  `m_interviewnums` mediumint(6) NOT NULL default '0',
  `m_expertnums` mediumint(6) NOT NULL default '0',
  `m_comm` tinyint(1) NOT NULL default '0',
  `m_commstart` date NOT NULL default '0000-00-00',
  `m_commend` date NOT NULL default '0000-00-00',
  `m_logo` varchar(50) NOT NULL,
  `m_logostatus` tinyint(1) NOT NULL default '0',
  `m_logoflag` tinyint(1) NOT NULL default '0',
  `m_logocomm` tinyint(1) NOT NULL default '0',
  `m_logostartdate` date NOT NULL default '0000-00-00',
  `m_logoenddate` date NOT NULL default '0000-00-00',
  `m_licence` varchar(100) NOT NULL,
  `m_trade` varchar(50) NOT NULL,
  `m_ecoclass` varchar(20) NOT NULL,
  `m_fund` mediumint(6) NOT NULL default '0',
  `m_workers` varchar(10) NOT NULL,
  `m_founddate` date NOT NULL default '0000-00-00',
  `m_introduce` mediumtext NOT NULL,
  `m_teachers` mediumtext NOT NULL,
  `m_achievement` mediumtext NOT NULL,
  `m_hits` int(10) NOT NULL default '0',
  `m_template` varchar(20) NOT NULL,
  `m_activedate` datetime NOT NULL default '0000-00-00 00:00:00',
  `m_mobile` varchar(20) NOT NULL,
  `m_mobileshowflag` tinyint(1) NOT NULL default '0',
  `m_smsnum` smallint(4) NOT NULL default '0',
  `m_hirenum` smallint(4) NOT NULL default '0',
  `m_myinterviewnum` smallint(4) NOT NULL default '0',
  `m_expertnum` smallint(4) NOT NULL default '0',
  `m_recyclenums` mediumint(6) NOT NULL default '0',
  `m_recyclenum` smallint(4) NOT NULL default '0',
  `m_contactnums` mediumint(6) NOT NULL default '0',
  `m_contactnum` smallint(4) NOT NULL default '0',
  `m_smsnums` mediumint(6) NOT NULL default '0',
  `m_mysendnum` smallint(4) NOT NULL default '0',
  `m_myfavoritenum` smallint(4) NOT NULL default '0',
  `m_ishire` smallint(4) NOT NULL default '0',
  `m_operator` varchar(20) NOT NULL,
  `m_map` varchar(50) NOT NULL,
  `m_confirm` tinyint(1) NOT NULL default '0',
  `m_inviteid` int(10) NOT NULL default '0',
  `m_site` smallint(4) NOT NULL default '0',
  `m_nameshow` TINYINT( 1 ) NOT NULL DEFAULT '0',
  `m_qzstate` VARCHAR( 255 ) NOT NULL,
  `m_openid` VARCHAR( 100 ) NOT NULL,
  PRIMARY KEY  (`m_id`),
  KEY `m_regdate` (`m_regdate`),
  KEY `m_enddate` (`m_enddate`),
  KEY `m_logindate` (`m_logindate`),
  KEY `m_login` (`m_login`),
  KEY `m_activedate` (`m_activedate`),
  KEY `m_startdate` (`m_startdate`),
  KEY `m_ishire` (`m_ishire`),
  KEY `m_logoflag` (`m_logoflag`),
  KEY `m_logostatus` (`m_logostatus`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_myexpert`;
CREATE TABLE `job_myexpert` (
  `m_id` int(10) unsigned NOT NULL auto_increment,
  `m_rid` int(10) NOT NULL default '0',
  `m_name` varchar(50) NOT NULL,
  `m_sex` tinyint(1) NOT NULL default '0',
  `m_birth` date NOT NULL default '0000-00-00',
  `m_edu` tinyint(2) NOT NULL,
  `m_cmember` varchar(50) NOT NULL,
  `m_pmember` varchar(50) NOT NULL,
  `m_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `m_down` tinyint(1) NOT NULL default '0',
  `m_downdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `m_exp` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`m_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_myfavorite`;
CREATE TABLE `job_myfavorite` (
  `f_id` int(10) unsigned NOT NULL auto_increment,
  `f_hid` int(10) NOT NULL,
  `f_comname` varchar(200) NOT NULL,
  `f_place` varchar(100) NOT NULL,
  `f_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `f_pmember` varchar(50) NOT NULL,
  `f_cmember` varchar(50) NOT NULL,
  PRIMARY KEY  (`f_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_myinterview`;
CREATE TABLE `job_myinterview` (
  `i_id` int(10) unsigned NOT NULL auto_increment,
  `i_hid` int(10) NOT NULL,
  `i_comname` varchar(200) NOT NULL,
  `i_place` varchar(100) NOT NULL,
  `i_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `i_pmember` varchar(50) NOT NULL,
  `i_cmember` varchar(50) NOT NULL,
  `i_read` tinyint(1) NOT NULL default '0',
  `i_title` varchar(100) NOT NULL,
  `i_content` mediumtext NOT NULL,
  PRIMARY KEY  (`i_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_myreceive`;
CREATE TABLE `job_myreceive` (
  `m_id` int(10) unsigned NOT NULL auto_increment,
  `m_rid` int(10) NOT NULL default '0',
  `m_name` varchar(50) NOT NULL,
  `m_sex` tinyint(1) NOT NULL default '0',
  `m_birth` date NOT NULL,
  `m_edu` tinyint(2) NOT NULL default '0',
  `m_hid` int(10) NOT NULL default '0',
  `m_place` varchar(50) NOT NULL,
  `m_cmember` varchar(50) NOT NULL,
  `m_pmember` varchar(50) NOT NULL,
  `m_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `m_read` tinyint(1) NOT NULL default '0',
  `m_content` mediumtext NOT NULL,
  `m_lang` tinyint(1) NOT NULL default '0',
  `m_reply` TINYINT( 1 ) NOT NULL DEFAULT '0',
  PRIMARY KEY  (`m_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_mysend`;
CREATE TABLE `job_mysend` (
  `s_id` int(10) unsigned NOT NULL auto_increment,
  `s_hid` int(10) NOT NULL,
  `s_comname` varchar(200) NOT NULL,
  `s_place` varchar(50) NOT NULL,
  `s_rid` int(10) NOT NULL,
  `s_resumename` varchar(50) NOT NULL,
  `s_lang` varchar(10) NOT NULL,
  `s_adddate` datetime NOT NULL,
  `s_interview` smallint(1) NOT NULL default '0',
  `s_favorite` tinyint(1) NOT NULL default '0',
  `s_response` tinyint(1) NOT NULL default '0',
  `s_deny` tinyint(1) NOT NULL default '0',
  `s_pmember` varchar(50) NOT NULL,
  `s_cmember` varchar(50) NOT NULL,
  PRIMARY KEY  (`s_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_nation`;
CREATE TABLE `job_nation` (
  `n_id` int(4) unsigned NOT NULL auto_increment,
  `n_name` varchar(50) NOT NULL,
  `n_enname` varchar(100) NOT NULL,
  PRIMARY KEY  (`n_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_news`;
CREATE TABLE `job_news` (
  `n_id` int(10) unsigned NOT NULL auto_increment,
  `n_title` varchar(100) NOT NULL,
  `n_content` mediumtext NOT NULL,
  `n_overview` varchar(255) NOT NULL,
  `n_sorttit` varchar(100) NOT NULL,
  `n_color` varchar(10) NOT NULL,
  `n_cid` smallint(4) NOT NULL,
  `n_sid` int(10) NOT NULL,
  `n_author` varchar(50) NOT NULL,
  `n_editor` varchar(50) NOT NULL,
  `n_from` varchar(100) NOT NULL,
  `n_pic` varchar(50) NOT NULL,
  `n_addtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `n_hits` int(10) NOT NULL default '0',
  `n_iscomm` tinyint(1) NOT NULL default '0',
  `n_ispic` tinyint(1) NOT NULL default '0',
  `n_ishome` tinyint(1) NOT NULL default '0',
  `n_keywords` varchar(255) NOT NULL,
  `n_description` varchar(255) NOT NULL,
  PRIMARY KEY  (`n_id`),
  KEY `n_addtime` (`n_addtime`),
  KEY `n_hits` (`n_hits`),
  KEY `n_sid` (`n_sid`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_newssort`;
CREATE TABLE `job_newssort` (
  `s_id` int(10) unsigned NOT NULL auto_increment,
  `s_name` varchar(50) NOT NULL,
  `s_cid` smallint(4) NOT NULL default '0',
  `s_addtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `s_order` int(10) NOT NULL default '0',
  `s_fid` int(10) NOT NULL default '0',
  PRIMARY KEY  (`s_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_orderservice`;
CREATE TABLE `job_orderservice` (
  `o_id` int(10) unsigned NOT NULL auto_increment,
  `o_groupid` tinyint(3) NOT NULL,
  `o_groupname` varchar(20) NOT NULL,
  `o_member` varchar(50) NOT NULL,
  `o_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `o_pactnum` varchar(20) NOT NULL,
  `o_result` tinyint(1) NOT NULL default '0',
  `o_dealdatetime` datetime NOT NULL,
  `o_content` varchar(255) NOT NULL,
  `o_revert` varchar(255) NOT NULL,
  PRIMARY KEY  (`o_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_payback`;
CREATE TABLE `job_payback` (
  `p_id` int(10) unsigned NOT NULL auto_increment,
  `p_mid` varchar(20) NOT NULL,
  `p_amount` varchar(10) NOT NULL,
  `p_type` varchar(10) NOT NULL,
  `p_pmode` varchar(20) NOT NULL,
  `p_oid` varchar(14) NOT NULL,
  `p_content` varchar(100) NOT NULL,
  `p_member` varchar(50) NOT NULL,
  `p_class` varchar(10) NOT NULL,
  `p_address` varchar(100) NOT NULL,
  `p_email` varchar(50) NOT NULL,
  `p_tel` varchar(50) NOT NULL,
  `p_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `p_userip` varchar(15) NOT NULL,
  `p_isucceed` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`p_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_payonline`;
CREATE TABLE `job_payonline` (
  `p_id` tinyint(2) unsigned NOT NULL auto_increment,
  `p_key` varchar(200) NOT NULL,
  `p_no` varchar(50) NOT NULL,
  `p_shid` varchar(50) NOT NULL,
  `p_flag` tinyint(2) NOT NULL default '0',
  `p_chk` tinyint(1) NOT NULL default '0',
  `p_name` varchar(20) NOT NULL,
  PRIMARY KEY  (`p_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_picture`;
CREATE TABLE `job_picture` (
  `p_id` int(10) unsigned NOT NULL auto_increment,
  `p_type` tinyint(2) NOT NULL,
  `p_filename` varchar(100) NOT NULL,
  `p_status` tinyint(1) NOT NULL default '0',
  `p_member` varchar(50) NOT NULL,
  `p_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `p_flag` tinyint(1) NOT NULL default '0',
  `p_name` varchar(20) NOT NULL,
  `p_info` varchar(255) NOT NULL,
  `p_hits` int(10) NOT NULL default '0',
  PRIMARY KEY  (`p_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_polity`;
CREATE TABLE `job_polity` (
  `p_id` smallint(4) unsigned NOT NULL auto_increment,
  `p_name` varchar(20) NOT NULL,
  `p_enname` varchar(50) NOT NULL,
  PRIMARY KEY  (`p_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_position`;
CREATE TABLE `job_position` (
  `p_id` smallint(4) unsigned NOT NULL auto_increment,
  `p_name` varchar(100) NOT NULL,
  `p_enname` varchar(100) NOT NULL,
  `p_fid` smallint(4) NOT NULL default '0',
  `p_order` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`p_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_prices`;
CREATE TABLE `job_prices` (
  `p_id` int(10) unsigned NOT NULL auto_increment,
  `p_name` varchar(50) NOT NULL,
  `p_value` smallint(4) NOT NULL default '0',
  `p_useday` smallint(4) NOT NULL default '0',
  `p_picture` varchar(100) NOT NULL,
  `p_type` tinyint(2) NOT NULL default '0',
  `p_content` varchar(255) NOT NULL,
  `p_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`p_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_profession`;
CREATE TABLE `job_profession` (
  `p_id` smallint(4) unsigned NOT NULL auto_increment,
  `p_name` varchar(100) NOT NULL,
  `p_enname` varchar(100) NOT NULL,
  `p_fid` smallint(4) NOT NULL default '0',
  `p_order` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`p_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_professor`;
CREATE TABLE `job_professor` (
  `p_id` int(10) unsigned NOT NULL auto_increment,
  `p_name` varchar(50) NOT NULL,
  `p_photo` varchar(100) NOT NULL,
  `p_sex` varchar(2) NOT NULL,
  `p_birth` date NOT NULL,
  `p_nation` varchar(20) NOT NULL,
  `p_province` varchar(50) NOT NULL,
  `p_edu` varchar(10) NOT NULL,
  `p_school` varchar(100) NOT NULL,
  `p_profession` varchar(100) NOT NULL,
  `p_jobtitle` varchar(50) NOT NULL,
  `p_comname` varchar(100) NOT NULL,
  `p_position` varchar(50) NOT NULL,
  `p_introduce` mediumtext NOT NULL,
  `p_fruit` mediumtext NOT NULL,
  `p_address` varchar(100) NOT NULL,
  `p_post` varchar(6) NOT NULL,
  `p_tel` varchar(100) NOT NULL,
  `p_fax` varchar(100) NOT NULL,
  `p_email` varchar(100) NOT NULL,
  `p_url` varchar(100) NOT NULL,
  `p_sid` int(10) NOT NULL default '0',
  `p_member` varchar(50) NOT NULL,
  `p_operator` varchar(20) NOT NULL,
  `p_adddate` datetime NOT NULL,
  `p_flag` tinyint(1) NOT NULL default '0',
  `p_commstart` date NOT NULL,
  `p_commend` date NOT NULL,
  `p_commflag` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`p_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_provinceandcity`;
CREATE TABLE `job_provinceandcity` (
  `p_id` smallint(4) unsigned NOT NULL auto_increment,
  `p_name` varchar(100) NOT NULL,
  `p_enname` varchar(100) NOT NULL,
  `p_fid` smallint(4) NOT NULL default '0',
  `p_order` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`p_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_rbrower`;
CREATE TABLE `job_rbrower` (
  `r_id` int(10) unsigned NOT NULL auto_increment,
  `r_bid` int(10) NOT NULL default '0',
  `r_bmember` varchar(50) NOT NULL,
  `r_member` varchar(50) NOT NULL,
  `r_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `r_name` varchar(200) NOT NULL,
  `r_type` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`r_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_recycle`;
CREATE TABLE `job_recycle` (
  `r_id` int(10) unsigned NOT NULL auto_increment,
  `r_rid` int(10) NOT NULL default '0',
  `r_name` varchar(50) NOT NULL,
  `r_sex` tinyint(1) NOT NULL default '0',
  `r_birth` date NOT NULL default '0000-00-00',
  `r_edu` tinyint(2) NOT NULL default '0',
  `r_hid` int(10) NOT NULL default '0',
  `r_place` varchar(50) NOT NULL,
  `r_cmember` varchar(50) NOT NULL,
  `r_pmember` varchar(50) NOT NULL,
  `r_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `r_content` mediumtext NOT NULL,
  PRIMARY KEY  (`r_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_reply`;
CREATE TABLE `job_reply` (
  `r_id` int(10) unsigned NOT NULL auto_increment,
  `r_username` varchar(50) NOT NULL,
  `r_content` mediumtext NOT NULL,
  `r_addtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `r_gid` int(10) NOT NULL default '0',
  PRIMARY KEY  (`r_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_resume`;
CREATE TABLE `job_resume` (
  `r_id` int(10) unsigned NOT NULL auto_increment,
  `r_usergroup` tinyint(1) NOT NULL default '0',
  `r_openness` tinyint(1) NOT NULL default '0',
  `r_title` varchar(50) NOT NULL,
  `r_chinese` tinyint(1) NOT NULL default '0',
  `r_english` tinyint(1) NOT NULL default '0',
  `r_cnstatus` tinyint(1) NOT NULL default '0',
  `r_enstatus` tinyint(1) NOT NULL default '0',
  `r_name` varchar(50) NOT NULL,
  `r_sex` tinyint(1) NOT NULL default '0',
  `r_birth` date NOT NULL,
  `r_cardtype` tinyint(1) NOT NULL default '0',
  `r_idcard` varchar(50) NOT NULL,
  `r_nation` varchar(20) NOT NULL,
  `r_polity` varchar(10) NOT NULL,
  `r_marriage` varchar(10) NOT NULL,
  `r_height` smallint(4) NOT NULL default '0',
  `r_weight` smallint(4) NOT NULL default '0',
  `r_hukou` varchar(100) NOT NULL,
  `r_seat` varchar(100) NOT NULL,
  `r_edu` tinyint(2) NOT NULL default '0',
  `r_tel` varchar(100) NOT NULL,
  `r_mobile` varchar(20) NOT NULL,
  `r_chat` varchar(20) NOT NULL,
  `r_email` varchar(100) NOT NULL,
  `r_url` varchar(100) NOT NULL,
  `r_address` varchar(200) NOT NULL,
  `r_post` varchar(6) NOT NULL,
  `r_sumup` varchar(50) NOT NULL,
  `r_appraise` mediumtext NOT NULL,
  `r_jobtype` tinyint(1) NOT NULL default '0',
  `r_trade` varchar(255) NOT NULL,
  `r_position` varchar(255) NOT NULL,
  `r_workadd` varchar(255) NOT NULL,
  `r_pay` mediumint(8) NOT NULL default '0',
  `r_stay` tinyint(1) NOT NULL default '0',
  `r_workdate` tinyint(2) NOT NULL default '0',
  `r_request` mediumtext NOT NULL,
  `r_personinfo` tinyint(1) NOT NULL default '0',
  `r_education` tinyint(1) NOT NULL default '0',
  `r_train` tinyint(1) NOT NULL default '0',
  `r_lang` tinyint(1) NOT NULL default '0',
  `r_work` tinyint(1) NOT NULL default '0',
  `r_careerwill` tinyint(1) NOT NULL default '0',
  `r_visitnum` int(10) NOT NULL default '0',
  `r_member` varchar(50) NOT NULL,
  `r_adddate` datetime NOT NULL,
  `r_flag` tinyint(1) NOT NULL default '0',
  `r_school` varchar(100) NOT NULL,
  `r_graduate` date NOT NULL,
  `r_zhicheng` varchar(50) NOT NULL,
  `r_template` varchar(100) NOT NULL,
  `r_ability` mediumtext NOT NULL,
  `r_mid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`r_id`),
  KEY `r_adddate` (`r_adddate`),
  KEY `r_member` (`r_member`),
  KEY `r_usergroup` (`r_usergroup`),
  KEY `r_seat` (`r_seat`),
  KEY `r_position` (`r_position`),
  KEY `r_jobtype` (`r_jobtype`),
  KEY `r_visitnum` (`r_visitnum`),
  KEY `r_mid` (`r_mid`),
  FULLTEXT KEY `r_title` (`r_title`,`r_name`,`r_appraise`,`r_request`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_sendresume`;
CREATE TABLE `job_sendresume` (
  `s_id` int(10) unsigned NOT NULL auto_increment,
  `s_comname` varchar(200) NOT NULL,
  `s_tel` varchar(100) NOT NULL,
  `s_email` varchar(100) NOT NULL,
  `s_place` varchar(100) NOT NULL,
  `s_adddate` datetime NOT NULL default '0000-00-00 00:00:00',
  `s_member` varchar(50) NOT NULL,
  `s_contact` varchar(50) NOT NULL,
  PRIMARY KEY  (`s_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_siteconfig`;
CREATE TABLE `job_siteconfig` (
  `s_id` smallint(4) unsigned NOT NULL auto_increment,
  `s_sitename` varchar(100) NOT NULL,
  `s_sitetitle` varchar(255) NOT NULL,
  `s_siteurl` varchar(255) NOT NULL,
  `s_icp` varchar(20) NOT NULL,
  `s_count` text NOT NULL,
  `s_webstate` varchar(255) NOT NULL,
  `s_key` varchar(255) NOT NULL,
  `s_logourl` varchar(255) NOT NULL,
  `s_template` varchar(20) NOT NULL,
  `s_skin` varchar(20) NOT NULL,
  `s_charset` varchar(5) NOT NULL,
  `s_master` varchar(20) NOT NULL,
  `s_email` varchar(100) NOT NULL,
  `s_copyright` text NOT NULL,
  `s_keywords` varchar(255) NOT NULL,
  `s_description` varchar(255) NOT NULL,
  `s_meta` text NOT NULL,
  `s_path` varchar(20) NOT NULL,
  `s_admindir` varchar(20) NOT NULL,
  `s_contact` varchar(20) NOT NULL,
  `s_address` varchar(100) NOT NULL,
  `s_phone` varchar(50) NOT NULL,
  `s_fax` varchar(50) NOT NULL,
  `s_regperson` varchar(255) NOT NULL,
  `s_regcompany` varchar(255) NOT NULL,
  `s_regschool` varchar(255) NOT NULL,
  `s_regtrain` varchar(255) NOT NULL,
  `s_regdisabled` varchar(255) NOT NULL,
  `s_mailobject` tinyint(1) NOT NULL default '0',
  `s_mailserver` varchar(50) NOT NULL,
  `s_mailport` smallint(4) NOT NULL default '0',
  `s_mailvali` tinyint(1) NOT NULL default '0',
  `s_mailadd` varchar(100) NOT NULL,
  `s_mailcrlf` tinyint(1) NOT NULL default '0',
  `s_username` varchar(50) NOT NULL,
  `s_password` varchar(50) NOT NULL,
  `s_gbenablevisitor` tinyint(1) NOT NULL default '0',
  `s_gbmanagerubbish` varchar(255) NOT NULL,
  `s_createhtml` tinyint(1) NOT NULL default '0',
  `s_htmlpath` varchar(10) NOT NULL,
  `s_createtime` tinyint(2) NOT NULL default '0',
  `s_defaultext` varchar(10) NOT NULL,
  `s_sitemap` tinyint(1) NOT NULL default '0',
  `s_sitemaptime` tinyint(3) NOT NULL default '0',
  `s_percontact` tinyint(1) NOT NULL default '0',
  `s_comcontact` tinyint(1) NOT NULL default '0',
  `s_seecontact` tinyint(1) NOT NULL default '0',
  `s_smssend` varchar(20) NOT NULL,
  `s_verifycode` varchar(20) NOT NULL,
  `s_cookiepath` varchar(50) NOT NULL,
  `s_cookiedomain` varchar(100) NOT NULL,
  `s_comment` tinyint(1) NOT NULL default '0',
  `s_commentcheck` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`s_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_sms`;
CREATE TABLE `job_sms` (
  `s_id` int(10) unsigned NOT NULL auto_increment,
  `s_memberlogin` varchar(50) NOT NULL,
  `s_tomobile` varchar(20) NOT NULL,
  `s_issuccess` tinyint(1) NOT NULL default '0',
  `s_sendtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `s_content` varchar(200) NOT NULL,
  `s_tomemberlogin` varchar(50) NOT NULL,
  PRIMARY KEY  (`s_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_trade`;
CREATE TABLE `job_trade` (
  `t_id` smallint(4) unsigned NOT NULL auto_increment,
  `t_name` varchar(100) NOT NULL,
  `t_enname` varchar(100) NOT NULL,
  `t_order` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`t_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_trainer`;
CREATE TABLE `job_trainer` (
  `t_id` int(10) unsigned NOT NULL auto_increment,
  `t_name` varchar(50) NOT NULL,
  `t_photo` varchar(100) NOT NULL,
  `t_sex` varchar(2) NOT NULL,
  `t_birth` date NOT NULL,
  `t_nation` varchar(20) NOT NULL,
  `t_province` varchar(100) NOT NULL,
  `t_edu` varchar(10) NOT NULL,
  `t_school` varchar(100) NOT NULL,
  `t_profession` varchar(100) NOT NULL,
  `t_jobtitle` varchar(50) NOT NULL,
  `t_comname` varchar(100) NOT NULL,
  `t_position` varchar(50) NOT NULL,
  `t_introduce` mediumtext NOT NULL,
  `t_fruit` mediumtext NOT NULL,
  `t_address` varchar(100) NOT NULL,
  `t_post` varchar(6) NOT NULL,
  `t_tel` varchar(100) NOT NULL,
  `t_fax` varchar(100) NOT NULL,
  `t_email` varchar(100) NOT NULL,
  `t_url` varchar(100) NOT NULL,
  `t_tid` int(10) NOT NULL default '0',
  `t_member` varchar(50) NOT NULL,
  `t_operator` varchar(20) NOT NULL,
  `t_adddate` datetime NOT NULL,
  `t_flag` tinyint(1) NOT NULL default '0',
  `t_commstart` date NOT NULL,
  `t_commend` date NOT NULL,
  `t_commflag` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`t_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_training`;
CREATE TABLE `job_training` (
  `t_id` int(10) unsigned NOT NULL auto_increment,
  `t_startyear` smallint(4) NOT NULL,
  `t_startmonth` tinyint(2) NOT NULL,
  `t_endyear` smallint(4) NOT NULL,
  `t_endmonth` tinyint(2) NOT NULL,
  `t_train` varchar(100) NOT NULL,
  `t_address` varchar(100) NOT NULL,
  `t_course` varchar(100) NOT NULL,
  `t_certificate` varchar(100) NOT NULL,
  `t_detail` mediumtext NOT NULL,
  `t_adddate` datetime NOT NULL,
  `t_pmember` varchar(50) NOT NULL,
  `t_rid` int(10) NOT NULL,
  `t_language` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`t_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_vote`;
CREATE TABLE `job_vote` (
  `v_id` int(10) unsigned NOT NULL auto_increment,
  `v_title` varchar(255) NOT NULL,
  `v_start` date NOT NULL default '0000-00-00',
  `v_end` date NOT NULL default '0000-00-00',
  `v_style` varchar(20) NOT NULL,
  `v_ing` tinyint(1) NOT NULL default '0',
  `v_color` varchar(10) NOT NULL,
  `v_count` int(10) NOT NULL default '0',
  `v_class` int(10) NOT NULL default '0',
  PRIMARY KEY  (`v_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_work`;
CREATE TABLE `job_work` (
  `w_id` int(10) unsigned NOT NULL auto_increment,
  `w_startyear` smallint(4) NOT NULL,
  `w_startmonth` tinyint(2) NOT NULL,
  `w_endyear` smallint(4) NOT NULL,
  `w_endmonth` tinyint(2) NOT NULL,
  `w_comname` varchar(100) NOT NULL,
  `w_ecoclass` varchar(20) NOT NULL,
  `w_trade` varchar(50) NOT NULL,
  `w_dept` varchar(50) NOT NULL,
  `w_position` varchar(50) NOT NULL,
  `w_place` varchar(100) NOT NULL,
  `w_introduce` mediumtext NOT NULL,
  `w_leftreason` varchar(100) NOT NULL,
  `w_adddate` datetime NOT NULL,
  `w_pmember` varchar(50) NOT NULL,
  `w_rid` int(10) NOT NULL,
  `w_language` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`w_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

DROP TABLE IF EXISTS `job_vhire`;
CREATE TABLE `job_vhire` (
  `v_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `v_place` varchar(50) NOT NULL,
  `v_number` smallint(4) NOT NULL DEFAULT '0',
  `v_comname` varchar(100) NOT NULL,
  `v_contact` varchar(20) NOT NULL,
  `v_tel` varchar(20) NOT NULL,
  `v_address` varchar(50) NOT NULL,
  `v_request` varchar(255) NOT NULL,
  `v_validity` smallint(4) NOT NULL DEFAULT '0',
  `v_adddate` datetime NOT NULL,
  `v_ip` varchar(15) NOT NULL,
  `v_flag` tinyint(4) NOT NULL DEFAULT '0',
  `v_top` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`v_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gb2312;

INSERT INTO job_ad VALUES('7','㲻ҹ','http://www.91rencai.com','ֿƼ','','970*60','/upfiles/webads/20100831152724_653.gif','㲻ҹ','image','0','0','0','0000-00-00','0','3090','0','','1','1','2010-08-31 15:27:46','2011-01-04 12:52:05','0','0');
INSERT INTO job_ad VALUES('10','ƷƹB2','http://www.91rencai.com','ƷƹB2','','317*60','/upfiles/webads/20100831160751_222.gif','ƷƹB2','image','0','0','0','0000-00-00','1','3078','0','','2','1','2010-08-31 16:08:04','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('9','ƷƹB1','http://www.91rencai.com','ƷƹB1','','317*60','/upfiles/webads/20100831160415_381.gif','ƷƹB1','image','0','0','0','0000-00-00','2','3084','0','','2','1','2010-08-31 16:04:31','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('8','ƷƹB','http://www.91rencai.com','ƷƹB','','317*60','/upfiles/webads/20100831160224_361.gif','ƷƹB','image','0','0','0','0000-00-00','5','3086','0','','2','1','2010-08-31 16:03:04','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('11','ƷƹB3','http://www.91rencai.com','ƷƹB3','','317*60','/upfiles/webads/20100831160902_792.gif','ƷƹB3','image','0','0','0','0000-00-00','1','3077','0','','2','1','2010-08-31 16:09:13','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('39','yjys','http://192.168.1.200','yjys','','155*60','/upfiles/webads/20101231141113_733.gif','','image','0','0','0','0000-00-00','0','209','0','','7','1','2010-12-31 14:11:23','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('6','עҳ','http://p.finereason.com','վ','','270*270','/upfiles/webads/20100830091419_167.gif','עҳ','image','0','0','0','0000-00-00','1','287','0','','5','3','2010-08-30 09:14:42','2011-01-04 11:41:16','0','0');
INSERT INTO job_ad VALUES('12','ƷƹB4','http://www.91rencai.com','ƷƹB4','','317*60','/upfiles/webads/20100831161706_781.gif','ƷƹB4','image','0','0','0','0000-00-00','0','3070','0','','2','1','2010-08-31 16:17:19','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('13','ƷƹB5','http://www.91rencai.com','ƷƹB5','','317*60','/upfiles/webads/20100831161740_140.gif','ƷƹB5','image','0','0','0','0000-00-00','0','3070','0','','2','1','2010-08-31 16:17:52','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('14','ƷƹB6','http://www.91rencai.com','ƷƹB6','','317*60','/upfiles/webads/20100831162012_245.gif','ƷƹB6','image','0','0','0','0000-00-00','0','3069','0','','2','1','2010-08-31 16:20:25','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('15','ƷƹB7','http://www.91rencai.com','ƷƹB7','','317*60','/upfiles/webads/20100831162046_248.gif','ƷƹB7','image','0','0','0','0000-00-00','0','3069','0','','2','1','2010-08-31 16:21:00','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('16','ƷƹB9','http://www.91rencai.com','ƷƹB9','','317*60','/upfiles/webads/20100831162226_748.gif','ƷƹB9','image','0','0','0','0000-00-00','0','3068','0','','2','1','2010-08-31 16:22:37','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('17','ƷƹB10','http://www.91rencai.com','ƷƹB10','','317*60','/upfiles/webads/20100831162305_994.gif','ƷƹB10','image','0','0','0','0000-00-00','0','3068','0','','2','1','2010-08-31 16:23:20','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('18','ƷƹC1','http://www.91rencai.com','ƷƹC1','','155*60','/upfiles/webads/20100831163146_955.gif','ƷƹC2','image','0','0','0','0000-00-00','0','3068','0','','6','1','2010-08-31 16:31:57','2011-01-04 12:52:05','0','0');
INSERT INTO job_ad VALUES('19','ƷƹC2','http://www.91rencai.com','ƷƹC3','','155*60','/upfiles/webads/20100831163223_496.gif','ƷƹC3','image','0','0','0','0000-00-00','0','3066','0','','6','1','2010-08-31 16:32:37','2011-01-04 12:52:05','0','0');
INSERT INTO job_ad VALUES('20','ƷƹC3','http://www.91rencai.com','ƷƹC3','','155*60','/upfiles/webads/20100831163424_388.gif','ƷƹC3','image','0','0','0','0000-00-00','0','3064','0','','6','1','2010-08-31 16:34:35','2011-01-04 12:52:05','0','0');
INSERT INTO job_ad VALUES('21','ƷƹC4','http://www.91rencai.com','ƷƹC4','','155*60','/upfiles/webads/20100831163612_866.gif','ƷƹC4','image','0','0','0','0000-00-00','0','3063','0','','6','1','2010-08-31 16:36:46','2011-01-04 12:52:05','0','0');
INSERT INTO job_ad VALUES('22','ƷƹC5','http://www.91rencai.com','ƷƹC5','','155*60','/upfiles/webads/20100831163935_632.gif','ƷƹC5','image','0','0','0','0000-00-00','0','3061','0','','6','1','2010-08-31 16:39:49','2011-01-04 12:52:05','0','0');
INSERT INTO job_ad VALUES('23','ƷƹC6','http://www.91rencai.com','ƷƹC6','','155*60','/upfiles/webads/20100831164050_400.gif','ƷƹC6','image','0','0','0','0000-00-00','0','3061','0','','6','1','2010-08-31 16:41:03','2011-01-04 12:52:05','0','0');
INSERT INTO job_ad VALUES('24','ƷƹC7','http://www.91rencai.com','ƷƹC7','','155*60','/upfiles/webads/20100831164440_846.gif','ƷƹC7','image','0','0','0','0000-00-00','0','3061','0','','6','1','2010-08-31 16:44:51','2011-01-04 12:52:05','0','0');
INSERT INTO job_ad VALUES('25','ƷƹC8','http://www.91rencai.com','ƷƹC8','','155*60','/upfiles/webads/20100831164639_869.gif','ƷƹC8','image','0','0','0','0000-00-00','0','3061','0','','6','1','2010-08-31 16:46:54','2011-01-04 12:52:05','0','0');
INSERT INTO job_ad VALUES('26','ƷƹC9','http://www.91rencai.com','ƷƹC9','','155*60','/upfiles/webads/20100831164849_730.gif','ƷƹC9','image','0','0','0','0000-00-00','0','3060','0','','6','1','2010-08-31 16:49:00','2011-01-04 12:52:05','0','0');
INSERT INTO job_ad VALUES('27','ƷƹC10','http://www.91rencai.com','ƷƹC10','','155*60','/upfiles/webads/20100831164938_557.gif','ƷƹC10','image','0','0','0','0000-00-00','0','3060','0','','6','1','2010-08-31 16:49:49','2011-01-04 12:52:05','0','0');
INSERT INTO job_ad VALUES('28','ƷƹD1','http://www.91rencai.com','ƷƹD1','','155*60','/upfiles/webads/20100831165936_290.gif','ƷƹD1','image','0','0','0','0000-00-00','0','3060','0','','7','1','2010-08-31 16:59:50','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('29','ƷƹD2','http://www.91rencai.com','ƷƹD2','','155*60','/upfiles/webads/20100831170058_769.gif','ƷƹD2','image','0','0','0','0000-00-00','1','3058','0','','7','1','2010-08-31 17:01:11','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('30','ƷƹD3','http://www.91rencai.com','ƷƹD3','','155*60','/upfiles/webads/20100831170146_710.gif','ƷƹD3','image','0','0','0','0000-00-00','1','3058','0','','7','1','2010-08-31 17:01:56','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('31','ƷƹD4','http://www.91rencai.com','ƷƹD4','','155*60','/upfiles/webads/20100831170728_473.gif','ƷƹD4','image','0','0','0','0000-00-00','0','3050','0','','7','1','2010-08-31 17:07:40','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('32','ƷƹD5','http://www.91rencai.com','ƷƹD5','','155*60','/upfiles/webads/20100831170811_707.gif','ƷƹD5','image','0','0','0','0000-00-00','0','3050','0','','7','1','2010-08-31 17:08:21','2011-01-04 12:52:07','0','0');
INSERT INTO job_ad VALUES('33','ƷƹF01','http://www.finereason.com','Ʒƹ','','318*60','/upfiles/webads/20101011035201_883.gif','ƷƹF01','image','0','0','0','0000-00-00','1','1678','0','','8','1','2010-10-11 03:52:31','2011-01-04 12:52:09','0','0');
INSERT INTO job_ad VALUES('34','ƷƹF02','http://www.finereason.com','Ʒƹ','','318*60','/upfiles/webads/20101011035304_963.gif','ƷƹF02','image','0','0','0','0000-00-00','0','1678','0','','8','1','2010-10-11 03:53:25','2011-01-04 12:52:09','0','0');
INSERT INTO job_ad VALUES('35','s','http://p.finereason.com','s','','290*117','/upfiles/webads/20101011174010_252.gif','s','image','0','0','0','0000-00-00','0','1624','0','','9','1','2010-10-11 17:40:26','2011-01-04 12:52:09','0','0');
INSERT INTO job_ad VALUES('40','yjys','http://192.168.1.200','yjys','','700*60','/upfiles/webads/20101231155015_189.gif','','image','0','0','0','0000-00-00','0','896','0','','4','1','2010-12-31 15:50:28','2011-01-04 13:05:53','0','0');
INSERT INTO job_ad VALUES('43','','http://192.168.1.200','','','100*100','/upfiles/webads/20110109184533_122.gif','','float','0','0','0','0000-00-00','0','1011','0','','11','1','2011-01-09 18:45:43','2011-03-13 22:19:00','0','0');
INSERT INTO job_ad VALUES('44','ɶǷ ','','ڴ','','100*100','/upfiles/webads/20110109190141_888.gif','','float','0','0','0','0000-00-00','3','1001','0','','11','1','2011-01-09 19:01:48','2011-03-13 22:19:00','0','0');
INSERT INTO job_ad VALUES('46','yjys','http://192.168.1.200','yjys','','700*60','/upfiles/webads/20101231155015_189.gif','','image','0','0','0','0000-00-00','0','1524','0','','4','1','2011-03-01 13:29:12','2011-03-11 11:25:27','0','0');
INSERT INTO job_ad VALUES('41','Ѷҳ','http://192.168.1.200/admin/index.php','Ե','','260*200','/upfiles/webads/20110305142018_262.jpg','Ѷҳ','image','0','0','0','0000-00-00','0','55','0','','12','4','2011-03-05 14:13:34','2011-03-11 17:09:52','0','0');
INSERT INTO job_ad VALUES('42','΢Ƹ','http://192.168.1.200/admin/index.php','Ե','','290*148','/upfiles/webads/20110810233925_715.gif','΢Ƹҳ','image','0','0','0','0000-00-00','0','55','0','','13','1','2011-03-05 14:13:34','2011-03-11 17:09:52','0','0');

INSERT INTO job_adplace VALUES('1','վҳ');
INSERT INTO job_adplace VALUES('2','ҵƸ');
INSERT INTO job_adplace VALUES('3','Աע');
INSERT INTO job_adplace VALUES('4','Ѷ');

INSERT INTO job_adsplace VALUES('1','ƷƹA','1','1','1000','','1*1','970*60');
INSERT INTO job_adsplace VALUES('2','ƷƹB','1','2','1000','','6*2','318*60');
INSERT INTO job_adsplace VALUES('3','ƷƹE','2','5','1000','','3*9','100*100');
INSERT INTO job_adsplace VALUES('4','TOPA','1','3','1000','','1*1','700*60');
INSERT INTO job_adsplace VALUES('5','עA','1','4','1000','','1*1','260*260');
INSERT INTO job_adsplace VALUES('6','ƷƹC','1','6','1000','','6*2','155*60');
INSERT INTO job_adsplace VALUES('7','ƷƹD','1','7','1000','','3*6','155*60');
INSERT INTO job_adsplace VALUES('8','ƷƹF','1','8','1000','','1*2','330*60');
INSERT INTO job_adsplace VALUES('9','ƷƹG','1','9','1000','','1*1','290*117');
INSERT INTO job_adsplace VALUES('10','Ư','1','10','1000','','1*1','80*80');
INSERT INTO job_adsplace VALUES('11','','1','11','1000','','2*2','80*80');
INSERT INTO job_adsplace VALUES('12','ѶA','4','12','1000','','1*1','260*200');
INSERT INTO job_adsplace VALUES('13','΢Ƹ', '1', '13', '1000', '', '2*1', '290*148');

INSERT INTO job_channel VALUES('1','ְ','','','ְ','ְ','ְ','0','0','0','','person','1','0','1','1','0','0','0','0');
INSERT INTO job_channel VALUES('2','ҵƸ','ְλ','ְλ','ҵƸ','ҵƸ','ҵƸ','1','0','0','','company','2','0','1','1','0','0','0','0');
INSERT INTO job_channel VALUES('4','ͷ','ͷ','ͷ','ͷ','ͷ','ͷ','3','0','0','','hr','4','0','1','0','0','0','0','0');
INSERT INTO job_channel VALUES('6','Ѷ','','','Ѷ','Ѷ','Ѷ','6','0','0','','article','10','0','1','1','0','0','2','0');
INSERT INTO job_channel VALUES('7','߼˲','˲','˲','߼˲','߼˲','߼˲','7','0','0','','besthr','1','0','1','1','0','0','0','0');
INSERT INTO job_channel VALUES('8','ְ˲','˲','˲','ְ˲','ְ˲','ְ˲','8','0','0','','sideline','1','0','1','1','0','0','0','0');
INSERT INTO job_channel VALUES('9','','','','','','','9','0','0','','help','14','0','1','1','0','0','0','0');
INSERT INTO job_channel VALUES('10','Է','','','Է','Է','Է','10','0','0','','guestbook','6','0','1','1','0','0','0','0');
INSERT INTO job_channel VALUES('11','΢Ƹ','','','΢Ƹ,һ仰Ƹ','','','13','0','2','/vhire/','','0','0','1','0','0','0','0','0');

INSERT INTO job_common VALUES('1','','<div class=\"main_con\"><span style=\"font-family: Verdana;\">\r\n<p>ϺֿƼչ޹˾2006꣬ҵʼ2004꣨ǰΪԵƹңһӪۼҵĸ¼ҵӵлƷ&ldquo;Ե&reg;&rdquo;&ldquo;FineReason&reg;&rdquo;˾վfinereason.comͼ̳(bbs.finereason.com)ĿǰڼӰķվ̳</p>\r\n<p>˾ӵһƷƺͿŶӣзḻӦƿ飬˲Ƹվϵͳ򣬾ڴԿһ״㷨ݽṹƷȫԷȼʹòƷȶԡŻЧʡȫȼܿɲٿԺȨԵȷ涼ӹͬƷȵλ˾ʼרעзļ֪ʶȨƷҪƷԵ&reg;˲ϵвƷǵǰԼ۱ȡܻӭHRCMS͵ϵͳĿǰгվӦùģӵǧҵû漰ҵнýȸҵӵйڽ30%гݶռҵһϯλ</p>\r\n<p>˾&ldquo;ķ񡡳Ÿ&rdquo;ΪΪûṩվƸƽ̨ѯѵʵʩ񡣹˾ӷΪҵӿͻΪҵ֮ԷͻΪҵּŬˮƽΪͻԼɱֵӮ˹û֧֡˾ӵһרҵԱҵѯʺĿרң˹ģĲƷзѯۺͷϵȽĿ֪ʶģʽΪͻṩʵĲƷͷ</p>\r\n</span></div>','about','aboutus','1','0','2010-12-27 14:30:40','1','0');
INSERT INTO job_common VALUES('2','','<p><span class=\"l_14\">1. Ľ</span><br />ƵûָȫͬעδעʹüԵ˲ķû<br /><span class=\"l_14\">2. ı޸</span><br />Ե˲ȨʱԷ޸ģһı䶯Ե˲ҳʾ޸ĵݣûʹüԵ˲ʱӦܼԵ˲ʱṩصĹ˵Ҵ˹˵ɱһ֡ûͬ޸ģȡѾõûΪûѾܷ޸ġ<br /><span class=\"l_14\">3. ˵</span><br />1 Ե˲ԼĲϵͳͨʻûṩḻԴϢߡ̳Իݵȣ¼Ʊ񣩡ȷ涨ǿǿĿǰκ¹ܣ²Ʒñ<br />2 Ե˲񲻳еκΣûʹóеաԵ˲֤һûʹҪҲ֤񲻻жϣԷļʱԡȫԡ׼ȷҲ<br />3 Ϊʹñû룺<br />a䱸ʻ豸ݻȡװã<br />b֧˷йصķá<br />4ûܱͬ⣺<br />a. ṩʵ׼ȷµĸϣ<br />b. ϸעϣԷ4.aҪ<br />ûṩκδ󡢲ʵʱϣΪԵ˲ȷ֪߼Ե˲кɻǰΪ󡢲ʵʱԵ˲Ȩֹͣûʺţܾڻʹñȫһ֡<br /><span class=\"l_14\">4. ûӦ·ɼ棺</span><br />ûͬءл񹲺͹عܷл񹲺͹Ϣϵͳȫйؼ涨ķɺͷ桢ʵʩ취κ£Ե˲ΪûΪΥɡ棬Ե˲κʱ򣬲ֹ֪ͨûṩ<br />ûӦ˽ʻ޹ԣӦرעصйصķɺͷ档<br /><span class=\"l_14\">5. û˽Ȩƶ</span><br />ûעԵ˲ķʱûṩظϢԵ˲ռϢĿΪûṩܶĸ˻ϷԼΪṩһ;ӴʺϵûҿԷ;Եݺ͹档<br />£ڣ£Ե˲ȨʹûĸϢ<br />1ڽд齱ʱԵ˲ܻ̹ûĸϢ<br />2Ե˲ԽûϢƥ䡣<br />3Ե˲ͨ͸¶ϼûͳݣδĺ顢̼ԼΪϷĿĶԵ˲ķ<br />5Ե˲ȷŻ֤κθϢİȫԣûԼеաûɱڷʵĸϢʱûпܻյδûͬϢԵ˲ĺͿͨԵ˲ʵĵվͷͨ齱Ȼ֪ûϢжռȻԵ˲ûκεΪκΡ<br /><span class=\"l_14\">6. ûʺšͰȫ</span><br />ûһעɹΪԵ˲ĺϷûõһʺšû֤ʺŵİȫûøʺеһлȫΣκʧ𺦣Ե˲޷ҲκΡ<br />ûʺ⵽δȨʹûκΰȫ⣬û֪ͨԵ˲ûÿ߽ӦʺʹãûܵòԵ˲İȫ<br /><span class=\"l_14\">7. ûϢĴ洢</span><br />Ե˲ûϢɾ򴢴ʧܸ𡣼Ե˲ȨжûΪǷϼԵ˲涨ȨԵ˲ΪûΥ˷Ĺ涨Ե˲жṩȨ<br /><span class=\"l_14\">8. ֹûΪ</span><br />1 ء͵ʼκηǷквȡɧšֺˡס̰ࡢֺ˽ӻ˲İѶϡ֡֡ƬͼΡϢϣ¼ݣ<br />2 κηʽΣδˡ<br />3 ðκ˻αʵķʽѳƻʹΪκ˻κλйء<br />4 αʽٿʶϣʹΪΪԵ˲͡<br />5 Ȩ͵ݣڲϡϣء͵ʼʽ͡<br />6 ַκ˵ר̱ꡢȨҵܻרȨ֮ݼء͵ʼʽ͡<br />7 溯ϡ\"ʼ\"ȣء͵ʼʽ͡ǰĿʹõר⡣<br />8 йظšƻκμӲͨѶ豸ܵ롢ͳ֮ϣء͵ʼʽ͡<br />9 Żƻ뱾ķ磬رʹ֮涨<br />10 ǹΥκصйɡ桢¡зЧĹ淶<br />11 ٻʽɧˡ<br />ûԾɱء͵ʼ͵ݸȫζھɱ͵ݣԵ˲֤ǰݵȷԡԻƷʡûڽܱʱпܻӴ˲졢ʵݡκ£Ե˲κݸ𣬰κݷκδ©Լκʧ𺦡Ե˲ȨоܾɾɱṩκݡûʹݣӦгеա<br />Ե˲Ȩ£ݽб¶<br />1 ɳ涨<br />2 涨<br />3 ֺĵȨţ<br />4 ΪԵ˲ʹ߼ṫڵȨƲȫ<br />5 Ե˲ΪбҪ<br /><span class=\"l_14\">9. ûڼԵ˲Ĺʹ򷢲ݣ</span><br />1\"ʹ\"ָһ㹫ڿʹõ<br />2ûڱ񹫿ʹ򷢲ݣΪûȨԵ˲ʹȨǶʹȨԵ˲ȨΪչʾɢƹǰ֮Ŀģݽиơ޸ġ档ʹȨûڱɾ<br />3ûκεҪκ𺦻ʧûеȫΡ<br /><span class=\"b_12\">10 ûöԱиơۻҵ;</span><br /><span class=\"b_12\">11 Ե˲Ȩ涨޸ʹñһʩԵ˲δܴɾݻѶϢԵ˲κΡûʱδʹõʺţԵ˲ȨԹرա</span><br /><span class=\"l_14\">12 ̵ҵ</span><br />ûɱ̽ͨѶϵҵȫû֮ΪԵ˲ûκιϵǰ׻ǰ򱾷֮κ𺦻ʧԵ˲еκΡԵ˲ûԹ漰̽顣<br /><span class=\"l_14\">13 </span><br />ܻṩʻվԴӡǰվԴǷãԵ˲赣ʹûվԴʧ𺦣Ե˲ҲκΡ<br /><span class=\"l_14\">14 Ե˲֪ʶȨȨ</span><br />1Ե˲Ա񼰱ʹõ֪ʶȨɱӦȨ<br />2ɱ͵ѶݣܵȨ̱귨רɵıδԵ˲ʾȨɣûý޸ġ⡢ɢƷ<br />3ûԱʹõзרʹȨԼûκεơ޸ġۻƷ<br />4 Ե˲Ե˲ͼԼԵ˲ͼƷƣκ˲ʹáƻ;<br /><span class=\"l_14\">15 </span><br />1 Ե˲κΰɻӡػκйرõκݡϢ棬֤ȷԻɿԣҶûϵĹ桢չʾȡõκβƷϢϣԵ˲֤Ρûиʹñķա<br />2 Ե˲Ȩ񣬸ƻκβ֮κ©<br />3 Ե˲֤ڣ<br />ʺûʹҪbܸţʱȫɿ򲻳ִcûɱȡõκβƷϷû<br />4 ûʹþɱصĻȡõκϣиʹöûϵͳ𻵻ʧûӦȫΣ<br />5 ԭɵҵʧλʧԵ˲еκֱӡӡͷԵ⳥aʹû޷ʹãbɱȡõκβƷϻcû⵽δȨʹû޸ģd뱾صˡ<br />6 û·ʱжʹüԵ˲ļĿ¼üĿ¼ܻû뵽ΪйԻʵվԵ˲û鿴Ŀ¼վݣˣȷԡϷԡԲκΡ<br /><span class=\"b_12\">16 ⳥ûɱݡ뱾ߡΥֺ˵κȨκεȨţûͬ⳥Ե˲ֹ˾˾˻鼰Աʹ𺦡</span><br /><span class=\"l_14\">17 ޸ĺֹ</span><br />Ե˲Ȩκʱʱõ޸Ļֹ񣨻κһ֣Ƿ֪ͨԵ˲Ա޸Ļֹûκε˲еκΡԵ˲Ȩκɣֹûʺšʹñ񣬻ɾתû洢ڱݣԵ˲ȡΪ֪ͨҶûκε˲еκΡ<br /><span class=\"l_14\">18 ֪ͨ</span><br />Ե˲û֪ͨõʼҳ湫򳣹żʽ޸ĻʱԵ˲ʽ֪ͨ<br /><span class=\"b_12\">19 淶ûʹñ񣬽ȡûǰԵ˲ǩκЭ顣ͼԵ˲Э鹹Э顣</span><br /><span class=\"l_14\">20 ɵú͹Ͻ</span><br />ЧСͼĽл񹲺͹ɣٲòþվֵġл񹲺͹зִ²ЧӰֵЧ</p>','about','service','1','0','2010-12-27 14:33:41','1','0');
INSERT INTO job_common VALUES('3','','<p>ҪʺʹüԵ˲վ벻޸ĵȫܱЭͼԵ˲վʱǵͨ棬йػά/վطɡ涨һʡʹ˼Ե˲վʾͬⲢиõͨ档 <br /><span class=\"l_14\">վϵϢ</span><br />վϹڼԵ˲վԱǵĲƷڹ˾ơϵ˼ϢƷ˵ͼƬѶȣϢɻԱṩԱӦṩκϢеȫΡԵ˲վԴ˵Ϣ׼ȷԡԡϷԻʵԾеκΡ⣬Ե˲վκʹûṩվϢҵղеκΡ</p>\r\n<p>δϷȨ˵ɣκϽڱվչʾƷͼƬκδȨڱվʹøͼƬΥʷ̱귨˽ȨͨѶͨŵȷɷ档 ߿رվʾϣЩֻڸѧϰоʹãκҵ;Ƿʾд˵϶ܵȨķɱ</p>\r\n<p>ûлüԵ˲վԵİȨȷͬ£÷ַ޸ġɢʹáٴݻʹñվκιҵ; <br /><span class=\"l_14\"></span><br />Ե˲վ˾ڴر˲еκηΣ <br />һԵ˲վڴʹվ뱾վصκݡվվ㡢ݾֱӡӡԼı֤ <br /> κԭ£ԭ򣩣κͨʹñվϵϢɱվӵϢ뱾վӵվϢµʧ𺦣ֱӡӡرԵʧ𺦣֮ʧϵͳ֮𻵻ݶʧȺξʹгеΣ</p>\r\n<p>ʹ߶ԱվʹüͬеվȫգڼԵ˲վԵ˲վӪ̻Ե˲վ˾δ뽨衢չվṩݣʹڱվȡµκֱӡصġԵġӵĻǮϵʧеκΡ</p>\r\n<p><span class=\"l_14\">վʹ </span><br />ҪڼĹٻ׼ȷļϣҪǼϣ֪ͨҵݡ <br />κһλʹ߾Ե˲ԱȷΥվʹùĳһ涨ǽֹͣԸʹߵķ <br />Ե˲?ڲ£ṩۺԵϡûбͬ£Ե˲ַʼ͵绰</p>','about','enactment','1','0','2010-12-27 14:34:52','1','0');
INSERT INTO job_common VALUES('4','˽','<p>û˽ȨǼԵ˲Ļԭ¼ǵûʹüԵ˲ṩĸַʱԵ˲˽ԡ²ԿܻΪԵ˲Ϊûṩ಻ͬķĶйһ䶯ҪҳϽ˵Чͬⱻ޸ݣûȡѻõûΪ˽Եı䶯ʽûڲġ</p>\r\n<p><span class=\"b_12\">Ե˲ռԱĸϢ</span><br />Ե˲ҪռûڼԵ˲עΪԱʱύĸϢͨЩעϢԻԱۺͳƷͳƷǵĻԱз࣬磺ҵҵȣԱԵΪǵĻԱṩ¸ЧķǽͨԱṩĵĵʼַԱϵṩϷ񡣶ԻԱ˽⣬ڼԵ˲ΪԱṩõķ</p>\r\n<p><span class=\"b_12\">Ե˲ռĸϢݡ</span><br />Ե˲Ա֮䡢ԱԱ֮ϢݵȻҪռԱʼַԱӦṩع˾Ϣ˾ơַ绰ʹ롢ַ˾ҵԼԱȡԱͨڼԵ˲עĵ¼¼Ե˲ʱάϢ</p>\r\n<p><span class=\"b_12\">Ե˲ռйûϢ</span><br />ϻԱעϢ⣬ǻռɹԵ˲ҵοʹõϢⲻǶԸʶõϢгǵķ⣬ҲǷֹԵ˲ܵ⹥ıҪʩϢ\"ûʼ¼\"бҪʹ\"Cookies\"\"IP ַ\"ʶʶûڼԵ˲עᡢ¼ԻƾҪû\"Cookies\"</p>\r\n<p><span class=\"b_12\">ԱĸϢᴦ</span><br />Ե˲ĻԱϢڰȫĲڹϵͳСԵ˲ػԱĸϢ˽<br />ų±<br />1ӦķɻҪԵ˲ṩûĸϣ<br />2ҪϼԵ˲Ȩ£<br />3ִмԵ˲ķҪ<br />4άԵ˲ûṫڵҪ¡  <br />Ե˲עԱϢĻϻҵͳƷĹΪ˸õ˽ͻΪԱṩõķ񡣼Ե˲ͳƷṩշѿͻҵȨ</p>\r\n<p><span class=\"b_12\">Ϣ</span><br />û˽Ļԭ£ǲԱĸϢǵõԱȨĳЩҪʱǽϢṩǵҵΪг;⣬Ե˲ڷҪ»бҪĹάȹʱṩػԱϢ</p>\r\n<p><span class=\"b_12\">е</span><br />ûһڼԵ˲עɹǽϻԱĸϢڼԵ˲ϵͳеİȫй¶Ե˲е紫䲻ɱ100İȫԶķգҲԴκ͵ĵ</p>\r\n<p><span class=\"b_12\">ϸϢİȫ</span><br />ûڼԵ˲עΪԱõԱʹõĵ¼롣Աʱͨ¼¼Ե˲ЩϢ޸ġǽԱҪй©¼ˣԱϸϢİȫ <br />ԱڼԵ˲ύĹҵ;Ϣû</p>\r\n<p><span class=\"b_14\">ע⣺</span><span class=\"b_12\">ԱӦڹ򹫲ظϢ</span></p>','about','secret','1','0','2010-12-27 14:35:33','1','0');
INSERT INTO job_common VALUES('5','','<p><strong><span class=\"l_14\">滥 </span></strong><br />еĹԴ磺λѶţҵ綯̬ȣǻںԴͬʱﵽõЧ ԴЭ <br /><strong></strong></p>\r\n<p><strong><span class=\"l_14\">淢 </span></strong><br />&ldquo;Ҫ˲&rdquo; Ŀͻṩ񣬹շѱ׼μ Դշѱ׼</p>\r\n<p><span class=\"b_12\"><strong>ԴЭ </strong></span></p>\r\n<p><span class=\"b_12\"><strong></strong></span><br />׷ϺֿƼչ޹˾Ե˲ <br />ҷ</p>\r\n<p>Ϊƶйҵٽ˫ҵչõΪҵû񣬼˫ƽȻͬչƻԭ򣬼׷ȨվԵ˲ϺֿƼչ޹˾<a href=\"http://www.finereason.com\">http://www.finereason.com</a>ҷȨվ<span style=\"text-decoration: underline;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span>ѺЭ̣ںϴһ£Ϊ飬׷Э涨ķʽҷṩ˲ְҵϢҷƵ裬ֱ֤˫Ȩ档־˫ľ˼˫ȨЭ飺 <br />һݡ <br />1. ׷վ&ldquo;Ե˲&rdquo; ҷȨվ&ldquo;<span style=\"text-decoration: underline;\"></span>&rdquo;кڼ׷ҳ &ldquo;<span style=\"text-decoration: underline;\"></span>&rdquo;ҷй滥ߴΪ<span style=\"text-decoration: underline;\"></span>ʱΪ<span style=\"text-decoration: underline;\"></span><span style=\"text-decoration: underline;\"></span>ֵΪ<span style=\"text-decoration: underline;\"></span><br />2. ƽЭл涼Ϊѵĺ<br />3. ͼLOGO˫ƣȨС</p>\r\n<p>ڶҷְ𡡡 <br />1 ҷվ\"<span style=\"text-decoration: underline;\"></span>\"Ϊ׷\"Ե˲\"ӹߴΪ<span style=\"text-decoration: underline;\"></span>ʱΪ<span style=\"text-decoration: underline;\"></span><span style=\"text-decoration: underline;\"></span>ֵΪ<span style=\"text-decoration: underline;\"></span>üԵ˲ṩ·<br />2 ҳҳüҳģ</p>\r\n<p>ҵ<br />1. ˫ӦͨӴ֪ͨйضԷҵϸܣδԷͬ⣬¶  <br />2. Э涨֮δԷͬ⣬ʹáƶԷ̱ꡢ־ҵϢϡ</p>\r\n<p><br />1.˫֮ΪսԺϵ<br />2. ˫ϢԴԱ֤վϢԴʵԡ׼ȷʱЧԡ<br />3. ˫վƵƹͬй㡢ܺ<br />4. ˫͸ԵľӪṩķݳеΣͰȨ<br />5. վ»Ķԭλòٴڣ˫뽫µӰڷλõ֤ԭЧ൱λá<br />6.Э˫ȿԷԼ<br />7. ˫ĺϵǻݵģṩΪ໥ѡ</p>\r\n<p>Эִޡ <br />ЭЧΪҼ꣬ԡ ꡡ¡ ꡡ¡ΪЭ̶ִޡ</p>\r\n<p>Эֹ <br />Эκԭֹ <br />1. Э޽ <br />2. ˫Эֹͬͬκһֹ˺ͬǰһ֪ͨԷ</p>\r\n<p>ڰĽ  <br />˫ڱЭΧڷףӦЭ̽Э̲ܴһʱٲίԱٲý</p>\r\n<p>ھɿ <br />𡢻ֵȻֺսչͣ硢Ϊ˫бЭ˫ͨʽ֪ͨԷЭ鼴ֹ  <br />ʮЭһʽݣ˫ִһݣ˫ǩָЧЭ鼰ظͬȷЧ</p>\r\n<p>׷Ե˲Ϻֿ˾ ҷ</p>\r\n<p><br />ǩ֣ ǩ֣</p>\r\n<p><br />££</p>\r\n<p><br />ڣꡡ¡աڣꡡ¡</p>','about','ads','1','0','2010-12-27 14:41:19','1','0');
INSERT INTO job_common VALUES('6','','<p><strong><span class=\"b_14\">˴</span></strong></p>\r\n<p><strong></strong><br /> ҵԴϵ캽,ְߵ԰,רҵ˲վ---һΪҵ͸˴ֵý</p>\r\n<p><span class=\"l_14\">һҵҵƽ̨ </span><br />ɱ͡Χ㡢ʱ䳤ϢϢ㡢ʱԺͽԵͻص㣬ٸıǵ硣 <br />Ϊ߷չýƽ̨綼йгǰ</p>\r\n<p><span class=\"l_14\">Ͷ룬򿪲Ƹ֮ </span><br /> ĳĳҵԴƺгչԵ˲\"ҵӪ\"ͨһƸվ <br /> 1еվ衢ķ! <br /> 2ܷ֮! <br /> 3ӮĽʾ֭! <br /> 4еͶķ! <br /> 5ܾӪ֮֮̽!</p>\r\n<p class=\"b_14\">Ե˲</p>\r\n<p><span class=\"l_14\">1 г</span><br /> ǰй1800ҵÿҵƸ󣬶ƸִܵҵӺiresesrchгѯ2003йƸо棩оʾ2003йƸгģΪ3.1Ԫң2006꽫Ϊ16.5ԪңƽΪ75.35<br />Ե˲ȺΪдרѧεĸԼҵȡԵ˲ҵ񼯺˵ǰԴչӯǱࡣ</p>\r\n<p><span class=\"l_14\">Ե˲ҵӪɱ</span><br /><span class=\"b_12\">ҵɿٷչ</span><br />ƸӪģʽ򵥣ҵչɱܵͣԿɿٵķչĿͻȺ<br /><span class=\"b_12\">пͻԴ</span><br />ԵԴϵвƷ̿ɳеĿͻȺͶ̫ĳɱ<br /><span class=\"b_12\">ѹɱ</span><br />ҵԴص˲ƸлڶͨϢʵִ֣κѹѹʽɱӪշǳС<br /><span class=\"b_12\">ۺɱ </span><br />ԵƵۺϵṩ١Чķ̵֧֣֤ۺɱС<br /> <br /><span class=\"l_14\">ġ  </span><br />1עĶ˵λԶеεķ˻<br />2гĳҵõҵͨ<br />3˽ⲢϤԵ˲վṩĸƷ̡<br />4ȷŵϸִЭͺͬейرغͱ\"Ե˲ϵ\"֪ʶȨչ˹ϵ<br />5Ӫ֧֤ҵչ<br />6ӵӪĵԵ豸ʩ <br />7ܶϷķƱݡ<br />8ж硢ܿгӪԱ</p>\r\n<p><span class=\"l_14\">塢˳ΪӪ̵Ĳ</span><br />1ֱµºԵ˲Ӫ룬ṩصļ<br />2Ե˲Ӫ˽Ǣ̸˽ͬӪߡƷݺͼ۸ϵ<br />3ϿӪߡƷݺͼ۸ϵĻϣԵ˲ǩʽͬļ<br />4պͬ涨ָʽԵ˲ָʻ֧ӪԤ<br />5Ե˲ȷյԤԵʼʽԷʹȨ޺룬ͬʱ&ldquo;Ե˲ӪȨ&rdquo;<br /><span class=\"l_14\">Ե˲˼Э</span><br /><span class=\"b_12\">׷</span> ҷ<br />ַ ַ</p>\r\n<p>˫л񹲺͹ͬؾ񣬱ŻݡԴӮԭ򣬾Э̣һͬǩ¼Ե˲˴ӪЭָͬվǼԵ߼Ե˲<br /><span class=\"b_12\">һݣ</span><br />˫Эһ£ҷָڴ׷&ldquo;Դ&rdquo;Ʒƹ㼰**רҵ񣬲Ʒ˵Լ׷ĹΪ׼<br /><span class=\"b_12\">Ȩ </span><br />һ׷Ȩ<br />1 ׷ǩЭڣҷ׷ɼ˷Ѻ󣬼׷Ȩ飻ҷ༭Ȩޣ༭Ϣ辭׷˺ٿͨ<br />2׷վӪ¡ӵվȫȨȨҷϢˣΪվϢɾܾ<br />3ڼ䣬ҷгڼ׷Ե˲ҳ裺Ե˲ վҷӣ <br />3׷֤վЧϵתЭҷչгƹ㣻<br />4׷ȷר˸ҷָЭԱ֤ ЧĽУ<br />5׷ҷҵѵԭϼ׷չҵѵѣ̲Ĺ⣩<br />6׷ҷύҵ񶩵׷ȷҷյͻĿ󣬰տͻɷһڿͨ񣨷ڼջ˳ӣ<br />7ͻԲƷͶߣṩߵ绰02151699591<br />8ݲƷͨͳÿ¶ҷṩĽɷѿͻݡɷܷýУԣ<br />9׷ƴϵͳԷ֧ҷչҵ<br />10׷гھֻٰᡢѵ<br />11׷ΪҷĿͻطƱҷÿ5ǰӦ׷µҵ񶩵<br />12ҷ׷ṩ֤֤ӡλ顣<br /> ҷȨ<br />1 ҷΪ׷Ȩĵ̣ҷȨ**/Χڣչ׷ȨĵľӪٽ׷ҵڵطչ <br />2 ڱͬЧڣ׷ ÷չڶҶ̣<br />3ҷڼ׷ҳϿ裺Ե˲ վҷӣҷҳ񱣳Ե˲ҳͬ<br />4ҷͻм׷Ʒۣά׷ƷƵ£иг뷢չͻ<br />5ڴҵб֤ͻṩõķ񣬲թȵȲֶ𺦿ͻ׷漰<br />6ռ׷ͬշѱ׼ն˿ͻȡã<br />7ҷҳϷϢʵɿ,ɴɵһк,ҷе䷨ΣҼ׷Ȩ泷ڱվϷϢطã <br />8 ҷӦȷԼͻʱҷյͻķú󣬷ΪͻϢ<br />9 ÿܵɷϢעͻϡɷѿͻޡɷѽͨƽ̨ѽɷϢݸף׷ϵͳԽɿͷʱͨ<br />10 ԿͻڲƷɷѡ񡢿ͨѯͶһڴṩѯ绰 <br />11 ҷдΪЧϵݣҷĵʼַϵ˵ϱ䶯ʱ뼰ʱԴ淽ʽλӸǹ¡˴ǩ֤ӡ֪ͨ׷£<br />12 ҷӦμӼ׷֯ĲڵĴֻ̽ᡢѵȣЭ׷⣻<br />13׷ṩϷĴ֤֤ӡλ֤顣<br />14ҷÿ5ǰ׷µҵ <br /><span class=\"b_12\">ҷ&ldquo;Դ&rdquo; Ʒ</span><br />һ˷Ʒ<br />1 ԵְֱͨΪȫʡϣعԱͨԵ˲ķϵƼ**ĸƸλ״οһƼ5ΣֱҵΪֹһշΪ100Ԫ/ꣻ<br />2 ԵְΪԻְṩְÿſΪ30100Ԫ<br />3 ʡΪȫ񹤵ȫҪṩʵЧùϢ֤ϵͬʱṩɴÿշΪ100Ԫ300Ԫݾշѣ<br />4 ȫԺУڴ<br />5 ѧʵϰΪУӦҵṩʵϰÿշΪÿ200400Ԫݾշѣ<br />ҵԴƷ<br />1ƸԱΪҵƸṩշΪ800Ԫ8000Ԫ/ꡣ<br />2нԱΪ˲šѵѯнṩϢշΪ600Ԫ8000Ԫ/ꣻ<br />3棺Ƹ桢桢ѵ桢վӵȣշΪ1000Ԫ150000Ԫշѱ׼<br />4ҵʼΪҵλṩʼͷÿշ0.2Ԫ2.00Ԫ<br />5ҵΪչеҵṩԴѯ˲ƼԱѵԱְ졢籣ȣշΪ50Ԫ500Ԫ/.£<br />6 ѵԱΪҵṩԱѵշΪ3000Ԫ20000Ԫݾշѣ<br />7 ͷΪҵṩ߼˲źͼ˲ţԼ˲޷շѱ׼Ϊн2030<br />8 վ裺ŵԴԼһļƿΪҵṩվרҳշΪ3000Ԫ50000Ԫݾշѣ<br />Ŀ׼ɸݵʵʵصı׼辭׷ͬ⡣<br /><span class=\"b_12\">ġޣ</span><br />꣬   ա   <br /><span class=\"b_12\">塢ü </span><br />1Ե˲˹ܶΪ ԪҷڱЭǩ10֧壻<br />2ҷ׷еԴƷصķƷ˫ղͬƷ档 1˷Ʒ˫ʵս۳˰Ѻı䣬ñΪҷ60׷40<br />2ҵƷ<br />12345ҵ˫ʵս۳˰Ѻı䣬ñΪҷ60׷40<br />678Ʒ˫۳ɱ󣬸50䡣Ŀ鶨ᡣ<br /><span class=\"b_12\"> ˰ѣ</span><br />˫ʵķֳɱԳе<br /><span class=\"b_12\">ߡ㷽ʽ</span><br />1 ҷÿҵ룬׷ӦĽ׷ʻͬʱҷӦԼõ6050ҵ׷վݣ <br />2 ʱ䣺ÿ5ǰҷ׷ҵ<br /><span class=\"b_12\">ˡرԼ </span><br />1 ҷδ׷ɣԼ׷һоӪɴһкҷге<br />2 ЭЧڣݱЭȷ涨ҷʹü׷ƷƺͱʶЭֹ֮ҷȨʹü׷κϰ̱ꡢ̺šԼվƵȣ<br />3 Эͬ£ҷǩȨ<br /><span class=\"b_12\">š</span><br />1 һһȡҵϸܣδȡһͬ£κε¶<br />2 ˫еƷͻʵϸб񣬲¶ʹã3ǩԼ˫ԱЭ鸺б<br /><span class=\"b_12\">ʮΥԼΣ </span><br />1 ҷʱ׷¿3ÿ찴Ӧ֮׷֧ɽ2ҷδ׷ͬļ۸вƷۣ׷ȨֱȡҷĴʸ񣬲׷ҷΥԼΣ<br />3ڼ׷ԭûаҷѽɷѿͻķʱͨڼ׷ԭϵͳУɴɵʧɼ׷е<br />4Υ&ldquo;&rdquo;ʧֵ3⳥Է<br />5δ׷ͬ⣬Լ׷±ЭľӪҷõ3֧׷ΥԼ<br />6һԭΥЭһʧģΥԼӦеɴ˸һɵһʧ<br /><span class=\"b_12\">ʮһĽʽ</span><br />緢飬˫Э̽Э̲ܴɣԭ淽ڵطԺϽ<br /><span class=\"b_12\">ʮЭֹ</span><br /> Эһγʱֹ<br />1޽˫ټ<br />2粻ɿ30ϣκһɷֹЭֹ֪ͨЭ飻<br /><span class=\"b_12\">ʮ</span><br />1 Э漰Ϊң<br />2 Эδ֮ˣ˫Э̣ <br />3Э龭˫ǩָºЧ<br />4Эһʽķݣ˫ִݣͬȷЧ<br />׷  ҷ<br />ǩ֣£ ǩ֣£<br />ϵ绰   ϵ绰<br />ʼ   ʼ<br />ڣ ڣ</p>','about','agent','1','0','2010-12-27 14:42:48','1','0');
INSERT INTO job_common VALUES('7','ϵ','<p><span class=\"l_14\"><span style=\"font-family: Verdana;\">˾ƣϺֿƼչ޹˾Chinese Jiazhi Network Tech Corp.<br />˾ַйϺζι·1022ţ201800<br />ֹ˾ַʡ̫·5ޱв2¥2201</span></span></p>\r\n<p><span class=\"l_14\"></span><span class=\"l_14\"><span style=\"font-family: Verdana;\">ѯ绰029-85460076&nbsp; 400-6606-156ⳤ;ѣ<br />˾棺400-6606-156-600</span></span></p>\r\n<p><span class=\"l_14\"><span style=\"font-family: Verdana;\">ѯ䣺<a href=\"mailto:web@finereason.com\">web#finereason.com</a>&nbsp; #@<br />֧֣support#finereason.com&nbsp; #@<br />ٷַ<a href=\"http://www.finereason.com/\">http://www.finereason.com</a>&nbsp;&nbsp;&nbsp; <a href=\"http://bbs.finereason.com/\">http://bbs.finereason.com</a></span></span></p>\r\n<p><span class=\"l_14\"><span style=\"font-family: Verdana;\">OICQѯ320133800&nbsp; &nbsp;&nbsp; 320133801&nbsp;&nbsp;&nbsp; 320133802&nbsp;&nbsp;&nbsp; 320133803&nbsp;&nbsp;&nbsp; 320133804&nbsp;&nbsp;&nbsp; &nbsp;822922400<br /></span></span></p>','about','contact','1','0','2010-12-27 14:45:35','1','0');
INSERT INTO job_common VALUES('8','ԱЭ','<p><span style=\"font-family: Verdana;\">{$FR_վ}ԱЭ</span></p>\r\n<p><span style=\"font-family: Verdana;\">{$FR_վ}ṩְƸѵϢְ֮ߡƸλԼκĿĽ뱾վķ߽ܱЭעΪҵԱرЭ֮ʹñվṩ֮㲻ܱ֮ʹñվܱ֮㽫رЭ֮涨 <br />1.Ϣķ</span></p>\r\n<p><span style=\"font-family: Verdana;\">?÷κΥйطɹ涨Ϣ<br />?÷κ뱾վְƸѵĿĲ֮Ϣ<br />?÷κβٵϢ<br />?ûκϢеȫΡ</span></p>\r\n<p><span style=\"font-family: Verdana;\">2.Ϣʹ</span></p>\r\n<p><span style=\"font-family: Verdana;\">?ƸλɾƸĿʹְ֮Ϣ<br />?ְ߽ӦƸĳְλʹƸλ֮ƸϢ<br />?վṩϢӦйصĿĶʹã<br />?ýκαվϢκҵĿġ</span></p>\r\n<p><span style=\"font-family: Verdana;\">3.ϢĹ</span></p>\r\n<p><span style=\"font-family: Verdana;\">{$FR_վ}¼κϢпܱκαվķҲܱʹáվԴ˽еκΡ</span></p>\r\n<p><span style=\"font-family: Verdana;\">4.Ϣ׼ȷ</span></p>\r\n<p><span style=\"font-family: Verdana;\">κڱվϢϺϷ׼ȷʱԭ򡣵վܱ֤ɵṩϢվвɼϢȫ׼ȷʹ˽⣬ЩϢʹãҪһʵվԷδкʵñվϢɵκʧеκΡ</span></p>\r\n<p><span style=\"font-family: Verdana;\">5.Ϣɾ</span></p>\r\n<p><span style=\"font-family: Verdana;\">Ϣķ⣬κη߲øĻɾ˷κϢվȨжϱ޸ĻɾκβϢ֮Ȩ</span></p>\r\n<p><span style=\"font-family: Verdana;\">6.Ȩ̱Ȩ</span></p>\r\n<p><span style=\"font-family: Verdana;\">վͼΡͼּȾ{$FR_վ}֮Ȩ̱귨֪ʶȨɱδ{$FR_վ}ɣκ˲ءơʹáڱϢ̱֮꣬Ӧ̱Ȩˣ̱귨</span></p>\r\n<p><span style=\"font-family: Verdana;\">7עϢʹ</span></p>\r\n<p><span style=\"font-family: Verdana;\">עԱṩĸϽᱻ{$FR_վ}ͳơܣǵϸ£Ϊ{$FR_վ}Ĺ̼ṩݡ{$FR_վ}᲻ڵͨעԱµĵʼͬûԱϵ </span></p>\r\n<p><span style=\"font-family: Verdana;\">{$FR_վ}ŵδȨͬ£{$FR_վ}Ὣߵĸй¶⡣<br />1 ) ִλ֮ҪΪ֮Ŀصλṩϣ<br />2 ) 㽫û֪˻˹עʻɴ˵µκθй¶<br />3 ) ڼ2000⡢ڿ͹ƶɵʱԹرյӰӪ֮ɿɵĸй¶ʧû򱻴ܸĵȣ <br />4 ) {$FR_վ}ӵվ֮й¶ɴ˶µκηͺ<br />5 ) ΪƲ֮Σա</span></p>\r\n<p><span style=\"font-family: Verdana;\">8.</span></p>\r\n<p><span style=\"font-family: Verdana;\">ʹñվûʹñվϢڱվϢıʹãеȫΡվκʹñվĵ֮ľףκΡ</span></p>\r\n<p><span style=\"font-family: Verdana;\">9.ֹ</span></p>\r\n<p><span style=\"font-family: Verdana;\">վȨԤֹ֪֪ͨͨκѷ</span></p>\r\n<p><span style=\"font-family: Verdana;\">10.鴦</span></p>\r\n<p><span style=\"font-family: Verdana;\">վϵͳάϵͳӵվܷʣվеκΡ</span></p>\r\n<p><span style=\"font-family: Verdana;\">11.</span></p>\r\n<p><span style=\"font-family: Verdana;\">ʱӴַʵʩʵʱӵȨģǱĲϣŲκηΡӦƸϢĵĸ˼ϵĸʽݵ׼ȷԺͺϷԶеһзΡƸϢķְλݿ⹫Ĳ϶еһзΡ</span></p>\r\n<p><span style=\"font-family: Verdana;\">֤ĳһְλһĿʹҲ֤һλضʹַڱַݣŲΡ</span></p>','about','agreement','1','0','2010-12-27 14:46:24','1','0');
INSERT INTO job_common VALUES('9','Ա','<p>Ա</p>','about','service','1','0','2010-08-28 12:13:59','1','0');
INSERT INTO job_common VALUES('10','ʽ','<div class=\"main_con\">\r\n<div style=\"border: #333333 1px dashed;\"><span style=\"color: #ff0000;\"><strong>˵</strong></span><br /><span style=\"color: #555;\">󼴱ȫǵĲƷ,ǲ˿<span style=\"color: #000000;\"></span>ṩĸʽϾΪϵӸͷԷȷϣ磺0.13ԪҪƱ뽫Ʊ˰7%һԺ뼰ʱϵȷϣ𲻱Ҫ鷳ҲԽ׵ɨ贫浽400-6606-156-600߷ʵweb<a href=\"mailto:service@finereason.com\">@finereason.com</a> ƭӣͻ·ʽʻ</span></div>\r\n<p><span style=\"color: #0000ff;\"> ˾ʻҵʱתʹ,벻Ҫ˺Ż㣩</span></p>\r\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\r\n<tbody>\r\n<tr>\r\n<td width=\"250\">\r\n<p><img style=\"width: 160px; height: 59px;\" src=\"http://www.finereason.com/Onlinepay/pay_img/banklogo_01.gif\" border=\"0\" alt=\"\" hspace=\"0\" width=\"160\" height=\"59\" /></p>\r\n</td>\r\n<td>У<span style=\"font-family: Verdana;\">йϺмζ֧</span> <br />&nbsp;&nbsp; ϺֿƼչ޹˾ <br />&nbsp; &nbsp;ţ<strong><span style=\"font-family: Verdana;\">1001 7008 0930 0147 897</span></strong></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>˵ ͬһתʻ24Сʱʡͬмתʣ48Сʱʡ</p>\r\n<p>ע⣺ʺֻҵתʣ;עѣ</p>\r\n<p><span style=\"color: #0000ff;\"> ûʽ</span></p>\r\n<table id=\"table1\" style=\"margin-top: 8px;\" border=\"1\" cellspacing=\"0\" width=\"700\" align=\"center\" bgcolor=\"#f5f5f5\">\r\n<tbody>\r\n<tr align=\"center\">\r\n<td width=\"200\" height=\"32\" align=\"center\" bgcolor=\"#1941a5\"><span style=\"color: #ffffff;\"></span></td>\r\n<td width=\"200\" height=\"32\" align=\"center\" bgcolor=\"#1941a5\"><span style=\"color: #ffffff;\"></span></td>\r\n<td height=\"32\" align=\"center\" bgcolor=\"#1941a5\"><span style=\"color: #ffffff;\"></span></td>\r\n<td width=\"120\" height=\"32\" align=\"center\" bgcolor=\"#1941a5\"><span style=\"color: #ffffff;\">տ</span></td>\r\n</tr>\r\n<tr align=\"center\">\r\n<td id=\"table1\" height=\"58\" align=\"center\"><img style=\"width: 160px; height: 59px;\" src=\"http://www.finereason.com/Onlinepay/pay_img/banklogo_01.gif\" border=\"0\" alt=\"\" hspace=\"0\" width=\"160\" height=\"59\" /></td>\r\n<td id=\"table1\" align=\"center\">й</td>\r\n<td id=\"table1\" align=\"center\">9558820405000568730</td>\r\n<td id=\"table1\" align=\"center\">ΰ</td>\r\n</tr>\r\n<tr align=\"center\">\r\n<td id=\"table1\" height=\"58\" align=\"center\">\r\n<div><img src=\"http://www.finereason.com/Onlinepay/pay_img/banklogo_02.gif\" alt=\"\" width=\"160\" height=\"59\" /></div>\r\n</td>\r\n<td id=\"table1\" align=\"center\">й</td>\r\n<td id=\"table1\" align=\"center\">4367420110228229223</td>\r\n<td id=\"table1\" align=\"center\">ΰ</td>\r\n</tr>\r\n<tr align=\"center\">\r\n<td id=\"table6\" height=\"58\" align=\"center\">\r\n<div><img src=\"http://www.finereason.com/Onlinepay/pay_img/banklogo_03.gif\" alt=\"\" width=\"160\" height=\"59\" /></div>\r\n</td>\r\n<td id=\"table6\" align=\"center\">йũҵ</td>\r\n<td id=\"table6\" align=\"center\">6228481720560433411</td>\r\n<td id=\"table6\" align=\"center\"></td>\r\n</tr>\r\n<tr align=\"center\">\r\n<td id=\"table9\" height=\"58\" align=\"center\">\r\n<div><img src=\"http://www.finereason.com/Onlinepay/pay_img/banklogo_05.gif\" alt=\"\" width=\"160\" height=\"59\" /></div>\r\n</td>\r\n<td id=\"table9\" align=\"center\">й</td>\r\n<td id=\"table9\" align=\"center\">6013825008002060922</td>\r\n<td id=\"table9\" align=\"center\"></td>\r\n</tr>\r\n<tr align=\"center\">\r\n<td id=\"table8\" height=\"58\" align=\"center\"><img src=\"http://www.kesion.com/Images/1197629054194800251.gif\" alt=\"\" width=\"198\" height=\"76\" /></td>\r\n<td id=\"table8\" align=\"center\"><a href=\"https://www.alipay.com/\" target=\"_blank\">www.alipay.com</a></td>\r\n<td id=\"table8\" align=\"center\"><a href=\"mailto:pay@finereason.com\">pay@finereason.com</a></td>\r\n<td id=\"table8\" align=\"center\">ž</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>','about','pay','1','0','2010-12-27 14:50:06','1','0');
INSERT INTO job_common VALUES('11','ͷ','<p><strong>&nbsp;</strong></p>\r\n<p><strong>Եͷ</strong><strong>&nbsp;</strong></p>\r\n<p>ҪҵƸ߼Ա߼רҵԱ</p>\r\n<p></p>\r\n<p>ҵг</p>\r\n<p>ۺְҵˣѷ</p>\r\n<p>ߺľƵרҵ˲ţѷ</p>\r\n<p>Ǳʷḻ׷׿Խĸˣѷ</p>\r\n<p>&nbsp;</p>\r\n<p>Լ</p>\r\n<p>ͻ&mdash;&mdash;ȷͻϢȫ</p>\r\n<p>ȫЧͨ&mdash;&mdash;Эͻȷ</p>\r\n<p>ٷ&mdash;&mdash;ṩֵ</p>\r\n<p>Ͻ淶&mdash;&mdash;ȷͻĿ</p>\r\n<p>&nbsp;</p>\r\n<p>Ƽɹ95%</p>\r\n<p>շѱ׼Ƹְλн30%Ƹλշѣ</p>\r\n<p>ɵĿƽ15&mdash;30</p>\r\n<p>Ƽѡƽ7</p>\r\n<p>Եͷߣ400 6606 156</p>\r\n<p>&nbsp;</p>\r\n<p><strong>ͷ̣</strong><strong></strong></p>\r\n<p>ǩͷ/ίƸЭ顷&mdash;&mdash;ȷƸλְְ&mdash;&mdash;Ѱáѡ˲&mdash;&mdash;ҵƼ25ѡ&mdash;&mdash;ЭҵԺѡ˽&mdash;&mdash;δͨƼ˲&mdash;&mdash;ٴԣֱԳɹϸ&mdash;&mdash;뱣֤&mdash;&mdash;֤ںѡ˱˻ְƼ˲&mdash;&mdash;ѡ˺ϸĿ</p>\r\n<p>Եͷߣ400 6606 156</p>','','','0','3','2010-12-30 23:16:50','0','2');
INSERT INTO job_common VALUES('12','շѱ׼ ','<p>շѱ׼Ƹְλн30%Ƹλշѣ</p>\r\n<p>ɵĿƽ15&mdash;30</p>\r\n<p>Ƽѡƽ7</p>\r\n<p>Եͷߣ400 6606 156</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Եͷ</strong><strong></strong></p>\r\n<p>ҪҵƸ߼Ա߼רҵԱ</p>\r\n<p></p>\r\n<p>ҵг</p>\r\n<p>ۺְҵˣѷ</p>\r\n<p>ߺľƵרҵ˲ţѷ</p>\r\n<p>Ǳʷḻ׷׿Խĸˣѷ</p>','','','0','4','2010-12-30 23:17:00','0','2');
INSERT INTO job_common VALUES('13','ͷ ','<p><span style=\"font-size: medium;\"><strong>&nbsp;</strong></span><strong>Ŷ</strong></p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;һͷҵרҵͷɣб϶Ľͳѯ飬ҵĻڶͷɹҵ֪ʶ</p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;  HRḻжϺѡʱȽ׼ȷ</p>\r\n<p><br /><strong>Ŷ&nbsp;</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ȫҵڹʡƴѧ汾ƽ</p>\r\n<p><br /><strong>ְֹŶ</strong>&nbsp;&nbsp; ȫԹʹ֪ҵHRܼࡢ˾߲ܡҵʿ߲ϵϹľӢʿ</p>\r\n<p><span style=\"font-size: medium;\"><strong>&nbsp;</strong></span></p>\r\n<p><span style=\"font-size: medium;\"><strong>Եְ</strong></span></p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ĳӵй㷺ϵڶ߼˲ŵĴҵĳҵרҡȨʿЩԴǵļְ֣ԵͷЩԴתΪμֵͬʱʹѻҵ档</p>\r\n<p><strong></strong><br />&nbsp;&nbsp;&nbsp;&nbsp; 1ĳҵй㷺ϵṩ߼˲Ÿ˼<br />&nbsp;&nbsp;&nbsp;&nbsp;2ĳҵй㷺ҵ߲ԴɾͷгǢ<br /><strong>λְ</strong><strong> </strong><strong><br /><strong>&nbsp;&nbsp;&nbsp; </strong></strong>ЭͷʿҵͻѰĿѡͷҵṩרҵӢ˲Ÿϡ<br /><strong>нر</strong> <br />&nbsp;&nbsp;&nbsp; ޵нĿɹ󣬰շܶ15%-20%ȡѣһԶ֡<br /><strong>˵</strong> <br />&nbsp;&nbsp;&nbsp;&nbsp;1ԵͷǩְЭ顷<br />&nbsp;&nbsp;&nbsp;&nbsp;2ԵͷѶԼְֽĿѵ<br />&nbsp;&nbsp;&nbsp;&nbsp;3ԵͷԼְϢϸܡ<br /><strong></strong><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;绰벦רѯ绰ֱԤԼ̸<br /><strong>ѯ绰</strong><strong>029</strong><strong>&mdash;</strong><strong>85460076</strong></p>','','','0','2','2010-12-30 23:17:08','0','2');
INSERT INTO job_common VALUES('14','ͷ','<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ԵͷṩרҵͷĻ֮һּ&ldquo;ΪҵѰƸһи߼˲šΪ˲Ŵְҵչƽ̨&rdquo;ҵΧ漰زͨšIT桢ҵҵ򸲸ǱϺϾݡڵʮмԵͷڳʵл˷ḻϢѼѡµ飬ǵרҵͷΪͻṩѸ١׼ȷ͸߶ȸԻķ</p>\r\n<p>ͷߣ400 6606 156</p>\r\n<p>&nbsp;</p>\r\n<p>ǵ</p>\r\n<p>ǿϢԴУ</p>\r\n<p>ԵͷԼĶվ&mdash;&mdash;Ե˲ΪУж˲ŻΪܣע˲Ϣ15и߼˲2WˣΪѡͷ˲ṩ˱Ҫͽϳֵ</p>\r\n<p>&nbsp;</p>\r\n<p>ȽѧĲϵͳ</p>\r\n<p>Ե˲ܻ߱˲ʲϵͳ֪ԴרҵԸͲԣɶ</p>\r\n<p>ѡ˽ȫ桢ѧΪѸ١׼Ƽѡṩ˱Ҫ֧֡</p>\r\n<p>϶רҵķ</p>\r\n<p>ͷʣǱ鲼иҵļְ֣Եͷʱ̲Լ˾&ldquo;ҵҪƷƣҪƷʣԱҪƷ&rdquo;ԵͷԶԼְ&ldquo;Ϊ˲ṩѵķչᣬΪҵ齨˲Ŷ&rdquo;</p>\r\n<p>&nbsp;</p>\r\n<p>Եͷߣ400 6606 156</p>','','','0','1','2010-12-30 23:17:24','0','2');
INSERT INTO job_common VALUES('15','Եͷ','<p>ǿϢԴУ</p>\r\n<p>ԵͷԼĶվ&mdash;&mdash;Ե˲ΪУж˲ŻΪܣע˲Ϣ15и߼˲2WˣΪѡͷ˲ṩ˱Ҫͽϳֵ</p>\r\n<p>&nbsp;</p>\r\n<p>ȽѧĲϵͳ</p>\r\n<p>Ե˲ܻ߱˲ʲϵͳ֪ԴרҵԸͲԣɶ</p>\r\n<p>ѡ˽ȫ桢ѧΪѸ١׼Ƽѡṩ˱Ҫ֧֡</p>\r\n<p>϶רҵķ</p>\r\n<p>ͷʣǱ鲼иҵļְ֣Եͷʱ̲Լ˾&ldquo;ҵҪƷƣҪƷʣԱҪƷ&rdquo;ԵͷԶԼְ&ldquo;Ϊ˲ṩѵķչᣬΪҵ齨˲Ŷ&rdquo;</p>\r\n<p>&nbsp;</p>\r\n<p>Եͷߣ400 6606 156</p>','','','0','5','2010-12-30 23:17:34','0','2');
INSERT INTO job_common VALUES('16','','<strong> <hr />\r\n<p>վҪ</strong>ݽ۴󷽣ҳ࣬޲롣<br />\r\n<strong>ҳҪ</strong>PR3IP1000ϣٶ¼1ϡ<br />\r\n<strong>ҳҪ</strong>PR4ϻٶ¼3ϡ<br />\r\n</p>','links','links','0','0','2011-03-10 17:52:35','1','0');

INSERT INTO job_ecoclass VALUES('10','ҵ','State-owned Enterprise');
INSERT INTO job_ecoclass VALUES('11','ҵ','Collective Enterprise');
INSERT INTO job_ecoclass VALUES('12','̶','Wholly Foreign-owned Enterprise');
INSERT INTO job_ecoclass VALUES('13','','Chinese-foreign Joint Venture');
INSERT INTO job_ecoclass VALUES('14','Ӫҵ','Non-government Enterprise');
INSERT INTO job_ecoclass VALUES('15','ɷҵ','Joint-equity Enterprise');
INSERT INTO job_ecoclass VALUES('16','','Administrative Organ');
INSERT INTO job_ecoclass VALUES('17','','Social Organization');
INSERT INTO job_ecoclass VALUES('18','ҵλ','Institution');
INSERT INTO job_ecoclass VALUES('19','','Other');

INSERT INTO job_edu VALUES('1','','Junior High School');
INSERT INTO job_edu VALUES('2','','Senior High School');
INSERT INTO job_edu VALUES('3','ְ/У','Vocational high school/Technical School');
INSERT INTO job_edu VALUES('4','ר','Technical Secondary School');
INSERT INTO job_edu VALUES('5','ר','Junior College');
INSERT INTO job_edu VALUES('6','ѧ','Bachelor');
INSERT INTO job_edu VALUES('7','˶ʿ','Master');
INSERT INTO job_edu VALUES('8','ʿ','Doctorate');

INSERT INTO job_foreigndegree VALUES('1','һ','Ordinary ');
INSERT INTO job_foreigndegree VALUES('2','','Good');
INSERT INTO job_foreigndegree VALUES('3','','Skilled');
INSERT INTO job_foreigndegree VALUES('4','ͨ','Versed');

INSERT INTO job_foreignlanguage VALUES('1','Ӣ','English');
INSERT INTO job_foreignlanguage VALUES('2','','Japanese');
INSERT INTO job_foreignlanguage VALUES('3','','Russian');
INSERT INTO job_foreignlanguage VALUES('4','','French');
INSERT INTO job_foreignlanguage VALUES('5','','German');
INSERT INTO job_foreignlanguage VALUES('6','','Italian');
INSERT INTO job_foreignlanguage VALUES('7','','Spanish');
INSERT INTO job_foreignlanguage VALUES('8','','Korean');
INSERT INTO job_foreignlanguage VALUES('9','ɹ','Mongolian');
INSERT INTO job_foreignlanguage VALUES('10','','Portuguese');
INSERT INTO job_foreignlanguage VALUES('11','','Arabic');
INSERT INTO job_foreignlanguage VALUES('12','','Others');

INSERT INTO job_group VALUES('2','ûԱ','1','0','1','','skin/system/group1.gif','1,3,1,3,1,3,3,3,1,1,1,3,0,0','0,0,0,0,0,0,0,0','1');
INSERT INTO job_group VALUES('3','ͨԱ','1','50','1','','skin/system/group2.gif','1,0,1,0,1,0,5,0,1,1,1,0,0,0','0,0,0,0,0,0,0,0','0');
INSERT INTO job_group VALUES('4','ûԱ','2','0','1','','skin/system/group1.gif','1,3,1,1,1,1,1,1,0,1,1,1,0,0','2,2,2,2,2,1,10','1');
INSERT INTO job_group VALUES('5','VIP¶ȻԱ','2','300','1','','skin/system/group2.gif','1,100,1,500,1,0,1,500,1,0,1,1,1,100','2,2,2,2,2,1,10','0');
INSERT INTO job_group VALUES('8','ͨԱ','3','0','1','','skin/system/group1.gif','0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0','0,0,0,0,0,0,0,0','1');
INSERT INTO job_group VALUES('10','ͨԱ','4','300','1','','skin/system/group1.gif','0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0','0,0,0,0,0,0,0,0','1');
INSERT INTO job_group VALUES('16','ԺУ','3','0','30','','skin/system/group0.gif','0,0,0,0,0,0,0,0,0,0,0,0,0,0','0,0,0,0,0,0,0','0');

INSERT INTO job_help VALUES('2','Ϊʲôҵϵʽ','<p>&nbsp;&nbsp;&nbsp; ְߵһ½վҪע˻Աֻע¼վܿվҵԱϵʽûоվ˵ҵϵʽͶݼҵϵ㣬ҪӪҵִոſԣǾͿҹ˾ʵԡ</p>','2','admin','2010-12-28 16:38:28');
INSERT INTO job_help VALUES('3','ûô죿','<blockquote>\r\n<p><span class=\\\"STYLE2\\\">&nbsp;&nbsp;&nbsp; Ե˲ṩ˿һ빦ܣֻṩעʱǼǵE-mailַǻԶ뷢䡣յ뻹ǲܵ¼ε½ʻƣϵͷ绰029-85460076&nbsp;&nbsp; 400-6606-156</span></p>\r\n</blockquote>','1','admin','2010-12-28 16:37:54');
INSERT INTO job_help VALUES('4','޸룿','<p>&nbsp;&nbsp;&nbsp; ¼˻Աģҵ²άĵ½޸ģ롣</p>','1','admin','2010-12-28 16:37:32');
INSERT INTO job_help VALUES('5','עʲôôҪ೤ʱ䣿עҪ','<p><br />&nbsp;&nbsp;&nbsp; עҪͨվȻͻվļ⣬˿ʱ޸ġҵƸʱԼ⣬ϵиĻᡣ⣬ע󣬿ʹְλۺϲѯղصȹܡעܼ򵥣ֻҪû롢ʼӼɣעȡдٶȡдãȻճУעǲҪѵģȫѵġ</p>','1','admin','2010-12-28 16:37:21');
INSERT INTO job_help VALUES('6','ûٵƸ棿','<p>&nbsp;&nbsp;&nbsp; ԿһµλǷͨǵ֤ʵ֤ʵҵһVIP ־Щûо֤ʵҵͲ֣Ҫעһ·ʾԼֵһԭǣκȡѡѵѡϸڷѵȷöΥģʵĹ˾ЩСķáҪΪְжϵɴ˶ɵʧǸŲְء</p>','3','admin','2010-12-28 16:25:45');
INSERT INTO job_help VALUES('7','д˼ôһ㷴ӦҲûУ','<p>&nbsp;&nbsp;&nbsp; ãҲľ̫ƽҲļдĲˣ޷ҵע⡣ʵϣܶΪ̫ҵ֮ϵգʵҵͶݼҵʶȡ</p>','2','admin','2010-12-28 16:26:41');
INSERT INTO job_help VALUES('8','оƸôҹ˾','<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ãΪ¼վĹ˾ܵõ¶Ļᣬᾭǡⲿֹ˾ʹվ¶ĻȽ϶ʹ⣬ְλѯвѯиְλ</p>','2','admin','2010-12-28 16:31:52');
INSERT INTO job_help VALUES('9','ˢҵļ','<p>&nbsp;&nbsp;&nbsp;&nbsp; ʾ&ldquo;¼ʱ&rdquo;Ǹÿε¼ʱԶĵģԼ޸ģֻҪ¼վɡʾ&ldquo;ʱ&rdquo;ָһ޸ļݵʱ䡣</p>','2','admin','2010-12-28 16:32:55');
INSERT INTO job_help VALUES('10','Ҹоְɹʲߣʲôؾ','<p>&nbsp;&nbsp;&nbsp; ԰½ְһǷа<br />&nbsp;&nbsp; (1)ϸʵд˼˵λĳ˽ǴӼʼģҪʱϴԼƬ&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <br />&nbsp;&nbsp;&nbsp; (2)Լдȫƣ⽫ʹƸаȫУְ&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <br />&nbsp;&nbsp;&nbsp; (3)ʹԤܣŰҪ۴󷽣Էϵ޸ġ<br />&nbsp;&nbsp;&nbsp; (4)žäĿͶݼͶݼǰϸ鿴ְλҪ󣬷ƸλС&nbsp;&nbsp; <br />&nbsp;&nbsp;&nbsp; (5)ʹְλ</p>','2','admin','2010-12-28 16:39:50');
INSERT INTO job_help VALUES('11','Ѿע˼ĿǰѾҵɾ ','<p class=\\\"tgray\\\" style=\\\"display: block;\\\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ṩ˵ķĿǰҹʾԺҹļ뱻λԵ&ldquo;&rdquo;в&ldquo;ҵϵʽ&rdquo;ܽ</p>','2','admin','2010-12-28 16:40:37');
INSERT INTO job_help VALUES('12','ͶݼʱϵͳʾҪ޷Ͷʲôԭ ','<p class=\\\"tgray\\\" style=\\\"display: block;\\\">&nbsp; &nbsp;ѧ߹鲻ϴ˹˾ãվáѡλͶļ</p>','2','admin','2010-12-28 16:41:33');
INSERT INTO job_help VALUES('13','ΪʲôеҵVIP־Ҳϵʽأ','<p>&nbsp;&nbsp;&nbsp; ǵĴֵͻԱҲǾ˵ģֻԱǿϵʽͶݼҵԿϵʽҵյļ󣬸оǻϵġ</p>','2','admin','2010-12-29 09:00:59');
INSERT INTO job_help VALUES('14','Ҹո޸ҵļҪǰͶݼĵλͶ ','<p class=\\\"tgray\\\" style=\\\"display: block;\\\">&nbsp;&nbsp;&nbsp; ͶݣЩλԿ°ļ</p>','2','admin','2010-12-28 16:43:09');
INSERT INTO job_help VALUES('15','ηƸ棿ܲܽҵƸŵҳͣһʱ䣿 ','<p><span class=\\\"tgray\\\">&nbsp;&nbsp;&nbsp; κξ׼ϷҵѷƸ档ҵûעᣬҪ5ҵʱעᡣעҵʹû¼ͿԷƸְλˣÿε¼վְλԶվҳ1Сʱظ¼ظ֣</span></p>','3','admin','2010-12-28 16:44:09');
INSERT INTO job_help VALUES('16','עҵƸǷշѣ ','<p class=\\\"tgray\\\" style=\\\"display: block;\\\">&nbsp;&nbsp;&nbsp; Ƹȫѵġҵעɹʹû/¼Ϳʱ޸ġɾƸְλעҵͬʱ5ְλ</p>','3','admin','2010-12-28 16:44:56');
INSERT INTO job_help VALUES('17','շѻԱѻԱҪ ','<p class=\\\"tgray\\\" style=\\\"display: block;\\\">&nbsp;&nbsp;&nbsp;&nbsp;շѵĻԱǳΪʽҵԱ,Ҫ¼㣺<br />(1)ʽҵԱԲ鿴мϵʽҵԱֻܲ鿴ְߵĻϡ<br />(2)ʽҵԱ¼վʾƼVIPԱѻԱʾҵְλ<br />(3)ҵԱֻͬʱ5ƸְλʽҵԱƷƸְλ</p>','3','admin','2010-12-28 16:45:36');
INSERT INTO job_help VALUES('18','һҺСĹ˾ÿֻƸˣʱ䲻̶ôʡǮ ','<p style=\\\"display: block;\\\"><span class=\\\"tgray\\\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ˾һƸǺܶ࣬ʱ䲻Ǻ̶ܹĻ˾μ&ldquo;ֵ&rdquo;ҵԱֻԱ԰ʹôշѣеֻʷ뵽ҳ·&ldquo;ʷѱ׼&rdquo;鿴</span></p>','3','admin','2010-12-28 16:47:18');
INSERT INTO job_help VALUES('19','νѣѺʹã𣿷ƱǷһң','<p>&nbsp;&nbsp;&nbsp; ҪҪʽԱ鿴VIP,Ҫлص͹˾Ӫҵִո浽053288789113յĴڹʱ10ڿͨ񣬲е绰֪ͨ˺,ȡƱǻ3ڻὫƱԹҺʽĳͨƱĳеʼ֪ͨԱмලͲѯ</p>','3','admin','2010-12-28 16:54:43');
INSERT INTO job_help VALUES('20','óʱ䲻ˣû룬ô죿 ','<p class=\\\"tgray\\\" style=\\\"display: block;\\\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ҳ&ldquo;&rdquo;ܡֻҪעʱûEmail֮һû뽫СѾˣ뽫˾ӪҵִմǣӪҵִע&ldquo;ȡû&rdquo;Ȼ󲦴ͷ绰ѯ</p>','1','admin','2010-12-28 16:55:23');
INSERT INTO job_help VALUES('21','µܡҵǰʲôҲû£Ҹô죿','<p><span class=\\\"tgray\\\">&nbsp;&nbsp;&nbsp; ˾ӪҵִմǣӪҵִע&ldquo;ȡû룬Ȼ󲦴ͷ绰ѯǰ鵽û/ؾ¼վ޸Ϣû롢ϵˡ绰桢ʼ</span></p>','1','admin','2010-12-28 16:56:09');
INSERT INTO job_help VALUES('22','ҸоƸɹʲߣʲôؾ ','<p>&nbsp;&nbsp;&nbsp; Գ·кܴ<br />(1)˾龡ʵɿʹְͨ˾ܻ˽Ĺ˾ְͶݼ<br />(2)׼ȷƸְλݣڲţϼ¼ְߵҪ󣨲ҪԱ塢ڽְäĿͶݼ<br />(3)ʱɾڵƸְλ<br />(4)⣬˲ͶݼҪˣҪʱʹ&ldquo;ܼѯ&rdquo;<br />(5)ʱظյӦƸҪְߵְʯ󺣣˾ĿڱҲǳɹĹؼϣʹòлܡ<br />(6)ļŽղؼУڲãԺá<br />(7)ܶĵ¼վλпҳ֡</p>','3','admin','2010-12-28 16:57:04');
INSERT INTO job_help VALUES('23','еĸʵ ','<p class=\\\"tgray\\\" style=\\\"display: block;\\\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ڼڶ࣬ǲ֤мݵʵԣƸλ֤ͨԼɴ˶ɵһΣվŲ</p>','3','admin','2010-12-28 16:57:36');
INSERT INTO job_help VALUES('24','ҹ˾ƸѾɾҵ˻ΰ ','<p class=\\\"tgray\\\" style=\\\"display: block;\\\">&nbsp;&nbsp;&nbsp;&nbsp;ǸλûṩƸƸְλȫͣɾְ߾Ͳѯ˾Ϣˣɾ˻˹˾´ƸʱٴעᣬΪʡʱ䡣</p>','3','admin','2010-12-28 16:58:25');
INSERT INTO job_help VALUES('25','д¼룿','<p>Ա¼:&nbsp;<br />&nbsp;&nbsp; ģѡ2-16ַӢĸСдɣ»߻֣ҲӢġ»ֽ<br />ʾ<br />&nbsp;&nbsp;1ѡ빫˾صĻԱ¼ǣ<br />&nbsp;&nbsp;2벻ҪڻԱ¼͸¶ҪĸϣÿŻ롣<br /><br />룺<br />&nbsp; ¼ͬԱ֤밲ȫѡ4-16ַӢĸעִСд֣ҲӢֽ<br /><br />ʾ<br />&nbsp; 1ʱأ벻Ҫʹòȫױ˲µ룬1111111aaaaaaaԱ֤밲ȫ<br />&nbsp; 2һΪ֪룬޸롣</p>','1','admin','2010-12-28 17:31:53');
INSERT INTO job_help VALUES('26','ְλ','<p>&nbsp;&nbsp;&nbsp; ϣĹλѡҪĹͣϣѡҪĵְλѡ񷢲ʱ䣬ڹؼдҪѰְλƣȻ</p>','3','admin','2010-12-28 17:31:35');

INSERT INTO job_helpsort VALUES('1','Աעᡢ½һ','1');
INSERT INTO job_helpsort VALUES('2','ְ','2');
INSERT INTO job_helpsort VALUES('3','Ƹҵ','3');
INSERT INTO job_helpsort VALUES('4','ͷ','4');
INSERT INTO job_helpsort VALUES('5','ѵ','5');
INSERT INTO job_helpsort VALUES('6','ԺУ˳','6');
INSERT INTO job_helpsort VALUES('7','Ѷ','7');

INSERT INTO job_label VALUES('1','{$FR_˲}','4','˲','<div class=\"resumesearch\">\r\n<form name=\"resumesimplesearch\" action=\"{$FR_ϵͳĿ¼}search/resume_searchresult.php\" method=\"post\" target=\"_blank\" class=\"search\">\r\n<li>רҵ <input type=\"hidden\" value=\"\" name=\"profession\"><input type=\"text\" name=\"professions\" value=\"ѡ˲רҵ\" class=\"search_case\" onclick=\"JumpSearchLayers(0,0,5,\'resumesimplesearch\',\'professions\',\'profession\');\" readonly /></li>\r\n<li>ְλ <input type=\"hidden\" value=\"\" name=\"position\"><input type=\"text\" name=\"positions\" value=\"ѡ˲ְλ\" class=\"search_case\" onclick=\"JumpSearchLayers(0,0,1,\'resumesimplesearch\',\'positions\',\'position\');\" readonly />\r\n</li>\r\n<li> <input type=\"hidden\" value=\"\" name=\"workadd\"><input type=\"text\" name=\"workadds\" value=\"ѡְ\" class=\"search_case\" onclick=\"JumpSearchLayers(0,0,2,\'resumesimplesearch\',\'workadds\',\'workadd\');\" readonly /></li>\r\n<li>ա <input type=\"hidden\" value=\"\" name=\"datetime\"><input type=\"text\" name=\"datetimes\" value=\"ѡ\" class=\"search_case\" onclick=\"JumpSearchDate(\'resumesimplesearch\',\'datetimes\',\'datetime\');\" readonly />\r\n</li>\r\n<li>ؼ <input name=\"keyword\" type=\"text\" size=\"20\" class=\"input165\" onblur=\"if(this.value==\'\') this.value=\'Ĺؼʣ\';\" onfocus=\"if(this.value==\'Ĺؼʣ\') this.value=\'\';\" value=\"Ĺؼʣ\" /></li>\r\n<li><input type=\"submit\" name=\"Submit3\" value=\" \" class=\"inputs\" /> [<a href=\"{$FR_ϵͳĿ¼}search/resume_searchresult.php\" target=\"_blank\">߼</a>]</li>\r\n</form>\r\n</div>','2008-11-08 16:48:00','2010-10-11 02:31:56','0');
INSERT INTO job_label VALUES('2','{$FR_ְλ}','4','ְλ','<div class=\"hiresearch\">\r\n<form name=\"hiresimplesearch\" action=\"{$FR_ϵͳĿ¼}search/hire_searchresult.php\" method=\"post\" target=\"_blank\" class=\"search\">\r\n<li>Сҵ:<input type=\"hidden\" value=\"\" name=\"trade\"><input type=\"text\" name=\"trades\" value=\"ѡҵ\" class=\"search_case\" onclick=\"JumpSearchLayers(2,0,4,\'hiresimplesearch\',\'trades\',\'trade\');\" readonly /></li> \r\n<li>ְλ:<input type=\"hidden\" value=\"\" name=\"position\"><input type=\"text\" name=\"positions\" value=\"ѡְλ\" class=\"search_case\" onclick=\"JumpSearchLayers(0,0,1,\'hiresimplesearch\',\'positions\',\'position\');\" readonly /></li>\r\n<li>:<input type=\"hidden\" value=\"\" name=\"workadd\"><input type=\"text\" name=\"workadds\" value=\"ѡص\" class=\"search_case\" onclick=\"JumpSearchLayers(0,0,2,\'hiresimplesearch\',\'workadds\',\'workadd\');\" readonly /></li>     \r\n<li>ա:<input type=\"hidden\" value=\"\" name=\"datetime\"><input type=\"text\" name=\"datetimes\" value=\"ѡ񷢲\" class=\"search_case\" onclick=\"JumpSearchDate(\'hiresimplesearch\',\'datetimes\',\'datetime\');\" readonly />\r\n</li>\r\n<li>ؼ:<input name=\"keyword\" type=\"text\" size=\"20\" class=\"input165\" onblur=\"if(this.value==\'\') this.value=\'Ĺؼʣ\';\" onfocus=\"if(this.value==\'Ĺؼʣ\') this.value=\'\';\" value=\"Ĺؼʣ\" /></li>\r\n<li><input type=\"submit\" name=\"Submit3\" value=\"   \" class=\"inputs\" /> | ߼</li>\r\n</form></div>','2008-11-10 09:18:00','2010-10-11 02:33:13','0');
INSERT INTO job_label VALUES('3','{$FR_ҳƵ}','5','ҳƵ','<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0\" width=\"232\" height=\"202\" style=\"z-index:0\">\r\n<param name=\"movie\" value=\"{$FR_ϵͳĿ¼}images/flvplayer.swf?file={$FR_ϵͳĿ¼}Upfiles/Video/daxuesheng.flv&image={$FR_ϵͳĿ¼}images/ad-3.gif&logo={$FR_ϵͳĿ¼}images/vod_logo.gif&autostart=false&loop=1&lightcolor=0x557722&backcolor=0x000000&frontcolor=0xCCCCCC\"><param name=\"wmode\" value=\"opaque\"><param name=\"quality\" value=\"high\"><param name=\"LOOP\" value=\"false\" />\r\n<embed src=\"{$FR_ϵͳĿ¼}images/flvplayer.swf?file={$FR_ϵͳĿ¼}Upfiles/Video/daxuesheng.flv&image={$FR_ϵͳĿ¼}images/ad-3.gif&logo={$FR_ϵͳĿ¼}images/vod_logo.gif&autostart=false&loop=1&lightcolor=0x557722&backcolor=0x000000&frontcolor=0xCCCCCC\" width=\"232\" height=\"202\" loop=\"false\" quality=\"high\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" type=\"application/x-shockwave-flash\"></embed></object>','2008-11-14 15:18:00','2008-11-21 16:07:00','0');
INSERT INTO job_label VALUES('4','{$FR_Ա¼}','5','Ա¼','<script language=\"JavaScript\">\r\nfunction fnRemoveBrank(strSource)\r\n{\r\n return strSource.replace(/^\\s*/,\'\').replace(/\\s*$/,\'\');\r\n}\r\nfunction check(myform)\r\n{\r\n	if(fnRemoveBrank(myform.login.value)==\"\")\r\n	{\r\n		alert(\"û\");\r\n		myform.login.focus();\r\n		return(false);\r\n	}\r\n	if(myform.pwd.value==\"\")\r\n	{\r\n		alert(\"룡\");\r\n		myform.pwd.focus();\r\n		return(false);\r\n	}\r\n}\r\nfunction loginout()\r\n{\r\n	if(confirm(\"ȷҪ˳\"))\r\n{\r\n	location.href =\"{$FR_ϵͳĿ¼}login.asp?Action=loginout&LoginChannel={$FR_Աͱ}\";\r\n}\r\n}\r\nfunction getpwd()\r\n{\r\n	location.href=\"{$FR_ϵͳĿ¼}getpassword.asp\";\r\n}\r\nfunction regmember()\r\n{\r\n	location.href =\"{$FR_ϵͳĿ¼}Register.asp?Member_type={$FR_Աͱ}\";\r\n}\r\n-->\r\n</script>\r\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\" class=\"logintab\">\r\n<form action=\"{$FR_ϵͳĿ¼}login.asp?Action=login&LoginChannel={$FR_Աͱ}\" method=\"post\" name=\"loginform\" id=\"loginform\" onSubmit=\"return check(this);\">\r\n	<tr>\r\n		<td width=\"170\">û<input type=\"text\" name=\"login\" class=\"inputl\" tabindex=\"1\" /></td>\r\n	</tr>\r\n	<tr>\r\n		<td>ܡ룺<input type=\"password\" name=\"pwd\" class=\"inputl\" tabindex=\"2\" /></td>\r\n	</tr>\r\n    <tr>\r\n		<td><label>\r\n	        <input type=\"submit\" name=\"button\" id=\"button\" value=\"¼\" />\r\n        </label></td>\r\n	</tr>\r\n	<tr>\r\n		<td>\r\n			<a href=\"#\" onclick=\"regmember();\">ע</a> <a href=\"#\" onclick=\"getpwd();\"></a>\r\n		</td>\r\n	</tr>\r\n</form>\r\n</table>\r\n<script language=\"javascript\" src=\"{$FR_ϵͳĿ¼}login.asp?Action=unlogin&LoginChannel={$FR_Աͱ}\"></script>','2008-11-14 15:30:00','2009-11-06 10:36:00','0');
INSERT INTO job_label VALUES('5','{$FR_ҵƸ}','6','ҳҵƸ','{getcomlist(72,3,0,12,1,1,4,2,1,1,0,\'m_activedate desc\',\'_blank\',0,0,0,0,180,60,0,0,0,0,1,2)}','2008-11-14 17:31:00','2010-09-29 00:56:35','0');
INSERT INTO job_label VALUES('6','{$FR_ƼӢ˲}','6','ƼӢ˲','{getresumelist(10,2,\'0|0|1|0|0|0|1|0|0|0\',1,1,1,0,3,3,\'r_adddate desc\',\'_blank\',0,0,90,99,0,0)}','2008-11-14 17:36:00','2010-08-15 00:32:38','0');
INSERT INTO job_label VALUES('7','{$FR_ȵҵƸ}','6','ҳȵҵƸ','{getcomlist(48,4,0,14,0,0,4,3,0,1,0,\'m_id desc\',\'_blank\',0,0,0,0,180,60,0,0,0,1,0,2)}','2008-11-15 10:21:00','2010-08-31 18:40:13','0');
INSERT INTO job_label VALUES('8','{$FR_վ׼ͷ}','5','վ׼ͷ','<SCRIPT src=\"{$FR_ϵͳĿ¼}js/tit.js\" type=\"text/javascript\"></SCRIPT>\r\n<div class=\"container\">\r\n<div class=\"headtop\">\r\n<li class=\"topl\">ù {$FR_վ}</li>\r\n<li class=\"topr\"><a href=\"javascript:void(0);\" onclick=\"this.style.behavior=\'url(#default#homepage)\'; this.setHomePage(\'{$FR_վַ}\');\">ҳ</a> | <a href=\"javascript:window.external.addFavorite(\'{$FR_վַ}\',\'{$FR_վ}\')\">ղرվ</a> | <a href=\"{$FR_ϵͳĿ¼}common.php?cid=7\">ϵ</a> | <script src=\"{$FR_վַ}{$FR_ϵͳĿ¼}js/language.js\" language=\"javascript\"></script></li>\r\n</div>\r\n	<div class=\"head\">\r\n		<div id=\"logo\"><a href=\"{$FR_վַ}\"><img src=\"{$FR_LOGOַ}\" alt=\"ӭ{$FR_վ}\" /></a></div>\r\n		<div class=\"banner\"><script language=\'javascript\' src=\'{$FR_ϵͳĿ¼}webad/ads.php?p=3\'></script></div>\r\n        <div class=\"linedh\">\r\n        <!-- <li class=\"dh\">ͷߣ{$FR_ϵ绰}</li> --></div>\r\n	</div>\r\n</div>\r\n	<div class=\"nav\"><div class=\"navr\"> </div><div class=\"navl\">{$FR_վ}</div></div>','2008-11-15 17:19:00','2011-03-10 14:14:44','0');
INSERT INTO job_label VALUES('9','{$FR_˲}','6','˲','{getresumelist(10,2,\'0|0|0|0|0|0|0|0|0|0\',1,1,0,0,3,3,\'r_adddate desc\',\'_blank\',3,1,90,99,0,0)}','2008-11-15 10:43:00','2010-08-15 00:35:04','0');
INSERT INTO job_label VALUES('10','{$FR_}','6','','{getlink(0,30,20,\'l_id desc\',8,\'_blank\',2)}','2008-11-15 11:16:00','2010-08-15 14:11:02','0');
INSERT INTO job_label VALUES('11','{$FR_ȨϢ}','5','ȨϢ','<ul>\r\n<li>{$FR_ҳβ}</li>\r\n</ul>\r\n<span>{$FR_վȨ}<br>{$FR_ICP֤} {$FR_ͳ}</span>\r\n<!-- JiaThis Button BEGIN -->\r\n<script type=\"text/javascript\" src=\"http://v2.jiathis.com/code/jiathis_r.js?move=0&amp;uid=896604\" charset=\"utf-8\"></script>\r\n<!-- JiaThis Button END -->','2008-11-15 11:30:00','2010-12-28 20:45:33','0');
INSERT INTO job_label VALUES('12','{$FR_}','4','','<div id=\"bodyly\" style=\"position:absolute;top:0px;z-index:0;left:0px;display:none;\"></div>\r\n<script language = \"JavaScript\" src=\"{$FR_ϵͳĿ¼}js/gettrade.js\"></script>\r\n<script language = \"JavaScript\" src=\"{$FR_ϵͳĿ¼}js/getposition.js\"></script>\r\n<script language = \"JavaScript\" src=\"{$FR_ϵͳĿ¼}js/getprovince.js\"></script>\r\n<script language = \"JavaScript\" src=\"{$FR_ϵͳĿ¼}js/getprofession.js\"></script>\r\n<div id=\"SearchDivhire\" style=\"border:1px #8BC3F6 solid; position:absolute;background-color:#FFFFFF;width:560px;font-size:12px;  z-index:999; display:none;\">\r\n	<div class=\"memmenul\">\r\n		<div style=\"width:538px; font-size:13px;color:#166AB6; font-weight:bold;\" class=\"leftmenutit\"><span style=\"float:right;font-size:12px; padding-right:10px; font-weight:normal; cursor:pointer;\" onClick=\"unSearchLayers();\">[ر]</span><span id=\"wintit\"></span></div>\r\n		<div style=\"width:100%;\">\r\n			<div id=\"hiretypes\" style=\"margin-left:20px; margin-top:10px;\"></div>\r\n			<div id=\"hiretype\" style=\"margin-left:20px; width:540px;\"></div>\r\n		</div>\r\n	</div>\r\n</div>','2008-11-14 15:44:00','2010-10-11 02:33:59','0');
INSERT INTO job_label VALUES('13','{$FR_ҳ·õƬ}','6','ǩ...','{getarticlelist(6,-1,0,5,5,0,1,1,\'n_id desc\',0,\'_blank\',0,0,290,118,0,0)}','2010-09-01 11:53:14','2010-09-01 11:54:43','0');
INSERT INTO job_label VALUES('14','{$FR_ְƸ}','6','߼˲ҳְƸģ','{gethirelist(10,1,\'1|0|1|0|0|0|0|0|0|0|0|0|0|0\',1,0,0,1,0,3,3,\'h_adddate desc\',\'_blank\',0,6,20,2)}','2010-09-04 21:27:48','2010-09-04 21:27:48','0');
INSERT INTO job_label VALUES('15','{$FR_¸߼˲}','6','¸߼˲','{getresumelist(20,2,\'0|0|1|1|0|1|1|0|0|0\',1,1,0,0,2,3,\'r_adddate desc\',\'_blank\',0,0,0,0,0,0)}','2010-09-04 21:29:37','2010-09-04 21:29:37','0');
INSERT INTO job_label VALUES('16','{$FR_¸߼ְλ}','6','¸߼ְλ','{gethirelist(20,1,\'1|1|1|0|0|1|1|0|0|0|0|0|0|1\',1,0,0,1,0,2,3,\'h_adddate desc\',\'_blank\',0,6,10,2)}','2010-09-04 21:35:04','2010-09-04 21:35:04','0');
INSERT INTO job_label VALUES('17','{$FR_ְλ}','6','ְλ','{gethirelist(10,1,\'1|0|1|0|0|0|0|0|0|0|0|0|0|0\',1,0,0,1,0,3,3,\'h_visitcount desc\',\'_blank\',0,6,0,2)}','2010-09-04 21:38:51','2010-09-04 21:39:47','0');
INSERT INTO job_label VALUES('18','{$FR_Ƽҵ}','6','ǩ...','{getcomlist(10,1,0,12,0,0,0,0,0,1,1,\'m_regdate desc\',\'_blank\',0,0,0,0,\'\',\'\',0,0,0,1,0,2)}','2010-09-04 21:46:58','2010-09-04 21:46:58','0');
INSERT INTO job_label VALUES('19','{$FR_¼ְ˲}','6','¼ְ˲','{getresumelist(20,2,\'0|0|1|1|0|1|1|0|0|0\',1,1,0,0,3,2,\'r_adddate desc\',\'_blank\',0,0,\'\',\'\',0,0)}','2010-09-04 21:48:57','2010-09-04 21:48:57','0');
INSERT INTO job_label VALUES('20','{$FR_ͷȵͼƬ}','6','ǩ...','{getarticlelist(-1,-1,0,10,2,1,1,0,\'n_id desc\',9,\'_blank\',1,0,120,90,0,10)}','2010-09-04 23:02:32','2010-09-05 00:13:05','0');
INSERT INTO job_label VALUES('21','{$FR_Ƽ}','6','ǩ...','{getarticlelist(-1,0,\'icon.gif\',10,1,1,0,0,\'n_id desc\',12,\'_blank\',1,0,0,0,0,10)}','2010-09-04 23:05:41','2010-09-04 23:05:41','0');
INSERT INTO job_label VALUES('22','{$FR_}','6','ǩ...','{getarticlelist(-1,0,\'icon.gif\',10,1,0,0,0,\'n_addtime desc\',13,\'_blank\',1,0,0,0,0,10)}','2010-09-04 23:07:45','2010-09-04 23:13:19','0');
INSERT INTO job_label VALUES('23','{$FR_ȵ}','6','ǩ...','{getarticlelist(-1,0,\'icon.gif\',10,1,0,0,0,\'n_hits asc\',13,\'_blank\',1,0,0,0,0,0)}','2010-09-04 23:09:03','2010-09-04 23:09:03','0');
INSERT INTO job_label VALUES('24','{$FR_ĿͼƬѶ}','6','ĿͼƬѶ','{getarticlelist(-1,-1,0,5,2,0,1,0,\'n_addtime desc\',10,\'_blank\',1,0,120,90,0,0)}','2010-09-04 23:41:38','2010-09-05 00:43:00','0');
INSERT INTO job_label VALUES('25','{$FR_ƼƬ˲}','6','ǩ...','{getresumelist(20,5,\'0|0|1|0|0|1|0|1|0|0\',1,1,0,0,3,3,\'r_adddate desc\',\'_blank\',2,1,60,72,0,0)}','2010-09-05 09:50:04','2010-10-11 02:50:20','0');
INSERT INTO job_label VALUES('26','{$FR_Ƽ˲}','6','ǩ...','{getresumelist(40,2,\'0|0|1|1|0|1|1|0|0|1\',1,1,0,0,3,3,\'r_adddate desc\',\'_blank\',0,0,0,0,0,0)}','2010-09-05 11:19:09','2010-09-05 11:19:09','0');
INSERT INTO job_label VALUES('27','{$FR_ƼƸ}','6','ǩ...','{getcomlist(12,6,0,0,1,1,5,2,1,1,1,\'m_activedate desc\',\'_blank\',1,0,1,0,144,100,0,0,0,0,0,2)}','2010-09-05 11:32:41','2010-10-11 02:09:27','0');
INSERT INTO job_label VALUES('30','{$FR_߷}','6','ǩ...','{getarticlelist(6,-1,\'icon.gif\',24,1,0,0,0,\'n_id desc\',20,\'_blank\',1,2,0,0,0,0)}','2010-10-11 01:41:25','2010-10-11 01:53:59','0');
INSERT INTO job_label VALUES('31','{$FR_Ƭ˲Ƽ}','6','Ƭ˲Ƽ','{getresumelist(10,10,\'0|0|0|0|0|0|0|0|0|0\',1,1,1,0,3,3,\'r_adddate desc\',\'_blank\',4,1,60,72,0,0)}','2010-10-11 02:58:23','2010-12-31 10:17:22','0');
INSERT INTO job_label VALUES('32','{$FR_˲Ƽ}','6','ǩ...','{getresumelist(30,5,\'0|0|1|1|0|1|0|0|0|0\',1,1,1,0,3,3,\'r_adddate desc\',\'_blank\',0,0,0,0,0,\'\')}','2010-10-11 03:04:10','2010-10-11 03:04:10','0');
INSERT INTO job_label VALUES('33','{$FR_ҳҵ֮·}','6','ǩ...','{getarticlelist(6,1,\'icon.gif\',10,1,0,0,1,\'n_id desc\',20,\'_blank\',1,2,0,0,0,0)}','2010-10-11 03:31:20','2010-10-11 03:31:20','0');
INSERT INTO job_label VALUES('34','{$FR_ҳְ}','6','ǩ...','{getarticlelist(6,6,\'icon.gif\',10,1,0,0,1,\'n_id desc\',20,\'_blank\',1,2,0,0,0,0)}','2010-10-11 03:32:14','2010-10-11 03:32:14','0');
INSERT INTO job_label VALUES('35','{$FR_ҳѶ}','6','ҳѶ','{getarticlelist(6,0,\'icon.gif\',10,1,0,0,1,\'n_id desc\',20,\'_blank\',1,2,0,0,0,0)}','2010-10-11 03:58:02','2010-10-11 03:58:02','0');
INSERT INTO job_label VALUES('36','{$FR_ҳͷѶ}','6','ǩ...','{getarticlelist(6,0,0,2,3,1,1,1,\'n_id desc\',12,\'_blank\',1,0,60,58,0,30)}','2010-10-11 16:53:15','2010-10-11 16:53:15','0');
INSERT INTO job_label VALUES('50','{$FR_߼ͷְλ}','6','ǩ...','{gethrzwlist(20,1,20,20,\'h_id desc\',\'_blank\',0,1)}','2010-12-30 11:10:02','2010-12-30 11:15:16','0');
INSERT INTO job_label VALUES('51','{$FR_ƷҵƸ}','6','ǩ...','{getcomlist(12,6,0,12,0,0,5,2,1,1,0,\'m_activedate desc\',\'_blank\',1,0,1,0,144,100,0,0,0,0,0,2)}','2010-12-31 04:27:29','2010-12-31 11:54:04','0');
INSERT INTO job_label VALUES('52','{$FR_ҳϷõƬ}','6','ǩ...','{getarticlelist(6,0,0,5,5,0,1,0,\'n_id desc\',0,\'_blank\',0,0,290,238,0,0)}','2010-12-31 09:57:11','2010-12-31 09:57:11','0');
INSERT INTO job_label VALUES('53','{$FR_ҳͷְλ}','6','ǩ...','{gethrzwlist(16,2,6,12,\'h_id desc\',\'_blank\',0,0)}','2010-12-31 10:22:27','2011-01-03 15:22:07','0');
INSERT INTO job_label VALUES('54','{$FR_ҳְҵָ}','6','ǩ...','{getarticlelist(6,5,0,8,1,0,0,1,\'n_id desc\',20,\'_blank\',1,2,0,0,1,0)}','2010-12-31 11:23:51','2011-01-03 15:21:40','0');
INSERT INTO job_label VALUES('55','{$FR_ҳƸר}','6','ǩ...','{gethirelist(7,1,\'1|1|0|0|0|0|0|0|0|0|0|0|0|1\',0,0,0,0,0,3,3,\'h_adddate desc\',\'_blank\',0,6,10,2)}','2010-12-31 12:04:27','2011-03-05 09:45:48','0');
INSERT INTO job_label VALUES('62','{$FR_}','5','ǩ...','ǩ...','2011-03-04 10:07:39','2011-03-04 10:07:39','0');
INSERT INTO job_label VALUES('63','{$FR_}','6','ҳ','{getlink(0,100,0,\'l_order asc\',10,\'_blank\',0)}','2011-03-05 09:47:04','2011-03-05 09:47:04','0');
INSERT INTO job_label VALUES('64','{$FR_ȫͼƬ}','6','ȫͼƬ','{getlink(1,0,1000,\'l_id desc\',0,\'_blank\',2)}','2011-03-05 09:56:20','2011-03-05 09:56:20','0');
INSERT INTO job_label VALUES('65','{$FR_ȫ}','6','ȫ','{getlink(0,1000,0,\'l_id desc\',10,\'_blank\',2)}','2011-03-05 09:56:49','2011-03-05 09:56:49','0');
INSERT INTO job_label VALUES('66','{$FR_ѶҳƸ}','6','ǩ...','{getcomlist(20,2,0,9,1,0,0,0,0,1,1,\'m_activedate desc\',\'_blank\',0,0,0,0,0,0,\'\',\'\',0,0,0,2)}','2011-03-05 13:45:20','2011-03-05 14:07:48','0');
INSERT INTO job_label VALUES('67','{$FR_¾ƼͼƬ}','6','ǩ...','{getarticlelist(0,-1,0,5,3,1,1,0,\'n_id desc\',10,\'_blank\',1,0,80,60,0,30)}','2011-03-05 13:52:04','2011-03-05 14:01:15','0');
INSERT INTO job_label VALUES('69','{$FR_߼ͷְλ}','6','ǩ...','{gethrzwlist(16,1,10,12,\'h_adddate desc\',\'_blank\',1,0)}','2011-03-05 21:13:30','2011-03-05 21:13:30','0');

INSERT INTO job_level VALUES('1','Сѧ','0','level/level1.gif','0');
INSERT INTO job_level VALUES('2','','100','level/level2.gif','0');
INSERT INTO job_level VALUES('3','','1000','level/level3.gif','0');
INSERT INTO job_level VALUES('4','ѧ','3000','level/level4.gif','0');
INSERT INTO job_level VALUES('5','о','6000','level/level5.gif','0');
INSERT INTO job_level VALUES('6','ʦ','10000','level/level6.gif','0');
INSERT INTO job_level VALUES('7','ʦ','15000','level/level7.gif','0');
INSERT INTO job_level VALUES('8','߼ʦ','20000','level/level8.gif','0');
INSERT INTO job_level VALUES('9','ר','28000','level/level9.gif','0');
INSERT INTO job_level VALUES('10','ר','36000','level/level10.gif','0');

INSERT INTO job_mailtemp VALUES('1','˻Աע֪ͨ','<p>ӭע{$FR_վ}ְԱ</p>\r\n<p>עûǣ{$FR_Աû}ǣ{$FR_Ա}ĵһݼѳɹ뼰ʱ½{$FR_վ}¼ݣԱҵʵĹ</p>','˻Աע֪ͨ','person_reg','1');
INSERT INTO job_mailtemp VALUES('2','ҵԱע֪ͨ','<p>ӭע{$FR_վ}ҵƸԱ</p>\r\n<p>עûǣ{$FR_Աû}ǣ{$FR_Ա}</p>','ҵԱע֪ͨ','company_reg','2');
INSERT INTO job_mailtemp VALUES('3','ԺУԱע֪ͨ','ԺУԱע֪ͨ','ԺУԱע֪ͨ','school_reg','0');
INSERT INTO job_mailtemp VALUES('4','Աע֪ͨ','Աע֪ͨ','Աע֪ͨ','train_reg','0');
INSERT INTO job_mailtemp VALUES('5','һʼ','<p>{$FR_Ա},ãóɹΪ:{$FR_Ա}뾡½<a href=\"{$FR_վַ}\">{$FR_վ}</a>޸ġ</p>','һʼ','get_pwd','0');
INSERT INTO job_mailtemp VALUES('6','ĺ{$FR_}ƼְλŶ','<p>{$FR_ռ}ã</p>\r\n<p>{$FR_ʼ}</p>\r\n<p>ʼϵͳˣ{$FR_}ַ{$FR_}</p>','Ƽְλ','to_friend','0');
INSERT INTO job_mailtemp VALUES('7','ҵԱ֪ͨ','<p>𾴵{$FR_Աû}</p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <a target=\"_blank\" href=\"{$FR_վַ}\">{$FR_վ}</a>עύҵͨ뾡½Ƹְλ</p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ˳ף</p>\r\n<p></p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; {$FR_վ}</p>','ҵԱ֪ͨ','company_flag','0');
INSERT INTO job_mailtemp VALUES('8','˻Ա֪ͨ','<p>𾴵{$FR_Աû}</p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <a target=\"_blank\" href=\"{$FR_վַ}\">{$FR_վ}</a>עύĸͨ뾡½д</p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ˳ף</p>\r\n<p></p>\r\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; {$FR_վ}</p>','˻Ա֪ͨ','person_flag','0');
INSERT INTO job_mailtemp VALUES('9','ԣ{$FR_λ}{$FR_ְλ}','<p>{$FR_ӦƸ}</p>\r\n<p>ã{$FR_λ}&ldquo;{$FR_ְλ}&rdquo;ְλ</p>\r\n<p>ְλַ{$FR_ְλַ}</p>\r\n<p>£</p>\r\n<p>{$FR_}</p>\r\n<p>&nbsp;</p>','֪ͨ','in_send','0');
INSERT INTO job_mailtemp VALUES('10','{$FR_ӦƸ}ӦƸ˾ġ{$FR_ְλ}ְλ','<p>𾴵{$FR_Աû}</p>\r\n<p>{$FR_ӦƸ}ӦƸ˾&ldquo;{$FR_ְλ}&rdquo;ְλ£</p>\r\n<p>{$FR_ְ}</p>\r\n<p>{$FR_ӦƸ}ϸַΪ{$FR_ַ}</p>','ְλӦƸ֪ͨ','re_send','0');
INSERT INTO job_mailtemp VALUES('11','ӦƸ{$FR_ְλ}{$FR_ӦƸ}ͨ{$FR_վ}ְ','<div style=\"font-size: 14px; line-height: 150%; text-align: left;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ã{$FR_ӦƸ}Թ˾&ldquo;{$FR_ְλ}&rdquo;ְλܸȤͨ&ldquo;{$FR_վ}&rdquo;&ldquo;ⷢ&rdquo;ƽ̨Ͷݸ˼ַ{$FR_ַ}<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Ͷ򣬿ֱӰϵʽ{$FR_ӦƸ}ϵ<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Ϊṩ˲ţ <a href=\"{$FR_վַ}{$FR_ϵͳĿ¼}\" target=\"_blank\">½վɸѡ˲ţ</a><br />{$FR_ְ}</div>\r\n<p>&nbsp;</p>','ⷢʼģ','send_out','0');
INSERT INTO job_mailtemp VALUES('12','{$FR_Ա},ԹԱѻظ','<p>𾴵{$FR_Ա}</p>\r\n<p>ã{$FR_վ}ύΪ{$FR_}ԣԱѻظ<a href=\"{$FR_վַ}{$FR_ϵͳĿ¼}guestbook\">ھ͵½鿴</a></p>','Իظ֪ͨ','answer_gb','0');
INSERT INTO job_mailtemp VALUES('13','ͨʼģ','<p>𾴵{$FR_Աû}</p>\r\n<p>{$FR_ʼ}</p>\r\n<p>&nbsp;</p>','ͨʼģ','mail_mb','0');

INSERT INTO job_marriage VALUES('1','δ','Single');
INSERT INTO job_marriage VALUES('2','ѻ','Married');
INSERT INTO job_marriage VALUES('3','','Divorced');
INSERT INTO job_marriage VALUES('4','','keep secret');

INSERT INTO job_nation VALUES('1000','','Hanzu');
INSERT INTO job_nation VALUES('1001','ɹ','Mongol');
INSERT INTO job_nation VALUES('1002','','Huizu');
INSERT INTO job_nation VALUES('1003','','Zangzu');
INSERT INTO job_nation VALUES('1004','ά','Uygur');
INSERT INTO job_nation VALUES('1005','','Miaozu');
INSERT INTO job_nation VALUES('1006','','Yizu');
INSERT INTO job_nation VALUES('1007','׳','Zhuangzu');
INSERT INTO job_nation VALUES('1008','','Bouyei');
INSERT INTO job_nation VALUES('1009','','Chaoxian');
INSERT INTO job_nation VALUES('1010','','Manzu');
INSERT INTO job_nation VALUES('1011','','Dongzu');
INSERT INTO job_nation VALUES('1012','','Yaozu');
INSERT INTO job_nation VALUES('1013','','Baizu');
INSERT INTO job_nation VALUES('1014','','Tujia');
INSERT INTO job_nation VALUES('1015','','Hani');
INSERT INTO job_nation VALUES('1016','','Kazak');
INSERT INTO job_nation VALUES('1017','','Daizu');
INSERT INTO job_nation VALUES('1018','','Lizu');
INSERT INTO job_nation VALUES('1019','','Lisu');
INSERT INTO job_nation VALUES('1020','','Vazu');
INSERT INTO job_nation VALUES('1021','','Shezu');
INSERT INTO job_nation VALUES('1022','ɽ','Gaoshan');
INSERT INTO job_nation VALUES('1023','','Lahu');
INSERT INTO job_nation VALUES('1024','ˮ','Suizu');
INSERT INTO job_nation VALUES('1025','','Dongxiang');
INSERT INTO job_nation VALUES('1026','','Naxi');
INSERT INTO job_nation VALUES('1027','','Jingpo');
INSERT INTO job_nation VALUES('1028','¶','Kirgiz');
INSERT INTO job_nation VALUES('1029','','Tuzu');
INSERT INTO job_nation VALUES('1030','Ӷ','Daur');
INSERT INTO job_nation VALUES('1031','','Mulam');
INSERT INTO job_nation VALUES('1032','Ǽ','Qiangzu');
INSERT INTO job_nation VALUES('1033','','Blang');
INSERT INTO job_nation VALUES('1034','','Salar');
INSERT INTO job_nation VALUES('1035','ë','Maonan');
INSERT INTO job_nation VALUES('1036','','Gelao');
INSERT INTO job_nation VALUES('1037','','Xibe');
INSERT INTO job_nation VALUES('1038','','Achang');
INSERT INTO job_nation VALUES('1039','','Primi');
INSERT INTO job_nation VALUES('1040','','Tajik');
INSERT INTO job_nation VALUES('1041','ŭ','Nuzu');
INSERT INTO job_nation VALUES('1042','α','Uzbek');
INSERT INTO job_nation VALUES('1043','˹','Russ');
INSERT INTO job_nation VALUES('1044','¿','Ewenki');
INSERT INTO job_nation VALUES('1045','','Benglong');
INSERT INTO job_nation VALUES('1046','','Bonan');
INSERT INTO job_nation VALUES('1047','ԣ','Yugur');
INSERT INTO job_nation VALUES('1048','','Ginzu');
INSERT INTO job_nation VALUES('1049','','Tatar');
INSERT INTO job_nation VALUES('1050','','Derung');
INSERT INTO job_nation VALUES('1051','״','Oroqen');
INSERT INTO job_nation VALUES('1052','','Hezhen');
INSERT INTO job_nation VALUES('1053','Ű','Monba');
INSERT INTO job_nation VALUES('1054','','Lhoba');
INSERT INTO job_nation VALUES('1055','ŵ','Jino');
INSERT INTO job_nation VALUES('1056','Ѫͳй','Foreigners with Chinese Nationality');
INSERT INTO job_nation VALUES('1057','','Others');

INSERT INTO job_newssort VALUES('1','ҵ֮·','6','2010-11-04 20:18:34','0','0');
INSERT INTO job_newssort VALUES('2','ְ̬','6','2008-11-13 16:32:40','1','0');
INSERT INTO job_newssort VALUES('3','߷','6','2008-11-13 16:42:29','2','0');
INSERT INTO job_newssort VALUES('5','ҵָ','6','2008-11-13 16:54:48','3','0');
INSERT INTO job_newssort VALUES('6','ְ','6','2008-11-13 16:54:57','4','0');
INSERT INTO job_newssort VALUES('7','¶̬','6','2008-11-13 16:55:03','5','0');
INSERT INTO job_newssort VALUES('8','н긣','6','2008-11-13 16:55:08','6','0');
INSERT INTO job_newssort VALUES('9','Ч','6','2008-11-13 16:55:17','7','0');
INSERT INTO job_newssort VALUES('10','ְ','6','2008-11-13 16:56:25','8','0');
INSERT INTO job_newssort VALUES('11','ۺ','6','2008-11-13 16:56:55','9','0');
INSERT INTO job_newssort VALUES('12','Ա','6','2008-11-14 09:33:16','10','0');
INSERT INTO job_newssort VALUES('13','䰸','6','2008-11-14 09:33:23','11','0');
INSERT INTO job_newssort VALUES('14','ְҵ','6','2008-11-14 09:33:29','12','0');
INSERT INTO job_newssort VALUES('15','ҵѵ','6','2008-11-14 09:33:35','13','0');
INSERT INTO job_newssort VALUES('16','ѽ','6','2008-11-14 09:37:13','14','0');
INSERT INTO job_newssort VALUES('22','ͷѶ','6','2010-12-28 10:45:19','0','0');


INSERT INTO job_payonline VALUES('1','YW92NzU1YnF0YWw2OWQ3MTJkYm54YTlldnJ1aXRlZ3c=','cGF5QGZpbmVyZWFzb24uY29t','MjA4ODEwMjc3NDI0NjUzMw==','1','0','֧');
INSERT INTO job_payonline VALUES('2','Y2hpbmFiYW5rNDg3NDA5NDc4','MTEzOTM=','','2','1','֧');
INSERT INTO job_payonline VALUES('3','NjUwNWIwMGFhNzFmNDY4MTI0NDgwNWI0OGE0NmMzZDI=','MTIwNDYyMTkwMQ==','','3','1','Ƹ֧ͨ');
INSERT INTO job_payonline VALUES('4','MzRUdEMxazI4MWVudXIxNTBQNTM5cDV4RXU4UTYxNDVENmtaRTE0dTQxWnFsQzJ4Rks0SjdweHRQNk1D','MTAwMDE1MDE5NTI=','','4','1','ױ֧');
INSERT INTO job_payonline VALUES('5','M250dGN1cGw2c2lqZncwOGdzZWU0NnpjdGZ3dDNkYmw=','YWxpcGF5QGZpbmVyZWFzb24uY29t','MjA4ODUwMTcxMzk3MDQwOQ==','5','1','֧ʱ');

INSERT INTO job_polity VALUES('1','Ա','Party Member');
INSERT INTO job_polity VALUES('2','Ա','League Member');
INSERT INTO job_polity VALUES('3','','Other Party Member');
INSERT INTO job_polity VALUES('4','Ⱥ','Non-Party Member');
INSERT INTO job_polity VALUES('5','','Other');

INSERT INTO job_position VALUES('1000','IT-','IT Software Development','0','0');
INSERT INTO job_position VALUES('1001','IT-Ӳ','IT Hardware Development','0','1');
INSERT INTO job_position VALUES('1002','IT-缰ͨѶ','IT Network and Communication','0','2');
INSERT INTO job_position VALUES('1003','IT-','IT Management','0','3');
INSERT INTO job_position VALUES('1004','IT-Ʒܡּ֧','IT Quality Control, Technical Support and Others','0','4');
INSERT INTO job_position VALUES('1005','Ӫ-','Marketing and Management','0','5');
INSERT INTO job_position VALUES('1006','Ӫ-','Sales','0','6');
INSERT INTO job_position VALUES('1007','Ӫ-񼰿ͷ','Sales, Technical Service and Customer Service','0','7');
INSERT INTO job_position VALUES('1008','Ӫ-','Others about Sales','0','8');
INSERT INTO job_position VALUES('1009','/ó/ɹ','Logistics/Trade/ Purchasing','0','9');
INSERT INTO job_position VALUES('1010','г//','Marketing/Public Relation/Advertising','0','10');
INSERT INTO job_position VALUES('1011','//ͳ/','Finance/ Accounting/Statistic','0','11');
INSERT INTO job_position VALUES('1012','//','Administration/ Personnel/ Logistics','0','12');
INSERT INTO job_position VALUES('1013','߼','Senior Management','0','13');
INSERT INTO job_position VALUES('1014','//','Art/Design','0','14');
INSERT INTO job_position VALUES('1015','ʦ/','Lawyer/Justice','0','15');
INSERT INTO job_position VALUES('1016','ʦ ','Teachers','0','16');
INSERT INTO job_position VALUES('1017','ҽ//','Medical Treatment/ Nursing/Health','0','17');
INSERT INTO job_position VALUES('1018','ѯ/','Consultant/ Adviser','0','18');
INSERT INTO job_position VALUES('1019','Уѧ','Students','0','19');
INSERT INTO job_position VALUES('1020','ѵ','Trained Person','0','20');
INSERT INTO job_position VALUES('1021',' ','Service','0','21');
INSERT INTO job_position VALUES('1022','ز///װ','Real Estate/ Architecture /Building Materials/ Dec','0','22');
INSERT INTO job_position VALUES('1023','','Translators','0','23');
INSERT INTO job_position VALUES('1024','֯װ','Textile and Clothing','0','24');
INSERT INTO job_position VALUES('1025','','Chemical Industry','0','25');
INSERT INTO job_position VALUES('1026','ʳƷ','Food','0','26');
INSERT INTO job_position VALUES('1027','Ƶ/','Hotel/Food & Beverage','0','27');
INSERT INTO job_position VALUES('1028','װ/ӡˢ/ֽ','Packaging/Printing/Paper','0','28');
INSERT INTO job_position VALUES('1029','е豸','Machine and Equipment','0','29');
INSERT INTO job_position VALUES('1030','ũ','Agriculture','0','30');
INSERT INTO job_position VALUES('1031','ͨ','Traffic & Transportation','0','31');
INSERT INTO job_position VALUES('1032','//Դ','Electric Power/Energy','0','32');
INSERT INTO job_position VALUES('1033','/Ӫ/','Production/Operation/Project','0','33');
INSERT INTO job_position VALUES('1034','Ա','Researchers','0','34');
INSERT INTO job_position VALUES('1035','Ա','Civil Servant','0','35');
INSERT INTO job_position VALUES('1036','','Others','0','36');
INSERT INTO job_position VALUES('1037','ϵͳԱ','Systems Analyst','1000','37');
INSERT INTO job_position VALUES('1038','߼ʦ','Senior Software Engineer','1000','38');
INSERT INTO job_position VALUES('1039','ʦ','Software Engineer','1000','39');
INSERT INTO job_position VALUES('1040','ϵͳʦ','Systematic Engineer','1000','40');
INSERT INTO job_position VALUES('1041','ERP/Ӧù','ERP Technical/Application Consultant','1000','41');
INSERT INTO job_position VALUES('1042','ݿ⹤ʦ','Database Engineer','1000','42');
INSERT INTO job_position VALUES('1043','߼Ӳʦ','Senior Hardware Engineer','1001','43');
INSERT INTO job_position VALUES('1044','Ӳʦ','Hardware Engineer','1001','44');
INSERT INTO job_position VALUES('1045','Ƭ/OLC/DSP/ײ㹤ʦ','Mono-Chip Computers / OLC/DSP /Bottom Engineer','1001','45');
INSERT INTO job_position VALUES('1046','Ϣ','IT Manager','1002','46');
INSERT INTO job_position VALUES('1047','Ϣ','IT Supervisor','1002','47');
INSERT INTO job_position VALUES('1048','ϢרԱ','IT Specialist','1002','48');
INSERT INTO job_position VALUES('1049','ͨżʦ','Communications Engineer','1002','49');
INSERT INTO job_position VALUES('1050','Ϣȫʦ','Information Security Engineer','1002','50');
INSERT INTO job_position VALUES('1051','վӪ˾/','Web Operations Manager/ Supervisor','1002','51');
INSERT INTO job_position VALUES('1052','繤ʦ','Network engineer','1002','52');
INSERT INTO job_position VALUES('1053','վʦ','Website engineer','1002','53');
INSERT INTO job_position VALUES('1054','ϵͳԱ/','System Manager / Webmaster','1002','54');
INSERT INTO job_position VALUES('1055','ҳ/','WebPages Designer / Maker','1002','55');
INSERT INTO job_position VALUES('1056','ʦ','E-commerce Engineer','1002','56');
INSERT INTO job_position VALUES('1057','վ߻','Website Planner','1002','57');
INSERT INTO job_position VALUES('1058','ܴ/ۺϲ/','Intelligent Building/Generic Cabling/Light Current','1002','58');
INSERT INTO job_position VALUES('1059','ͨѶʦ','Communications Engineer','1002','59');
INSERT INTO job_position VALUES('1060','ϯִй٣CTO','Chief Technical Officer','1003','60');
INSERT INTO job_position VALUES('1061','ܼ/','Technical Director/Manager','1003','61');
INSERT INTO job_position VALUES('1062','Ŀ/','Project Manager/ Supervisor','1003','62');
INSERT INTO job_position VALUES('1063','Ŀִ/ЭԱ','Project Operational Staff/Coordinator','1003','63');
INSERT INTO job_position VALUES('1064','̹','Software Project Manager','1003','64');
INSERT INTO job_position VALUES('1065','֧־','Technical Support Manager','1004','65');
INSERT INTO job_position VALUES('1066','ֹ֧ʦ','Technical Support Engineer','1004','66');
INSERT INTO job_position VALUES('1067','Ʒʾ','QA Manager','1004','67');
INSERT INTO job_position VALUES('1068','Թʦ','Software QA Engineer','1004','68');
INSERT INTO job_position VALUES('1069','ӲԹʦ','Hardware QA Engineer','1004','69');
INSERT INTO job_position VALUES('1070','Ա','QA Inspector','1004','70');
INSERT INTO job_position VALUES('1071','ý뿪','Multi-media Designer and Developer','1004','71');
INSERT INTO job_position VALUES('1072','ͼ','Computer Associate Design and Drawing','1004','72');
INSERT INTO job_position VALUES('1073','ϵͳ֧','System Integration and Support','1004','73');
INSERT INTO job_position VALUES('1074','Ա/','Technical Clerk/Assistant','1004','74');
INSERT INTO job_position VALUES('1075','','Others','1004','75');
INSERT INTO job_position VALUES('1076','Ӫܼ','Sales director','1005','76');
INSERT INTO job_position VALUES('1077','Ӫ','Sales Manager','1005','77');
INSERT INTO job_position VALUES('1078','Ӫ','Sales Supervisor','1005','78');
INSERT INTO job_position VALUES('1079','','Commercial Manager','1005','79');
INSERT INTO job_position VALUES('1080','/','Channel/Distribution Manager','1005','80');
INSERT INTO job_position VALUES('1081','ͻ','Account Manager','1005','81');
INSERT INTO job_position VALUES('1082','Ӫ','Sales Administration Manager','1005','82');
INSERT INTO job_position VALUES('1083','Ӫ','Sales Administration Supervisor','1005','83');
INSERT INTO job_position VALUES('1084','','Distribution Supervisor','1005','84');
INSERT INTO job_position VALUES('1085','Ӫ','Regional Marketing Manager','1005','85');
INSERT INTO job_position VALUES('1086','۴','Sales Representative','1006','86');
INSERT INTO job_position VALUES('1087','','General Distributor','1006','87');
INSERT INTO job_position VALUES('1088','ҽҩ','Pharmaceutical Sales Representative','1006','88');
INSERT INTO job_position VALUES('1089','մ','Insurance Agent','1006','89');
INSERT INTO job_position VALUES('1090','۹ʦ','Sales Engineer','1006','90');
INSERT INTO job_position VALUES('1091','绰ӪԱ','Telephone Sales Executive','1006','91');
INSERT INTO job_position VALUES('1092','ǰ/ۺ','Technical Service Manager','1007','92');
INSERT INTO job_position VALUES('1093','ǰ/ۺ','Technical Service Supervisor','1007','93');
INSERT INTO job_position VALUES('1094','ǰ/ۺ񹤳ʦ','Technical Service Engineer','1007','94');
INSERT INTO job_position VALUES('1095','ۺ/ͷǼ','Customer Service Manager','1007','95');
INSERT INTO job_position VALUES('1096','ۺ/ͷܣǼ','Customer Service Supervisor','1007','96');
INSERT INTO job_position VALUES('1097','ۺ/ͷרԱǼ','Customer Service Specialist','1007','97');
INSERT INTO job_position VALUES('1098','ͻϵ','Customer Relationship Management','1007','98');
INSERT INTO job_position VALUES('1099','ͻ','Customer Analyst','1007','99');
INSERT INTO job_position VALUES('1100','Ͷ߹','Customer Complaint Management','1007','100');
INSERT INTO job_position VALUES('1101','ͻѵ','Customer Training','1007','101');
INSERT INTO job_position VALUES('1102','Ա','Hotline Staff','1007','102');
INSERT INTO job_position VALUES('1103','','Sales Assistant','1008','103');
INSERT INTO job_position VALUES('1104','רԱ/','Business Specialist /Assistant','1008','104');
INSERT INTO job_position VALUES('1105','','Others','1008','105');
INSERT INTO job_position VALUES('1106','','Logistics Manager','1009','106');
INSERT INTO job_position VALUES('1107','','Logistics Supervisor','1009','107');
INSERT INTO job_position VALUES('1108','רԱ/','Logistics Specialist /Assistant','1009','108');
INSERT INTO job_position VALUES('1109','Ͼ','Materials Manager','1009','109');
INSERT INTO job_position VALUES('1110','','Materials Supervisor','1009','110');
INSERT INTO job_position VALUES('1111','ɹ','Purchasing Manager','1009','111');
INSERT INTO job_position VALUES('1112','ɹ','Purchasing Supervisor','1009','112');
INSERT INTO job_position VALUES('1113','ɹԱ','Purchasing Executive','1009','113');
INSERT INTO job_position VALUES('1114','ó/ó׾/','Trading Manager/Supervisor','1009','114');
INSERT INTO job_position VALUES('1115','ó/óרԱ/','Trading Specialist /Assistant','1009','115');
INSERT INTO job_position VALUES('1116','ҵ','Merchandiser Manager','1009','116');
INSERT INTO job_position VALUES('1117','߼ҵ','Senior Merchandiser','1009','117');
INSERT INTO job_position VALUES('1118','ҵ','Merchandiser','1009','118');
INSERT INTO job_position VALUES('1119','ҵ','Assistant Merchandiser','1009','119');
INSERT INTO job_position VALUES('1120','ֿ⾭/','Warehouse Manager','1009','120');
INSERT INTO job_position VALUES('1121','ֿԱ','Warehouse Specialist','1009','121');
INSERT INTO job_position VALUES('1122','侭/','Distribution Manager/Supervisor','1009','122');
INSERT INTO job_position VALUES('1123','Ա','Declarant','1009','123');
INSERT INTO job_position VALUES('1124','֤Ա','Documentation Specialist','1009','124');
INSERT INTO job_position VALUES('1125','Ա','Shipping Service Staff','1009','125');
INSERT INTO job_position VALUES('1126','Ա','Courier','1009','126');
INSERT INTO job_position VALUES('1127','Ա','Stockman','1009','127');
INSERT INTO job_position VALUES('1128','','Others','1009','128');
INSERT INTO job_position VALUES('1129','г/ܼ','Marketing/ Advertising Director','1010','129');
INSERT INTO job_position VALUES('1130','г/Ӫ','Marketing Manager','1010','130');
INSERT INTO job_position VALUES('1131','г/Ӫ','Marketing Supervisor','1010','131');
INSERT INTO job_position VALUES('1132','г/ӪרԱ','Marketing Executive','1010','132');
INSERT INTO job_position VALUES('1133','г','Marketing Assistant','1010','133');
INSERT INTO job_position VALUES('1134','г/','Market Analyst/Researcher','1010','134');
INSERT INTO job_position VALUES('1135','Ʒ/Ʒƾ','Product/Brand Manager','1010','135');
INSERT INTO job_position VALUES('1136','Ʒ/Ʒ','Product/Brand Supervisor','1010','136');
INSERT INTO job_position VALUES('1137','гͨ·','Trade Marketing Manager','1010','137');
INSERT INTO job_position VALUES('1138','гͨ·','Trade Marketing Supervisor','1010','138');
INSERT INTO job_position VALUES('1139','','Promotions Manager','1010','139');
INSERT INTO job_position VALUES('1140','','Promotions Supervisor','1010','140');
INSERT INTO job_position VALUES('1141','Ա','Promotions Specialist','1010','141');
INSERT INTO job_position VALUES('1142','г/Ա','Market Analyst/Researcher','1010','142');
INSERT INTO job_position VALUES('1143','/','Public Relations Manager','1010','143');
INSERT INTO job_position VALUES('1144','/','Public Relations Supervisor','1010','144');
INSERT INTO job_position VALUES('1145','/רԱ','Public Relations Executive','1010','145');
INSERT INTO job_position VALUES('1146','ý龭','Media Manager','1010','146');
INSERT INTO job_position VALUES('1147','ýԱ','Media Staff','1010','147');
INSERT INTO job_position VALUES('1148','ҵ/ҵչ','Business Development Manager','1010','148');
INSERT INTO job_position VALUES('1149','ҵ߻Ա','Corporate Planner','1010','149');
INSERT INTO job_position VALUES('1150','߻//İ','Advertising Creative/Design/Copy writer','1010','150');
INSERT INTO job_position VALUES('1151','ӪҵԱ','Shop-assistant','1010','151');
INSERT INTO job_position VALUES('1152','Ա','Cashier','1010','152');
INSERT INTO job_position VALUES('1153','ʦ','Auctioneer','1010','153');
INSERT INTO job_position VALUES('1154','䵱ҵԱ','Pawnshop Businessman','1010','154');
INSERT INTO job_position VALUES('1155','ҵԱ','Renting Businessman','1010','155');
INSERT INTO job_position VALUES('1156','﷢Ա','Publishing Staff','1010','156');
INSERT INTO job_position VALUES('1157','','Others','1010','157');
INSERT INTO job_position VALUES('1158','ܼ','Financial Controller','1011','158');
INSERT INTO job_position VALUES('1159','//','Financial Manager/Deputy Manager/ Treasurer','1011','159');
INSERT INTO job_position VALUES('1160','/','Finance Executive','1011','160');
INSERT INTO job_position VALUES('1161','ƾ/','Accounting Manager','1011','161');
INSERT INTO job_position VALUES('1162','','Accountant','1011','162');
INSERT INTO job_position VALUES('1163','Ա','Treasurer','1011','163');
INSERT INTO job_position VALUES('1164','/','Finance / Accounting Assistant','1011','164');
INSERT INTO job_position VALUES('1165','/','Financial Analysis Manager/Supervisor','1011','165');
INSERT INTO job_position VALUES('1166','Ա','Financial Analyst','1011','166');
INSERT INTO job_position VALUES('1167','ɱ/ɱ','Cost Accounting Manager/Supervisor','1011','167');
INSERT INTO job_position VALUES('1168','ɱԱ','Cost Accounting Specialist','1011','168');
INSERT INTO job_position VALUES('1169','ƾ/','Audit Manager/ Supervisor','1011','169');
INSERT INTO job_position VALUES('1170','רԱ/','Audit Specialist /Assistant','1011','170');
INSERT INTO job_position VALUES('1171','ԤԱ','Budgeter','1011','171');
INSERT INTO job_position VALUES('1172','Ա','Audit Clerk','1011','172');
INSERT INTO job_position VALUES('1173','ʲ','Assets Appraisal','1011','173');
INSERT INTO job_position VALUES('1174','˰/˰','Tax Manager/ Supervisor','1011','174');
INSERT INTO job_position VALUES('1175','˰רԱ','Tax Specialist','1011','175');
INSERT INTO job_position VALUES('1176','֤ȯ','Stock Broker','1011','176');
INSERT INTO job_position VALUES('1177','ڻ','Future Broker','1011','177');
INSERT INTO job_position VALUES('1178','Ͷʹ','Investment Advisor','1011','178');
INSERT INTO job_position VALUES('1179','עʦ','Chartered Financial Analyst','1011','179');
INSERT INTO job_position VALUES('1180','Ͷ/Ŀ','Investment Manager','1011','180');
INSERT INTO job_position VALUES('1181','ʾ/','Treasury Supervisor','1011','181');
INSERT INTO job_position VALUES('1182','רԱ','Treasury Specialist','1011','182');
INSERT INTO job_position VALUES('1183','г/г','President/ Vice President','1011','183');
INSERT INTO job_position VALUES('1184','տ','Risk Control','1011','184');
INSERT INTO job_position VALUES('1185','/֤','Import & Export Credit Settlement','1011','185');
INSERT INTO job_position VALUES('1186','Ա','Settlement Officer','1011','186');
INSERT INTO job_position VALUES('1187','','Exchange Manager','1011','187');
INSERT INTO job_position VALUES('1188','㾭','Exchange Broker','1011','188');
INSERT INTO job_position VALUES('1189','߼ͻ/ͻ','Senior Account Manager/ Account Manager','1011','189');
INSERT INTO job_position VALUES('1190','ͻ/רԱ','Account Supervisor / Specialist','1011','190');
INSERT INTO job_position VALUES('1191','Ŵ/õ/Ա','Credit/Research/ Analyst','1011','191');
INSERT INTO job_position VALUES('1192','й̨','Cashier','1011','192');
INSERT INTO job_position VALUES('1193','ͳԱ','Statistical Clerk','1011','193');
INSERT INTO job_position VALUES('1194','','Others','1011','194');
INSERT INTO job_position VALUES('1195','/ܼ','Administrative/ Personnel Director','1012','195');
INSERT INTO job_position VALUES('1196','Դ','Human Resource Manager','1012','196');
INSERT INTO job_position VALUES('1197','','Human Resource Supervisor','1012','197');
INSERT INTO job_position VALUES('1198','רԱ','Human Resource Specialist','1012','198');
INSERT INTO job_position VALUES('1199','','Assistant HR Supervisor','1012','199');
INSERT INTO job_position VALUES('1200','Ƹ//רԱ','Recruiting Manager/Supervisor/ Specialist','1012','200');
INSERT INTO job_position VALUES('1201','нʸ/','Compensation & Benefits Mgr./Supervisor','1012','201');
INSERT INTO job_position VALUES('1202','нʸרԱ/','Compensation & Benefits Specialist/Assistant','1012','202');
INSERT INTO job_position VALUES('1203','Ч˾//רԱ','Performance Check Manager/Supervisor/ Specialist','1012','203');
INSERT INTO job_position VALUES('1204','ѵ/','Training Manager/Supervisor','1012','204');
INSERT INTO job_position VALUES('1205','ѵרԱ/','Training Specialist/ Assistant','1012','205');
INSERT INTO job_position VALUES('1206','//칫','Administration Manager/ Supervisor/Office Manager','1012','206');
INSERT INTO job_position VALUES('1207','רԱ/','Administration Specialist/ Assistant','1012','207');
INSERT INTO job_position VALUES('1208','','Manager Assistant','1012','208');
INSERT INTO job_position VALUES('1209','','Executive Secretary','1012','209');
INSERT INTO job_position VALUES('1210','','Commercial Secretarial Clerk','1012','210');
INSERT INTO job_position VALUES('1211','ǰ̨Ӵ/ܻ','Front Reception/ Operator','1012','211');
INSERT INTO job_position VALUES('1212','','Logistics','1012','212');
INSERT INTO job_position VALUES('1213','ͼ鱨//ĵ','Library Information/ Facilities/Documents Manageme','1012','213');
INSERT INTO job_position VALUES('1214','ԲԱ/Ա','Computer Typist','1012','214');
INSERT INTO job_position VALUES('1215','','Others','1012','215');
INSERT INTO job_position VALUES('1216','ϯִй/ܾ','CEO/ General Manager','1013','216');
INSERT INTO job_position VALUES('1217','ܾ','Assistant GM','1013','217');
INSERT INTO job_position VALUES('1218','ܼ','Director','1013','218');
INSERT INTO job_position VALUES('1219','ϻ','Copartner','1013','219');
INSERT INTO job_position VALUES('1220','ܲ/ܲ/ܾ','President / Vice President /Assistant to General M','1013','220');
INSERT INTO job_position VALUES('1221','','Others','1013','221');
INSERT INTO job_position VALUES('1222','༭//׫','Editor/ Writer','1014','222');
INSERT INTO job_position VALUES('1223','','Reporter','1014','223');
INSERT INTO job_position VALUES('1224','У/¼','Proofreader/ Data Entry Staff','1014','224');
INSERT INTO job_position VALUES('1225','Ű','Layout Designer','1014','225');
INSERT INTO job_position VALUES('1226','/ܼ','Art/Design Director','1014','226');
INSERT INTO job_position VALUES('1227','ӰӲ߻/Ա','Movies & TV Planning/Programming Staff','1014','227');
INSERT INTO job_position VALUES('1228','','Director','1014','228');
INSERT INTO job_position VALUES('1229','Ӱʦ','Photographer','1014','229');
INSERT INTO job_position VALUES('1230','Чʦ/DJ','Sound Effect Controller / DJ','1014','230');
INSERT INTO job_position VALUES('1231','Ա/ģ/','Actor/Actress/ Model/Anchor person','1014','231');
INSERT INTO job_position VALUES('1232','','Announcer','1014','232');
INSERT INTO job_position VALUES('1233','ƽ/','Graphic Designer/Fine Arts Designer','1014','233');
INSERT INTO job_position VALUES('1234','ҵ/Ʒ','Industry Product Designer','1014','234');
INSERT INTO job_position VALUES('1235','Ʒ/鱦','Artwork/Jewelry Designer','1014','235');
INSERT INTO job_position VALUES('1236','װ/װ','Interior and Exterior Decoration/Upholstery Design','1014','236');
INSERT INTO job_position VALUES('1237','Ҿ','Furniture Designer','1014','237');
INSERT INTO job_position VALUES('1238','','Image Designer','1014','238');
INSERT INTO job_position VALUES('1239','赸','Dance Designer','1014','239');
INSERT INTO job_position VALUES('1240','','Others','1014','240');
INSERT INTO job_position VALUES('1241','ʦ','Lawyer','1015','241');
INSERT INTO job_position VALUES('1242','ʦ','Lawyers Assistant','1015','242');
INSERT INTO job_position VALUES('1243','ɹ','Counselor','1015','243');
INSERT INTO job_position VALUES('1244','','Justice Assistant','1015','244');
INSERT INTO job_position VALUES('1245','Ա','Clerk of the Court','1015','245');
INSERT INTO job_position VALUES('1246','','Others','1015','246');
INSERT INTO job_position VALUES('1247','׶','Early Childhood Education','1016','247');
INSERT INTO job_position VALUES('1248','Сѧѧ','Primary Education(Math)','1016','248');
INSERT INTO job_position VALUES('1249','Сѧģ','Primary Education(Chinese)','1016','249');
INSERT INTO job_position VALUES('1250','СѧӢ','Primary Education(English)','1016','250');
INSERT INTO job_position VALUES('1251','СѧȻ','Primary Education(Nature)','1016','251');
INSERT INTO job_position VALUES('1252','Сѧ','Primary Education(PE)','1016','252');
INSERT INTO job_position VALUES('1253','Сѧ֣','Primary Education(Music)','1016','253');
INSERT INTO job_position VALUES('1254','Сѧۺϣ','Primary Education(Integration)','1016','254');
INSERT INTO job_position VALUES('1255','Сѧ','Primary Education(Other)','1016','255');
INSERT INTO job_position VALUES('1256','еȽѧ','Secondary Education(Math)','1016','256');
INSERT INTO job_position VALUES('1257','еȽģ','Secondary Education(Chinese)','1016','257');
INSERT INTO job_position VALUES('1258','еȽ','Secondary Education(Physics)','1016','258');
INSERT INTO job_position VALUES('1259','еȽѧ','Secondary Education(Chemistry)','1016','259');
INSERT INTO job_position VALUES('1260','еȽ','Secondary Education(Biology)','1016','260');
INSERT INTO job_position VALUES('1261','еȽ','Secondary Education(Foreign Language )','1016','261');
INSERT INTO job_position VALUES('1262','еȽ','Secondary Education(Geography)','1016','262');
INSERT INTO job_position VALUES('1263','еȽʷ','Secondary Education(History)','1016','263');
INSERT INTO job_position VALUES('1264','еȽͱ','Secondary Education(PE & Health)','1016','264');
INSERT INTO job_position VALUES('1265','еȽ','Secondary Education(Computer)','1016','265');
INSERT INTO job_position VALUES('1266','еȽ֣','Secondary Education(Music)','1016','266');
INSERT INTO job_position VALUES('1267','еȽ','Secondary Education(Fine Arts)','1016','267');
INSERT INTO job_position VALUES('1268','еȽ˼Σ','Secondary Education(Ideology)','1016','268');
INSERT INTO job_position VALUES('1269','еȽѧ','Secondary Education(Electronics)','1016','269');
INSERT INTO job_position VALUES('1270','еȽе','Secondary Education(Machinery)','1016','270');
INSERT INTO job_position VALUES('1271','еȽ','Secondary Education(Chemical Industry)','1016','271');
INSERT INTO job_position VALUES('1272','еȽʳƷ','Secondary Education(Food)','1016','272');
INSERT INTO job_position VALUES('1273','еȽ⿣','Secondary Education(Cuisine)','1016','273');
INSERT INTO job_position VALUES('1274','еȽʻ','Secondary Education(Driving)','1016','274');
INSERT INTO job_position VALUES('1275','еȽװ','Secondary Education(Clothing)','1016','275');
INSERT INTO job_position VALUES('1276','еȽװ꣩','Secondary Education(Decoration)','1016','276');
INSERT INTO job_position VALUES('1277','еȽ','Secondary Education(Architecture)','1016','277');
INSERT INTO job_position VALUES('1278','еȽũѧ','Secondary Education(Agriculture)','1016','278');
INSERT INTO job_position VALUES('1279','еȽѧ','Secondary Education(Forestry)','1016','279');
INSERT INTO job_position VALUES('1280','еȽ','Secondary Education(Animal Husbandry)','1016','280');
INSERT INTO job_position VALUES('1281','еȽֳ','Secondary Education(Aquaculture)','1016','281');
INSERT INTO job_position VALUES('1282','еȽڣ','Secondary Education(Finance )','1016','282');
INSERT INTO job_position VALUES('1283','еȽƻᣩ','Secondary Education(Accounting)','1016','283');
INSERT INTO job_position VALUES('1284','еȽ','Secondary Education(Educational Technology)','1016','284');
INSERT INTO job_position VALUES('1285','еȽҽѧ','Secondary Education(Medical Nursing)','1016','285');
INSERT INTO job_position VALUES('1286','еȽأ','Secondary Education(Secretary)','1016','286');
INSERT INTO job_position VALUES('1287','еȽݣ','Secondary Education(Acting)','1016','287');
INSERT INTO job_position VALUES('1288','еȽۺϣ','Secondary Education(Integration)','1016','288');
INSERT INTO job_position VALUES('1289','еȽ','Secondary Education(Others)','1016','289');
INSERT INTO job_position VALUES('1290','ߵȽ','Higher Education(Computer)','1016','290');
INSERT INTO job_position VALUES('1291','ߵȽѧ','Higher Education(Electronics)','1016','291');
INSERT INTO job_position VALUES('1292','ߵȽ΢ӣ','Higher Education(Microelectronics)','1016','292');
INSERT INTO job_position VALUES('1293','ߵȽе','Higher Education(Machinery)','1016','293');
INSERT INTO job_position VALUES('1294','ߵȽ','Higher Education(Chemical Industry)','1016','294');
INSERT INTO job_position VALUES('1295','ߵȽʳƷ','Higher Education(Food)','1016','295');
INSERT INTO job_position VALUES('1296','ߵȽ','Higher Education(Biology)','1016','296');
INSERT INTO job_position VALUES('1297','ߵȽװ','Higher Education(Clothing)','1016','297');
INSERT INTO job_position VALUES('1298','ߵȽ','Higher Education(Architecture)','1016','298');
INSERT INTO job_position VALUES('1299','ߵȽũѧ','Higher Education(Agriculture)','1016','299');
INSERT INTO job_position VALUES('1300','ߵȽѧ','Higher Education(Forestry)','1016','300');
INSERT INTO job_position VALUES('1301','ߵȽ','Higher Education(Animal Husbandry)','1016','301');
INSERT INTO job_position VALUES('1302','ߵȽˮ','Higher Education(Aquaculture)','1016','302');
INSERT INTO job_position VALUES('1303','ߵȽңУ','Higher Education(Remote Sensing)','1016','303');
INSERT INTO job_position VALUES('1304','ߵȽ','Higher Education(Management)','1016','304');
INSERT INTO job_position VALUES('1305','ߵȽѧ','Higher Education(Math)','1016','305');
INSERT INTO job_position VALUES('1306','ߵȽѧ','Higher Education(Physics)','1016','306');
INSERT INTO job_position VALUES('1307','ߵȽѧ','Higher Education(Chemistry)','1016','307');
INSERT INTO job_position VALUES('1308','ߵȽй滮','Higher Education(Urban Planning)','1016','308');
INSERT INTO job_position VALUES('1309','ߵȽӢ','Higher Education(English)','1016','309');
INSERT INTO job_position VALUES('1310','ߵȽ','Higher Education(French)','1016','310');
INSERT INTO job_position VALUES('1311','ߵȽ','Higher Education(Japanese)','1016','311');
INSERT INTO job_position VALUES('1312','ߵȽ','Higher Education(Germany)','1016','312');
INSERT INTO job_position VALUES('1313','ߵȽ','Higher Education(Russian)','1016','313');
INSERT INTO job_position VALUES('1314','ߵȽ','Higher Education(Spanish)','1016','314');
INSERT INTO job_position VALUES('1315','ߵȽ','Higher Education(Other Foreign Languages)','1016','315');
INSERT INTO job_position VALUES('1316','ߵȽѧ','Higher Education(Law)','1016','316');
INSERT INTO job_position VALUES('1317','ߵȽѧ','Higher Education(Economics)','1016','317');
INSERT INTO job_position VALUES('1318','ߵȽѧ','Higher Education(Journalism)','1016','318');
INSERT INTO job_position VALUES('1319','ߵȽѧ','Higher Education(Psychology)','1016','319');
INSERT INTO job_position VALUES('1320','ߵȽѧ','Higher Education(Philosophy)','1016','320');
INSERT INTO job_position VALUES('1321','ߵȽѧ','Higher Education(Literature)','1016','321');
INSERT INTO job_position VALUES('1322','ߵȽʷѧ','Higher Education(History)','1016','322');
INSERT INTO job_position VALUES('1323','ߵȽѧ','Higher Education(Archaeology)','1016','323');
INSERT INTO job_position VALUES('1324','ߵȽѧ','Higher Education(Chinese Language)','1016','324');
INSERT INTO job_position VALUES('1325','ߵȽ','Higher Education(Educational Technology)','1016','325');
INSERT INTO job_position VALUES('1326','ߵȽٴҽѧ','Higher Education(Basic Medicine)','1016','326');
INSERT INTO job_position VALUES('1327','ߵȽҽѧ','Higher Education(Basic Medicine)','1016','327');
INSERT INTO job_position VALUES('1328','ߵȽҽѧѧ','Higher Education(Medical Immunology)','1016','328');
INSERT INTO job_position VALUES('1329','ߵȽѧ','Higher Education(Surgery)','1016','329');
INSERT INTO job_position VALUES('1330','ߵȽڿѧ','Higher Education(Internal medicine)','1016','330');
INSERT INTO job_position VALUES('1331','ߵȽǵԷף','Higher Education(SARS)','1016','331');
INSERT INTO job_position VALUES('1332','ߵȽҽѧ','Higher Education(Chinese Medicine)','1016','332');
INSERT INTO job_position VALUES('1333','ߵȽ뽡','Higher Education(PE and Health)','1016','333');
INSERT INTO job_position VALUES('1334','ߵȽѧ','Higher Education(Philosophy)','1016','334');
INSERT INTO job_position VALUES('1335','ߵȽ','Higher Education(Fine Arts)','1016','335');
INSERT INTO job_position VALUES('1336','ߵȽ֣','Higher Education(Music)','1016','336');
INSERT INTO job_position VALUES('1337','ߵȽϷ','Higher Education(Opera)','1016','337');
INSERT INTO job_position VALUES('1338','ߵȽ赸','Higher Education(Dance)','1016','338');
INSERT INTO job_position VALUES('1339','ߵȽ','Higher Education(Others)','1016','339');
INSERT INTO job_position VALUES('1340','ѧ/Ա','Teaching/ Academic Affairs Manager','1016','340');
INSERT INTO job_position VALUES('1341','ҽ','Home Tutor','1016','341');
INSERT INTO job_position VALUES('1342','ҵڲѵ','Enterprise Trainer','1016','342');
INSERT INTO job_position VALUES('1343','ʦ','Others','1016','343');
INSERT INTO job_position VALUES('1344','ڿҽʦ ','Physician','1017','344');
INSERT INTO job_position VALUES('1345','ҽʦ','Surgeon','1017','345');
INSERT INTO job_position VALUES('1346','ҽʦ','Pediatrician','1017','346');
INSERT INTO job_position VALUES('1347','ҽʦ','Obstetrician-gynecologist','1017','347');
INSERT INTO job_position VALUES('1348','ۿҽʦ','Oculist','1017','348');
INSERT INTO job_position VALUES('1349','Ǻҽʦ','E.N.T. Doctor','1017','349');
INSERT INTO job_position VALUES('1350','ǻҽʦ','Stomatologist','1017','350');
INSERT INTO job_position VALUES('1351','Ƥҽʦ','Dermatologist','1017','351');
INSERT INTO job_position VALUES('1352','ҽʦ','Psychiatrist','1017','352');
INSERT INTO job_position VALUES('1353','ҽʦ','Psychiatrist','1017','353');
INSERT INTO job_position VALUES('1354','Ⱦҽʦ','Infectious Disease Doctor','1017','354');
INSERT INTO job_position VALUES('1355','ҽʦ','Emergency Doctor','1017','355');
INSERT INTO job_position VALUES('1356','ҽʦ','Rehabilitation Doctor','1017','356');
INSERT INTO job_position VALUES('1357','ҽʦ','Analgesist','1017','357');
INSERT INTO job_position VALUES('1358','ҽʦ','Pathology Doctor','1017','358');
INSERT INTO job_position VALUES('1359','ҽʦ','Radiologist','1017','359');
INSERT INTO job_position VALUES('1360','ҽѧҽʦ','Nuclear Medicine Doctor','1017','360');
INSERT INTO job_position VALUES('1361','Ͽҽʦ','Ultrasonic Diagnosis Doctor','1017','361');
INSERT INTO job_position VALUES('1362','ҽʦ','Radiation Oncology Doctor','1017','362');
INSERT INTO job_position VALUES('1363','ҽʦ','Plastic Surgery Doctor','1017','363');
INSERT INTO job_position VALUES('1364','ȫҽʦ','Generalist','1017','364');
INSERT INTO job_position VALUES('1365','ҽʦ','Country Doctor','1017','365');
INSERT INTO job_position VALUES('1366','ױҽʦ','Maternity and Child Care Doctor','1017','366');
INSERT INTO job_position VALUES('1367','(ɹ)Ѫҽʦ','Blood Collecting and Supply Doctor','1017','367');
INSERT INTO job_position VALUES('1368','ҽҽʦ','Other Western Medical Doctor','1017','368');
INSERT INTO job_position VALUES('1369','ҽڿҽʦ','Traditional Chinese Medicine Physician','1017','369');
INSERT INTO job_position VALUES('1370','ҽҽʦ','Traditional Chinese Medicine Surgeon','1017','370');
INSERT INTO job_position VALUES('1371','ҽҽʦ','Traditional Chinese Medicine Gynecologist','1017','371');
INSERT INTO job_position VALUES('1372','ҽҽʦ','Traditional Chinese Medicine Pediatrician','1017','372');
INSERT INTO job_position VALUES('1373','Ͷ(ְҵ)ҽʦ','Occupational Health Doctor','1017','373');
INSERT INTO job_position VALUES('1374','ҽۿҽʦ','Traditional Chinese Medicine Oculist','1017','374');
INSERT INTO job_position VALUES('1375','ҽʦ','Radiohygiene Doctor','1017','375');
INSERT INTO job_position VALUES('1376','ҽƤҽʦ','Traditional Chinese Medicine Dermatologist','1017','376');
INSERT INTO job_position VALUES('1377','ٶѧУҽʦ','Children and School Health Doctor','1017','377');
INSERT INTO job_position VALUES('1378','ҽ˿ҽʦ','Traditional Chinese Medicine Traumatology & Orthop','1017','378');
INSERT INTO job_position VALUES('1379','ҽسҽʦ','Traditional Chinese Medicine Anus and Intestine Do','1017','379');
INSERT INTO job_position VALUES('1380','ҽǺҽʦ','Traditional Chinese Medicine E.N.T. Doctor','1017','380');
INSERT INTO job_position VALUES('1381','Ŀҽʦ','Chinese Acuponcture & Moxibustion Doctor','1017','381');
INSERT INTO job_position VALUES('1382','ðĦҽʦ','Massage Doctor','1017','382');
INSERT INTO job_position VALUES('1383','ҽҽʦ','Other Traditional Chinese Medicine Doctor','1017','383');
INSERT INTO job_position VALUES('1384','ҽҽʦ','Integrated Traditional Chinese and Western Medicin','1017','384');
INSERT INTO job_position VALUES('1385','ҽʦ','Nationality Doctor','1017','385');
INSERT INTO job_position VALUES('1386','вѧҽʦ','Epidemiologist','1017','386');
INSERT INTO job_position VALUES('1387','ӪʳƷҽʦ','Nutrition and Food Health Doctor','1017','387');
INSERT INTO job_position VALUES('1388','ҽʦ','Environmental Sanitation Doctor','1017','388');
INSERT INTO job_position VALUES('1389','ְҵҽʦ','Occupational Disease Doctor','1017','389');
INSERT INTO job_position VALUES('1390','ҩʦ','Western Medicine Pharmacist','1017','390');
INSERT INTO job_position VALUES('1391','ҩʦ','Traditional Chinese Medicine Pharmacist','1017','391');
INSERT INTO job_position VALUES('1392','ҩԱ','Other Pharmacists','1017','392');
INSERT INTO job_position VALUES('1393','Ӱʦ','Imaging Technician','1017','393');
INSERT INTO job_position VALUES('1394','ʦ','Anesthesia Technician','1017','394');
INSERT INTO job_position VALUES('1395','ʦ',' Pathology Technician','1017','395');
INSERT INTO job_position VALUES('1396','ٴ鼼ʦ','Clinical Test Technician','1017','396');
INSERT INTO job_position VALUES('1397','鼼ʦ','Public Health Test Technician','1017','397');
INSERT INTO job_position VALUES('1398','̼ʦ','Sanitary Engineering Technician','1017','398');
INSERT INTO job_position VALUES('1399','䣨ɹѪʦ','Blood Collecting and Supply Technician','1017','399');
INSERT INTO job_position VALUES('1400','ҽƼԱ','Other Medical Technician','1017','400');
INSERT INTO job_position VALUES('1401','ʿ','Ward Nurse','1017','401');
INSERT INTO job_position VALUES('1402','ﻤʿ','Clinic Nurse','1017','402');
INSERT INTO job_position VALUES('1403','ﻤʿ','Emergency Nurse','1017','403');
INSERT INTO job_position VALUES('1404','һʿ','Operating Nurse','1017','404');
INSERT INTO job_position VALUES('1405','Ӧһʿ','Supply Nurse','1017','405');
INSERT INTO job_position VALUES('1406','ʿ','Community Nurse','1017','406');
INSERT INTO job_position VALUES('1407','ʿ','Midwife','1017','407');
INSERT INTO job_position VALUES('1408','Ա','Other Nurses','1017','408');
INSERT INTO job_position VALUES('1409','רҵԱ','Other Health Technicians','1017','409');
INSERT INTO job_position VALUES('1410','ҽѧԱ','Medical Management','1017','410');
INSERT INTO job_position VALUES('1411','ҽҩԱ','Medicine Technician','1017','411');
INSERT INTO job_position VALUES('1412','ױ/ʦ','Cosmetician /Beautician','1017','412');
INSERT INTO job_position VALUES('1413','','Sanitation and Epidemic Prevention','1017','413');
INSERT INTO job_position VALUES('1414','ҽ/ҽ','Veterinarian/ Pet Doctor','1017','414');
INSERT INTO job_position VALUES('1415','ҽԱ','Other Health and Medical Staff','1017','415');
INSERT INTO job_position VALUES('1416','רҵ','Professional Adviser','1018','416');
INSERT INTO job_position VALUES('1417','ѯܼ','Consulting Director','1018','417');
INSERT INTO job_position VALUES('1418','ѯ','Consulting Manager','1018','418');
INSERT INTO job_position VALUES('1419','ѯԱ','Advisory','1018','419');
INSERT INTO job_position VALUES('1420','','Others','1018','420');
INSERT INTO job_position VALUES('1421','Уѧ()','Students (Engineering)','1019','421');
INSERT INTO job_position VALUES('1422','Уѧ()','Students (Science)','1019','422');
INSERT INTO job_position VALUES('1423','Уѧ(Ŀ)','Students (Liberal Art)','1019','423');
INSERT INTO job_position VALUES('1424','Уѧ(Ӫ)','Students(Sales)','1019','424');
INSERT INTO job_position VALUES('1425','Уѧ()','Students(Art)','1019','425');
INSERT INTO job_position VALUES('1426','Уѧ()','Students(Management)','1019','426');
INSERT INTO job_position VALUES('1427','Уѧ(ʦ)','Students(Normal)','1019','427');
INSERT INTO job_position VALUES('1428','Уѧ()','Students(PE)','1019','428');
INSERT INTO job_position VALUES('1429','Ӧҵ()','Graduating Students(Engineering)','1019','429');
INSERT INTO job_position VALUES('1430','Ӧҵ()','Graduating Students(Science)','1019','430');
INSERT INTO job_position VALUES('1431','Ӧҵ(Ŀ)','Graduating Students(Liberal Art)','1019','431');
INSERT INTO job_position VALUES('1432','Ӧҵ(Ӫ)','Graduating Students(Sales)','1019','432');
INSERT INTO job_position VALUES('1433','Ӧҵ()','Graduating Students(Art)','1019','433');
INSERT INTO job_position VALUES('1434','Ӧҵ()','Graduating Students(Management)','1019','434');
INSERT INTO job_position VALUES('1435','Ӧҵ(ʦ)','Graduating Students(Normal)','1019','435');
INSERT INTO job_position VALUES('1436','Ӧҵ()','Graduating Students(PE)','1019','436');
INSERT INTO job_position VALUES('1437','ʵϰ()','Interns(Engineering)','1019','437');
INSERT INTO job_position VALUES('1438','ʵϰ()','Interns(Science)','1019','438');
INSERT INTO job_position VALUES('1439','ʵϰ(Ŀ)','Interns(Liberal Art)','1019','439');
INSERT INTO job_position VALUES('1440','ʵϰ(Ӫ)','Interns(Sales)','1019','440');
INSERT INTO job_position VALUES('1441','ʵϰ()','Interns(Art)','1019','441');
INSERT INTO job_position VALUES('1442','ʵϰ()','Interns(Management)','1019','442');
INSERT INTO job_position VALUES('1443','ʵϰ(ʦ)','Interns(Normal)','1019','443');
INSERT INTO job_position VALUES('1444','ʵϰ()','Interns(PE)','1019','444');
INSERT INTO job_position VALUES('1445','','Others','1019','445');
INSERT INTO job_position VALUES('1446','ѵ','Trained Person','1020','446');
INSERT INTO job_position VALUES('1447','/','Beauty/Exercise Adviser','1021','447');
INSERT INTO job_position VALUES('1448','/־','Food & Beverage / Amusement Manager','1021','448');
INSERT INTO job_position VALUES('1449','/Ƶ꾭','Hotel Manager','1021','449');
INSERT INTO job_position VALUES('1450','','Head Waiter','1021','450');
INSERT INTO job_position VALUES('1451','Ա','Attendant','1021','451');
INSERT INTO job_position VALUES('1452','ӪҵԱ/Ա/Ա','Salesman/Cashier/ Stockman','1021','452');
INSERT INTO job_position VALUES('1453','ʦ','Cook','1021','453');
INSERT INTO job_position VALUES('1454','','Tourist Guide','1021','454');
INSERT INTO job_position VALUES('1455','˾','Driver','1021','455');
INSERT INTO job_position VALUES('1456','','Security Guard','1021','456');
INSERT INTO job_position VALUES('1457','ѰԱ/Ա','Paging Person / Telephonist','1021','457');
INSERT INTO job_position VALUES('1458','','Others','1021','458');
INSERT INTO job_position VALUES('1459','ƹʦ','Architectural Design Engineer','1022','459');
INSERT INTO job_position VALUES('1460','ṹ/ʦ','Structural / Civil Engineer','1022','460');
INSERT INTO job_position VALUES('1461','·ƹʦ','Highway and Bridge Design Engineer','1022','461');
INSERT INTO job_position VALUES('1462','·̼Ա','Road Construction Engineering Technician','1022','462');
INSERT INTO job_position VALUES('1463','ۿ뺽ʦ','Harbours and Water Channels Engineer','1022','463');
INSERT INTO job_position VALUES('1464','̼Ա','Airport Engineering Technician','1022','464');
INSERT INTO job_position VALUES('1465','ʦ','Electrical Engineer','1022','465');
INSERT INTO job_position VALUES('1466','ˮ/ůͨʦ','Drainage/ HVAC Engineer','1022','466');
INSERT INTO job_position VALUES('1467','ʦ/Ԥ','Budgeting Specialist/Budgeter','1022','467');
INSERT INTO job_position VALUES('1468','̹','Construction Manager','1022','468');
INSERT INTO job_position VALUES('1469','̼','Construction Supervisor','1022','469');
INSERT INTO job_position VALUES('1470','װ','Interior and Exterior Decoration Designer','1022','470');
INSERT INTO job_position VALUES('1471','װ','Interior and Exterior Decoration','1022','471');
INSERT INTO job_position VALUES('1472','й滮','Urban Planning and Design','1022','472');
INSERT INTO job_position VALUES('1473','ͼ','Architectural Drawer','1022','473');
INSERT INTO job_position VALUES('1474','ʩԱ','Builder Technician','1022','474');
INSERT INTO job_position VALUES('1475','ز/߻','Real Estate Development and Planning Staff','1022','475');
INSERT INTO job_position VALUES('1476','ز','Real Estate Appraisal','1022','476');
INSERT INTO job_position VALUES('1477','زн/','Real Estate Agent/Trade','1022','477');
INSERT INTO job_position VALUES('1478','ҵ','Property Management','1022','478');
INSERT INTO job_position VALUES('1479','羰԰ֹ̼Ա','Landscape Engineering Technician','1022','479');
INSERT INTO job_position VALUES('1480','ˮˮ罨̼Ա','Water Conservancy and Hydropower Engineering Techn','1022','480');
INSERT INTO job_position VALUES('1481','ι̼Ա','Silicate Engineering Technician','1022','481');
INSERT INTO job_position VALUES('1482','ǽƷ̼Ա','Nonmetallic Minerals and Its Products Engineering ','1022','482');
INSERT INTO job_position VALUES('1483','޻ǽ²Ϲ̼Ա','Inorganic Nonmetallic Materials Engineering Techni','1022','483');
INSERT INTO job_position VALUES('1484','','Others','1022','484');
INSERT INTO job_position VALUES('1485','Ӣ﷭','English Translator','1023','485');
INSERT INTO job_position VALUES('1486','﷭','Russian Translator','1023','486');
INSERT INTO job_position VALUES('1487','﷭','German Translator','1023','487');
INSERT INTO job_position VALUES('1488','﷭','French Translator','1023','488');
INSERT INTO job_position VALUES('1489','﷭','Spanish Translator','1023','489');
INSERT INTO job_position VALUES('1490','﷭','Arabic Translator','1023','490');
INSERT INTO job_position VALUES('1491','﷭','Japanese Translator','1023','491');
INSERT INTO job_position VALUES('1492','˹﷭','Farsi Translator','1023','492');
INSERT INTO job_position VALUES('1493','﷭','Korean Translator','1023','493');
INSERT INTO job_position VALUES('1494','ɱ﷭','Tagalog Translator','1023','494');
INSERT INTO job_position VALUES('1495','﷭','Sanskrit and Pali Translator','1023','495');
INSERT INTO job_position VALUES('1496','ӡ﷭','Indonesian Translator','1023','496');
INSERT INTO job_position VALUES('1497','ӡ﷭','Hindi Translator','1023','497');
INSERT INTO job_position VALUES('1498','կ﷭','Kampuchean Translator','1023','498');
INSERT INTO job_position VALUES('1499','﷭','Lao Translator','1023','499');
INSERT INTO job_position VALUES('1500','﷭','Burmese Translator','1023','500');
INSERT INTO job_position VALUES('1501','﷭','Malay Translator','1023','501');
INSERT INTO job_position VALUES('1502','ɹ﷭','Mongolian Translator','1023','502');
INSERT INTO job_position VALUES('1503','ɮ﷭','Singhalese Translator','1023','503');
INSERT INTO job_position VALUES('1504','̩﷭','Thai Translator','1023','504');
INSERT INTO job_position VALUES('1505','ڶ﷭','Urdu Translator','1023','505');
INSERT INTO job_position VALUES('1506','ϣ﷭','Rabbini Translator','1023','506');
INSERT INTO job_position VALUES('1507','Խ﷭','Vietnamese Translator','1023','507');
INSERT INTO job_position VALUES('1508','﷭','Chadic Translator','1023','508');
INSERT INTO job_position VALUES('1509','˹ϣ﷭','Swahili Translator','1023','509');
INSERT INTO job_position VALUES('1510','﷭','Albanian Translator','1023','510');
INSERT INTO job_position VALUES('1511','﷭','Bulgarian Translator','1023','511');
INSERT INTO job_position VALUES('1512','﷭','Polish Translator','1023','512');
INSERT INTO job_position VALUES('1513','ݿ﷭','Czech Translator','1023','513');
INSERT INTO job_position VALUES('1514','﷭','Romanian Translator','1023','514');
INSERT INTO job_position VALUES('1515','﷭','Portuguese Translator','1023','515');
INSERT INTO job_position VALUES('1516','﷭','Swedish Translator','1023','516');
INSERT INTO job_position VALUES('1517','ά?޵﷭','Serbo ? Croatian Translator','1023','517');
INSERT INTO job_position VALUES('1518','﷭','Turkish Translator','1023','518');
INSERT INTO job_position VALUES('1519','ϣ﷭','Greek Translator','1023','519');
INSERT INTO job_position VALUES('1520','﷭','Mungarian Translator','1023','520');
INSERT INTO job_position VALUES('1521','﷭','Italian Translator','1023','521');
INSERT INTO job_position VALUES('1522','ַ','Other Translators','1023','522');
INSERT INTO job_position VALUES('1523','ɴʦ','Textile Engineer','1024','523');
INSERT INTO job_position VALUES('1524','֯칤ʦ','Weaving Engineer','1024','524');
INSERT INTO job_position VALUES('1525','Ⱦʦ','Dyeing and Finishing Engineer','1024','525');
INSERT INTO job_position VALUES('1526','װʦ','Clothing Designer','1024','526');
INSERT INTO job_position VALUES('1527','װʦ','Assistant Clothing Designer','1024','527');
INSERT INTO job_position VALUES('1528','ʦ','Fabric Designer','1024','528');
INSERT INTO job_position VALUES('1529','ƤＰƤëʦ','Leather and Fur Technologist','1024','529');
INSERT INTO job_position VALUES('1530','֯еĹʦ','Textile Machinery Engineer','1024','530');
INSERT INTO job_position VALUES('1531','װʦ','Clothing Technologist','1024','531');
INSERT INTO job_position VALUES('1532','װCAD/CAM','Clothing CAD/CAM','1024','532');
INSERT INTO job_position VALUES('1533','ưʦ','Plate-maker','1024','533');
INSERT INTO job_position VALUES('1534','װʦ','Clothing Displayer','1024','534');
INSERT INTO job_position VALUES('1535','ʦ','Pattern Cutter','1024','535');
INSERT INTO job_position VALUES('1536','巿','Pattern Room Supervisor','1024','536');
INSERT INTO job_position VALUES('1537','ӡȾ','Dyeing and Printing Worker','1024','537');
INSERT INTO job_position VALUES('1538','֯ô','Knitting Cutter','1024','538');
INSERT INTO job_position VALUES('1539','װ','Proofing Worker','1024','539');
INSERT INTO job_position VALUES('1540','ҹ','Sewer','1024','540');
INSERT INTO job_position VALUES('1541','ü','Cutting Worker','1024','541');
INSERT INTO job_position VALUES('1542','̹','Pressing Worker','1024','542');
INSERT INTO job_position VALUES('1543','ƽλ','Flat Machine Worker','1024','543');
INSERT INTO job_position VALUES('1544','װ','Pattern Sewer','1024','544');
INSERT INTO job_position VALUES('1545','ֽŰԱ','Pattern Composition Staff','1024','545');
INSERT INTO job_position VALUES('1546','λԱ','Flat Machine Staff','1024','546');
INSERT INTO job_position VALUES('1547','װģ','Model','1024','547');
INSERT INTO job_position VALUES('1548','װר곤','Clothes Shop Manager','1024','548');
INSERT INTO job_position VALUES('1549','װ˲/','Clothes Leaguing Department Supervisor/Manager','1024','549');
INSERT INTO job_position VALUES('1550','װƷƲ/','Clothes Brand Department Supervisor/Manager','1024','550');
INSERT INTO job_position VALUES('1551','װڲ/','Clothes Export Department Supervisor/Manager','1024','551');
INSERT INTO job_position VALUES('1552','֯װQC','Textile and Garment QC','1024','552');
INSERT INTO job_position VALUES('1553','֯װ','Others ','1024','553');
INSERT INTO job_position VALUES('1554','ʵ鹤ʦ','Chemical Industry Experiment Engineer','1025','554');
INSERT INTO job_position VALUES('1555','ƹʦ','Chemical Industry Design Engineer','1025','555');
INSERT INTO job_position VALUES('1556','ʦ','Chemical Production Engineer','1025','556');
INSERT INTO job_position VALUES('1557','ԭ׼','Industry Material Preparation Operator','1025','557');
INSERT INTO job_position VALUES('1558','ѹ','Compressor Operator','1025','558');
INSERT INTO job_position VALUES('1559','徻','Gas Purification Operator','1025','559');
INSERT INTO job_position VALUES('1560','˹','Filter Operator','1025','560');
INSERT INTO job_position VALUES('1561','ͼȹ','Oil Heating Operator','1025','561');
INSERT INTO job_position VALUES('1562','乤','Refrigeration Operator','1025','562');
INSERT INTO job_position VALUES('1563','','Evaporation Operator','1025','563');
INSERT INTO job_position VALUES('1564','','Distillation Operator','1025','564');
INSERT INTO job_position VALUES('1565','ȡ','Extraction Operator','1025','565');
INSERT INTO job_position VALUES('1566','չ','Absorption Operator','1025','566');
INSERT INTO job_position VALUES('1567','','Absorption Operator','1025','567');
INSERT INTO job_position VALUES('1568','﹤','Drying Operator','1025','568');
INSERT INTO job_position VALUES('1569','ᾧ','Crystallization Operator','1025','569');
INSERT INTO job_position VALUES('1570','','Granulation Operator','1025','570');
INSERT INTO job_position VALUES('1571','ʴ','Corrosion Protection Operator','1025','571');
INSERT INTO job_position VALUES('1572','鹤','Chemical Process Tester','1025','572');
INSERT INTO job_position VALUES('1573','ܿع','Chemical Industry General Controller','1025','573');
INSERT INTO job_position VALUES('1574','ȼ','Fuel Oil Producer','1025','574');
INSERT INTO job_position VALUES('1575','֬͡','Lubricant Producer','1025','575');
INSERT INTO job_position VALUES('1576','ʯͲƷƹ','Petroleum Product Refiner','1025','576');
INSERT INTO job_position VALUES('1577','','Oil Gas Producer','1025','577');
INSERT INTO job_position VALUES('1578','úɸ','Coal Preparing and Screening Worker','1025','578');
INSERT INTO job_position VALUES('1579','¯¹','Coke Oven Temperature Controller','1025','579');
INSERT INTO job_position VALUES('1580','¯˾','Coke Oven Engine Driver','1025','580');
INSERT INTO job_position VALUES('1581','ú','Coal Gas Producer','1025','581');
INSERT INTO job_position VALUES('1582','ȼ˹','Fuel Gas Storage and Transport Worker','1025','582');
INSERT INTO job_position VALUES('1583','ϳɰ','Synthetic Ammonia Producer','1025','583');
INSERT INTO job_position VALUES('1584','','Urea Producer','1025','584');
INSERT INTO job_position VALUES('1585','','Ammonium Nitrate Producer','1025','585');
INSERT INTO job_position VALUES('1586','̼','Ammonium Bicarbonate Producer','1025','586');
INSERT INTO job_position VALUES('1587','','Ammonium Sulfate Producer','1025','587');
INSERT INTO job_position VALUES('1588','','Superphosphate Producer','1025','588');
INSERT INTO job_position VALUES('1589','׷','Compound Phosphoric Fertilizer Producer','1025','589');
INSERT INTO job_position VALUES('1590','þ׷','Ca & Mg Phosphoric Fertilizer Producer','1025','590');
INSERT INTO job_position VALUES('1591','Ȼ','Potassium Chloride Producer','1025','591');
INSERT INTO job_position VALUES('1592','΢Ԫػ','Microelement Mixed Fertilizer Producer','1025','592');
INSERT INTO job_position VALUES('1593','','Sulphuric Acid Producer','1025','593');
INSERT INTO job_position VALUES('1594','','Nitric Acid Producer','1025','594');
INSERT INTO job_position VALUES('1595','','Muriatic Acid Producer','1025','595');
INSERT INTO job_position VALUES('1596','','Phosphoric Acid Producer','1025','596');
INSERT INTO job_position VALUES('1597','','Soda Producer','1025','597');
INSERT INTO job_position VALUES('1598','ռ','Caustic Soda Producer','1025','598');
INSERT INTO job_position VALUES('1599','','Fluoride Salt Producer','1025','599');
INSERT INTO job_position VALUES('1600','','Condensed Phosphate Producer','1025','600');
INSERT INTO job_position VALUES('1601','޻ѧӦ','Inorganic Chemical Reaction Worker','1025','601');
INSERT INTO job_position VALUES('1602','Ƶӹ','High-frequency Plasma Worker','1025','602');
INSERT INTO job_position VALUES('1603','빤','Gas Cryogenic Separating Worker','1025','603');
INSERT INTO job_position VALUES('1604','ҵҺ','Industry Gas Liquefying Worker','1025','604');
INSERT INTO job_position VALUES('1605','̿칤','Charcoal Black Producer','1025','605');
INSERT INTO job_position VALUES('1606','ϩ','Polyethylene Producer','1025','606');
INSERT INTO job_position VALUES('1607','۱ϩ','Polypropylene Producer','1025','607');
INSERT INTO job_position VALUES('1608','۱ϩ','Polystyrene Producer','1025','608');
INSERT INTO job_position VALUES('1609','۶ϩ','Polybutadiene Producer','1025','609');
INSERT INTO job_position VALUES('1610','ϩ','PVC Producer','1025','610');
INSERT INTO job_position VALUES('1611','֬','Araldite Producer','1025','611');
INSERT INTO job_position VALUES('1612','ϩ-ϩ-ϩABS','ABS Producer','1025','612');
INSERT INTO job_position VALUES('1613','˳','Cis1,4polybutadiene Rubber Producer','1025','613');
INSERT INTO job_position VALUES('1614','ұ','Ethylene Propylene Rubber Producer','1025','614');
INSERT INTO job_position VALUES('1615','','Isoprene Producer','1025','615');
INSERT INTO job_position VALUES('1616','','Nitrile-butadiene Rubber Producer','1025','616');
INSERT INTO job_position VALUES('1617','','Styrene Butadiene Rubber Producer','1025','617');
INSERT INTO job_position VALUES('1618','ȶ','Neoprene Producer','1025','618');
INSERT INTO job_position VALUES('1619','˾ۺϹ','Polymerization Worker','1025','619');
INSERT INTO job_position VALUES('1620','ʪҺ칤','','1025','620');
INSERT INTO job_position VALUES('1621','˿','Spinner','1025','621');
INSERT INTO job_position VALUES('1622','˺','Chemical Fiber After-treating Worker','1025','622');
INSERT INTO job_position VALUES('1623','˿ԡҺƹ','Precipitated Coagulating Bath Liquid Mixer','1025','623');
INSERT INTO job_position VALUES('1624','޷Ĳ칤','Non-Woven Fabric Producer','1025','624');
INSERT INTO job_position VALUES('1625','˷˿','Chemical Fiber Precision Component Worker','1025','625');
INSERT INTO job_position VALUES('1626','ϳɸ칤','Synthetic Leather Producer','1025','626');
INSERT INTO job_position VALUES('1627','лϳɹ','Organic Synthesis Worker','1025','627');
INSERT INTO job_position VALUES('1628','ũҩ鹤','Pesticide Tester','1025','628');
INSERT INTO job_position VALUES('1629','й鹤','Sensitive Material Tester','1025','629');
INSERT INTO job_position VALUES('1630','Ⱦϱ׼','Dye Standard Worker','1025','630');
INSERT INTO job_position VALUES('1631','칤','Cassette Producer','1025','631');
INSERT INTO job_position VALUES('1632','ȾӦ鹤','Dye Application Tester','1025','632');
INSERT INTO job_position VALUES('1633','Ⱦƴ칤','Dye Mixer','1025','633');
INSERT INTO job_position VALUES('1634','ĥɢ','Grinding and Separating Worker','1025','634');
INSERT INTO job_position VALUES('1635','߻鹤','Activator Tester','1025','635');
INSERT INTO job_position VALUES('1636','߻Թ','Activator Worker','1025','636');
INSERT INTO job_position VALUES('1637','ͿϺϳ֬','Dope Vinylite Worker','1025','637');
INSERT INTO job_position VALUES('1638','ɫƹ','Lacquer Colour Mixer','1025','638');
INSERT INTO job_position VALUES('1639','ܼ칤','Solvent Producer','1025','639');
INSERT INTO job_position VALUES('1640','ѧȼ칤','Chemical Preparation Producer','1025','640');
INSERT INTO job_position VALUES('1641','Ӽ칤','Chemical Additive Producer','1025','641');
INSERT INTO job_position VALUES('1642','Ƭ칤','Film Base Producer','1025','642');
INSERT INTO job_position VALUES('1643','й칤','Producer','1025','643');
INSERT INTO job_position VALUES('1644','Ƭչ','Waste Film and Silver Recycler','1025','644');
INSERT INTO job_position VALUES('1645','ŷ칤','Magnetic Powder Producer','1025','645');
INSERT INTO job_position VALUES('1646','ż¼칤','Magnetic Record Material Producer','1025','646');
INSERT INTO job_position VALUES('1647','ż¼鹤','Magnetic Record Material Tester','1025','647');
INSERT INTO job_position VALUES('1648','йͿ','Sensitive Drum Dauber','1025','648');
INSERT INTO job_position VALUES('1649','ҩ칤','Single-base Powder Producer','1025','649');
INSERT INTO job_position VALUES('1650','˫ҩ칤','Double-base Powder Producer','1025','650');
INSERT INTO job_position VALUES('1651','ҩ칤','Multi-base Powder Producer','1025','651');
INSERT INTO job_position VALUES('1652','ڻҩ칤','Black Powder Producer','1025','652');
INSERT INTO job_position VALUES('1653','ˮըҩԱ','Slurry Explosive Producer','1025','653');
INSERT INTO job_position VALUES('1654','ϻҩ칤','Mixed Powder Producer','1025','654');
INSERT INTO job_position VALUES('1655','ҩԱ','Other Powder Producer','1025','655');
INSERT INTO job_position VALUES('1656','ըҩ칤','Explosive Compound Producer','1025','656');
INSERT INTO job_position VALUES('1657','ըҩ칤','Mixed Explosive Producer','1025','657');
INSERT INTO job_position VALUES('1658','ҩ칤','Burster Producer','1025','658');
INSERT INTO job_position VALUES('1659','㹤','Colophony Worker','1025','659');
INSERT INTO job_position VALUES('1660','ɽƷ','Terebinth Producer','1025','660');
INSERT INTO job_position VALUES('1661','̿',' Active Carbon Producer','1025','661');
INSERT INTO job_position VALUES('1662','ὺ','','1025','662');
INSERT INTO job_position VALUES('1663','Ͻ','Lac Producer','1025','663');
INSERT INTO job_position VALUES('1664','˨ƤƷ','Cork Producer','1025','664');
INSERT INTO job_position VALUES('1665','ľˮ⹤','Wood Hydrolyzing Worker','1025','665');
INSERT INTO job_position VALUES('1666','֬ϲϹ','Resin Composite Material Worker','1025','666');
INSERT INTO job_position VALUES('1667','𽺻ϲϹ','Rubber Composite Material Worker','1025','667');
INSERT INTO job_position VALUES('1668','̼ϲϹ','Carbon Composite Material Worker','1025','668');
INSERT INTO job_position VALUES('1669','մɻϲϹ','Ceramics Composite Material Worker','1025','669');
INSERT INTO job_position VALUES('1670','Ϲƽ͹','Composite Solid Propellant Shaper','1025','670');
INSERT INTO job_position VALUES('1671','Ϲ巢װҩ','Composite Solid Engine Charger','1025','671');
INSERT INTO job_position VALUES('1672','ɻϲƷ','Airplane Composite Material Product Maker','1025','672');
INSERT INTO job_position VALUES('1673','','Soap Producer','1025','673');
INSERT INTO job_position VALUES('1674','͹','Glycerol Producer','1025','674');
INSERT INTO job_position VALUES('1675','֬Ṥ','Fatty Acid Producer','1025','675');
INSERT INTO job_position VALUES('1676','ϴ·۳͹','Washing Powder Producer','1025','676');
INSERT INTO job_position VALUES('1677','ϳϴӼ칤','Synthetic Detergent Producer','1025','677');
INSERT INTO job_position VALUES('1678','칤','Perfume Producer','1025','678');
INSERT INTO job_position VALUES('1679','㾫ƹ','Perfume Mixer','1025','679');
INSERT INTO job_position VALUES('1680','ױƷƹ','Cosmetic Mixer','1025','680');
INSERT INTO job_position VALUES('1681','칤','Toothpaste Producer','1025','681');
INSERT INTO job_position VALUES('1682','ī칤','Ink Producer','1025','682');
INSERT INTO job_position VALUES('1683','ƽ','Glue Producer','1025','683');
INSERT INTO job_position VALUES('1684','ӾԵʲ칤','Electronic Conductive and Medium Materials Produce','1025','684');
INSERT INTO job_position VALUES('1685','','Others','1025','685');
INSERT INTO job_position VALUES('1686','ʳƷʦ','Food Engineer','1026','686');
INSERT INTO job_position VALUES('1687','ʳƷӹʦ','Food Processing Technologist','1026','687');
INSERT INTO job_position VALUES('1688','ʳƷѧʦ','Food Chemical Analyst','1026','688');
INSERT INTO job_position VALUES('1689','ʳƷԱ','Food Surveyor','1026','689');
INSERT INTO job_position VALUES('1690','ʳƷ֤Ա','Food Certificating Staff','1026','690');
INSERT INTO job_position VALUES('1691','ʳƷװʦ','Food Packaging Designer','1026','691');
INSERT INTO job_position VALUES('1692','ʳƷеάԱ','Food Mechanic ','1026','692');
INSERT INTO job_position VALUES('1693','ʳƷ','Food Sanitary Management','1026','693');
INSERT INTO job_position VALUES('1694','ʳƷƷʿ','Food Quality Control','1026','694');
INSERT INTO job_position VALUES('1695','͹Ա','Grain and oil Manager','1026','695');
INSERT INTO job_position VALUES('1696','Ա','Keeping-fresh Staff','1026','696');
INSERT INTO job_position VALUES('1697','ع','Cold Storage Staff','1026','697');
INSERT INTO job_position VALUES('1698','췢͹ʦ','Brewage and Fermentation Engineer','1026','698');
INSERT INTO job_position VALUES('1699','Ʒʦ','Wine Taster ','1026','699');
INSERT INTO job_position VALUES('1700','Ӫʦ','Nutritionist','1026','700');
INSERT INTO job_position VALUES('1701','ʦ','Baker','1026','701');
INSERT INTO job_position VALUES('1702','ʦ','Cake Maker','1026','702');
INSERT INTO job_position VALUES('1703','۽ӹʦ','Candied Fruit Processing Technologist','1026','703');
INSERT INTO job_position VALUES('1704','ӹʦ','Grain Processing Technologist','1026','704');
INSERT INTO job_position VALUES('1705','ϼӹʦ','Beverage Processing Technologist','1026','705');
INSERT INTO job_position VALUES('1706','ɿӹʦ','Sweet and Chocolate Processing Technologist','1026','706');
INSERT INTO job_position VALUES('1707','ɹӹʦ','Dried Fruit Processing Technologist','1026','707');
INSERT INTO job_position VALUES('1708','ˮӹʦ','Fruit Processing Technologist','1026','708');
INSERT INTO job_position VALUES('1709','߲˼ӹʦ','Vegetable Processing Technologist','1026','709');
INSERT INTO job_position VALUES('1710','ˮӹʦ','Aquatic Product Processing Technologist','1026','710');
INSERT INTO job_position VALUES('1711','Ʒӹʦ','Dairy Product Processing Technologist','1026','711');
INSERT INTO job_position VALUES('1712','Ʒӹʦ','Meat Product Processing Technologist','1026','712');
INSERT INTO job_position VALUES('1713','Ʒӹʦ','Bean Product Processing Technologist','1026','713');
INSERT INTO job_position VALUES('1714','Ҷӹʦ','Tea Processing Technologist','1026','714');
INSERT INTO job_position VALUES('1715','̼ӹʦ','Tobacco Processing Technologist','1026','715');
INSERT INTO job_position VALUES('1716','ۼӹʦ','Starch Processing Technologist','1026','716');
INSERT INTO job_position VALUES('1717','ӹʦ','Fungus and Algae Processing Technologist','1026','717');
INSERT INTO job_position VALUES('1718','ζƷӹʦ','Spice Processing Technologist','1026','718');
INSERT INTO job_position VALUES('1719','֬ӹʦ','Oil Processing Technologist','1026','719');
INSERT INTO job_position VALUES('1720','ͷӹʦ','Canned Food Processing Technologist','1026','720');
INSERT INTO job_position VALUES('1721','決ʳƷӹʦ','Baked Food Processing Technologist','1026','721');
INSERT INTO job_position VALUES('1722','ʳƷӹʦ','Snack Food Processing Technologist','1026','722');
INSERT INTO job_position VALUES('1723','ʳƷӹʦ','Instant Food Processing Technologist','1026','723');
INSERT INTO job_position VALUES('1724','ʳƷӹʦ','Health Food Processing Technologist','1026','724');
INSERT INTO job_position VALUES('1725','䶳ʳƷӹʦ','Frozen Food Processing Technologist','1026','725');
INSERT INTO job_position VALUES('1726','طزӹʦ','Local Product Processing Technologist','1026','726');
INSERT INTO job_position VALUES('1727','ʳƷ','Others','1026','727');
INSERT INTO job_position VALUES('1728','Ƶ깫۲ܼ','Hotel Public Relation and Sales Director','1027','728');
INSERT INTO job_position VALUES('1729','Ƶ깫۲','Hotel Public Relation and Sales Manager','1027','729');
INSERT INTO job_position VALUES('1730','Ƶ깫۲','Hotel Public Relation and Sales Front-line Managem','1027','730');
INSERT INTO job_position VALUES('1731','Ƶ깫۲Ա','Hotel Public Relation and Sales Staff','1027','731');
INSERT INTO job_position VALUES('1732','ܼ','Food & Beverage Director','1027','732');
INSERT INTO job_position VALUES('1733','','Food & Beverage Manager','1027','733');
INSERT INTO job_position VALUES('1734','','Food & Beverage Front-line Management','1027','734');
INSERT INTO job_position VALUES('1735','ʦ','Wine Mixer','1027','735');
INSERT INTO job_position VALUES('1736','ʦ','Tea Technologist','1027','736');
INSERT INTO job_position VALUES('1737','ܳ','Executive Head Cook','1027','737');
INSERT INTO job_position VALUES('1738','гʦ','Chief Cook of Chinese Food','1027','738');
INSERT INTO job_position VALUES('1739','ʦ','Chief Cook of Western Food','1027','739');
INSERT INTO job_position VALUES('1740','вͳʦ','Chinese Food Cook','1027','740');
INSERT INTO job_position VALUES('1741','ͳʦ','Western Food Cook','1027','741');
INSERT INTO job_position VALUES('1742','ʽʦ','Chinese Baker','1027','742');
INSERT INTO job_position VALUES('1743','ʽʦ','Western Baker','1027','743');
INSERT INTO job_position VALUES('1744','ʳ','Food Carving Staff','1027','744');
INSERT INTO job_position VALUES('1745','','Cold Dish Staff','1027','745');
INSERT INTO job_position VALUES('1746','','Block Staff','1027','746');
INSERT INTO job_position VALUES('1747','','','1027','747');
INSERT INTO job_position VALUES('1748','¯','Stove Staff','1027','748');
INSERT INTO job_position VALUES('1749','','Party Staff','1027','749');
INSERT INTO job_position VALUES('1750','ʲ','','1027','750');
INSERT INTO job_position VALUES('1751','տ','Roasting Staff','1027','751');
INSERT INTO job_position VALUES('1752','ܼ','Room Service Director','1027','752');
INSERT INTO job_position VALUES('1753','ͷ','Room Service Manager','1027','753');
INSERT INTO job_position VALUES('1754','ͷ','Room Service Front-line Management','1027','754');
INSERT INTO job_position VALUES('1755','ͷԱ','Room Service Staff','1027','755');
INSERT INTO job_position VALUES('1756','ǰ','Front Office Manager','1027','756');
INSERT INTO job_position VALUES('1757','ø','Lobby Deputy Manager','1027','757');
INSERT INTO job_position VALUES('1758','̳','Store Manager','1027','758');
INSERT INTO job_position VALUES('1759','̳Ա','Store Staff','1027','759');
INSERT INTO job_position VALUES('1760','ǰ','Front Office Front-line Management','1027','760');
INSERT INTO job_position VALUES('1761','ǰԱ','Front Office','1027','761');
INSERT INTO job_position VALUES('1762','ֲܼ','Amusement Department Director','1027','762');
INSERT INTO job_position VALUES('1763','ֲ','Amusement Department Manager','1027','763');
INSERT INTO job_position VALUES('1764','ֲ','Amusement Department Front-line Management','1027','764');
INSERT INTO job_position VALUES('1765','Ħʦ','Masseur','1027','765');
INSERT INTO job_position VALUES('1766','ʦ','Technician','1027','766');
INSERT INTO job_position VALUES('1767','DJ','DJ','1027','767');
INSERT INTO job_position VALUES('1768','','Exercise Coach','1027','768');
INSERT INTO job_position VALUES('1769','Ӿ','Swimming Coach','1027','769');
INSERT INTO job_position VALUES('1770','ֲԱ','Amusement Department Staff','1027','770');
INSERT INTO job_position VALUES('1771','Ƶ걣','Hotel Security Agent Manager','1027','771');
INSERT INTO job_position VALUES('1772','Ƶ걣','Hotel Security Agent Front-line Management','1027','772');
INSERT INTO job_position VALUES('1773','Ƶ걣Ա','Hotel Security Agent Staff','1027','773');
INSERT INTO job_position VALUES('1774','Ƶɹ','Hotel Procurement Division Manager','1027','774');
INSERT INTO job_position VALUES('1775','ƵɹԱ','Hotel Procurement Division Staff','1027','775');
INSERT INTO job_position VALUES('1776','Ƶ깤̲','Hotel Engineering Department Manager','1027','776');
INSERT INTO job_position VALUES('1777','Ƶ깤̲','Hotel Engineering Department Front-line Management','1027','777');
INSERT INTO job_position VALUES('1778','Ƶ깤̲Ա','Hotel Engineering Department Staff','1027','778');
INSERT INTO job_position VALUES('1779','Ա','Waiter/ Waitress','1027','779');
INSERT INTO job_position VALUES('1780','װʦ','Packaging Designer','1028','780');
INSERT INTO job_position VALUES('1781','ӡˢʦ','Printing technologist','1028','781');
INSERT INTO job_position VALUES('1782','Ϲʦ','Material Engineer','1028','782');
INSERT INTO job_position VALUES('1783','װе','Packaging Machine Designer','1028','783');
INSERT INTO job_position VALUES('1784','װṹ','Packaging Structural Designer','1028','784');
INSERT INTO job_position VALUES('1785','װ','Buffer Packaging Designer','1028','785');
INSERT INTO job_position VALUES('1786','װ','Packaging Inspector','1028','786');
INSERT INTO job_position VALUES('1787','ƽư湤','Flat Plate Maker','1028','787');
INSERT INTO job_position VALUES('1788','͹ư湤','Letterpress Plate Maker','1028','788');
INSERT INTO job_position VALUES('1789','ư湤','Gravure Plate Maker','1028','789');
INSERT INTO job_position VALUES('1790','װư湤','Porous Plate Maker','1028','790');
INSERT INTO job_position VALUES('1791','ƽӡˢ','Flat Plate Printer','1028','791');
INSERT INTO job_position VALUES('1792','͹ӡˢ','Letterpress Plate Printer','1028','792');
INSERT INTO job_position VALUES('1793','ӡˢ','Gravure Plate Printer','1028','793');
INSERT INTO job_position VALUES('1794','װӡˢ','Porous Plate Printer','1028','794');
INSERT INTO job_position VALUES('1795','ľˮӡӡƹ','Wooden-Block Printer','1028','795');
INSERT INTO job_position VALUES('1796','˿ӡˢԱ','Screen Printing Technician','1028','796');
INSERT INTO job_position VALUES('1797','ӡƹ','Collotype Printer','1028','797');
INSERT INTO job_position VALUES('1798','äӡƹ','Braille Printer','1028','798');
INSERT INTO job_position VALUES('1799','װ','Bookbinder','1028','799');
INSERT INTO job_position VALUES('1800','ӡƷι','Printed Matter Decorator','1028','800');
INSERT INTO job_position VALUES('1801','ӡˢ','Printing Machine Operator','1028','801');
INSERT INTO job_position VALUES('1802','?','Machine Master','1028','802');
INSERT INTO job_position VALUES('1803','','Second Fiddle','1028','803');
INSERT INTO job_position VALUES('1804','ɨ','Scanning Operator','1028','804');
INSERT INTO job_position VALUES('1805','ī','Ink Mixer','1028','805');
INSERT INTO job_position VALUES('1806','ɫԱ','Colour Mixer','1028','806');
INSERT INTO job_position VALUES('1807','','Compounder','1028','807');
INSERT INTO job_position VALUES('1808','Ϳ','Dauber','1028','808');
INSERT INTO job_position VALUES('1809','ҳѹװ','Page Folding, Pressing and Binding','1028','809');
INSERT INTO job_position VALUES('1810','','Flow Casting Worker','1028','810');
INSERT INTO job_position VALUES('1811','Ĥ','Blown Film Worker','1028','811');
INSERT INTO job_position VALUES('1812','й','Parting Cutter','1028','812');
INSERT INTO job_position VALUES('1813','ֽ','Paper Cutter','1028','813');
INSERT INTO job_position VALUES('1814','ƴ','Bag Maker','1028','814');
INSERT INTO job_position VALUES('1815','ģѹ','Coining Worker','1028','815');
INSERT INTO job_position VALUES('1816','Ĥ','Film Cutter','1028','816');
INSERT INTO job_position VALUES('1817','д','Bag Cutter','1028','817');
INSERT INTO job_position VALUES('1818','','Cutter','1028','818');
INSERT INTO job_position VALUES('1819','','Box Plaster','1028','819');
INSERT INTO job_position VALUES('1820','ע','Injection Worker','1028','820');
INSERT INTO job_position VALUES('1821','ߵ','Line Debugger','1028','821');
INSERT INTO job_position VALUES('1822','߼¼Ա','Line Recorder','1028','822');
INSERT INTO job_position VALUES('1823','װ/ӡˢ/ֽԱ','Others','1028','823');
INSERT INTO job_position VALUES('1824','еƹ̼Ա','Machine Design Engineering Technician','1029','824');
INSERT INTO job_position VALUES('1825','е칤̼Ա','Machine Manufacture Engineering Technician','1029','825');
INSERT INTO job_position VALUES('1826','Ǳ̼Ա','Instrument Engineering Technician','1029','826');
INSERT INTO job_position VALUES('1827','豸̼Ա','Equipment Engineering Technician','1029','827');
INSERT INTO job_position VALUES('1828','е豸װ','Machine Erector','1029','828');
INSERT INTO job_position VALUES('1829','豸װ','Electric Equipment Erector','1029','829');
INSERT INTO job_position VALUES('1830','ܹ','Plumber','1029','830');
INSERT INTO job_position VALUES('1831','','Latheman','1029','831');
INSERT INTO job_position VALUES('1832','칤','Forging Worker','1029','832');
INSERT INTO job_position VALUES('1833','ϳ','Miller','1029','833');
INSERT INTO job_position VALUES('1834','ѹ','Presser','1029','834');
INSERT INTO job_position VALUES('1835','ٲ幤','Planer','1029','835');
INSERT INTO job_position VALUES('1836','й','Cutter','1029','836');
INSERT INTO job_position VALUES('1837','ĥ','Grinder','1029','837');
INSERT INTO job_position VALUES('1838','','Welder','1029','838');
INSERT INTO job_position VALUES('1839','۹','Boring Machine Operator','1029','839');
INSERT INTO job_position VALUES('1840','ȴ','Metal Heat-treating Worker','1029','840');
INSERT INTO job_position VALUES('1841','괲','Driller','1029','841');
INSERT INTO job_position VALUES('1842','ϻ','Operator of Unit Built Machine Tool ','1029','842');
INSERT INTO job_position VALUES('1843','ӹĲ','Operator of Machining Center','1029','843');
INSERT INTO job_position VALUES('1844','Ƴݹ','Tooth Maker','1029','844');
INSERT INTO job_position VALUES('1845','˿Ƽι','Thread Pusher','1029','845');
INSERT INTO job_position VALUES('1846','ĥ⹤','Polishing Worker','1029','846');
INSERT INTO job_position VALUES('1847','','Broaching Machine Worker','1029','847');
INSERT INTO job_position VALUES('1848','ⴲ','Sawing Machine Worker','1029','848');
INSERT INTO job_position VALUES('1849','оŤƹ','Cutlery Winder','1029','849');
INSERT INTO job_position VALUES('1850','Ԫ칤','Elastic Cell Maker','1029','850');
INSERT INTO job_position VALUES('1851','еӹԱ','Other Cold-working Worker','1029','851');
INSERT INTO job_position VALUES('1852','','Electrical Cutting Worker','1029','852');
INSERT INTO job_position VALUES('1853','ӽ','Sheet Metal Worker','1029','853');
INSERT INTO job_position VALUES('1854','ӽӹԱ','Other Sheet Metal Workers','1029','854');
INSERT INTO job_position VALUES('1855','Ʋ㹤','Coating Worker','1029','855');
INSERT INTO job_position VALUES('1856','Ϳװ','Painting Dressing Worker','1029','856');
INSERT INTO job_position VALUES('1857','ĥ칤','Abrasive Maker','1029','857');
INSERT INTO job_position VALUES('1858','ĥ칤','Sharpener Maker','1029','858');
INSERT INTO job_position VALUES('1859','ܡƹܹ','Metal Soft Pipe and Bellows Worker','1029','859');
INSERT INTO job_position VALUES('1860','ǹѧӹ','Satellite Optical Cold-working Worker','1029','860');
INSERT INTO job_position VALUES('1861','´','Spacecraft Components Heat-treating Worker','1029','861');
INSERT INTO job_position VALUES('1862','纸칤','Welding Electrode Maker','1029','862');
INSERT INTO job_position VALUES('1863','Ǳ޼칤','Instrument Maker','1029','863');
INSERT INTO job_position VALUES('1864','ոﴦ','Vacuum Drying Treating Worker','1029','864');
INSERT INTO job_position VALUES('1865','챦ʯ칤','Synthetic Cut Stone Maker','1029','865');
INSERT INTO job_position VALUES('1866','ǯ','Machine Maintenance Locksmith','1029','866');
INSERT INTO job_position VALUES('1867','','Motorcar Repairman','1029','867');
INSERT INTO job_position VALUES('1868','','Ship Repairman','1029','868');
INSERT INTO job_position VALUES('1869','ҵԶǱװ','Industrial Automation Instrument and Equipment Rep','1029','869');
INSERT INTO job_position VALUES('1870','繤Ǳ','Electrical Instrument Repairman','1029','870');
INSERT INTO job_position VALUES('1871','Ǳ','Precise Instrument Repairman','1029','871');
INSERT INTO job_position VALUES('1873','Сʩе','Small and Medium-sized Construction Machine Operat','1029','873');
INSERT INTO job_position VALUES('1874','ҵ̬̼Ա','Forest Ecological Environment Engineering Technici','1030','874');
INSERT INTO job_position VALUES('1875','ɭ̼Ա','Silviculture Engineering Technician','1030','875');
INSERT INTO job_position VALUES('1876','԰̻̼Ա','Landscaping Engineering Technician','1030','876');
INSERT INTO job_position VALUES('1877','Ұﱣ뷱ֳù̼Ա','Engineering Technician of Wildlife Conservation an','1030','877');
INSERT INTO job_position VALUES('1878','Ȼ̼Ա','Natural Reserve Engineering Technician','1030','878');
INSERT INTO job_position VALUES('1879','ɭֱ̼Ա','Forest Resources Conservation Engineering Technici','1030','879');
INSERT INTO job_position VALUES('1880','ľļӹ̼Ա','Wood and Bamboo Processing Engineering Technician','1030','880');
INSERT INTO job_position VALUES('1881','ɭֲɷ乤̼Ա','Forest Felling and Transport Engineering Technicia','1030','881');
INSERT INTO job_position VALUES('1882','ֺزƷӹ̼Ա','Economic forests and Forest Products Processing En','1030','882');
INSERT INTO job_position VALUES('1883','ɭԴ⹤̼Ա','Forest Resources Management and Monitoring Enginee','1030','883');
INSERT INTO job_position VALUES('1884','ˮֳ̼Ա','Aquaculture Engineering Technician','1030','884');
INSERT INTO job_position VALUES('1885','ҵԴù̼Ա','Fishing Resource Development and Utilization Engin','1030','885');
INSERT INTO job_position VALUES('1886','ũչ','Agronomic Worker','1030','886');
INSERT INTO job_position VALUES('1887','ӷ','Seed Planter','1030','887');
INSERT INTO job_position VALUES('1888','ơƻ','Hop Producer','1030','888');
INSERT INTO job_position VALUES('1889','ũֲ','Crop Planter','1030','889');
INSERT INTO job_position VALUES('1890','ũҵʵ鹤','Agriculture Tester','1030','890');
INSERT INTO job_position VALUES('1891','ũⱨԱ','Agriculture Information Reporter','1030','891');
INSERT INTO job_position VALUES('1892','߲԰չ','Vegetable Gardener','1030','892');
INSERT INTO job_position VALUES('1893','԰չ','Flower Gardener','1030','893');
INSERT INTO job_position VALUES('1894','衢ɣ԰չ','Fruit/Tea/ Mulberry Gardener','1030','894');
INSERT INTO job_position VALUES('1895','Ȼ','Natural Rubber Producer','1030','895');
INSERT INTO job_position VALUES('1896','','Sisal Producer','1030','896');
INSERT INTO job_position VALUES('1897','޻ӹ','Cotton Processor','1030','897');
INSERT INTO job_position VALUES('1898','Ҷӹ','Tea Processor','1030','898');
INSERT INTO job_position VALUES('1899','߲˼ӹ','Vegetable Gardener','1030','899');
INSERT INTO job_position VALUES('1900','١顢ءƷӹ','Bamboo/Bine/ Hemp/ Palm/Grass Product Processor','1030','900');
INSERT INTO job_position VALUES('1901','ֲԭϼӹ','Special Plant Material Processor','1030','901');
INSERT INTO job_position VALUES('1902','ľ繤','Forest Planter','1030','902');
INSERT INTO job_position VALUES('1903','ɷ','Cultivating and Felling Worker','1030','903');
INSERT INTO job_position VALUES('1904','ɭֲ溦Ա','Forest Insect Pest Prevention Worker','1030','904');
INSERT INTO job_position VALUES('1905','걾Ա','Sample Maker','1030','905');
INSERT INTO job_position VALUES('1906','ľĲɷ','Wood Feller','1030','906');
INSERT INTO job_position VALUES('1907','','Livestock Feeder','1030','907');
INSERT INTO job_position VALUES('1908','ֳ','Livestock Breeder','1030','908');
INSERT INTO job_position VALUES('1909','۷','Bee Feeder','1030','909');
INSERT INTO job_position VALUES('1910','߲Ա','Animal Plague Preventing Worker','1030','910');
INSERT INTO job_position VALUES('1911','ҽԱ','Veterinary Analyst','1030','911');
INSERT INTO job_position VALUES('1912','߼Ա','Animal Quarantine Checker','1030','912');
INSERT INTO job_position VALUES('1913','ݵؼ໤Ա','Lawn Guarder','1030','913');
INSERT INTO job_position VALUES('1914','ƺֲ','Lawn Planter','1030','914');
INSERT INTO job_position VALUES('1915','ݹ','Grazing Worker','1030','915');
INSERT INTO job_position VALUES('1916','ˮַ','Aquatic Animal Offspring Propagating Worker','1030','916');
INSERT INTO job_position VALUES('1917','ˮ','Aquatic Animal Offspring Feeder','1030','917');
INSERT INTO job_position VALUES('1918','ˮ','Aquatic Animal Feeder','1030','918');
INSERT INTO job_position VALUES('1919','ˮֲ๤','Hydrophyte Planter','1030','919');
INSERT INTO job_position VALUES('1920','ֳ','Pearl Cultivator','1030','920');
INSERT INTO job_position VALUES('1921','','Biological Feedstuff Foster','1030','921');
INSERT INTO job_position VALUES('1922','ˮֳǱˮ','Aquaculture Diver','1030','922');
INSERT INTO job_position VALUES('1923','ˮ̹','Aquatic Product Fisher','1030','923');
INSERT INTO job_position VALUES('1924','ҵԱ','Fishing Production Shipman','1030','924');
INSERT INTO job_position VALUES('1925','װ乤','Fishing Net and Gear Assembler','1030','925');
INSERT INTO job_position VALUES('1926','ˮƷԭϴ','Raw Aquatic Product Treating Worker','1030','926');
INSERT INTO job_position VALUES('1927','ˮƷѬƹ','Smoked and Salted Aquatic Product Processor','1030','927');
INSERT INTO job_position VALUES('1928','ӼƷӹ','Minced Fillet and Its Product Processor','1030','928');
INSERT INTO job_position VALUES('1929','ۼӹ','Fish Meal Processor','1030','929');
INSERT INTO job_position VALUES('1930','ͼƷӹ','Fish-liver Oil and Its Product Processor','1030','930');
INSERT INTO job_position VALUES('1931','Ƶ⹤','Seaweed Iodine Producer','1030','931');
INSERT INTO job_position VALUES('1932','ƴ','Seaweed Alcohols Producer','1030','932');
INSERT INTO job_position VALUES('1933','ƽ','Seaweed Glue Producer','1030','933');
INSERT INTO job_position VALUES('1934','ྻ','Shellfish Cleaner','1030','934');
INSERT INTO job_position VALUES('1935','ҩֲԱ','Chinese Medicinal Material Planter','1030','935');
INSERT INTO job_position VALUES('1936','ʳƷӹ','Seaweed Food Processor','1030','936');
INSERT INTO job_position VALUES('1937','ˮĿ⹤','Hydrologic Surveyor','1030','937');
INSERT INTO job_position VALUES('1938','ʻԱ','Tractor Driver','1030','938');
INSERT INTO job_position VALUES('1939','ոʻԱ','Combine Harvester Driver','1030','939');
INSERT INTO job_position VALUES('1940','ũ䳵ʻԱ','Farm-Transporter Driver','1030','940');
INSERT INTO job_position VALUES('1941','мʻԱ','Pilot','1031','941');
INSERT INTO job_position VALUES('1942','леԱ','Flight Engineer','1031','942');
INSERT INTO job_position VALUES('1943','캽Ա','Flight Navigator','1031','943');
INSERT INTO job_position VALUES('1944','ͨԱ','Flight Radioman','1031','944');
INSERT INTO job_position VALUES('1945','װ岿Ա','Deck Technician','1031','945');
INSERT INTO job_position VALUES('1946','ֻԱ','Engine Technician','1031','946');
INSERT INTO job_position VALUES('1947','Ա','Ship Pilot','1031','947');
INSERT INTO job_position VALUES('1948','ù̼Ա','Automobile Application Engineering Technician','1031','948');
INSERT INTO job_position VALUES('1949','ù̼Ա','Ship Application Engineering Technician','1031','949');
INSERT INTO job_position VALUES('1950','Ͼ̹̼Ա','Ocean Rescue and Salvage Engineering Technician','1031','950');
INSERT INTO job_position VALUES('1951','鹤̼Ա','Ship Inspection Engineering Technician','1031','951');
INSERT INTO job_position VALUES('1952','̼ͨԱ','Other Traffic Engineering Technician','1031','952');
INSERT INTO job_position VALUES('1953','AʻԱ','A License Driver','1031','953');
INSERT INTO job_position VALUES('1954','BʻԱ','B License Driver','1031','954');
INSERT INTO job_position VALUES('1955','CʻԱ','C License Driver','1031','955');
INSERT INTO job_position VALUES('1956','ֳʻԱ','Special Vehicle Driver','1031','956');
INSERT INTO job_position VALUES('1957','ά','Automotive Maintenance Personnel','1031','957');
INSERT INTO job_position VALUES('1958','װ','Automotive Decoration Personnel','1031','958');
INSERT INTO job_position VALUES('1959','𳵼ʻԱ','Train Driver','1031','959');
INSERT INTO job_position VALUES('1960','𳵵Ա','Train Dispatcher','1031','960');
INSERT INTO job_position VALUES('1961','ά','Train Maintenance Personnel','1031','961');
INSERT INTO job_position VALUES('1962','','Switchman','1031','962');
INSERT INTO job_position VALUES('1963','г','Conductor','1031','963');
INSERT INTO job_position VALUES('1964','гԱ','Train Attendant','1031','964');
INSERT INTO job_position VALUES('1965','','Captain','1031','965');
INSERT INTO job_position VALUES('1966','','First Mate','1031','966');
INSERT INTO job_position VALUES('1967','','Second Mate','1031','967');
INSERT INTO job_position VALUES('1968','ʻ','Ship Driver','1031','968');
INSERT INTO job_position VALUES('1969','ά','Ship Maintenance Personnel','1031','969');
INSERT INTO job_position VALUES('1970','Ա','Sailor','1031','970');
INSERT INTO job_position VALUES('1971','ƱԱ','Conductor','1031','971');
INSERT INTO job_position VALUES('1972','Ա','Buses Dispatcher','1031','972');
INSERT INTO job_position VALUES('1973','ͨԱ','Other Traffic and Transportation Staff','1031','973');
INSERT INTO job_position VALUES('1974','繤̼Ա','Power Generation Engineering Technician','1032','974');
INSERT INTO job_position VALUES('1975','繤̼Ա','Engineering Technician','1032','975');
INSERT INTO job_position VALUES('1976','õ繤̼Ա','Engineering Technician','1032','976');
INSERT INTO job_position VALUES('1977','ʦ','Electrical Engineer','1032','977');
INSERT INTO job_position VALUES('1978','Ԥʦ','Electrical Budgeter','1032','978');
INSERT INTO job_position VALUES('1979','ʦ','Electrical Supervision Engineer','1032','979');
INSERT INTO job_position VALUES('1980','ϵͳԶ','Electrical system and Automation','1032','980');
INSERT INTO job_position VALUES('1981','糧ר','Power Plant Electrical Operator','1032','981');
INSERT INTO job_position VALUES('1982','Ӳʦ','Electrical Software and Hardware Engineer','1032','982');
INSERT INTO job_position VALUES('1983','ԴԱ','Power Technician','1032','983');
INSERT INTO job_position VALUES('1984','ܶʦ','Thermal Power Engineer','1032','984');
INSERT INTO job_position VALUES('1985','绯ѧʦ','Electrochemical Engineer','1032','985');
INSERT INTO job_position VALUES('1986','ȫʦ','Quality and Safety Engineer','1032','986');
INSERT INTO job_position VALUES('1987','ʦ','Engine Development Engineer','1032','987');
INSERT INTO job_position VALUES('1988','ʦ','Aerodynamic Engineer','1032','988');
INSERT INTO job_position VALUES('1989','ר','Steamer Operation Specialized Worker','1032','989');
INSERT INTO job_position VALUES('1990','ר','Steamer Specialized Repairman','1032','990');
INSERT INTO job_position VALUES('1991','糧¯ר','Power Plant Boiler Specialized Repairman','1032','991');
INSERT INTO job_position VALUES('1992','糧Ѳ','Power Plant Inspector','1032','992');
INSERT INTO job_position VALUES('1993','ˮƹʦ','Hydroelectric Design Engineer','1032','993');
INSERT INTO job_position VALUES('1994','ȱ¹ʦ','Attempering and Insulation','1032','994');
INSERT INTO job_position VALUES('1995','ѹƵӦùʦ','High-pressure Converter Application Engineer','1032','995');
INSERT INTO job_position VALUES('1996','гϵͳӦùʦ','Harmonic Abatement System Application Engineer','1032','996');
INSERT INTO job_position VALUES('1997','ˮԱ','Water Treatment Designer','1032','997');
INSERT INTO job_position VALUES('1998','ˮˮʩװʦ','Water Conservancy and Hydropower Construction and ','1032','998');
INSERT INTO job_position VALUES('1999','¯ʦ','Boiler Engineer','1032','999');
INSERT INTO job_position VALUES('2000','ʦ','Steam Engine Engineer','1032','1000');
INSERT INTO job_position VALUES('2001','ȼȻ񹤳ʦ','Engine and Heat Engine Locomotive Engineer','1032','1001');
INSERT INTO job_position VALUES('2002','˾','Driver','1032','1002');
INSERT INTO job_position VALUES('2003','˾˾ˮԱ','Driver Assistant','1032','1003');
INSERT INTO job_position VALUES('2004','˾¯','','1032','1004');
INSERT INTO job_position VALUES('2005','ӵѹʦ','Electronic Transformer Engineer','1032','1005');
INSERT INTO job_position VALUES('2006','صԴзʦ','Switch and Power R & D Engineer','1032','1006');
INSERT INTO job_position VALUES('2007','ϵͳʦ','Safety and Protection System Engineer','1032','1007');
INSERT INTO job_position VALUES('2008','շ繤ʦ','Fire Power Generation Engineer','1032','1008');
INSERT INTO job_position VALUES('2009','ṹʦ','Structure Process Designer','1032','1009');
INSERT INTO job_position VALUES('2010','̵籣Ʒзʦ','Relay Protection Product R & D Engineer','1032','1010');
INSERT INTO job_position VALUES('2011','ʦ','Sulfur and Dust Removal Engineer','1032','1011');
INSERT INTO job_position VALUES('2012','ˮʦ','Oil and Water Engineer','1032','1012');
INSERT INTO job_position VALUES('2013','˵繤ʦ','Nuclear Power Engineer','1032','1013');
INSERT INTO job_position VALUES('2014','ǿ繤ʦ','Strong Electricity Engineer','1032','1014');
INSERT INTO job_position VALUES('2015','⡢ܼУ','Power Check','1032','1015');
INSERT INTO job_position VALUES('2016','ͨѶ','Electric Communication Designer','1032','1016');
INSERT INTO job_position VALUES('2017','ˮеʦ','Hydraulic Machinery Engineer','1032','1017');
INSERT INTO job_position VALUES('2018','ֹܱ֧ʦ','Power Instrument Technology Supply Engineer','1032','1018');
INSERT INTO job_position VALUES('2019','ѹ繤','High-pressure Electrician','1032','1019');
INSERT INTO job_position VALUES('2020','繤','Electrician','1032','1020');
INSERT INTO job_position VALUES('2021','//ԴԱ','Others','1032','1021');
INSERT INTO job_position VALUES('2022','///','Factory Manager/ Director/ Deputy Director/Directo','1033','1022');
INSERT INTO job_position VALUES('2023','ܹʦ/ܹʦ','Chief Engineer/ Deputy Chief Engineer','1033','1023');
INSERT INTO job_position VALUES('2024','Ŀ/','Project Manager/Director','1033','1024');
INSERT INTO job_position VALUES('2025','Ŀʦ','Project Engineer','1033','1025');
INSERT INTO job_position VALUES('2026','Ӫ˾','Operation Manager','1033','1026');
INSERT INTO job_position VALUES('2027','Ӫ','Operation Director','1033','1027');
INSERT INTO job_position VALUES('2028','/','Production Manager/Workshop Director','1033','1028');
INSERT INTO job_position VALUES('2029','ƻЭԱ','Production Plan Coordinator','1033','1029');
INSERT INTO job_position VALUES('2030','//','Production Director/ Supervisor/ Foreman','1033','1030');
INSERT INTO job_position VALUES('2031','/ƾ/','Technology/ Process Design Manager/Director','1033','1031');
INSERT INTO job_position VALUES('2032','/ƹʦ','Technology/ Process Design Engineer','1033','1032');
INSERT INTO job_position VALUES('2033','ʵҸ/ʦ','Laboratory Director/ Engineer','1033','1033');
INSERT INTO job_position VALUES('2034','/豸','Project / Equipment Manager','1033','1034');
INSERT INTO job_position VALUES('2035','/豸','Project / Equipment Director','1033','1035');
INSERT INTO job_position VALUES('2036','/豸ʦ','Project / Equipment Engineer','1033','1036');
INSERT INTO job_position VALUES('2037','/ӹʦ','Electrical /Electronics Engineer','1033','1037');
INSERT INTO job_position VALUES('2038','еʦ','Mechanical Engineer','1033','1038');
INSERT INTO job_position VALUES('2039','繤ʦ','Electromechanical Engineer','1033','1039');
INSERT INTO job_position VALUES('2040','ģ߹ʦ','Mould Engineer','1033','1040');
INSERT INTO job_position VALUES('2041','ά޹ʦ','Maintenance Engineer','1033','1041');
INSERT INTO job_position VALUES('2042','','Quality Manager','1033','1042');
INSERT INTO job_position VALUES('2043','','Quality Director','1033','1043');
INSERT INTO job_position VALUES('2044','ʦ','Quality Engineer','1033','1044');
INSERT INTO job_position VALUES('2045','Ա/Ա','Quality Inspector/ Tester','1033','1045');
INSERT INTO job_position VALUES('2046','֤ʦ','Certification Engineer','1033','1046');
INSERT INTO job_position VALUES('2047','ȫ///','Safety/Health/Environment Manager/Director','1033','1047');
INSERT INTO job_position VALUES('2048','ȫ//ʦ','Safety/Health/Environment Engineer','1033','1048');
INSERT INTO job_position VALUES('2049','̻ͼԱ','Engineering Drawer','1033','1049');
INSERT INTO job_position VALUES('2050','еͼԱ','Mechanical Drawer','1033','1050');
INSERT INTO job_position VALUES('2051','Ա','Analyst','1033','1051');
INSERT INTO job_position VALUES('2052','繤','Electrician','1033','1052');
INSERT INTO job_position VALUES('2053','ǯ','Locksmith','1033','1053');
INSERT INTO job_position VALUES('2054','޹','Mechanic','1033','1054');
INSERT INTO job_position VALUES('2055','ӽ','Sheet Metal Worker','1033','1055');
INSERT INTO job_position VALUES('2056','纸','Welder','1033','1056');
INSERT INTO job_position VALUES('2057','í','Rivet Welder','1033','1057');
INSERT INTO job_position VALUES('2058','','Latheman','1033','1058');
INSERT INTO job_position VALUES('2059','ĥ','Grinder','1033','1059');
INSERT INTO job_position VALUES('2060','ϳ','Miller','1033','1060');
INSERT INTO job_position VALUES('2061','崲','Punch Worker','1033','1061');
INSERT INTO job_position VALUES('2062','ല','','1033','1062');
INSERT INTO job_position VALUES('2063','ģ߹','Mould Worker','1033','1063');
INSERT INTO job_position VALUES('2064','ˮ','Water Worker','1033','1064');
INSERT INTO job_position VALUES('2065','ľ','Carpenter','1033','1065');
INSERT INTO job_position VALUES('2066','Ṥ','Painter','1033','1066');
INSERT INTO job_position VALUES('2067','泵','Forklift Driver','1033','1067');
INSERT INTO job_position VALUES('2068','յ','Air-conditioner Worker','1033','1068');
INSERT INTO job_position VALUES('2069','ݹ','Liftman','1033','1069');
INSERT INTO job_position VALUES('2070','¯','Stillman','1033','1070');
INSERT INTO job_position VALUES('2071','չ','Unskilled Man','1033','1071');
INSERT INTO job_position VALUES('2072','','Others','1033','1072');
INSERT INTO job_position VALUES('2073','йԱ','Research Manager','1034','1073');
INSERT INTO job_position VALUES('2074','Ա','Researcher','1034','1074');
INSERT INTO job_position VALUES('2075','Ա','Civil Servant','1035','1075');
INSERT INTO job_position VALUES('2076','ȫ','Safety and Fire Fighting','1036','1076');
INSERT INTO job_position VALUES('2077','ѧ','Acoustic and Optic Technology','1036','1077');
INSERT INTO job_position VALUES('2078','漼','Surveying & Mapping Technology','1036','1078');
INSERT INTO job_position VALUES('2079','/','Geology/ Minerals','1036','1079');
INSERT INTO job_position VALUES('2080','ұ/Ϳ/','metallurgy/ sputtering/ Metal material','1036','1080');
INSERT INTO job_position VALUES('2081','','Others','1036','1081');

INSERT INTO job_prices VALUES('1','˼̶','30','30','','1','˼̶ʾ','2010-09-08 16:49:42');
INSERT INTO job_prices VALUES('2','ƬƼ','30','30','','2','ƬʾԼ˲б','2010-09-08 16:49:42');
INSERT INTO job_prices VALUES('3','ҵLOGOƼ','100','30','','3','ҵLOGOƼʾ','2010-09-08 16:49:42');
INSERT INTO job_prices VALUES('4','ҵ̶ʾ','300','30','','4','ҵϢ̶ʾƸб','2010-09-08 16:49:42');
INSERT INTO job_prices VALUES('5','ְλ̶Ƽ','50','30','','5','̶ƼְλϢְλбʾ','2010-09-08 16:49:42');

INSERT INTO job_profession VALUES('1000','','Computer','0','0');
INSERT INTO job_profession VALUES('1001','ͨԿؼ','Electronic Communication and Automation Technology','0','1');
INSERT INTO job_profession VALUES('1002','Ǳ','Lnstrument and Apparatus','0','2');
INSERT INTO job_profession VALUES('1003','','Power and Electric','0','3');
INSERT INTO job_profession VALUES('1004','ʳƷ','Food and Beverage','0','4');
INSERT INTO job_profession VALUES('1005','ũ','Agricultural Sciences','0','5');
INSERT INTO job_profession VALUES('1006','е','Machinery','0','6');
INSERT INTO job_profession VALUES('1007','ѧ','Chemical Engineering','0','7');
INSERT INTO job_profession VALUES('1008','Ṥ','Light Industry ','0','8');
INSERT INTO job_profession VALUES('1009','ӹ','Processing and Manufacturing','0','9');
INSERT INTO job_profession VALUES('1010','','Surveying & Mapping','0','10');
INSERT INTO job_profession VALUES('1011','','Materials','0','11');
INSERT INTO job_profession VALUES('1012','','Architecture','0','12');
INSERT INTO job_profession VALUES('1013','ͨ','Science of Traffic & Transportation','0','13');
INSERT INTO job_profession VALUES('1014','Դˮ','Energy and Water Conservancy','0','14');
INSERT INTO job_profession VALUES('1015','﹤','Biotechnology','0','15');
INSERT INTO job_profession VALUES('1016','ҽҩѧ','Medicine','0','16');
INSERT INTO job_profession VALUES('1017','ؿұ','Mining and Metallurgy','0','17');
INSERT INTO job_profession VALUES('1018','','Environmental Protection','0','18');
INSERT INTO job_profession VALUES('1019','','Management','0','19');
INSERT INTO job_profession VALUES('1020','','Natural Sciences','0','20');
INSERT INTO job_profession VALUES('1021','','Technician','0','21');
INSERT INTO job_profession VALUES('1022','ѧ','Economics Sciences','0','22');
INSERT INTO job_profession VALUES('1023','ƻ','Finance and Accounting','0','23');
INSERT INTO job_profession VALUES('1024','ͳ','Auditing and Statistics ','0','24');
INSERT INTO job_profession VALUES('1025','˰','Finance and Taxation','0','25');
INSERT INTO job_profession VALUES('1026','֤ȯ','Finance and Securities','0','26');
INSERT INTO job_profession VALUES('1027','ƾ','Finance','0','27');
INSERT INTO job_profession VALUES('1028','Ӫ','Sale ','0','28');
INSERT INTO job_profession VALUES('1029','ѧ','Philosophical Sciences','0','29');
INSERT INTO job_profession VALUES('1030','ѧ','Psychological Sciences','0','30');
INSERT INTO job_profession VALUES('1031','ʷ','History','0','31');
INSERT INTO job_profession VALUES('1032','ѧ','Law','0','32');
INSERT INTO job_profession VALUES('1033','','Society and politics','0','33');
INSERT INTO job_profession VALUES('1034','','Arts','0','34');
INSERT INTO job_profession VALUES('1035','ѧŴѧ','Language & Literatur and News','0','35');
INSERT INTO job_profession VALUES('1036','','Foreign Languages','0','36');
INSERT INTO job_profession VALUES('1037','','Education','0','37');
INSERT INTO job_profession VALUES('1038','պ','Aeronautics and Astronautics','0','38');
INSERT INTO job_profession VALUES('1039','¹','Military, Public Security and Weapons','0','39');
INSERT INTO job_profession VALUES('1040','','Business and Tourist','0','40');
INSERT INTO job_profession VALUES('1041','ṫ','Public Affairs','0','41');
INSERT INTO job_profession VALUES('1042','','Public Relations and Secretary','0','42');
INSERT INTO job_profession VALUES('1043','ѧ뼼','Computer Science and Technology','1000','43');
INSERT INTO job_profession VALUES('1044','','Computer Software','1000','44');
INSERT INTO job_profession VALUES('1045','Ӳ','Computer Hardware','1000','45');
INSERT INTO job_profession VALUES('1046','ά','Computer and Maintenance of Peripheral Equipment','1000','46');
INSERT INTO job_profession VALUES('1047','Ӧ','Computer Applied Technology','1000','47');
INSERT INTO job_profession VALUES('1048','Ӧ','Computer and Applications','1000','48');
INSERT INTO job_profession VALUES('1049','','Computer Engineering','1000','49');
INSERT INTO job_profession VALUES('1050','˹','Artificial Intelligence','1000','50');
INSERT INTO job_profession VALUES('1051','','Computer Network','1000','51');
INSERT INTO job_profession VALUES('1052','缼','Computer Network Technology','1000','52');
INSERT INTO job_profession VALUES('1053','ͼ','Computer Produced Drawing','1000','53');
INSERT INTO job_profession VALUES('1054','ά','Computer Maintenance','1000','54');
INSERT INTO job_profession VALUES('1055','Ϣ','Information Engineering','1000','55');
INSERT INTO job_profession VALUES('1056','ϢϢϵͳ','Information Management & Information System','1000','56');
INSERT INTO job_profession VALUES('1057','','Electronic Commerce','1000','57');
INSERT INTO job_profession VALUES('1058','칫Զ','Office Automation','1000','58');
INSERT INTO job_profession VALUES('1059','ͼϢ','Library Information Management','1000','59');
INSERT INTO job_profession VALUES('1060','ӿѧ뼼','Electronic Science and Technology','1001','60');
INSERT INTO job_profession VALUES('1061','Ϣ','Electronic and Information Technology','1001','61');
INSERT INTO job_profession VALUES('1062','ӼӦ','Electronic Applied Technology','1001','62');
INSERT INTO job_profession VALUES('1063','ӹ','Electronic engineering','1001','63');
INSERT INTO job_profession VALUES('1064','΢ѧ','Microelectronics ','1001','64');
INSERT INTO job_profession VALUES('1065','ӲԪ','Electronic Materials and Components','1001','65');
INSERT INTO job_profession VALUES('1066','Ϣ뼼','Optical Information Engineering and Technology','1001','66');
INSERT INTO job_profession VALUES('1067','ߵ缼','Radio Technology','1001','67');
INSERT INTO job_profession VALUES('1068','뵼弯ɼ','Semiconductor Integration Technology','1001','68');
INSERT INTO job_profession VALUES('1069','Ϣ','Information Processing','1001','69');
INSERT INTO job_profession VALUES('1070','ͨż','Communications Technology','1001','70');
INSERT INTO job_profession VALUES('1071','ͨŵԴ','Communications Power Supply Technology','1001','71');
INSERT INTO job_profession VALUES('1072','ͨӪ','Communications Operation Administration','1001','72');
INSERT INTO job_profession VALUES('1073','ܿ','Intelligent Control','1001','73');
INSERT INTO job_profession VALUES('1074','㲥ӹ','Radio and Television Engineering','1001','74');
INSERT INTO job_profession VALUES('1075','Զ','Automatic Control','1001','75');
INSERT INTO job_profession VALUES('1076','Զ','Automation','1001','76');
INSERT INTO job_profession VALUES('1077','ӦõӼ','Electronic and Information Engineering','1001','77');
INSERT INTO job_profession VALUES('1078','Ϣ','Electronic and Information Engineering','1001','78');
INSERT INTO job_profession VALUES('1079','ͨŹ','Telecommunications Engineering','1001','79');
INSERT INTO job_profession VALUES('1080','ź','Railway Signal','1001','80');
INSERT INTO job_profession VALUES('1081','ͨ뵼','Naval Architecture Communications and Navigation','1001','81');
INSERT INTO job_profession VALUES('1082','ͨŹ ','Post Communications Administration','1001','82');
INSERT INTO job_profession VALUES('1083','Զ','Post Automation Technology','1001','83');
INSERT INTO job_profession VALUES('1084','㲥Ӧü','Radio and Television Applied Technology','1001','84');
INSERT INTO job_profession VALUES('1085','豸ά','Flight Vehicle Electronic Equipment Maintenance','1001','85');
INSERT INTO job_profession VALUES('1086','豸','Naval Architecture Electronic Equipment','1001','86');
INSERT INTO job_profession VALUES('1087','ͨ','Others','1001','87');
INSERT INTO job_profession VALUES('1088','ؼ','Measuring & Control Technology and Instrumentation','1002','88');
INSERT INTO job_profession VALUES('1089','','Sensors','1002','89');
INSERT INTO job_profession VALUES('1090','','Precision Instrument','1002','90');
INSERT INTO job_profession VALUES('1091','','Test Instrument','1002','91');
INSERT INTO job_profession VALUES('1092','ѧ','Optical Instrument','1002','92');
INSERT INTO job_profession VALUES('1093','','Others','1002','93');
INSERT INTO job_profession VALUES('1094','붯','Thermal Energy and Power Engineering','1003','94');
INSERT INTO job_profession VALUES('1095','˹˼','Nuclear Engineering and Technology','1003','95');
INSERT INTO job_profession VALUES('1096','ѧ','Electromechanics','1003','96');
INSERT INTO job_profession VALUES('1097','϶','Electric Traction','1003','97');
INSERT INTO job_profession VALUES('1098','繤','Electricity Generation and Distribution Engineerin','1003','98');
INSERT INTO job_profession VALUES('1099','õ缼','Electricity Supply and Applied Technology','1003','99');
INSERT INTO job_profession VALUES('1100','糧ϵͳ','Power Plant and Power System','1003','100');
INSERT INTO job_profession VALUES('1101','繤ѧ','Electrical Engineering','1003','101');
INSERT INTO job_profession VALUES('1102','Ӽ','Power Electronics Technology','1003','102');
INSERT INTO job_profession VALUES('1103','ҵԶ','Industry Electric Automation','1003','103');
INSERT INTO job_profession VALUES('1104','̼Զ','Electrical Engineering and Automation','1003','104');
INSERT INTO job_profession VALUES('1105','','Electric Technology','1003','105');
INSERT INTO job_profession VALUES('1106','','Others','1003','106');
INSERT INTO job_profession VALUES('1107','ʳƷѧ빤','Food Science and Engineering','1004','107');
INSERT INTO job_profession VALUES('1108','ʳƷ밲ȫ','Food Chemistry and Analysis','1004','108');
INSERT INTO job_profession VALUES('1109','ʳƷӹ','Food Processing Technology','1004','109');
INSERT INTO job_profession VALUES('1110','ʳƷ뱣','Food Storage,Transport and Freshness','1004','110');
INSERT INTO job_profession VALUES('1111','ʳƷӪ','Food Nutrition and Hygiene','1004','111');
INSERT INTO job_profession VALUES('1112','ʳƷ','Food Detection','1004','112');
INSERT INTO job_profession VALUES('1113','ʳƷ֤','Food Certification','1004','113');
INSERT INTO job_profession VALUES('1114','ʳƷ΢ѧ','Food Microbiology','1004','114');
INSERT INTO job_profession VALUES('1115','ʳƷе','Food Machinery','1004','115');
INSERT INTO job_profession VALUES('1116','ʳƷװ','Food Packaging','1004','116');
INSERT INTO job_profession VALUES('1117','ʳֲ֬ﵰ׹','Cereals, Oils and Vegetable Protein Engineering','1004','117');
INSERT INTO job_profession VALUES('1118','ƹ','Wine-making Engineering','1004','118');
INSERT INTO job_profession VALUES('1119','͹','Fermentation Engineering','1004','119');
INSERT INTO job_profession VALUES('1120','߲ѧ','Olericulture','1004','120');
INSERT INTO job_profession VALUES('1121','ǹ','Sugar Engineering','1004','121');
INSERT INTO job_profession VALUES('1122','ũƷӹع','Processing and Storage of Agriculture Products','1004','122');
INSERT INTO job_profession VALUES('1123','̲ݻѧ빤','Tobacco Chemistry and Engineering','1004','123');
INSERT INTO job_profession VALUES('1124','','Cuisine','1004','124');
INSERT INTO job_profession VALUES('1125','','Western Food','1004','125');
INSERT INTO job_profession VALUES('1126','','Pastry','1004','126');
INSERT INTO job_profession VALUES('1127','','Cake','1004','127');
INSERT INTO job_profession VALUES('1128','Ʒ//','Wine Taster/Bartender','1004','128');
INSERT INTO job_profession VALUES('1129','/Ƶ/','Restaurant/Hotel/Catering Business Management','1004','129');
INSERT INTO job_profession VALUES('1130','ʳƷ','Others','1004','130');
INSERT INTO job_profession VALUES('1131','ũѧ','Agronomy','1005','131');
INSERT INTO job_profession VALUES('1132','ũ','Agronomy','1005','132');
INSERT INTO job_profession VALUES('1133','ֲ','Planting','1005','133');
INSERT INTO job_profession VALUES('1134','ũҵеԶ','Agricultural mechanization and automation','1005','134');
INSERT INTO job_profession VALUES('1135','ũҵе','Agricultural mechanization','1005','135');
INSERT INTO job_profession VALUES('1136','ũҵԶ','Agricultural electrification and automation','1005','136');
INSERT INTO job_profession VALUES('1137','ũҵԴ','Agricultural Structure Environment and Energy Engi','1005','137');
INSERT INTO job_profession VALUES('1138','ũҵﻷԴ','Agricultural Biological Environmental and Energy E','1005','138');
INSERT INTO job_profession VALUES('1139','ũҵԴ뻷','Agricultural Resources and Environment','1005','139');
INSERT INTO job_profession VALUES('1140','ũҵˮ','Agricultural Water Conservancy Engineering','1005','140');
INSERT INTO job_profession VALUES('1141','ũˮ','Farmland Water Conservancy Engineering','1005','141');
INSERT INTO job_profession VALUES('1142','ũƷӹ','Agriculture Products Processing','1005','142');
INSERT INTO job_profession VALUES('1143','ũ徭ù','Rural Economy Management','1005','143');
INSERT INTO job_profession VALUES('1144','޻ӹ','Cotton Inspection,Processing and Management','1005','144');
INSERT INTO job_profession VALUES('1145','ѧ','Pomology','1005','145');
INSERT INTO job_profession VALUES('1146','ѧ','Tea science','1005','146');
INSERT INTO job_profession VALUES('1147','ѧ','Sericulture','1005','147');
INSERT INTO job_profession VALUES('1148','ɣ','Sericulture','1005','148');
INSERT INTO job_profession VALUES('1149','԰','Horticulture','1005','149');
INSERT INTO job_profession VALUES('1150','ֲﱣ','Plant Protection','1005','150');
INSERT INTO job_profession VALUES('1151','ֲӪѧ','Plant Nutrition','1005','151');
INSERT INTO job_profession VALUES('1152','ҵѧ','Prataculture Science','1005','152');
INSERT INTO job_profession VALUES('1153','ѧ','Forestry','1005','153');
INSERT INTO job_profession VALUES('1154','ҵ','Forestry','1005','154');
INSERT INTO job_profession VALUES('1155','زƷӹ','Forest Products Processing','1005','155');
INSERT INTO job_profession VALUES('1156','ɭԴ','Forest Resources Conservation and Recreation','1005','156');
INSERT INTO job_profession VALUES('1157','ɭԴ','Forest Resources and Administration','1005','157');
INSERT INTO job_profession VALUES('1158','ɭֲ˹','Forest Felling and Transport Management','1005','158');
INSERT INTO job_profession VALUES('1159','԰','Landscape gardening','1005','159');
INSERT INTO job_profession VALUES('1160','ɭֹ','Forest Logging Engineering','1005','160');
INSERT INTO job_profession VALUES('1161','ľĿѧ빤','Wood Science and Engineering','1005','161');
INSERT INTO job_profession VALUES('1162','ľļӹ','Wood Processing','1005','162');
INSERT INTO job_profession VALUES('1163','ֲ','Chemical Processing of Forest Products','1005','163');
INSERT INTO job_profession VALUES('1164','ҰȻ','Wildlife and Natural Reserve Management','1005','164');
INSERT INTO job_profession VALUES('1165','Ұֲﱣ','Wildlife Conservation','1005','165');
INSERT INTO job_profession VALUES('1166','ˮĮ','Soil and Water Conservation and Combating Desertif','1005','166');
INSERT INTO job_profession VALUES('1167','ѧ','Animal Science','1005','167');
INSERT INTO job_profession VALUES('1168','ҽѧ','Veterinary Medicine','1005','168');
INSERT INTO job_profession VALUES('1169','ҽѧ','Veterinary Medicine','1005','169');
INSERT INTO job_profession VALUES('1170','Ŵ뷱ֳ','Animal Genetics, Breeding and Reproduction Science','1005','170');
INSERT INTO job_profession VALUES('1171','ӪϿѧ','Animal Nutrition and Feed Science','1005','171');
INSERT INTO job_profession VALUES('1172','ֳ','Aquaculture','1005','172');
INSERT INTO job_profession VALUES('1173','ˮѧ','Fisheries Science','1005','173');
INSERT INTO job_profession VALUES('1174','ˮֳѧ','Aquaculture Science','1005','174');
INSERT INTO job_profession VALUES('1175','ҵѧ뼼','Marine fishery science and technology','1005','175');
INSERT INTO job_profession VALUES('1176','','Marne Fishing','1005','176');
INSERT INTO job_profession VALUES('1177','','Marne Biology','1005','177');
INSERT INTO job_profession VALUES('1178','ѧ','Marne Science','1005','178');
INSERT INTO job_profession VALUES('1179','е켰Զ','Machine Design & Manufacturing and Automation','1006','179');
INSERT INTO job_profession VALUES('1180','ϳͼƹ','Material Processing and Control','1006','180');
INSERT INTO job_profession VALUES('1181','ҵ','Industrial Design','1006','181');
INSERT INTO job_profession VALUES('1182','װƹ','Process Equipment and Control','1006','182');
INSERT INTO job_profession VALUES('1183','Լӹ','Plastic Working','1006','183');
INSERT INTO job_profession VALUES('1184','豸','Refrigeration Equipment','1006','184');
INSERT INTO job_profession VALUES('1185','ܻе','Precision Machinery','1006','185');
INSERT INTO job_profession VALUES('1186','е','Machine Design','1006','186');
INSERT INTO job_profession VALUES('1187','е칤','Mechanical Manufacturing Technology','1006','187');
INSERT INTO job_profession VALUES('1188','һ廯','Mechanical & Electrical Integration','1006','188');
INSERT INTO job_profession VALUES('1189','','Machine and cutting Tools','1006','189');
INSERT INTO job_profession VALUES('1190','еԶ','Machine Automation','1006','190');
INSERT INTO job_profession VALUES('1191','豸е','Chemical Equipment and Machinery','1006','191');
INSERT INTO job_profession VALUES('1192','ұе','Metallurgical Machinery','1006','192');
INSERT INTO job_profession VALUES('1193','ұ𹤳','Metallurgical Engineering','1006','193');
INSERT INTO job_profession VALUES('1194','ģ','Mold Design and Manufacturing','1006','194');
INSERT INTO job_profession VALUES('1195','','Foundry','1006','195');
INSERT INTO job_profession VALUES('1196','¯','Boiler','1006','196');
INSERT INTO job_profession VALUES('1197','ӹռ豸','Welding Technology and Equipment','1006','197');
INSERT INTO job_profession VALUES('1198','Һѹ','Hydraulic Transmission','1006','198');
INSERT INTO job_profession VALUES('1199','ȴе','Heat Treatment Machinery','1006','199');
INSERT INTO job_profession VALUES('1200','֯е豸','Textile Machinery','1006','200');
INSERT INTO job_profession VALUES('1201','ȼ','Internal Combustion Engine','1006','201');
INSERT INTO job_profession VALUES('1202','','Automotive Manufacturing','1006','202');
INSERT INTO job_profession VALUES('1203','뺣󹤳','Naval Architecture and Ocean Engineering','1006','203');
INSERT INTO job_profession VALUES('1204','е','Others','1006','204');
INSERT INTO job_profession VALUES('1205','ѧ빤','Chemical Engineering and Technology','1007','205');
INSERT INTO job_profession VALUES('1206','ҩ   ','Pharmaceutical Engineering','1007','206');
INSERT INTO job_profession VALUES('1207','޻','Inorganic Chemical Engineering','1007','207');
INSERT INTO job_profession VALUES('1208','л','Organic Chemical Engineering','1007','208');
INSERT INTO job_profession VALUES('1209','绯','Electric Chemical Engineering','1007','209');
INSERT INTO job_profession VALUES('1210','ϸ','Superfine Chemical Engineering','1007','210');
INSERT INTO job_profession VALUES('1211','ﻯ','Biological Chemical Engineering','1007','211');
INSERT INTO job_profession VALUES('1212','û','Daily Chemical Engineering','1007','212');
INSERT INTO job_profession VALUES('1213','뷴Ӧ','Separation Reaction Engineering','1007','213');
INSERT INTO job_profession VALUES('1214','ʯú','Petroleum Coalification Chemical Engineering','1007','214');
INSERT INTO job_profession VALUES('1215','߷','Macromolecular','1007','215');
INSERT INTO job_profession VALUES('1216','ѧ','Chemical Analysis','1007','216');
INSERT INTO job_profession VALUES('1217','ι','Silicate Engineering','1007','217');
INSERT INTO job_profession VALUES('1218','֬','Grease','1007','218');
INSERT INTO job_profession VALUES('1219','','Others','1007','219');
INSERT INTO job_profession VALUES('1220','ữ','Light Chemical Engineering','1008','220');
INSERT INTO job_profession VALUES('1221','֯','Textile Engineering','1008','221');
INSERT INTO job_profession VALUES('1222','֯','Textile Material','1008','222');
INSERT INTO job_profession VALUES('1223','֯','Textile Technology','1008','223');
INSERT INTO job_profession VALUES('1224','ά ','Fabrics Manufacturing','1008','224');
INSERT INTO job_profession VALUES('1225','Ⱦ','Dyeing and Finishing Technology','1008','225');
INSERT INTO job_profession VALUES('1226','װ빤','Clothing Design and Engineering','1008','226');
INSERT INTO job_profession VALUES('1227','֯','Textile Others','1008','227');
INSERT INTO job_profession VALUES('1228','Ƥ＼','Leather Technology','1008','228');
INSERT INTO job_profession VALUES('1229','ӡˢ','Printing Engineering','1008','229');
INSERT INTO job_profession VALUES('1230','װ','Packaging Engineering','1008','230');
INSERT INTO job_profession VALUES('1231','ֽ','Paper Engineering','1008','231');
INSERT INTO job_profession VALUES('1232','ұ ','Ferrous Metallurgy','1009','232');
INSERT INTO job_profession VALUES('1233','ѹӹ','Metal Mechanical Treatment Technology','1009','233');
INSERT INTO job_profession VALUES('1234','ұܼ','Metallurgy Thermal Energy Technology','1009','234');
INSERT INTO job_profession VALUES('1235','̼زϼ','Carbon Material Technology','1009','235');
INSERT INTO job_profession VALUES('1236','ĩұ','Powder Metallurgy','1009','236');
INSERT INTO job_profession VALUES('1237','ɫұ','Mon-ferrous Metals Metallurgy','1009','237');
INSERT INTO job_profession VALUES('1238','е','Machinery Manufacture and Control','1009','238');
INSERT INTO job_profession VALUES('1239','ά','Automobile Manufacture and Maintenance','1009','239');
INSERT INTO job_profession VALUES('1240','еӹ','Mechanical Working Technology','1009','240');
INSERT INTO job_profession VALUES('1241','豸װά','Electromechanical Equipment Installation and Maint','1009','241');
INSERT INTO job_profession VALUES('1242','ؼӦ','Numerical Control Technology and Application','1009','242');
INSERT INTO job_profession VALUES('1243','ģ','Mould Design and Manufacture','1009','243');
INSERT INTO job_profession VALUES('1244','缼Ӧ','Electromechanical Technology and Application','1009','244');
INSERT INTO job_profession VALUES('1245','Ϳյ豸ά','Refrigeration and Air-conditioning Equipment Appli','1009','245');
INSERT INTO job_profession VALUES('1246','','Electronic Operation and Control','1009','246');
INSERT INTO job_profession VALUES('1247','Ӧ','Electronic Technology and Application','1009','247');
INSERT INTO job_profession VALUES('1248','','Electronic Machinery and Equipment','1009','248');
INSERT INTO job_profession VALUES('1249','彨','Ship Manufacture and Maintenance','1009','249');
INSERT INTO job_profession VALUES('1250','еװ','Ship Mechanism','1009','250');
INSERT INTO job_profession VALUES('1251','','Ship Electric Technology','1009','251');
INSERT INTO job_profession VALUES('1252','ȼӹ','Metal Hot-working','1009','252');
INSERT INTO job_profession VALUES('1253','','Welding','1009','253');
INSERT INTO job_profession VALUES('1254','洦','Metal Surface Treatment','1009','254');
INSERT INTO job_profession VALUES('1255','ˮṹ밲װ','Manufacture and Installation of Hydraulic Metal-St','1009','255');
INSERT INTO job_profession VALUES('1256','Ǳ','Equipment and Instrument','1009','256');
INSERT INTO job_profession VALUES('1257','ά','Photoelectric Instrument Manufacture and Maintenan','1009','257');
INSERT INTO job_profession VALUES('1258','칤','Flight Vehicle Manufacturing Technology','1009','258');
INSERT INTO job_profession VALUES('1259','豸Ǳ','Flight Vehicle Control Equipment and Instrument','1009','259');
INSERT INTO job_profession VALUES('1260','ǽϳ','Flight Vehicle Non-Metal Material Molding','1009','260');
INSERT INTO job_profession VALUES('1261','ӵӦά','Electronic Equipment Application and Maintenance','1009','261');
INSERT INTO job_profession VALUES('1262','ӲԪ','Electronic Material and Components','1009','262');
INSERT INTO job_profession VALUES('1263','΢Ӽ','Microelectronics Technology and Devices','1009','263');
INSERT INTO job_profession VALUES('1264','ѧ','Chemical Technology','1009','264');
INSERT INTO job_profession VALUES('1265','ҵ','Industrial Analysis and Inspection','1009','265');
INSERT INTO job_profession VALUES('1266','ʯ','Petroleum Processing','1009','266');
INSERT INTO job_profession VALUES('1267','ʯȻ ','Oil & Gas Storage and Transportation','1009','267');
INSERT INTO job_profession VALUES('1268','װ','Chemical Process Equipment Technology','1009','268');
INSERT INTO job_profession VALUES('1269','̼','Chemical Process Monitoring and Control','1009','269');
INSERT INTO job_profession VALUES('1270','ϸ','Superfine Chemical Engineering','1009','270');
INSERT INTO job_profession VALUES('1271','ﻯ','Biochemical Engineering','1009','271');
INSERT INTO job_profession VALUES('1272','ֲ','Chemical Processing of Forest Products','1009','272');
INSERT INTO job_profession VALUES('1273','߷Ӳϼӹ','Macromolecular Material Processing Technology','1009','273');
INSERT INTO job_profession VALUES('1274','˼Ӧ','Nuclear Technology and Application','1009','274');
INSERT INTO job_profession VALUES('1275','˻ѧ','Nuclear Chemical Engineering','1009','275');
INSERT INTO job_profession VALUES('1276','ըҩ','Explosive Technology','1009','276');
INSERT INTO job_profession VALUES('1277','ʳƷ﹤','Food Biological Technology','1009','277');
INSERT INTO job_profession VALUES('1278','ϼӹ봢','Grain & Oil & Feed Processing and Storage & Inspec','1009','278');
INSERT INTO job_profession VALUES('1279','Ƥ﹤ռƷ','Leather Technology and Manufacture','1009','279');
INSERT INTO job_profession VALUES('1280','ӡˢ','Printing Technology','1009','280');
INSERT INTO job_profession VALUES('1281','ƽֽ','Pulp & Paper Technology','1009','281');
INSERT INTO job_profession VALUES('1282','ϳ','Plastic Molding','1009','282');
INSERT INTO job_profession VALUES('1283','𽺹','Rubber Technology','1009','283');
INSERT INTO job_profession VALUES('1284','֫','Artificial Limb & Orthotics Manufacture','1009','284');
INSERT INTO job_profession VALUES('1285','Ⱦ','Dyeing and Finishing Technology','1009','285');
INSERT INTO job_profession VALUES('1286','֯','Textile Technology','1009','286');
INSERT INTO job_profession VALUES('1287','ѧά','Chemical Fiber Technology','1009','287');
INSERT INTO job_profession VALUES('1288','˿','Silk Technology','1009','288');
INSERT INTO job_profession VALUES('1289','֯','Knitting Technology','1009','289');
INSERT INTO job_profession VALUES('1290','֯ϲϹ','Textile Composite Materials Technology','1009','290');
INSERT INTO job_profession VALUES('1291','װӪ','Clothing Manufacture and Sales','1009','291');
INSERT INTO job_profession VALUES('1292','빤̲','Architecture and Engineering Material','1009','292');
INSERT INTO job_profession VALUES('1293','ιռҵ','Silicate Technology and Industrial Control','1009','293');
INSERT INTO job_profession VALUES('1294','ͨ','Traffic and Transportation','1009','294');
INSERT INTO job_profession VALUES('1295','','Railway Transportation Management','1009','295');
INSERT INTO job_profession VALUES('1296','','Electric Locomotive Application and Maintenance','1009','296');
INSERT INTO job_profession VALUES('1297','ȼ','Diesel Locomotive Application and Maintenance','1009','297');
INSERT INTO job_profession VALUES('1298','','Railway cars Application and Maintenance','1009','298');
INSERT INTO job_profession VALUES('1299','ʻ','Ship Handling','1009','299');
INSERT INTO job_profession VALUES('1300','ֻ','Motorship Engine Management','1009','300');
INSERT INTO job_profession VALUES('1301','ˮ','Ship Sailor and Machinist','1009','301');
INSERT INTO job_profession VALUES('1302','','Ocean Shipping Tally','1009','302');
INSERT INTO job_profession VALUES('1303','','Ship Inspection','1009','303');
INSERT INTO job_profession VALUES('1304','Ǳˮ','Technical Diving','1009','304');
INSERT INTO job_profession VALUES('1305','','Civil Aviaton Transportation','1009','305');
INSERT INTO job_profession VALUES('1306','ɻά','Aircraft and Engine Maintenance','1009','306');
INSERT INTO job_profession VALUES('1307','շ','Aviation Service','1009','307');
INSERT INTO job_profession VALUES('1308','Ϲ','Aviation Oil Management','1009','308');
INSERT INTO job_profession VALUES('1309','ά','Automobile Application and Maintenance','1009','309');
INSERT INTO job_profession VALUES('1310','ͨ','Communication and Transportation Management','1009','310');
INSERT INTO job_profession VALUES('1311','ߵȼ·','Highway Maintenance and Management','1009','311');
INSERT INTO job_profession VALUES('1312','湤','Surveying & Mapping Engineering','1010','312');
INSERT INTO job_profession VALUES('1313','̼','Surveying Engineering Technology','1010','313');
INSERT INTO job_profession VALUES('1314','ңм','Surveying & Remote Sensing Technology','1010','314');
INSERT INTO job_profession VALUES('1315','Ӱ','Aerial Surveying','1010','315');
INSERT INTO job_profession VALUES('1316','','Marine Surveying','1010','316');
INSERT INTO job_profession VALUES('1317','','Surveying Instrument','1010','317');
INSERT INTO job_profession VALUES('1318','ͼͼ','Cartography','1010','318');
INSERT INTO job_profession VALUES('1319','ͼͼϢ','Cartography and Geographic Information','1010','319');
INSERT INTO job_profession VALUES('1320','','Others','1010','320');
INSERT INTO job_profession VALUES('1321','ұ𹤳','Metallurgical Engineering','1011','321');
INSERT INTO job_profession VALUES('1322','Ϲ','Metallic Materials Engineering','1011','322');
INSERT INTO job_profession VALUES('1323','޻ǽϹ','Inorganic Nonmetallic Materials Engineering','1011','323');
INSERT INTO job_profession VALUES('1324','߷Ӳ빤','Macromolecular Materials and Engineering','1011','324');
INSERT INTO job_profession VALUES('1325','ϼȴ','Metal Material and Heat Treatment','1011','325');
INSERT INTO job_profession VALUES('1326','','Materials Physics','1011','326');
INSERT INTO job_profession VALUES('1327','ϻѧ','Materials Chemistry','1011','327');
INSERT INTO job_profession VALUES('1328','ʴ','Cankerous and Protection ','1011','328');
INSERT INTO job_profession VALUES('1329','ϲ','Composite Material','1011','329');
INSERT INTO job_profession VALUES('1330','','Others','1011','330');
INSERT INTO job_profession VALUES('1331','ѧ','Architecture','1012','331');
INSERT INTO job_profession VALUES('1332','й滮','Urban Planning','1012','332');
INSERT INTO job_profession VALUES('1333','','Municipal Engineering','1012','333');
INSERT INTO job_profession VALUES('1334','ʩ','Municipal Engineering Construction','1012','334');
INSERT INTO job_profession VALUES('1335','','Urban Construction','1012','335');
INSERT INTO job_profession VALUES('1336','ľ','Civil Engineering','1012','336');
INSERT INTO job_profession VALUES('1337','豸','Building Environment and Equipment Engineering','1012','337');
INSERT INTO job_profession VALUES('1338','ʩеά','Construction Machinery Application and Maintenance','1012','338');
INSERT INTO job_profession VALUES('1339','豸װ','Architectural Equipment Installation','1012','339');
INSERT INTO job_profession VALUES('1340','ѧ','Engineering Mechanics','1012','340');
INSERT INTO job_profession VALUES('1341','ˮˮ','Water Supply and Sewerage Engineering ','1012','341');
INSERT INTO job_profession VALUES('1342','ˮˮ繤','Water Conservancy and Hydropower Engineering','1012','342');
INSERT INTO job_profession VALUES('1343','ˮˮ繤̼','Water Conservancy and Hydropower Engineering','1012','343');
INSERT INTO job_profession VALUES('1344','ˮ繤̽ʩ','Hydropower Engineering Construction','1012','344');
INSERT INTO job_profession VALUES('1345','ũҵˮ','Agricultural Hydraulic Technology','1012','345');
INSERT INTO job_profession VALUES('1346','ˮˮԴ','Hydrology and Water Resources Engineering','1012','346');
INSERT INTO job_profession VALUES('1347','ۿں뺣','Harbours, Water Channels and Coast Engineering','1012','347');
INSERT INTO job_profession VALUES('1348','ۿ뺽̼','Harbours and Water Channels Engineering Technology','1012','348');
INSERT INTO job_profession VALUES('1349','·','Highway and Bridge','1012','349');
INSERT INTO job_profession VALUES('1350','ʩ','Railway Construction and Maintenance','1012','350');
INSERT INTO job_profession VALUES('1351','ҵý','Industrial and Civil Buildings','1012','351');
INSERT INTO job_profession VALUES('1352','󾮽','Mines Construction','1012','352');
INSERT INTO job_profession VALUES('1353','ͨ','Heat Supply and Ventilation','1012','353');
INSERT INTO job_profession VALUES('1354','ͨյ','Heat Supply & Ventilation and Air-conditioning','1012','354');
INSERT INTO job_profession VALUES('1355','Ʒ','Building Materials and Products','1012','355');
INSERT INTO job_profession VALUES('1356','ˮ','Cement Manufacture','1012','356');
INSERT INTO job_profession VALUES('1357','ز','Real Estate','1012','357');
INSERT INTO job_profession VALUES('1358','װ','Decorative Design','1012','358');
INSERT INTO job_profession VALUES('1359','װ','Architectural Decoration','1012','359');
INSERT INTO job_profession VALUES('1360','Ԥ','Budget and Final Account of Construction','1012','360');
INSERT INTO job_profession VALUES('1361','','Architectural Engineering Design','1012','361');
INSERT INTO job_profession VALUES('1362','','Building Electrical Design','1012','362');
INSERT INTO job_profession VALUES('1363','豸װ','Electric Equipment Installation','1012','363');
INSERT INTO job_profession VALUES('1364','湤','Surveying & Mapping Engineering','1012','364');
INSERT INTO job_profession VALUES('1365','','Environmental Engineering','1012','365');
INSERT INTO job_profession VALUES('1366','ܵ','Pipeline Engineering','1012','366');
INSERT INTO job_profession VALUES('1367','','Tunnel Engineering','1012','367');
INSERT INTO job_profession VALUES('1368','','Bridge Engineering','1012','368');
INSERT INTO job_profession VALUES('1369','԰','Landscape Design','1012','369');
INSERT INTO job_profession VALUES('1370','ù','Architectural Economy Management','1012','370');
INSERT INTO job_profession VALUES('1371','ŽӪ','Ancient Architecture Building and Repair','1012','371');
INSERT INTO job_profession VALUES('1372','','Civil Engineering and Material Inspection','1012','372');
INSERT INTO job_profession VALUES('1373','','Others','1012','373');
INSERT INTO job_profession VALUES('1374','ͨ','Traffic and Transportation','1013','374');
INSERT INTO job_profession VALUES('1375','ͨ','Traffic Engineering','1013','375');
INSERT INTO job_profession VALUES('1376','˹','Petroleum and Gas Storage and Transportation Engin','1013','376');
INSERT INTO job_profession VALUES('1377','м','Aviation Technology','1013','377');
INSERT INTO job_profession VALUES('1378','','Navigation Technology','1013','378');
INSERT INTO job_profession VALUES('1379','ֻ','Marine Engineering','1013','379');
INSERT INTO job_profession VALUES('1380','·','Highway Engineering','1013','380');
INSERT INTO job_profession VALUES('1381','·','Railway Transportation','1013','381');
INSERT INTO job_profession VALUES('1382','','Air Transportation','1013','382');
INSERT INTO job_profession VALUES('1383','ˮ·','Waterway Transportation','1013','383');
INSERT INTO job_profession VALUES('1384','·','Highway Transportation','1013','384');
INSERT INTO job_profession VALUES('1385','','Bridge Engineering','1013','385');
INSERT INTO job_profession VALUES('1386','뺣󹤳','Naval Architecture and Ocean Engineering','1013','386');
INSERT INTO job_profession VALUES('1387','','Others','1013','387');
INSERT INTO job_profession VALUES('1388','ˮˮ繤','Water Conservancy and Hydropower Engineering','1014','388');
INSERT INTO job_profession VALUES('1389','ˮˮԴ','Hydrology and Water Resources Engineering','1014','389');
INSERT INTO job_profession VALUES('1390','ۿں뺣','Harbours, Water Channels and Coast Engineering','1014','390');
INSERT INTO job_profession VALUES('1391','','Energy Storage','1014','391');
INSERT INTO job_profession VALUES('1392','','Energy Saving','1014','392');
INSERT INTO job_profession VALUES('1393','','Nuclear Energy','1014','393');
INSERT INTO job_profession VALUES('1394','ˮʩ','Water Conservancy Construction','1014','394');
INSERT INTO job_profession VALUES('1395','ʯͿ','Petroleum Exploitation','1014','395');
INSERT INTO job_profession VALUES('1396','˿󿪲','Uranium Ore Exploitation','1014','396');
INSERT INTO job_profession VALUES('1397','ѡú','Coal Preparation','1014','397');
INSERT INTO job_profession VALUES('1398','糧豸','Thermodynamics Equipment Operation of Power Plant','1014','398');
INSERT INTO job_profession VALUES('1399','ˮ糧豸','Electromechanical Equipment Operation of Hydropowe','1014','399');
INSERT INTO job_profession VALUES('1400','糧ȹǱԶװ','Heat Engineering Instrument and Automation Equipme','1014','400');
INSERT INTO job_profession VALUES('1401','糧ˮѧල','Water Treatment and Chemical Supervision of Power ','1014','401');
INSERT INTO job_profession VALUES('1402','糧豸װ','Thermodynamics Equipment Installation and Inspecti','1014','402');
INSERT INTO job_profession VALUES('1403','ˮ糧豸װά','Power Equipment Installation and Maintenance of Hy','1014','403');
INSERT INTO job_profession VALUES('1404','糧վ','Electrical Operation of Electric Plant and Substat','1014','404');
INSERT INTO job_profession VALUES('1405','̵籣Զװά','Relay Protection and Automation Equipment Maintena','1014','405');
INSERT INTO job_profession VALUES('1406','糧վ豸','Electric Plant and Substation Equipment','1014','406');
INSERT INTO job_profession VALUES('1407','ˮվˮվ豸','Electrical Equipment of Hydropower Station and Pum','1014','407');
INSERT INTO job_profession VALUES('1408','·ʩ','Electric line Construction and Maintenance','1014','408');
INSERT INTO job_profession VALUES('1409','ʩ','Electric Power Cable Operation and Construction','1014','409');
INSERT INTO job_profession VALUES('1410','õ缼','Electricity Supply and Applied Technology','1014','410');
INSERT INTO job_profession VALUES('1411','','Electrified Railway Power Supply','1014','411');
INSERT INTO job_profession VALUES('1412','ũԴ','Rural Energy Development and Utilization','1014','412');
INSERT INTO job_profession VALUES('1413','Ӫ','Electric Power Marketing','1014','413');
INSERT INTO job_profession VALUES('1414','豸װ','Electric Equipment Installation','1014','414');
INSERT INTO job_profession VALUES('1415','ͨյ','Heat Supply & Ventilation and Air-conditioning','1014','415');
INSERT INTO job_profession VALUES('1416','ˮˮ繤̼','Water Conservancy and Hydropower Engineering Techn','1014','416');
INSERT INTO job_profession VALUES('1417','ũҵˮ','Agricultural Water Conservancy Technology','1014','417');
INSERT INTO job_profession VALUES('1418','ˮ繤̽ʩ','Hydropower Engineering Construction','1014','418');
INSERT INTO job_profession VALUES('1419','󹤳','Ocean Engineering','1014','419');
INSERT INTO job_profession VALUES('1420','Դ','Others','1014','420');
INSERT INTO job_profession VALUES('1421','','Biology','1015','421');
INSERT INTO job_profession VALUES('1422','ֲ','Botany','1015','422');
INSERT INTO job_profession VALUES('1423','＼','Biological Technology','1015','423');
INSERT INTO job_profession VALUES('1424','﹤','Biotechnology','1015','424');
INSERT INTO job_profession VALUES('1425','Ŵ','Biological Heritage','1015','425');
INSERT INTO job_profession VALUES('1426','ҽѧ','Biomedical Engineering','1015','426');
INSERT INTO job_profession VALUES('1427','','Others','1015','427');
INSERT INTO job_profession VALUES('1428','ҽѧ','Basic Medical Sciences','1016','428');
INSERT INTO job_profession VALUES('1429','Ԥҽѧ','Public Health','1016','429');
INSERT INTO job_profession VALUES('1430','ٴҽѧ','Clinical Medicine','1016','430');
INSERT INTO job_profession VALUES('1431','ѧ','Anesthesiology','1016','431');
INSERT INTO job_profession VALUES('1432','ҽѧӰѧ','Medical Imaging','1016','432');
INSERT INTO job_profession VALUES('1433','ҽѧӰ','Medical Imaging Technology','1016','433');
INSERT INTO job_profession VALUES('1434','ҽѧ','Medical Laboratory Tests and Analyses','1016','434');
INSERT INTO job_profession VALUES('1435','ҽѧ鼼','Medical Laboratory Tests and Analyses Technology','1016','435');
INSERT INTO job_profession VALUES('1436','ǻҽѧ','Stomatology ','1016','436');
INSERT INTO job_profession VALUES('1437','ǻռ','Stomatology Technology','1016','437');
INSERT INTO job_profession VALUES('1438','ҽѧ','Chinese Medicine','1016','438');
INSERT INTO job_profession VALUES('1439','ҽ','Chinese Medical Traumatology & Orthopedics','1016','439');
INSERT INTO job_profession VALUES('1440','ҽ','Chinese Medical Nursing','1016','440');
INSERT INTO job_profession VALUES('1441','ҽѧ','Western Medicine','1016','441');
INSERT INTO job_profession VALUES('1442','ѧ','Acupuncture Moxibustion and Massage','1016','442');
INSERT INTO job_profession VALUES('1443','ҽѧ','Mongolian Medicine','1016','443');
INSERT INTO job_profession VALUES('1444','ҽҽҩ','Mongolian Medical Service and Medicine','1016','444');
INSERT INTO job_profession VALUES('1445','άҽҽ','Uygur Medical Service','1016','445');
INSERT INTO job_profession VALUES('1446','ҽѧ','Tibetan Medicine','1016','446');
INSERT INTO job_profession VALUES('1447','ҩҽ','Tibetan Medical Service','1016','447');
INSERT INTO job_profession VALUES('1448','ҽѧ','Medical Jurisprudence','1016','448');
INSERT INTO job_profession VALUES('1449','ѧ','Nursing','1016','449');
INSERT INTO job_profession VALUES('1450','','Nursing','1016','450');
INSERT INTO job_profession VALUES('1451','','Midwifery','1016','451');
INSERT INTO job_profession VALUES('1452','ҩѧ','Pharmacy','1016','452');
INSERT INTO job_profession VALUES('1453','ҩ','Pharmaceutical Preparations','1016','453');
INSERT INTO job_profession VALUES('1454','ҩѧ','Traditional Chinese Pharmacy','1016','454');
INSERT INTO job_profession VALUES('1455','ҩҩ','Chinese Pharmaceutical Science','1016','455');
INSERT INTO job_profession VALUES('1456','ҩ','Chinese Medical Rehabilitation and Health','1016','456');
INSERT INTO job_profession VALUES('1457','ҩѧ','Western Pharmacy','1016','457');
INSERT INTO job_profession VALUES('1458','ҽѧ','Special Medicine','1016','458');
INSERT INTO job_profession VALUES('1459','ҩƼ','Pharmaceutical Preparations','1016','459');
INSERT INTO job_profession VALUES('1460','ҩ','Pharmaceutical Engineering','1016','460');
INSERT INTO job_profession VALUES('1461','ҽҩ','Biological Medicine Engineering','1016','461');
INSERT INTO job_profession VALUES('1462','ҽѧ＼','Biomedical Engineering','1016','462');
INSERT INTO job_profession VALUES('1463','','Quarantine','1016','463');
INSERT INTO job_profession VALUES('1464','','Radiology','1016','464');
INSERT INTO job_profession VALUES('1465','','Health Care','1016','465');
INSERT INTO job_profession VALUES('1466','ƻ','Family Planning Technology','1016','466');
INSERT INTO job_profession VALUES('1467','˿ƻ','Population and Family Planning Management','1016','467');
INSERT INTO job_profession VALUES('1468','Ϣ','Health Information Management','1016','468');
INSERT INTO job_profession VALUES('1469','ӹ⼼','Eye Technology','1016','469');
INSERT INTO job_profession VALUES('1470','','Rehabilitation Technology','1016','470');
INSERT INTO job_profession VALUES('1471','ҽҩѧ','Others','1016','471');
INSERT INTO job_profession VALUES('1472','ɿ󹤳','Mining Engineering','1017','472');
INSERT INTO job_profession VALUES('1473','ɿ','Mining Technology','1017','473');
INSERT INTO job_profession VALUES('1474','ʯ͹','Petroleum Engineering','1017','474');
INSERT INTO job_profession VALUES('1475','ӹ','Minerals Processing Engineering','1017','475');
INSERT INTO job_profession VALUES('1476','鼼빤','Prospecting Techniques and Engineering','1017','476');
INSERT INTO job_profession VALUES('1477','Դ鹤','Natural Resources Prospecting Engineering','1017','477');
INSERT INTO job_profession VALUES('1478','Դ','Land and Resources Investigation','1017','478');
INSERT INTO job_profession VALUES('1479','','Geology','1017','479');
INSERT INTO job_profession VALUES('1480','ʵҿ','Geological Survey and Prospecting','1017','480');
INSERT INTO job_profession VALUES('1481','ɽеά','Mining Equipment Operation and Maintenance','1017','481');
INSERT INTO job_profession VALUES('1482','ͨ밲ȫ','Mine Ventilation and Safety','1017','482');
INSERT INTO job_profession VALUES('1483','̽','Geological Prospecting','1017','483');
INSERT INTO job_profession VALUES('1484','Կղ뿱̽','Radioactive Minerals Prospecting','1017','484');
INSERT INTO job_profession VALUES('1485','ˮĵ빤̵ʿ̽','Prospecting of Hydrogeology and Engineering Geolog','1017','485');
INSERT INTO job_profession VALUES('1486','̽','Prospecting and Tunneling','1017','486');
INSERT INTO job_profession VALUES('1487','ѧ̽','Detection of Geophysics and Geochemistry','1017','487');
INSERT INTO job_profession VALUES('1488','','Geotechnical Engineering','1017','488');
INSERT INTO job_profession VALUES('1489','̼','Geotechnical Engineering Technology','1017','489');
INSERT INTO job_profession VALUES('1490','ұ𹤳','Metallurgical Engineering','1017','490');
INSERT INTO job_profession VALUES('1491','鱦','Jewellery Technology','1017','491');
INSERT INTO job_profession VALUES('1492','⼼','Seismic monitoring Technology','1017','492');
INSERT INTO job_profession VALUES('1493','ʯӹ','Gemological Qualification and Processing','1017','493');
INSERT INTO job_profession VALUES('1494','','Others about Geology','1017','494');
INSERT INTO job_profession VALUES('1495','ɽұ','Others about Metallurgy','1017','495');
INSERT INTO job_profession VALUES('1496','ѧ','Environmental Science','1018','496');
INSERT INTO job_profession VALUES('1497','','Environmental Engineering','1018','497');
INSERT INTO job_profession VALUES('1498','','Environmental Supervision','1018','498');
INSERT INTO job_profession VALUES('1499','ȫ','Safety Engineering','1018','499');
INSERT INTO job_profession VALUES('1500','','Environmental Monitoring','1018','500');
INSERT INTO job_profession VALUES('1501','','Environmental Protection and Monitoring','1018','501');
INSERT INTO job_profession VALUES('1502','','Environment Improvement Technology','1018','502');
INSERT INTO job_profession VALUES('1503','','Radiation Measurement and Protection','1018','503');
INSERT INTO job_profession VALUES('1504','̬ѧ','Ecology','1018','504');
INSERT INTO job_profession VALUES('1505','̬','Ecological Environment Protection','1018','505');
INSERT INTO job_profession VALUES('1506','ˮˮԴ','Hydrology and Water Resources','1018','506');
INSERT INTO job_profession VALUES('1507','ˮĮ','Soil and Water Conservation and Desertification Co','1018','507');
INSERT INTO job_profession VALUES('1508','ˮ̬','Soil and Water Conservation and Ecological Environ','1018','508');
INSERT INTO job_profession VALUES('1509','','Meteorology','1018','509');
INSERT INTO job_profession VALUES('1510','߿̽','Radiosonde-radiowind Ascents','1018','510');
INSERT INTO job_profession VALUES('1511','۲','Ocean Observation','1018','511');
INSERT INTO job_profession VALUES('1512','','Others','1018','512');
INSERT INTO job_profession VALUES('1513','ѧ','Management Science','1019','513');
INSERT INTO job_profession VALUES('1514','ϢϢϵͳ','Information Management & Information System','1019','514');
INSERT INTO job_profession VALUES('1515','ҵ','Industrial Engineering','1019','515');
INSERT INTO job_profession VALUES('1516','̹','Project Management','1019','516');
INSERT INTO job_profession VALUES('1517','̹','Business Administration','1019','517');
INSERT INTO job_profession VALUES('1518','гӪ','Marketing','1019','518');
INSERT INTO job_profession VALUES('1519','ѧ','Accounting','1019','519');
INSERT INTO job_profession VALUES('1520','Ƶ㻯','Accounting Computerization','1019','520');
INSERT INTO job_profession VALUES('1521','','Financial Management','1019','521');
INSERT INTO job_profession VALUES('1522','Դ','Human Resource Management','1019','522');
INSERT INTO job_profession VALUES('1523','ι','Tourism management','1019','523');
INSERT INTO job_profession VALUES('1524','','General Administration','1019','524');
INSERT INTO job_profession VALUES('1525','ҵ','Public Utilities Management','1019','525');
INSERT INTO job_profession VALUES('1526','Ͷᱣ','Labor and Social Security','1019','526');
INSERT INTO job_profession VALUES('1527','Դ','Land Resources Management','1019','527');
INSERT INTO job_profession VALUES('1528','ũҵù','Agricultural/forest economy management','1019','528');
INSERT INTO job_profession VALUES('1529','ũչ','Rural regional development','1019','529');
INSERT INTO job_profession VALUES('1530','ͼѧ','Library Science','1019','530');
INSERT INTO job_profession VALUES('1531','ѧ','Archive Science','1019','531');
INSERT INTO job_profession VALUES('1532','ҵ','Enterprise Management','1019','532');
INSERT INTO job_profession VALUES('1533','ù','Economic Management','1019','533');
INSERT INTO job_profession VALUES('1534','ʹ','Material Management','1019','534');
INSERT INTO job_profession VALUES('1535','','Administrative Management','1019','535');
INSERT INTO job_profession VALUES('1536','Ƶ','Hotel Management','1019','536');
INSERT INTO job_profession VALUES('1537','ҵ','Property Management','1019','537');
INSERT INTO job_profession VALUES('1538','ҵ߻','Business Planning','1019','538');
INSERT INTO job_profession VALUES('1539','','Others','1019','539');
INSERT INTO job_profession VALUES('1540','ѧ','Mathematics','1020','540');
INSERT INTO job_profession VALUES('1541','Ӧѧ','Applied Mathematics','1020','541');
INSERT INTO job_profession VALUES('1542','ѧӦѧ','Mathematics and Applied Mathematics','1020','542');
INSERT INTO job_profession VALUES('1543','Ϣѧ','Information and Computing Science','1020','543');
INSERT INTO job_profession VALUES('1544','ѧ','Physics','1020','544');
INSERT INTO job_profession VALUES('1545','Ӧѧ','Applied Physics','1020','545');
INSERT INTO job_profession VALUES('1546','ѧ','Chemistry','1020','546');
INSERT INTO job_profession VALUES('1547','Ӧûѧ','Applied Chemistry','1020','547');
INSERT INTO job_profession VALUES('1548','ѧ','Biological Science','1020','548');
INSERT INTO job_profession VALUES('1549','΢ѧ','Microbiology','1020','549');
INSERT INTO job_profession VALUES('1550','ϸѧ','Cell Biology','1020','550');
INSERT INTO job_profession VALUES('1551','ѧ','Molecular Biology','1020','551');
INSERT INTO job_profession VALUES('1552','ﻯѧ','Biochemistry','1020','552');
INSERT INTO job_profession VALUES('1553','＼','Biotechnology','1020','553');
INSERT INTO job_profession VALUES('1554','ѧ','Astronomy','1020','554');
INSERT INTO job_profession VALUES('1555','ѧ','Geology','1020','555');
INSERT INTO job_profession VALUES('1556','ѧ','Geochemistry','1020','556');
INSERT INTO job_profession VALUES('1557','ѧ','Geography','1020','557');
INSERT INTO job_profession VALUES('1558','Դ滮','Urban and Rural Planning & Resource management','1020','558');
INSERT INTO job_profession VALUES('1559','Ϣϵͳ','Geographical Information System','1020','559');
INSERT INTO job_profession VALUES('1560','ѧ','Geophysics','1020','560');
INSERT INTO job_profession VALUES('1561','ѧ','Atmospheric Science','1020','561');
INSERT INTO job_profession VALUES('1562','Ӧѧ','Applied Meteorology','1020','562');
INSERT INTO job_profession VALUES('1563','ѧ','Marne Science','1020','563');
INSERT INTO job_profession VALUES('1564','','Marine Technology','1020','564');
INSERT INTO job_profession VALUES('1565','Ӧѧ','Theoretical and Applied Mechanics','1020','565');
INSERT INTO job_profession VALUES('1566','Ϣѧ뼼','Electronic and Information Science and Technology','1020','566');
INSERT INTO job_profession VALUES('1567','΢ѧ','Microelectronics','1020','567');
INSERT INTO job_profession VALUES('1568','Ϣѧ뼼','Optical Information Science and Technology','1020','568');
INSERT INTO job_profession VALUES('1569','','Material Physics','1020','569');
INSERT INTO job_profession VALUES('1570','ϻѧ','Material Chemistry','1020','570');
INSERT INTO job_profession VALUES('1571','ѧ','Environmental Science','1020','571');
INSERT INTO job_profession VALUES('1572','̬ѧ','Ecology','1020','572');
INSERT INTO job_profession VALUES('1573','ѧ','Psychology','1020','573');
INSERT INTO job_profession VALUES('1574','Ӧѧ','Applied Psychology','1020','574');
INSERT INTO job_profession VALUES('1575','ͳѧ','Statistics','1020','575');
INSERT INTO job_profession VALUES('1576','ѧ','Mechanics','1020','576');
INSERT INTO job_profession VALUES('1577','Ϣѧ','Informatics','1020','577');
INSERT INTO job_profession VALUES('1578','ӹ','Machine Working','1021','578');
INSERT INTO job_profession VALUES('1579','ά','Electric Appliance Repairing','1021','579');
INSERT INTO job_profession VALUES('1580','̨ƹ','Stage Lights and Acoustics Control','1021','580');
INSERT INTO job_profession VALUES('1581','¯','Boiler Worker','1021','581');
INSERT INTO job_profession VALUES('1582','','Security Guard','1021','582');
INSERT INTO job_profession VALUES('1583','纸','Welding Worker','1021','583');
INSERT INTO job_profession VALUES('1584','˾ά','Driving and Maintenance','1021','584');
INSERT INTO job_profession VALUES('1585','繤','Electrician','1021','585');
INSERT INTO job_profession VALUES('1586','','Hair & Beauty','1021','586');
INSERT INTO job_profession VALUES('1587','Ա','Waiter','1021','587');
INSERT INTO job_profession VALUES('1588','Ű','Composition','1021','588');
INSERT INTO job_profession VALUES('1589','΢¼','Typist','1021','589');
INSERT INTO job_profession VALUES('1590','','Others','1021','590');
INSERT INTO job_profession VALUES('1591','ѧ','Economics','1022','591');
INSERT INTO job_profession VALUES('1592','ʾó','International Economics & Trade','1022','592');
INSERT INTO job_profession VALUES('1593','ѧ','Public Finance','1022','593');
INSERT INTO job_profession VALUES('1594','ѧ','Finance and Banking','1022','594');
INSERT INTO job_profession VALUES('1595','ʾ','International Economics','1022','595');
INSERT INTO job_profession VALUES('1596','ҵ','Industry Economics','1022','596');
INSERT INTO job_profession VALUES('1597','ҵ','Business Economics','1022','597');
INSERT INTO job_profession VALUES('1598','ѧ','Insurance','1022','598');
INSERT INTO job_profession VALUES('1599','̻','Business Accounting','1023','599');
INSERT INTO job_profession VALUES('1600','','Cashier','1023','600');
INSERT INTO job_profession VALUES('1601','л','Bank Accounting','1023','601');
INSERT INTO job_profession VALUES('1602','ó','Foreign Trade Accounting','1023','602');
INSERT INTO job_profession VALUES('1603','Ƶ㻯','Accounting Computerization','1023','603');
INSERT INTO job_profession VALUES('1604','ѧ','Auditing','1024','604');
INSERT INTO job_profession VALUES('1605','ͳѧ','Statistics','1024','605');
INSERT INTO job_profession VALUES('1606','','Finance Management','1025','606');
INSERT INTO job_profession VALUES('1607','˰','Taxation Management','1025','607');
INSERT INTO job_profession VALUES('1608','Ŵ','Credit','1026','608');
INSERT INTO job_profession VALUES('1609','Ͷ','Investment','1026','609');
INSERT INTO job_profession VALUES('1610','','Finance','1026','610');
INSERT INTO job_profession VALUES('1611','','Finance and Banking','1026','611');
INSERT INTO job_profession VALUES('1612','ʽ','International Finance','1026','612');
INSERT INTO job_profession VALUES('1613','֤ȯ','Securities','1026','613');
INSERT INTO job_profession VALUES('1614','ڻ','Futures','1026','614');
INSERT INTO job_profession VALUES('1615','','Insurance','1026','615');
INSERT INTO job_profession VALUES('1616','','Public Finance Affairs','1027','616');
INSERT INTO job_profession VALUES('1617','','Accounting','1027','617');
INSERT INTO job_profession VALUES('1618','','Auditing Affairs','1027','618');
INSERT INTO job_profession VALUES('1619','','Finance Affairs','1027','619');
INSERT INTO job_profession VALUES('1620','˰','Taxation Affairs','1027','620');
INSERT INTO job_profession VALUES('1621','ͳ','Statistics','1027','621');
INSERT INTO job_profession VALUES('1622','ͳƵϢ','Statistic Investigation and Information Service','1027','622');
INSERT INTO job_profession VALUES('1623','','Prices','1027','623');
INSERT INTO job_profession VALUES('1624','Ӫҵ','Sales Business','1028','624');
INSERT INTO job_profession VALUES('1625','ѧ','Philosophy','1029','625');
INSERT INTO job_profession VALUES('1626','ѧ','Philosophy of Marxism & Leninism','1029','626');
INSERT INTO job_profession VALUES('1627','Ȼ֤','Natural Dialectics','1029','627');
INSERT INTO job_profession VALUES('1628','ѧ','Eastern Philosophy','1029','628');
INSERT INTO job_profession VALUES('1629','ѧ','Western Philosophy','1029','629');
INSERT INTO job_profession VALUES('1630','ִѧ','Modern Philosophy','1029','630');
INSERT INTO job_profession VALUES('1631','߼ѧ','Logic','1029','631');
INSERT INTO job_profession VALUES('1632','ѧ','Ethics','1029','632');
INSERT INTO job_profession VALUES('1633','ѧ','Aesthetics','1029','633');
INSERT INTO job_profession VALUES('1634','ڽѧ','Science of Religion','1029','634');
INSERT INTO job_profession VALUES('1635','ѧ','Psychology','1030','635');
INSERT INTO job_profession VALUES('1636','Ӧѧ','Applied Psychology','1030','636');
INSERT INTO job_profession VALUES('1637','ʷѧ','Historical','1031','637');
INSERT INTO job_profession VALUES('1638','ʷ','World History','1031','638');
INSERT INTO job_profession VALUES('1639','ѧ','Archaeology','1031','639');
INSERT INTO job_profession VALUES('1640','ѧ','Museology','1031','640');
INSERT INTO job_profession VALUES('1641','ѧ','Ethnology','1031','641');
INSERT INTO job_profession VALUES('1642','йʷ','Chinese History','1031','642');
INSERT INTO job_profession VALUES('1643','ʷ','Others','1031','643');
INSERT INTO job_profession VALUES('1644','ѧ','Law','1032','644');
INSERT INTO job_profession VALUES('1645','ѧʹ˶','Scientific Socialism & International Communist Mov','1032','645');
INSERT INTO job_profession VALUES('1646','йʷйʷ','History of the Chinese Revolution & History of the','1032','646');
INSERT INTO job_profession VALUES('1647','ѧ','Sociology','1032','647');
INSERT INTO job_profession VALUES('1648','Ṥ','Social Work','1032','648');
INSERT INTO job_profession VALUES('1649','ѧ','Political Sciences','1032','649');
INSERT INTO job_profession VALUES('1650','ѧѧ','Political Science & Public Administration','1032','650');
INSERT INTO job_profession VALUES('1651','','International Politics','1032','651');
INSERT INTO job_profession VALUES('1652','⽻ѧ','Science of Diplomacy','1032','652');
INSERT INTO job_profession VALUES('1653','˼ν','Idea logical & Political Education','1032','653');
INSERT INTO job_profession VALUES('1654','ΰѧ','Science of Public Order','1032','654');
INSERT INTO job_profession VALUES('1655','ѧ','Science of Criminal Investigation','1032','655');
INSERT INTO job_profession VALUES('1656','߷','Management of Frontier Order','1032','656');
INSERT INTO job_profession VALUES('1657','۷ѧ','Jurisprudence','1032','657');
INSERT INTO job_profession VALUES('1658','ŷѧ','Department Law','1032','658');
INSERT INTO job_profession VALUES('1659','ʷѧ','International law','1032','659');
INSERT INTO job_profession VALUES('1660','÷','Economic Law','1032','660');
INSERT INTO job_profession VALUES('1661','ѧ','Others','1032','661');
INSERT INTO job_profession VALUES('1662','ѧ','Sociology','1033','662');
INSERT INTO job_profession VALUES('1663','˿ѧ','Demography','1033','663');
INSERT INTO job_profession VALUES('1664','ѧ','Ethnology','1033','664');
INSERT INTO job_profession VALUES('1665','ѧ','Political Science','1033','665');
INSERT INTO job_profession VALUES('1666','','Others','1033','666');
INSERT INTO job_profession VALUES('1667','ѧ','Musicology','1034','667');
INSERT INTO job_profession VALUES('1668','','Music','1034','668');
INSERT INTO job_profession VALUES('1669','','Composition and Theories of Composition','1034','669');
INSERT INTO job_profession VALUES('1670','ֱ','Music Performance','1034','670');
INSERT INTO job_profession VALUES('1671','','Vocal Music','1034','671');
INSERT INTO job_profession VALUES('1672','','Instrumental Music','1034','672');
INSERT INTO job_profession VALUES('1673','滭','Painting','1034','673');
INSERT INTO job_profession VALUES('1674','','Sculpture','1034','674');
INSERT INTO job_profession VALUES('1675','ѧ','Research of Fine Arts','1034','675');
INSERT INTO job_profession VALUES('1676','','Arts and Crafts','1034','676');
INSERT INTO job_profession VALUES('1677','滭','Fine Arts and Painting','1034','677');
INSERT INTO job_profession VALUES('1678','','Aesthetic Design','1034','678');
INSERT INTO job_profession VALUES('1679','ѧ','Artistic Design Theories','1034','679');
INSERT INTO job_profession VALUES('1680','','Artistic Designing','1034','680');
INSERT INTO job_profession VALUES('1681','赸ѧ','Dancology','1034','681');
INSERT INTO job_profession VALUES('1682','赸ർ','Choreography','1034','682');
INSERT INTO job_profession VALUES('1683','Ϸѧ','Dramaturgy','1034','683');
INSERT INTO job_profession VALUES('1684','','Acting','1034','684');
INSERT INTO job_profession VALUES('1685','赸','Dance Performance','1034','685');
INSERT INTO job_profession VALUES('1686','Ϸ','Opera Performance','1034','686');
INSERT INTO job_profession VALUES('1687','ձ','Quyi Performance','1034','687');
INSERT INTO job_profession VALUES('1688','Ϸ','Drama Performance','1034','688');
INSERT INTO job_profession VALUES('1689','Ӽħ','Acrobatics & Magic Performance','1034','689');
INSERT INTO job_profession VALUES('1690','ľżƤӰݼ','Puppet & Shadow Puppet Performance and Manufacture','1034','690');
INSERT INTO job_profession VALUES('1691','','Directing','1034','691');
INSERT INTO job_profession VALUES('1692','ϷӰѧ','Literature of Theatre Film & Television','1034','692');
INSERT INTO job_profession VALUES('1693','ϷӰ','Artistic Design of Theatre Film & Television','1034','693');
INSERT INTO job_profession VALUES('1694','Ӱ','Photography','1034','694');
INSERT INTO job_profession VALUES('1695','¼','Recording Arts','1034','695');
INSERT INTO job_profession VALUES('1696','','Science of Animated Cartoon','1034','696');
INSERT INTO job_profession VALUES('1697','','Techniques of Broadcasting & Anchoring','1034','697');
INSERT INTO job_profession VALUES('1698','ӰӽĿ','Programming of Film & Television Advertisement ','1034','698');
INSERT INTO job_profession VALUES('1699','Ŀ','Broadcasting and Programming','1034','699');
INSERT INTO job_profession VALUES('1700','ӰӰ','Imaging and Film & Television Arts','1034','700');
INSERT INTO job_profession VALUES('1701','㲥ӱർ','Radio & Television Editing & Directing','1034','701');
INSERT INTO job_profession VALUES('1702','ģ','Model','1034','702');
INSERT INTO job_profession VALUES('1703','','Etiquette','1034','703');
INSERT INTO job_profession VALUES('1704','ȺĻ','Folk Culture and Arts','1034','704');
INSERT INTO job_profession VALUES('1705','ĻӰҵ','Culture and Film & Television Management','1034','705');
INSERT INTO job_profession VALUES('1706','ﱣ','Culture Relic Protection','1034','706');
INSERT INTO job_profession VALUES('1707','װ빤','Apparel Design and Engineering','1034','707');
INSERT INTO job_profession VALUES('1708','װ','Fashion Show','1034','708');
INSERT INTO job_profession VALUES('1709','䴫ͳ','Traditional Arts','1034','709');
INSERT INTO job_profession VALUES('1710','','Others','1034','710');
INSERT INTO job_profession VALUES('1711','ѧ','Chinese Language & Literature','1035','711');
INSERT INTO job_profession VALUES('1712','','Chinese Language','1035','712');
INSERT INTO job_profession VALUES('1713','⺺','Chinese as a Second Language','1035','713');
INSERT INTO job_profession VALUES('1714','йѧ','Chinese Minority Language & Literatures','1035','714');
INSERT INTO job_profession VALUES('1715','ŵ ','Chinese Classics And Classical Bibliography','1035','715');
INSERT INTO job_profession VALUES('1716','йѧ','Chinese Literature','1035','716');
INSERT INTO job_profession VALUES('1717','ѧ','Eastern Literature','1035','717');
INSERT INTO job_profession VALUES('1718','ѧ','Western Literature','1035','718');
INSERT INTO job_profession VALUES('1719','ѧ','Journalism','1035','719');
INSERT INTO job_profession VALUES('1720','㲥ѧ','Radio & Television Science','1035','720');
INSERT INTO job_profession VALUES('1721','Ųɱ','News Acquisition and Cataloguing','1035','721');
INSERT INTO job_profession VALUES('1722','д','News Composition and Commentary','1035','722');
INSERT INTO job_profession VALUES('1723','Ӱ','News Photography','1035','723');
INSERT INTO job_profession VALUES('1724','ѧ','Advertising','1035','724');
INSERT INTO job_profession VALUES('1725','༭ѧ','Editing & Publishing Science','1035','725');
INSERT INTO job_profession VALUES('1726','뷢','Publishing and Distribution','1035','726');
INSERT INTO job_profession VALUES('1727','ͼ','LiBrary Facilities','1035','727');
INSERT INTO job_profession VALUES('1728','Ƽ鱨','Technological Imformation','1035','728');
INSERT INTO job_profession VALUES('1729','','Archives','1035','729');
INSERT INTO job_profession VALUES('1730','','Museum','1035','730');
INSERT INTO job_profession VALUES('1731','','Others','1035','731');
INSERT INTO job_profession VALUES('1732','Ӣ','English','1036','732');
INSERT INTO job_profession VALUES('1733','','Russian','1036','733');
INSERT INTO job_profession VALUES('1734','','German','1036','734');
INSERT INTO job_profession VALUES('1735','','French','1036','735');
INSERT INTO job_profession VALUES('1736','','Spanish','1036','736');
INSERT INTO job_profession VALUES('1737','','Arabic','1036','737');
INSERT INTO job_profession VALUES('1738','','Japanese','1036','738');
INSERT INTO job_profession VALUES('1739','˹','Farsi','1036','739');
INSERT INTO job_profession VALUES('1740','','Korean','1036','740');
INSERT INTO job_profession VALUES('1741','ɱ','Tagalog','1036','741');
INSERT INTO job_profession VALUES('1742','','Sanskrit','1036','742');
INSERT INTO job_profession VALUES('1743','','Pali','1036','743');
INSERT INTO job_profession VALUES('1744','ӡ','Indonesian','1036','744');
INSERT INTO job_profession VALUES('1745','ӡ','Hindi','1036','745');
INSERT INTO job_profession VALUES('1746','կ','Kampuchean','1036','746');
INSERT INTO job_profession VALUES('1747','','Lao','1036','747');
INSERT INTO job_profession VALUES('1748','','Burmese','1036','748');
INSERT INTO job_profession VALUES('1749','','Malay','1036','749');
INSERT INTO job_profession VALUES('1750','ɹ','Mongolian','1036','750');
INSERT INTO job_profession VALUES('1751','ɮ','Singhalese','1036','751');
INSERT INTO job_profession VALUES('1752','̩','Thai','1036','752');
INSERT INTO job_profession VALUES('1753','ڶ','Urdu','1036','753');
INSERT INTO job_profession VALUES('1754','ϣ','Rabbinic','1036','754');
INSERT INTO job_profession VALUES('1755','Խ','Vietnamese','1036','755');
INSERT INTO job_profession VALUES('1756','','Chadic','1036','756');
INSERT INTO job_profession VALUES('1757','˹ϣ','Swahili','1036','757');
INSERT INTO job_profession VALUES('1758','','Albanian','1036','758');
INSERT INTO job_profession VALUES('1759','','Bulgarian','1036','759');
INSERT INTO job_profession VALUES('1760','','Polish','1036','760');
INSERT INTO job_profession VALUES('1761','ݿ','Czech','1036','761');
INSERT INTO job_profession VALUES('1762','','Romanian','1036','762');
INSERT INTO job_profession VALUES('1763','','Portuguese','1036','763');
INSERT INTO job_profession VALUES('1764','','Swedish','1036','764');
INSERT INTO job_profession VALUES('1765','ά-޵','Serbo - Croatian','1036','765');
INSERT INTO job_profession VALUES('1766','','Turkish','1036','766');
INSERT INTO job_profession VALUES('1767','ϣ','Greek','1036','767');
INSERT INTO job_profession VALUES('1768','','Mungarian','1036','768');
INSERT INTO job_profession VALUES('1769','','Italian','1036','769');
INSERT INTO job_profession VALUES('1770','','Others','1036','770');
INSERT INTO job_profession VALUES('1771','ѧ','Education','1037','771');
INSERT INTO job_profession VALUES('1772','ѧǰ','Preschool Education','1037','772');
INSERT INTO job_profession VALUES('1773','','Special Education','1037','773');
INSERT INTO job_profession VALUES('1774','ѧ','Educational Technology','1037','774');
INSERT INTO job_profession VALUES('1775','','Physical Education','1037','775');
INSERT INTO job_profession VALUES('1776','˶ѵ','Sports Training','1037','776');
INSERT INTO job_profession VALUES('1777','','Social Sports','1037','777');
INSERT INTO job_profession VALUES('1778','˶ѧ','Human Kinesiology','1037','778');
INSERT INTO job_profession VALUES('1779','Ͽ','Sports Support and Rehabilitation','1037','779');
INSERT INTO job_profession VALUES('1780','崫ͳ','Traditional Sports of Nationalities','1037','780');
INSERT INTO job_profession VALUES('1781','빤','Flight Vehicle Design and Engineering','1038','781');
INSERT INTO job_profession VALUES('1782','','Flight Vehicle Propulsion Engineering','1038','782');
INSERT INTO job_profession VALUES('1783','칤','Flight Vehicle Manufacturing Engineering','1038','783');
INSERT INTO job_profession VALUES('1784','Ϲ','Flight Vehicle Environment and Life Support System','1038','784');
INSERT INTO job_profession VALUES('1785','ṹ','Flight Vehicle Structural Design','1038','785');
INSERT INTO job_profession VALUES('1786','','Flight Vehicle Materiacl','1038','786');
INSERT INTO job_profession VALUES('1787','豸','Flight Vehicle Navigation Instrument','1038','787');
INSERT INTO job_profession VALUES('1788','ϵͳ','Flight Vehicle System Engineering','1038','788');
INSERT INTO job_profession VALUES('1789','','Others','1038','789');
INSERT INTO job_profession VALUES('1790','¿ѧ','Criminal Science and Technology','1039','790');
INSERT INTO job_profession VALUES('1791','ΰѧ','Science of Public Order','1039','791');
INSERT INTO job_profession VALUES('1792','ѧ','Science of Criminal Investigation','1039','792');
INSERT INTO job_profession VALUES('1793','߷','Management of Frontier Order','1039','793');
INSERT INTO job_profession VALUES('1794','','Fire Prevention Engineering','1039','794');
INSERT INTO job_profession VALUES('1795','ϵͳ뷢乤','Weapon Systems and Launching Engineering','1039','795');
INSERT INTO job_profession VALUES('1796','̽ƵƼ','Detection, guidance and Control Technology','1039','796');
INSERT INTO job_profession VALUES('1797','ҩ뱬ը','Ammunition Engineering and Explosion technology','1039','797');
INSERT INTO job_profession VALUES('1798','Դ̻','Special energy and Pyrotechnics','1039','798');
INSERT INTO job_profession VALUES('1799','','Ground Motor Weapon Engineering','1039','799');
INSERT INTO job_profession VALUES('1800','ϢԿ','Information Countermeasure/Warfare Technology','1039','800');
INSERT INTO job_profession VALUES('1801','ָ','Science of Command','1039','801');
INSERT INTO job_profession VALUES('1802','Ӫ','Commerce Management','1040','802');
INSERT INTO job_profession VALUES('1803','гӪ','Marketing','1040','803');
INSERT INTO job_profession VALUES('1804','','Electronic Commerce','1040','804');
INSERT INTO job_profession VALUES('1805','','International Commerce','1040','805');
INSERT INTO job_profession VALUES('1806','Ӣ','Commerce English','1040','806');
INSERT INTO job_profession VALUES('1807','֯Ʒó','Textile Inspection and Trade','1040','807');
INSERT INTO job_profession VALUES('1808','ʾӪ','Materials Management','1040','808');
INSERT INTO job_profession VALUES('1809','̲ר','Tobacco Management','1040','809');
INSERT INTO job_profession VALUES('1810','Ʒ','Commodity Storage and Distribution','1040','810');
INSERT INTO job_profession VALUES('1811','زӪ','Real Estate Management','1040','811');
INSERT INTO job_profession VALUES('1812','','Cuisine','1040','812');
INSERT INTO job_profession VALUES('1813','','Beauty and Image Design','1040','813');
INSERT INTO job_profession VALUES('1814','μӹ뾭Ӫ','Jewelry Processing and Management','1040','814');
INSERT INTO job_profession VALUES('1815','ӱ۾','Clock & Watch and Glasses Fitting and Repair','1040','815');
INSERT INTO job_profession VALUES('1816','','Restaurant Service and Management','1040','816');
INSERT INTO job_profession VALUES('1817','η','Tourist Service and Management','1040','817');
INSERT INTO job_profession VALUES('1818','','Leisure Sports Service and Management','1040','818');
INSERT INTO job_profession VALUES('1819','ʩӪ','Sports Facilities Business','1040','819');
INSERT INTO job_profession VALUES('1820','','Law Affairs','1041','820');
INSERT INTO job_profession VALUES('1821','','Public Security','1041','821');
INSERT INTO job_profession VALUES('1822','ΰ','Security Management','1041','822');
INSERT INTO job_profession VALUES('1823','','Criminal Investigation','1041','823');
INSERT INTO job_profession VALUES('1824','','Prison Management','1041','824');
INSERT INTO job_profession VALUES('1825','ͽ̹','Reforming Education Management','1041','825');
INSERT INTO job_profession VALUES('1826','','Security Guard','1041','826');
INSERT INTO job_profession VALUES('1827','·ͨ','Highway Traffic Management','1041','827');
INSERT INTO job_profession VALUES('1828','','Industry and Commerce Administration','1041','828');
INSERT INTO job_profession VALUES('1829','Դ','Human Resource Management','1041','829');
INSERT INTO job_profession VALUES('1830','ᱣ','Social Security','1041','830');
INSERT INTO job_profession VALUES('1831','','Civil Service and Management','1041','831');
INSERT INTO job_profession VALUES('1832','ḣҵ','Social Welfare Programs Management','1041','832');
INSERT INTO job_profession VALUES('1833','Լ','Measurement and Test Technology','1041','833');
INSERT INTO job_profession VALUES('1834','Ʒල','Products Quality Supervision and Inspection','1041','834');
INSERT INTO job_profession VALUES('1835','׼ල','Standardization and Quality Supervision','1041','835');
INSERT INTO job_profession VALUES('1836','','Secretary','1041','836');
INSERT INTO job_profession VALUES('1837','','Public Relations Etiquette','1041','837');
INSERT INTO job_profession VALUES('1838','ҵ','Property Management','1041','838');
INSERT INTO job_profession VALUES('1839','','Housekeeping and Community Service','1041','839');
INSERT INTO job_profession VALUES('1840','˷','Service and Management for Old People','1041','840');
INSERT INTO job_profession VALUES('1841','ִǼ','Modern Funeral Technology and Management','1041','841');
INSERT INTO job_profession VALUES('1842','','Others','1041','842');
INSERT INTO job_profession VALUES('1843','ϵ','Public Relations','1042','843');
INSERT INTO job_profession VALUES('1844','','Secretary','1042','844');
INSERT INTO job_profession VALUES('1845','','Tourist Guide','1042','845');
INSERT INTO job_profession VALUES('1847','','xiulilei','0','847');
INSERT INTO job_profession VALUES('1848','','Qcxl','1847','848');
INSERT INTO job_profession VALUES('1849','ά','Dnwx','1847','849');
INSERT INTO job_profession VALUES('1850','','Qt','1847','850');

INSERT INTO job_provinceandcity VALUES('1000','','Beijing','0','0');
INSERT INTO job_provinceandcity VALUES('1001','Ϻ','Shanghai','0','1');
INSERT INTO job_provinceandcity VALUES('1002','','Tianjin','0','2');
INSERT INTO job_provinceandcity VALUES('1003','','Chongqing','0','3');
INSERT INTO job_provinceandcity VALUES('1004','㽭ʡ','Zhejiang','0','4');
INSERT INTO job_provinceandcity VALUES('1005','㶫ʡ','Guangdong','0','5');
INSERT INTO job_provinceandcity VALUES('1006','ʡ','Jiangsu','0','6');
INSERT INTO job_provinceandcity VALUES('1007','ӱʡ','Hebei','0','7');
INSERT INTO job_provinceandcity VALUES('1008','ɽʡ','Shanxi','0','8');
INSERT INTO job_provinceandcity VALUES('1009','Ĵʡ','Sichuan','0','9');
INSERT INTO job_provinceandcity VALUES('1010','ʡ','Henan','0','10');
INSERT INTO job_provinceandcity VALUES('1011','ʡ','Liaoning','0','11');
INSERT INTO job_provinceandcity VALUES('1012','ʡ','Jilin','0','12');
INSERT INTO job_provinceandcity VALUES('1013','ʡ','Heilongjiang','0','13');
INSERT INTO job_provinceandcity VALUES('1014','ɽʡ','Shandong','0','14');
INSERT INTO job_provinceandcity VALUES('1015','ʡ','Anhui','0','15');
INSERT INTO job_provinceandcity VALUES('1016','ʡ','Fujian','0','16');
INSERT INTO job_provinceandcity VALUES('1017','ʡ','Hubei','0','17');
INSERT INTO job_provinceandcity VALUES('1018','ʡ','Hunan','0','18');
INSERT INTO job_provinceandcity VALUES('1019','ʡ','Hainan','0','19');
INSERT INTO job_provinceandcity VALUES('1020','ʡ','Jiangxi','0','20');
INSERT INTO job_provinceandcity VALUES('1021','ʡ','Guizhou','0','21');
INSERT INTO job_provinceandcity VALUES('1022','ʡ','Yunnan','0','22');
INSERT INTO job_provinceandcity VALUES('1023','ʡ','Shanxi','0','23');
INSERT INTO job_provinceandcity VALUES('1024','ʡ','Gansu','0','24');
INSERT INTO job_provinceandcity VALUES('1025','','Guangxi','0','25');
INSERT INTO job_provinceandcity VALUES('1026','','Ningxia','0','26');
INSERT INTO job_provinceandcity VALUES('1027','ຣʡ','Qinghai','0','27');
INSERT INTO job_provinceandcity VALUES('1028','½','Xinjiang','0','28');
INSERT INTO job_provinceandcity VALUES('1029','','Tibet','0','29');
INSERT INTO job_provinceandcity VALUES('1030','ɹ','Inner Mongolia','0','30');
INSERT INTO job_provinceandcity VALUES('1031','','Hongkong','0','31');
INSERT INTO job_provinceandcity VALUES('1032','','Macao','0','32');
INSERT INTO job_provinceandcity VALUES('1033','̨','Taiwan','0','33');
INSERT INTO job_provinceandcity VALUES('1034','ɽ','Maanshan','1015','34');
INSERT INTO job_provinceandcity VALUES('1035','','Liuan','1015','35');
INSERT INTO job_provinceandcity VALUES('1036','','Xuancheng','1015','36');
INSERT INTO job_provinceandcity VALUES('1037','','Suzhou','1015','37');
INSERT INTO job_provinceandcity VALUES('1038','ͭ','Tongling','1015','38');
INSERT INTO job_provinceandcity VALUES('1039','ߺ','Wuhu','1015','39');
INSERT INTO job_provinceandcity VALUES('1040','','Bozhou','1015','40');
INSERT INTO job_provinceandcity VALUES('1041','','Bengbu','1015','41');
INSERT INTO job_provinceandcity VALUES('1042','','Anqing','1015','42');
INSERT INTO job_provinceandcity VALUES('1043','','Chuzhou','1015','43');
INSERT INTO job_provinceandcity VALUES('1044','','Caohu','1015','44');
INSERT INTO job_provinceandcity VALUES('1045','','Fuyang','1015','45');
INSERT INTO job_provinceandcity VALUES('1046','','Chizhou','1015','46');
INSERT INTO job_provinceandcity VALUES('1047','Ϸ','Hefei','1015','47');
INSERT INTO job_provinceandcity VALUES('1048','ɽ','Huangshan','1015','48');
INSERT INTO job_provinceandcity VALUES('1049','','Huainan','1015','49');
INSERT INTO job_provinceandcity VALUES('1050','','Huaibei','1015','50');
INSERT INTO job_provinceandcity VALUES('1051','','Longyan','1016','51');
INSERT INTO job_provinceandcity VALUES('1052','','Sanming','1016','52');
INSERT INTO job_provinceandcity VALUES('1053','Ȫ','Quanzhou','1016','53');
INSERT INTO job_provinceandcity VALUES('1054','','Xiamen','1016','54');
INSERT INTO job_provinceandcity VALUES('1055','','Zhangzhou','1016','55');
INSERT INTO job_provinceandcity VALUES('1056','','Putian','1016','56');
INSERT INTO job_provinceandcity VALUES('1057','ƽ','Manping','1016','57');
INSERT INTO job_provinceandcity VALUES('1058','','Ningde','1016','58');
INSERT INTO job_provinceandcity VALUES('1059','','Fuzhou','1016','59');
INSERT INTO job_provinceandcity VALUES('1060','Ļ','Linxia','1024','60');
INSERT INTO job_provinceandcity VALUES('1061','¤ϵ','Longnan','1024','61');
INSERT INTO job_provinceandcity VALUES('1062','','Lanzhou','1024','62');
INSERT INTO job_provinceandcity VALUES('1063','ˮ','Tianshui','1024','63');
INSERT INTO job_provinceandcity VALUES('1064','','Wuwei','1024','64');
INSERT INTO job_provinceandcity VALUES('1065','','Qingyang','1024','65');
INSERT INTO job_provinceandcity VALUES('1066','Ҵ','Zhangye','1024','66');
INSERT INTO job_provinceandcity VALUES('1067','ƽ','Pingliang','1024','67');
INSERT INTO job_provinceandcity VALUES('1068','','Baiyin','1024','68');
INSERT INTO job_provinceandcity VALUES('1069','','Dingxi','1024','69');
INSERT INTO job_provinceandcity VALUES('1070','ϲ','Gannan','1024','70');
INSERT INTO job_provinceandcity VALUES('1071','','Jiayuguan','1024','71');
INSERT INTO job_provinceandcity VALUES('1072','','Jinchang','1024','72');
INSERT INTO job_provinceandcity VALUES('1073','Ȫ','Jiuquan','1024','73');
INSERT INTO job_provinceandcity VALUES('1074','ï','Maoming','1005','74');
INSERT INTO job_provinceandcity VALUES('1075','÷','Meizhou','1005','75');
INSERT INTO job_provinceandcity VALUES('1076','Զ','Qingyuan','1005','76');
INSERT INTO job_provinceandcity VALUES('1077','β','Shanwei','1005','77');
INSERT INTO job_provinceandcity VALUES('1078','ͷ','Shantou','1005','78');
INSERT INTO job_provinceandcity VALUES('1079','','Shenzhen','1005','79');
INSERT INTO job_provinceandcity VALUES('1080','ع','Shaoguan','1005','80');
INSERT INTO job_provinceandcity VALUES('1081','','Yangjiang','1005','81');
INSERT INTO job_provinceandcity VALUES('1082','Ƹ','Yunfu','1005','82');
INSERT INTO job_provinceandcity VALUES('1083','տ','Zhanjiang','1005','83');
INSERT INTO job_provinceandcity VALUES('1084','','Zhaoqing','1005','84');
INSERT INTO job_provinceandcity VALUES('1085','ɽ','Zhongshan','1005','85');
INSERT INTO job_provinceandcity VALUES('1086','麣','Zhuhai','1005','86');
INSERT INTO job_provinceandcity VALUES('1087','','Chaozhou','1005','87');
INSERT INTO job_provinceandcity VALUES('1088','ݸ','Dongguan','1005','88');
INSERT INTO job_provinceandcity VALUES('1089','ɽ','Foshan','1005','89');
INSERT INTO job_provinceandcity VALUES('1090','','Guangzhou','1005','90');
INSERT INTO job_provinceandcity VALUES('1091','Դ','Heyuan','1005','91');
INSERT INTO job_provinceandcity VALUES('1092','','Huizhou','1005','92');
INSERT INTO job_provinceandcity VALUES('1093','','Jieyang','1005','93');
INSERT INTO job_provinceandcity VALUES('1094','','Jiangmen','1005','94');
INSERT INTO job_provinceandcity VALUES('1095','','Liuzhou','1025','95');
INSERT INTO job_provinceandcity VALUES('1096','','Congzuo','1025','96');
INSERT INTO job_provinceandcity VALUES('1097','','Qinzhou','1025','97');
INSERT INTO job_provinceandcity VALUES('1098','','Wuzhou','1025','98');
INSERT INTO job_provinceandcity VALUES('1099','','Yulin','1025','99');
INSERT INTO job_provinceandcity VALUES('1100','','Nanning','1025','100');
INSERT INTO job_provinceandcity VALUES('1101','','Laibin','1025','101');
INSERT INTO job_provinceandcity VALUES('1102','ɫ','Baise','1025','102');
INSERT INTO job_provinceandcity VALUES('1103','','Beihai','1025','103');
INSERT INTO job_provinceandcity VALUES('1104','Ǹ','Fangchengguang','1025','104');
INSERT INTO job_provinceandcity VALUES('1105','','Guilin','1025','105');
INSERT INTO job_provinceandcity VALUES('1106','','Guigang','1025','106');
INSERT INTO job_provinceandcity VALUES('1107','ӳص','Hechi','1025','107');
INSERT INTO job_provinceandcity VALUES('1108','ݵ','Hezhou','1025','108');
INSERT INTO job_provinceandcity VALUES('1109','ˮ','Liupanshui','1021','109');
INSERT INTO job_provinceandcity VALUES('1110','ǭϲ','Qian Southwest','1021','110');
INSERT INTO job_provinceandcity VALUES('1111','ǭϲ','Qian South','1021','111');
INSERT INTO job_provinceandcity VALUES('1112','ǭ嶱','Qian Southeast','1021','112');
INSERT INTO job_provinceandcity VALUES('1113','ͭʵ','Tongren','1021','113');
INSERT INTO job_provinceandcity VALUES('1114','˳','Anshun','1021','114');
INSERT INTO job_provinceandcity VALUES('1115','Ͻڵ','Bijie','1021','115');
INSERT INTO job_provinceandcity VALUES('1116','','Guiyang','1021','116');
INSERT INTO job_provinceandcity VALUES('1117','','Zunyi','1021','117');
INSERT INTO job_provinceandcity VALUES('1118','','Sanya','1019','118');
INSERT INTO job_provinceandcity VALUES('1119','','Haikou','1019','119');
INSERT INTO job_provinceandcity VALUES('1120','ȷ','Langfang','1007','120');
INSERT INTO job_provinceandcity VALUES('1121','ػʵ','Qinhuangdao','1007','121');
INSERT INTO job_provinceandcity VALUES('1122','̨','Xingtai','1007','122');
INSERT INTO job_provinceandcity VALUES('1123','ʯׯ','Shijiazhuang','1007','123');
INSERT INTO job_provinceandcity VALUES('1124','ɽ','Tangshan','1007','124');
INSERT INTO job_provinceandcity VALUES('1125','żҿ','Zhangjiakou','1007','125');
INSERT INTO job_provinceandcity VALUES('1126','','Baoding','1007','126');
INSERT INTO job_provinceandcity VALUES('1127','','Cangzhou','1007','127');
INSERT INTO job_provinceandcity VALUES('1128','е','Chengde','1007','128');
INSERT INTO job_provinceandcity VALUES('1129','ˮ','Hengshui','1007','129');
INSERT INTO job_provinceandcity VALUES('1130','','Handan','1007','130');
INSERT INTO job_provinceandcity VALUES('1131','','Luoyang','1010','131');
INSERT INTO job_provinceandcity VALUES('1132','','Xinxiang','1010','132');
INSERT INTO job_provinceandcity VALUES('1133','','Xuchang','1010','133');
INSERT INTO job_provinceandcity VALUES('1134','','Xinyang','1010','134');
INSERT INTO job_provinceandcity VALUES('1135','','Shangqiu','1010','135');
INSERT INTO job_provinceandcity VALUES('1136','Ͽ','Sanmenxia','1010','136');
INSERT INTO job_provinceandcity VALUES('1137','','Puyang','1010','137');
INSERT INTO job_provinceandcity VALUES('1138','','Luohe','1010','138');
INSERT INTO job_provinceandcity VALUES('1139','','Nanyang','1010','139');
INSERT INTO job_provinceandcity VALUES('1140','ƽɽ','Pingdingshan','1010','140');
INSERT INTO job_provinceandcity VALUES('1141','ܿ','Zhoukou','1010','141');
INSERT INTO job_provinceandcity VALUES('1142','֣','Zhengzhou','1010','142');
INSERT INTO job_provinceandcity VALUES('1143','','Anyang','1010','143');
INSERT INTO job_provinceandcity VALUES('1144','ױ','Hebi','1010','144');
INSERT INTO job_provinceandcity VALUES('1145','','Jiaozuo','1010','145');
INSERT INTO job_provinceandcity VALUES('1146','','Kaifeng','1010','146');
INSERT INTO job_provinceandcity VALUES('1147','פ','Zhumadian','1010','147');
INSERT INTO job_provinceandcity VALUES('1148','绯','Suihua','1013','148');
INSERT INTO job_provinceandcity VALUES('1149','˫Ѽɽ','Shuangyashan','1013','149');
INSERT INTO job_provinceandcity VALUES('1150','','Yichun','1013','150');
INSERT INTO job_provinceandcity VALUES('1151','','Qiqihar','1013','151');
INSERT INTO job_provinceandcity VALUES('1152','ĵ','Mudanjiang','1013','152');
INSERT INTO job_provinceandcity VALUES('1153','̨','Qitaihe','1013','153');
INSERT INTO job_provinceandcity VALUES('1154','','Daqing','1013','154');
INSERT INTO job_provinceandcity VALUES('1155','˰','Daxinganling','1013','155');
INSERT INTO job_provinceandcity VALUES('1156','','Harbing','1013','156');
INSERT INTO job_provinceandcity VALUES('1157','ں','Heihe','1013','157');
INSERT INTO job_provinceandcity VALUES('1158','׸','Hegang','1013','158');
INSERT INTO job_provinceandcity VALUES('1159','ľ˹','Jiamusi','1013','159');
INSERT INTO job_provinceandcity VALUES('1160','','Jixi','1013','160');
INSERT INTO job_provinceandcity VALUES('1161','Т','Xiaogan','1017','161');
INSERT INTO job_provinceandcity VALUES('1162','','Suizhou','1017','162');
INSERT INTO job_provinceandcity VALUES('1163','ʮ','Shiyan','1017','163');
INSERT INTO job_provinceandcity VALUES('1164','','Xianning','1017','164');
INSERT INTO job_provinceandcity VALUES('1165','差','Xiangfan','1017','165');
INSERT INTO job_provinceandcity VALUES('1166','人','Wuhan','1017','166');
INSERT INTO job_provinceandcity VALUES('1167','˲','Yichang','1017','167');
INSERT INTO job_provinceandcity VALUES('1168','','Ezhou','1017','168');
INSERT INTO job_provinceandcity VALUES('1169','ʩ','Enshi','1017','169');
INSERT INTO job_provinceandcity VALUES('1170','ʯ','Huangshi','1017','170');
INSERT INTO job_provinceandcity VALUES('1171','Ƹ','Huanggang','1017','171');
INSERT INTO job_provinceandcity VALUES('1172','','Jingmen','1017','172');
INSERT INTO job_provinceandcity VALUES('1173','','Jingzhou','1017','173');
INSERT INTO job_provinceandcity VALUES('1174','¦','Loudi','1018','174');
INSERT INTO job_provinceandcity VALUES('1175','','Shaoyang','1018','175');
INSERT INTO job_provinceandcity VALUES('1176','̶','Xiangtan','1018','176');
INSERT INTO job_provinceandcity VALUES('1177','','Xiangxi','1018','177');
INSERT INTO job_provinceandcity VALUES('1178','','Yueyang','1018','178');
INSERT INTO job_provinceandcity VALUES('1179','','Yongzhou','1018','179');
INSERT INTO job_provinceandcity VALUES('1180','żҽ','Zhangjiajie','1018','180');
INSERT INTO job_provinceandcity VALUES('1181','','Yiyang','1018','181');
INSERT INTO job_provinceandcity VALUES('1182','','Zhuzhou','1018','182');
INSERT INTO job_provinceandcity VALUES('1183','','Changde','1018','183');
INSERT INTO job_provinceandcity VALUES('1184','ɳ','Changsha','1018','184');
INSERT INTO job_provinceandcity VALUES('1185','','Chenzhou','1018','185');
INSERT INTO job_provinceandcity VALUES('1186','','Hengyang','1018','186');
INSERT INTO job_provinceandcity VALUES('1187','','Huaihua','1018','187');
INSERT INTO job_provinceandcity VALUES('1188','Դ','Liaoyuan','1012','188');
INSERT INTO job_provinceandcity VALUES('1189','ԭ','Songyuan','1012','189');
INSERT INTO job_provinceandcity VALUES('1190','ƽ','Siping','1012','190');
INSERT INTO job_provinceandcity VALUES('1191','ͨ','Tonghua','1012','191');
INSERT INTO job_provinceandcity VALUES('1192','ӱ߳','Yanbian','1012','192');
INSERT INTO job_provinceandcity VALUES('1193','ɽ','Baishan','1012','193');
INSERT INTO job_provinceandcity VALUES('1194','׳','Baicheng','1012','194');
INSERT INTO job_provinceandcity VALUES('1195','','Changchun','1012','195');
INSERT INTO job_provinceandcity VALUES('1196','','Jilin','1012','196');
INSERT INTO job_provinceandcity VALUES('1197','Ƹ','Lianyungang','1006','197');
INSERT INTO job_provinceandcity VALUES('1198','','Xuzhou','1006','198');
INSERT INTO job_provinceandcity VALUES('1199','','Suzhou','1006','199');
INSERT INTO job_provinceandcity VALUES('1200','Ǩ','Suqian','1006','200');
INSERT INTO job_provinceandcity VALUES('1201','̩','Taizhou','1006','201');
INSERT INTO job_provinceandcity VALUES('1202','','Wuxi','1006','202');
INSERT INTO job_provinceandcity VALUES('1203','','Yangzhou','1006','203');
INSERT INTO job_provinceandcity VALUES('1204','γ','Yancheng','1006','204');
INSERT INTO job_provinceandcity VALUES('1205','','Zhenjiang','1006','205');
INSERT INTO job_provinceandcity VALUES('1206','ͨ','Nantong','1006','206');
INSERT INTO job_provinceandcity VALUES('1207','Ͼ','Nanjing','1006','207');
INSERT INTO job_provinceandcity VALUES('1208','','Changzhou','1006','208');
INSERT INTO job_provinceandcity VALUES('1209','','Huaian','1006','209');
INSERT INTO job_provinceandcity VALUES('1210','','Xinyu','1020','210');
INSERT INTO job_provinceandcity VALUES('1211','','Shangrao','1020','211');
INSERT INTO job_provinceandcity VALUES('1212','˴','Yichun','1020','212');
INSERT INTO job_provinceandcity VALUES('1213','ӥ̶','Yingtan','1020','213');
INSERT INTO job_provinceandcity VALUES('1214','ϲ','Nanchang','1020','214');
INSERT INTO job_provinceandcity VALUES('1215','Ƽ','Pingxiang','1020','215');
INSERT INTO job_provinceandcity VALUES('1216','','Ganzhou','1020','216');
INSERT INTO job_provinceandcity VALUES('1217','','Fuzhou','1020','217');
INSERT INTO job_provinceandcity VALUES('1218','','Jian','1020','218');
INSERT INTO job_provinceandcity VALUES('1219','Ž','Jiujiang','1020','219');
INSERT INTO job_provinceandcity VALUES('1220','','Jingdezhen','1020','220');
INSERT INTO job_provinceandcity VALUES('1221','','Liaoyang','1011','221');
INSERT INTO job_provinceandcity VALUES('1222','','Shenyang','1011','222');
INSERT INTO job_provinceandcity VALUES('1223','','Tieling','1011','223');
INSERT INTO job_provinceandcity VALUES('1224','Ӫ','Yingkou','1011','224');
INSERT INTO job_provinceandcity VALUES('1225','̽','Panjin','1011','225');
INSERT INTO job_provinceandcity VALUES('1226','ɽ','Anshan','1011','226');
INSERT INTO job_provinceandcity VALUES('1227','Ϫ','Benxi','1011','227');
INSERT INTO job_provinceandcity VALUES('1228','','Chaoyang','1011','228');
INSERT INTO job_provinceandcity VALUES('1229','','Dalian','1011','229');
INSERT INTO job_provinceandcity VALUES('1230','','Dandong','1011','230');
INSERT INTO job_provinceandcity VALUES('1231','˳','Fushun','1011','231');
INSERT INTO job_provinceandcity VALUES('1232','','Fuxin','1011','232');
INSERT INTO job_provinceandcity VALUES('1233','«','Huludao','1011','233');
INSERT INTO job_provinceandcity VALUES('1234','','Jinzhou','1011','234');
INSERT INTO job_provinceandcity VALUES('1235','˰','Xingan','1030','235');
INSERT INTO job_provinceandcity VALUES('1236','첼','Wulanchabu','1030','236');
INSERT INTO job_provinceandcity VALUES('1237','ں','Wuhai','1030','237');
INSERT INTO job_provinceandcity VALUES('1238','ֹ','Xilinguole','1030','238');
INSERT INTO job_provinceandcity VALUES('1239','ͨ','Tongliao','1030','239');
INSERT INTO job_provinceandcity VALUES('1240','׶','Bayanzhuoer','1030','240');
INSERT INTO job_provinceandcity VALUES('1241','ͷ','Baotou','1030','241');
INSERT INTO job_provinceandcity VALUES('1242','','Alashan','1030','242');
INSERT INTO job_provinceandcity VALUES('1243','','Chifeng','1030','243');
INSERT INTO job_provinceandcity VALUES('1244','˹','Erduosi','1030','244');
INSERT INTO job_provinceandcity VALUES('1245','ױ','Hulunbeir','1030','245');
INSERT INTO job_provinceandcity VALUES('1246','ͺ','Huhehaote','1030','246');
INSERT INTO job_provinceandcity VALUES('1247','ʯɽ','Shizuishan','1026','247');
INSERT INTO job_provinceandcity VALUES('1248','','Wuzhong','1026','248');
INSERT INTO job_provinceandcity VALUES('1249','','Yinchuan','1026','249');
INSERT INTO job_provinceandcity VALUES('1250','ԭ','Guyuan','1026','250');
INSERT INTO job_provinceandcity VALUES('1251','','Xining','1027','251');
INSERT INTO job_provinceandcity VALUES('1252','','Yushu','1027','252');
INSERT INTO job_provinceandcity VALUES('1253','','Guoluo','1027','253');
INSERT INTO job_provinceandcity VALUES('1254','ɹ','Haixi','1027','254');
INSERT INTO job_provinceandcity VALUES('1255','ϲ','Hainan','1027','255');
INSERT INTO job_provinceandcity VALUES('1256','','Haibei','1027','256');
INSERT INTO job_provinceandcity VALUES('1257','','Haidong','1027','257');
INSERT INTO job_provinceandcity VALUES('1258','ϲ','Huangnan','1027','258');
INSERT INTO job_provinceandcity VALUES('1259','','Linyi','1014','259');
INSERT INTO job_provinceandcity VALUES('1260','ĳ','Liaocheng','1014','260');
INSERT INTO job_provinceandcity VALUES('1261','','Laiwu','1014','261');
INSERT INTO job_provinceandcity VALUES('1262','ൺ','Qingdao','1014','262');
INSERT INTO job_provinceandcity VALUES('1263','','Rizhao','1014','263');
INSERT INTO job_provinceandcity VALUES('1264','̩','Taian','1014','264');
INSERT INTO job_provinceandcity VALUES('1265','Ϋ','Weifang','1014','265');
INSERT INTO job_provinceandcity VALUES('1266','','Weihai','1014','266');
INSERT INTO job_provinceandcity VALUES('1267','̨','Yantai','1014','267');
INSERT INTO job_provinceandcity VALUES('1268','ׯ','Zaozhuang','1014','268');
INSERT INTO job_provinceandcity VALUES('1269','','Binzhou','1014','269');
INSERT INTO job_provinceandcity VALUES('1270','','Dezhou','1014','270');
INSERT INTO job_provinceandcity VALUES('1271','Ӫ','Dongying','1014','271');
INSERT INTO job_provinceandcity VALUES('1272','','Heze','1014','272');
INSERT INTO job_provinceandcity VALUES('1273','','Jinan','1014','273');
INSERT INTO job_provinceandcity VALUES('1274','','Jining','1014','274');
INSERT INTO job_provinceandcity VALUES('1275','Ͳ','Zibo','1014','275');
INSERT INTO job_provinceandcity VALUES('1276','','Lvliang','1008','276');
INSERT INTO job_provinceandcity VALUES('1277','ٷ','Linfen','1008','277');
INSERT INTO job_provinceandcity VALUES('1278','','Xinzhou','1008','278');
INSERT INTO job_provinceandcity VALUES('1279','˷','Shuozhou','1008','279');
INSERT INTO job_provinceandcity VALUES('1280','̫ԭ','Taiyuan','1008','280');
INSERT INTO job_provinceandcity VALUES('1281','Ȫ','Yangquan','1008','281');
INSERT INTO job_provinceandcity VALUES('1282','˳','Yuncheng','1008','282');
INSERT INTO job_provinceandcity VALUES('1283','','Changzhi','1008','283');
INSERT INTO job_provinceandcity VALUES('1284','ͬ','Datong','1008','284');
INSERT INTO job_provinceandcity VALUES('1285','','Jinzhong','1008','285');
INSERT INTO job_provinceandcity VALUES('1286','','Jincheng','1008','286');
INSERT INTO job_provinceandcity VALUES('1287','','Shangluo','1023','287');
INSERT INTO job_provinceandcity VALUES('1288','','Xianyang','1023','288');
INSERT INTO job_provinceandcity VALUES('1289','ͭ','Tongchuan','1023','289');
INSERT INTO job_provinceandcity VALUES('1290','μ','Weinan','1023','290');
INSERT INTO job_provinceandcity VALUES('1291','','Xian','1023','291');
INSERT INTO job_provinceandcity VALUES('1292','Ӱ','Yanan','1023','292');
INSERT INTO job_provinceandcity VALUES('1293','','Yulin','1023','293');
INSERT INTO job_provinceandcity VALUES('1294','','Ankang','1023','294');
INSERT INTO job_provinceandcity VALUES('1295','','Baoji','1023','295');
INSERT INTO job_provinceandcity VALUES('1296','','Hanzhong','1023','296');
INSERT INTO job_provinceandcity VALUES('1297','','Mianyang','1009','297');
INSERT INTO job_provinceandcity VALUES('1298','','Luzhou','1009','298');
INSERT INTO job_provinceandcity VALUES('1299','ɽ','Leshan','1009','299');
INSERT INTO job_provinceandcity VALUES('1300','ɽ','Liangshan','1009','300');
INSERT INTO job_provinceandcity VALUES('1301','üɽ','Meishan','1009','301');
INSERT INTO job_provinceandcity VALUES('1302','','Suining','1009','302');
INSERT INTO job_provinceandcity VALUES('1303','Ű','Yaan','1009','303');
INSERT INTO job_provinceandcity VALUES('1304','˱','Yibin','1009','304');
INSERT INTO job_provinceandcity VALUES('1305','֦','Panzhihua','1009','305');
INSERT INTO job_provinceandcity VALUES('1306','ϳ','Nanchong','1009','306');
INSERT INTO job_provinceandcity VALUES('1307','ڽ','Neijiang','1009','307');
INSERT INTO job_provinceandcity VALUES('1308','','Bazhong','1009','308');
INSERT INTO job_provinceandcity VALUES('1309','ӲǼ','Aba','1009','309');
INSERT INTO job_provinceandcity VALUES('1310','ɶ','Chengdu','1009','310');
INSERT INTO job_provinceandcity VALUES('1311','','Dazhou','1009','311');
INSERT INTO job_provinceandcity VALUES('1312','','Deyang','1009','312');
INSERT INTO job_provinceandcity VALUES('1313','β','Ganzi','1009','313');
INSERT INTO job_provinceandcity VALUES('1314','Ԫ','Guangyuan','1009','314');
INSERT INTO job_provinceandcity VALUES('1315','㰲','Guangan','1009','315');
INSERT INTO job_provinceandcity VALUES('1316','','Ziyang','1009','316');
INSERT INTO job_provinceandcity VALUES('1317','Թ','Zigong','1009','317');
INSERT INTO job_provinceandcity VALUES('1318','֥','Linzhi','1029','318');
INSERT INTO job_provinceandcity VALUES('1319','','Lasa','1029','319');
INSERT INTO job_provinceandcity VALUES('1320','տ','Rikaze','1029','320');
INSERT INTO job_provinceandcity VALUES('1321','ɽϵ','Shannan','1029','321');
INSERT INTO job_provinceandcity VALUES('1322','','Naqu','1029','322');
INSERT INTO job_provinceandcity VALUES('1323','','Ali','1029','323');
INSERT INTO job_provinceandcity VALUES('1324','','Changdu','1029','324');
INSERT INTO job_provinceandcity VALUES('1325','³','Tulufan','1028','325');
INSERT INTO job_provinceandcity VALUES('1326','³ľ','Wulumuqi','1028','326');
INSERT INTO job_provinceandcity VALUES('1327','','Yining','1028','327');
INSERT INTO job_provinceandcity VALUES('1328','ͼʲ','Atushi','1028','328');
INSERT INTO job_provinceandcity VALUES('1329','','Akesu','1028','329');
INSERT INTO job_provinceandcity VALUES('1330','','Changji','1028','330');
INSERT INTO job_provinceandcity VALUES('1331','','Bole','1028','331');
INSERT INTO job_provinceandcity VALUES('1332','','Hami','1028','332');
INSERT INTO job_provinceandcity VALUES('1333','','Hetian','1028','333');
INSERT INTO job_provinceandcity VALUES('1334','','Kuerle','1028','334');
INSERT INTO job_provinceandcity VALUES('1335','','Kelamayi','1028','335');
INSERT INTO job_provinceandcity VALUES('1336','ʲ','Kashi','1028','336');
INSERT INTO job_provinceandcity VALUES('1337','ٲ','Lincang','1022','337');
INSERT INTO job_provinceandcity VALUES('1338','','Lijiang','1022','338');
INSERT INTO job_provinceandcity VALUES('1339','','Kunming','1022','339');
INSERT INTO job_provinceandcity VALUES('1340','º','Luxi','1022','340');
INSERT INTO job_provinceandcity VALUES('1341','','Qujing','1022','341');
INSERT INTO job_provinceandcity VALUES('1342','˼é','Simao','1022','342');
INSERT INTO job_provinceandcity VALUES('1343','ɽ׳','Wenshan','1022','343');
INSERT INTO job_provinceandcity VALUES('1344','ͨ','Zhaotong','1022','344');
INSERT INTO job_provinceandcity VALUES('1345','Ϫ','Yuxi','1022','345');
INSERT INTO job_provinceandcity VALUES('1346','ŭ','Nujiang','1022','346');
INSERT INTO job_provinceandcity VALUES('1347','ɽ','Baoshan','1022','347');
INSERT INTO job_provinceandcity VALUES('1348','','Chuxiong','1022','348');
INSERT INTO job_provinceandcity VALUES('1349','','Dali','1022','349');
INSERT INTO job_provinceandcity VALUES('1350','','Diqing','1022','350');
INSERT INTO job_provinceandcity VALUES('1351','','Gejiu','1022','351');
INSERT INTO job_provinceandcity VALUES('1352','','Jinghong','1022','352');
INSERT INTO job_provinceandcity VALUES('1353','','Quzhou','1004','353');
INSERT INTO job_provinceandcity VALUES('1354','ˮ','Lishui','1004','354');
INSERT INTO job_provinceandcity VALUES('1355','','Shaoxing','1004','355');
INSERT INTO job_provinceandcity VALUES('1356','','Wenzhou','1004','356');
INSERT INTO job_provinceandcity VALUES('1357','̨','Taizhou','1004','357');
INSERT INTO job_provinceandcity VALUES('1358','','Ningbo','1004','358');
INSERT INTO job_provinceandcity VALUES('1359','ɽ','Zhoushan','1004','359');
INSERT INTO job_provinceandcity VALUES('1360','','Hangzhou','1004','360');
INSERT INTO job_provinceandcity VALUES('1361','','Huzhou','1004','361');
INSERT INTO job_provinceandcity VALUES('1362','','Jiaxing','1004','362');
INSERT INTO job_provinceandcity VALUES('1363','','Jinhua','1004','363');
INSERT INTO job_provinceandcity VALUES('1364','ʯ','Shihezi','1028','364');
INSERT INTO job_provinceandcity VALUES('1365','','Alaer','1028','365');
INSERT INTO job_provinceandcity VALUES('1366','ͼľ','Tumushuke','1028','366');
INSERT INTO job_provinceandcity VALUES('1367','','Wujiaqu','1028','367');
INSERT INTO job_provinceandcity VALUES('1368','','Beijing','1000','368');
INSERT INTO job_provinceandcity VALUES('1369','Ϻ','Shanghai','1001','369');
INSERT INTO job_provinceandcity VALUES('1370','','Tianjin','1002','370');
INSERT INTO job_provinceandcity VALUES('1371','','Chongqing','1003','371');
INSERT INTO job_provinceandcity VALUES('1372','','Hongkong','1372','372');
INSERT INTO job_provinceandcity VALUES('1373','','Macao','1373','373');
INSERT INTO job_provinceandcity VALUES('1374','̨','Taiwan','1374','374');
INSERT INTO job_provinceandcity VALUES('1375','ɳ','Baisha','1019','375');
INSERT INTO job_provinceandcity VALUES('1376','ͤ','Baoting','1019','376');
INSERT INTO job_provinceandcity VALUES('1377','','Changjiang','1019','377');
INSERT INTO job_provinceandcity VALUES('1378','','Chengmai','1019','378');
INSERT INTO job_provinceandcity VALUES('1379','','Dingan','1019','379');
INSERT INTO job_provinceandcity VALUES('1380','','Dongfang','1019','380');
INSERT INTO job_provinceandcity VALUES('1381','ֶ','Ledong','1019','381');
INSERT INTO job_provinceandcity VALUES('1382','ٸ','Lingao','1019','382');
INSERT INTO job_provinceandcity VALUES('1383','ˮ','Lingshui','1019','383');
INSERT INTO job_provinceandcity VALUES('1384','','Qionghai','1019','384');
INSERT INTO job_provinceandcity VALUES('1385','','Qiongzhong','1019','385');
INSERT INTO job_provinceandcity VALUES('1386','Ͳ','Tunchang','1019','386');
INSERT INTO job_provinceandcity VALUES('1387','','Wanning','1019','387');
INSERT INTO job_provinceandcity VALUES('1388','Ĳ','Wenchang','1019','388');
INSERT INTO job_provinceandcity VALUES('1389','ָɽ','Wuzhishan','1019','389');
INSERT INTO job_provinceandcity VALUES('1390','','Danzhou','1019','390');
INSERT INTO job_provinceandcity VALUES('1391','Դ','Jiyuan','1010','391');
INSERT INTO job_provinceandcity VALUES('1392','Ǳ','Qianjiang','1017','392');
INSERT INTO job_provinceandcity VALUES('1393','ũ','Shennongjia','1017','393');
INSERT INTO job_provinceandcity VALUES('1394','','Tianmen','1017','394');
INSERT INTO job_provinceandcity VALUES('1395','','Xiantao','1017','395');
INSERT INTO job_provinceandcity VALUES('1396','ƾ','Pinxiang','1025','396');
INSERT INTO job_provinceandcity VALUES('1397','','Dongcheng','1368','397');
INSERT INTO job_provinceandcity VALUES('1398','','Xicheng','1368','398');
INSERT INTO job_provinceandcity VALUES('1399','','Chongwen','1368','399');
INSERT INTO job_provinceandcity VALUES('1400','','Xuanwu','1368','400');
INSERT INTO job_provinceandcity VALUES('1401','','Chaoyang','1368','401');
INSERT INTO job_provinceandcity VALUES('1402','','Haidian','1368','402');
INSERT INTO job_provinceandcity VALUES('1403','̨','Fengtai','1368','403');
INSERT INTO job_provinceandcity VALUES('1404','ʯɽ','Shijingshan','1368','404');
INSERT INTO job_provinceandcity VALUES('1405','ɽ','Fangshan','1368','405');
INSERT INTO job_provinceandcity VALUES('1406','ͨ','Tongzhou','1368','406');
INSERT INTO job_provinceandcity VALUES('1407','˳','Shunyi','1368','407');
INSERT INTO job_provinceandcity VALUES('1408','ͷ','Mentougou','1368','408');
INSERT INTO job_provinceandcity VALUES('1409','ƽ','Changping','1368','409');
INSERT INTO job_provinceandcity VALUES('1410','','Daxing','1368','410');
INSERT INTO job_provinceandcity VALUES('1411','','Huairou','1368','411');
INSERT INTO job_provinceandcity VALUES('1412','ƽ','Pinggu','1368','412');
INSERT INTO job_provinceandcity VALUES('1413','','Miyun','1368','413');
INSERT INTO job_provinceandcity VALUES('1414','','Yanqing','1368','414');
INSERT INTO job_provinceandcity VALUES('1415','ƽ','Heping','1370','415');
INSERT INTO job_provinceandcity VALUES('1416','Ӷ','Hedong','1370','416');
INSERT INTO job_provinceandcity VALUES('1417','','Hexi','1370','417');
INSERT INTO job_provinceandcity VALUES('1418','Ͽ','Nankai','1370','418');
INSERT INTO job_provinceandcity VALUES('1419','ӱ','Hebei','1370','419');
INSERT INTO job_provinceandcity VALUES('1420','','Hongqiao','1370','420');
INSERT INTO job_provinceandcity VALUES('1421','','Tanggu','1370','421');
INSERT INTO job_provinceandcity VALUES('1422','','Hangu','1370','422');
INSERT INTO job_provinceandcity VALUES('1423','','Dagang','1370','423');
INSERT INTO job_provinceandcity VALUES('1424','','Dongli','1370','424');
INSERT INTO job_provinceandcity VALUES('1425','','Xiqing','1370','425');
INSERT INTO job_provinceandcity VALUES('1426','','Beichen','1370','426');
INSERT INTO job_provinceandcity VALUES('1427','','Jinnan','1370','427');
INSERT INTO job_provinceandcity VALUES('1428','','Wuqing','1370','428');
INSERT INTO job_provinceandcity VALUES('1429','','Baodi','1370','429');
INSERT INTO job_provinceandcity VALUES('1430','','Jinghai','1370','430');
INSERT INTO job_provinceandcity VALUES('1431','','Ninghe','1370','431');
INSERT INTO job_provinceandcity VALUES('1432','','Jixian','1370','432');
INSERT INTO job_provinceandcity VALUES('1433','','Huangpu','1369','433');
INSERT INTO job_provinceandcity VALUES('1434','¬','Luwan','1369','434');
INSERT INTO job_provinceandcity VALUES('1435','','Xuhui','1369','435');
INSERT INTO job_provinceandcity VALUES('1436','','Changning','1369','436');
INSERT INTO job_provinceandcity VALUES('1437','','Jingan','1369','437');
INSERT INTO job_provinceandcity VALUES('1438','','Putuo','1369','438');
INSERT INTO job_provinceandcity VALUES('1439','բ','Zhabei','1369','439');
INSERT INTO job_provinceandcity VALUES('1440','','Hongkou','1369','440');
INSERT INTO job_provinceandcity VALUES('1441','','Yangpu','1369','441');
INSERT INTO job_provinceandcity VALUES('1442','ɽ','Baoshan','1369','442');
INSERT INTO job_provinceandcity VALUES('1443','','Minxing','1369','443');
INSERT INTO job_provinceandcity VALUES('1444','ζ','Jiading','1369','444');
INSERT INTO job_provinceandcity VALUES('1445','ɽ','Songjiang','1369','445');
INSERT INTO job_provinceandcity VALUES('1446','ɽ','Jinshan','1369','446');
INSERT INTO job_provinceandcity VALUES('1447','','Qingpu','1369','447');
INSERT INTO job_provinceandcity VALUES('1448','ֶ','Pudong','1369','448');
INSERT INTO job_provinceandcity VALUES('1449','ϻ','Nanhui','1369','449');
INSERT INTO job_provinceandcity VALUES('1450','','Fengxian','1369','450');
INSERT INTO job_provinceandcity VALUES('1451','','Chongming','1369','451');
INSERT INTO job_provinceandcity VALUES('1452','','Yuzhong','1371','452');
INSERT INTO job_provinceandcity VALUES('1453','ɿ','Dadukou','1371','453');
INSERT INTO job_provinceandcity VALUES('1454','','Jiangbei','1371','454');
INSERT INTO job_provinceandcity VALUES('1455','ɳƺ','Shapingba','1371','455');
INSERT INTO job_provinceandcity VALUES('1456','','Jiulongpo','1371','456');
INSERT INTO job_provinceandcity VALUES('1457','ϰ','Nanan','1371','457');
INSERT INTO job_provinceandcity VALUES('1458','','Beibei','1371','458');
INSERT INTO job_provinceandcity VALUES('1459','ʢ','Wansheng','1371','459');
INSERT INTO job_provinceandcity VALUES('1460','˫','Shuangqiao','1371','460');
INSERT INTO job_provinceandcity VALUES('1461','山','Yubei','1371','461');
INSERT INTO job_provinceandcity VALUES('1462','','Banan','1371','462');
INSERT INTO job_provinceandcity VALUES('1463','','Wanzhou','1371','463');
INSERT INTO job_provinceandcity VALUES('1464','','Fuling','1371','464');
INSERT INTO job_provinceandcity VALUES('1465','ǭ','Qianjiang','1371','465');
INSERT INTO job_provinceandcity VALUES('1466','','Changshou','1371','466');
INSERT INTO job_provinceandcity VALUES('1467','','Yongzhou','1371','467');
INSERT INTO job_provinceandcity VALUES('1468','ϴ','Hezhou','1371','468');
INSERT INTO job_provinceandcity VALUES('1469','','Jiangjin','1371','469');
INSERT INTO job_provinceandcity VALUES('1470','ϴ','Nanchuan','1371','470');
INSERT INTO job_provinceandcity VALUES('1471','뽭','Qijiang','1371','471');
INSERT INTO job_provinceandcity VALUES('1472','','Tongnan','1371','472');
INSERT INTO job_provinceandcity VALUES('1473','ٲ','Rongchang','1371','473');
INSERT INTO job_provinceandcity VALUES('1474','ɽ','Bishan','1371','474');
INSERT INTO job_provinceandcity VALUES('1475','','Dazu','1371','475');
INSERT INTO job_provinceandcity VALUES('1476','ͭ','Tongliang','1371','476');
INSERT INTO job_provinceandcity VALUES('1477','ƽ','Liangping','1371','477');
INSERT INTO job_provinceandcity VALUES('1478','ǿ','Chengkou','1371','478');
INSERT INTO job_provinceandcity VALUES('1479','潭','Dianjiang','1371','479');
INSERT INTO job_provinceandcity VALUES('1480','¡','Wulong','1371','480');
INSERT INTO job_provinceandcity VALUES('1481','ᶼ','Fengdu','1371','481');
INSERT INTO job_provinceandcity VALUES('1482','','Fengjie','1371','482');
INSERT INTO job_provinceandcity VALUES('1483','','Kaixian','1371','483');
INSERT INTO job_provinceandcity VALUES('1484','','Yunyang','1371','484');
INSERT INTO job_provinceandcity VALUES('1485','','Zhongxian','1371','485');
INSERT INTO job_provinceandcity VALUES('1486','Ϫ','Wuxi','1371','486');
INSERT INTO job_provinceandcity VALUES('1487','ɽ','Wushan','1371','487');
INSERT INTO job_provinceandcity VALUES('1488','ʯ','Shizhu','1371','488');
INSERT INTO job_provinceandcity VALUES('1489','ɽ','Xiushan','1371','489');
INSERT INTO job_provinceandcity VALUES('1490','','Youyang','1371','490');
INSERT INTO job_provinceandcity VALUES('1491','ˮ','Pengshui','1371','491');
INSERT INTO job_provinceandcity VALUES('1492','','Changan','1123','492');
INSERT INTO job_provinceandcity VALUES('1493','Ŷ','Qiaodong','1123','493');
INSERT INTO job_provinceandcity VALUES('1494','','Qiaoxi','1123','494');
INSERT INTO job_provinceandcity VALUES('1495','»','Xinhua','1123','495');
INSERT INTO job_provinceandcity VALUES('1496','ԣ','Yuhua','1123','496');
INSERT INTO job_provinceandcity VALUES('1497','','Jingxing Mining Area','1123','497');
INSERT INTO job_provinceandcity VALUES('1498','','Xinji','1123','498');
INSERT INTO job_provinceandcity VALUES('1499','޻','Gaocheng','1123','499');
INSERT INTO job_provinceandcity VALUES('1500','','Jinzhou','1123','500');
INSERT INTO job_provinceandcity VALUES('1501','','Xinle','1123','501');
INSERT INTO job_provinceandcity VALUES('1502','¹Ȫ','Luquan','1123','502');
INSERT INTO job_provinceandcity VALUES('1503','ƽɽ','Pingshan','1123','503');
INSERT INTO job_provinceandcity VALUES('1504','','Jingxing','1123','504');
INSERT INTO job_provinceandcity VALUES('1505','','Luancheng','1123','505');
INSERT INTO job_provinceandcity VALUES('1506','','Zhengding','1123','506');
INSERT INTO job_provinceandcity VALUES('1507','','Xingtang','1123','507');
INSERT INTO job_provinceandcity VALUES('1508','','Lingshou','1123','508');
INSERT INTO job_provinceandcity VALUES('1509','','Gaoyi','1123','509');
INSERT INTO job_provinceandcity VALUES('1510','','Zhaoxian','1123','510');
INSERT INTO job_provinceandcity VALUES('1511','޻','Zanhuang','1123','511');
INSERT INTO job_provinceandcity VALUES('1512','','Shenze','1123','512');
INSERT INTO job_provinceandcity VALUES('1513','޼','Wuji','1123','513');
INSERT INTO job_provinceandcity VALUES('1514','Ԫ','Yuanshi','1123','514');
INSERT INTO job_provinceandcity VALUES('1515','·','Lubei','1124','515');
INSERT INTO job_provinceandcity VALUES('1516','·','Lunan','1124','516');
INSERT INTO job_provinceandcity VALUES('1517','ұ','Guzhi','1124','517');
INSERT INTO job_provinceandcity VALUES('1518','ƽ','Kaiping','1124','518');
INSERT INTO job_provinceandcity VALUES('1519','','Fengnan','1124','519');
INSERT INTO job_provinceandcity VALUES('1520','','Fengrun','1124','520');
INSERT INTO job_provinceandcity VALUES('1521','','Zunhua','1124','521');
INSERT INTO job_provinceandcity VALUES('1522','Ǩ','Qianan','1124','522');
INSERT INTO job_provinceandcity VALUES('1523','Ǩ','Qianxi','1124','523');
INSERT INTO job_provinceandcity VALUES('1524','','Luannan','1124','524');
INSERT INTO job_provinceandcity VALUES('1525','','Yutian','1124','525');
INSERT INTO job_provinceandcity VALUES('1526','ƺ','Tanghai','1124','526');
INSERT INTO job_provinceandcity VALUES('1527','ͤ','Leting','1124','527');
INSERT INTO job_provinceandcity VALUES('1528','','Luanxian','1124','528');
INSERT INTO job_provinceandcity VALUES('1529','','Hanggang','1121','529');
INSERT INTO job_provinceandcity VALUES('1530','ɽ','Shanhaiguan','1121','530');
INSERT INTO job_provinceandcity VALUES('1531','','Beidaihe','1121','531');
INSERT INTO job_provinceandcity VALUES('1532','','Changli','1121','532');
INSERT INTO job_provinceandcity VALUES('1533','¬','Lulong','1121','533');
INSERT INTO job_provinceandcity VALUES('1534','','Funing','1121','534');
INSERT INTO job_provinceandcity VALUES('1535','','Qinglong','1121','535');
INSERT INTO job_provinceandcity VALUES('1536','̨','Congtai','1130','536');
INSERT INTO job_provinceandcity VALUES('1537','','Fuxing','1130','537');
INSERT INTO job_provinceandcity VALUES('1538','ɽ','Hanshan','1130','538');
INSERT INTO job_provinceandcity VALUES('1539','','Fengfeng Mining Area','1130','539');
INSERT INTO job_provinceandcity VALUES('1540','䰲','Wuan','1130','540');
INSERT INTO job_provinceandcity VALUES('1541','','Handan','1130','541');
INSERT INTO job_provinceandcity VALUES('1542','','Yongnian','1130','542');
INSERT INTO job_provinceandcity VALUES('1543','','Quzhou','1130','543');
INSERT INTO job_provinceandcity VALUES('1544','','Guantao','1130','544');
INSERT INTO job_provinceandcity VALUES('1545','κ','Weixian','1130','545');
INSERT INTO job_provinceandcity VALUES('1546','ɰ','Chengan','1130','546');
INSERT INTO job_provinceandcity VALUES('1547','','Daming','1130','547');
INSERT INTO job_provinceandcity VALUES('1548','','Shexian','1130','548');
INSERT INTO job_provinceandcity VALUES('1549','','Jize','1130','549');
INSERT INTO job_provinceandcity VALUES('1550','','Qiuxian','1130','550');
INSERT INTO job_provinceandcity VALUES('1551','ƽ','Guangping','1130','551');
INSERT INTO job_provinceandcity VALUES('1552','','Feixiang','1130','552');
INSERT INTO job_provinceandcity VALUES('1553','','Linzhang','1130','553');
INSERT INTO job_provinceandcity VALUES('1554','','Cixian','1130','554');
INSERT INTO job_provinceandcity VALUES('1555','Ŷ','Qiaodong','1122','555');
INSERT INTO job_provinceandcity VALUES('1556','','Qiaoxi','1122','556');
INSERT INTO job_provinceandcity VALUES('1557','Ϲ','Nangong','1122','557');
INSERT INTO job_provinceandcity VALUES('1558','ɳ','Shahe','1122','558');
INSERT INTO job_provinceandcity VALUES('1559','̨','Xingtai','1122','559');
INSERT INTO job_provinceandcity VALUES('1560','','Baixiang','1122','560');
INSERT INTO job_provinceandcity VALUES('1561','','Renxian','1122','561');
INSERT INTO job_provinceandcity VALUES('1562','','Qinghe','1122','562');
INSERT INTO job_provinceandcity VALUES('1563','','Ningjin','1122','563');
INSERT INTO job_provinceandcity VALUES('1564','','Weixian','1122','564');
INSERT INTO job_provinceandcity VALUES('1565','¡Ң','Longyao','1122','565');
INSERT INTO job_provinceandcity VALUES('1566','ٳ','Lincheng','1122','566');
INSERT INTO job_provinceandcity VALUES('1567','','Guangzong','1122','567');
INSERT INTO job_provinceandcity VALUES('1568','','Linxi','1122','568');
INSERT INTO job_provinceandcity VALUES('1569','','Neiqiu','1122','569');
INSERT INTO job_provinceandcity VALUES('1570','ƽ','Pingxiang','1122','570');
INSERT INTO job_provinceandcity VALUES('1571','¹','Julu','1122','571');
INSERT INTO job_provinceandcity VALUES('1572','º','Xinhe','1122','572');
INSERT INTO job_provinceandcity VALUES('1573','Ϻ','Nanhe','1122','573');
INSERT INTO job_provinceandcity VALUES('1574','','Xinshi','1126','574');
INSERT INTO job_provinceandcity VALUES('1575','','Nanshi','1126','575');
INSERT INTO job_provinceandcity VALUES('1576','','Beishi','1126','576');
INSERT INTO job_provinceandcity VALUES('1577','','Zhuozhou','1126','577');
INSERT INTO job_provinceandcity VALUES('1578','','Dingzhou','1126','578');
INSERT INTO job_provinceandcity VALUES('1579','','Anguo','1126','579');
INSERT INTO job_provinceandcity VALUES('1580','߱','Gaobeidian','1126','580');
INSERT INTO job_provinceandcity VALUES('1581','','Mancheng','1126','581');
INSERT INTO job_provinceandcity VALUES('1582','Է','Qingyuan','1126','582');
INSERT INTO job_provinceandcity VALUES('1583','ˮ','Laishui','1126','583');
INSERT INTO job_provinceandcity VALUES('1584','ƽ','Fuping','1126','584');
INSERT INTO job_provinceandcity VALUES('1585','ˮ','Xushui','1126','585');
INSERT INTO job_provinceandcity VALUES('1586','','Dingxing','1126','586');
INSERT INTO job_provinceandcity VALUES('1587','','Tangxian','1126','587');
INSERT INTO job_provinceandcity VALUES('1588','','Gaoyang','1126','588');
INSERT INTO job_provinceandcity VALUES('1589','ݳ','Rongcheng','1126','589');
INSERT INTO job_provinceandcity VALUES('1590','Դ','Laiyuan','1126','590');
INSERT INTO job_provinceandcity VALUES('1591','','Wangdu','1126','591');
INSERT INTO job_provinceandcity VALUES('1592','','Anxin','1126','592');
INSERT INTO job_provinceandcity VALUES('1593','','Yixian','1126','593');
INSERT INTO job_provinceandcity VALUES('1594','','Quyang','1126','594');
INSERT INTO job_provinceandcity VALUES('1595','','Lixian','1126','595');
INSERT INTO job_provinceandcity VALUES('1596','˳ƽ','Shunping','1126','596');
INSERT INTO job_provinceandcity VALUES('1597','Ұ','Boye','1126','597');
INSERT INTO job_provinceandcity VALUES('1598','','Xiongxian','1126','598');
INSERT INTO job_provinceandcity VALUES('1599','','Qiaoxi','1125','599');
INSERT INTO job_provinceandcity VALUES('1600','Ŷ','Qiaodong','1125','600');
INSERT INTO job_provinceandcity VALUES('1601','','Xuanhua','1125','601');
INSERT INTO job_provinceandcity VALUES('1602','»԰','Xiahuayuan','1125','602');
INSERT INTO job_provinceandcity VALUES('1603','','Xuanhua','1125','603');
INSERT INTO job_provinceandcity VALUES('1604','ԭ','Yangyuan','1125','604');
INSERT INTO job_provinceandcity VALUES('1605','','Chicheng','1125','605');
INSERT INTO job_provinceandcity VALUES('1606','Դ','Guyuan','1125','606');
INSERT INTO job_provinceandcity VALUES('1607','','Huaian','1125','607');
INSERT INTO job_provinceandcity VALUES('1608','','Huailai','1125','608');
INSERT INTO job_provinceandcity VALUES('1609','','Chongli','1125','609');
INSERT INTO job_provinceandcity VALUES('1610','','Shangyi','1125','610');
INSERT INTO job_provinceandcity VALUES('1611','ε','Weixian','1125','611');
INSERT INTO job_provinceandcity VALUES('1612','¹','Zhuolu','1125','612');
INSERT INTO job_provinceandcity VALUES('1613','ȫ','Wanquan','1125','613');
INSERT INTO job_provinceandcity VALUES('1614','','Kangbao','1125','614');
INSERT INTO job_provinceandcity VALUES('1615','ű','Zhangbei','1125','615');
INSERT INTO job_provinceandcity VALUES('1616','˫','Shuangqiao','1128','616');
INSERT INTO job_provinceandcity VALUES('1617','˫','Shuangluan','1128','617');
INSERT INTO job_provinceandcity VALUES('1618','ӥӪӿ','Yingshouyingzi ','1128','618');
INSERT INTO job_provinceandcity VALUES('1619','е','Chengde','1128','619');
INSERT INTO job_provinceandcity VALUES('1620','¡','Xinglong','1128','620');
INSERT INTO job_provinceandcity VALUES('1621','¡','Longhua','1128','621');
INSERT INTO job_provinceandcity VALUES('1622','ƽȪ','Pingquan','1128','622');
INSERT INTO job_provinceandcity VALUES('1623','ƽ','Luanping','1128','623');
INSERT INTO job_provinceandcity VALUES('1624','','Fengning','1128','624');
INSERT INTO job_provinceandcity VALUES('1625','Χɹ','Weichang','1128','625');
INSERT INTO job_provinceandcity VALUES('1626','','Kuancheng','1128','626');
INSERT INTO job_provinceandcity VALUES('1627','˺','Yunhe','1127','627');
INSERT INTO job_provinceandcity VALUES('1628','»','Xinhua','1127','628');
INSERT INTO job_provinceandcity VALUES('1629','ͷ','Botou','1127','629');
INSERT INTO job_provinceandcity VALUES('1630','','Renqiu','1127','630');
INSERT INTO job_provinceandcity VALUES('1631','','Huanghua','1127','631');
INSERT INTO job_provinceandcity VALUES('1632','Ӽ','Hejian','1127','632');
INSERT INTO job_provinceandcity VALUES('1633','','Cangxian','1127','633');
INSERT INTO job_provinceandcity VALUES('1634','','Qingxian','1127','634');
INSERT INTO job_provinceandcity VALUES('1635','','Xianxian','1127','635');
INSERT INTO job_provinceandcity VALUES('1636','','Dongguang','1127','636');
INSERT INTO job_provinceandcity VALUES('1637','','Haixing','1127','637');
INSERT INTO job_provinceandcity VALUES('1638','ɽ','Yanshan','1127','638');
INSERT INTO job_provinceandcity VALUES('1639','','Suning','1127','639');
INSERT INTO job_provinceandcity VALUES('1640','Ƥ','Nanpi','1127','640');
INSERT INTO job_provinceandcity VALUES('1641','','Wuqiao','1127','641');
INSERT INTO job_provinceandcity VALUES('1642','ϴ','Mengcun','1127','642');
INSERT INTO job_provinceandcity VALUES('1643','','Anci','1120','643');
INSERT INTO job_provinceandcity VALUES('1644','','Guangyang','1120','644');
INSERT INTO job_provinceandcity VALUES('1645','','Bazhou','1120','645');
INSERT INTO job_provinceandcity VALUES('1646','','Sanhe ','1120','646');
INSERT INTO job_provinceandcity VALUES('1647','̰','Guan','1120','647');
INSERT INTO job_provinceandcity VALUES('1648','','Yongqing','1120','648');
INSERT INTO job_provinceandcity VALUES('1649','','Xianghe','1120','649');
INSERT INTO job_provinceandcity VALUES('1650','','Dacheng','1120','650');
INSERT INTO job_provinceandcity VALUES('1651','İ','Wenan','1120','651');
INSERT INTO job_provinceandcity VALUES('1652','󳧻','Daguang','1120','652');
INSERT INTO job_provinceandcity VALUES('1653','ҳ','Taocheng','1129','653');
INSERT INTO job_provinceandcity VALUES('1654','','Jizhou','1129','654');
INSERT INTO job_provinceandcity VALUES('1655','','Shenzhou','1129','655');
INSERT INTO job_provinceandcity VALUES('1656','','Raoyang','1129','656');
INSERT INTO job_provinceandcity VALUES('1657','ǿ','Zaoqiang','1129','657');
INSERT INTO job_provinceandcity VALUES('1658','ʳ','Gucheng','1129','658');
INSERT INTO job_provinceandcity VALUES('1659','','Fucheng','1129','659');
INSERT INTO job_provinceandcity VALUES('1660','ƽ','Anping','1129','660');
INSERT INTO job_provinceandcity VALUES('1661','','Wuyi','1129','661');
INSERT INTO job_provinceandcity VALUES('1662','','Jingxian','1129','662');
INSERT INTO job_provinceandcity VALUES('1663','ǿ','Wuqiang','1129','663');
INSERT INTO job_provinceandcity VALUES('1664','ӻ','Xinhualing','1280','664');
INSERT INTO job_provinceandcity VALUES('1665','С','Xiaodian','1280','665');
INSERT INTO job_provinceandcity VALUES('1666','ӭ','Yingze','1280','666');
INSERT INTO job_provinceandcity VALUES('1667','ƺ','Jiancaoping','1280','667');
INSERT INTO job_provinceandcity VALUES('1668','','Wanbailin','1280','668');
INSERT INTO job_provinceandcity VALUES('1669','Դ','Jinyuan','1280','669');
INSERT INTO job_provinceandcity VALUES('1670','Ž','Gujiao','1280','670');
INSERT INTO job_provinceandcity VALUES('1671','','Yangqu','1280','671');
INSERT INTO job_provinceandcity VALUES('1672','','Qingxu','1280','672');
INSERT INTO job_provinceandcity VALUES('1673','¦','Loufan','1280','673');
INSERT INTO job_provinceandcity VALUES('1674','','Urban Area','1284','674');
INSERT INTO job_provinceandcity VALUES('1675','','Mining Area','1284','675');
INSERT INTO job_provinceandcity VALUES('1676','Ͻ','Nanjiao','1284','676');
INSERT INTO job_provinceandcity VALUES('1677','','Xinrong','1284','677');
INSERT INTO job_provinceandcity VALUES('1678','ͬ','Datong','1284','678');
INSERT INTO job_provinceandcity VALUES('1679','','Tianzhen','1284','679');
INSERT INTO job_provinceandcity VALUES('1680','','Lingqiu','1284','680');
INSERT INTO job_provinceandcity VALUES('1681','','Yanggao','1284','681');
INSERT INTO job_provinceandcity VALUES('1682','','Zuoyun','1284','682');
INSERT INTO job_provinceandcity VALUES('1683','','Guangling','1284','683');
INSERT INTO job_provinceandcity VALUES('1684','Դ','Hunyuan','1284','684');
INSERT INTO job_provinceandcity VALUES('1685','','Urban Area','1281','685');
INSERT INTO job_provinceandcity VALUES('1686','','Mining Area','1281','686');
INSERT INTO job_provinceandcity VALUES('1687','','Suburb','1281','687');
INSERT INTO job_provinceandcity VALUES('1688','ƽ','Pingding','1281','688');
INSERT INTO job_provinceandcity VALUES('1689','','Yuxian','1281','689');
INSERT INTO job_provinceandcity VALUES('1690','','Urban Area','1283','690');
INSERT INTO job_provinceandcity VALUES('1691','','Suburb','1283','691');
INSERT INTO job_provinceandcity VALUES('1692','º','Lucheng','1283','692');
INSERT INTO job_provinceandcity VALUES('1693','','Changzhi','1283','693');
INSERT INTO job_provinceandcity VALUES('1694','','Zhangzi','1283','694');
INSERT INTO job_provinceandcity VALUES('1695','ƽ˳','Pingshun','1283','695');
INSERT INTO job_provinceandcity VALUES('1696','ԫ','Xiangyuan','1283','696');
INSERT INTO job_provinceandcity VALUES('1697','Դ','Qinyuan','1283','697');
INSERT INTO job_provinceandcity VALUES('1698','','Tunliu','1283','698');
INSERT INTO job_provinceandcity VALUES('1699','','Licheng','1283','699');
INSERT INTO job_provinceandcity VALUES('1700','','Wuxiang','1283','700');
INSERT INTO job_provinceandcity VALUES('1701','','Qinxian','1283','701');
INSERT INTO job_provinceandcity VALUES('1702','','Huguan','1283','702');
INSERT INTO job_provinceandcity VALUES('1703','','Urban Area','1286','703');
INSERT INTO job_provinceandcity VALUES('1704','ƽ','Gaoping','1286','704');
INSERT INTO job_provinceandcity VALUES('1705','','Zezhou','1286','705');
INSERT INTO job_provinceandcity VALUES('1706','괨','Lingchuan','1286','706');
INSERT INTO job_provinceandcity VALUES('1707','','Yangcheng','1286','707');
INSERT INTO job_provinceandcity VALUES('1708','ˮ','Qinshui','1286','708');
INSERT INTO job_provinceandcity VALUES('1709','˷','Shuocheng','1279','709');
INSERT INTO job_provinceandcity VALUES('1710','ƽ³','Pinglu','1279','710');
INSERT INTO job_provinceandcity VALUES('1711','ɽ','Shanyin','1279','711');
INSERT INTO job_provinceandcity VALUES('1712','','Youyu','1279','712');
INSERT INTO job_provinceandcity VALUES('1713','Ӧ','Yingxian','1279','713');
INSERT INTO job_provinceandcity VALUES('1714','','Huairen','1279','714');
INSERT INTO job_provinceandcity VALUES('1715','ܴ','Yuci','1285','715');
INSERT INTO job_provinceandcity VALUES('1716','','Jiexiu','1285','716');
INSERT INTO job_provinceandcity VALUES('1717','','Xiyang','1285','717');
INSERT INTO job_provinceandcity VALUES('1718','ʯ','Lingshi','1285','718');
INSERT INTO job_provinceandcity VALUES('1719','','Qixian','1285','719');
INSERT INTO job_provinceandcity VALUES('1720','Ȩ','Zuoquan','1285','720');
INSERT INTO job_provinceandcity VALUES('1721','','Shouyang','1285','721');
INSERT INTO job_provinceandcity VALUES('1722','̫','Taigu','1285','722');
INSERT INTO job_provinceandcity VALUES('1723','˳','Heshun','1285','723');
INSERT INTO job_provinceandcity VALUES('1724','ƽң','Pingyao','1285','724');
INSERT INTO job_provinceandcity VALUES('1725','','Yushe','1285','725');
INSERT INTO job_provinceandcity VALUES('1726','ø','Xinfu','1278','726');
INSERT INTO job_provinceandcity VALUES('1727','ԭƽ','Yuanping','1278','727');
INSERT INTO job_provinceandcity VALUES('1728','','Daixian','1278','728');
INSERT INTO job_provinceandcity VALUES('1729','','Shenchi','1278','729');
INSERT INTO job_provinceandcity VALUES('1730','կ','Wuzhai','1278','730');
INSERT INTO job_provinceandcity VALUES('1731','̨','Wutai','1278','731');
INSERT INTO job_provinceandcity VALUES('1732','ƫ','Pianguan','1278','732');
INSERT INTO job_provinceandcity VALUES('1733','','Ningwu','1278','733');
INSERT INTO job_provinceandcity VALUES('1734','','Jingle','1278','734');
INSERT INTO job_provinceandcity VALUES('1735','','Fanshi','1278','735');
INSERT INTO job_provinceandcity VALUES('1736','','Hequ','1278','736');
INSERT INTO job_provinceandcity VALUES('1737','','Baode','1278','737');
INSERT INTO job_provinceandcity VALUES('1738','','Dingxiang','1278','738');
INSERT INTO job_provinceandcity VALUES('1739','','Kelan','1278','739');
INSERT INTO job_provinceandcity VALUES('1740','Ң','Yaodu','1277','740');
INSERT INTO job_provinceandcity VALUES('1741','','Houma','1277','741');
INSERT INTO job_provinceandcity VALUES('1742','','Huozhou','1277','742');
INSERT INTO job_provinceandcity VALUES('1743','','Fenxi','1277','743');
INSERT INTO job_provinceandcity VALUES('1744','','Jixian','1277','744');
INSERT INTO job_provinceandcity VALUES('1745','','Anze','1277','745');
INSERT INTO job_provinceandcity VALUES('1746','','Daning','1277','746');
INSERT INTO job_provinceandcity VALUES('1747','ɽ','Fushan','1277','747');
INSERT INTO job_provinceandcity VALUES('1748','','Guxian','1277','748');
INSERT INTO job_provinceandcity VALUES('1749','','Xixian','1277','749');
INSERT INTO job_provinceandcity VALUES('1750','','Xiangfen','1277','750');
INSERT INTO job_provinceandcity VALUES('1751','','Yicheng','1277','751');
INSERT INTO job_provinceandcity VALUES('1752','','Yonghe','1277','752');
INSERT INTO job_provinceandcity VALUES('1753','','Xiangning','1277','753');
INSERT INTO job_provinceandcity VALUES('1754','','Quwo','1277','754');
INSERT INTO job_provinceandcity VALUES('1755','鶴','Hongdong','1277','755');
INSERT INTO job_provinceandcity VALUES('1756','','Puxian','1277','756');
INSERT INTO job_provinceandcity VALUES('1757','κ','Yanhu','1282','757');
INSERT INTO job_provinceandcity VALUES('1758','ӽ','Hejin','1282','758');
INSERT INTO job_provinceandcity VALUES('1759','','Yongji','1282','759');
INSERT INTO job_provinceandcity VALUES('1760','ϲ','Wenxi','1282','760');
INSERT INTO job_provinceandcity VALUES('1761','','Xinjiang','1282','761');
INSERT INTO job_provinceandcity VALUES('1762','ƽ½','Pinglu','1282','762');
INSERT INTO job_provinceandcity VALUES('1763','ԫ','Yuanqu','1282','763');
INSERT INTO job_provinceandcity VALUES('1764','','Jiangxian','1282','764');
INSERT INTO job_provinceandcity VALUES('1765','ɽ','Jishan','1282','765');
INSERT INTO job_provinceandcity VALUES('1766','ǳ','Ruicheng','1282','766');
INSERT INTO job_provinceandcity VALUES('1767','','Xiaxian','1282','767');
INSERT INTO job_provinceandcity VALUES('1768','','Wanrong','1282','768');
INSERT INTO job_provinceandcity VALUES('1769','','Linyi','1282','769');
INSERT INTO job_provinceandcity VALUES('1770','ʯ','Lishi','1276','770');
INSERT INTO job_provinceandcity VALUES('1771','Т','Xiaoyi','1276','771');
INSERT INTO job_provinceandcity VALUES('1772','','Fenyang','1276','772');
INSERT INTO job_provinceandcity VALUES('1773','ˮ','Wenshui','1276','773');
INSERT INTO job_provinceandcity VALUES('1774','','Zhongyang','1276','774');
INSERT INTO job_provinceandcity VALUES('1775','','Xingxian','1276','775');
INSERT INTO job_provinceandcity VALUES('1776','','Linxian','1276','776');
INSERT INTO job_provinceandcity VALUES('1777','ɽ','Fangshan','1276','777');
INSERT INTO job_provinceandcity VALUES('1778','','Liulin','1276','778');
INSERT INTO job_provinceandcity VALUES('1779','','Lanxian','1276','779');
INSERT INTO job_provinceandcity VALUES('1780','','Jiaokou','1276','780');
INSERT INTO job_provinceandcity VALUES('1781','','Jiaocheng','1276','781');
INSERT INTO job_provinceandcity VALUES('1782','ʯ¥','Shilou','1276','782');
INSERT INTO job_provinceandcity VALUES('1783','','Shenhe','1222','783');
INSERT INTO job_provinceandcity VALUES('1784','ʹ','Huanggu','1222','784');
INSERT INTO job_provinceandcity VALUES('1785','ƽ','Heping','1222','785');
INSERT INTO job_provinceandcity VALUES('1786','','Dadong','1222','786');
INSERT INTO job_provinceandcity VALUES('1787','','Tiexi','1222','787');
INSERT INTO job_provinceandcity VALUES('1788','ռ','Sujiatun','1222','788');
INSERT INTO job_provinceandcity VALUES('1789','','Dongling','1222','789');
INSERT INTO job_provinceandcity VALUES('1790','³','Xianchengzi','1222','790');
INSERT INTO job_provinceandcity VALUES('1791','ں','Yuhong','1222','791');
INSERT INTO job_provinceandcity VALUES('1792','','Xinmin','1222','792');
INSERT INTO job_provinceandcity VALUES('1793','','Faku','1222','793');
INSERT INTO job_provinceandcity VALUES('1794','','Liaozhong','1222','794');
INSERT INTO job_provinceandcity VALUES('1795','ƽ','Kangpping','1222','795');
INSERT INTO job_provinceandcity VALUES('1796','','Xigang','1229','796');
INSERT INTO job_provinceandcity VALUES('1797','ɽ','Zhongshan','1229','797');
INSERT INTO job_provinceandcity VALUES('1798','ɳӿ','Shahekou','1229','798');
INSERT INTO job_provinceandcity VALUES('1799','ʾ','Ganjingzi','1229','799');
INSERT INTO job_provinceandcity VALUES('1800','˳','Lvshunkou','1229','800');
INSERT INTO job_provinceandcity VALUES('1801','','Jinzhou','1229','801');
INSERT INTO job_provinceandcity VALUES('1802','߷','Wafangdian','1229','802');
INSERT INTO job_provinceandcity VALUES('1803','','Pulandian','1229','803');
INSERT INTO job_provinceandcity VALUES('1804','ׯ','Zhuanghe','1229','804');
INSERT INTO job_provinceandcity VALUES('1805','','Changhai','1229','805');
INSERT INTO job_provinceandcity VALUES('1806','','Tiedong','1226','806');
INSERT INTO job_provinceandcity VALUES('1807','','Tiexi','1226','807');
INSERT INTO job_provinceandcity VALUES('1808','ɽ','Lishan','1226','808');
INSERT INTO job_provinceandcity VALUES('1809','ǧɽ','Qianshan','1226','809');
INSERT INTO job_provinceandcity VALUES('1810','','Haicheng','1226','810');
INSERT INTO job_provinceandcity VALUES('1811','̨','Taian','1226','811');
INSERT INTO job_provinceandcity VALUES('1812','','Xiuyan','1226','812');
INSERT INTO job_provinceandcity VALUES('1813','¸','Xinfu','1231','813');
INSERT INTO job_provinceandcity VALUES('1814','','Dongzhou','1231','814');
INSERT INTO job_provinceandcity VALUES('1815','','Wanghua','1231','815');
INSERT INTO job_provinceandcity VALUES('1816','˳','Shuncheng','1231','816');
INSERT INTO job_provinceandcity VALUES('1817','˳','Fushun','1231','817');
INSERT INTO job_provinceandcity VALUES('1818','ԭ','Qingyuan','1231','818');
INSERT INTO job_provinceandcity VALUES('1819','±','Xinbin','1231','819');
INSERT INTO job_provinceandcity VALUES('1820','ƽɽ','Pingshan','1227','820');
INSERT INTO job_provinceandcity VALUES('1821','ɽ','Mingshan','1227','821');
INSERT INTO job_provinceandcity VALUES('1822','Ϫ','Xihu','1227','822');
INSERT INTO job_provinceandcity VALUES('1823','Ϸ','Nanfen','1227','823');
INSERT INTO job_provinceandcity VALUES('1824','Ϫ','Benxi','1227','824');
INSERT INTO job_provinceandcity VALUES('1825','','Huanren','1227','825');
INSERT INTO job_provinceandcity VALUES('1826','','Zhenxing','1230','826');
INSERT INTO job_provinceandcity VALUES('1827','Ԫ','Yuanbao','1230','827');
INSERT INTO job_provinceandcity VALUES('1828','','Zhenan','1230','828');
INSERT INTO job_provinceandcity VALUES('1829','','Donggang','1230','829');
INSERT INTO job_provinceandcity VALUES('1830','','Fengcheng','1230','830');
INSERT INTO job_provinceandcity VALUES('1831','','Kuandian','1230','831');
INSERT INTO job_provinceandcity VALUES('1832','̫','Taihe','1234','832');
INSERT INTO job_provinceandcity VALUES('1833','','Kuta','1234','833');
INSERT INTO job_provinceandcity VALUES('1834','','Linghe','1234','834');
INSERT INTO job_provinceandcity VALUES('1835','躣','Linghai','1234','835');
INSERT INTO job_provinceandcity VALUES('1836','','Beining','1234','836');
INSERT INTO job_provinceandcity VALUES('1837','ɽ','Heishan','1234','837');
INSERT INTO job_provinceandcity VALUES('1838','','Yixian','1234','838');
INSERT INTO job_provinceandcity VALUES('1839','','Longgang','1233','839');
INSERT INTO job_provinceandcity VALUES('1840','Ʊ','Nanpiao','1233','840');
INSERT INTO job_provinceandcity VALUES('1841','ɽ','Lianshan','1233','841');
INSERT INTO job_provinceandcity VALUES('1842','˳','Xingcheng','1233','842');
INSERT INTO job_provinceandcity VALUES('1843','','Suizhong','1233','843');
INSERT INTO job_provinceandcity VALUES('1844','','Jianchang','1233','844');
INSERT INTO job_provinceandcity VALUES('1845','վǰ','Zhanqian','1224','845');
INSERT INTO job_provinceandcity VALUES('1846','','Xishi','1224','846');
INSERT INTO job_provinceandcity VALUES('1847','Ȧ','Bayuquan','1224','847');
INSERT INTO job_provinceandcity VALUES('1848','ϱ','Laobian','1224','848');
INSERT INTO job_provinceandcity VALUES('1849','ʯ','Dashiqiao','1224','849');
INSERT INTO job_provinceandcity VALUES('1850','','Gaizhou','1224','850');
INSERT INTO job_provinceandcity VALUES('1851','˫̨','Shuangtaizi','1225','851');
INSERT INTO job_provinceandcity VALUES('1852','¡̨','Xinglongtai','1225','852');
INSERT INTO job_provinceandcity VALUES('1853','ɽ','Panshan','1225','853');
INSERT INTO job_provinceandcity VALUES('1854','','Dawa','1225','854');
INSERT INTO job_provinceandcity VALUES('1855','','Haizhou','1232','855');
INSERT INTO job_provinceandcity VALUES('1856','','Xinqiu','1232','856');
INSERT INTO job_provinceandcity VALUES('1857','̫ƽ','Taiping','1232','857');
INSERT INTO job_provinceandcity VALUES('1858','','Qinghemen','1232','858');
INSERT INTO job_provinceandcity VALUES('1859','ϸ','Xihe','1232','859');
INSERT INTO job_provinceandcity VALUES('1860','','Zhangwu','1232','860');
INSERT INTO job_provinceandcity VALUES('1861','ɹ','Fuxin','1232','861');
INSERT INTO job_provinceandcity VALUES('1862','','Baita','1221','862');
INSERT INTO job_provinceandcity VALUES('1863','ʥ','Wensheng','1221','863');
INSERT INTO job_provinceandcity VALUES('1864','ΰ','Hongwei','1221','864');
INSERT INTO job_provinceandcity VALUES('1865','̫Ӻ','Taizihe','1221','865');
INSERT INTO job_provinceandcity VALUES('1866','','Gongchangling','1221','866');
INSERT INTO job_provinceandcity VALUES('1867','','Dengta','1221','867');
INSERT INTO job_provinceandcity VALUES('1868','','Liaoyang','1221','868');
INSERT INTO job_provinceandcity VALUES('1869','','Yinzhou','1223','869');
INSERT INTO job_provinceandcity VALUES('1870','','Qinghe','1223','870');
INSERT INTO job_provinceandcity VALUES('1871','ɽ','Diaobingshan','1223','871');
INSERT INTO job_provinceandcity VALUES('1872','ԭ','Kaiyuan','1223','872');
INSERT INTO job_provinceandcity VALUES('1873','','Tieling','1223','873');
INSERT INTO job_provinceandcity VALUES('1874','ͼ','Changtu','1223','874');
INSERT INTO job_provinceandcity VALUES('1875','','Xifeng','1223','875');
INSERT INTO job_provinceandcity VALUES('1876','˫','Shuangta','1228','876');
INSERT INTO job_provinceandcity VALUES('1877','','Longcheng','1228','877');
INSERT INTO job_provinceandcity VALUES('1878','Դ','Lingyuan','1228','878');
INSERT INTO job_provinceandcity VALUES('1879','Ʊ','Beipiao','1228','879');
INSERT INTO job_provinceandcity VALUES('1880','','Chaoyang','1228','880');
INSERT INTO job_provinceandcity VALUES('1881','ƽ','Jianping','1228','881');
INSERT INTO job_provinceandcity VALUES('1882','ɹ','Kalaqin','1228','882');
INSERT INTO job_provinceandcity VALUES('1883','','Chaoyang','1195','883');
INSERT INTO job_provinceandcity VALUES('1884','','Kuancheng','1195','884');
INSERT INTO job_provinceandcity VALUES('1885','','Erdao','1195','885');
INSERT INTO job_provinceandcity VALUES('1886','Ϲ','Nanguan','1195','886');
INSERT INTO job_provinceandcity VALUES('1887','Բ','Lvyuan','1195','887');
INSERT INTO job_provinceandcity VALUES('1888','˫','Shuangyang','1195','888');
INSERT INTO job_provinceandcity VALUES('1889','̨','Jiutai','1195','889');
INSERT INTO job_provinceandcity VALUES('1890','','Yushu','1195','890');
INSERT INTO job_provinceandcity VALUES('1891','»','Dehui','1195','891');
INSERT INTO job_provinceandcity VALUES('1892','ũ','Nongan','1195','892');
INSERT INTO job_provinceandcity VALUES('1893','Ӫ','Chuanying','1196','893');
INSERT INTO job_provinceandcity VALUES('1894','','Changyi','1196','894');
INSERT INTO job_provinceandcity VALUES('1895','̶','Longtan','1196','895');
INSERT INTO job_provinceandcity VALUES('1896','','Fengman','1196','896');
INSERT INTO job_provinceandcity VALUES('1897','','Shulan','1196','897');
INSERT INTO job_provinceandcity VALUES('1898','','Huadian','1196','898');
INSERT INTO job_provinceandcity VALUES('1899','Ժ','Jiaohe','1196','899');
INSERT INTO job_provinceandcity VALUES('1900','ʯ','Panshi','1196','900');
INSERT INTO job_provinceandcity VALUES('1901','','Yongji','1196','901');
INSERT INTO job_provinceandcity VALUES('1902','','Tiexi','1190','902');
INSERT INTO job_provinceandcity VALUES('1903','','Tiedong','1190','903');
INSERT INTO job_provinceandcity VALUES('1904','','Gongzhuling','1190','904');
INSERT INTO job_provinceandcity VALUES('1905','˫','Shuangliao','1190','905');
INSERT INTO job_provinceandcity VALUES('1906','','Lishu','1190','906');
INSERT INTO job_provinceandcity VALUES('1907','ͨ','Yitong','1190','907');
INSERT INTO job_provinceandcity VALUES('1908','ɽ','Longshan','1188','908');
INSERT INTO job_provinceandcity VALUES('1909','','Xian','1188','909');
INSERT INTO job_provinceandcity VALUES('1910','','Dongliao','1188','910');
INSERT INTO job_provinceandcity VALUES('1911','','Dongfeng','1188','911');
INSERT INTO job_provinceandcity VALUES('1912','','Dongchang','1191','912');
INSERT INTO job_provinceandcity VALUES('1913','','Erdaojiang','1191','913');
INSERT INTO job_provinceandcity VALUES('1914','÷ӿ','Meihekou','1191','914');
INSERT INTO job_provinceandcity VALUES('1915','','Jian','1191','915');
INSERT INTO job_provinceandcity VALUES('1916','ͨ','Tonghua','1191','916');
INSERT INTO job_provinceandcity VALUES('1917','','Huinan','1191','917');
INSERT INTO job_provinceandcity VALUES('1918','','Liuhe','1191','918');
INSERT INTO job_provinceandcity VALUES('1919','˵','Badaojiang','1193','919');
INSERT INTO job_provinceandcity VALUES('1920','ٽ','Linjiang','1193','920');
INSERT INTO job_provinceandcity VALUES('1921','','Jingyu','1193','921');
INSERT INTO job_provinceandcity VALUES('1922','','Fusong','1193','922');
INSERT INTO job_provinceandcity VALUES('1923','Դ','Songyuan','1193','923');
INSERT INTO job_provinceandcity VALUES('1924','׳','Changbai','1193','924');
INSERT INTO job_provinceandcity VALUES('1925','','Ningjiang','1189','925');
INSERT INTO job_provinceandcity VALUES('1926','Ǭ','Qianan','1189','926');
INSERT INTO job_provinceandcity VALUES('1927','','Changling','1189','927');
INSERT INTO job_provinceandcity VALUES('1928','','Fuyu','1189','928');
INSERT INTO job_provinceandcity VALUES('1929','ǰ˹ɹ','Qianguoerluosi','1189','929');
INSERT INTO job_provinceandcity VALUES('1930','䬱','Taobei','1194','930');
INSERT INTO job_provinceandcity VALUES('1931','','Daan','1194','931');
INSERT INTO job_provinceandcity VALUES('1932','','Taonan','1194','932');
INSERT INTO job_provinceandcity VALUES('1933','','Zhenlai','1194','933');
INSERT INTO job_provinceandcity VALUES('1934','ͨ','Tongyu','1194','934');
INSERT INTO job_provinceandcity VALUES('1935','Ӽ','Yanji','1192','935');
INSERT INTO job_provinceandcity VALUES('1936','ͼ','Tumen','1192','936');
INSERT INTO job_provinceandcity VALUES('1937','ػ','Dunhua','1192','937');
INSERT INTO job_provinceandcity VALUES('1938','','Longjing','1192','938');
INSERT INTO job_provinceandcity VALUES('1939','','Hunchun','1192','939');
INSERT INTO job_provinceandcity VALUES('1940','','Helong','1192','940');
INSERT INTO job_provinceandcity VALUES('1941','ͼ','Antu','1192','941');
INSERT INTO job_provinceandcity VALUES('1942','','Wangqing','1192','942');
INSERT INTO job_provinceandcity VALUES('1943','','Daoli','1156','943');
INSERT INTO job_provinceandcity VALUES('1944','ϸ','Nangang','1156','944');
INSERT INTO job_provinceandcity VALUES('1945','','Dongli','1156','945');
INSERT INTO job_provinceandcity VALUES('1946','ƽ','Pingfang','1156','946');
INSERT INTO job_provinceandcity VALUES('1947','㷻','Xiangfang','1156','947');
INSERT INTO job_provinceandcity VALUES('1948','ɱ','Songbei','1156','948');
INSERT INTO job_provinceandcity VALUES('1949','','Hulan','1156','949');
INSERT INTO job_provinceandcity VALUES('1950','','Daowai','1156','950');
INSERT INTO job_provinceandcity VALUES('1951','','Acheng','1156','951');
INSERT INTO job_provinceandcity VALUES('1952','־','Shangzhi','1156','952');
INSERT INTO job_provinceandcity VALUES('1953','˫','Shuangcheng','1156','953');
INSERT INTO job_provinceandcity VALUES('1954','峣','Wuchang','1156','954');
INSERT INTO job_provinceandcity VALUES('1955','','Fangzheng','1156','955');
INSERT INTO job_provinceandcity VALUES('1956','','Binxian','1156','956');
INSERT INTO job_provinceandcity VALUES('1957','','Yilan','1156','957');
INSERT INTO job_provinceandcity VALUES('1958','','Bayan','1156','958');
INSERT INTO job_provinceandcity VALUES('1959','ͨ','Tonghe','1156','959');
INSERT INTO job_provinceandcity VALUES('1960','ľ','Mulan','1156','960');
INSERT INTO job_provinceandcity VALUES('1961','','Yanshou','1156','961');
INSERT INTO job_provinceandcity VALUES('1962','ɳ','Longsha','1151','962');
INSERT INTO job_provinceandcity VALUES('1963','Ϫ','Angangxi','1151','963');
INSERT INTO job_provinceandcity VALUES('1964','','Tiefeng','1151','964');
INSERT INTO job_provinceandcity VALUES('1965','','Jianhua','1151','965');
INSERT INTO job_provinceandcity VALUES('1966','','Fulaerji','1151','966');
INSERT INTO job_provinceandcity VALUES('1967','ɽ','Nianzishan','1151','967');
INSERT INTO job_provinceandcity VALUES('1968','÷˹Ӷ','Meilisidawoer','1151','968');
INSERT INTO job_provinceandcity VALUES('1969','ګ','Nehe','1151','969');
INSERT INTO job_provinceandcity VALUES('1970','ԣ','Fuyu','1151','970');
INSERT INTO job_provinceandcity VALUES('1971','Ȫ','Baiquan','1151','971');
INSERT INTO job_provinceandcity VALUES('1972','','Gannan','1151','972');
INSERT INTO job_provinceandcity VALUES('1973','','Yian','1151','973');
INSERT INTO job_provinceandcity VALUES('1974','ɽ','Keshan','1151','974');
INSERT INTO job_provinceandcity VALUES('1975','̩','Tailai','1151','975');
INSERT INTO job_provinceandcity VALUES('1976','˶','Kedong','1151','976');
INSERT INTO job_provinceandcity VALUES('1977','','Longjiang','1151','977');
INSERT INTO job_provinceandcity VALUES('1978','ɽ','Xingshan','1158','978');
INSERT INTO job_provinceandcity VALUES('1979','ũ','Gongnong','1158','979');
INSERT INTO job_provinceandcity VALUES('1980','ɽ','Nanshan','1158','980');
INSERT INTO job_provinceandcity VALUES('1981','˰','Xingan','1158','981');
INSERT INTO job_provinceandcity VALUES('1982','','Xiangyang','1158','982');
INSERT INTO job_provinceandcity VALUES('1983','ɽ','Dongshan','1158','983');
INSERT INTO job_provinceandcity VALUES('1984','ܱ','Luobei','1158','984');
INSERT INTO job_provinceandcity VALUES('1985','','Suibin','1158','985');
INSERT INTO job_provinceandcity VALUES('1986','ɽ','Jianshan','1149','986');
INSERT INTO job_provinceandcity VALUES('1987','붫','Lingdong','1149','987');
INSERT INTO job_provinceandcity VALUES('1988','ķ̨','Sifangtai','1149','988');
INSERT INTO job_provinceandcity VALUES('1989','ɽ','Baoshan','1149','989');
INSERT INTO job_provinceandcity VALUES('1990','','Jixian','1149','990');
INSERT INTO job_provinceandcity VALUES('1991','','Baoqing','1149','991');
INSERT INTO job_provinceandcity VALUES('1992','','Youyi','1149','992');
INSERT INTO job_provinceandcity VALUES('1993','ĺ','Raohe','1149','993');
INSERT INTO job_provinceandcity VALUES('1994','','Jiguan','1160','994');
INSERT INTO job_provinceandcity VALUES('1995','ɽ','Hengshan','1160','995');
INSERT INTO job_provinceandcity VALUES('1996','Ӻ','Chengzihe','1160','996');
INSERT INTO job_provinceandcity VALUES('1997','ε','Didao','1160','997');
INSERT INTO job_provinceandcity VALUES('1998','','Lishu','1160','998');
INSERT INTO job_provinceandcity VALUES('1999','ɽ','Mashan','1160','999');
INSERT INTO job_provinceandcity VALUES('2000','ɽ','Mishan','1160','1000');
INSERT INTO job_provinceandcity VALUES('2001','','Hulin','1160','1001');
INSERT INTO job_provinceandcity VALUES('2002','','Jidong','1160','1002');
INSERT INTO job_provinceandcity VALUES('2003','ͼ','Saertu','1154','1003');
INSERT INTO job_provinceandcity VALUES('2004','','Honggang','1154','1004');
INSERT INTO job_provinceandcity VALUES('2005','','Longfeng','1154','1005');
INSERT INTO job_provinceandcity VALUES('2006','ú·','Ranghulu','1154','1006');
INSERT INTO job_provinceandcity VALUES('2007','ͬ','Datong','1154','1007');
INSERT INTO job_provinceandcity VALUES('2008','ֵ','Lindian','1154','1008');
INSERT INTO job_provinceandcity VALUES('2009','','Zhaozhou','1154','1009');
INSERT INTO job_provinceandcity VALUES('2010','Դ','Zhaoyuan','1154','1010');
INSERT INTO job_provinceandcity VALUES('2011','Ŷɹ','Duerbote','1154','1011');
INSERT INTO job_provinceandcity VALUES('2012','','Yichun','1150','1012');
INSERT INTO job_provinceandcity VALUES('2013','','Dailing','1150','1013');
INSERT INTO job_provinceandcity VALUES('2014','ϲ','Nancha','1150','1014');
INSERT INTO job_provinceandcity VALUES('2015','ɽ','Jinshantun','1150','1015');
INSERT INTO job_provinceandcity VALUES('2016','','Xilin','1150','1016');
INSERT INTO job_provinceandcity VALUES('2017','Ϫ','Meixi','1150','1017');
INSERT INTO job_provinceandcity VALUES('2018','','Wumahe','1150','1018');
INSERT INTO job_provinceandcity VALUES('2019','','Cuiluan','1150','1019');
INSERT INTO job_provinceandcity VALUES('2020','Ѻ','Youhao','1150','1020');
INSERT INTO job_provinceandcity VALUES('2021','ϸ','Shanganling','1150','1021');
INSERT INTO job_provinceandcity VALUES('2022','Ӫ','Wuying','1150','1022');
INSERT INTO job_provinceandcity VALUES('2023','','Hongxing','1150','1023');
INSERT INTO job_provinceandcity VALUES('2024','','Xinqing','1150','1024');
INSERT INTO job_provinceandcity VALUES('2025','','Tangwanghe','1150','1025');
INSERT INTO job_provinceandcity VALUES('2026','','Wuyiling','1150','1026');
INSERT INTO job_provinceandcity VALUES('2027','','Tieli','1150','1027');
INSERT INTO job_provinceandcity VALUES('2028','','Jiayin','1150','1028');
INSERT INTO job_provinceandcity VALUES('2029','','Aimin','1152','1029');
INSERT INTO job_provinceandcity VALUES('2030','','Dongan','1152','1030');
INSERT INTO job_provinceandcity VALUES('2031','','Yangming','1152','1031');
INSERT INTO job_provinceandcity VALUES('2032','','Xian','1152','1032');
INSERT INTO job_provinceandcity VALUES('2033','Һ','Suifenhe','1152','1033');
INSERT INTO job_provinceandcity VALUES('2034','','Ningan','1152','1034');
INSERT INTO job_provinceandcity VALUES('2035','','Hailin','1152','1035');
INSERT INTO job_provinceandcity VALUES('2036','','Muleng','1152','1036');
INSERT INTO job_provinceandcity VALUES('2037','ֿ','Linkou','1152','1037');
INSERT INTO job_provinceandcity VALUES('2038','','Dongning','1152','1038');
INSERT INTO job_provinceandcity VALUES('2039','ǰ','Qianjin','1159','1039');
INSERT INTO job_provinceandcity VALUES('2040','','Yonghong','1159','1040');
INSERT INTO job_provinceandcity VALUES('2041','','Xiangyang','1159','1041');
INSERT INTO job_provinceandcity VALUES('2042','','Dongfeng','1159','1042');
INSERT INTO job_provinceandcity VALUES('2043','','Suburb','1159','1043');
INSERT INTO job_provinceandcity VALUES('2044','ͬ','Tongjiang','1159','1044');
INSERT INTO job_provinceandcity VALUES('2045','','Fujin','1159','1045');
INSERT INTO job_provinceandcity VALUES('2046','봨','Huachuan','1159','1046');
INSERT INTO job_provinceandcity VALUES('2047','Զ','Fuyuan','1159','1047');
INSERT INTO job_provinceandcity VALUES('2048','','Huanan','1159','1048');
INSERT INTO job_provinceandcity VALUES('2049','ԭ','Tangyuan','1159','1049');
INSERT INTO job_provinceandcity VALUES('2050','ɽ','Taoshan','1153','1050');
INSERT INTO job_provinceandcity VALUES('2051','','Xinxing','1153','1051');
INSERT INTO job_provinceandcity VALUES('2052','Ӻ','Qiezihe','1153','1052');
INSERT INTO job_provinceandcity VALUES('2053','','Boli','1153','1053');
INSERT INTO job_provinceandcity VALUES('2054','','Aihui','1157','1054');
INSERT INTO job_provinceandcity VALUES('2055','','Beian','1157','1055');
INSERT INTO job_provinceandcity VALUES('2056','','Wudalianchi','1157','1056');
INSERT INTO job_provinceandcity VALUES('2057','ѷ','Xunke','1157','1057');
INSERT INTO job_provinceandcity VALUES('2058','۽','Nenjiang','1157','1058');
INSERT INTO job_provinceandcity VALUES('2059','','Sunwu','1157','1059');
INSERT INTO job_provinceandcity VALUES('2060','','Beilin','1148','1060');
INSERT INTO job_provinceandcity VALUES('2061','','Anda','1148','1061');
INSERT INTO job_provinceandcity VALUES('2062','ض','Zhaodong','1148','1062');
INSERT INTO job_provinceandcity VALUES('2063','','Hailun','1148','1063');
INSERT INTO job_provinceandcity VALUES('2064','','Suileng','1148','1064');
INSERT INTO job_provinceandcity VALUES('2065','','Lanxi','1148','1065');
INSERT INTO job_provinceandcity VALUES('2066','ˮ','Mingshui','1148','1066');
INSERT INTO job_provinceandcity VALUES('2067','','Qinggang','1148','1067');
INSERT INTO job_provinceandcity VALUES('2068','찲','Qingan','1148','1068');
INSERT INTO job_provinceandcity VALUES('2069','','Wangkui','1148','1069');
INSERT INTO job_provinceandcity VALUES('2070','','Huma','1155','1070');
INSERT INTO job_provinceandcity VALUES('2071','','Tahe','1155','1071');
INSERT INTO job_provinceandcity VALUES('2072','Į','Mohe','1155','1072');
INSERT INTO job_provinceandcity VALUES('2073','','Huimin','1246','1073');
INSERT INTO job_provinceandcity VALUES('2074','Ȫ','Yuquan','1246','1074');
INSERT INTO job_provinceandcity VALUES('2075','³','Xincheng','1246','1075');
INSERT INTO job_provinceandcity VALUES('2076','','Saihan','1246','1076');
INSERT INTO job_provinceandcity VALUES('2077','п','Tuoketuo','1246','1077');
INSERT INTO job_provinceandcity VALUES('2078','ˮ','Qingshuihe','1246','1078');
INSERT INTO job_provinceandcity VALUES('2079','䴨','Wuchuan','1246','1079');
INSERT INTO job_provinceandcity VALUES('2080','ָ','Helingeer','1246','1080');
INSERT INTO job_provinceandcity VALUES('2081','Ĭ','Tumotezuo','1246','1081');
INSERT INTO job_provinceandcity VALUES('2082','','Kundulun','1241','1082');
INSERT INTO job_provinceandcity VALUES('2083','ɽ','Qingshan','1241','1083');
INSERT INTO job_provinceandcity VALUES('2084','','Donghe','1241','1084');
INSERT INTO job_provinceandcity VALUES('2085','ԭ','Jiuyuan','1241','1085');
INSERT INTO job_provinceandcity VALUES('2086','ʯ','Shiguai','1241','1086');
INSERT INTO job_provinceandcity VALUES('2087','ƿ','Baiyun Mining Area','1241','1087');
INSERT INTO job_provinceandcity VALUES('2088','','Guyang','1241','1088');
INSERT INTO job_provinceandcity VALUES('2089','Ĭ','Tumoteyou','1241','1089');
INSERT INTO job_provinceandcity VALUES('2090','ï','Daerhan','1241','1090');
INSERT INTO job_provinceandcity VALUES('2091','','Haibowan','1237','1091');
INSERT INTO job_provinceandcity VALUES('2092','ڴ','Wuda','1237','1092');
INSERT INTO job_provinceandcity VALUES('2093','','Hainan','1237','1093');
INSERT INTO job_provinceandcity VALUES('2094','ɽ','Hongshan','1243','1094');
INSERT INTO job_provinceandcity VALUES('2095','Ԫɽ','Yuanbaoshan','1243','1095');
INSERT INTO job_provinceandcity VALUES('2096','ɽ','Songshan','1243','1096');
INSERT INTO job_provinceandcity VALUES('2097','','Ningcheng','1243','1097');
INSERT INTO job_provinceandcity VALUES('2098','','Linxi','1243','1098');
INSERT INTO job_provinceandcity VALUES('2099','','Kalaqin','1243','1099');
INSERT INTO job_provinceandcity VALUES('2100','','Balinzuo','1243','1100');
INSERT INTO job_provinceandcity VALUES('2101','','Aohan','1243','1101');
INSERT INTO job_provinceandcity VALUES('2102','³ƶ','Alukeerqin','1243','1102');
INSERT INTO job_provinceandcity VALUES('2103','ţ','Wengniute','1243','1103');
INSERT INTO job_provinceandcity VALUES('2104','ʲ','Keshike','1243','1104');
INSERT INTO job_provinceandcity VALUES('2105','','Balinyou','1243','1105');
INSERT INTO job_provinceandcity VALUES('2106','ƶ','Keerqin','1239','1106');
INSERT INTO job_provinceandcity VALUES('2107','ֹ','Huolinguole','1239','1107');
INSERT INTO job_provinceandcity VALUES('2108','³','Kailu','1239','1108');
INSERT INTO job_provinceandcity VALUES('2109','ƶ','Keerqinzuoyizhong','1239','1109');
INSERT INTO job_provinceandcity VALUES('2110','ƶ','Keerqinzuoyihou','1239','1110');
INSERT INTO job_provinceandcity VALUES('2111','','Kulun','1239','1111');
INSERT INTO job_provinceandcity VALUES('2112','','Naiman','1239','1112');
INSERT INTO job_provinceandcity VALUES('2113','³','Zhalute','1239','1113');
INSERT INTO job_provinceandcity VALUES('2114','ʤ','Dongsheng','1244','1114');
INSERT INTO job_provinceandcity VALUES('2115','׼','Zhunger','1244','1115');
INSERT INTO job_provinceandcity VALUES('2116','','Wushen','1244','1116');
INSERT INTO job_provinceandcity VALUES('2117','','Yijinhuoluo','1244','1117');
INSERT INTO job_provinceandcity VALUES('2118','п','Etuoke','1244','1118');
INSERT INTO job_provinceandcity VALUES('2119','пǰ','Etuokeqian','1244','1119');
INSERT INTO job_provinceandcity VALUES('2120','','Hangjin','1244','1120');
INSERT INTO job_provinceandcity VALUES('2121','','Dalate','1244','1121');
INSERT INTO job_provinceandcity VALUES('2122','','Hailaer','1245','1122');
INSERT INTO job_provinceandcity VALUES('2123','','Manzhouli','1245','1123');
INSERT INTO job_provinceandcity VALUES('2124','ʯ','Yakeshi','1245','1124');
INSERT INTO job_provinceandcity VALUES('2125','','Zhalantun','1245','1125');
INSERT INTO job_provinceandcity VALUES('2126','','Genhe','1245','1126');
INSERT INTO job_provinceandcity VALUES('2127','','Eerguna','1245','1127');
INSERT INTO job_provinceandcity VALUES('2128','°Ͷ','Chenbaerhuqi','1245','1128');
INSERT INTO job_provinceandcity VALUES('2129','','Arong','1245','1129');
INSERT INTO job_provinceandcity VALUES('2130','°Ͷ','Xinbaerhuzuo','1245','1130');
INSERT INTO job_provinceandcity VALUES('2131','°Ͷ','Xinbaerhuyou','1245','1131');
INSERT INTO job_provinceandcity VALUES('2132','״','Elunchun','1245','1132');
INSERT INTO job_provinceandcity VALUES('2133','ĪߴӶ','Molidawadawoer','1245','1133');
INSERT INTO job_provinceandcity VALUES('2134','¿','Ewenke','1245','1134');
INSERT INTO job_provinceandcity VALUES('2135','','Fengzhen','1236','1135');
INSERT INTO job_provinceandcity VALUES('2136','','Jining','1236','1136');
INSERT INTO job_provinceandcity VALUES('2137','˺','Xinghe','1236','1137');
INSERT INTO job_provinceandcity VALUES('2138','׿','Zhuozi','1236','1138');
INSERT INTO job_provinceandcity VALUES('2139','̶','Shangdu','1236','1139');
INSERT INTO job_provinceandcity VALUES('2140','','Liangcheng','1236','1140');
INSERT INTO job_provinceandcity VALUES('2141','','Huade','1236','1141');
INSERT INTO job_provinceandcity VALUES('2142','ǰ','Chahaeryouyiqian','1236','1142');
INSERT INTO job_provinceandcity VALUES('2143','','Chahaeryouyizhong','1236','1143');
INSERT INTO job_provinceandcity VALUES('2144','','Chahaeryouyihou','1236','1144');
INSERT INTO job_provinceandcity VALUES('2145','','Siziwang','1236','1145');
INSERT INTO job_provinceandcity VALUES('2146','ֺ','Xilinhaote','1238','1146');
INSERT INTO job_provinceandcity VALUES('2147','','Erlianhaote','1238','1147');
INSERT INTO job_provinceandcity VALUES('2148','','Duolun','1238','1148');
INSERT INTO job_provinceandcity VALUES('2149','͸','Abaga','1238','1149');
INSERT INTO job_provinceandcity VALUES('2150','','Xiwuzhumuqin','1238','1150');
INSERT INTO job_provinceandcity VALUES('2151','','Dongwuzhumuqin','1238','1151');
INSERT INTO job_provinceandcity VALUES('2152','','Sunitezuo','1238','1152');
INSERT INTO job_provinceandcity VALUES('2153','','Suniteyou','1238','1153');
INSERT INTO job_provinceandcity VALUES('2154','̫','Taipusi','1238','1154');
INSERT INTO job_provinceandcity VALUES('2155','','Zhengxiangbai','1238','1155');
INSERT INTO job_provinceandcity VALUES('2156','','Zhenglan','1238','1156');
INSERT INTO job_provinceandcity VALUES('2157','','Xianghuang','1238','1157');
INSERT INTO job_provinceandcity VALUES('2158','ٺ','Linhe','1240','1158');
INSERT INTO job_provinceandcity VALUES('2159','ԭ','Wuyuan','1240','1159');
INSERT INTO job_provinceandcity VALUES('2160','','Dengkou','1240','1160');
INSERT INTO job_provinceandcity VALUES('2161','','Hangjinhou','1240','1161');
INSERT INTO job_provinceandcity VALUES('2162','','Wulatezhong','1240','1162');
INSERT INTO job_provinceandcity VALUES('2163','ǰ','Wulateqian','1240','1163');
INSERT INTO job_provinceandcity VALUES('2164','غ','Wulatehou','1240','1164');
INSERT INTO job_provinceandcity VALUES('2165','','Alashanzuo','1242','1165');
INSERT INTO job_provinceandcity VALUES('2166','','Alashanyou','1242','1166');
INSERT INTO job_provinceandcity VALUES('2167','','Ejina','1242','1167');
INSERT INTO job_provinceandcity VALUES('2168','','Wulanhaote','1235','1168');
INSERT INTO job_provinceandcity VALUES('2169','ɽ','Aershan','1235','1169');
INSERT INTO job_provinceandcity VALUES('2170','ͻȪ','Tuquan','1235','1170');
INSERT INTO job_provinceandcity VALUES('2171','','Zhalaite','1235','1171');
INSERT INTO job_provinceandcity VALUES('2172','ƶǰ','Keerqinyouyiqian','1235','1172');
INSERT INTO job_provinceandcity VALUES('2173','ƶ','Keerqinyouyizhong','1235','1173');
INSERT INTO job_provinceandcity VALUES('2174','','Xuanwu','1207','1174');
INSERT INTO job_provinceandcity VALUES('2175','¥','Gulou','1207','1175');
INSERT INTO job_provinceandcity VALUES('2176','','Jianye','1207','1176');
INSERT INTO job_provinceandcity VALUES('2177','','Baixia','1207','1177');
INSERT INTO job_provinceandcity VALUES('2178','ػ','Qinhuai','1207','1178');
INSERT INTO job_provinceandcity VALUES('2179','¹','Xiaguan','1207','1179');
INSERT INTO job_provinceandcity VALUES('2180','껨̨','Yuhuatai','1207','1180');
INSERT INTO job_provinceandcity VALUES('2181','ֿ','Pukou','1207','1181');
INSERT INTO job_provinceandcity VALUES('2182','ϼ','Qixia','1207','1182');
INSERT INTO job_provinceandcity VALUES('2183','','Dachang','1207','1183');
INSERT INTO job_provinceandcity VALUES('2184','','Jiangning','1207','1184');
INSERT INTO job_provinceandcity VALUES('2185','ˮ','Lishui','1207','1185');
INSERT INTO job_provinceandcity VALUES('2186','ߴ','Gaochun','1207','1186');
INSERT INTO job_provinceandcity VALUES('2187','','Liuhe','1207','1187');
INSERT INTO job_provinceandcity VALUES('2188','','Jiangpu','1207','1188');
INSERT INTO job_provinceandcity VALUES('2189','','Yunlong','1198','1189');
INSERT INTO job_provinceandcity VALUES('2190','¥','Gulou','1198','1190');
INSERT INTO job_provinceandcity VALUES('2191','','Jiuli','1198','1191');
INSERT INTO job_provinceandcity VALUES('2192','','Jiawang','1198','1192');
INSERT INTO job_provinceandcity VALUES('2193','','Jiawang','1198','1193');
INSERT INTO job_provinceandcity VALUES('2194','','Pizhou','1198','1194');
INSERT INTO job_provinceandcity VALUES('2195','','Xinyi','1198','1195');
INSERT INTO job_provinceandcity VALUES('2196','ͭɽ','Tongshan','1198','1196');
INSERT INTO job_provinceandcity VALUES('2197','','Suining','1198','1197');
INSERT INTO job_provinceandcity VALUES('2198','','Peixian','1198','1198');
INSERT INTO job_provinceandcity VALUES('2199','','Fengxian','1198','1199');
INSERT INTO job_provinceandcity VALUES('2200','','Xinpu','1197','1200');
INSERT INTO job_provinceandcity VALUES('2201','','Lianyun','1197','1201');
INSERT INTO job_provinceandcity VALUES('2202','','Haizhou','1197','1202');
INSERT INTO job_provinceandcity VALUES('2203','','Donghai','1197','1203');
INSERT INTO job_provinceandcity VALUES('2204','','Guanyun','1197','1204');
INSERT INTO job_provinceandcity VALUES('2205','','Ganyu','1197','1205');
INSERT INTO job_provinceandcity VALUES('2206','','Guannan','1197','1206');
INSERT INTO job_provinceandcity VALUES('2207','','Qinghe','1209','1207');
INSERT INTO job_provinceandcity VALUES('2208','','Qingpu','1209','1208');
INSERT INTO job_provinceandcity VALUES('2209','','Chuzhou','1209','1209');
INSERT INTO job_provinceandcity VALUES('2210','','Huaiyin','1209','1210');
INSERT INTO job_provinceandcity VALUES('2211','ˮ','Lianshui','1209','1211');
INSERT INTO job_provinceandcity VALUES('2212','','Hongze','1209','1212');
INSERT INTO job_provinceandcity VALUES('2213','','Jinhu','1209','1213');
INSERT INTO job_provinceandcity VALUES('2214','','Xuyi','1209','1214');
INSERT INTO job_provinceandcity VALUES('2215','޳','Sucheng','1200','1215');
INSERT INTO job_provinceandcity VALUES('2216','ԥ','Suyu','1200','1216');
INSERT INTO job_provinceandcity VALUES('2217','','Shuyang','1200','1217');
INSERT INTO job_provinceandcity VALUES('2218','','Siyang','1200','1218');
INSERT INTO job_provinceandcity VALUES('2219','','Sihong','1200','1219');
INSERT INTO job_provinceandcity VALUES('2220','','Urban Area','1204','1220');
INSERT INTO job_provinceandcity VALUES('2221','̨','Dongtai','1204','1221');
INSERT INTO job_provinceandcity VALUES('2222','','Dafeng','1204','1222');
INSERT INTO job_provinceandcity VALUES('2223','ζ','Yandu','1204','1223');
INSERT INTO job_provinceandcity VALUES('2224','','Jianhu','1204','1224');
INSERT INTO job_provinceandcity VALUES('2225','ˮ','Xiangshui','1204','1225');
INSERT INTO job_provinceandcity VALUES('2226','','Funing','1204','1226');
INSERT INTO job_provinceandcity VALUES('2227','','Sheyang','1204','1227');
INSERT INTO job_provinceandcity VALUES('2228','','Binhai','1204','1228');
INSERT INTO job_provinceandcity VALUES('2229','','Guangling','1203','1229');
INSERT INTO job_provinceandcity VALUES('2230','ά','Weiyang','1203','1230');
INSERT INTO job_provinceandcity VALUES('2231','','Hanjiang','1203','1231');
INSERT INTO job_provinceandcity VALUES('2232','','Gaoyou','1203','1232');
INSERT INTO job_provinceandcity VALUES('2233','','Jiangdu','1203','1233');
INSERT INTO job_provinceandcity VALUES('2234','','Yizheng','1203','1234');
INSERT INTO job_provinceandcity VALUES('2235','Ӧ','Baoying','1203','1235');
INSERT INTO job_provinceandcity VALUES('2236','','Hailing','1201','1236');
INSERT INTO job_provinceandcity VALUES('2237','߸','Gaogang','1201','1237');
INSERT INTO job_provinceandcity VALUES('2238','̩','Taixing','1201','1238');
INSERT INTO job_provinceandcity VALUES('2239','','Jiangyan','1201','1239');
INSERT INTO job_provinceandcity VALUES('2240','','Jingjiang','1201','1240');
INSERT INTO job_provinceandcity VALUES('2241','˻','Xinghua','1201','1241');
INSERT INTO job_provinceandcity VALUES('2242','紨','Chongchuan','1206','1242');
INSERT INTO job_provinceandcity VALUES('2243','բ','Gangzha','1206','1243');
INSERT INTO job_provinceandcity VALUES('2244','','Rugao','1206','1244');
INSERT INTO job_provinceandcity VALUES('2245','ͨ','Tongzhou','1206','1245');
INSERT INTO job_provinceandcity VALUES('2246','','Haimen','1206','1246');
INSERT INTO job_provinceandcity VALUES('2247','','Qidong','1206','1247');
INSERT INTO job_provinceandcity VALUES('2248','','Haian','1206','1248');
INSERT INTO job_provinceandcity VALUES('2249','綫','Rudong','1206','1249');
INSERT INTO job_provinceandcity VALUES('2250','','Jingkou','1205','1250');
INSERT INTO job_provinceandcity VALUES('2251','','Runzhou','1205','1251');
INSERT INTO job_provinceandcity VALUES('2252','','Danyang','1205','1252');
INSERT INTO job_provinceandcity VALUES('2253','','Yangzhong','1205','1253');
INSERT INTO job_provinceandcity VALUES('2254','','Jurong','1205','1254');
INSERT INTO job_provinceandcity VALUES('2255','ͽ','Dantu','1205','1255');
INSERT INTO job_provinceandcity VALUES('2256','¥','Zhonglou','1208','1256');
INSERT INTO job_provinceandcity VALUES('2257','','Tianning','1208','1257');
INSERT INTO job_provinceandcity VALUES('2258','','Qishuyan','1208','1258');
INSERT INTO job_provinceandcity VALUES('2259','','Suburb','1208','1259');
INSERT INTO job_provinceandcity VALUES('2260','̳','Jintan','1208','1260');
INSERT INTO job_provinceandcity VALUES('2261','','Liyang','1208','1261');
INSERT INTO job_provinceandcity VALUES('2262','','Wujin','1208','1262');
INSERT INTO job_provinceandcity VALUES('2263','簲','Chongan','1202','1263');
INSERT INTO job_provinceandcity VALUES('2264','','Beitang','1202','1264');
INSERT INTO job_provinceandcity VALUES('2265','ϳ','Nanchang','1202','1265');
INSERT INTO job_provinceandcity VALUES('2266','ɽ','Xishan','1202','1266');
INSERT INTO job_provinceandcity VALUES('2267','ɽ','Huishan','1202','1267');
INSERT INTO job_provinceandcity VALUES('2268','','Binhu','1202','1268');
INSERT INTO job_provinceandcity VALUES('2269','','Jiangyin','1202','1269');
INSERT INTO job_provinceandcity VALUES('2270','','Yixing','1202','1270');
INSERT INTO job_provinceandcity VALUES('2271','','Canglang','1199','1271');
INSERT INTO job_provinceandcity VALUES('2272','','Jinchang','1199','1272');
INSERT INTO job_provinceandcity VALUES('2273','ƽ','Pingjiang','1199','1273');
INSERT INTO job_provinceandcity VALUES('2274','','Huqiu','1199','1274');
INSERT INTO job_provinceandcity VALUES('2275','','Wuzhong','1199','1275');
INSERT INTO job_provinceandcity VALUES('2276','','Xiangcheng','1199','1276');
INSERT INTO job_provinceandcity VALUES('2277','','Changshu','1199','1277');
INSERT INTO job_provinceandcity VALUES('2278','żҸ','Zhangjiagang','1199','1278');
INSERT INTO job_provinceandcity VALUES('2279','̫','Taicang','1199','1279');
INSERT INTO job_provinceandcity VALUES('2280','ɽ','Kunshan','1199','1280');
INSERT INTO job_provinceandcity VALUES('2281','⽭','Wujiang','1199','1281');
INSERT INTO job_provinceandcity VALUES('2282','','Gongshu','1360','1282');
INSERT INTO job_provinceandcity VALUES('2283','','Xihu','1360','1283');
INSERT INTO job_provinceandcity VALUES('2284','ϳ','Shangcheng','1360','1284');
INSERT INTO job_provinceandcity VALUES('2285','³','Xiacheng','1360','1285');
INSERT INTO job_provinceandcity VALUES('2286','','Jianggan','1360','1286');
INSERT INTO job_provinceandcity VALUES('2287','','Binjiang','1360','1287');
INSERT INTO job_provinceandcity VALUES('2288','ຼ','Yuhang','1360','1288');
INSERT INTO job_provinceandcity VALUES('2289','ɽ','Xiaoshan','1360','1289');
INSERT INTO job_provinceandcity VALUES('2290','','Jiande','1360','1290');
INSERT INTO job_provinceandcity VALUES('2291','','Fuyang','1360','1291');
INSERT INTO job_provinceandcity VALUES('2292','ٰ','Linan','1360','1292');
INSERT INTO job_provinceandcity VALUES('2293','ͩ®','Tonglu','1360','1293');
INSERT INTO job_provinceandcity VALUES('2294','','Chunan','1360','1294');
INSERT INTO job_provinceandcity VALUES('2295','','Haishu','1358','1295');
INSERT INTO job_provinceandcity VALUES('2296','','Jiangdong','1358','1296');
INSERT INTO job_provinceandcity VALUES('2297','','Jiangbei','1358','1297');
INSERT INTO job_provinceandcity VALUES('2298','','Zhenhai','1358','1298');
INSERT INTO job_provinceandcity VALUES('2299','','Beilun','1358','1299');
INSERT INTO job_provinceandcity VALUES('2300','۴','Yinzhou','1358','1300');
INSERT INTO job_provinceandcity VALUES('2301','Ҧ','Yuyao','1358','1301');
INSERT INTO job_provinceandcity VALUES('2302','Ϫ','Cixi','1358','1302');
INSERT INTO job_provinceandcity VALUES('2303','','Fenghua','1358','1303');
INSERT INTO job_provinceandcity VALUES('2304','','Ninghai','1358','1304');
INSERT INTO job_provinceandcity VALUES('2305','ɽ','Xiangshan','1358','1305');
INSERT INTO job_provinceandcity VALUES('2306','¹','Lucheng','1356','1306');
INSERT INTO job_provinceandcity VALUES('2307','','Longwan','1356','1307');
INSERT INTO job_provinceandcity VALUES('2308','걺','Ouhai','1356','1308');
INSERT INTO job_provinceandcity VALUES('2309','','Ruian','1356','1309');
INSERT INTO job_provinceandcity VALUES('2310','','Yueqing','1356','1310');
INSERT INTO job_provinceandcity VALUES('2311','','Yongjia','1356','1311');
INSERT INTO job_provinceandcity VALUES('2312','ͷ','Dongtou','1356','1312');
INSERT INTO job_provinceandcity VALUES('2313','ƽ','Pingyang','1356','1313');
INSERT INTO job_provinceandcity VALUES('2314','','Cangnan','1356','1314');
INSERT INTO job_provinceandcity VALUES('2315','ĳ','Wencheng','1356','1315');
INSERT INTO job_provinceandcity VALUES('2316','̩˳','Taishun','1356','1316');
INSERT INTO job_provinceandcity VALUES('2317','','Xiucheng','1362','1317');
INSERT INTO job_provinceandcity VALUES('2318','','Xiuzhou','1362','1318');
INSERT INTO job_provinceandcity VALUES('2319','','Haining','1362','1319');
INSERT INTO job_provinceandcity VALUES('2320','ƽ','Pinghu','1362','1320');
INSERT INTO job_provinceandcity VALUES('2321','ͩ','Tongxiang','1362','1321');
INSERT INTO job_provinceandcity VALUES('2322','','Jiashan','1362','1322');
INSERT INTO job_provinceandcity VALUES('2323','','Haiyan','1362','1323');
INSERT INTO job_provinceandcity VALUES('2324','','Wuxing','1361','1324');
INSERT INTO job_provinceandcity VALUES('2325','','Nanxun','1361','1325');
INSERT INTO job_provinceandcity VALUES('2326','','Changxing','1361','1326');
INSERT INTO job_provinceandcity VALUES('2327','','Deqing','1361','1327');
INSERT INTO job_provinceandcity VALUES('2328','','Anji','1361','1328');
INSERT INTO job_provinceandcity VALUES('2329','Խ','Yuecheng','1355','1329');
INSERT INTO job_provinceandcity VALUES('2330','','Zhuji','1355','1330');
INSERT INTO job_provinceandcity VALUES('2331','','Shangyu','1355','1331');
INSERT INTO job_provinceandcity VALUES('2332','','Shengzhou','1355','1332');
INSERT INTO job_provinceandcity VALUES('2333','','Shaoxing','1355','1333');
INSERT INTO job_provinceandcity VALUES('2334','²','Xinchang','1355','1334');
INSERT INTO job_provinceandcity VALUES('2335','ĳ','Wucheng','1363','1335');
INSERT INTO job_provinceandcity VALUES('2336','','Jindong','1363','1336');
INSERT INTO job_provinceandcity VALUES('2337','Ϫ','Lanxi','1363','1337');
INSERT INTO job_provinceandcity VALUES('2338','','Yiwu','1363','1338');
INSERT INTO job_provinceandcity VALUES('2339','','Dongyang','1363','1339');
INSERT INTO job_provinceandcity VALUES('2340','','Yongkang','1363','1340');
INSERT INTO job_provinceandcity VALUES('2341','','Wuyi','1363','1341');
INSERT INTO job_provinceandcity VALUES('2342','ֽ','Pujiang','1363','1342');
INSERT INTO job_provinceandcity VALUES('2343','Ͱ','Panan','1363','1343');
INSERT INTO job_provinceandcity VALUES('2344','³','Kecheng','1353','1344');
INSERT INTO job_provinceandcity VALUES('2345','齭','Qujiang','1353','1345');
INSERT INTO job_provinceandcity VALUES('2346','ɽ','Jiangshan','1353','1346');
INSERT INTO job_provinceandcity VALUES('2347','','Longyou','1353','1347');
INSERT INTO job_provinceandcity VALUES('2348','ɽ','Changshan','1353','1348');
INSERT INTO job_provinceandcity VALUES('2349','','Kaihua','1353','1349');
INSERT INTO job_provinceandcity VALUES('2350','','Dinghai','1359','1350');
INSERT INTO job_provinceandcity VALUES('2351','','Putuo','1359','1351');
INSERT INTO job_provinceandcity VALUES('2352','ɽ','Daishan','1359','1352');
INSERT INTO job_provinceandcity VALUES('2353','','Shengsi','1359','1353');
INSERT INTO job_provinceandcity VALUES('2354','','Jiaojiang','1357','1354');
INSERT INTO job_provinceandcity VALUES('2355','','Huangyan','1357','1355');
INSERT INTO job_provinceandcity VALUES('2356','·','Luqiao','1357','1356');
INSERT INTO job_provinceandcity VALUES('2357','ٺ','Linhai','1357','1357');
INSERT INTO job_provinceandcity VALUES('2358','','Wenling','1357','1358');
INSERT INTO job_provinceandcity VALUES('2359','','Yuhuan','1357','1359');
INSERT INTO job_provinceandcity VALUES('2360','̨','Tiantai','1357','1360');
INSERT INTO job_provinceandcity VALUES('2361','ɾ','Xianju','1357','1361');
INSERT INTO job_provinceandcity VALUES('2362','','Sanmen','1357','1362');
INSERT INTO job_provinceandcity VALUES('2363','','Liandu','1354','1363');
INSERT INTO job_provinceandcity VALUES('2364','Ȫ','Longquan','1354','1364');
INSERT INTO job_provinceandcity VALUES('2365','','Jinyun','1354','1365');
INSERT INTO job_provinceandcity VALUES('2366','','Qingtian','1354','1366');
INSERT INTO job_provinceandcity VALUES('2367','ƺ','Yunhe','1354','1367');
INSERT INTO job_provinceandcity VALUES('2368','','Suichang','1354','1368');
INSERT INTO job_provinceandcity VALUES('2369','','Songyang','1354','1369');
INSERT INTO job_provinceandcity VALUES('2370','Ԫ','Qingyuan','1354','1370');
INSERT INTO job_provinceandcity VALUES('2371','','Jingning','1354','1371');
INSERT INTO job_provinceandcity VALUES('2372','®','Luyang','1047','1372');
INSERT INTO job_provinceandcity VALUES('2373','','Yaohai','1047','1373');
INSERT INTO job_provinceandcity VALUES('2374','ɽ','Shushan','1047','1374');
INSERT INTO job_provinceandcity VALUES('2375','','Baohe','1047','1375');
INSERT INTO job_provinceandcity VALUES('2376','','Changfeng','1047','1376');
INSERT INTO job_provinceandcity VALUES('2377','ʶ','Feidong','1047','1377');
INSERT INTO job_provinceandcity VALUES('2378','','Feixi','1047','1378');
INSERT INTO job_provinceandcity VALUES('2379','','Jinghu','1039','1379');
INSERT INTO job_provinceandcity VALUES('2380','','Xinwu','1039','1380');
INSERT INTO job_provinceandcity VALUES('2381','','Matang','1039','1381');
INSERT INTO job_provinceandcity VALUES('2382','𯽭','Jiujiang','1039','1382');
INSERT INTO job_provinceandcity VALUES('2383','ߺ','Wuhu','1039','1383');
INSERT INTO job_provinceandcity VALUES('2384','','Nanling','1039','1384');
INSERT INTO job_provinceandcity VALUES('2385','','Fanchang','1039','1385');
INSERT INTO job_provinceandcity VALUES('2386','','Zhongshi','1041','1386');
INSERT INTO job_provinceandcity VALUES('2387','','Dongshi','1041','1387');
INSERT INTO job_provinceandcity VALUES('2388','','Xishi','1041','1388');
INSERT INTO job_provinceandcity VALUES('2389','','Suburb','1041','1389');
INSERT INTO job_provinceandcity VALUES('2390','Զ','Huaiyuan','1041','1390');
INSERT INTO job_provinceandcity VALUES('2391','','Guzhen','1041','1391');
INSERT INTO job_provinceandcity VALUES('2392','','Wuhe','1041','1392');
INSERT INTO job_provinceandcity VALUES('2393','','Tianjiaan','1049','1393');
INSERT INTO job_provinceandcity VALUES('2394','ͨ','Datong','1049','1394');
INSERT INTO job_provinceandcity VALUES('2395','лҼ','Xiejiaji','1049','1395');
INSERT INTO job_provinceandcity VALUES('2396','˹ɽ','Bagongshan','1049','1396');
INSERT INTO job_provinceandcity VALUES('2397','˼','Panji','1049','1397');
INSERT INTO job_provinceandcity VALUES('2398','̨','Fengtai','1049','1398');
INSERT INTO job_provinceandcity VALUES('2399','ɽ','Yushan','1034','1399');
INSERT INTO job_provinceandcity VALUES('2400','ɽ','Huashan','1034','1400');
INSERT INTO job_provinceandcity VALUES('2401','ׯ','Jinjiazhuang','1034','1401');
INSERT INTO job_provinceandcity VALUES('2402','Ϳ','Dangtu','1034','1402');
INSERT INTO job_provinceandcity VALUES('2403','ɽ','Xiangshan','1050','1403');
INSERT INTO job_provinceandcity VALUES('2404','ż','Duji','1050','1404');
INSERT INTO job_provinceandcity VALUES('2405','ɽ','Lieshan','1050','1405');
INSERT INTO job_provinceandcity VALUES('2406','Ϫ','Suixi','1050','1406');
INSERT INTO job_provinceandcity VALUES('2407','ͭɽ','Tongguanshan','1038','1407');
INSERT INTO job_provinceandcity VALUES('2408','ʨɽ','Shizishan','1038','1408');
INSERT INTO job_provinceandcity VALUES('2409','','Suburb','1038','1409');
INSERT INTO job_provinceandcity VALUES('2410','ͭ','Tongling','1038','1410');
INSERT INTO job_provinceandcity VALUES('2411','ӭ','Yingjiang','1042','1411');
INSERT INTO job_provinceandcity VALUES('2412','','Daguan','1042','1412');
INSERT INTO job_provinceandcity VALUES('2413','','Suburb','1042','1413');
INSERT INTO job_provinceandcity VALUES('2414','ͩ','Tongcheng','1042','1414');
INSERT INTO job_provinceandcity VALUES('2415','','Susong','1042','1415');
INSERT INTO job_provinceandcity VALUES('2416','','Zongyang','1042','1416');
INSERT INTO job_provinceandcity VALUES('2417','̫','Taihu','1042','1417');
INSERT INTO job_provinceandcity VALUES('2418','','Huaining','1042','1418');
INSERT INTO job_provinceandcity VALUES('2419','','Yuexi','1042','1419');
INSERT INTO job_provinceandcity VALUES('2420','','Wangjiang','1042','1420');
INSERT INTO job_provinceandcity VALUES('2421','Ǳɽ','Qianshan','1042','1421');
INSERT INTO job_provinceandcity VALUES('2422','Ϫ','Tunxi','1048','1422');
INSERT INTO job_provinceandcity VALUES('2423','ɽ','Huangshan','1048','1423');
INSERT INTO job_provinceandcity VALUES('2424','','Huizhou','1048','1424');
INSERT INTO job_provinceandcity VALUES('2425','','Xiuning','1048','1425');
INSERT INTO job_provinceandcity VALUES('2426','','Shexian','1048','1426');
INSERT INTO job_provinceandcity VALUES('2427','','Qimen','1048','1427');
INSERT INTO job_provinceandcity VALUES('2428','','Yixian','1048','1428');
INSERT INTO job_provinceandcity VALUES('2429','','Langya','1043','1429');
INSERT INTO job_provinceandcity VALUES('2430','','Nanqiao','1043','1430');
INSERT INTO job_provinceandcity VALUES('2431','쳤','Tianchang','1043','1431');
INSERT INTO job_provinceandcity VALUES('2432','','Mingguang','1043','1432');
INSERT INTO job_provinceandcity VALUES('2433','ȫ','Quanjiao','1043','1433');
INSERT INTO job_provinceandcity VALUES('2434','','Laian','1043','1434');
INSERT INTO job_provinceandcity VALUES('2435','Զ','Dingyuan','1043','1435');
INSERT INTO job_provinceandcity VALUES('2436','','Fengyang','1043','1436');
INSERT INTO job_provinceandcity VALUES('2437','ӱ','Yingzhou','1045','1437');
INSERT INTO job_provinceandcity VALUES('2438','ӱ','Yingdong','1045','1438');
INSERT INTO job_provinceandcity VALUES('2439','ӱȪ','Yingquan','1045','1439');
INSERT INTO job_provinceandcity VALUES('2440','','Jieshou','1045','1440');
INSERT INTO job_provinceandcity VALUES('2441','Ȫ','Linquan','1045','1441');
INSERT INTO job_provinceandcity VALUES('2442','ӱ','Yingshang','1045','1442');
INSERT INTO job_provinceandcity VALUES('2443','','Funan','1045','1443');
INSERT INTO job_provinceandcity VALUES('2444','̫','Taihe','1045','1444');
INSERT INTO job_provinceandcity VALUES('2445','?','Yongqiao','1037','1445');
INSERT INTO job_provinceandcity VALUES('2446','','Xianxian','1037','1446');
INSERT INTO job_provinceandcity VALUES('2447','','Sixian','1037','1447');
INSERT INTO job_provinceandcity VALUES('2448','ɽ','Dangshan','1037','1448');
INSERT INTO job_provinceandcity VALUES('2449','','Lingbi','1037','1449');
INSERT INTO job_provinceandcity VALUES('2450','ӳ','Juchao','1044','1450');
INSERT INTO job_provinceandcity VALUES('2451','ɽ','Hanshan','1044','1451');
INSERT INTO job_provinceandcity VALUES('2452','Ϊ','Wuwei','1044','1452');
INSERT INTO job_provinceandcity VALUES('2453','®','Lujiang','1044','1453');
INSERT INTO job_provinceandcity VALUES('2454','','Hexian','1044','1454');
INSERT INTO job_provinceandcity VALUES('2455','','Jinan','1035','1455');
INSERT INTO job_provinceandcity VALUES('2456','ԣ','Yuan','1035','1456');
INSERT INTO job_provinceandcity VALUES('2457','','Shouxian','1035','1457');
INSERT INTO job_provinceandcity VALUES('2458','ɽ','Huoshan','1035','1458');
INSERT INTO job_provinceandcity VALUES('2459','','Huoqiu','1035','1459');
INSERT INTO job_provinceandcity VALUES('2460','','Shucheng','1035','1460');
INSERT INTO job_provinceandcity VALUES('2461','կ','Jinzhai','1035','1461');
INSERT INTO job_provinceandcity VALUES('2462','۳','Qiaocheng','1040','1462');
INSERT INTO job_provinceandcity VALUES('2463','','Lixin','1040','1463');
INSERT INTO job_provinceandcity VALUES('2464','','Guoyang','1040','1464');
INSERT INTO job_provinceandcity VALUES('2465','ɳ','Mengcheng','1040','1465');
INSERT INTO job_provinceandcity VALUES('2466','','Xuanzhou','1036','1466');
INSERT INTO job_provinceandcity VALUES('2467','','Ningguo','1036','1467');
INSERT INTO job_provinceandcity VALUES('2468','','Guangde','1036','1468');
INSERT INTO job_provinceandcity VALUES('2469','Ϫ','Langxi','1036','1469');
INSERT INTO job_provinceandcity VALUES('2470','','Jingxian','1036','1470');
INSERT INTO job_provinceandcity VALUES('2471','캵','Jingde','1036','1471');
INSERT INTO job_provinceandcity VALUES('2472','Ϫ','Jixi','1036','1472');
INSERT INTO job_provinceandcity VALUES('2473','','Guichi','1046','1473');
INSERT INTO job_provinceandcity VALUES('2474','','Dongzhi','1046','1474');
INSERT INTO job_provinceandcity VALUES('2475','ʯ̨','Shitai','1046','1475');
INSERT INTO job_provinceandcity VALUES('2476','','Qingyang','1046','1476');
INSERT INTO job_provinceandcity VALUES('2477','¥','Gulou','1059','1477');
INSERT INTO job_provinceandcity VALUES('2478','̨','Taijiang','1059','1478');
INSERT INTO job_provinceandcity VALUES('2479','ɽ','Cangshan','1059','1479');
INSERT INTO job_provinceandcity VALUES('2480','β','Mawei','1059','1480');
INSERT INTO job_provinceandcity VALUES('2481','','Jinan','1059','1481');
INSERT INTO job_provinceandcity VALUES('2482','','Fuqing','1059','1482');
INSERT INTO job_provinceandcity VALUES('2483','','Changle','1059','1483');
INSERT INTO job_provinceandcity VALUES('2484','','Minhou','1059','1484');
INSERT INTO job_provinceandcity VALUES('2485','','Minqing','1059','1485');
INSERT INTO job_provinceandcity VALUES('2486','̩','Yongtai','1059','1486');
INSERT INTO job_provinceandcity VALUES('2487','','Lianjiang','1059','1487');
INSERT INTO job_provinceandcity VALUES('2488','Դ','Luoyuan','1059','1488');
INSERT INTO job_provinceandcity VALUES('2489','ƽ̶','Pingtan','1059','1489');
INSERT INTO job_provinceandcity VALUES('2490','','Jimei','1054','1490');
INSERT INTO job_provinceandcity VALUES('2491','','Haicang','1054','1491');
INSERT INTO job_provinceandcity VALUES('2492','˼','Siming','1054','1492');
INSERT INTO job_provinceandcity VALUES('2493','','Huli','1054','1493');
INSERT INTO job_provinceandcity VALUES('2494','ͬ','Tongan','1054','1494');
INSERT INTO job_provinceandcity VALUES('2495','谲','Xiangan','1054','1495');
INSERT INTO job_provinceandcity VALUES('2496','÷','Meilie','1052','1496');
INSERT INTO job_provinceandcity VALUES('2497','Ԫ','Sanyuan','1052','1497');
INSERT INTO job_provinceandcity VALUES('2498','','Yongan','1052','1498');
INSERT INTO job_provinceandcity VALUES('2499','Ϫ','Mingxi','1052','1499');
INSERT INTO job_provinceandcity VALUES('2500','','Jiangle','1052','1500');
INSERT INTO job_provinceandcity VALUES('2501','','Datian','1052','1501');
INSERT INTO job_provinceandcity VALUES('2502','','Ninghua','1052','1502');
INSERT INTO job_provinceandcity VALUES('2503','','Jianning','1052','1503');
INSERT INTO job_provinceandcity VALUES('2504','ɳ','Shaxian','1052','1504');
INSERT INTO job_provinceandcity VALUES('2505','Ϫ','Youxi','1052','1505');
INSERT INTO job_provinceandcity VALUES('2506','','Qingliu','1052','1506');
INSERT INTO job_provinceandcity VALUES('2507','̩','Taining','1052','1507');
INSERT INTO job_provinceandcity VALUES('2508','','Changxiang','1056','1508');
INSERT INTO job_provinceandcity VALUES('2509','','Hanjiang','1056','1509');
INSERT INTO job_provinceandcity VALUES('2510','','Licheng','1056','1510');
INSERT INTO job_provinceandcity VALUES('2511','','Xiuyu','1056','1511');
INSERT INTO job_provinceandcity VALUES('2512','','Xianyou','1056','1512');
INSERT INTO job_provinceandcity VALUES('2513','','Licheng','1053','1513');
INSERT INTO job_provinceandcity VALUES('2514','','Fengze','1053','1514');
INSERT INTO job_provinceandcity VALUES('2515','彭','Luojiang','1053','1515');
INSERT INTO job_provinceandcity VALUES('2516','Ȫ','Quangang','1053','1516');
INSERT INTO job_provinceandcity VALUES('2517','ʯʨ','Shishi','1053','1517');
INSERT INTO job_provinceandcity VALUES('2518','','Jinjiang','1053','1518');
INSERT INTO job_provinceandcity VALUES('2519','ϰ','Nanan','1053','1519');
INSERT INTO job_provinceandcity VALUES('2520','ݰ','Huian','1053','1520');
INSERT INTO job_provinceandcity VALUES('2521','','Yongchun','1053','1521');
INSERT INTO job_provinceandcity VALUES('2522','Ϫ','Anxi','1053','1522');
INSERT INTO job_provinceandcity VALUES('2523','»','Dehua','1053','1523');
INSERT INTO job_provinceandcity VALUES('2524','','Jinmen','1053','1524');
INSERT INTO job_provinceandcity VALUES('2525','ܼ','Xiangcheng','1055','1525');
INSERT INTO job_provinceandcity VALUES('2526','','Longwen','1055','1526');
INSERT INTO job_provinceandcity VALUES('2527','','Longhai','1055','1527');
INSERT INTO job_provinceandcity VALUES('2528','ƽ','Pinghe','1055','1528');
INSERT INTO job_provinceandcity VALUES('2529','Ͼ','Nanjing','1055','1529');
INSERT INTO job_provinceandcity VALUES('2530','گ','Zhaoan','1055','1530');
INSERT INTO job_provinceandcity VALUES('2531','','Zhangpu','1055','1531');
INSERT INTO job_provinceandcity VALUES('2532','','Huaan','1055','1532');
INSERT INTO job_provinceandcity VALUES('2533','ɽ','Dongshan','1055','1533');
INSERT INTO job_provinceandcity VALUES('2534','̩','Changtai','1055','1534');
INSERT INTO job_provinceandcity VALUES('2535','','Yunxiao','1055','1535');
INSERT INTO job_provinceandcity VALUES('2536','ƽ','Yanping','1057','1536');
INSERT INTO job_provinceandcity VALUES('2537','','Jianou','1057','1537');
INSERT INTO job_provinceandcity VALUES('2538','','Shaowu','1057','1538');
INSERT INTO job_provinceandcity VALUES('2539','ɽ','Wuyishan','1057','1539');
INSERT INTO job_provinceandcity VALUES('2540','','Jianyang','1057','1540');
INSERT INTO job_provinceandcity VALUES('2541','Ϫ','Songxi','1057','1541');
INSERT INTO job_provinceandcity VALUES('2542','','Guangze','1057','1542');
INSERT INTO job_provinceandcity VALUES('2543','˳','Shunchang','1057','1543');
INSERT INTO job_provinceandcity VALUES('2544','ֳ','Pucheng','1057','1544');
INSERT INTO job_provinceandcity VALUES('2545','','Zhenghe','1057','1545');
INSERT INTO job_provinceandcity VALUES('2546','','Xinluo','1051','1546');
INSERT INTO job_provinceandcity VALUES('2547','ƽ','Zhangping','1051','1547');
INSERT INTO job_provinceandcity VALUES('2548','͡','Changting','1051','1548');
INSERT INTO job_provinceandcity VALUES('2549','ƽ','Wuping','1051','1549');
INSERT INTO job_provinceandcity VALUES('2550','Ϻ','Shanghang','1051','1550');
INSERT INTO job_provinceandcity VALUES('2551','','Yongding','1051','1551');
INSERT INTO job_provinceandcity VALUES('2552','','Liancheng','1051','1552');
INSERT INTO job_provinceandcity VALUES('2553','','Jiaocheng','1058','1553');
INSERT INTO job_provinceandcity VALUES('2554','','Fuan','1058','1554');
INSERT INTO job_provinceandcity VALUES('2555','','Fuding','1058','1555');
INSERT INTO job_provinceandcity VALUES('2556','','Shouning','1058','1556');
INSERT INTO job_provinceandcity VALUES('2557','ϼ','Xiapu','1058','1557');
INSERT INTO job_provinceandcity VALUES('2558','','Zherong','1058','1558');
INSERT INTO job_provinceandcity VALUES('2559','','Pingnan','1058','1559');
INSERT INTO job_provinceandcity VALUES('2560','','Gutian','1058','1560');
INSERT INTO job_provinceandcity VALUES('2561','','Zhouning','1058','1561');
INSERT INTO job_provinceandcity VALUES('2562','','Donghu','1214','1562');
INSERT INTO job_provinceandcity VALUES('2563','','Xihu','1214','1563');
INSERT INTO job_provinceandcity VALUES('2564','','Qingyun','1214','1564');
INSERT INTO job_provinceandcity VALUES('2565','','Wanli','1214','1565');
INSERT INTO job_provinceandcity VALUES('2566','ɽ','Qingshanhu','1214','1566');
INSERT INTO job_provinceandcity VALUES('2567','½','Xinjian','1214','1567');
INSERT INTO job_provinceandcity VALUES('2568','ϲ','Nanchang','1214','1568');
INSERT INTO job_provinceandcity VALUES('2569','','Jinxian','1214','1569');
INSERT INTO job_provinceandcity VALUES('2570','','Anyi','1214','1570');
INSERT INTO job_provinceandcity VALUES('2571','ɽ','Zhushan','1220','1571');
INSERT INTO job_provinceandcity VALUES('2572','','Changjiang','1220','1572');
INSERT INTO job_provinceandcity VALUES('2573','ƽ','Leping','1220','1573');
INSERT INTO job_provinceandcity VALUES('2574','','Fuliang','1220','1574');
INSERT INTO job_provinceandcity VALUES('2575','Դ','Anyuan','1215','1575');
INSERT INTO job_provinceandcity VALUES('2576','涫','Xiangdong','1215','1576');
INSERT INTO job_provinceandcity VALUES('2577','','Lianhua','1215','1577');
INSERT INTO job_provinceandcity VALUES('2578','','Shangli','1215','1578');
INSERT INTO job_provinceandcity VALUES('2579','«Ϫ','Luxi','1215','1579');
INSERT INTO job_provinceandcity VALUES('2580','ˮ','Yushui','1210','1580');
INSERT INTO job_provinceandcity VALUES('2581','','Fenyi','1210','1581');
INSERT INTO job_provinceandcity VALUES('2582','','Xunyang','1219','1582');
INSERT INTO job_provinceandcity VALUES('2583','®ɽ','Lushan','1219','1583');
INSERT INTO job_provinceandcity VALUES('2584','','Ruichang','1219','1584');
INSERT INTO job_provinceandcity VALUES('2585','Ž','Jiujiang','1219','1585');
INSERT INTO job_provinceandcity VALUES('2586','','Xingzi','1219','1586');
INSERT INTO job_provinceandcity VALUES('2587','','Wuning','1219','1587');
INSERT INTO job_provinceandcity VALUES('2588','','Pengze','1219','1588');
INSERT INTO job_provinceandcity VALUES('2589','','Yongxiu','1219','1589');
INSERT INTO job_provinceandcity VALUES('2590','ˮ','Xiushui','1219','1590');
INSERT INTO job_provinceandcity VALUES('2591','','Hukou','1219','1591');
INSERT INTO job_provinceandcity VALUES('2592','°','Dean','1219','1592');
INSERT INTO job_provinceandcity VALUES('2593','','Duchang','1219','1593');
INSERT INTO job_provinceandcity VALUES('2594','º','Yuehu','1213','1594');
INSERT INTO job_provinceandcity VALUES('2595','Ϫ','Guixi','1213','1595');
INSERT INTO job_provinceandcity VALUES('2596','཭','Yujiang','1213','1596');
INSERT INTO job_provinceandcity VALUES('2597','¹','Zhanggong','1216','1597');
INSERT INTO job_provinceandcity VALUES('2598','','Ruijin','1216','1598');
INSERT INTO job_provinceandcity VALUES('2599','Ͽ','Nankang','1216','1599');
INSERT INTO job_provinceandcity VALUES('2600','ʯ','Shicheng','1216','1600');
INSERT INTO job_provinceandcity VALUES('2601','Զ','Anyuan','1216','1601');
INSERT INTO job_provinceandcity VALUES('2602','','Ganxian','1216','1602');
INSERT INTO job_provinceandcity VALUES('2603','','Ningdu','1216','1603');
INSERT INTO job_provinceandcity VALUES('2604','Ѱ','Xunwu','1216','1604');
INSERT INTO job_provinceandcity VALUES('2605','˹','Xingguo','1216','1605');
INSERT INTO job_provinceandcity VALUES('2606','','Dingnan','1216','1606');
INSERT INTO job_provinceandcity VALUES('2607','','Shangyou','1216','1607');
INSERT INTO job_provinceandcity VALUES('2608','ڶ','Yudu','1216','1608');
INSERT INTO job_provinceandcity VALUES('2609','','Longnan','1216','1609');
INSERT INTO job_provinceandcity VALUES('2610','','Chongyi','1216','1610');
INSERT INTO job_provinceandcity VALUES('2611','ŷ','Xinfeng','1216','1611');
INSERT INTO job_provinceandcity VALUES('2612','ȫ','Quannan','1216','1612');
INSERT INTO job_provinceandcity VALUES('2613','','Dayu','1216','1613');
INSERT INTO job_provinceandcity VALUES('2614','','Huichang','1216','1614');
INSERT INTO job_provinceandcity VALUES('2615','','Jizhou','1218','1615');
INSERT INTO job_provinceandcity VALUES('2616','ԭ','Qingyuan','1218','1616');
INSERT INTO job_provinceandcity VALUES('2617','ɽ','Jinggangshan','1218','1617');
INSERT INTO job_provinceandcity VALUES('2618','','Jian','1218','1618');
INSERT INTO job_provinceandcity VALUES('2619','','Yongfeng','1218','1619');
INSERT INTO job_provinceandcity VALUES('2620','','Yongxin','1218','1620');
INSERT INTO job_provinceandcity VALUES('2621','¸','Xingan','1218','1621');
INSERT INTO job_provinceandcity VALUES('2622','̩','Taihe','1218','1622');
INSERT INTO job_provinceandcity VALUES('2623','Ͽ','Xiajiang','1218','1623');
INSERT INTO job_provinceandcity VALUES('2624','촨','Suichuan','1218','1624');
INSERT INTO job_provinceandcity VALUES('2625','','Anfu','1218','1625');
INSERT INTO job_provinceandcity VALUES('2626','ˮ','Jishui','1218','1626');
INSERT INTO job_provinceandcity VALUES('2627','','Wanan','1218','1627');
INSERT INTO job_provinceandcity VALUES('2628','Ԭ','Yuanzhou','1212','1628');
INSERT INTO job_provinceandcity VALUES('2629','','Fengcheng','1212','1629');
INSERT INTO job_provinceandcity VALUES('2630','','Zhangshu','1212','1630');
INSERT INTO job_provinceandcity VALUES('2631','߰','Gaoan','1212','1631');
INSERT INTO job_provinceandcity VALUES('2632','ͭ','Tonggu','1212','1632');
INSERT INTO job_provinceandcity VALUES('2633','','Jingan','1212','1633');
INSERT INTO job_provinceandcity VALUES('2634','˷','Yifeng','1212','1634');
INSERT INTO job_provinceandcity VALUES('2635','','Fengxin','1212','1635');
INSERT INTO job_provinceandcity VALUES('2636','','Waizai','1212','1636');
INSERT INTO job_provinceandcity VALUES('2637','ϸ','Shanggao','1212','1637');
INSERT INTO job_provinceandcity VALUES('2638','ٴ','Linchuan','1217','1638');
INSERT INTO job_provinceandcity VALUES('2639','Ϸ','Nanfeng','1217','1639');
INSERT INTO job_provinceandcity VALUES('2640','ְ','Lean','1217','1640');
INSERT INTO job_provinceandcity VALUES('2641','Ϫ','Jinxi','1217','1641');
INSERT INTO job_provinceandcity VALUES('2642','ϳ','Nancheng','1217','1642');
INSERT INTO job_provinceandcity VALUES('2643','','Dongxiang','1217','1643');
INSERT INTO job_provinceandcity VALUES('2644','Ϫ','Zixi','1217','1644');
INSERT INTO job_provinceandcity VALUES('2645','˻','Yihuang','1217','1645');
INSERT INTO job_provinceandcity VALUES('2646','','Guangchang','1217','1646');
INSERT INTO job_provinceandcity VALUES('2647','质','Lichuan','1217','1647');
INSERT INTO job_provinceandcity VALUES('2648','','Chongren','1217','1648');
INSERT INTO job_provinceandcity VALUES('2649','','Xinzhou','1211','1649');
INSERT INTO job_provinceandcity VALUES('2650','','Dexing','1211','1650');
INSERT INTO job_provinceandcity VALUES('2651','','Shangrao','1211','1651');
INSERT INTO job_provinceandcity VALUES('2652','','Guangfeng','1211','1652');
INSERT INTO job_provinceandcity VALUES('2653','','Boyang','1211','1653');
INSERT INTO job_provinceandcity VALUES('2654','Դ','Wuyuan','1211','1654');
INSERT INTO job_provinceandcity VALUES('2655','Ǧɽ','Qianshan','1211','1655');
INSERT INTO job_provinceandcity VALUES('2656','','Yugan','1211','1656');
INSERT INTO job_provinceandcity VALUES('2657','','Hengfeng','1211','1657');
INSERT INTO job_provinceandcity VALUES('2658','߮','Yiyang','1211','1658');
INSERT INTO job_provinceandcity VALUES('2659','ɽ','Yushan','1211','1659');
INSERT INTO job_provinceandcity VALUES('2660','','Wannian','1211','1660');
INSERT INTO job_provinceandcity VALUES('2661','','Shizhong','1273','1661');
INSERT INTO job_provinceandcity VALUES('2662','','Lixia','1273','1662');
INSERT INTO job_provinceandcity VALUES('2663','','Tianqiao','1273','1663');
INSERT INTO job_provinceandcity VALUES('2664','','Huaiyin','1273','1664');
INSERT INTO job_provinceandcity VALUES('2665','','Licheng','1273','1665');
INSERT INTO job_provinceandcity VALUES('2666','','Changqing','1273','1666');
INSERT INTO job_provinceandcity VALUES('2667','','Zhangqiu','1273','1667');
INSERT INTO job_provinceandcity VALUES('2668','ƽ','Pingyin','1273','1668');
INSERT INTO job_provinceandcity VALUES('2669','','Jiyang','1273','1669');
INSERT INTO job_provinceandcity VALUES('2670','̺','Shanghe','1273','1670');
INSERT INTO job_provinceandcity VALUES('2671','','Shinan','1262','1671');
INSERT INTO job_provinceandcity VALUES('2672','б','Shibei','1262','1672');
INSERT INTO job_provinceandcity VALUES('2673','','Changyang','1262','1673');
INSERT INTO job_provinceandcity VALUES('2674','ķ','Sifang','1262','1674');
INSERT INTO job_provinceandcity VALUES('2675','','Licang','1262','1675');
INSERT INTO job_provinceandcity VALUES('2676','Ƶ','Huangdao','1262','1676');
INSERT INTO job_provinceandcity VALUES('2677','ɽ','Laoshan','1262','1677');
INSERT INTO job_provinceandcity VALUES('2678','','Jiaonan','1262','1678');
INSERT INTO job_provinceandcity VALUES('2679','','Jiaozhou','1262','1679');
INSERT INTO job_provinceandcity VALUES('2680','ƽ','Pingdu','1262','1680');
INSERT INTO job_provinceandcity VALUES('2681','','Laixi','1262','1681');
INSERT INTO job_provinceandcity VALUES('2682','ī','Jimo','1262','1682');
INSERT INTO job_provinceandcity VALUES('2683','ŵ','Zhangdian','1275','1683');
INSERT INTO job_provinceandcity VALUES('2684','','Linzi','1275','1684');
INSERT INTO job_provinceandcity VALUES('2685','ʹ','Zichuan','1275','1685');
INSERT INTO job_provinceandcity VALUES('2686','ɽ','Boshan','1275','1686');
INSERT INTO job_provinceandcity VALUES('2687','ܴ','Zhoucun','1275','1687');
INSERT INTO job_provinceandcity VALUES('2688','̨','Huaitai','1275','1688');
INSERT INTO job_provinceandcity VALUES('2689','','Gaoqing','1275','1689');
INSERT INTO job_provinceandcity VALUES('2690','Դ','Yiyuan','1275','1690');
INSERT INTO job_provinceandcity VALUES('2691','','Shizhong','1268','1691');
INSERT INTO job_provinceandcity VALUES('2692','ɽͤ','Shanting','1268','1692');
INSERT INTO job_provinceandcity VALUES('2693','ỳ','Yicheng','1268','1693');
INSERT INTO job_provinceandcity VALUES('2694','̨ׯ','Taierzhuang','1268','1694');
INSERT INTO job_provinceandcity VALUES('2695','Ѧ','Xuecheng','1268','1695');
INSERT INTO job_provinceandcity VALUES('2696','','Tengzhou','1268','1696');
INSERT INTO job_provinceandcity VALUES('2697','Ӫ','Dongying','1271','1697');
INSERT INTO job_provinceandcity VALUES('2698','ӿ','Hekou','1271','1698');
INSERT INTO job_provinceandcity VALUES('2699','','Kenli','1271','1699');
INSERT INTO job_provinceandcity VALUES('2700','','Guangrao','1271','1700');
INSERT INTO job_provinceandcity VALUES('2701','','Lijin','1271','1701');
INSERT INTO job_provinceandcity VALUES('2702','Ϋ','Weicheng','1265','1702');
INSERT INTO job_provinceandcity VALUES('2703','ͤ','Hanting','1265','1703');
INSERT INTO job_provinceandcity VALUES('2704','','Fangzi','1265','1704');
INSERT INTO job_provinceandcity VALUES('2705','','Kuiwen','1265','1705');
INSERT INTO job_provinceandcity VALUES('2706','','Qingzhou','1265','1706');
INSERT INTO job_provinceandcity VALUES('2707','','Zhucheng','1265','1707');
INSERT INTO job_provinceandcity VALUES('2708','ٹ','Shouguang','1265','1708');
INSERT INTO job_provinceandcity VALUES('2709','','Anqiu','1265','1709');
INSERT INTO job_provinceandcity VALUES('2710','','Gaomi','1265','1710');
INSERT INTO job_provinceandcity VALUES('2711','','Changyi','1265','1711');
INSERT INTO job_provinceandcity VALUES('2712','','Changle','1265','1712');
INSERT INTO job_provinceandcity VALUES('2713','','Linqu','1265','1713');
INSERT INTO job_provinceandcity VALUES('2714','֥','Zhifu','1267','1714');
INSERT INTO job_provinceandcity VALUES('2715','ɽ','Fushan','1267','1715');
INSERT INTO job_provinceandcity VALUES('2716','Ĳƽ','Mouping','1267','1716');
INSERT INTO job_provinceandcity VALUES('2717','ɽ','Laishan','1267','1717');
INSERT INTO job_provinceandcity VALUES('2718','','Longkou','1267','1718');
INSERT INTO job_provinceandcity VALUES('2719','','Laiyang','1267','1719');
INSERT INTO job_provinceandcity VALUES('2720','','Laizhou','1267','1720');
INSERT INTO job_provinceandcity VALUES('2721','Զ','Zhaoyuan','1267','1721');
INSERT INTO job_provinceandcity VALUES('2722','','Penglai','1267','1722');
INSERT INTO job_provinceandcity VALUES('2723','ϼ','Qixia','1267','1723');
INSERT INTO job_provinceandcity VALUES('2724','','Haiyang','1267','1724');
INSERT INTO job_provinceandcity VALUES('2725','','Changdao','1267','1725');
INSERT INTO job_provinceandcity VALUES('2726','','Huancui','1266','1726');
INSERT INTO job_provinceandcity VALUES('2727','ɽ','Lushan','1266','1727');
INSERT INTO job_provinceandcity VALUES('2728','ĵ','Wendeng','1266','1728');
INSERT INTO job_provinceandcity VALUES('2729','ٳ','Rongcheng','1266','1729');
INSERT INTO job_provinceandcity VALUES('2730','','Shizhong','1274','1730');
INSERT INTO job_provinceandcity VALUES('2731','γ','Rencheng','1274','1731');
INSERT INTO job_provinceandcity VALUES('2732','','Qufu','1274','1732');
INSERT INTO job_provinceandcity VALUES('2733','','Yanzhou','1274','1733');
INSERT INTO job_provinceandcity VALUES('2734','޳','Zhoucheng','1274','1734');
INSERT INTO job_provinceandcity VALUES('2735','̨','Yutai','1274','1735');
INSERT INTO job_provinceandcity VALUES('2736','','Jinxiang','1274','1736');
INSERT INTO job_provinceandcity VALUES('2737','','Jiaxiang','1274','1737');
INSERT INTO job_provinceandcity VALUES('2738','΢ɽ','Weishan','1274','1738');
INSERT INTO job_provinceandcity VALUES('2739','','Wenshang','1274','1739');
INSERT INTO job_provinceandcity VALUES('2740','ˮ','Sishui','1274','1740');
INSERT INTO job_provinceandcity VALUES('2741','ɽ','Liangshan','1274','1741');
INSERT INTO job_provinceandcity VALUES('2742','̩ɽ','Taishan','1264','1742');
INSERT INTO job_provinceandcity VALUES('2743','','Daiyue','1264','1743');
INSERT INTO job_provinceandcity VALUES('2744','̩','Xintai','1264','1744');
INSERT INTO job_provinceandcity VALUES('2745','ʳ','Feicheng','1264','1745');
INSERT INTO job_provinceandcity VALUES('2746','','Ningyang','1264','1746');
INSERT INTO job_provinceandcity VALUES('2747','ƽ','Dongping','1264','1747');
INSERT INTO job_provinceandcity VALUES('2748','','Donggang','1263','1748');
INSERT INTO job_provinceandcity VALUES('2749','','Wulian','1263','1749');
INSERT INTO job_provinceandcity VALUES('2750','','Juxian','1263','1750');
INSERT INTO job_provinceandcity VALUES('2751','','Laicheng','1261','1751');
INSERT INTO job_provinceandcity VALUES('2752','ֳ','Gangcheng','1261','1752');
INSERT INTO job_provinceandcity VALUES('2753','³','Decheng','1270','1753');
INSERT INTO job_provinceandcity VALUES('2754','','Leling','1270','1754');
INSERT INTO job_provinceandcity VALUES('2755','','Yucheng','1270','1755');
INSERT INTO job_provinceandcity VALUES('2756','','Lingxian','1270','1756');
INSERT INTO job_provinceandcity VALUES('2757','','Ningjin','1270','1757');
INSERT INTO job_provinceandcity VALUES('2758','','Jihe','1270','1758');
INSERT INTO job_provinceandcity VALUES('2759','','Wucheng','1270','1759');
INSERT INTO job_provinceandcity VALUES('2760','','Qingyun','1270','1760');
INSERT INTO job_provinceandcity VALUES('2761','ƽԭ','Pingyuan','1270','1761');
INSERT INTO job_provinceandcity VALUES('2762','Ľ','Xiajin','1270','1762');
INSERT INTO job_provinceandcity VALUES('2763','','Linyi','1270','1763');
INSERT INTO job_provinceandcity VALUES('2764','ɽ','Lanshan','1259','1764');
INSERT INTO job_provinceandcity VALUES('2765','ׯ','Luozhuang','1259','1765');
INSERT INTO job_provinceandcity VALUES('2766','Ӷ','Hedong','1259','1766');
INSERT INTO job_provinceandcity VALUES('2767','','Yinan','1259','1767');
INSERT INTO job_provinceandcity VALUES('2768','۰','Taicheng','1259','1768');
INSERT INTO job_provinceandcity VALUES('2769','ˮ','Yishui','1259','1769');
INSERT INTO job_provinceandcity VALUES('2770','ɽ','Cangshan','1259','1770');
INSERT INTO job_provinceandcity VALUES('2771','','Feixian','1259','1771');
INSERT INTO job_provinceandcity VALUES('2772','ƽ','Pingyi','1259','1772');
INSERT INTO job_provinceandcity VALUES('2773','','Junan','1259','1773');
INSERT INTO job_provinceandcity VALUES('2774','','Mengyin','1259','1774');
INSERT INTO job_provinceandcity VALUES('2775','','Linshu','1259','1775');
INSERT INTO job_provinceandcity VALUES('2776','','Dongchang','1260','1776');
INSERT INTO job_provinceandcity VALUES('2777','','Linqing','1260','1777');
INSERT INTO job_provinceandcity VALUES('2778','','Gaotang','1260','1778');
INSERT INTO job_provinceandcity VALUES('2779','','Yanggu','1260','1779');
INSERT INTO job_provinceandcity VALUES('2780','ƽ','Chiping','1260','1780');
INSERT INTO job_provinceandcity VALUES('2781','ݷ','Shenxian','1260','1781');
INSERT INTO job_provinceandcity VALUES('2782','','Donge','1260','1782');
INSERT INTO job_provinceandcity VALUES('2783','','Guanxian','1260','1783');
INSERT INTO job_provinceandcity VALUES('2784','','Bincheng','1269','1784');
INSERT INTO job_provinceandcity VALUES('2785','ƽ','Zhouping','1269','1785');
INSERT INTO job_provinceandcity VALUES('2786','մ','Zhanhua','1269','1786');
INSERT INTO job_provinceandcity VALUES('2787','','Huimin','1269','1787');
INSERT INTO job_provinceandcity VALUES('2788','','Boxing','1269','1788');
INSERT INTO job_provinceandcity VALUES('2789','','Yangxin','1269','1789');
INSERT INTO job_provinceandcity VALUES('2790','','Wudi','1269','1790');
INSERT INTO job_provinceandcity VALUES('2791','ĵ','Mudan','1272','1791');
INSERT INTO job_provinceandcity VALUES('2792','۲','Juancheng','1272','1792');
INSERT INTO job_provinceandcity VALUES('2793','','Shanxian','1272','1793');
INSERT INTO job_provinceandcity VALUES('2794','۩','Yuncheng','1272','1794');
INSERT INTO job_provinceandcity VALUES('2795','','Caoxian','1272','1795');
INSERT INTO job_provinceandcity VALUES('2796','','Dingtao','1272','1796');
INSERT INTO job_provinceandcity VALUES('2797','Ұ','Juye','1272','1797');
INSERT INTO job_provinceandcity VALUES('2798','','Dongming','1272','1798');
INSERT INTO job_provinceandcity VALUES('2799','','Chengwu','1272','1799');
INSERT INTO job_provinceandcity VALUES('2800','ԭ','Zhongyuan','1142','1800');
INSERT INTO job_provinceandcity VALUES('2801','ˮ','Jinshui','1142','1801');
INSERT INTO job_provinceandcity VALUES('2802','','Eiqi','1142','1802');
INSERT INTO job_provinceandcity VALUES('2803','ܳǻ','Quancheng','1142','1803');
INSERT INTO job_provinceandcity VALUES('2804','Ͻ','Shangjie','1142','1804');
INSERT INTO job_provinceandcity VALUES('2805','ɽ','Mangshan','1142','1805');
INSERT INTO job_provinceandcity VALUES('2806','','Gongyi','1142','1806');
INSERT INTO job_provinceandcity VALUES('2807','֣','Xinzheng','1142','1807');
INSERT INTO job_provinceandcity VALUES('2808','','Xinmi','1142','1808');
INSERT INTO job_provinceandcity VALUES('2809','Ƿ','Dengfeng','1142','1809');
INSERT INTO job_provinceandcity VALUES('2810','','Xingyang','1142','1810');
INSERT INTO job_provinceandcity VALUES('2811','Ĳ','Zhongmou','1142','1811');
INSERT INTO job_provinceandcity VALUES('2812','¥','Gulou','1146','1812');
INSERT INTO job_provinceandcity VALUES('2813','ͤ','Longting','1146','1813');
INSERT INTO job_provinceandcity VALUES('2814','˳ӻ','Shunhe','1146','1814');
INSERT INTO job_provinceandcity VALUES('2815','Ϲ','Nanguan','1146','1815');
INSERT INTO job_provinceandcity VALUES('2816','','Suburb','1146','1816');
INSERT INTO job_provinceandcity VALUES('2817','','Kaifeng','1146','1817');
INSERT INTO job_provinceandcity VALUES('2818','ξ','Weishi','1146','1818');
INSERT INTO job_provinceandcity VALUES('2819','','Lankao','1146','1819');
INSERT INTO job_provinceandcity VALUES('2820','','Qixian','1146','1820');
INSERT INTO job_provinceandcity VALUES('2821','ͨ','Tongxu','1146','1821');
INSERT INTO job_provinceandcity VALUES('2822','','Xigong','1131','1822');
INSERT INTO job_provinceandcity VALUES('2823','ϳ','Laocheng','1131','1823');
INSERT INTO job_provinceandcity VALUES('2824','','Jianxi','1131','1824');
INSERT INTO job_provinceandcity VALUES('2825','?ӻ','Chanhe','1131','1825');
INSERT INTO job_provinceandcity VALUES('2826','','Luolong','1131','1826');
INSERT INTO job_provinceandcity VALUES('2827','','Jili','1131','1827');
INSERT INTO job_provinceandcity VALUES('2828','ʦ','Yanshi','1131','1828');
INSERT INTO job_provinceandcity VALUES('2829','Ͻ','Mengjin','1131','1829');
INSERT INTO job_provinceandcity VALUES('2830','','Ruyang','1131','1830');
INSERT INTO job_provinceandcity VALUES('2831','','Yichuan','1131','1831');
INSERT INTO job_provinceandcity VALUES('2832','','Luoning','1131','1832');
INSERT INTO job_provinceandcity VALUES('2833','','Songxian','1131','1833');
INSERT INTO job_provinceandcity VALUES('2834','','Yiyang','1131','1834');
INSERT INTO job_provinceandcity VALUES('2835','°','Xinan','1131','1835');
INSERT INTO job_provinceandcity VALUES('2836','ﴨ','Luanchuan','1131','1836');
INSERT INTO job_provinceandcity VALUES('2837','»','Xinhua','1140','1837');
INSERT INTO job_provinceandcity VALUES('2838','','Weidong','1140','1838');
INSERT INTO job_provinceandcity VALUES('2839','տ','Zhanhe','1140','1839');
INSERT INTO job_provinceandcity VALUES('2840','ʯ','Shilong','1140','1840');
INSERT INTO job_provinceandcity VALUES('2841','','Ruzhou','1140','1841');
INSERT INTO job_provinceandcity VALUES('2842','','Wugang','1140','1842');
INSERT INTO job_provinceandcity VALUES('2843','','Baofeng','1140','1843');
INSERT INTO job_provinceandcity VALUES('2844','Ҷ','Yexian','1140','1844');
INSERT INTO job_provinceandcity VALUES('2845','ۣ','Jiaxian','1140','1845');
INSERT INTO job_provinceandcity VALUES('2846','³ɽ','Lushan','1140','1846');
INSERT INTO job_provinceandcity VALUES('2847','','Jiefang','1145','1847');
INSERT INTO job_provinceandcity VALUES('2848','վ','Zhongzhan','1145','1848');
INSERT INTO job_provinceandcity VALUES('2849','','Macun','1145','1849');
INSERT INTO job_provinceandcity VALUES('2850','ɽ','Shanyang','1145','1850');
INSERT INTO job_provinceandcity VALUES('2851','','Qinyang','1145','1851');
INSERT INTO job_provinceandcity VALUES('2852','','Mengzhou','1145','1852');
INSERT INTO job_provinceandcity VALUES('2853','','Xiuwu','1145','1853');
INSERT INTO job_provinceandcity VALUES('2854','','Wenxian','1145','1854');
INSERT INTO job_provinceandcity VALUES('2855','','Wuzhi','1145','1855');
INSERT INTO job_provinceandcity VALUES('2856','','Boai','1145','1856');
INSERT INTO job_provinceandcity VALUES('2857','俱','Qibin','1144','1857');
INSERT INTO job_provinceandcity VALUES('2858','ɽ','Shancheng','1144','1858');
INSERT INTO job_provinceandcity VALUES('2859','ɽ','Heshan','1144','1859');
INSERT INTO job_provinceandcity VALUES('2860','','Junxian','1144','1860');
INSERT INTO job_provinceandcity VALUES('2861','','Qixian','1144','1861');
INSERT INTO job_provinceandcity VALUES('2862','»','Xinhua','1132','1862');
INSERT INTO job_provinceandcity VALUES('2863','','Hongqi','1132','1863');
INSERT INTO job_provinceandcity VALUES('2864','վ','Beizhan','1132','1864');
INSERT INTO job_provinceandcity VALUES('2865','','Suburb','1132','1865');
INSERT INTO job_provinceandcity VALUES('2866','','Weihui','1132','1866');
INSERT INTO job_provinceandcity VALUES('2867','','Huixian','1132','1867');
INSERT INTO job_provinceandcity VALUES('2868','','Xinxiang','1132','1868');
INSERT INTO job_provinceandcity VALUES('2869','','Huojia','1132','1869');
INSERT INTO job_provinceandcity VALUES('2870','ԭ','Yuanyang','1132','1870');
INSERT INTO job_provinceandcity VALUES('2871','ԫ','Chuangyuan','1132','1871');
INSERT INTO job_provinceandcity VALUES('2872','','Fengqiu','1132','1872');
INSERT INTO job_provinceandcity VALUES('2873','ӽ','Yanjin','1132','1873');
INSERT INTO job_provinceandcity VALUES('2874','','Beiguan','1143','1874');
INSERT INTO job_provinceandcity VALUES('2875','ķ','Wenfeng','1143','1875');
INSERT INTO job_provinceandcity VALUES('2876','','Yindu','1143','1876');
INSERT INTO job_provinceandcity VALUES('2877','','Longan','1143','1877');
INSERT INTO job_provinceandcity VALUES('2878','','Linzhou','1143','1878');
INSERT INTO job_provinceandcity VALUES('2879','','Anyang','1143','1879');
INSERT INTO job_provinceandcity VALUES('2880','','Huaxian','1143','1880');
INSERT INTO job_provinceandcity VALUES('2881','ڻ','Neihuang','1143','1881');
INSERT INTO job_provinceandcity VALUES('2882','','Tangyin','1143','1882');
INSERT INTO job_provinceandcity VALUES('2883','','Hualong','1137','1883');
INSERT INTO job_provinceandcity VALUES('2884','','Puyang','1137','1884');
INSERT INTO job_provinceandcity VALUES('2885','','Nanle','1137','1885');
INSERT INTO job_provinceandcity VALUES('2886','̨ǰ','Taiqian','1137','1886');
INSERT INTO job_provinceandcity VALUES('2887','','Qingfeng','1137','1887');
INSERT INTO job_provinceandcity VALUES('2888','','Fanxian','1137','1888');
INSERT INTO job_provinceandcity VALUES('2889','κ','Weidu','1133','1889');
INSERT INTO job_provinceandcity VALUES('2890','','Yuzhou','1133','1890');
INSERT INTO job_provinceandcity VALUES('2891','','Changge','1133','1891');
INSERT INTO job_provinceandcity VALUES('2892','','Xuchang','1133','1892');
INSERT INTO job_provinceandcity VALUES('2893','۳','Yanling','1133','1893');
INSERT INTO job_provinceandcity VALUES('2894','','Xiangcheng','1133','1894');
INSERT INTO job_provinceandcity VALUES('2895','Դ','Yuanhui','1138','1895');
INSERT INTO job_provinceandcity VALUES('2896','۱','Yancheng','1138','1896');
INSERT INTO job_provinceandcity VALUES('2897','','Linying','1138','1897');
INSERT INTO job_provinceandcity VALUES('2898','','Wuyang','1138','1898');
INSERT INTO job_provinceandcity VALUES('2899','','Hubin','1136','1899');
INSERT INTO job_provinceandcity VALUES('2900','','Yima','1136','1900');
INSERT INTO job_provinceandcity VALUES('2901','鱦','Lingbao','1136','1901');
INSERT INTO job_provinceandcity VALUES('2902','ų','Mianchi','1136','1902');
INSERT INTO job_provinceandcity VALUES('2903','¬','Lushi','1136','1903');
INSERT INTO job_provinceandcity VALUES('2904','','Shanxian','1136','1904');
INSERT INTO job_provinceandcity VALUES('2905','','Wolong','1139','1905');
INSERT INTO job_provinceandcity VALUES('2906','','Wancheng','1139','1906');
INSERT INTO job_provinceandcity VALUES('2907','','Dengzhou','1139','1907');
INSERT INTO job_provinceandcity VALUES('2908','ͩ','Tongbai','1139','1908');
INSERT INTO job_provinceandcity VALUES('2909','','Fangcheng','1139','1909');
INSERT INTO job_provinceandcity VALUES('2910','','Xichuan','1139','1910');
INSERT INTO job_provinceandcity VALUES('2911','ƽ','Zhenping','1139','1911');
INSERT INTO job_provinceandcity VALUES('2912','ƺ','Tanghe','1139','1912');
INSERT INTO job_provinceandcity VALUES('2913','','Nanzhao','1139','1913');
INSERT INTO job_provinceandcity VALUES('2914','','Neixiang','1139','1914');
INSERT INTO job_provinceandcity VALUES('2915','Ұ','Xinye','1139','1915');
INSERT INTO job_provinceandcity VALUES('2916','','Sheqi','1139','1916');
INSERT INTO job_provinceandcity VALUES('2917','Ͽ','Xixia','1139','1917');
INSERT INTO job_provinceandcity VALUES('2918','԰','Liangyuan','1135','1918');
INSERT INTO job_provinceandcity VALUES('2919','','Suiyang','1135','1919');
INSERT INTO job_provinceandcity VALUES('2920','','Yongcheng','1135','1920');
INSERT INTO job_provinceandcity VALUES('2921','','Ningling','1135','1921');
INSERT INTO job_provinceandcity VALUES('2922','ݳ','Yucheng','1135','1922');
INSERT INTO job_provinceandcity VALUES('2923','Ȩ','Minquan','1135','1923');
INSERT INTO job_provinceandcity VALUES('2924','','Xiayi','1135','1924');
INSERT INTO job_provinceandcity VALUES('2925','ϳ','Zhecheng','1135','1925');
INSERT INTO job_provinceandcity VALUES('2926','','Suixian','1135','1926');
INSERT INTO job_provinceandcity VALUES('2927','?','Shihe','1134','1927');
INSERT INTO job_provinceandcity VALUES('2928','ƽ','Pingqiao','1134','1928');
INSERT INTO job_provinceandcity VALUES('2929','괨','Huangchuan','1134','1929');
INSERT INTO job_provinceandcity VALUES('2930','','Huaibin','1134','1930');
INSERT INTO job_provinceandcity VALUES('2931','Ϣ','Xixian','1134','1931');
INSERT INTO job_provinceandcity VALUES('2932','','Xinxian','1134','1932');
INSERT INTO job_provinceandcity VALUES('2933','̳','Shangcheng','1134','1933');
INSERT INTO job_provinceandcity VALUES('2934','ʼ','Gushi','1134','1934');
INSERT INTO job_provinceandcity VALUES('2935','ɽ','Luoshan','1134','1935');
INSERT INTO job_provinceandcity VALUES('2936','ɽ','Guangshan','1134','1936');
INSERT INTO job_provinceandcity VALUES('2937','','Chuanhui','1141','1937');
INSERT INTO job_provinceandcity VALUES('2938','','Dingcheng','1141','1938');
INSERT INTO job_provinceandcity VALUES('2939','ˮ','Shangshui','1141','1939');
INSERT INTO job_provinceandcity VALUES('2940','','Huaiyang','1141','1940');
INSERT INTO job_provinceandcity VALUES('2941','̫','Taikang','1141','1941');
INSERT INTO job_provinceandcity VALUES('2942','¹','Luyi','1141','1942');
INSERT INTO job_provinceandcity VALUES('2943','','Xihua','1141','1943');
INSERT INTO job_provinceandcity VALUES('2944','','Fugou','1141','1944');
INSERT INTO job_provinceandcity VALUES('2945','','Shenqiu','1141','1945');
INSERT INTO job_provinceandcity VALUES('2946','','Dancheng','1141','1946');
INSERT INTO job_provinceandcity VALUES('2947','','Yicheng','1147','1947');
INSERT INTO job_provinceandcity VALUES('2948','ȷɽ','Queshan','1147','1948');
INSERT INTO job_provinceandcity VALUES('2949','²','Xincai','1147','1949');
INSERT INTO job_provinceandcity VALUES('2950','ϲ','Shangcai','1147','1950');
INSERT INTO job_provinceandcity VALUES('2951','ƽ','Xiping','1147','1951');
INSERT INTO job_provinceandcity VALUES('2952','','Biyang','1147','1952');
INSERT INTO job_provinceandcity VALUES('2953','ƽ','Pingyu','1147','1953');
INSERT INTO job_provinceandcity VALUES('2954','','Runan','1147','1954');
INSERT INTO job_provinceandcity VALUES('2955','ƽ','Suiping','1147','1955');
INSERT INTO job_provinceandcity VALUES('2956','','Zhengyang','1147','1956');
INSERT INTO job_provinceandcity VALUES('2957','Դ','Jiyuan','1391','1957');
INSERT INTO job_provinceandcity VALUES('2958','','Jiangan','1166','1958');
INSERT INTO job_provinceandcity VALUES('2959','','Wuchang','1166','1959');
INSERT INTO job_provinceandcity VALUES('2960','','Jianghan','1166','1960');
INSERT INTO job_provinceandcity VALUES('2961','?','Qiaokou','1166','1961');
INSERT INTO job_provinceandcity VALUES('2962','','Hanyang','1166','1962');
INSERT INTO job_provinceandcity VALUES('2963','ɽ','Qingshan','1166','1963');
INSERT INTO job_provinceandcity VALUES('2964','ɽ','Hongshan','1166','1964');
INSERT INTO job_provinceandcity VALUES('2965','','Dongxihu','1166','1965');
INSERT INTO job_provinceandcity VALUES('2966','','Hannan','1166','1966');
INSERT INTO job_provinceandcity VALUES('2967','̵','Caidian','1166','1967');
INSERT INTO job_provinceandcity VALUES('2968','','Jiangxia','1166','1968');
INSERT INTO job_provinceandcity VALUES('2969','','Huangpi','1166','1969');
INSERT INTO job_provinceandcity VALUES('2970','','Xinzhou','1166','1970');
INSERT INTO job_provinceandcity VALUES('2971','ʯ','Huangshigang','1170','1971');
INSERT INTO job_provinceandcity VALUES('2972','ʯҤ','Shihuiyao','1170','1972');
INSERT INTO job_provinceandcity VALUES('2973','½','Xialu','1170','1973');
INSERT INTO job_provinceandcity VALUES('2974','ɽ','Tieshan','1170','1974');
INSERT INTO job_provinceandcity VALUES('2975','ұ','Daye','1170','1975');
INSERT INTO job_provinceandcity VALUES('2976','','Yangxin','1170','1976');
INSERT INTO job_provinceandcity VALUES('2977','','Xiangcheng','1165','1977');
INSERT INTO job_provinceandcity VALUES('2978','','Fancheng','1165','1978');
INSERT INTO job_provinceandcity VALUES('2979','','Xiangyang','1165','1979');
INSERT INTO job_provinceandcity VALUES('2980','Ϻӿ','Laohekou','1165','1980');
INSERT INTO job_provinceandcity VALUES('2981','','Zaoyang','1165','1981');
INSERT INTO job_provinceandcity VALUES('2982','˳','Yicheng','1165','1982');
INSERT INTO job_provinceandcity VALUES('2983','','Nanzhang','1165','1983');
INSERT INTO job_provinceandcity VALUES('2984','ȳ','Gucheng','1165','1984');
INSERT INTO job_provinceandcity VALUES('2985','','Baokang','1165','1985');
INSERT INTO job_provinceandcity VALUES('2986','','Zhangwan','1163','1986');
INSERT INTO job_provinceandcity VALUES('2987','é','Maojian','1163','1987');
INSERT INTO job_provinceandcity VALUES('2988','','Danjiangkou','1163','1988');
INSERT INTO job_provinceandcity VALUES('2989','','Yunxian','1163','1989');
INSERT INTO job_provinceandcity VALUES('2990','ɽ','Zhushan','1163','1990');
INSERT INTO job_provinceandcity VALUES('2991','','Fangxian','1163','1991');
INSERT INTO job_provinceandcity VALUES('2992','','Yunxi','1163','1992');
INSERT INTO job_provinceandcity VALUES('2993','Ϫ','Zhuxi','1163','1993');
INSERT INTO job_provinceandcity VALUES('2994','ɳ','Shashi','1173','1994');
INSERT INTO job_provinceandcity VALUES('2995','','Jingzhou','1173','1995');
INSERT INTO job_provinceandcity VALUES('2996','','Honghu','1173','1996');
INSERT INTO job_provinceandcity VALUES('2997','ʯ','Shishou','1173','1997');
INSERT INTO job_provinceandcity VALUES('2998','','Songzi','1173','1998');
INSERT INTO job_provinceandcity VALUES('2999','','Jianli','1173','1999');
INSERT INTO job_provinceandcity VALUES('3000','','Gongan','1173','2000');
INSERT INTO job_provinceandcity VALUES('3001','','Jiangling','1173','2001');
INSERT INTO job_provinceandcity VALUES('3002','','Xiling','1167','2002');
INSERT INTO job_provinceandcity VALUES('3003','Ҹ','Wujiagang','1167','2003');
INSERT INTO job_provinceandcity VALUES('3004','','Dianjun','1167','2004');
INSERT INTO job_provinceandcity VALUES('3005','?ͤ','Xiaoting','1167','2005');
INSERT INTO job_provinceandcity VALUES('3006','','Yiling','1167','2006');
INSERT INTO job_provinceandcity VALUES('3007','˶','Yidu','1167','2007');
INSERT INTO job_provinceandcity VALUES('3008','','Dangyang','1167','2008');
INSERT INTO job_provinceandcity VALUES('3009','֦','Zhijiang','1167','2009');
INSERT INTO job_provinceandcity VALUES('3010','','Zigui','1167','2010');
INSERT INTO job_provinceandcity VALUES('3011','Զ','Yuanan','1167','2011');
INSERT INTO job_provinceandcity VALUES('3012','ɽ','Xingshan','1167','2012');
INSERT INTO job_provinceandcity VALUES('3013','','Wufeng','1167','2013');
INSERT INTO job_provinceandcity VALUES('3014','','Changyang','1167','2014');
INSERT INTO job_provinceandcity VALUES('3015','','Dongbao','1172','2015');
INSERT INTO job_provinceandcity VALUES('3016','޵','Duodao','1172','2016');
INSERT INTO job_provinceandcity VALUES('3017','','Zhongxiang','1172','2017');
INSERT INTO job_provinceandcity VALUES('3018','ɽ','Jingshan','1172','2018');
INSERT INTO job_provinceandcity VALUES('3019','ɳ','Shayang','1172','2019');
INSERT INTO job_provinceandcity VALUES('3020','','Echeng','1168','2020');
INSERT INTO job_provinceandcity VALUES('3021','','Huarong','1168','2021');
INSERT INTO job_provinceandcity VALUES('3022','Ӻ','Liangzihu','1168','2022');
INSERT INTO job_provinceandcity VALUES('3023','Т','Xiaonan','1161','2023');
INSERT INTO job_provinceandcity VALUES('3024','Ӧ','Yingcheng','1161','2024');
INSERT INTO job_provinceandcity VALUES('3025','½','Anlu','1161','2025');
INSERT INTO job_provinceandcity VALUES('3026','','Hanchuan','1161','2026');
INSERT INTO job_provinceandcity VALUES('3027','','Yunmeng','1161','2027');
INSERT INTO job_provinceandcity VALUES('3028','','Dawu','1161','2028');
INSERT INTO job_provinceandcity VALUES('3029','Т','Xiaochang','1161','2029');
INSERT INTO job_provinceandcity VALUES('3030','','Huangzhou','1171','2030');
INSERT INTO job_provinceandcity VALUES('3031','','Macheng','1171','2031');
INSERT INTO job_provinceandcity VALUES('3032','Ѩ','Wuxue','1171','2032');
INSERT INTO job_provinceandcity VALUES('3033','찲','Hongan','1171','2033');
INSERT INTO job_provinceandcity VALUES('3034','','Luotian','1171','2034');
INSERT INTO job_provinceandcity VALUES('3035','ˮ','Xishui','1171','2035');
INSERT INTO job_provinceandcity VALUES('3036','ޭ','Qichun','1171','2036');
INSERT INTO job_provinceandcity VALUES('3037','÷','Huangmei','1171','2037');
INSERT INTO job_provinceandcity VALUES('3038','Ӣɽ','Yingshan','1171','2038');
INSERT INTO job_provinceandcity VALUES('3039','ŷ','Tuofeng','1171','2039');
INSERT INTO job_provinceandcity VALUES('3040','̰','Xianan','1164','2040');
INSERT INTO job_provinceandcity VALUES('3041','','Chibi','1164','2041');
INSERT INTO job_provinceandcity VALUES('3042','','Jiayu','1164','2042');
INSERT INTO job_provinceandcity VALUES('3043','ͨɽ','Tongshan','1164','2043');
INSERT INTO job_provinceandcity VALUES('3044','','Chongyang','1164','2044');
INSERT INTO job_provinceandcity VALUES('3045','ͨ','Tongcheng','1164','2045');
INSERT INTO job_provinceandcity VALUES('3046','','Zengdu','1162','2046');
INSERT INTO job_provinceandcity VALUES('3047','ˮ','Guangshui','1162','2047');
INSERT INTO job_provinceandcity VALUES('3048','','Xiantao','1395','2048');
INSERT INTO job_provinceandcity VALUES('3049','','Tianmen','1394','2049');
INSERT INTO job_provinceandcity VALUES('3050','Ǳ','Qianjiang','1392','2050');
INSERT INTO job_provinceandcity VALUES('3051','ũ','Shennongjia','1393','2051');
INSERT INTO job_provinceandcity VALUES('3052','ʩ','Shien','1169','2052');
INSERT INTO job_provinceandcity VALUES('3053','','Lichuan','1169','2053');
INSERT INTO job_provinceandcity VALUES('3054','ʼ','Jianshi','1169','2054');
INSERT INTO job_provinceandcity VALUES('3055','','Laifeng','1169','2055');
INSERT INTO job_provinceandcity VALUES('3056','Ͷ','Badong','1169','2056');
INSERT INTO job_provinceandcity VALUES('3057','׷','Hefeng','1169','2057');
INSERT INTO job_provinceandcity VALUES('3058','','Xuanen','1169','2058');
INSERT INTO job_provinceandcity VALUES('3059','̷','Xianfeng','1169','2059');
INSERT INTO job_provinceandcity VALUES('3060','´','Yuelu','1184','2060');
INSERT INTO job_provinceandcity VALUES('3061','ܽ','Furong','1184','2061');
INSERT INTO job_provinceandcity VALUES('3062','','Tianxin','1184','2062');
INSERT INTO job_provinceandcity VALUES('3063','','Kaifu','1184','2063');
INSERT INTO job_provinceandcity VALUES('3064','껨','Yuhua','1184','2064');
INSERT INTO job_provinceandcity VALUES('3065','','Liuyang','1184','2065');
INSERT INTO job_provinceandcity VALUES('3066','ɳ','Changsha','1184','2066');
INSERT INTO job_provinceandcity VALUES('3067','','Wangcheng','1184','2067');
INSERT INTO job_provinceandcity VALUES('3068','','Ningxiang','1184','2068');
INSERT INTO job_provinceandcity VALUES('3069','Ԫ','Tianyuan','1182','2069');
INSERT INTO job_provinceandcity VALUES('3070','','Hetang','1182','2070');
INSERT INTO job_provinceandcity VALUES('3071','«','Lusong','1182','2071');
INSERT INTO job_provinceandcity VALUES('3072','ʯ','Shifeng','1182','2072');
INSERT INTO job_provinceandcity VALUES('3073','','Liling','1182','2073');
INSERT INTO job_provinceandcity VALUES('3074','','Zhuzhou','1182','2074');
INSERT INTO job_provinceandcity VALUES('3075','','Yanling','1182','2075');
INSERT INTO job_provinceandcity VALUES('3076','','Chaling','1182','2076');
INSERT INTO job_provinceandcity VALUES('3077','','Youxian','1182','2077');
INSERT INTO job_provinceandcity VALUES('3078','','Yuhu','1176','2078');
INSERT INTO job_provinceandcity VALUES('3079','','Yuetang','1176','2079');
INSERT INTO job_provinceandcity VALUES('3080','','Xiangxiang','1176','2080');
INSERT INTO job_provinceandcity VALUES('3081','ɽ','Shaoshan','1176','2081');
INSERT INTO job_provinceandcity VALUES('3082','̶','Xiangtan','1176','2082');
INSERT INTO job_provinceandcity VALUES('3083','ʯ','Shigu','1186','2083');
INSERT INTO job_provinceandcity VALUES('3084','','Yanfeng','1186','2084');
INSERT INTO job_provinceandcity VALUES('3085','','Zhuhui','1186','2085');
INSERT INTO job_provinceandcity VALUES('3086','','Zhengxiang','1186','2086');
INSERT INTO job_provinceandcity VALUES('3087','','Nanyue','1186','2087');
INSERT INTO job_provinceandcity VALUES('3088','','Leiyang','1186','2088');
INSERT INTO job_provinceandcity VALUES('3089','','Changning','1186','2089');
INSERT INTO job_provinceandcity VALUES('3090','','Hengyang','1186','2090');
INSERT INTO job_provinceandcity VALUES('3091','ⶫ','Hengdong','1186','2091');
INSERT INTO job_provinceandcity VALUES('3092','ɽ','Hengshan','1186','2092');
INSERT INTO job_provinceandcity VALUES('3093','','Hengnan','1186','2093');
INSERT INTO job_provinceandcity VALUES('3094','','Qidong','1186','2094');
INSERT INTO job_provinceandcity VALUES('3095','˫','Shuangqing','1175','2095');
INSERT INTO job_provinceandcity VALUES('3096','','Daxiang','1175','2096');
INSERT INTO job_provinceandcity VALUES('3097','','Beita','1175','2097');
INSERT INTO job_provinceandcity VALUES('3098','','Wugang','1175','2098');
INSERT INTO job_provinceandcity VALUES('3099','۶','Shaodong','1175','2099');
INSERT INTO job_provinceandcity VALUES('3100','','Dongkou','1175','2100');
INSERT INTO job_provinceandcity VALUES('3101','','Xinshao','1175','2101');
INSERT INTO job_provinceandcity VALUES('3102','','Suining','1175','2102');
INSERT INTO job_provinceandcity VALUES('3103','','Xinning','1175','2103');
INSERT INTO job_provinceandcity VALUES('3104','','Shaoyang','1175','2104');
INSERT INTO job_provinceandcity VALUES('3105','¡','Longhui','1175','2105');
INSERT INTO job_provinceandcity VALUES('3106','ǲ','Chengbu','1175','2106');
INSERT INTO job_provinceandcity VALUES('3107','¥','Yueyanglou','1178','2107');
INSERT INTO job_provinceandcity VALUES('3108','ɽ','Junshan','1178','2108');
INSERT INTO job_provinceandcity VALUES('3109','Ϫ','Yunxi','1178','2109');
INSERT INTO job_provinceandcity VALUES('3110','','Linxiang','1178','2110');
INSERT INTO job_provinceandcity VALUES('3111','','Miluo','1178','2111');
INSERT INTO job_provinceandcity VALUES('3112','','Yueyang','1178','2112');
INSERT INTO job_provinceandcity VALUES('3113','','Xiangyin','1178','2113');
INSERT INTO job_provinceandcity VALUES('3114','ƽ','Pingjiang','1178','2114');
INSERT INTO job_provinceandcity VALUES('3115','','Huarong','1178','2115');
INSERT INTO job_provinceandcity VALUES('3116','','Wuling','1183','2116');
INSERT INTO job_provinceandcity VALUES('3117','','Dingcheng','1183','2117');
INSERT INTO job_provinceandcity VALUES('3118','','Jinshi','1183','2118');
INSERT INTO job_provinceandcity VALUES('3119','','Lixian','1183','2119');
INSERT INTO job_provinceandcity VALUES('3120','','Linli','1183','2120');
INSERT INTO job_provinceandcity VALUES('3121','Դ','Taoyuan','1183','2121');
INSERT INTO job_provinceandcity VALUES('3122','','Hanshou','1183','2122');
INSERT INTO job_provinceandcity VALUES('3123','','Anxiang','1183','2123');
INSERT INTO job_provinceandcity VALUES('3124','ʯ','Shimen','1183','2124');
INSERT INTO job_provinceandcity VALUES('3125','','Yongding','1180','2125');
INSERT INTO job_provinceandcity VALUES('3126','Դ','Wulingyuan','1180','2126');
INSERT INTO job_provinceandcity VALUES('3127','','Cili','1180','2127');
INSERT INTO job_provinceandcity VALUES('3128','ɣֲ','Sangzhi','1180','2128');
INSERT INTO job_provinceandcity VALUES('3129','ɽ','Heshan','1181','2129');
INSERT INTO job_provinceandcity VALUES('3130','','Ziyang','1181','2130');
INSERT INTO job_provinceandcity VALUES('3131','佭','Yuanjiang','1181','2131');
INSERT INTO job_provinceandcity VALUES('3132','ҽ','Taojiang','1181','2132');
INSERT INTO job_provinceandcity VALUES('3133','','Nanxian','1181','2133');
INSERT INTO job_provinceandcity VALUES('3134','','Anhua','1181','2134');
INSERT INTO job_provinceandcity VALUES('3135','','Beihu','1185','2135');
INSERT INTO job_provinceandcity VALUES('3136','','Suxian','1185','2136');
INSERT INTO job_provinceandcity VALUES('3137','','Zixing','1185','2137');
INSERT INTO job_provinceandcity VALUES('3138','','Yizhang','1185','2138');
INSERT INTO job_provinceandcity VALUES('3139','','Rucheng','1185','2139');
INSERT INTO job_provinceandcity VALUES('3140','','Anren','1185','2140');
INSERT INTO job_provinceandcity VALUES('3141','κ','Jiahe','1185','2141');
INSERT INTO job_provinceandcity VALUES('3142','','Linwu','1185','2142');
INSERT INTO job_provinceandcity VALUES('3143','','Guidong','1185','2143');
INSERT INTO job_provinceandcity VALUES('3144','','Yongxing','1185','2144');
INSERT INTO job_provinceandcity VALUES('3145','','Guiyang','1185','2145');
INSERT INTO job_provinceandcity VALUES('3146','ˮ̲','Lengshuitan','1179','2146');
INSERT INTO job_provinceandcity VALUES('3147','֥ɽ','Zhishan','1179','2147');
INSERT INTO job_provinceandcity VALUES('3148','','Qiyang','1179','2148');
INSERT INTO job_provinceandcity VALUES('3149','ɽ','Lanshan','1179','2149');
INSERT INTO job_provinceandcity VALUES('3150','Զ','Ningyuan','1179','2150');
INSERT INTO job_provinceandcity VALUES('3151','','Xintian','1179','2151');
INSERT INTO job_provinceandcity VALUES('3152','','Dongan','1179','2152');
INSERT INTO job_provinceandcity VALUES('3153','','Jiangyong','1179','2153');
INSERT INTO job_provinceandcity VALUES('3154','','Daoxian','1179','2154');
INSERT INTO job_provinceandcity VALUES('3155','˫','Shuangpai','1179','2155');
INSERT INTO job_provinceandcity VALUES('3156','','Jianghua','1179','2156');
INSERT INTO job_provinceandcity VALUES('3157','׳','Hecheng','1187','2157');
INSERT INTO job_provinceandcity VALUES('3158','齭','Hongjiang','1187','2158');
INSERT INTO job_provinceandcity VALUES('3159','ͬ','Huitong','1187','2159');
INSERT INTO job_provinceandcity VALUES('3160','','Yuanling','1187','2160');
INSERT INTO job_provinceandcity VALUES('3161','Ϫ','Chenxi','1187','2161');
INSERT INTO job_provinceandcity VALUES('3162','','Xupu','1187','2162');
INSERT INTO job_provinceandcity VALUES('3163','з','Zhongfang','1187','2163');
INSERT INTO job_provinceandcity VALUES('3164','»ζ','Xinhuang','1187','2164');
INSERT INTO job_provinceandcity VALUES('3165','ƽ','Zhijiang','1187','2165');
INSERT INTO job_provinceandcity VALUES('3166','ͨ','Tongdao','1187','2166');
INSERT INTO job_provinceandcity VALUES('3167','嶱','Jingzhou','1187','2167');
INSERT INTO job_provinceandcity VALUES('3168','','Mayang','1187','2168');
INSERT INTO job_provinceandcity VALUES('3169','¦','Louxing','1174','2169');
INSERT INTO job_provinceandcity VALUES('3170','ˮ','Lengshuijiang','1174','2170');
INSERT INTO job_provinceandcity VALUES('3171','Դ','Lianyuan','1174','2171');
INSERT INTO job_provinceandcity VALUES('3172','»','Xinhua','1174','2172');
INSERT INTO job_provinceandcity VALUES('3173','˫','Shuangfeng','1174','2173');
INSERT INTO job_provinceandcity VALUES('3174','','Jishou','1177','2174');
INSERT INTO job_provinceandcity VALUES('3175','','Guzhang','1177','2175');
INSERT INTO job_provinceandcity VALUES('3176','ɽ','Longshan','1177','2176');
INSERT INTO job_provinceandcity VALUES('3177','˳','Yongshun','1177','2177');
INSERT INTO job_provinceandcity VALUES('3178','','Fenghuang','1177','2178');
INSERT INTO job_provinceandcity VALUES('3179','Ϫ','Luxi','1177','2179');
INSERT INTO job_provinceandcity VALUES('3180','','Baojing','1177','2180');
INSERT INTO job_provinceandcity VALUES('3181','ԫ','Huayuan','1177','2181');
INSERT INTO job_provinceandcity VALUES('3182','Խ','Yuexiu','1090','2182');
INSERT INTO job_provinceandcity VALUES('3183','ɽ','Dongshan','1090','2183');
INSERT INTO job_provinceandcity VALUES('3184','','Haizhu','1090','2184');
INSERT INTO job_provinceandcity VALUES('3185','','Liwan','1090','2185');
INSERT INTO job_provinceandcity VALUES('3186','','Tianhe','1090','2186');
INSERT INTO job_provinceandcity VALUES('3187','','Baiyun','1090','2187');
INSERT INTO job_provinceandcity VALUES('3188','','Huangpu','1090','2188');
INSERT INTO job_provinceandcity VALUES('3189','','Fangcun','1090','2189');
INSERT INTO job_provinceandcity VALUES('3190','','Huadu','1090','2190');
INSERT INTO job_provinceandcity VALUES('3191','خ','Fanyu','1090','2191');
INSERT INTO job_provinceandcity VALUES('3192','ӻ','Conghua','1090','2192');
INSERT INTO job_provinceandcity VALUES('3193','','Zengcheng','1090','2193');
INSERT INTO job_provinceandcity VALUES('3194','','Futian','1079','2194');
INSERT INTO job_provinceandcity VALUES('3195','޺','Luohu','1079','2195');
INSERT INTO job_provinceandcity VALUES('3196','ɽ','Nanshan','1079','2196');
INSERT INTO job_provinceandcity VALUES('3197','','Baoan','1079','2197');
INSERT INTO job_provinceandcity VALUES('3198','','Longgang','1079','2198');
INSERT INTO job_provinceandcity VALUES('3199','','Yantian','1079','2199');
INSERT INTO job_provinceandcity VALUES('3200','','Xiangzhou','1086','2200');
INSERT INTO job_provinceandcity VALUES('3201','','Doumen','1086','2201');
INSERT INTO job_provinceandcity VALUES('3202','','Jinwan','1086','2202');
INSERT INTO job_provinceandcity VALUES('3203','','Chaoyang','1078','2203');
INSERT INTO job_provinceandcity VALUES('3204','','Chaonan','1078','2204');
INSERT INTO job_provinceandcity VALUES('3205','κ','Chenghai','1078','2205');
INSERT INTO job_provinceandcity VALUES('3206','婽','Haojiang','1078','2206');
INSERT INTO job_provinceandcity VALUES('3207','ƽ','Jinping','1078','2207');
INSERT INTO job_provinceandcity VALUES('3208','','Longhu','1078','2208');
INSERT INTO job_provinceandcity VALUES('3209','ϰ','Nanao','1078','2209');
INSERT INTO job_provinceandcity VALUES('3210','','Beijiang','1080','2210');
INSERT INTO job_provinceandcity VALUES('3211','䥽','Zhenjiang','1080','2211');
INSERT INTO job_provinceandcity VALUES('3212','佭','Wujiang','1080','2212');
INSERT INTO job_provinceandcity VALUES('3213','ֲ','Lechang','1080','2213');
INSERT INTO job_provinceandcity VALUES('3214','','Nanxiong','1080','2214');
INSERT INTO job_provinceandcity VALUES('3215','ʻ','Renhua','1080','2215');
INSERT INTO job_provinceandcity VALUES('3216','ʼ','Shixing','1080','2216');
INSERT INTO job_provinceandcity VALUES('3217','Դ','Wengyuan','1080','2217');
INSERT INTO job_provinceandcity VALUES('3218','','Qujiang','1080','2218');
INSERT INTO job_provinceandcity VALUES('3219','·','Xinfeng','1080','2219');
INSERT INTO job_provinceandcity VALUES('3220','Դ','Luyuan','1080','2220');
INSERT INTO job_provinceandcity VALUES('3221','Դ','Yuancheng','1091','2221');
INSERT INTO job_provinceandcity VALUES('3222','ƽ','Heping','1091','2222');
INSERT INTO job_provinceandcity VALUES('3223','','Longchuan','1091','2223');
INSERT INTO job_provinceandcity VALUES('3224','Ͻ','Zijin','1091','2224');
INSERT INTO job_provinceandcity VALUES('3225','ƽ','Lianping','1091','2225');
INSERT INTO job_provinceandcity VALUES('3226','Դ','Dongyuan','1091','2226');
INSERT INTO job_provinceandcity VALUES('3227','÷','Meijiang','1075','2227');
INSERT INTO job_provinceandcity VALUES('3228','','Xingning','1075','2228');
INSERT INTO job_provinceandcity VALUES('3229','÷','Meixian','1075','2229');
INSERT INTO job_provinceandcity VALUES('3230','','Jiaoling','1075','2230');
INSERT INTO job_provinceandcity VALUES('3231','','Dabu','1075','2231');
INSERT INTO job_provinceandcity VALUES('3232','˳','Fengshun','1075','2232');
INSERT INTO job_provinceandcity VALUES('3233','廪','Wuhua','1075','2233');
INSERT INTO job_provinceandcity VALUES('3234','ƽԶ','Pingyuan','1075','2234');
INSERT INTO job_provinceandcity VALUES('3235','ݳ','Huicheng','1092','2235');
INSERT INTO job_provinceandcity VALUES('3236','','Huiyang','1092','2236');
INSERT INTO job_provinceandcity VALUES('3237','ݶ','Huidong','1092','2237');
INSERT INTO job_provinceandcity VALUES('3238','','Boluo','1092','2238');
INSERT INTO job_provinceandcity VALUES('3239','','Longmen','1092','2239');
INSERT INTO job_provinceandcity VALUES('3240','','Urban Area','1077','2240');
INSERT INTO job_provinceandcity VALUES('3241','½','Lufeng','1077','2241');
INSERT INTO job_provinceandcity VALUES('3242','','Haifeng','1077','2242');
INSERT INTO job_provinceandcity VALUES('3243','½','Luhe','1077','2243');
INSERT INTO job_provinceandcity VALUES('3244','ݸ','Dongguan','1088','2244');
INSERT INTO job_provinceandcity VALUES('3245','ɽ','Zhongshan','1085','2245');
INSERT INTO job_provinceandcity VALUES('3246','','Jianghai','1094','2246');
INSERT INTO job_provinceandcity VALUES('3247','','Pengjiang','1094','2247');
INSERT INTO job_provinceandcity VALUES('3248','»','Xinhui','1094','2248');
INSERT INTO job_provinceandcity VALUES('3249','̨ɽ','Taishan','1094','2249');
INSERT INTO job_provinceandcity VALUES('3250','ƽ','Kaiping','1094','2250');
INSERT INTO job_provinceandcity VALUES('3251','ɽ','Heshan','1094','2251');
INSERT INTO job_provinceandcity VALUES('3252','ƽ','Enping','1094','2252');
INSERT INTO job_provinceandcity VALUES('3253','˳','Shunde','1089','2253');
INSERT INTO job_provinceandcity VALUES('3254','Ϻ','Nanhai','1089','2254');
INSERT INTO job_provinceandcity VALUES('3255','ˮ','Shanshui','1089','2255');
INSERT INTO job_provinceandcity VALUES('3256','','Gaoming','1089','2256');
INSERT INTO job_provinceandcity VALUES('3257','','Chancheng','1089','2257');
INSERT INTO job_provinceandcity VALUES('3258','','Jiangcheng','1081','2258');
INSERT INTO job_provinceandcity VALUES('3259','','Yangchun','1081','2259');
INSERT INTO job_provinceandcity VALUES('3260','','Yangxi','1081','2260');
INSERT INTO job_provinceandcity VALUES('3261','','Yangdong','1081','2261');
INSERT INTO job_provinceandcity VALUES('3262','࿲','Chikan','1083','2262');
INSERT INTO job_provinceandcity VALUES('3263','ϼɽ','Xiashan','1083','2263');
INSERT INTO job_provinceandcity VALUES('3264','ͷ','Potou','1083','2264');
INSERT INTO job_provinceandcity VALUES('3265','','Mazhang','1083','2265');
INSERT INTO job_provinceandcity VALUES('3266','','Lianjiang','1083','2266');
INSERT INTO job_provinceandcity VALUES('3267','','Leizhou','1083','2267');
INSERT INTO job_provinceandcity VALUES('3268','⴨','Wuchuan','1083','2268');
INSERT INTO job_provinceandcity VALUES('3269','Ϫ','Suixi','1083','2269');
INSERT INTO job_provinceandcity VALUES('3270','','Xuwen','1083','2270');
INSERT INTO job_provinceandcity VALUES('3271','ï','Maonan','1074','2271');
INSERT INTO job_provinceandcity VALUES('3272','ï','Maogang','1074','2272');
INSERT INTO job_provinceandcity VALUES('3273','','Gaozhou','1074','2273');
INSERT INTO job_provinceandcity VALUES('3274','','Huazhou','1074','2274');
INSERT INTO job_provinceandcity VALUES('3275','','Xinyi','1074','2275');
INSERT INTO job_provinceandcity VALUES('3276','','Dianbai','1074','2276');
INSERT INTO job_provinceandcity VALUES('3277','','Duanzhou','1084','2277');
INSERT INTO job_provinceandcity VALUES('3278','','Dinghu','1084','2278');
INSERT INTO job_provinceandcity VALUES('3279','Ҫ','Gaoyao','1084','2279');
INSERT INTO job_provinceandcity VALUES('3280','Ļ','Sihui','1084','2280');
INSERT INTO job_provinceandcity VALUES('3281','','Guangning','1084','2281');
INSERT INTO job_provinceandcity VALUES('3282','','Deqing','1084','2282');
INSERT INTO job_provinceandcity VALUES('3283','⿪','Fengkai','1084','2283');
INSERT INTO job_provinceandcity VALUES('3284','','Huaiji','1084','2284');
INSERT INTO job_provinceandcity VALUES('3285','','Qingcheng','1076','2285');
INSERT INTO job_provinceandcity VALUES('3286','Ӣ','Yingde','1076','2286');
INSERT INTO job_provinceandcity VALUES('3287','','Lianzhou','1076','2287');
INSERT INTO job_provinceandcity VALUES('3288','','Fogang','1076','2288');
INSERT INTO job_provinceandcity VALUES('3289','ɽ','Yangshan','1076','2289');
INSERT INTO job_provinceandcity VALUES('3290','','Qingxin','1076','2290');
INSERT INTO job_provinceandcity VALUES('3291','ɽ׳','Lianshan','1076','2291');
INSERT INTO job_provinceandcity VALUES('3292','','Liannan','1076','2292');
INSERT INTO job_provinceandcity VALUES('3293','','Xiangqiao','1087','2293');
INSERT INTO job_provinceandcity VALUES('3294','','Chaoan','1087','2294');
INSERT INTO job_provinceandcity VALUES('3295','ƽ','Raoping','1087','2295');
INSERT INTO job_provinceandcity VALUES('3296','ų','Rongcheng','1093','2296');
INSERT INTO job_provinceandcity VALUES('3297','','Puning','1093','2297');
INSERT INTO job_provinceandcity VALUES('3298','Ҷ','Jiedong','1093','2298');
INSERT INTO job_provinceandcity VALUES('3299','','Jiexi','1093','2299');
INSERT INTO job_provinceandcity VALUES('3300','','Huilai','1093','2300');
INSERT INTO job_provinceandcity VALUES('3301','Ƴ','Yuncheng','1082','2301');
INSERT INTO job_provinceandcity VALUES('3302','޶','Luoding','1082','2302');
INSERT INTO job_provinceandcity VALUES('3303','ư','Yunan','1082','2303');
INSERT INTO job_provinceandcity VALUES('3304','','Xinxing','1082','2304');
INSERT INTO job_provinceandcity VALUES('3305','','Yunan','1082','2305');
INSERT INTO job_provinceandcity VALUES('3306','ɽ','Qiongshan','1019','2306');
INSERT INTO job_provinceandcity VALUES('3307','Ӣ','Xiuying','1119','2307');
INSERT INTO job_provinceandcity VALUES('3308','','Longhua','1119','2308');
INSERT INTO job_provinceandcity VALUES('3309','ɽ','Qiongshan','1119','2309');
INSERT INTO job_provinceandcity VALUES('3310','','Meilan','1119','2310');
INSERT INTO job_provinceandcity VALUES('3311','','Sanya','1118','2311');
INSERT INTO job_provinceandcity VALUES('3312','ָɽ','Wuzhishan','1389','2312');
INSERT INTO job_provinceandcity VALUES('3313','','Qionghai','1384','2313');
INSERT INTO job_provinceandcity VALUES('3314','','Danzhou','1390','2314');
INSERT INTO job_provinceandcity VALUES('3315','ɽ','Qiongshan','3306','2315');
INSERT INTO job_provinceandcity VALUES('3316','Ĳ','Wenchang','1388','2316');
INSERT INTO job_provinceandcity VALUES('3317','','Wanning','1387','2317');
INSERT INTO job_provinceandcity VALUES('3318','','Dongfang','1380','2318');
INSERT INTO job_provinceandcity VALUES('3319','','Chengmai','1378','2319');
INSERT INTO job_provinceandcity VALUES('3320','','Anding','1379','2320');
INSERT INTO job_provinceandcity VALUES('3321','Ͳ','Tunchang','1386','2321');
INSERT INTO job_provinceandcity VALUES('3322','ٸ','Lingao','1382','2322');
INSERT INTO job_provinceandcity VALUES('3323','ɳ','Baisha','1375','2323');
INSERT INTO job_provinceandcity VALUES('3324','','Changjiang','1377','2324');
INSERT INTO job_provinceandcity VALUES('3325','ֶ','Ledong','1381','2325');
INSERT INTO job_provinceandcity VALUES('3326','ˮ','Lingshui','1383','2326');
INSERT INTO job_provinceandcity VALUES('3327','ͤ','Baoting','1376','2327');
INSERT INTO job_provinceandcity VALUES('3328','','Qiongzhong','1385','2328');
INSERT INTO job_provinceandcity VALUES('3329','³','Xincheng','1100','2329');
INSERT INTO job_provinceandcity VALUES('3330','','Xingning','1100','2330');
INSERT INTO job_provinceandcity VALUES('3331','','Yongxin','1100','2331');
INSERT INTO job_provinceandcity VALUES('3332','Ǳ','Chengbei','1100','2332');
INSERT INTO job_provinceandcity VALUES('3333','','Jiangnan','1100','2333');
INSERT INTO job_provinceandcity VALUES('3334','','Yongning','1100','2334');
INSERT INTO job_provinceandcity VALUES('3335','','Wuming','1100','2335');
INSERT INTO job_provinceandcity VALUES('3336','¡','Longan','1100','2336');
INSERT INTO job_provinceandcity VALUES('3337','ɽ','Mashan','1100','2337');
INSERT INTO job_provinceandcity VALUES('3338','','Shanglin','1100','2338');
INSERT INTO job_provinceandcity VALUES('3339','','Binyang','1100','2339');
INSERT INTO job_provinceandcity VALUES('3340','','Hengxian','1100','2340');
INSERT INTO job_provinceandcity VALUES('3341','','Chengzhong','1095','2341');
INSERT INTO job_provinceandcity VALUES('3342','','Yufeng','1095','2342');
INSERT INTO job_provinceandcity VALUES('3343','','Liubei','1095','2343');
INSERT INTO job_provinceandcity VALUES('3344','','Liunan','1095','2344');
INSERT INTO job_provinceandcity VALUES('3345','н','Suburb','1095','2345');
INSERT INTO job_provinceandcity VALUES('3346','','Liujiang','1095','2346');
INSERT INTO job_provinceandcity VALUES('3347','','Liucheng','1095','2347');
INSERT INTO job_provinceandcity VALUES('3348','ˮ','Rongshui','1095','2348');
INSERT INTO job_provinceandcity VALUES('3349','¹կ','Luzhai','1095','2349');
INSERT INTO job_provinceandcity VALUES('3350','ڰ','Rongan','1095','2350');
INSERT INTO job_provinceandcity VALUES('3351','','Sanjiang','1095','2351');
INSERT INTO job_provinceandcity VALUES('3352','','Xiufeng','1105','2352');
INSERT INTO job_provinceandcity VALUES('3353','','Diecai','1105','2353');
INSERT INTO job_provinceandcity VALUES('3354','ɽ','Xiangshan','1105','2354');
INSERT INTO job_provinceandcity VALUES('3355','','Qixing','1105','2355');
INSERT INTO job_provinceandcity VALUES('3356','ɽ','Yanshan','1105','2356');
INSERT INTO job_provinceandcity VALUES('3357','˷','Yangshuo','1105','2357');
INSERT INTO job_provinceandcity VALUES('3358','ٹ','Lingui','1105','2358');
INSERT INTO job_provinceandcity VALUES('3359','鴨','Lingchuan','1105','2359');
INSERT INTO job_provinceandcity VALUES('3360','ȫ','Quanzhou','1105','2360');
INSERT INTO job_provinceandcity VALUES('3361','ƽ','Pingle','1105','2361');
INSERT INTO job_provinceandcity VALUES('3362','˰','Xingan','1105','2362');
INSERT INTO job_provinceandcity VALUES('3363','','Guanyang','1105','2363');
INSERT INTO job_provinceandcity VALUES('3364','','Lipu','1105','2364');
INSERT INTO job_provinceandcity VALUES('3365','Դ','Ziyuan','1105','2365');
INSERT INTO job_provinceandcity VALUES('3366','','Yongfu','1105','2366');
INSERT INTO job_provinceandcity VALUES('3367','ʤ','Longsheng','1105','2367');
INSERT INTO job_provinceandcity VALUES('3368','','Gongcheng','1105','2368');
INSERT INTO job_provinceandcity VALUES('3369','','Wanxiu','1098','2369');
INSERT INTO job_provinceandcity VALUES('3370','ɽ','Dieshan','1098','2370');
INSERT INTO job_provinceandcity VALUES('3371','н','Suburb','1098','2371');
INSERT INTO job_provinceandcity VALUES('3372','Ϫ','Cenxi','1098','2372');
INSERT INTO job_provinceandcity VALUES('3373','','Cangwu','1098','2373');
INSERT INTO job_provinceandcity VALUES('3374','','Tengxian','1098','2374');
INSERT INTO job_provinceandcity VALUES('3375','ɽ','Mengshan','1098','2375');
INSERT INTO job_provinceandcity VALUES('3376','','Haicheng','1103','2376');
INSERT INTO job_provinceandcity VALUES('3377','','Yinhai','1103','2377');
INSERT INTO job_provinceandcity VALUES('3378','ɽ','Tieshangang','1103','2378');
INSERT INTO job_provinceandcity VALUES('3379','','Hepu','1103','2379');
INSERT INTO job_provinceandcity VALUES('3380','ۿ','Gangkou','1104','2380');
INSERT INTO job_provinceandcity VALUES('3381','','Fangcheng','1104','2381');
INSERT INTO job_provinceandcity VALUES('3382','','Dongxing','1104','2382');
INSERT INTO job_provinceandcity VALUES('3383','˼','Shangsi','1104','2383');
INSERT INTO job_provinceandcity VALUES('3384','','Qinnan','1097','2384');
INSERT INTO job_provinceandcity VALUES('3385','ձ','Qinbei','1097','2385');
INSERT INTO job_provinceandcity VALUES('3386','ɽ','Lingshan','1097','2386');
INSERT INTO job_provinceandcity VALUES('3387','ֱ','Pubei','1097','2387');
INSERT INTO job_provinceandcity VALUES('3388','۱','Gangbei','1106','2388');
INSERT INTO job_provinceandcity VALUES('3389','','Gangnan','1106','2389');
INSERT INTO job_provinceandcity VALUES('3390','ƽ','Guiping','1106','2390');
INSERT INTO job_provinceandcity VALUES('3391','ƽ','Pingnan','1106','2391');
INSERT INTO job_provinceandcity VALUES('3392','','Yuzhou','1099','2392');
INSERT INTO job_provinceandcity VALUES('3393','','Beiliu','1099','2393');
INSERT INTO job_provinceandcity VALUES('3394','','Rongxian','1099','2394');
INSERT INTO job_provinceandcity VALUES('3395','½','Luchuan','1099','2395');
INSERT INTO job_provinceandcity VALUES('3396','','Bobai','1099','2396');
INSERT INTO job_provinceandcity VALUES('3397','ҵ','Xingye','1099','2397');
INSERT INTO job_provinceandcity VALUES('3398','','Jiangzhou','1096','2398');
INSERT INTO job_provinceandcity VALUES('3399','','Ningming','1096','2399');
INSERT INTO job_provinceandcity VALUES('3400','','Fusui','1096','2400');
INSERT INTO job_provinceandcity VALUES('3401','','Longzhou','1096','2401');
INSERT INTO job_provinceandcity VALUES('3402','','Daxin','1096','2402');
INSERT INTO job_provinceandcity VALUES('3403','','Tiandeng','1096','2403');
INSERT INTO job_provinceandcity VALUES('3404','ƾ','Pingxiang','1396','2404');
INSERT INTO job_provinceandcity VALUES('3405','ɽ','Heshan','1101','2405');
INSERT INTO job_provinceandcity VALUES('3406','˱','Xingbin','1101','2406');
INSERT INTO job_provinceandcity VALUES('3407','','Xiangzhou','1101','2407');
INSERT INTO job_provinceandcity VALUES('3408','','Wuxuan','1101','2408');
INSERT INTO job_provinceandcity VALUES('3409','ó','Xincheng','1101','2409');
INSERT INTO job_provinceandcity VALUES('3410','','Jinxiu','1101','2410');
INSERT INTO job_provinceandcity VALUES('3411','','Hezhou','1108','2411');
INSERT INTO job_provinceandcity VALUES('3412','ɽ','Zhongshan','1108','2412');
INSERT INTO job_provinceandcity VALUES('3413','ƽ','Zhaoping','1108','2413');
INSERT INTO job_provinceandcity VALUES('3414','','Fuchuan','1108','2414');
INSERT INTO job_provinceandcity VALUES('3415','','Lingyun','1102','2415');
INSERT INTO job_provinceandcity VALUES('3416','ƽ','Pingguo','1102','2416');
INSERT INTO job_provinceandcity VALUES('3417','','Xilin','1102','2417');
INSERT INTO job_provinceandcity VALUES('3418','ҵ','Leye','1102','2418');
INSERT INTO job_provinceandcity VALUES('3419','±','Debao','1102','2419');
INSERT INTO job_provinceandcity VALUES('3420','','Tianlin','1102','2420');
INSERT INTO job_provinceandcity VALUES('3421','','Tianyang','1102','2421');
INSERT INTO job_provinceandcity VALUES('3422','','Jingxi','1102','2422');
INSERT INTO job_provinceandcity VALUES('3423','ﶫ','Tiandong','1102','2423');
INSERT INTO job_provinceandcity VALUES('3424','','Napo','1102','2424');
INSERT INTO job_provinceandcity VALUES('3425','¡ָ','Longlin','1102','2425');
INSERT INTO job_provinceandcity VALUES('3426','ӳ','Hechi','1107','2426');
INSERT INTO job_provinceandcity VALUES('3427','','Yizhou','1107','2427');
INSERT INTO job_provinceandcity VALUES('3428','','Tiane','1107','2428');
INSERT INTO job_provinceandcity VALUES('3429','ɽ','Fengshan','1107','2429');
INSERT INTO job_provinceandcity VALUES('3430','ϵ','Nandan','1107','2430');
INSERT INTO job_provinceandcity VALUES('3431','','Donglan','1107','2431');
INSERT INTO job_provinceandcity VALUES('3432','','Duan','1107','2432');
INSERT INTO job_provinceandcity VALUES('3433','޳','Luocheng','1107','2433');
INSERT INTO job_provinceandcity VALUES('3434','','Bama','1107','2434');
INSERT INTO job_provinceandcity VALUES('3435','ë','Huanjiang','1107','2435');
INSERT INTO job_provinceandcity VALUES('3436','','Dahua','1107','2436');
INSERT INTO job_provinceandcity VALUES('3437','','Qingyang','1310','2437');
INSERT INTO job_provinceandcity VALUES('3438','','Jinjiang','1310','2438');
INSERT INTO job_provinceandcity VALUES('3439','ţ','Jinniu','1310','2439');
INSERT INTO job_provinceandcity VALUES('3440','','Wuhou','1310','2440');
INSERT INTO job_provinceandcity VALUES('3441','ɻ','Chenghua','1310','2441');
INSERT INTO job_provinceandcity VALUES('3442','Ȫ','Longquanyi','1310','2442');
INSERT INTO job_provinceandcity VALUES('3443','׽','Qingbaijiang','1310','2443');
INSERT INTO job_provinceandcity VALUES('3444','¶','Xindu','1310','2444');
INSERT INTO job_provinceandcity VALUES('3445','','Dujiangyan','1310','2445');
INSERT INTO job_provinceandcity VALUES('3446','','Pengzhou','1310','2446');
INSERT INTO job_provinceandcity VALUES('3447','','Qionglai','1310','2447');
INSERT INTO job_provinceandcity VALUES('3448','','Chongzhou','1310','2448');
INSERT INTO job_provinceandcity VALUES('3449','','Jintang','1310','2449');
INSERT INTO job_provinceandcity VALUES('3450','½','Wenjiang','1310','2450');
INSERT INTO job_provinceandcity VALUES('3451','ۯ','Pixian','1310','2451');
INSERT INTO job_provinceandcity VALUES('3452','½','Xinjin','1310','2452');
INSERT INTO job_provinceandcity VALUES('3453','˫','Shuangliu','1310','2453');
INSERT INTO job_provinceandcity VALUES('3454','ѽ','Pujiang','1310','2454');
INSERT INTO job_provinceandcity VALUES('3455','','Dayi','1310','2455');
INSERT INTO job_provinceandcity VALUES('3456','','Daan','1317','2456');
INSERT INTO job_provinceandcity VALUES('3457','','Ziliujing','1317','2457');
INSERT INTO job_provinceandcity VALUES('3458','','Gongjing','1317','2458');
INSERT INTO job_provinceandcity VALUES('3459','̲','Yantan','1317','2459');
INSERT INTO job_provinceandcity VALUES('3460','','Rongxian','1317','2460');
INSERT INTO job_provinceandcity VALUES('3461','˳','Fushun','1317','2461');
INSERT INTO job_provinceandcity VALUES('3462','','Dongqu','1305','2462');
INSERT INTO job_provinceandcity VALUES('3463','','Xiqu','1305','2463');
INSERT INTO job_provinceandcity VALUES('3464','ʺ','Renhe','1305','2464');
INSERT INTO job_provinceandcity VALUES('3465','','Miyi','1305','2465');
INSERT INTO job_provinceandcity VALUES('3466','α','Yanbian','1305','2466');
INSERT INTO job_provinceandcity VALUES('3467','','Jiangyang','1298','2467');
INSERT INTO job_provinceandcity VALUES('3468','Ϫ','Naxi','1298','2468');
INSERT INTO job_provinceandcity VALUES('3469','̶','Longmatan','1298','2469');
INSERT INTO job_provinceandcity VALUES('3470','','Luxian','1298','2470');
INSERT INTO job_provinceandcity VALUES('3471','Ͻ','Hejiang','1298','2471');
INSERT INTO job_provinceandcity VALUES('3472','','Xuyong','1298','2472');
INSERT INTO job_provinceandcity VALUES('3473','','Gulin','1298','2473');
INSERT INTO job_provinceandcity VALUES('3474','','Jingyang','1312','2474');
INSERT INTO job_provinceandcity VALUES('3475','㺺','Guanghan','1312','2475');
INSERT INTO job_provinceandcity VALUES('3476','ʲ','Shifang','1312','2476');
INSERT INTO job_provinceandcity VALUES('3477','','Mianzhu','1312','2477');
INSERT INTO job_provinceandcity VALUES('3478','޽','Luojiang','1312','2478');
INSERT INTO job_provinceandcity VALUES('3479','н','Zhongjiang','1312','2479');
INSERT INTO job_provinceandcity VALUES('3480','','Fucheng','1297','2480');
INSERT INTO job_provinceandcity VALUES('3481','','Youxian','1297','2481');
INSERT INTO job_provinceandcity VALUES('3482','','Jiangyou','1297','2482');
INSERT INTO job_provinceandcity VALUES('3483','ͤ','Yanting','1297','2483');
INSERT INTO job_provinceandcity VALUES('3484','̨','Santai','1297','2484');
INSERT INTO job_provinceandcity VALUES('3485','ƽ','Pingwu','1297','2485');
INSERT INTO job_provinceandcity VALUES('3486','','Beichuan','1297','2486');
INSERT INTO job_provinceandcity VALUES('3487','','Anxian','1297','2487');
INSERT INTO job_provinceandcity VALUES('3488','','Zitong','1297','2488');
INSERT INTO job_provinceandcity VALUES('3489','','Shizhong','1314','2489');
INSERT INTO job_provinceandcity VALUES('3490','Ԫ','Yuanba','1314','2490');
INSERT INTO job_provinceandcity VALUES('3491','','Chaotian','1314','2491');
INSERT INTO job_provinceandcity VALUES('3492','ന','Qingchuan','1314','2492');
INSERT INTO job_provinceandcity VALUES('3493','','Wangcang','1314','2493');
INSERT INTO job_provinceandcity VALUES('3494','','Jiange','1314','2494');
INSERT INTO job_provinceandcity VALUES('3495','Ϫ','Cangxi','1314','2495');
INSERT INTO job_provinceandcity VALUES('3496','','Shizhong','1302','2496');
INSERT INTO job_provinceandcity VALUES('3497','','Shehong','1302','2497');
INSERT INTO job_provinceandcity VALUES('3498','Ϫ','Pengxi','1302','2498');
INSERT INTO job_provinceandcity VALUES('3499','Ӣ','Daying','1302','2499');
INSERT INTO job_provinceandcity VALUES('3500','','Shizhong','1307','2500');
INSERT INTO job_provinceandcity VALUES('3501','','Dongxing','1307','2501');
INSERT INTO job_provinceandcity VALUES('3502','','Zizhong','1307','2502');
INSERT INTO job_provinceandcity VALUES('3503','¡','Longchang','1307','2503');
INSERT INTO job_provinceandcity VALUES('3504','Զ','Weiyuan','1307','2504');
INSERT INTO job_provinceandcity VALUES('3505','','Shizhong','1299','2505');
INSERT INTO job_provinceandcity VALUES('3506','ͨ','Wutongqiao','1299','2506');
INSERT INTO job_provinceandcity VALUES('3507','ɳ','Shawan','1299','2507');
INSERT INTO job_provinceandcity VALUES('3508','ں','Jinkouhe','1299','2508');
INSERT INTO job_provinceandcity VALUES('3509','üɽ','Emeishan','1299','2509');
INSERT INTO job_provinceandcity VALUES('3510','н','Jiajiang','1299','2510');
INSERT INTO job_provinceandcity VALUES('3511','','Jingyan','1299','2511');
INSERT INTO job_provinceandcity VALUES('3512','Ϊ','Qianwei','1299','2512');
INSERT INTO job_provinceandcity VALUES('3513','崨','Muchuan','1299','2513');
INSERT INTO job_provinceandcity VALUES('3514','','Mabian','1299','2514');
INSERT INTO job_provinceandcity VALUES('3515','','Ebian','1299','2515');
INSERT INTO job_provinceandcity VALUES('3516','˳','Shunqing','1306','2516');
INSERT INTO job_provinceandcity VALUES('3517','ƺ','Gaoping','1306','2517');
INSERT INTO job_provinceandcity VALUES('3518','','Jialing','1306','2518');
INSERT INTO job_provinceandcity VALUES('3519','','Langzhong','1306','2519');
INSERT INTO job_provinceandcity VALUES('3520','Ӫɽ','Yingshan','1306','2520');
INSERT INTO job_provinceandcity VALUES('3521','','Pengan','1306','2521');
INSERT INTO job_provinceandcity VALUES('3522','¤','Yilong','1306','2522');
INSERT INTO job_provinceandcity VALUES('3523','ϲ','Nanbu','1306','2523');
INSERT INTO job_provinceandcity VALUES('3524','','Xichong','1306','2524');
INSERT INTO job_provinceandcity VALUES('3525','','Cuiping','1304','2525');
INSERT INTO job_provinceandcity VALUES('3526','˱','Yibin','1304','2526');
INSERT INTO job_provinceandcity VALUES('3527','','Xingwen','1304','2527');
INSERT INTO job_provinceandcity VALUES('3528','Ϫ','Nanxi','1304','2528');
INSERT INTO job_provinceandcity VALUES('3529','','Gongxian','1304','2529');
INSERT INTO job_provinceandcity VALUES('3530','','Jiangan','1304','2530');
INSERT INTO job_provinceandcity VALUES('3531','','Junlian','1304','2531');
INSERT INTO job_provinceandcity VALUES('3532','ɽ','Pingshan','1304','2532');
INSERT INTO job_provinceandcity VALUES('3533','','Changning','1304','2533');
INSERT INTO job_provinceandcity VALUES('3534','','Gaoxian','1304','2534');
INSERT INTO job_provinceandcity VALUES('3535','㰲','Guangan','1315','2535');
INSERT INTO job_provinceandcity VALUES('3536','','Huaying','1315','2536');
INSERT INTO job_provinceandcity VALUES('3537','','Yuechi','1315','2537');
INSERT INTO job_provinceandcity VALUES('3538','ˮ','Lingshui','1315','2538');
INSERT INTO job_provinceandcity VALUES('3539','ʤ','Wusheng','1315','2539');
INSERT INTO job_provinceandcity VALUES('3540','ͨ','Tongchuan','1311','2540');
INSERT INTO job_provinceandcity VALUES('3541','Դ','Wanyuan','1311','2541');
INSERT INTO job_provinceandcity VALUES('3542','','Daxian','1311','2542');
INSERT INTO job_provinceandcity VALUES('3543','','Quxian','1311','2543');
INSERT INTO job_provinceandcity VALUES('3544','','Xuanhan','1311','2544');
INSERT INTO job_provinceandcity VALUES('3545','','Kaijiang','1311','2545');
INSERT INTO job_provinceandcity VALUES('3546','','Dazhu','1311','2546');
INSERT INTO job_provinceandcity VALUES('3547','','Bazhou','1308','2547');
INSERT INTO job_provinceandcity VALUES('3548','Ͻ','Nanjiang','1308','2548');
INSERT INTO job_provinceandcity VALUES('3549','ƽ','Pingchang','1308','2549');
INSERT INTO job_provinceandcity VALUES('3550','ͨ','Tongjiang','1308','2550');
INSERT INTO job_provinceandcity VALUES('3551','','Yucheng','1303','2551');
INSERT INTO job_provinceandcity VALUES('3552','«ɽ','Lushan','1303','2552');
INSERT INTO job_provinceandcity VALUES('3553','ʯ','Shimian','1303','2553');
INSERT INTO job_provinceandcity VALUES('3554','ɽ','Mingshan','1303','2554');
INSERT INTO job_provinceandcity VALUES('3555','ȫ','Tianquan','1303','2555');
INSERT INTO job_provinceandcity VALUES('3556','','Yingjing','1303','2556');
INSERT INTO job_provinceandcity VALUES('3557','','Baoxing','1303','2557');
INSERT INTO job_provinceandcity VALUES('3558','Դ','Hanyuan','1303','2558');
INSERT INTO job_provinceandcity VALUES('3559','','Dongpo','1301','2559');
INSERT INTO job_provinceandcity VALUES('3560','','Renshou','1301','2560');
INSERT INTO job_provinceandcity VALUES('3561','ɽ','Pengshan','1301','2561');
INSERT INTO job_provinceandcity VALUES('3562','','Hongya','1301','2562');
INSERT INTO job_provinceandcity VALUES('3563','','Danleng','1301','2563');
INSERT INTO job_provinceandcity VALUES('3564','','Qingshen','1301','2564');
INSERT INTO job_provinceandcity VALUES('3565','㽭','Yanjiang','1316','2565');
INSERT INTO job_provinceandcity VALUES('3566','','Jianyang','1316','2566');
INSERT INTO job_provinceandcity VALUES('3567','','Anyue','1316','2567');
INSERT INTO job_provinceandcity VALUES('3568','','Lezhi','1316','2568');
INSERT INTO job_provinceandcity VALUES('3569','','Maerkang','1309','2569');
INSERT INTO job_provinceandcity VALUES('3570','կ','Jiuzhaigou','1309','2570');
INSERT INTO job_provinceandcity VALUES('3571','ԭ','Hongyuan','1309','2571');
INSERT INTO job_provinceandcity VALUES('3572','봨','Wenchuan','1309','2572');
INSERT INTO job_provinceandcity VALUES('3573','','Aba','1309','2573');
INSERT INTO job_provinceandcity VALUES('3574','','Lixian','1309','2574');
INSERT INTO job_provinceandcity VALUES('3575','','Ruoergai','1309','2575');
INSERT INTO job_provinceandcity VALUES('3576','С','Xiaojin','1309','2576');
INSERT INTO job_provinceandcity VALUES('3577','ˮ','Heishui','1309','2577');
INSERT INTO job_provinceandcity VALUES('3578','','Jinchuan','1309','2578');
INSERT INTO job_provinceandcity VALUES('3579','','Songpan','1309','2579');
INSERT INTO job_provinceandcity VALUES('3580','','Rangtang','1309','2580');
INSERT INTO job_provinceandcity VALUES('3581','ï','Maoxian','1309','2581');
INSERT INTO job_provinceandcity VALUES('3582','','Kangding','1313','2582');
INSERT INTO job_provinceandcity VALUES('3583','','Danba','1313','2583');
INSERT INTO job_provinceandcity VALUES('3584','¯','Luhuo','1313','2584');
INSERT INTO job_provinceandcity VALUES('3585','','Jiulong','1313','2585');
INSERT INTO job_provinceandcity VALUES('3586','','Ganzi','1313','2586');
INSERT INTO job_provinceandcity VALUES('3587','Ž','Yajiang','1313','2587');
INSERT INTO job_provinceandcity VALUES('3588','','Xinlong','1313','2588');
INSERT INTO job_provinceandcity VALUES('3589','','Daofu','1313','2589');
INSERT INTO job_provinceandcity VALUES('3590','','Baiyu','1313','2590');
INSERT INTO job_provinceandcity VALUES('3591','','Litang','1313','2591');
INSERT INTO job_provinceandcity VALUES('3592','¸','Dege','1313','2592');
INSERT INTO job_provinceandcity VALUES('3593','','Xiangcheng','1313','2593');
INSERT INTO job_provinceandcity VALUES('3594','ʯ','Shiqu','1313','2594');
INSERT INTO job_provinceandcity VALUES('3595','','Daocheng','1313','2595');
INSERT INTO job_provinceandcity VALUES('3596','ɫ','Seda','1313','2596');
INSERT INTO job_provinceandcity VALUES('3597','','Batang','1313','2597');
INSERT INTO job_provinceandcity VALUES('3598','','Luding','1313','2598');
INSERT INTO job_provinceandcity VALUES('3599','','Derong','1313','2599');
INSERT INTO job_provinceandcity VALUES('3600','','Xichang','1300','2600');
INSERT INTO job_provinceandcity VALUES('3601','','Meigu','1300','2601');
INSERT INTO job_provinceandcity VALUES('3602','Ѿ','Zhaojue','1300','2602');
INSERT INTO job_provinceandcity VALUES('3603','','Jinyang','1300','2603');
INSERT INTO job_provinceandcity VALUES('3604','','Ganluo','1300','2604');
INSERT INTO job_provinceandcity VALUES('3605','','Butuo','1300','2605');
INSERT INTO job_provinceandcity VALUES('3606','ײ','Leibo','1300','2606');
INSERT INTO job_provinceandcity VALUES('3607','ո','Puge','1300','2607');
INSERT INTO job_provinceandcity VALUES('3608','','Ningnan','1300','2608');
INSERT INTO job_provinceandcity VALUES('3609','ϲ','Xide','1300','2609');
INSERT INTO job_provinceandcity VALUES('3610','ᶫ','Huidong','1300','2610');
INSERT INTO job_provinceandcity VALUES('3611','Խ','Yuexi','1300','2611');
INSERT INTO job_provinceandcity VALUES('3612','','Huili','1300','2612');
INSERT INTO job_provinceandcity VALUES('3613','Դ','Yanyuan','1300','2613');
INSERT INTO job_provinceandcity VALUES('3614','²','Dechang','1300','2614');
INSERT INTO job_provinceandcity VALUES('3615','','Mianning','1300','2615');
INSERT INTO job_provinceandcity VALUES('3616','ľ','Muli','1300','2616');
INSERT INTO job_provinceandcity VALUES('3617','','Nanming','1116','2617');
INSERT INTO job_provinceandcity VALUES('3618','','Yunyan','1116','2618');
INSERT INTO job_provinceandcity VALUES('3619','Ϫ','Huaxi','1116','2619');
INSERT INTO job_provinceandcity VALUES('3620','ڵ','Wudang','1116','2620');
INSERT INTO job_provinceandcity VALUES('3621','','Baiyun','1116','2621');
INSERT INTO job_provinceandcity VALUES('3622','С','Xiaohe','1116','2622');
INSERT INTO job_provinceandcity VALUES('3623','','Qingzhen','1116','2623');
INSERT INTO job_provinceandcity VALUES('3624','','Kaiyang','1116','2624');
INSERT INTO job_provinceandcity VALUES('3625','','Xiuwen','1116','2625');
INSERT INTO job_provinceandcity VALUES('3626','Ϣ','Xifeng','1116','2626');
INSERT INTO job_provinceandcity VALUES('3627','ɽ','Zhongshan','1109','2627');
INSERT INTO job_provinceandcity VALUES('3628','ˮ','Shuicheng','1109','2628');
INSERT INTO job_provinceandcity VALUES('3629','','Panxian','1109','2629');
INSERT INTO job_provinceandcity VALUES('3630','֦','Xiuzhite','1109','2630');
INSERT INTO job_provinceandcity VALUES('3631','컨','Honghuagang','1117','2631');
INSERT INTO job_provinceandcity VALUES('3632','ˮ','Chishui','1117','2632');
INSERT INTO job_provinceandcity VALUES('3633','ʻ','Renhuai','1117','2633');
INSERT INTO job_provinceandcity VALUES('3634','','Zunyi','1117','2634');
INSERT INTO job_provinceandcity VALUES('3635','','Suiyang','1117','2635');
INSERT INTO job_provinceandcity VALUES('3636','ͩ','Tongzi','1117','2636');
INSERT INTO job_provinceandcity VALUES('3637','ϰˮ','Xishui','1117','2637');
INSERT INTO job_provinceandcity VALUES('3638','','Fenggang','1117','2638');
INSERT INTO job_provinceandcity VALUES('3639','','Zhengan','1117','2639');
INSERT INTO job_provinceandcity VALUES('3640','','Yuqing','1117','2640');
INSERT INTO job_provinceandcity VALUES('3641','̶','Meitan','1117','2641');
INSERT INTO job_provinceandcity VALUES('3642','','Daozhen','1117','2642');
INSERT INTO job_provinceandcity VALUES('3643','','Wuchuan','1117','2643');
INSERT INTO job_provinceandcity VALUES('3644','','Xixiu','1114','2644');
INSERT INTO job_provinceandcity VALUES('3645','ն','Puding','1114','2645');
INSERT INTO job_provinceandcity VALUES('3646','ƽ','Pingba','1114','2646');
INSERT INTO job_provinceandcity VALUES('3647','','Zhenning','1114','2647');
INSERT INTO job_provinceandcity VALUES('3648','岼','Ziyun','1114','2648');
INSERT INTO job_provinceandcity VALUES('3649','벼','Guanling','1114','2649');
INSERT INTO job_provinceandcity VALUES('3650','ͭ','Tongren','1113','2650');
INSERT INTO job_provinceandcity VALUES('3651','½','Dejiang','1113','2651');
INSERT INTO job_provinceandcity VALUES('3652','','Jiangkou','1113','2652');
INSERT INTO job_provinceandcity VALUES('3653','˼','Sinan','1113','2653');
INSERT INTO job_provinceandcity VALUES('3654','ʯ','Shiqian','1113','2654');
INSERT INTO job_provinceandcity VALUES('3655','','Yuping','1113','2655');
INSERT INTO job_provinceandcity VALUES('3656','','Songtao','1113','2656');
INSERT INTO job_provinceandcity VALUES('3657','ӡ','Yinjiang','1113','2657');
INSERT INTO job_provinceandcity VALUES('3658','غ','Yanhe','1113','2658');
INSERT INTO job_provinceandcity VALUES('3659','ɽ','Wanshante','1113','2659');
INSERT INTO job_provinceandcity VALUES('3660','Ͻ','Bijie','1115','2660');
INSERT INTO job_provinceandcity VALUES('3661','ǭ','Qianxi','1115','2661');
INSERT INTO job_provinceandcity VALUES('3662','','Dafang','1115','2662');
INSERT INTO job_provinceandcity VALUES('3663','֯','Zhijin','1115','2663');
INSERT INTO job_provinceandcity VALUES('3664','ɳ','Jinsha','1115','2664');
INSERT INTO job_provinceandcity VALUES('3665','','Hezhang','1115','2665');
INSERT INTO job_provinceandcity VALUES('3666','Ӻ','Nayong','1115','2666');
INSERT INTO job_provinceandcity VALUES('3667','','Weining','1115','2667');
INSERT INTO job_provinceandcity VALUES('3668','','Xingyi','1110','2668');
INSERT INTO job_provinceandcity VALUES('3669','','Wangmo','1110','2669');
INSERT INTO job_provinceandcity VALUES('3670','','Xingren','1110','2670');
INSERT INTO job_provinceandcity VALUES('3671','հ','Puan','1110','2671');
INSERT INTO job_provinceandcity VALUES('3672','','Ceheng','1110','2672');
INSERT INTO job_provinceandcity VALUES('3673','¡','Qinglong','1110','2673');
INSERT INTO job_provinceandcity VALUES('3674','','Zhenfeng','1110','2674');
INSERT INTO job_provinceandcity VALUES('3675','','Anlong','1110','2675');
INSERT INTO job_provinceandcity VALUES('3676','','Kaili','1112','2676');
INSERT INTO job_provinceandcity VALUES('3677','ʩ','Shibing','1112','2677');
INSERT INTO job_provinceandcity VALUES('3678','ӽ','Congjiang','1112','2678');
INSERT INTO job_provinceandcity VALUES('3679','','Jinping','1112','2679');
INSERT INTO job_provinceandcity VALUES('3680','Զ','Zhenyuan','1112','2680');
INSERT INTO job_provinceandcity VALUES('3681','齭','Majiang','1112','2681');
INSERT INTO job_provinceandcity VALUES('3682','̨','Taijiang','1112','2682');
INSERT INTO job_provinceandcity VALUES('3683','','Tianzhu','1112','2683');
INSERT INTO job_provinceandcity VALUES('3684','ƽ','Huangping','1112','2684');
INSERT INTO job_provinceandcity VALUES('3685','Ž','Rongjiang','1112','2685');
INSERT INTO job_provinceandcity VALUES('3686','','Jianhe','1112','2686');
INSERT INTO job_provinceandcity VALUES('3687','','Sansui','1112','2687');
INSERT INTO job_provinceandcity VALUES('3688','ɽ','Leishan','1112','2688');
INSERT INTO job_provinceandcity VALUES('3689','ƽ','Liping','1112','2689');
INSERT INTO job_provinceandcity VALUES('3690','᯹','Cengong','1112','2690');
INSERT INTO job_provinceandcity VALUES('3691','կ','Danzhai','1112','2691');
INSERT INTO job_provinceandcity VALUES('3692','','Duyun','1111','2692');
INSERT INTO job_provinceandcity VALUES('3693','','Guiding','1111','2693');
INSERT INTO job_provinceandcity VALUES('3694','ˮ','Huishui','1111','2694');
INSERT INTO job_provinceandcity VALUES('3695','޵','Luodian','1111','2695');
INSERT INTO job_provinceandcity VALUES('3696','Ͱ','Wenan','1111','2696');
INSERT INTO job_provinceandcity VALUES('3697','','Libo','1111','2697');
INSERT INTO job_provinceandcity VALUES('3698','','Longli','1111','2698');
INSERT INTO job_provinceandcity VALUES('3699','ƽ','Pingtang','1111','2699');
INSERT INTO job_provinceandcity VALUES('3700','˳','Changshun','1111','2700');
INSERT INTO job_provinceandcity VALUES('3701','ɽ','Dushan','1111','2701');
INSERT INTO job_provinceandcity VALUES('3702','ˮ','Sandu','1111','2702');
INSERT INTO job_provinceandcity VALUES('3703','','Panlong','1339','2703');
INSERT INTO job_provinceandcity VALUES('3704','廪','Wuhua','1339','2704');
INSERT INTO job_provinceandcity VALUES('3705','ٶ','Guandu','1339','2705');
INSERT INTO job_provinceandcity VALUES('3706','ɽ','Xishan','1339','2706');
INSERT INTO job_provinceandcity VALUES('3707','','Dongchuan','1339','2707');
INSERT INTO job_provinceandcity VALUES('3708','','Anning','1339','2708');
INSERT INTO job_provinceandcity VALUES('3709','','Fumin','1339','2709');
INSERT INTO job_provinceandcity VALUES('3710','','Songming','1339','2710');
INSERT INTO job_provinceandcity VALUES('3711','ʹ','Chenggong','1339','2711');
INSERT INTO job_provinceandcity VALUES('3712','','Jinning','1339','2712');
INSERT INTO job_provinceandcity VALUES('3713','','Yiliang','1339','2713');
INSERT INTO job_provinceandcity VALUES('3714','»Ȱ','Luquan','1339','2714');
INSERT INTO job_provinceandcity VALUES('3715','ʯ','Shilin','1339','2715');
INSERT INTO job_provinceandcity VALUES('3716','Ѱ','Xundian','1339','2716');
INSERT INTO job_provinceandcity VALUES('3717','','Qilin','1341','2717');
INSERT INTO job_provinceandcity VALUES('3718','','Xuanwei','1341','2718');
INSERT INTO job_provinceandcity VALUES('3719','½','Luliang','1341','2719');
INSERT INTO job_provinceandcity VALUES('3720','','Huize','1341','2720');
INSERT INTO job_provinceandcity VALUES('3721','Դ','Fuyuan','1341','2721');
INSERT INTO job_provinceandcity VALUES('3722','ƽ','Luoping','1341','2722');
INSERT INTO job_provinceandcity VALUES('3723','','Malong','1341','2723');
INSERT INTO job_provinceandcity VALUES('3724','ʦ','Shizong','1341','2724');
INSERT INTO job_provinceandcity VALUES('3725','մ','Zhanyi','1341','2725');
INSERT INTO job_provinceandcity VALUES('3726','','Hongta','1345','2726');
INSERT INTO job_provinceandcity VALUES('3727','','Huaning','1345','2727');
INSERT INTO job_provinceandcity VALUES('3728','ν','Chengjiang','1345','2728');
INSERT INTO job_provinceandcity VALUES('3729','','Yimen','1345','2729');
INSERT INTO job_provinceandcity VALUES('3730','ͨ','Tonghai','1345','2730');
INSERT INTO job_provinceandcity VALUES('3731','','Jiangchuan','1345','2731');
INSERT INTO job_provinceandcity VALUES('3732','Ԫ','Yuanjiang','1345','2732');
INSERT INTO job_provinceandcity VALUES('3733','ƽ','Xinping','1345','2733');
INSERT INTO job_provinceandcity VALUES('3734','ɽ','Eshan','1345','2734');
INSERT INTO job_provinceandcity VALUES('3735','¡','Longyang','1347','2735');
INSERT INTO job_provinceandcity VALUES('3736','ʩ','Shidian','1347','2736');
INSERT INTO job_provinceandcity VALUES('3737','','Changning','1347','2737');
INSERT INTO job_provinceandcity VALUES('3738','','Longling','1347','2738');
INSERT INTO job_provinceandcity VALUES('3739','ڳ','Tengchong','1347','2739');
INSERT INTO job_provinceandcity VALUES('3740','','Zhaoyang','1344','2740');
INSERT INTO job_provinceandcity VALUES('3741','','Yongshan','1344','2741');
INSERT INTO job_provinceandcity VALUES('3742','罭','Suijiang','1344','2742');
INSERT INTO job_provinceandcity VALUES('3743','','Zhenxiong','1344','2743');
INSERT INTO job_provinceandcity VALUES('3744','','Daguan','1344','2744');
INSERT INTO job_provinceandcity VALUES('3745','ν','Yanjin','1344','2745');
INSERT INTO job_provinceandcity VALUES('3746','ɼ','Qiaojia','1344','2746');
INSERT INTO job_provinceandcity VALUES('3747','','Yiliang','1344','2747');
INSERT INTO job_provinceandcity VALUES('3748','','Weixin','1344','2748');
INSERT INTO job_provinceandcity VALUES('3749','ˮ','Shuifu','1344','2749');
INSERT INTO job_provinceandcity VALUES('3750','³','Ludian','1344','2750');
INSERT INTO job_provinceandcity VALUES('3751','ն','Puer','1342','2751');
INSERT INTO job_provinceandcity VALUES('3752','','Jingdong','1342','2752');
INSERT INTO job_provinceandcity VALUES('3753','','Zhenyuan','1342','2753');
INSERT INTO job_provinceandcity VALUES('3754','','Jinggu','1342','2754');
INSERT INTO job_provinceandcity VALUES('3755','ī','Mojiang','1342','2755');
INSERT INTO job_provinceandcity VALUES('3756','','Lancang','1342','2756');
INSERT INTO job_provinceandcity VALUES('3757','','Ximeng','1342','2757');
INSERT INTO job_provinceandcity VALUES('3758','ǹ','Jiangcheng','1342','2758');
INSERT INTO job_provinceandcity VALUES('3759','','Menglian','1342','2759');
INSERT INTO job_provinceandcity VALUES('3760','','Cuiyun','1342','2760');
INSERT INTO job_provinceandcity VALUES('3761','','Linxiang','1337','2761');
INSERT INTO job_provinceandcity VALUES('3762','','Zhenkang','1337','2762');
INSERT INTO job_provinceandcity VALUES('3763','','Fengqing','1337','2763');
INSERT INTO job_provinceandcity VALUES('3764','','Yunxian','1337','2764');
INSERT INTO job_provinceandcity VALUES('3765','','Yongde','1337','2765');
INSERT INTO job_provinceandcity VALUES('3766','˫岼','Shuangjiang','1337','2766');
INSERT INTO job_provinceandcity VALUES('3767','Դ','Cangyuan','1337','2767');
INSERT INTO job_provinceandcity VALUES('3768','','Gengma','1337','2768');
INSERT INTO job_provinceandcity VALUES('3769','ų','Gucheng','1338','2769');
INSERT INTO job_provinceandcity VALUES('3770','ƺ','Huaping','1338','2770');
INSERT INTO job_provinceandcity VALUES('3771','ʤ','Yongsheng','1338','2771');
INSERT INTO job_provinceandcity VALUES('3772','','Yulong','1338','2772');
INSERT INTO job_provinceandcity VALUES('3773','','Ninglang','1338','2773');
INSERT INTO job_provinceandcity VALUES('3774','ɽ','Wenshan','1343','2774');
INSERT INTO job_provinceandcity VALUES('3775','','Malipo','1343','2775');
INSERT INTO job_provinceandcity VALUES('3776','ɽ','Yanshan','1343','2776');
INSERT INTO job_provinceandcity VALUES('3777','','Guangnan','1343','2777');
INSERT INTO job_provinceandcity VALUES('3778','','Maguan','1343','2778');
INSERT INTO job_provinceandcity VALUES('3779','','Funing','1343','2779');
INSERT INTO job_provinceandcity VALUES('3780','','Xichou','1343','2780');
INSERT INTO job_provinceandcity VALUES('3781','','Qiubei','1343','2781');
INSERT INTO job_provinceandcity VALUES('3782','','Gejiu','1351','2782');
INSERT INTO job_provinceandcity VALUES('3783','Զ','Kaiyuan','1351','2783');
INSERT INTO job_provinceandcity VALUES('3784','','Mile','1351','2784');
INSERT INTO job_provinceandcity VALUES('3785','','Honghe','1351','2785');
INSERT INTO job_provinceandcity VALUES('3786','̴','Lvchun','1351','2786');
INSERT INTO job_provinceandcity VALUES('3787','','Mengzi','1351','2787');
INSERT INTO job_provinceandcity VALUES('3788','','Luxi','1351','2788');
INSERT INTO job_provinceandcity VALUES('3789','ˮ','Jianshui','1351','2789');
INSERT INTO job_provinceandcity VALUES('3790','Ԫ','Yuanyang','1351','2790');
INSERT INTO job_provinceandcity VALUES('3791','ʯ','Shiping','1351','2791');
INSERT INTO job_provinceandcity VALUES('3792','ƽ','Jinping','1351','2792');
INSERT INTO job_provinceandcity VALUES('3793','ӿ','Hekou','1351','2793');
INSERT INTO job_provinceandcity VALUES('3794','','Pingbian','1351','2794');
INSERT INTO job_provinceandcity VALUES('3795','','Jinghong','1352','2795');
INSERT INTO job_provinceandcity VALUES('3796','º','Menghai','1352','2796');
INSERT INTO job_provinceandcity VALUES('3797','','Mengla','1352','2797');
INSERT INTO job_provinceandcity VALUES('3798','','Chuxiong','1348','2798');
INSERT INTO job_provinceandcity VALUES('3799','Ԫı','Yuanmou','1348','2799');
INSERT INTO job_provinceandcity VALUES('3800','ϻ','Nanhua','1348','2800');
INSERT INTO job_provinceandcity VALUES('3801','Ĳ','Mouding','1348','2801');
INSERT INTO job_provinceandcity VALUES('3802','䶨','Wuding','1348','2802');
INSERT INTO job_provinceandcity VALUES('3803','Ҧ','Dayao','1348','2803');
INSERT INTO job_provinceandcity VALUES('3804','˫','Shuangbai','1348','2804');
INSERT INTO job_provinceandcity VALUES('3805','»','Lufeng','1348','2805');
INSERT INTO job_provinceandcity VALUES('3806','','Yongren','1348','2806');
INSERT INTO job_provinceandcity VALUES('3807','Ҧ','Yaoan','1348','2807');
INSERT INTO job_provinceandcity VALUES('3808','','Dali','1349','2808');
INSERT INTO job_provinceandcity VALUES('3809','','Jianchuan','1349','2809');
INSERT INTO job_provinceandcity VALUES('3810','ֶ','Midu','1349','2810');
INSERT INTO job_provinceandcity VALUES('3811','','Yunlong','1349','2811');
INSERT INTO job_provinceandcity VALUES('3812','Դ','Eryuan','1349','2812');
INSERT INTO job_provinceandcity VALUES('3813','','Heqing','1349','2813');
INSERT INTO job_provinceandcity VALUES('3814','','Xiangyun','1349','2814');
INSERT INTO job_provinceandcity VALUES('3815','','Binchuan','1349','2815');
INSERT INTO job_provinceandcity VALUES('3816','ƽ','Yongping','1349','2816');
INSERT INTO job_provinceandcity VALUES('3817','','Yangbi','1349','2817');
INSERT INTO job_provinceandcity VALUES('3818','Ρɽ','Weishan','1349','2818');
INSERT INTO job_provinceandcity VALUES('3819','Ͻ','Nanjian','1349','2819');
INSERT INTO job_provinceandcity VALUES('3820','º','Luxi','1340','2820');
INSERT INTO job_provinceandcity VALUES('3821','','Ruili','1340','2821');
INSERT INTO job_provinceandcity VALUES('3822','ӯ','Yingjiang','1340','2822');
INSERT INTO job_provinceandcity VALUES('3823','','Lianghe','1340','2823');
INSERT INTO job_provinceandcity VALUES('3824','¤','Longchuan','1340','2824');
INSERT INTO job_provinceandcity VALUES('3825','ˮ','Lushui','1346','2825');
INSERT INTO job_provinceandcity VALUES('3826','','Fugong','1346','2826');
INSERT INTO job_provinceandcity VALUES('3827','ƺ','Lanping','1346','2827');
INSERT INTO job_provinceandcity VALUES('3828','ɽŭ','Gongshan','1346','2828');
INSERT INTO job_provinceandcity VALUES('3829','','Xianggelila','1350','2829');
INSERT INTO job_provinceandcity VALUES('3830','','Deqin','1350','2830');
INSERT INTO job_provinceandcity VALUES('3831','ά','Weixi','1350','2831');
INSERT INTO job_provinceandcity VALUES('3832','ǹ','Chengguan','1319','2832');
INSERT INTO job_provinceandcity VALUES('3833','','Linzhou','1319','2833');
INSERT INTO job_provinceandcity VALUES('3834','','Dazi','1319','2834');
INSERT INTO job_provinceandcity VALUES('3835','ľ','Nimu','1319','2835');
INSERT INTO job_provinceandcity VALUES('3836','','Dangxiong','1319','2836');
INSERT INTO job_provinceandcity VALUES('3837','ˮ','Qushui','1319','2837');
INSERT INTO job_provinceandcity VALUES('3838','ī񹤿','Mozhugongka','1319','2838');
INSERT INTO job_provinceandcity VALUES('3839','','Duilongdeqing','1319','2839');
INSERT INTO job_provinceandcity VALUES('3840','','Naqu','1322','2840');
INSERT INTO job_provinceandcity VALUES('3841','','Jiali','1322','2841');
INSERT INTO job_provinceandcity VALUES('3842','','Shenzha','1322','2842');
INSERT INTO job_provinceandcity VALUES('3843','','Baqing','1322','2843');
INSERT INTO job_provinceandcity VALUES('3844','','Nierong','1322','2844');
INSERT INTO job_provinceandcity VALUES('3845','','Nima','1322','2845');
INSERT INTO job_provinceandcity VALUES('3846','','Biru','1322','2846');
INSERT INTO job_provinceandcity VALUES('3847','','Suoxian','1322','2847');
INSERT INTO job_provinceandcity VALUES('3848','','Bange','1322','2848');
INSERT INTO job_provinceandcity VALUES('3849','','Anduo','1322','2849');
INSERT INTO job_provinceandcity VALUES('3850','','Changdu','1324','2850');
INSERT INTO job_provinceandcity VALUES('3851','â','Mangkang','1324','2851');
INSERT INTO job_provinceandcity VALUES('3852','','Gongjue','1324','2852');
INSERT INTO job_provinceandcity VALUES('3853','','Basu','1324','2853');
INSERT INTO job_provinceandcity VALUES('3854','','Zuogong','1324','2854');
INSERT INTO job_provinceandcity VALUES('3855','߰','Bianba','1324','2855');
INSERT INTO job_provinceandcity VALUES('3856','¡','Luolong','1324','2856');
INSERT INTO job_provinceandcity VALUES('3857','','Jiangda','1324','2857');
INSERT INTO job_provinceandcity VALUES('3858','','Leiwuqi','1324','2858');
INSERT INTO job_provinceandcity VALUES('3859','','Dingqing','1324','2859');
INSERT INTO job_provinceandcity VALUES('3860','','Chaya','1324','2860');
INSERT INTO job_provinceandcity VALUES('3861','˶','Naidong','1321','2861');
INSERT INTO job_provinceandcity VALUES('3862','','Qiongjie','1321','2862');
INSERT INTO job_provinceandcity VALUES('3863','','Cuomei','1321','2863');
INSERT INTO job_provinceandcity VALUES('3864','Ӳ','Jiacha','1321','2864');
INSERT INTO job_provinceandcity VALUES('3865','','Gongga','1321','2865');
INSERT INTO job_provinceandcity VALUES('3866','','Luozha','1321','2866');
INSERT INTO job_provinceandcity VALUES('3867','','Qusong','1321','2867');
INSERT INTO job_provinceandcity VALUES('3868','ɣ','Sangri','1321','2868');
INSERT INTO job_provinceandcity VALUES('3869','','Zhanang','1321','2869');
INSERT INTO job_provinceandcity VALUES('3870','','Cuona','1321','2870');
INSERT INTO job_provinceandcity VALUES('3871','¡','Longzi','1321','2871');
INSERT INTO job_provinceandcity VALUES('3872','˿','Langkazi','1321','2872');
INSERT INTO job_provinceandcity VALUES('3873','տ','Rikaze','1320','2873');
INSERT INTO job_provinceandcity VALUES('3874','','Dingjie','1320','2874');
INSERT INTO job_provinceandcity VALUES('3875','','Sajia','1320','2875');
INSERT INTO job_provinceandcity VALUES('3876','','Jiangzi','1320','2876');
INSERT INTO job_provinceandcity VALUES('3877','','Lazi','1320','2877');
INSERT INTO job_provinceandcity VALUES('3878','','Dingri','1320','2878');
INSERT INTO job_provinceandcity VALUES('3879','','Kangma','1320','2879');
INSERT INTO job_provinceandcity VALUES('3880','ľ','Nielamu','1320','2880');
INSERT INTO job_provinceandcity VALUES('3881','¡','Jilong','1320','2881');
INSERT INTO job_provinceandcity VALUES('3882','Ƕ','Yadong','1320','2882');
INSERT INTO job_provinceandcity VALUES('3883','лͨ','Xiedongmen','1320','2883');
INSERT INTO job_provinceandcity VALUES('3884','','Angren','1320','2884');
INSERT INTO job_provinceandcity VALUES('3885','ڰ','Gangba','1320','2885');
INSERT INTO job_provinceandcity VALUES('3886','ٰ','Zhongba','1320','2886');
INSERT INTO job_provinceandcity VALUES('3887','','Saga','1320','2887');
INSERT INTO job_provinceandcity VALUES('3888','ʲ','Renbu','1320','2888');
INSERT INTO job_provinceandcity VALUES('3889','','Bailang','1320','2889');
INSERT INTO job_provinceandcity VALUES('3890','ľ','Nanmulin','1320','2890');
INSERT INTO job_provinceandcity VALUES('3891','','Gaer','1323','2891');
INSERT INTO job_provinceandcity VALUES('3892','','Cuoqin','1323','2892');
INSERT INTO job_provinceandcity VALUES('3893','','Pulan','1323','2893');
INSERT INTO job_provinceandcity VALUES('3894','Ｊ','Geji','1323','2894');
INSERT INTO job_provinceandcity VALUES('3895','','Ritu','1323','2895');
INSERT INTO job_provinceandcity VALUES('3896','','Zhada','1323','2896');
INSERT INTO job_provinceandcity VALUES('3897','','Gaize','1323','2897');
INSERT INTO job_provinceandcity VALUES('3898','֥','Linzhi','1318','2898');
INSERT INTO job_provinceandcity VALUES('3899','ī','Motuo','1318','2899');
INSERT INTO job_provinceandcity VALUES('3900','','Langxian','1318','2900');
INSERT INTO job_provinceandcity VALUES('3901','','Milin','1318','2901');
INSERT INTO job_provinceandcity VALUES('3902','','Chaou','1318','2902');
INSERT INTO job_provinceandcity VALUES('3903','','Bomi','1318','2903');
INSERT INTO job_provinceandcity VALUES('3904','','Gongbujiangda','1318','2904');
INSERT INTO job_provinceandcity VALUES('3905','','Lianhu','1291','2905');
INSERT INTO job_provinceandcity VALUES('3906','³','Xincheng','1291','2906');
INSERT INTO job_provinceandcity VALUES('3907','','Beilin','1291','2907');
INSERT INTO job_provinceandcity VALUES('3908','','Yanta','1291','2908');
INSERT INTO job_provinceandcity VALUES('3909','','Baqiao','1291','2909');
INSERT INTO job_provinceandcity VALUES('3910','δ','Weiyang','1291','2910');
INSERT INTO job_provinceandcity VALUES('3911','','Yanliang','1291','2911');
INSERT INTO job_provinceandcity VALUES('3912','','Lintong','1291','2912');
INSERT INTO job_provinceandcity VALUES('3913','','Changan','1291','2913');
INSERT INTO job_provinceandcity VALUES('3914','','Gaoling','1291','2914');
INSERT INTO job_provinceandcity VALUES('3915','','Lantian','1291','2915');
INSERT INTO job_provinceandcity VALUES('3916','','Huxian','1291','2916');
INSERT INTO job_provinceandcity VALUES('3917','','Zhouzhi','1291','2917');
INSERT INTO job_provinceandcity VALUES('3918','','Wangyi','1289','2918');
INSERT INTO job_provinceandcity VALUES('3919','ӡ̨','Yintai','1289','2919');
INSERT INTO job_provinceandcity VALUES('3920','ҫ','Yaoxian','1289','2920');
INSERT INTO job_provinceandcity VALUES('3921','˾','Yijun','1289','2921');
INSERT INTO job_provinceandcity VALUES('3922','μ','Weibin','1295','2922');
INSERT INTO job_provinceandcity VALUES('3923','̨','Jintai','1295','2923');
INSERT INTO job_provinceandcity VALUES('3924','','Baoji','1295','2924');
INSERT INTO job_provinceandcity VALUES('3925','ɽ','Qishan','1295','2925');
INSERT INTO job_provinceandcity VALUES('3926','','Fengxiang','1295','2926');
INSERT INTO job_provinceandcity VALUES('3927','¤','Longxian','1295','2927');
INSERT INTO job_provinceandcity VALUES('3928','̫','Taibai','1295','2928');
INSERT INTO job_provinceandcity VALUES('3929','','Linyou','1295','2929');
INSERT INTO job_provinceandcity VALUES('3930','','Fufeng','1295','2930');
INSERT INTO job_provinceandcity VALUES('3931','ǧ','Qianyang','1295','2931');
INSERT INTO job_provinceandcity VALUES('3932','ü','Meixian','1295','2932');
INSERT INTO job_provinceandcity VALUES('3933','','Fengxian','1295','2933');
INSERT INTO job_provinceandcity VALUES('3934','ض','Qindu','1288','2934');
INSERT INTO job_provinceandcity VALUES('3935','μ','Weicheng','1288','2935');
INSERT INTO job_provinceandcity VALUES('3936','','Yangling','1288','2936');
INSERT INTO job_provinceandcity VALUES('3937','ƽ','Xingping','1288','2937');
INSERT INTO job_provinceandcity VALUES('3938','Ȫ','Liquan','1288','2938');
INSERT INTO job_provinceandcity VALUES('3939','','Jingyang','1288','2939');
INSERT INTO job_provinceandcity VALUES('3940','','Yongshou','1288','2940');
INSERT INTO job_provinceandcity VALUES('3941','ԭ','Sanyuan','1288','2941');
INSERT INTO job_provinceandcity VALUES('3942','','Binxian','1288','2942');
INSERT INTO job_provinceandcity VALUES('3943','Ѯ','Xunyi','1288','2943');
INSERT INTO job_provinceandcity VALUES('3944','','Changwu','1288','2944');
INSERT INTO job_provinceandcity VALUES('3945','Ǭ','Qianxian','1288','2945');
INSERT INTO job_provinceandcity VALUES('3946','书','Wugong','1288','2946');
INSERT INTO job_provinceandcity VALUES('3947','','Chunhua','1288','2947');
INSERT INTO job_provinceandcity VALUES('3948','μ','Linwei','1290','2948');
INSERT INTO job_provinceandcity VALUES('3949','','Hancheng','1290','2949');
INSERT INTO job_provinceandcity VALUES('3950','','Huayin','1290','2950');
INSERT INTO job_provinceandcity VALUES('3951','ѳ','Pucheng','1290','2951');
INSERT INTO job_provinceandcity VALUES('3952','','Tongguan','1290','2952');
INSERT INTO job_provinceandcity VALUES('3953','ˮ','Baishui','1290','2953');
INSERT INTO job_provinceandcity VALUES('3954','γ','Chengcheng','1290','2954');
INSERT INTO job_provinceandcity VALUES('3955','','Huaxian','1290','2955');
INSERT INTO job_provinceandcity VALUES('3956','','Heyang','1290','2956');
INSERT INTO job_provinceandcity VALUES('3957','','Heyang','1290','2957');
INSERT INTO job_provinceandcity VALUES('3958','','Dali','1290','2958');
INSERT INTO job_provinceandcity VALUES('3959','','Baota','1292','2959');
INSERT INTO job_provinceandcity VALUES('3960','','Ansai','1292','2960');
INSERT INTO job_provinceandcity VALUES('3961','崨','Luochuan','1292','2961');
INSERT INTO job_provinceandcity VALUES('3962','ӳ','Zichang','1292','2962');
INSERT INTO job_provinceandcity VALUES('3963','','Huangling','1292','2963');
INSERT INTO job_provinceandcity VALUES('3964','ӳ','Yanchang','1292','2964');
INSERT INTO job_provinceandcity VALUES('3965','Ȫ','Ganquan','1292','2965');
INSERT INTO job_provinceandcity VALUES('3966','˴','Yichuan','1292','2966');
INSERT INTO job_provinceandcity VALUES('3967','־','Zhidan','1292','2967');
INSERT INTO job_provinceandcity VALUES('3968','','Huanglong','1292','2968');
INSERT INTO job_provinceandcity VALUES('3969','','Wuqi','1292','2969');
INSERT INTO job_provinceandcity VALUES('3970','Ӵ','Yanchuan','1292','2970');
INSERT INTO job_provinceandcity VALUES('3971','','Fuxian','1292','2971');
INSERT INTO job_provinceandcity VALUES('3972','̨','Hantai','1296','2972');
INSERT INTO job_provinceandcity VALUES('3973','','Liuba','1296','2973');
INSERT INTO job_provinceandcity VALUES('3974','','Zhenba','1296','2974');
INSERT INTO job_provinceandcity VALUES('3975','ǹ','Chenggu','1296','2975');
INSERT INTO job_provinceandcity VALUES('3976','֣','Nanzheng','1296','2976');
INSERT INTO job_provinceandcity VALUES('3977','','Yangxian','1296','2977');
INSERT INTO job_provinceandcity VALUES('3978','ǿ','Ningqiang','1296','2978');
INSERT INTO job_provinceandcity VALUES('3979','ƺ','Foping','1296','2979');
INSERT INTO job_provinceandcity VALUES('3980','','Mianxian','1296','2980');
INSERT INTO job_provinceandcity VALUES('3981','','Xixiang','1296','2981');
INSERT INTO job_provinceandcity VALUES('3982','','Lueyang','1296','2982');
INSERT INTO job_provinceandcity VALUES('3983','','Yuyang','1293','2983');
INSERT INTO job_provinceandcity VALUES('3984','彧','Qingjian','1293','2984');
INSERT INTO job_provinceandcity VALUES('3985','','Suide','1293','2985');
INSERT INTO job_provinceandcity VALUES('3986','ľ','Shenmu','1293','2986');
INSERT INTO job_provinceandcity VALUES('3987','','Jiaxian','1293','2987');
INSERT INTO job_provinceandcity VALUES('3988','','Fugu','1293','2988');
INSERT INTO job_provinceandcity VALUES('3989','','Zizhou','1293','2989');
INSERT INTO job_provinceandcity VALUES('3990','','Jingbian','1293','2990');
INSERT INTO job_provinceandcity VALUES('3991','ɽ','Hengshan','1293','2991');
INSERT INTO job_provinceandcity VALUES('3992','֬','Mizhi','1293','2992');
INSERT INTO job_provinceandcity VALUES('3993','Ɽ','Wubao','1293','2993');
INSERT INTO job_provinceandcity VALUES('3994','','Dingbian','1293','2994');
INSERT INTO job_provinceandcity VALUES('3995','','Hanbin','1294','2995');
INSERT INTO job_provinceandcity VALUES('3996','','Ziyang','1294','2996');
INSERT INTO job_provinceandcity VALUES('3997','᰸','Langao','1294','2997');
INSERT INTO job_provinceandcity VALUES('3998','Ѯ','Xuyang','1294','2998');
INSERT INTO job_provinceandcity VALUES('3999','ƺ','Zhenping','1294','2999');
INSERT INTO job_provinceandcity VALUES('4000','ƽ','Pingli','1294','3000');
INSERT INTO job_provinceandcity VALUES('4001','ʯȪ','Shiquan','1294','3001');
INSERT INTO job_provinceandcity VALUES('4002','','Ningshan','1294','3002');
INSERT INTO job_provinceandcity VALUES('4003','׺','Baihe','1294','3003');
INSERT INTO job_provinceandcity VALUES('4004','','Hanyin','1294','3004');
INSERT INTO job_provinceandcity VALUES('4005','','Shangzhou','1287','3005');
INSERT INTO job_provinceandcity VALUES('4006','','Zhenan','1287','3006');
INSERT INTO job_provinceandcity VALUES('4007','ɽ','Shanyang','1287','3007');
INSERT INTO job_provinceandcity VALUES('4008','','Luonan','1287','3008');
INSERT INTO job_provinceandcity VALUES('4009','','Shangnan','1287','3009');
INSERT INTO job_provinceandcity VALUES('4010','','Danfeng','1287','3010');
INSERT INTO job_provinceandcity VALUES('4011','ˮ','Zhashui','1287','3011');
INSERT INTO job_provinceandcity VALUES('4012','','Yumen','1024','3012');
INSERT INTO job_provinceandcity VALUES('4013','ػ','Dunhuang','1024','3013');
INSERT INTO job_provinceandcity VALUES('4014','ǹ','Chengguan','1062','3014');
INSERT INTO job_provinceandcity VALUES('4015','','Qilihe','1062','3015');
INSERT INTO job_provinceandcity VALUES('4016','','Xigu','1062','3016');
INSERT INTO job_provinceandcity VALUES('4017','','Anning','1062','3017');
INSERT INTO job_provinceandcity VALUES('4018','','Honggu','1062','3018');
INSERT INTO job_provinceandcity VALUES('4019','','Yongdeng','1062','3019');
INSERT INTO job_provinceandcity VALUES('4020','','Yuzhong','1062','3020');
INSERT INTO job_provinceandcity VALUES('4021','','Gaolan','1062','3021');
INSERT INTO job_provinceandcity VALUES('4022','','Jinchuan','1072','3022');
INSERT INTO job_provinceandcity VALUES('4023','','Yongchang','1072','3023');
INSERT INTO job_provinceandcity VALUES('4024','','Baiyin','1068','3024');
INSERT INTO job_provinceandcity VALUES('4025','ƽ','Pingchuan','1068','3025');
INSERT INTO job_provinceandcity VALUES('4026','Զ','Jingyuan','1068','3026');
INSERT INTO job_provinceandcity VALUES('4027','Զ','Jingyuan','1068','3027');
INSERT INTO job_provinceandcity VALUES('4028','','Huining','1068','3028');
INSERT INTO job_provinceandcity VALUES('4029','س','Qincheng','1063','3029');
INSERT INTO job_provinceandcity VALUES('4030','','Beidao','1063','3030');
INSERT INTO job_provinceandcity VALUES('4031','ɽ','Wushan','1063','3031');
INSERT INTO job_provinceandcity VALUES('4032','ʹ','Gangu','1063','3032');
INSERT INTO job_provinceandcity VALUES('4033','ˮ','Qingshui','1063','3033');
INSERT INTO job_provinceandcity VALUES('4034','ذ','Qinan','1063','3034');
INSERT INTO job_provinceandcity VALUES('4035','żҴ','Zhangjiachuan','1063','3035');
INSERT INTO job_provinceandcity VALUES('4036','','Jiayuguan','1071','3036');
INSERT INTO job_provinceandcity VALUES('4037','','Liangzhou','1064','3037');
INSERT INTO job_provinceandcity VALUES('4038','','Minqin','1064','3038');
INSERT INTO job_provinceandcity VALUES('4039','','Gulang','1064','3039');
INSERT INTO job_provinceandcity VALUES('4040','ף','Tianzhu','1064','3040');
INSERT INTO job_provinceandcity VALUES('4041','','Dingxi','1069','3041');
INSERT INTO job_provinceandcity VALUES('4042','','Minxian','1069','3042');
INSERT INTO job_provinceandcity VALUES('4043','μԴ','Weiyuan','1069','3043');
INSERT INTO job_provinceandcity VALUES('4044','¤','Longxi','1069','3044');
INSERT INTO job_provinceandcity VALUES('4045','ͨμ','Tongwei','1069','3045');
INSERT INTO job_provinceandcity VALUES('4046','','Zhangxian','1069','3046');
INSERT INTO job_provinceandcity VALUES('4047','','Lintao','1069','3047');
INSERT INTO job_provinceandcity VALUES('4048','','Kongtong','1067','3048');
INSERT INTO job_provinceandcity VALUES('4049','̨','Lingtai','1067','3049');
INSERT INTO job_provinceandcity VALUES('4050','','Jingning','1067','3050');
INSERT INTO job_provinceandcity VALUES('4051','','Chongxin','1067','3051');
INSERT INTO job_provinceandcity VALUES('4052','ͤ','Huating','1067','3052');
INSERT INTO job_provinceandcity VALUES('4053','','Jingchuan','1067','3053');
INSERT INTO job_provinceandcity VALUES('4054','ׯ','Zhuanglang','1067','3054');
INSERT INTO job_provinceandcity VALUES('4055','','Xifeng','1065','3055');
INSERT INTO job_provinceandcity VALUES('4056','','Qingcheng','1065','3056');
INSERT INTO job_provinceandcity VALUES('4057','ԭ','Zhenyuan','1065','3057');
INSERT INTO job_provinceandcity VALUES('4058','','Huanxian','1065','3058');
INSERT INTO job_provinceandcity VALUES('4059','','Huachi','1065','3059');
INSERT INTO job_provinceandcity VALUES('4060','ˮ','Heshui','1065','3060');
INSERT INTO job_provinceandcity VALUES('4061','','Ningxian','1065','3061');
INSERT INTO job_provinceandcity VALUES('4062','','Zhengning','1065','3062');
INSERT INTO job_provinceandcity VALUES('4063','','Chengxian','1061','3063');
INSERT INTO job_provinceandcity VALUES('4064','','Lixian','1061','3064');
INSERT INTO job_provinceandcity VALUES('4065','','Kangxian','1061','3065');
INSERT INTO job_provinceandcity VALUES('4066','䶼','Wudu','1061','3066');
INSERT INTO job_provinceandcity VALUES('4067','','Wenxian','1061','3067');
INSERT INTO job_provinceandcity VALUES('4068','','Liangdang','1061','3068');
INSERT INTO job_provinceandcity VALUES('4069','','Huixian','1061','3069');
INSERT INTO job_provinceandcity VALUES('4070','崲','Dangchang','1061','3070');
INSERT INTO job_provinceandcity VALUES('4071','','Xihe','1061','3071');
INSERT INTO job_provinceandcity VALUES('4072','','Ganzhou','1066','3072');
INSERT INTO job_provinceandcity VALUES('4073','','Minle','1066','3073');
INSERT INTO job_provinceandcity VALUES('4074','ɽ','Shandan','1066','3074');
INSERT INTO job_provinceandcity VALUES('4075','','Linze','1066','3075');
INSERT INTO job_provinceandcity VALUES('4076','̨','Gaotai','1066','3076');
INSERT INTO job_provinceandcity VALUES('4077','ԣ','Sunan','1066','3077');
INSERT INTO job_provinceandcity VALUES('4078','','Yumen','4012','3078');
INSERT INTO job_provinceandcity VALUES('4079','ػ','Dunhuang','4013','3079');
INSERT INTO job_provinceandcity VALUES('4080','','Suzhou','1073','3080');
INSERT INTO job_provinceandcity VALUES('4081','','Anxi','1073','3081');
INSERT INTO job_provinceandcity VALUES('4082','','Jinta','1073','3082');
INSERT INTO job_provinceandcity VALUES('4083','','Akesai','1073','3083');
INSERT INTO job_provinceandcity VALUES('4084','౱ɹ','Subei','1073','3084');
INSERT INTO job_provinceandcity VALUES('4085','','Hezuo','1070','3085');
INSERT INTO job_provinceandcity VALUES('4086','̶','Lintan','1070','3086');
INSERT INTO job_provinceandcity VALUES('4087','׿','Zhuoni','1070','3087');
INSERT INTO job_provinceandcity VALUES('4088','','Zhouqu','1070','3088');
INSERT INTO job_provinceandcity VALUES('4089','','Diebu','1070','3089');
INSERT INTO job_provinceandcity VALUES('4090','','Maqu','1070','3090');
INSERT INTO job_provinceandcity VALUES('4091','µ','Luqu','1070','3091');
INSERT INTO job_provinceandcity VALUES('4092','ĺ','Xiahe','1070','3092');
INSERT INTO job_provinceandcity VALUES('4093','','Linxia','1060','3093');
INSERT INTO job_provinceandcity VALUES('4094','','Linxia','1060','3094');
INSERT INTO job_provinceandcity VALUES('4095','','Kangle','1060','3095');
INSERT INTO job_provinceandcity VALUES('4096','','Yongjing','1060','3096');
INSERT INTO job_provinceandcity VALUES('4097','','Guanghe','1060','3097');
INSERT INTO job_provinceandcity VALUES('4098','','Hezheng','1060','3098');
INSERT INTO job_provinceandcity VALUES('4099','','Dongxiang','1060','3099');
INSERT INTO job_provinceandcity VALUES('4100','ʯɽ嶫','Jishishan','1060','3100');
INSERT INTO job_provinceandcity VALUES('4101','','Chengzhong','1251','3101');
INSERT INTO job_provinceandcity VALUES('4102','Ƕ','Chengdong','1251','3102');
INSERT INTO job_provinceandcity VALUES('4103','','Chengxi','1251','3103');
INSERT INTO job_provinceandcity VALUES('4104','Ǳ','Chengbei','1251','3104');
INSERT INTO job_provinceandcity VALUES('4105','Դ','Huangyuan','1251','3105');
INSERT INTO job_provinceandcity VALUES('4106','','Huangzhong','1251','3106');
INSERT INTO job_provinceandcity VALUES('4107','ͨ','Datong','1251','3107');
INSERT INTO job_provinceandcity VALUES('4108','ƽ','Pingan','1257','3108');
INSERT INTO job_provinceandcity VALUES('4109','ֶ','Ledu','1257','3109');
INSERT INTO job_provinceandcity VALUES('4110','ͻ','Minhe','1257','3110');
INSERT INTO job_provinceandcity VALUES('4111','','Huzhu','1257','3111');
INSERT INTO job_provinceandcity VALUES('4112','¡','Hualong','1257','3112');
INSERT INTO job_provinceandcity VALUES('4113','ѭ','Xunhua','1257','3113');
INSERT INTO job_provinceandcity VALUES('4114','','Haiyan','1256','3114');
INSERT INTO job_provinceandcity VALUES('4115','','Qilian','1256','3115');
INSERT INTO job_provinceandcity VALUES('4116','ղ','Gangcha','1256','3116');
INSERT INTO job_provinceandcity VALUES('4117','Դ','Menyuan','1256','3117');
INSERT INTO job_provinceandcity VALUES('4118','ͬ','Tongren','1258','3118');
INSERT INTO job_provinceandcity VALUES('4119','','Zeku','1258','3119');
INSERT INTO job_provinceandcity VALUES('4120','','Jianzha','1258','3120');
INSERT INTO job_provinceandcity VALUES('4121','ɹ','Henan','1258','3121');
INSERT INTO job_provinceandcity VALUES('4122','','Gonghe','1255','3122');
INSERT INTO job_provinceandcity VALUES('4123','ͬ','Tongde','1255','3123');
INSERT INTO job_provinceandcity VALUES('4124','','Guide','1255','3124');
INSERT INTO job_provinceandcity VALUES('4125','˺','Xinghai','1255','3125');
INSERT INTO job_provinceandcity VALUES('4126','','Guinan','1255','3126');
INSERT INTO job_provinceandcity VALUES('4127','','Maqin','1253','3127');
INSERT INTO job_provinceandcity VALUES('4128','','Banma','1253','3128');
INSERT INTO job_provinceandcity VALUES('4129','ʵ','Gande','1253','3129');
INSERT INTO job_provinceandcity VALUES('4130','','Dari','1253','3130');
INSERT INTO job_provinceandcity VALUES('4131','','Jiuzhi','1253','3131');
INSERT INTO job_provinceandcity VALUES('4132','','Maduo','1253','3132');
INSERT INTO job_provinceandcity VALUES('4133','','Yushu','1252','3133');
INSERT INTO job_provinceandcity VALUES('4134','Ӷ','Zaduo','1252','3134');
INSERT INTO job_provinceandcity VALUES('4135','ƶ','Chengduo','1252','3135');
INSERT INTO job_provinceandcity VALUES('4136','ζ','Zhiduo','1252','3136');
INSERT INTO job_provinceandcity VALUES('4137','ǫ','Nangqian','1252','3137');
INSERT INTO job_provinceandcity VALUES('4138','','Qumalai','1252','3138');
INSERT INTO job_provinceandcity VALUES('4139','','Delingha','1254','3139');
INSERT INTO job_provinceandcity VALUES('4140','ľ','Geermu','1254','3140');
INSERT INTO job_provinceandcity VALUES('4141','','Wulan','1254','3141');
INSERT INTO job_provinceandcity VALUES('4142','','Tianjun','1254','3142');
INSERT INTO job_provinceandcity VALUES('4143','','Dulan','1254','3143');
INSERT INTO job_provinceandcity VALUES('4144','','Xixia','1249','3144');
INSERT INTO job_provinceandcity VALUES('4145','','Jinfeng','1249','3145');
INSERT INTO job_provinceandcity VALUES('4146','','Xingqing','1249','3146');
INSERT INTO job_provinceandcity VALUES('4147','','Yongning','1249','3147');
INSERT INTO job_provinceandcity VALUES('4148','','Helan','1249','3148');
INSERT INTO job_provinceandcity VALUES('4149','','Dawukou','1247','3149');
INSERT INTO job_provinceandcity VALUES('4150','ũ','Huinong','1247','3150');
INSERT INTO job_provinceandcity VALUES('4151','ʯ̿','Shitanjing','1247','3151');
INSERT INTO job_provinceandcity VALUES('4152','ƽ','Pingluo','1247','3152');
INSERT INTO job_provinceandcity VALUES('4153','ͨ','Litong','1248','3153');
INSERT INTO job_provinceandcity VALUES('4154','ͭϿ','Qingtongxia','1248','3154');
INSERT INTO job_provinceandcity VALUES('4155','','Lingwu','1248','3155');
INSERT INTO job_provinceandcity VALUES('4156','ͬ','Tongxin','1248','3156');
INSERT INTO job_provinceandcity VALUES('4157','γ','Yanchi','1248','3157');
INSERT INTO job_provinceandcity VALUES('4158','','Zhongwei','1248','3158');
INSERT INTO job_provinceandcity VALUES('4159','','Zhongning','1248','3159');
INSERT INTO job_provinceandcity VALUES('4160','ԭ','Yuanzhou','1250','3160');
INSERT INTO job_provinceandcity VALUES('4161','ԭ','Haiyuan','1250','3161');
INSERT INTO job_provinceandcity VALUES('4162','','Xiji','1250','3162');
INSERT INTO job_provinceandcity VALUES('4163','¡','Longde','1250','3163');
INSERT INTO job_provinceandcity VALUES('4164','Դ','Jingyuan','1250','3164');
INSERT INTO job_provinceandcity VALUES('4165','','Pengyang','1250','3165');
INSERT INTO job_provinceandcity VALUES('4166','ɽ','Tianshan','1326','3166');
INSERT INTO job_provinceandcity VALUES('4167','ɳͿ','Shanongbake','1326','3167');
INSERT INTO job_provinceandcity VALUES('4168','','Xinshi','1326','3168');
INSERT INTO job_provinceandcity VALUES('4169','ˮĥ','Shuimogou','1326','3169');
INSERT INTO job_provinceandcity VALUES('4170','ͷͺ','Toutunhe','1326','3170');
INSERT INTO job_provinceandcity VALUES('4171','','Dabancheng','1326','3171');
INSERT INTO job_provinceandcity VALUES('4172','ɽ','Dongshan','1326','3172');
INSERT INTO job_provinceandcity VALUES('4173','³ľ','Mulumuqi','1326','3173');
INSERT INTO job_provinceandcity VALUES('4174','','Kelamayi','1335','3174');
INSERT INTO job_provinceandcity VALUES('4175','ɽ','Dushanzi','1335','3175');
INSERT INTO job_provinceandcity VALUES('4176','׼̲','Baijiantan','1335','3176');
INSERT INTO job_provinceandcity VALUES('4177','ڶ','Wuerhe','1335','3177');
INSERT INTO job_provinceandcity VALUES('4178','ʯ','Shihezi','1364','3178');
INSERT INTO job_provinceandcity VALUES('4179','','Alaer','1365','3179');
INSERT INTO job_provinceandcity VALUES('4180','ͼľ','Tumushuke','1366','3180');
INSERT INTO job_provinceandcity VALUES('4181','','Wujiaqu','1367','3181');
INSERT INTO job_provinceandcity VALUES('4182','³','Tulufan','1325','3182');
INSERT INTO job_provinceandcity VALUES('4183','пѷ','Tuokexun','1325','3183');
INSERT INTO job_provinceandcity VALUES('4184','۷','Shanshan','1325','3184');
INSERT INTO job_provinceandcity VALUES('4185','','Hami','1332','3185');
INSERT INTO job_provinceandcity VALUES('4186','','Yiwu','1332','3186');
INSERT INTO job_provinceandcity VALUES('4187','','Balikun','1332','3187');
INSERT INTO job_provinceandcity VALUES('4188','','Hetian','1333','3188');
INSERT INTO job_provinceandcity VALUES('4189','','Hetian','1333','3189');
INSERT INTO job_provinceandcity VALUES('4190','','Luopu','1333','3190');
INSERT INTO job_provinceandcity VALUES('4191','','Minfeng','1333','3191');
INSERT INTO job_provinceandcity VALUES('4192','Ƥɽ','Pishan','1333','3192');
INSERT INTO job_provinceandcity VALUES('4193','','Cele','1333','3193');
INSERT INTO job_provinceandcity VALUES('4194','','Yutian','1333','3194');
INSERT INTO job_provinceandcity VALUES('4195','ī','Moyu','1333','3195');
INSERT INTO job_provinceandcity VALUES('4196','','Akesu','1329','3196');
INSERT INTO job_provinceandcity VALUES('4197','','Wensu','1329','3197');
INSERT INTO job_provinceandcity VALUES('4198','ɳ','Shaya','1329','3198');
INSERT INTO job_provinceandcity VALUES('4199','ݳ','Baicheng','1329','3199');
INSERT INTO job_provinceandcity VALUES('4200','','Awati','1329','3200');
INSERT INTO job_provinceandcity VALUES('4201','⳵','Kuche','1329','3201');
INSERT INTO job_provinceandcity VALUES('4202','ƺ','Keping','1329','3202');
INSERT INTO job_provinceandcity VALUES('4203','º','Xinhe','1329','3203');
INSERT INTO job_provinceandcity VALUES('4204','ʲ','Wushi','1329','3204');
INSERT INTO job_provinceandcity VALUES('4205','ʲ','Kashi','1336','3205');
INSERT INTO job_provinceandcity VALUES('4206','ͳ','Bachu','1336','3206');
INSERT INTO job_provinceandcity VALUES('4207','','Zepu','1336','3207');
INSERT INTO job_provinceandcity VALUES('4208','٤ʦ','Jiashi','1336','3208');
INSERT INTO job_provinceandcity VALUES('4209','Ҷ','Yecheng','1336','3209');
INSERT INTO job_provinceandcity VALUES('4210','պ','Yuepuhu','1336','3210');
INSERT INTO job_provinceandcity VALUES('4211','','Shule','1336','3211');
INSERT INTO job_provinceandcity VALUES('4212','','Maigaiti','1336','3212');
INSERT INTO job_provinceandcity VALUES('4213','Ӣɳ','Yingjisha','1336','3213');
INSERT INTO job_provinceandcity VALUES('4214','ɯ','Shache','1336','3214');
INSERT INTO job_provinceandcity VALUES('4215','踽','Shufu','1336','3215');
INSERT INTO job_provinceandcity VALUES('4216','ʲ','Tashikuergantajike','1336','3216');
INSERT INTO job_provinceandcity VALUES('4217','ͼʲ','Atushi','1328','3217');
INSERT INTO job_provinceandcity VALUES('4218','','Aheqi','1328','3218');
INSERT INTO job_provinceandcity VALUES('4219','ǡ','Wuqia','1328','3219');
INSERT INTO job_provinceandcity VALUES('4220','','Aketao','1328','3220');
INSERT INTO job_provinceandcity VALUES('4221','','Kuerle','1334','3221');
INSERT INTO job_provinceandcity VALUES('4222',';','Hejing','1334','3222');
INSERT INTO job_provinceandcity VALUES('4223','ξ','Weili','1334','3223');
INSERT INTO job_provinceandcity VALUES('4224','˶','Heshuo','1334','3224');
INSERT INTO job_provinceandcity VALUES('4225','ĩ','Qiemo','1334','3225');
INSERT INTO job_provinceandcity VALUES('4226','','Bohu','1334','3226');
INSERT INTO job_provinceandcity VALUES('4227','̨','Luntai','1334','3227');
INSERT INTO job_provinceandcity VALUES('4228','Ǽ','Ruoqiang','1334','3228');
INSERT INTO job_provinceandcity VALUES('4229','Ȼ','Yanqi','1334','3229');
INSERT INTO job_provinceandcity VALUES('4230','','Changji','1330','3230');
INSERT INTO job_provinceandcity VALUES('4231','','Fukang','1330','3231');
INSERT INTO job_provinceandcity VALUES('4232','Ȫ','Miquan','1330','3232');
INSERT INTO job_provinceandcity VALUES('4233','̨','Qitai','1330','3233');
INSERT INTO job_provinceandcity VALUES('4234','˹','Manasi','1330','3234');
INSERT INTO job_provinceandcity VALUES('4235','ľ','Jimusaer','1330','3235');
INSERT INTO job_provinceandcity VALUES('4236','ͼ','Hutubi','1330','3236');
INSERT INTO job_provinceandcity VALUES('4237','ľݹ','Mulei','1330','3237');
INSERT INTO job_provinceandcity VALUES('4238','','Bole','1331','3238');
INSERT INTO job_provinceandcity VALUES('4239','','Jinghe','1331','3239');
INSERT INTO job_provinceandcity VALUES('4240','Ȫ','Wenquan','1331','3240');
INSERT INTO job_provinceandcity VALUES('4241','','Yining','1327','3241');
INSERT INTO job_provinceandcity VALUES('4242','','Kuitun','1327','3242');
INSERT INTO job_provinceandcity VALUES('4243','','Yining','1327','3243');
INSERT INTO job_provinceandcity VALUES('4244','ؿ˹','Tekesi','1327','3244');
INSERT INTO job_provinceandcity VALUES('4245','տ','Nileke','1327','3245');
INSERT INTO job_provinceandcity VALUES('4246','','Zhaosu','1327','3246');
INSERT INTO job_provinceandcity VALUES('4247','Դ','Xinyuan','1327','3247');
INSERT INTO job_provinceandcity VALUES('4248','','Huocheng','1327','3248');
INSERT INTO job_provinceandcity VALUES('4249','','Gongliu','1327','3249');
INSERT INTO job_provinceandcity VALUES('4250','첼','Chabuchaer','1327','3250');
INSERT INTO job_provinceandcity VALUES('4251','ǵ','Tacheng','1327','3251');
INSERT INTO job_provinceandcity VALUES('4252','̩','Aletai','1327','3252');
INSERT INTO job_provinceandcity VALUES('4253','','Hongkong','1373','3253');
INSERT INTO job_provinceandcity VALUES('4254','','Macao','1374','3254');
INSERT INTO job_provinceandcity VALUES('4255','̨','Taiwan','1375','3255');
INSERT INTO job_provinceandcity VALUES('4256','','Abroad','0','3256');
INSERT INTO job_provinceandcity VALUES('4261','۵','1','1031','3261');
INSERT INTO job_provinceandcity VALUES('4262','','2','1031','3262');
INSERT INTO job_provinceandcity VALUES('4263','½','3','1031','3263');
INSERT INTO job_provinceandcity VALUES('4264','','a','4263','3264');
INSERT INTO job_provinceandcity VALUES('4265','','b','4263','3265');
INSERT INTO job_provinceandcity VALUES('4266','','c','4263','3266');
INSERT INTO job_provinceandcity VALUES('4267','','c','4263','3267');
INSERT INTO job_provinceandcity VALUES('4271','','Aboard','4256','3271');
INSERT INTO job_provinceandcity VALUES('4272','','Aboard','4271','3272');
INSERT INTO job_provinceandcity VALUES('4273','','Macao','1032','3273');
INSERT INTO job_provinceandcity VALUES('4274','','Macao','4273','3274');
INSERT INTO job_provinceandcity VALUES('4275','̨','Taiwan','1033','3275');
INSERT INTO job_provinceandcity VALUES('4276','̨','Taiwan','4275','3276');

INSERT INTO job_siteconfig VALUES('1','Ե˲PHP2011','йԵ˲ְƸ','http://192.168.1.200','','','0,','','/images/logo.gif','default','default','gbk','Ե','web@finereason.com','վϢְߡƸɷ,{$FR_վ}еݵĺϷԼʵһͷ <br />ַ:{$FR_ϵַ} ͷ:{$FR_ϵ} 绰:{$FR_ϵ绰} :{$FR_ϵ}<br /> Copyright 2004-2011 FineReason.com Inc All Rights Reserved.<script src=\"/plus/count/mycount.php\"></script>','ְ Ƹ Ƹվ ´ ᱣ ˲ ǲ ˲վ  ͷ Դ ѵ ְ ְ ƶְ Ӣ  Ƹ ҵ ѧ Ƹ HRרѯ ְҵ ԱƸ ѧʵϰ  job career hire employee recruitment headhunting training HR zhaopinwang gongzuo','ְ Ƹ Ƹվ ´ ᱣ ˲ ǲ ˲վ  ͷ Դ ѵ ְ ְ ƶְ Ӣ  Ƹ ҵ ѧ Ƹ HRרѯ ְҵ ԱƸ ѧʵϰ  job career hire employee recruitment headhunting training HR zhaopinwang gongzuo','','/','admin','С','ʡ̫·5','400-6606-156','029-85460076ת600','0,ʱעᣬά,0,1,0,1','0,,0,0,0,1','0,,0,0,0,1','0,,0,0,0,1','','1','smtp.ym.163.com','25','1','service@91rencai.com','0','service@91rencai.com','houzhirong','1','','0','html/','20','html','0','12','0','0','1','1,1,1,1,1,1','1,1,1,1,0,1','/','','1','1');

INSERT INTO job_trade VALUES('1000','','Computer Software','1');
INSERT INTO job_trade VALUES('1001','Ӳ','Computer Hardware','2');
INSERT INTO job_trade VALUES('1002','(ϵͳݷά)','Computer Services','3');
INSERT INTO job_trade VALUES('1003','ͨ//豸','Communication/Telecom/Network Equipment','4');
INSERT INTO job_trade VALUES('1004','ͨ/Ӫֵ','Telecom Operators/Service Providers','5');
INSERT INTO job_trade VALUES('1005','/','Internet/E-commerce','6');
INSERT INTO job_trade VALUES('1006','Ϸ','Network Game','7');
INSERT INTO job_trade VALUES('1007','Ӽ/뵼/ɵ·','Electronic technology/semiconductor/integrated cir','8');
INSERT INTO job_trade VALUES('1008','Ǳ/ҵԶ','Instrumentation/industrial automation','9');
INSERT INTO job_trade VALUES('1009','/','Accounting/audit','10');
INSERT INTO job_trade VALUES('1010','/Ͷ/֤ȯ','Financial/investment/securities','11');
INSERT INTO job_trade VALUES('1011','','Bank','12');
INSERT INTO job_trade VALUES('1012','','Insurance','13');
INSERT INTO job_trade VALUES('1013','ó/','Trade/Import and export','14');
INSERT INTO job_trade VALUES('1014','/','Wholesale/retail','15');
INSERT INTO job_trade VALUES('1015','Ʒ(ʳƷ,,ױƷ)','Fast moving consumer goods (food,beverage,cosmet)','16');
INSERT INTO job_trade VALUES('1016','װ/֯/Ƥ','Dress/textile/leather','17');
INSERT INTO job_trade VALUES('1017','Ҿ/ҵ/Ʒ//鱦','Furniture/Homeappliance/Toys/jewelry','18');
INSERT INTO job_trade VALUES('1018','칫Ʒ豸','Office supplies and equipment','19');
INSERT INTO job_trade VALUES('1019','е/豸/ع','Machinery/Equipment/Heavy Industries','20');
INSERT INTO job_trade VALUES('1020','','Cars and spare parts','21');
INSERT INTO job_trade VALUES('1021','ҩ/﹤','Pharmaceuticals/Biotechnology','22');
INSERT INTO job_trade VALUES('1022','ҽ///','Healthcare/Medicine/Public Health','23');
INSERT INTO job_trade VALUES('1023','ҽ豸/е','Medical Facilities/Equipment','24');
INSERT INTO job_trade VALUES('1024','','Advertising','25');
INSERT INTO job_trade VALUES('1025','/гƹ/չ','Public Relations/Marketing/Exhibitions','26');
INSERT INTO job_trade VALUES('1026','Ӱ/ý/','Films/Media/Arts','27');
INSERT INTO job_trade VALUES('1027','ý/','Print Media/Publishing','28');
INSERT INTO job_trade VALUES('1028','ز','Real estate development','29');
INSERT INTO job_trade VALUES('1029','빤','Building and Engineering','30');
INSERT INTO job_trade VALUES('1030','Ҿ//װ','Interior Design/Decoration','31');
INSERT INTO job_trade VALUES('1031','ҵ/ҵ','Property Management','32');
INSERT INTO job_trade VALUES('1032','н','Intermediary services','33');
INSERT INTO job_trade VALUES('1033','רҵ(ѯԴ)','Professional service(Consulting,human resources)','34');
INSERT INTO job_trade VALUES('1034','','Outsourcing service','35');
INSERT INTO job_trade VALUES('1035','⣬֤','Testing,Certification','36');
INSERT INTO job_trade VALUES('1036','','Law','37');
INSERT INTO job_trade VALUES('1037','/ѵ','Education/Trainning','38');
INSERT INTO job_trade VALUES('1038','ѧ/','Academic/research','39');
INSERT INTO job_trade VALUES('1039','ҵ','Catering Industry','40');
INSERT INTO job_trade VALUES('1040','Ƶ/','Hospitality/Tourism','40');
INSERT INTO job_trade VALUES('1041','//','Entertainment/Leisure/Sports','41');
INSERT INTO job_trade VALUES('1042','/','Beauty/Health','42');
INSERT INTO job_trade VALUES('1043','','Life Services','43');
INSERT INTO job_trade VALUES('1044','ͨ//','Traffic/transportation/logistics','44');
INSERT INTO job_trade VALUES('1045','/','Aerospace/Aviation/Airlines','45');
INSERT INTO job_trade VALUES('1046','ʯ///','Oils/Chemicals/Mines/Geology','46');
INSERT INTO job_trade VALUES('1047','ɾҵ/ұ','Mining/smelting','47');
INSERT INTO job_trade VALUES('1048','/ˮ','Power/water conservancy','48');
INSERT INTO job_trade VALUES('1049','ԭϺͼӹ','Raw Materials &Processing','49');
INSERT INTO job_trade VALUES('1050','','Government','50');
INSERT INTO job_trade VALUES('1051','ӯ','Nonprofit organizations','51');
INSERT INTO job_trade VALUES('1052','','Environmental Protection','52');
INSERT INTO job_trade VALUES('1053','ũҵ/ҵ/ҵ','Agriculture','53');
INSERT INTO job_trade VALUES('1054','ԪҵŹ˾','Diversified business group company','54');
INSERT INTO job_trade VALUES('1055','ҵ','Other Trade','55');

INSERT INTO job_vote VALUES('43','˲Ͷݼ','0000-00-00','0000-00-00','','0','#000088','20','41');
INSERT INTO job_vote VALUES('44','ѡҹϵæ','0000-00-00','0000-00-00','','0','#8800FF','54','41');
INSERT INTO job_vote VALUES('45','μӸƸͶݼ','0000-00-00','0000-00-00','','0','#CCAA00','1','41');
INSERT INTO job_vote VALUES('42','ҵصнܹ','0000-00-00','0000-00-00','','0','#0088FF','18','41');
INSERT INTO job_vote VALUES('41','ʹַʽҹ','2010-07-18','2010-12-31','radio','1','','0','0');
