/*
 * Decompiled with CFR 0.152.
 */
package org.tautua.markdownpapers.ast;

import org.tautua.markdownpapers.ast.Node;
import org.tautua.markdownpapers.ast.Resource;
import org.tautua.markdownpapers.ast.ResourceReference;
import org.tautua.markdownpapers.ast.SimpleNode;
import org.tautua.markdownpapers.ast.Text;
import org.tautua.markdownpapers.ast.Visitor;
import org.tautua.markdownpapers.util.Utils;

public class Link
extends SimpleNode
implements ResourceReference {
    private boolean inline = false;
    private String reference;
    private Resource resource;
    private boolean whitespaceAtMiddle = false;

    public Link(int id) {
        super(id);
    }

    public String getText() {
        StringBuilder buff = new StringBuilder();
        for (Node child : this.children) {
            if (child instanceof Text) {
                String val = ((Text)child).getValue();
                if ("\n".equals(val)) {
                    if (' ' == buff.charAt(buff.length() - 1)) continue;
                    buff.append(" ");
                    continue;
                }
                buff.append(val);
                continue;
            }
            if (!(child instanceof Link)) continue;
            buff.append(((Link)child).getText());
        }
        return buff.toString();
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public Resource getResource() {
        if (this.resource == null) {
            this.resource = Utils.isBlank(this.reference) ? this.getDocument().findResource(this.getText()) : this.getDocument().findResource(this.reference);
        }
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.inline = true;
        this.resource = resource;
    }

    public boolean isReferenced() {
        return !this.inline;
    }

    public boolean hasWhitespaceAtMiddle() {
        return this.whitespaceAtMiddle;
    }

    public void setWhitespaceAtMiddle() {
        this.whitespaceAtMiddle = true;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

