/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.convert;

import com.google.appengine.repackaged.org.joda.time.JodaTimePermission;
import com.google.appengine.repackaged.org.joda.time.convert.CalendarConverter;
import com.google.appengine.repackaged.org.joda.time.convert.Converter;
import com.google.appengine.repackaged.org.joda.time.convert.ConverterSet;
import com.google.appengine.repackaged.org.joda.time.convert.DateConverter;
import com.google.appengine.repackaged.org.joda.time.convert.DurationConverter;
import com.google.appengine.repackaged.org.joda.time.convert.InstantConverter;
import com.google.appengine.repackaged.org.joda.time.convert.IntervalConverter;
import com.google.appengine.repackaged.org.joda.time.convert.LongConverter;
import com.google.appengine.repackaged.org.joda.time.convert.NullConverter;
import com.google.appengine.repackaged.org.joda.time.convert.PartialConverter;
import com.google.appengine.repackaged.org.joda.time.convert.PeriodConverter;
import com.google.appengine.repackaged.org.joda.time.convert.ReadableDurationConverter;
import com.google.appengine.repackaged.org.joda.time.convert.ReadableInstantConverter;
import com.google.appengine.repackaged.org.joda.time.convert.ReadableIntervalConverter;
import com.google.appengine.repackaged.org.joda.time.convert.ReadablePartialConverter;
import com.google.appengine.repackaged.org.joda.time.convert.ReadablePeriodConverter;
import com.google.appengine.repackaged.org.joda.time.convert.StringConverter;

public final class ConverterManager {
    private static ConverterManager INSTANCE;
    private ConverterSet iInstantConverters = new ConverterSet(new Converter[]{ReadableInstantConverter.INSTANCE, StringConverter.INSTANCE, CalendarConverter.INSTANCE, DateConverter.INSTANCE, LongConverter.INSTANCE, NullConverter.INSTANCE});
    private ConverterSet iPartialConverters = new ConverterSet(new Converter[]{ReadablePartialConverter.INSTANCE, ReadableInstantConverter.INSTANCE, StringConverter.INSTANCE, CalendarConverter.INSTANCE, DateConverter.INSTANCE, LongConverter.INSTANCE, NullConverter.INSTANCE});
    private ConverterSet iDurationConverters = new ConverterSet(new Converter[]{ReadableDurationConverter.INSTANCE, ReadableIntervalConverter.INSTANCE, StringConverter.INSTANCE, LongConverter.INSTANCE, NullConverter.INSTANCE});
    private ConverterSet iPeriodConverters = new ConverterSet(new Converter[]{ReadableDurationConverter.INSTANCE, ReadablePeriodConverter.INSTANCE, ReadableIntervalConverter.INSTANCE, StringConverter.INSTANCE, NullConverter.INSTANCE});
    private ConverterSet iIntervalConverters = new ConverterSet(new Converter[]{ReadableIntervalConverter.INSTANCE, StringConverter.INSTANCE, NullConverter.INSTANCE});

    public static ConverterManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConverterManager();
        }
        return INSTANCE;
    }

    protected ConverterManager() {
    }

    public InstantConverter getInstantConverter(Object object) {
        InstantConverter converter = (InstantConverter)this.iInstantConverters.select(object == null ? null : object.getClass());
        if (converter != null) {
            return converter;
        }
        throw new IllegalArgumentException("No instant converter found for type: " + (object == null ? "null" : object.getClass().getName()));
    }

    public InstantConverter[] getInstantConverters() {
        ConverterSet set = this.iInstantConverters;
        Converter[] converters = new InstantConverter[set.size()];
        set.copyInto(converters);
        return converters;
    }

    public InstantConverter addInstantConverter(InstantConverter converter) throws SecurityException {
        this.checkAlterInstantConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new InstantConverter[1];
        this.iInstantConverters = this.iInstantConverters.add(converter, removed);
        return removed[0];
    }

    public InstantConverter removeInstantConverter(InstantConverter converter) throws SecurityException {
        this.checkAlterInstantConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new InstantConverter[1];
        this.iInstantConverters = this.iInstantConverters.remove(converter, removed);
        return removed[0];
    }

    private void checkAlterInstantConverters() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("ConverterManager.alterInstantConverters"));
        }
    }

    public PartialConverter getPartialConverter(Object object) {
        PartialConverter converter = (PartialConverter)this.iPartialConverters.select(object == null ? null : object.getClass());
        if (converter != null) {
            return converter;
        }
        throw new IllegalArgumentException("No partial converter found for type: " + (object == null ? "null" : object.getClass().getName()));
    }

    public PartialConverter[] getPartialConverters() {
        ConverterSet set = this.iPartialConverters;
        Converter[] converters = new PartialConverter[set.size()];
        set.copyInto(converters);
        return converters;
    }

    public PartialConverter addPartialConverter(PartialConverter converter) throws SecurityException {
        this.checkAlterPartialConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new PartialConverter[1];
        this.iPartialConverters = this.iPartialConverters.add(converter, removed);
        return removed[0];
    }

    public PartialConverter removePartialConverter(PartialConverter converter) throws SecurityException {
        this.checkAlterPartialConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new PartialConverter[1];
        this.iPartialConverters = this.iPartialConverters.remove(converter, removed);
        return removed[0];
    }

    private void checkAlterPartialConverters() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("ConverterManager.alterPartialConverters"));
        }
    }

    public DurationConverter getDurationConverter(Object object) {
        DurationConverter converter = (DurationConverter)this.iDurationConverters.select(object == null ? null : object.getClass());
        if (converter != null) {
            return converter;
        }
        throw new IllegalArgumentException("No duration converter found for type: " + (object == null ? "null" : object.getClass().getName()));
    }

    public DurationConverter[] getDurationConverters() {
        ConverterSet set = this.iDurationConverters;
        Converter[] converters = new DurationConverter[set.size()];
        set.copyInto(converters);
        return converters;
    }

    public DurationConverter addDurationConverter(DurationConverter converter) throws SecurityException {
        this.checkAlterDurationConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new DurationConverter[1];
        this.iDurationConverters = this.iDurationConverters.add(converter, removed);
        return removed[0];
    }

    public DurationConverter removeDurationConverter(DurationConverter converter) throws SecurityException {
        this.checkAlterDurationConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new DurationConverter[1];
        this.iDurationConverters = this.iDurationConverters.remove(converter, removed);
        return removed[0];
    }

    private void checkAlterDurationConverters() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("ConverterManager.alterDurationConverters"));
        }
    }

    public PeriodConverter getPeriodConverter(Object object) {
        PeriodConverter converter = (PeriodConverter)this.iPeriodConverters.select(object == null ? null : object.getClass());
        if (converter != null) {
            return converter;
        }
        throw new IllegalArgumentException("No period converter found for type: " + (object == null ? "null" : object.getClass().getName()));
    }

    public PeriodConverter[] getPeriodConverters() {
        ConverterSet set = this.iPeriodConverters;
        Converter[] converters = new PeriodConverter[set.size()];
        set.copyInto(converters);
        return converters;
    }

    public PeriodConverter addPeriodConverter(PeriodConverter converter) throws SecurityException {
        this.checkAlterPeriodConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new PeriodConverter[1];
        this.iPeriodConverters = this.iPeriodConverters.add(converter, removed);
        return removed[0];
    }

    public PeriodConverter removePeriodConverter(PeriodConverter converter) throws SecurityException {
        this.checkAlterPeriodConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new PeriodConverter[1];
        this.iPeriodConverters = this.iPeriodConverters.remove(converter, removed);
        return removed[0];
    }

    private void checkAlterPeriodConverters() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("ConverterManager.alterPeriodConverters"));
        }
    }

    public IntervalConverter getIntervalConverter(Object object) {
        IntervalConverter converter = (IntervalConverter)this.iIntervalConverters.select(object == null ? null : object.getClass());
        if (converter != null) {
            return converter;
        }
        throw new IllegalArgumentException("No interval converter found for type: " + (object == null ? "null" : object.getClass().getName()));
    }

    public IntervalConverter[] getIntervalConverters() {
        ConverterSet set = this.iIntervalConverters;
        Converter[] converters = new IntervalConverter[set.size()];
        set.copyInto(converters);
        return converters;
    }

    public IntervalConverter addIntervalConverter(IntervalConverter converter) throws SecurityException {
        this.checkAlterIntervalConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new IntervalConverter[1];
        this.iIntervalConverters = this.iIntervalConverters.add(converter, removed);
        return removed[0];
    }

    public IntervalConverter removeIntervalConverter(IntervalConverter converter) throws SecurityException {
        this.checkAlterIntervalConverters();
        if (converter == null) {
            return null;
        }
        Converter[] removed = new IntervalConverter[1];
        this.iIntervalConverters = this.iIntervalConverters.remove(converter, removed);
        return removed[0];
    }

    private void checkAlterIntervalConverters() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("ConverterManager.alterIntervalConverters"));
        }
    }

    public String toString() {
        return "ConverterManager[" + this.iInstantConverters.size() + " instant," + this.iPartialConverters.size() + " partial," + this.iDurationConverters.size() + " duration," + this.iPeriodConverters.size() + " period," + this.iIntervalConverters.size() + " interval]";
    }
}

