/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.io.protocol.ExtensionTags;
import com.google.appengine.repackaged.com.google.io.protocol.Extensions;
import com.google.appengine.repackaged.com.google.io.protocol.LazyParsingExtension;
import com.google.appengine.repackaged.com.google.io.protocol.ProtoString;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.protobuf.Extension;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessage;
import com.google.appengine.repackaged.com.google.protobuf.WireFormat;
import java.util.List;

public abstract class ExtendableProtocolMessage<T extends ExtendableProtocolMessage<T>>
extends ProtocolMessage<T> {
    protected ExtensionTags uninterpreted;

    public final boolean hasExtension(Extension<T, ?> extension) {
        if (this.uninterpreted == null) {
            return false;
        }
        if (!this.uninterpreted.containsKey(Extensions.getWireTag(extension))) {
            return false;
        }
        if (extension.isRepeated()) {
            List value = (List)this.uninterpreted.get(Extensions.getWireTag(extension)).read(extension);
            return !value.isEmpty();
        }
        return true;
    }

    public final <Ex> Ex getExtension(Extension<T, Ex> extension) {
        if (this.uninterpreted == null) {
            return extension.getDefaultValue();
        }
        LazyParsingExtension ext = this.uninterpreted.get(Extensions.getWireTag(extension));
        if (ext == null) {
            return extension.getDefaultValue();
        }
        return (Ex)(extension.isRepeated() ? ProtocolSupport.unmodifiableList((List)ext.read(extension)) : ext.read(extension));
    }

    public final <Ex> Ex getMutableExtension(Extension<T, Ex> extension) {
        if (!extension.isRepeated() && extension.getLiteType() != WireFormat.FieldType.MESSAGE) {
            throw new UnsupportedOperationException("getMutableExtension() can only be applied to message or repeated extensions.");
        }
        this.getUninterpretedForWrite();
        int wireTag = Extensions.getWireTag(extension);
        LazyParsingExtension ext = this.uninterpreted.get(wireTag);
        if (ext == null) {
            ext = LazyParsingExtension.empty(extension);
            this.uninterpreted.putExtension(wireTag, ext);
        }
        return ext.read(extension);
    }

    public final <Ex> Ex getExtension(Extension<T, List<Ex>> extension, int index) {
        return this.getExtension(extension).get(index);
    }

    public final <Ex> int extensionSize(Extension<T, List<Ex>> extension) {
        return this.getExtension(extension).size();
    }

    public final <Ex> T setExtension(Extension<T, Ex> extension, Ex value) {
        this.getUninterpretedForWrite().putExtension(Extensions.getWireTag(extension), LazyParsingExtension.parsed(extension, value));
        return (T)this;
    }

    public final T setExtension(Extension<T, Integer> extension, ProtocolMessageEnum enumValue) {
        return this.setExtension(extension, enumValue.getValue());
    }

    public final T setExtension(Extension<T, ProtoString> extension, String value) {
        return this.setExtension(extension, new ProtoString(value));
    }

    public final T setExtension(Extension<T, ProtoString> extension, byte[] value) {
        return this.setExtension(extension, new ProtoString(value));
    }

    public final <Ex> T setExtension(Extension<T, List<Ex>> extension, int index, Ex value) {
        this.getUninterpretedForWrite();
        int wireTag = Extensions.getWireTag(extension);
        LazyParsingExtension ext = this.uninterpreted.get(wireTag);
        if (ext == null) {
            ext = LazyParsingExtension.empty(extension);
            this.uninterpreted.putExtension(wireTag, ext);
        }
        ext.read(extension).set(index, value);
        return (T)this;
    }

    public final T setExtension(Extension<T, List<Integer>> extension, int index, ProtocolMessageEnum enumValue) {
        return this.setExtension(extension, index, enumValue.getValue());
    }

    public final T setExtension(Extension<T, List<ProtoString>> extension, int index, String value) {
        return this.setExtension(extension, index, new ProtoString(value));
    }

    public final T setExtension(Extension<T, List<ProtoString>> extension, int index, byte[] value) {
        return this.setExtension(extension, index, new ProtoString(value));
    }

    public final <Ex> T addExtension(Extension<T, List<Ex>> extension, Ex value) {
        this.getUninterpretedForWrite();
        int wireTag = Extensions.getWireTag(extension);
        LazyParsingExtension ext = this.uninterpreted.get(wireTag);
        if (ext == null) {
            ext = LazyParsingExtension.empty(extension);
            this.uninterpreted.putExtension(wireTag, ext);
        }
        ext.read(extension).add(value);
        return (T)this;
    }

    public final T addExtension(Extension<T, List<Integer>> extension, ProtocolMessageEnum enumValue) {
        return this.addExtension(extension, enumValue.getValue());
    }

    public final T addExtension(Extension<T, List<ProtoString>> extension, String value) {
        return this.addExtension(extension, new ProtoString(value));
    }

    public final T addExtension(Extension<T, List<ProtoString>> extension, byte[] value) {
        return this.addExtension(extension, new ProtoString(value));
    }

    public final <Ex extends MutableMessage> Ex addExtension(Extension<T, List<Ex>> extension) {
        MutableMessage result = ((MutableMessage)extension.getMessageDefaultInstance()).newMessageForType();
        this.getUninterpretedForWrite();
        int wireTag = Extensions.getWireTag(extension);
        LazyParsingExtension ext = this.uninterpreted.get(wireTag);
        if (ext == null) {
            ext = LazyParsingExtension.empty(extension);
            this.uninterpreted.putExtension(wireTag, ext);
        }
        ext.read(extension).add(result);
        return (Ex)result;
    }

    public final <Ex> T clearExtension(Extension<T, Ex> extension) {
        if (this.uninterpreted != null) {
            this.getUninterpretedForWrite().remove(Extensions.getWireTag(extension));
        }
        return (T)this;
    }

    public final void makeReadAccessThreadSafe(Extension<T, ?> ... extensions) {
        ExtensionTags tags = this.getUninterpretedForWrite();
        for (Extension<T, ?> e : extensions) {
            LazyParsingExtension lpe = tags.get(Extensions.getWireTag(e));
            if (lpe == null) continue;
            lpe.read(e);
        }
    }

    protected abstract ExtensionTags getUninterpretedForWrite();
}

