/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.Nullable;

@GoogleInternal
@GwtCompatible
public abstract class Converter<A, B>
implements Function<A, B> {
    private static final Converter<?, ?> IDENTITY_CONVERTER = new IdentityConverter();

    protected Converter() {
    }

    @Nullable
    public final B convert(@Nullable A a) {
        return this.doForward(a);
    }

    @Nullable
    protected B nullableDoForward(@Nullable A a) {
        return a == null ? null : (B)Preconditions.checkNotNull(this.doForward(a), "You cannot convert non-null (%s) to null.", a);
    }

    protected B doForward(A a) {
        throw new AssertionError((Object)"You must override either doFoward or nullableDoForward");
    }

    @Nullable
    protected A nullableDoBackward(@Nullable B b) {
        return b == null ? null : (A)Preconditions.checkNotNull(this.doBackward(b), "You cannot convert non-null (%s) to null.", b);
    }

    protected A doBackward(B b) {
        throw new AssertionError((Object)"You must override either doBackward or nullableDoBackward");
    }

    @Override
    @Nullable
    public final B apply(@Nullable A a) {
        return this.convert(a);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return super.equals(object);
    }

    public Converter<B, A> reverse() {
        return new ReverseConverter(this);
    }

    @GoogleInternal
    public <C> Converter<A, C> compose(Converter<B, C> secondConverter) {
        return ConverterComposition.of(this, Preconditions.checkNotNull(secondConverter, "secondConverter"));
    }

    public Iterable<B> convertAll(final Iterable<? extends A> fromIterable) {
        Preconditions.checkNotNull(fromIterable, "fromIterable");
        return new Iterable<B>(){

            @Override
            public Iterator<B> iterator() {
                return new Iterator<B>(){
                    private final Iterator<? extends A> fromIterator;
                    {
                        this.fromIterator = fromIterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.fromIterator.hasNext();
                    }

                    @Override
                    public B next() {
                        return Converter.this.doForward(this.fromIterator.next());
                    }

                    @Override
                    public void remove() {
                        this.fromIterator.remove();
                    }
                };
            }
        };
    }

    public static <T> Converter<T, T> identity() {
        return IDENTITY_CONVERTER;
    }

    private static class IdentityConverter
    extends Converter<Object, Object> {
        private IdentityConverter() {
        }

        @Override
        public Object doForward(@Nullable Object a) {
            return a;
        }

        @Override
        public Object doBackward(@Nullable Object b) {
            return b;
        }

        @Override
        public Converter<Object, Object> reverse() {
            return this;
        }

        @Override
        public <C> Converter<Object, C> compose(Converter<Object, C> otherConverter) {
            return Preconditions.checkNotNull(otherConverter, "otherConverter");
        }

        @Override
        public Iterable<Object> convertAll(Iterable<?> fromIterable) {
            return Preconditions.checkNotNull(fromIterable, "fromIterable");
        }

        public String toString() {
            return "IdentityConverter";
        }
    }

    private static final class ConverterComposition<A, B, C>
    extends Converter<A, C> {
        final Converter<A, B> first;
        final Converter<B, C> second;

        ConverterComposition(Converter<A, B> first, Converter<B, C> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public C doForward(@Nullable A a) {
            return this.second.doForward(this.first.doForward(a));
        }

        @Override
        public A doBackward(@Nullable C c) {
            return this.first.doBackward(this.second.doBackward(c));
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof ConverterComposition && this.first.equals(((ConverterComposition)o).first) && this.second.equals(((ConverterComposition)o).second);
        }

        public int hashCode() {
            return 31 * this.first.hashCode() + this.second.hashCode();
        }

        public String toString() {
            return this.first + ".compose(" + this.second + ")";
        }

        static <A, B, C> Converter<A, C> of(Converter<A, B> first, Converter<B, C> second) {
            return second == IDENTITY_CONVERTER ? first : new ConverterComposition<A, B, C>(first, second);
        }
    }

    private static final class ReverseConverter<A, B>
    extends Converter<B, A> {
        final Converter<A, B> original;

        ReverseConverter(Converter<A, B> original) {
            this.original = original;
        }

        @Override
        public A doForward(@Nullable B b) {
            return this.original.doBackward(b);
        }

        @Override
        public A nullableDoForward(@Nullable B b) {
            return this.original.nullableDoBackward(b);
        }

        @Override
        public B doBackward(@Nullable A a) {
            return this.original.doForward(a);
        }

        @Override
        public B nullableDoBackward(@Nullable A a) {
            return this.original.nullableDoForward(a);
        }

        @Override
        public Converter<A, B> reverse() {
            return this.original;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof ReverseConverter && this.original.equals(((ReverseConverter)o).original);
        }

        public int hashCode() {
            return ~this.original.hashCode();
        }

        public String toString() {
            return "ReverseConverter(" + this.original + ")";
        }
    }
}

