/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.checkers.IndexChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.api.AppEngineInternal;
import com.google.apphosting.api.search.DocumentPb;
import java.util.HashSet;

@AppEngineInternal
public final class DocumentChecker {
    private static final long MILLIS_UP_TO_1ST_JAN_2011 = 1293840000000L;

    public static String checkDocumentId(String documentId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(documentId), "Document id is null or empty");
        Preconditions.checkArgument(documentId.length() <= 500, "Document id is longer than %d: %s", 500, documentId);
        Preconditions.checkArgument(IndexChecker.isAsciiVisiblePrintable(documentId), "Document id must be ASCII visible printable: %s", documentId);
        Preconditions.checkArgument(!IndexChecker.isReserved(documentId), "Document id must not start with !: %s", documentId);
        return documentId;
    }

    public static void checkFieldSet(DocumentPb.Document document) {
        HashSet<String> noRepeatNames = Sets.newHashSet();
        for (DocumentPb.Field field : document.getFieldList()) {
            if (field.getValue().getType() != DocumentPb.FieldValue.ContentType.NUMBER && field.getValue().getType() != DocumentPb.FieldValue.ContentType.DATE) continue;
            if (noRepeatNames.contains(field.getName())) {
                throw new IllegalArgumentException("Invalid document " + document.getId() + ": field " + field.getName() + "with type date or number may not be repeated.");
            }
            noRepeatNames.add(field.getName());
        }
    }

    public static DocumentPb.Document checkValid(DocumentPb.Document pb) {
        Preconditions.checkArgument(pb.getSerializedSize() <= 0x100000, "Document length %d is greater than the maximum %d bytes", pb.getSerializedSize(), 0x100000);
        if (pb.hasId()) {
            DocumentChecker.checkDocumentId(pb.getId());
        }
        DocumentChecker.mandatoryCheckValid(pb);
        return pb;
    }

    static void mandatoryCheckValid(DocumentPb.Document pb) {
        Preconditions.checkArgument(!pb.getFieldList().isEmpty(), "Empty list of fields in document for indexing");
        DocumentChecker.checkFieldSet(pb);
    }

    public static int getNumberOfSecondsSince() {
        long millisSince = Math.max(0L, (System.currentTimeMillis() - 1293840000000L) / 1000L);
        Preconditions.checkArgument(millisSince <= Integer.MAX_VALUE, "API failure due to date conversion overflow");
        return (int)millisSince;
    }
}

