/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.b3log.latke.Latkes;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.LangPropsServiceImpl;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.util.Locales;
import org.b3log.latke.util.Stopwatchs;
import org.b3log.latke.util.freemarker.Templates;
import org.b3log.solo.SoloServletListener;

public final class Skins {
    private static final Logger LOGGER = Logger.getLogger((String)Skins.class.getName());
    private static final Map<String, Map<String, String>> LANG_MAP = new HashMap<String, Map<String, String>>();

    private Skins() {
    }

    public static void fillLangs(String localeString, String currentSkinDirName, Map<String, Object> dataModel) throws ServiceException {
        Stopwatchs.start((String)"Fill Skin Langs");
        try {
            String langName = currentSkinDirName + "." + localeString;
            Map<String, String> langs = LANG_MAP.get(langName);
            if (null == langs) {
                LANG_MAP.clear();
                LOGGER.log(Level.INFO, "Loading skin [dirName={0}, locale={1}]", new Object[]{currentSkinDirName, localeString});
                langs = new HashMap<String, String>();
                String language = Locales.getLanguage((String)localeString);
                String country = Locales.getCountry((String)localeString);
                ServletContext servletContext = SoloServletListener.getServletContext();
                InputStream inputStream = servletContext.getResourceAsStream("/skins/" + currentSkinDirName + "/lang/lang_" + language + '_' + country + ".properties");
                Properties props = new Properties();
                props.load(inputStream);
                Set<Object> keys = props.keySet();
                for (Object key : keys) {
                    langs.put((String)key, props.getProperty((String)key));
                }
                LANG_MAP.put(langName, langs);
                LOGGER.log(Level.INFO, "Loaded skin[dirName={0}, locale={1}, keyCount={2}]", new Object[]{currentSkinDirName, localeString, langs.size()});
            }
            dataModel.putAll(langs);
            LatkeBeanManager beanManager = Lifecycle.getBeanManager();
            LangPropsService langPropsService = (LangPropsService)beanManager.getReference(LangPropsServiceImpl.class);
            dataModel.putAll(langPropsService.getAll(Latkes.getLocale()));
        }
        catch (IOException e) {
            LOGGER.log(Level.ERROR, "Fills skin langs failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }

    public static void setDirectoryForTemplateLoading(String skinDirName) {
        ServletContext servletContext = SoloServletListener.getServletContext();
        Templates.MAIN_CFG.setServletContextForTemplateLoading((Object)servletContext, "/skins/" + skinDirName);
        Templates.MOBILE_CFG.setServletContextForTemplateLoading((Object)servletContext, "/skins/mobile");
    }

    public static Set<String> getSkinDirNames() {
        ServletContext servletContext = SoloServletListener.getServletContext();
        HashSet<String> ret = new HashSet<String>();
        Set resourcePaths = servletContext.getResourcePaths("/skins");
        for (String path : resourcePaths) {
            if (path.startsWith(".")) continue;
            ret.add(path.substring("/skins".length() + 1, path.length() - 1));
        }
        return ret;
    }
}

