/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.solo.repository.TagRepository;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class TagQueryService {
    private static final Logger LOGGER = Logger.getLogger((String)TagQueryService.class.getName());
    @Inject
    private TagRepository tagRepository;

    public JSONObject getTagByTitle(String tagTitle) throws ServiceException {
        try {
            JSONObject ret = new JSONObject();
            JSONObject tag = this.tagRepository.getByTitle(tagTitle);
            if (null == tag) {
                return null;
            }
            ret.put("tag", (Object)tag);
            LOGGER.log(Level.DEBUG, "Got an tag[title={0}]", new Object[]{tagTitle});
            return ret;
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets an article failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public long getTagCount() throws ServiceException {
        try {
            return this.tagRepository.count();
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets tags failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public List<JSONObject> getTags() throws ServiceException {
        try {
            Query query = new Query().setPageCount(1);
            JSONObject result = this.tagRepository.get(query);
            JSONArray tagArray = result.optJSONArray("rslts");
            return CollectionUtils.jsonArrayToList((JSONArray)tagArray);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets tags failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void removeForUnpublishedArticles(List<JSONObject> tags) throws JSONException, RepositoryException {
        Iterator<JSONObject> iterator = tags.iterator();
        while (iterator.hasNext()) {
            JSONObject tag = iterator.next();
            if (0 != tag.getInt("tagPublishedRefCount")) continue;
            iterator.remove();
        }
    }

    public void setTagRepository(TagRepository tagRepository) {
        this.tagRepository = tagRepository;
    }
}

