/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import javax.inject.Inject;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.solo.repository.StatisticRepository;
import org.b3log.solo.service.StatisticMgmtService;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class StatisticQueryService {
    private static final Logger LOGGER = Logger.getLogger((String)StatisticQueryService.class.getName());
    @Inject
    private StatisticRepository statisticRepository;

    public static int getOnlineVisitorCount() {
        return StatisticMgmtService.ONLINE_VISITORS.size();
    }

    public int getBlogCommentCount() throws JSONException, RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        return statistic.getInt("statisticBlogCommentCount");
    }

    public int getPublishedBlogCommentCount() throws JSONException, RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        return statistic.getInt("statisticPublishedBlogCommentCount");
    }

    public int getPublishedBlogArticleCount() throws JSONException, RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        return statistic.getInt("statisticPublishedBlogArticleCount");
    }

    public int getBlogArticleCount() throws JSONException, RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        return statistic.getInt("statisticBlogArticleCount");
    }

    public JSONObject getStatistic() throws ServiceException {
        try {
            JSONObject ret = this.statisticRepository.get("statistic");
            if (null == ret) {
                LOGGER.log(Level.WARN, "Can not load statistic from repository", new Object[0]);
                return null;
            }
            return ret;
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public void setStatisticRepository(StatisticRepository statisticRepository) {
        this.statisticRepository = statisticRepository;
    }
}

