/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import javax.inject.Inject;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.solo.repository.PreferenceRepository;
import org.json.JSONObject;

@Service
public class PreferenceQueryService {
    private static final Logger LOGGER = Logger.getLogger((String)PreferenceQueryService.class.getName());
    @Inject
    private PreferenceRepository preferenceRepository;

    public JSONObject getReplyNotificationTemplate() throws ServiceException {
        try {
            return this.preferenceRepository.get("replyNotificationTemplate");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Updates reply notification template failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public JSONObject getPreference() throws ServiceException {
        try {
            JSONObject ret = this.preferenceRepository.get("preference");
            if (null == ret) {
                LOGGER.log(Level.WARN, "Can not load preference from datastore", new Object[0]);
                return null;
            }
            return ret;
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public void setPreferenceRepository(PreferenceRepository preferenceRepository) {
        this.preferenceRepository = preferenceRepository;
    }
}

