/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.plugin.AbstractPlugin;
import org.b3log.latke.plugin.PluginManager;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.Paginator;
import org.b3log.solo.repository.PluginRepository;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class PluginQueryService {
    private static final Logger LOGGER = Logger.getLogger((String)PluginQueryService.class.getName());
    @Inject
    private PluginRepository pluginRepository;
    @Inject
    private PluginManager pluginManager;

    public JSONObject getPlugins(JSONObject requestJSONObject) throws ServiceException {
        JSONObject ret = new JSONObject();
        try {
            int currentPageNum = requestJSONObject.getInt("paginationCurrentPageNum");
            int pageSize = requestJSONObject.getInt("paginationPageSize");
            int windowSize = requestJSONObject.getInt("paginationWindowSize");
            ArrayList<JSONObject> pluginJSONObjects = new ArrayList<JSONObject>();
            List plugins = this.pluginManager.getPlugins();
            for (AbstractPlugin plugin : plugins) {
                JSONObject jsonObject = plugin.toJSONObject();
                pluginJSONObjects.add(jsonObject);
            }
            int pageCount = (int)Math.ceil((double)pluginJSONObjects.size() / (double)pageSize);
            JSONObject pagination = new JSONObject();
            ret.put("pagination", (Object)pagination);
            List pageNums = Paginator.paginate((int)currentPageNum, (int)pageSize, (int)pageCount, (int)windowSize);
            pagination.put("paginationPageCount", pageCount);
            pagination.put("paginationPageNums", (Collection)pageNums);
            int start = pageSize * (currentPageNum - 1);
            int end = start + pageSize;
            end = end > pluginJSONObjects.size() ? pluginJSONObjects.size() : end;
            ret.put("plugins", pluginJSONObjects.subList(start, end));
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets plugins failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public String getPluginSetting(String pluginId) throws ServiceException, JSONException {
        JSONObject ret = null;
        try {
            ret = this.pluginRepository.get(pluginId);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "get plugin[" + pluginId + "] fail", new Object[0]);
            throw new ServiceException("get plugin[" + pluginId + "] fail");
        }
        if (ret == null) {
            LOGGER.log(Level.ERROR, "can not find plugin[" + pluginId + "]", new Object[0]);
            throw new ServiceException("can not find plugin[" + pluginId + "]");
        }
        return ret.optString("setting");
    }

    public void setPluginRepository(PluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }
}

