/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.plugin.AbstractPlugin;
import org.b3log.latke.plugin.PluginManager;
import org.b3log.latke.plugin.PluginStatus;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.solo.repository.PluginRepository;
import org.b3log.solo.service.InitService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class PluginMgmtService {
    private static final Logger LOGGER = Logger.getLogger((String)PluginMgmtService.class.getName());
    @Inject
    private PluginRepository pluginRepository;
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private InitService initService;
    @Inject
    private PluginManager pluginManager;

    public void refresh(List<AbstractPlugin> plugins) throws Exception {
        if (!this.initService.isInited()) {
            return;
        }
        JSONObject result = this.pluginRepository.get(new Query());
        JSONArray pluginArray = result.getJSONArray("rslts");
        List persistedPlugins = CollectionUtils.jsonArrayToList((JSONArray)pluginArray);
        try {
            for (JSONObject oldPluginDesc : persistedPlugins) {
                String descId = oldPluginDesc.getString(Keys.OBJECT_ID);
                AbstractPlugin plugin = this.get(plugins, descId);
                this.pluginRepository.remove(descId);
                if (null == plugin) continue;
                String status = oldPluginDesc.getString("status");
                String setting = oldPluginDesc.optString("setting");
                plugin.setStatus(PluginStatus.valueOf((String)status));
                try {
                    if (!StringUtils.isNotBlank((String)setting)) continue;
                    plugin.setSetting(new JSONObject(setting));
                }
                catch (JSONException e) {
                    LOGGER.log(Level.WARN, "the formatter of the old config failed to convert to json", (Throwable)e);
                }
            }
            for (AbstractPlugin plugin : plugins) {
                JSONObject pluginDesc = plugin.toJSONObject();
                this.pluginRepository.add(pluginDesc);
                LOGGER.log(Level.TRACE, "Refreshed plugin[{0}]", new Object[]{pluginDesc});
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Refresh plugins failed", (Throwable)e);
        }
    }

    private AbstractPlugin get(List<AbstractPlugin> plugins, String id) {
        if (null == id) {
            throw new IllegalArgumentException("id must not be null");
        }
        for (AbstractPlugin plugin : plugins) {
            if (!id.equals(plugin.getId())) continue;
            return plugin;
        }
        return null;
    }

    public JSONObject setPluginStatus(String pluginId, String status) {
        Map langs = this.langPropsService.getAll(Latkes.getLocale());
        List plugins = this.pluginManager.getPlugins();
        JSONObject ret = new JSONObject();
        for (AbstractPlugin plugin : plugins) {
            if (!plugin.getId().equals(pluginId)) continue;
            Transaction transaction = this.pluginRepository.beginTransaction();
            try {
                plugin.setStatus(PluginStatus.valueOf((String)status));
                this.pluginRepository.update(pluginId, plugin.toJSONObject());
                transaction.commit();
                plugin.changeStatus();
                ret.put("sc", true);
                ret.put("msg", langs.get("setSuccLabel"));
                return ret;
            }
            catch (Exception e) {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                LOGGER.log(Level.ERROR, "Set plugin status error", (Throwable)e);
                ret.put("sc", false);
                ret.put("msg", langs.get("setFailLabel"));
                return ret;
            }
        }
        ret.put("sc", false);
        ret.put("msg", langs.get("refreshAndRetryLabel"));
        return ret;
    }

    public JSONObject updatePluginSetting(String pluginId, String setting) {
        Map langs = this.langPropsService.getAll(Latkes.getLocale());
        List plugins = this.pluginManager.getPlugins();
        JSONObject ret = new JSONObject();
        for (AbstractPlugin plugin : plugins) {
            if (!plugin.getId().equals(pluginId)) continue;
            Transaction transaction = this.pluginRepository.beginTransaction();
            try {
                JSONObject pluginJson = plugin.toJSONObject();
                pluginJson.put("setting", (Object)setting);
                this.pluginRepository.update(pluginId, pluginJson);
                transaction.commit();
                ret.put("sc", true);
                ret.put("msg", langs.get("setSuccLabel"));
                return ret;
            }
            catch (Exception e) {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                LOGGER.log(Level.ERROR, "Set plugin status error", (Throwable)e);
                ret.put("sc", false);
                ret.put("msg", langs.get("setFailLabel"));
                return ret;
            }
        }
        ret.put("sc", false);
        ret.put("msg", langs.get("refreshAndRetryLabel"));
        return ret;
    }

    public void setPluginRepository(PluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public void setLangPropsService(LangPropsService langPropsService) {
        this.langPropsService = langPropsService;
    }
}

