/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import javax.inject.Inject;
import org.b3log.latke.Keys;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.solo.repository.OptionRepository;
import org.json.JSONArray;
import org.json.JSONObject;

@Service
public class OptionQueryService {
    @Inject
    private OptionRepository optionRepository;

    public JSONObject getOptionById(String optionId) throws ServiceException {
        try {
            return this.optionRepository.get(optionId);
        }
        catch (RepositoryException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JSONObject getOptions(String category) throws ServiceException {
        Query query = new Query();
        query.setFilter((Filter)new PropertyFilter("optionCategory", FilterOperator.EQUAL, (Object)category));
        try {
            JSONObject result = this.optionRepository.get(query);
            JSONArray options = result.getJSONArray("rslts");
            if (0 == options.length()) {
                return null;
            }
            JSONObject ret = new JSONObject();
            for (int i = 0; i < options.length(); ++i) {
                JSONObject option = options.getJSONObject(i);
                ret.put(option.getString(Keys.OBJECT_ID), (Object)option.getString("optionValue"));
            }
            return ret;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void setOptionRepository(OptionRepository optionRepository) {
        this.optionRepository = optionRepository;
    }
}

