/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import javax.inject.Inject;
import org.b3log.latke.Keys;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.Strings;
import org.b3log.solo.repository.OptionRepository;
import org.json.JSONObject;

@Service
public class OptionMgmtService {
    @Inject
    private OptionRepository optionRepository;

    public String addOrUpdateOption(JSONObject option) throws ServiceException {
        Transaction transaction = this.optionRepository.beginTransaction();
        try {
            String id = option.optString(Keys.OBJECT_ID);
            if (Strings.isEmptyOrNull((String)id)) {
                id = this.optionRepository.add(option);
            } else {
                JSONObject old = this.optionRepository.get(id);
                if (null == old) {
                    id = this.optionRepository.add(option);
                } else {
                    old.put("optionCategory", (Object)option.optString("optionCategory"));
                    old.put("optionValue", (Object)option.optString("optionValue"));
                    this.optionRepository.update(id, old);
                }
            }
            transaction.commit();
            return id;
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new ServiceException((Throwable)e);
        }
    }

    public void removeOption(String optionId) throws ServiceException {
        Transaction transaction = this.optionRepository.beginTransaction();
        try {
            this.optionRepository.remove(optionId);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new ServiceException((Throwable)e);
        }
    }

    public void setOptionRepository(OptionRepository optionRepository) {
        this.optionRepository = optionRepository;
    }
}

